/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import ro.amiq.dvt.linter.ui.ILinterReportInput;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.linter.launch.LintConfigurationContainer;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;

public class OVMComplianceReportInput
implements ILinterReportInput {
    final LintConfigurationContainer fConfiguration;
    private boolean fLintingCanceled = false;

    public OVMComplianceReportInput(LintConfigurationContainer configuration) {
        this.fConfiguration = configuration;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        RulesetKind rulesetKind = this.fConfiguration.getRulesetKind();
        if (rulesetKind == RulesetKind.SV_OVM_COMPLIANCE) {
            return DVTImages.OVM_LINTER_ICON;
        }
        if (rulesetKind == RulesetKind.SV_UVM_COMPLIANCE) {
            return DVTImages.UVM_LINTER_ICON;
        }
        return DVTImages.IMG_LINTER;
    }

    public String getName() {
        return this.fConfiguration.getRulesetKind().toString();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public IProject getProject() {
        return this.fConfiguration.getProject();
    }

    public void setLintingCanceled(boolean lintingCanceled) {
        this.fLintingCanceled = lintingCanceled;
    }

    public boolean isLintingCanceled() {
        return this.fLintingCanceled;
    }

    public LintConfigurationContainer getConfiguration() {
        return this.fConfiguration;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fConfiguration == null ? 0 : this.fConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OVMComplianceReportInput)) {
            return false;
        }
        OVMComplianceReportInput other = (OVMComplianceReportInput)obj;
        return !(this.fConfiguration == null ? other.fConfiguration != null : !this.fConfiguration.equals(other.fConfiguration));
    }

    public Object getAdapter(Class adapter) {
        IProject project = this.getProject();
        if (project != null) {
            if (IResource.class.equals((Object)adapter)) {
                return project;
            }
            if (IFile.class.equals((Object)adapter)) {
                IFile file = project.getFile(".project");
                if (file.isAccessible()) {
                    return file;
                }
                return project;
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

