/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReport;

public class ShowCheckAction
implements IViewActionDelegate {
    private String fCheckName;
    private String fProjectName;
    OVMComplianceCheckHit fCheckHit;

    public void run(IAction action) {
        ShowCheckAction.doShowCheck(this.fCheckName, this.fProjectName, this.fCheckHit);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            action.setEnabled(false);
            if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
                return;
            }
            Object element = ((StructuredSelection)selection).getFirstElement();
            if (!(element instanceof IAdaptable)) {
                return;
            }
            Object adapter = ((IAdaptable)element).getAdapter(IMarker.class);
            if (!(adapter instanceof IMarker)) {
                return;
            }
            IMarker marker = (IMarker)adapter;
            this.fCheckName = marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.CheckNameAttribute", null);
            this.fProjectName = marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.ProjectNameAttribute", null);
            this.fCheckHit = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
            if (this.fCheckName == null || this.fProjectName == null || this.fCheckHit == null) {
                return;
            }
            action.setEnabled(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void init(IViewPart view) {
    }

    public static void doShowCheck(String checkName, String projectName, OVMComplianceCheckHit checkHit) {
        if (checkName == null || projectName == null || checkHit == null) {
            return;
        }
        OVMProject ovmProject = checkHit.getCheck().getOVMProject();
        if (ovmProject.lintProject() && !ovmProject.isStartedFromBuildConfig()) {
            ShowCheckAction.showCheckInReport(checkName, projectName, checkHit);
        } else {
            OVMComplianceCheck check = checkHit.getCheck();
            String fix = VerissimoAutofixUtils.getInstance().hasAutofixImplemented(check) ? " [Fix]" : "";
            ShowCheckAction.showCheckDescriptionDialog(String.valueOf(check.getName()) + ": " + check.getTitle() + fix, check.getCheckDescriptionToPrint());
        }
    }

    private static void showCheckDescriptionDialog(String title, String description) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> new Utils.MoreMessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title == null ? "" : title, MessageDialog.getDefaultImage(), null, 0, new String[]{"Close"}, 0, title, description, 800, 500).open());
    }

    protected static void showCheckInReport(String checkName, String projectName, OVMComplianceCheckHit checkHit) {
        HashMap projectsMap = new HashMap();
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            IEditorReference[] references;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IEditorReference[] iEditorReferenceArray = references = workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference reference = iEditorReferenceArray[n2];
                IEditorPart editor = reference.getEditor(false);
                if (editor != null && editor instanceof OVMComplianceReport) {
                    projectsMap.put(((OVMComplianceReport)editor).getProject().getName(), (OVMComplianceReport)editor);
                }
                ++n2;
            }
        });
        if (projectsMap.isEmpty() || !projectsMap.containsKey(projectName)) {
            new MessageDialog(Utils.getActiveShell(), "Internal Error", null, "An internal error has occurd: there is no active Verilog linting session. Please perform the linting operation again for this project.", 1, new String[]{"OK"}, 0).open();
            return;
        }
        ((OVMComplianceReport)projectsMap.get(projectName)).showCheck(checkName, checkHit);
    }
}

