/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class TagWidget
extends Canvas {
    private String text = "";
    private int horizontalMargin = 6;
    private int verticalMargin = 3;
    private int arcWidth = 5;
    private int arcHeight = 5;

    public TagWidget(Composite parent, int style) {
        super(parent, style | 0x100000);
        this.addPaintListener(x -> this.paintControl(x));
    }

    void paintControl(PaintEvent event) {
        Point rectangle = this.getSize();
        Color blueLightColor = DVTColorUtil.INSTANCE.getColor(116, 235, 213);
        Color blueDarkColor = DVTColorUtil.INSTANCE.getColor(172, 182, 229);
        event.gc.setForeground(blueLightColor);
        event.gc.setBackground(blueDarkColor);
        event.gc.fillGradientRectangle(this.horizontalMargin, this.verticalMargin, rectangle.x - 2 * this.horizontalMargin - 1, rectangle.y - 2 * this.verticalMargin - 1, false);
        event.gc.drawRoundRectangle(this.horizontalMargin, this.verticalMargin, rectangle.x - 2 * this.horizontalMargin - 1, rectangle.y - 2 * this.verticalMargin - 1, this.arcWidth, this.arcHeight);
        event.gc.setFont(this.getFont());
        Color blackColor = DVTColorUtil.INSTANCE.getColor(0, 0, 0);
        event.gc.setForeground(blackColor);
        event.gc.drawText(this.text, 2 * this.horizontalMargin, 2 * this.verticalMargin, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        Point pt = gc.stringExtent(this.text);
        gc.dispose();
        return new Point(pt.x + 4 * this.horizontalMargin, pt.y + 4 * this.verticalMargin);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }
}

