/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.Patch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ro.amiq.dvt.utils.PathMapper;

public class VerissimoDiffer {
    protected Map<String, Patch<String>> patchesByFile = new HashMap<String, Patch<String>>();
    protected Map<String, TreeMap<Integer, Range>> rangeMappingInFileByLine = new HashMap<String, TreeMap<Integer, Range>>();
    protected PathMapper.Result mappingResult;
    protected boolean isReverseDiffer;

    public VerissimoDiffer(PathMapper.Result mappingResult, boolean isReverseDiffer) {
        this.mappingResult = mappingResult;
        this.isReverseDiffer = isReverseDiffer;
    }

    public Patch<String> computeFilePatch(String file, List<String> fileContent1, List<String> fileContent2) {
        Patch patch = this.patchesByFile.get(file);
        if (patch != null) {
            return patch;
        }
        patch = DiffUtils.diff(fileContent1, fileContent2);
        this.patchesByFile.put(file, (Patch<String>)patch);
        return patch;
    }

    public boolean areFilesEqual(String file1, String file2) {
        if (file1 == null || file2 == null) {
            return false;
        }
        if (!this.isReverseDiffer) {
            return file1.equals(this.mappingResult.getA(file2));
        }
        return file1.equals(this.mappingResult.getB(file2));
    }

    public String getMappedFile(String file) {
        return !this.isReverseDiffer ? this.mappingResult.getB(file) : this.mappingResult.getA(file);
    }

    public Range computeLineMapping(String file, int line) {
        return this.computeLineMapping(file, line, true);
    }

    public Range computeLineMapping(String file, int line, boolean fromSource) {
        if (!this.patchesByFile.containsKey(file)) {
            return new Range(line, line);
        }
        int linesDifference = 0;
        List deltas = this.patchesByFile.get(file).getDeltas();
        TreeMap<Integer, Range> rangeMappingByLine = this.rangeMappingInFileByLine.get(file);
        if (rangeMappingByLine == null) {
            rangeMappingByLine = new TreeMap();
            int i = 0;
            while (i < deltas.size()) {
                AbstractDelta delta = (AbstractDelta)deltas.get(i);
                Chunk<String> chunk = this.getDeltaContent((AbstractDelta<String>)delta, fromSource);
                if (line >= chunk.getPosition() && line <= chunk.getPosition() + chunk.size()) {
                    Range linesRange = this.updateRangeMappingByLine(line, rangeMappingByLine, (AbstractDelta<String>)delta, fromSource);
                    this.rangeMappingInFileByLine.put(file, rangeMappingByLine);
                    return linesRange;
                }
                if (chunk.getPosition() + chunk.size() < line) {
                    linesDifference = this.updateLineDifference(line, linesDifference, (AbstractDelta<String>)delta, fromSource);
                }
                ++i;
            }
            Range rangeMapping = new Range(line + linesDifference, line + linesDifference);
            rangeMappingByLine.put(line, rangeMapping);
            this.rangeMappingInFileByLine.put(file, rangeMappingByLine);
            return rangeMapping;
        }
        Range linesRange = rangeMappingByLine.get(line);
        if (linesRange == null) {
            int i = 0;
            while (i < deltas.size()) {
                AbstractDelta delta = (AbstractDelta)deltas.get(i);
                Chunk<String> chunk = this.getDeltaContent((AbstractDelta<String>)delta, fromSource);
                if (line >= chunk.getPosition() && line <= chunk.getPosition() + chunk.size()) {
                    linesRange = this.updateRangeMappingByLine(line, rangeMappingByLine, (AbstractDelta<String>)delta, fromSource);
                    return linesRange;
                }
                if (chunk.getPosition() + chunk.size() < line) {
                    linesDifference = this.updateLineDifference(line, linesDifference, (AbstractDelta<String>)delta, fromSource);
                }
                ++i;
            }
            linesRange = new Range(line + linesDifference, line + linesDifference);
            rangeMappingByLine.put(line, linesRange);
            return linesRange;
        }
        return linesRange;
    }

    private Chunk<String> getDeltaContent(AbstractDelta<String> delta, boolean fromSource) {
        return fromSource ? delta.getSource() : delta.getTarget();
    }

    protected Range updateRangeMappingByLine(int line, TreeMap<Integer, Range> rangeMappingByLine, AbstractDelta<String> delta, boolean fromSource) {
        Chunk<String> chunk = this.getDeltaContent(delta, !fromSource);
        Range linesRange = new Range(chunk.getPosition(), chunk.getPosition() + chunk.size());
        rangeMappingByLine.put(line, linesRange);
        return linesRange;
    }

    protected int updateLineDifference(int line, int linesDifference, AbstractDelta<String> delta, boolean fromSource) {
        Chunk source = delta.getSource();
        Chunk target = delta.getTarget();
        if (!fromSource) {
            Chunk temp = source;
            source = target;
            target = temp;
        }
        if (source.getPosition() + source.size() >= line) {
            return linesDifference;
        }
        linesDifference += target.size();
        return linesDifference -= source.size();
    }

    public static class Range {
        int min;
        int max;

        public Range(int minimum, int maximum) {
            this.min = minimum;
            this.max = maximum;
        }

        public boolean contains(int value) {
            return value >= this.min && value <= this.max;
        }

        public String toString() {
            return "Min: " + this.min + " Max: " + this.max;
        }
    }
}

