/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.ui.WaiversManager;

public class VerissimoWaiveHitProposal
extends WorkbenchMarkerResolution
implements ICompletionProposal {
    private OVMComplianceCheckHit hit;
    private IMarker marker;

    public VerissimoWaiveHitProposal(OVMComplianceCheckHit hit) {
        this.hit = hit;
    }

    public VerissimoWaiveHitProposal(OVMComplianceCheckHit hit, IMarker marker) {
        this.hit = hit;
        this.marker = marker;
    }

    public void apply(IDocument document) {
        if (this.hit != null) {
            WaiversManager.getInstance().addWaiver(this.hit);
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        String message = "";
        if (this.hit != null) {
            message = this.hit.getDetails();
        }
        return message;
    }

    public String getDisplayString() {
        if (this.hit == null) {
            return "";
        }
        OVMComplianceCheck check = this.hit.getCheck();
        if (check == null) {
            return "";
        }
        return "Waive " + check.getName() + " failure";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.IMG_LINTER);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDescription() {
        return "";
    }

    public String getLabel() {
        return "Waive " + this.hit.getCheck().getName() + " failure";
    }

    public void run(IMarker marker) {
        try {
            OVMComplianceCheckHit hit = (OVMComplianceCheckHit)marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
            if (hit != null) {
                WaiversManager.getInstance().addWaiver(hit);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        try {
            if (markers == null) {
                return new IMarker[0];
            }
            ArrayList<IMarker> similarMarkers = new ArrayList<IMarker>();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker != this.marker && marker != null && "ro.amiq.vlogdt.LintingErrorMarker".equals(marker.getType())) {
                    Object markerName = marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.CheckNameAttribute");
                    Object firstSelectedMarkerName = this.marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.CheckNameAttribute");
                    if (markerName != null && firstSelectedMarkerName != null && firstSelectedMarkerName.equals(markerName)) {
                        similarMarkers.add(marker);
                    }
                }
                ++n2;
            }
            return similarMarkers.toArray(new IMarker[similarMarkers.size()]);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IMarker[0];
        }
    }
}

