/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ui.FontFactory;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.MessagePattern;
import ro.amiq.vlogdt.linter.waivers.PathEntry;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiversModel;

public final class WaiverDialog
extends TitleAreaDialog {
    private static final int NONE = 0;
    private static final int INVALID_NAME_ERROR = 1;
    private static final int INVALID_LINE_RANGE_ERROR = 2;
    private static final int INVALID_STATUS_ERROR = 4;
    private static final int INVALID_MESSAGE_PATTERN = 8;
    private static final int INVALID_WAIVER_TYPE_PATTERN = 16;
    private static final int INVALID_PATH_PATTERN = 32;
    private static final int INVALID_ELEMENT_PATTERN = 64;
    private static final int INVALID_SINGLE_LINE_COMMENT_ERROR = 128;
    private static final int INVALID_COMMENT_ERROR = 256;
    private static final int INVALID_MACRO_ERROR = 512;
    private static final Pattern lineSepPattern = Pattern.compile(DVTStringUtil.LINE_SEPARATOR);
    private static final String matchedText = "MATCHED";
    private static final String notMatchedText = "NOT MATCHED";
    private final OVMProject fOVMProject;
    private final boolean fCodeWaiverEnabled;
    private final boolean fUselessCodeWaiverWarning;
    private String fOriginalPathPattern;
    private String fOriginalMessagePattern;
    private IWaiver fPreviousWaiver;
    private IWaiver fWaiver;
    private DocumentManager fDocumentManager;
    private Text fNameText;
    private Combo fWaiverFileCombo;
    private Text fDescriptionText;
    private Text fPathsText;
    private Text fChecksText;
    private Text fMessagePatternsText;
    private Text fLineRangesText;
    private Text fOriginalMessagePatternText;
    private Label fOriginalFailureMessagePatternLabel;
    private Label fIsMatchingOriginalMessageLabel;
    private Text fOriginalPathPatternText;
    private Label fOriginalPathPatternLabel;
    private Label fIsMatchingOriginalPathLabel;
    private Button fInsertCheckNameButton;
    private Button fInsertFileButton;
    private Button fInsertDirectoryButton;
    private Button fPathPerlRegexRadio;
    private Button fPathSimpleRegexRadio;
    private Button fMessagePerlRegexRadio;
    private Button fMessageSimpleRegexRadio;
    private Button fInsideMacroPathCheckBox;
    private Button fTypeWaiver;
    private Button fTypePreWaiver;
    private Label fStatusLabel;
    private Map<String, Button> fStatusButtons;
    private Map<String, Button> fCommentTypeButtons;
    private Button fApplyOnMatched;
    private Button fApplyOnNonMatched;
    private Button fPathsApplyOnMatched;
    private Button fPathsApplyOnNonMatched;
    private Composite fStackComposite;
    private Composite fWaiverFilterComposite;
    private Composite fPreWaiverFilterComposite;
    private Button fPreWaiverApplyOnMatched;
    private Button fPreWaiverApplyOnNonMatched;
    private Button fPreWaiverPathsApplyOnMatched;
    private Button fPreWaiverPathsApplyOnNonMatched;
    private Button fPreWaiverInsertFileButton;
    private Button fPreWaiverInsertDirectoryButton;
    private Button fPreWaiverPathPerlRegexRadio;
    private Button fPreWaiverPathSimpleRegexRadio;
    private Text fPreWaiverOriginalPathPatternText;
    private Label fPreWaiverOriginalPathPatternLabel;
    private Label fPreWaiverIsMatchingOriginalPathLabel;
    private Text fPreWaiverPathsText;
    private Button fPreWaiverInsertCheckNameButton;
    private Text fPreWaiverChecksText;
    private Button fElementPerlRegexRadio;
    private Button fElementSimpleRegexRadio;
    private Button fPreWaiverElementPerlRegexRadio;
    private Button fPreWaiverElementSimpleRegexRadio;
    private Label fModuleBox;
    private Label fInterfaceBox;
    private Label fPackageBox;
    private Label fTopBox;
    private Text fModuleNamePattern;
    private Text fInterfaceNamePattern;
    private Text fPackageNamePattern;
    private Text fTopNamePattern;
    private Label fPreWaiverModuleBox;
    private Label fPreWaiverInterfaceBox;
    private Label fPreWaiverPackageBox;
    private Label fPreWaiverTopBox;
    private Text fPreWaiverModuleNamePattern;
    private Text fPreWaiverInterfaceNamePattern;
    private Text fPreWaiverPackageNamePattern;
    private Text fPreWaiverTopNamePattern;
    private TabItem pathItems;
    private TabItem checkItems;
    private TabItem mPatternsItems;
    private TabItem lRangesItems;
    private TabItem elementsItems;
    private TabItem reWaiverPathItems;
    private TabItem preWaiverCheckItems;
    private TabItem preWaiverElementsItems;
    private boolean fDefineOnLine;
    private int fErrors = 0;

    public WaiverDialog(Shell parentShell, OVMProject ovmProject) {
        this(parentShell, ovmProject, false, false, null, null, null);
    }

    public WaiverDialog(Shell parentShell, OVMProject ovmProject, boolean codeWaiverEnabled, boolean uselessWaiverWarning, String originalPathPattern, String originalMessagePattern, IWaiver previousWaiver) {
        super(parentShell);
        this.fOVMProject = ovmProject;
        this.fCodeWaiverEnabled = codeWaiverEnabled;
        this.fUselessCodeWaiverWarning = uselessWaiverWarning;
        this.fPreviousWaiver = previousWaiver;
        this.fOriginalPathPattern = originalPathPattern;
        this.fOriginalMessagePattern = originalMessagePattern;
    }

    public WaiverDialog(Shell parentShell, OVMProject ovmProject, boolean codeWaiverEnabled, boolean uselessWaiverWarning, IWaiver previousWaiver, DocumentManager documentManager) {
        this(parentShell, ovmProject, codeWaiverEnabled, uselessWaiverWarning, null, null, previousWaiver);
        this.fDocumentManager = documentManager;
    }

    public void setInput(IWaiver waiver) {
        this.fWaiver = waiver;
    }

    public int open() {
        return super.open();
    }

    public void create() {
        super.create();
        this.setTitleImage(DVTImages.imageCache.getImage(DVTImages.OVM_WAIVERS_WIZARD));
        this.setTitle("Configure waiver properties...");
        this.addWidgetListeners();
        this.setInputValues();
        if (this.fCodeWaiverEnabled) {
            this.checkIfMacroExists();
        }
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Edit Waiver");
        shell.setImage(DVTImages.imageCache.getImage(DVTImages.WAIVERS));
    }

    private boolean isWaiverForFailure() {
        return this.fOriginalPathPattern != null && this.fOriginalMessagePattern != null;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gl;
        GridData gd;
        Label label;
        Control container = super.createDialogArea(parent);
        Composite composite = new Composite((Composite)container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout());
        FontFactory fontFactory = new FontFactory(parent.getDisplay());
        Label info = new Label(composite, 64);
        info.setFont(fontFactory.createFont("info", 1));
        info.setLayoutData((Object)new GridData(4, 4, true, false));
        info.setText("The waiver is applied on failures that match the paths, checks, line-ranges, message-patterns and elements." + DVTStringUtil.LINE_SEPARATOR + "If any of them is not defined it is considered matched.");
        info.addDisposeListener(e -> {
            if (fontFactory != null) {
                fontFactory.dispose();
            }
        });
        int mainPartWidthOffset = 90;
        info = new Label(composite, 64);
        info.setLayoutData((Object)new GridData(4, 4, true, false));
        info.setText(" - Paths can be files or directories and may contain system variables." + DVTStringUtil.LINE_SEPARATOR + " - Line ranges can be a single integer or an interval defined by its endpoints separated by colon." + DVTStringUtil.LINE_SEPARATOR + " - Message patterns must be valid regular expressions that match the entire message.");
        Composite mainGroup = new Composite(composite, 0);
        mainGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        mainGroup.setLayout((Layout)new GridLayout(2, false));
        if (!this.fCodeWaiverEnabled) {
            label = new Label(mainGroup, 16384);
            gd = new GridData(16384, 0x1000000, false, false);
            gd.widthHint = mainPartWidthOffset;
            label.setLayoutData((Object)gd);
            label.setText("File:");
            this.fWaiverFileCombo = new Combo(mainGroup, 12);
            this.fWaiverFileCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            WaiversModel waiversModel = this.fOVMProject.getProjectWaivers();
            if (waiversModel != null) {
                Set<String> waiverFiles = waiversModel.getWaiverFiles();
                for (String waiverFile : waiverFiles) {
                    File file = new File(waiverFile);
                    if (file.exists() && !file.canWrite()) continue;
                    this.fWaiverFileCombo.add(waiverFile);
                }
            }
            label = new Label(mainGroup, 16384);
            gd = new GridData(16384, 0x1000000, false, false);
            gd.widthHint = mainPartWidthOffset;
            label.setLayoutData((Object)gd);
            label.setText("Type:");
            Composite typeButtons = new Composite(mainGroup, 0);
            typeButtons.setLayoutData((Object)new GridData(4, 4, false, false));
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            typeButtons.setLayout((Layout)gl);
            this.fTypeWaiver = new Button(typeButtons, 16);
            this.fTypeWaiver.setLayoutData((Object)new GridData());
            this.fTypeWaiver.setText("WAIVER");
            this.fTypePreWaiver = new Button(typeButtons, 16);
            this.fTypePreWaiver.setLayoutData((Object)new GridData());
            this.fTypePreWaiver.setText("PRE-WAIVER");
        }
        label = new Label(mainGroup, 16384);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = mainPartWidthOffset;
        label.setLayoutData((Object)gd);
        label.setText("Name:");
        this.fNameText = new Text(mainGroup, 2052);
        this.fNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (!this.fCodeWaiverEnabled) {
            label = new Label(mainGroup, 16384);
            gd = new GridData(16384, 0x1000000, false, false);
            gd.widthHint = mainPartWidthOffset;
            label.setLayoutData((Object)gd);
            label.setText("Description:");
            this.fDescriptionText = new Text(mainGroup, 2818);
            gd = new GridData(4, 4, true, false);
            gd.heightHint = 80;
            this.fDescriptionText.setLayoutData((Object)gd);
        }
        if (this.fCodeWaiverEnabled) {
            label = new Label(mainGroup, 16384);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label.setText("Comment type:");
            Composite commentTypeButtons = new Composite(mainGroup, 0);
            commentTypeButtons.setLayoutData((Object)new GridData(4, 4, true, false));
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            commentTypeButtons.setLayout((Layout)gl);
            this.fCommentTypeButtons = new LinkedHashMap<String, Button>();
            int i = 0;
            while (i < IWaiver.COMMENT_TYPES.length) {
                Button commentTypeButton = new Button(commentTypeButtons, 16);
                commentTypeButton.setLayoutData((Object)new GridData());
                commentTypeButton.setText(IWaiver.COMMENT_TYPES[i]);
                this.fCommentTypeButtons.put(IWaiver.COMMENT_TYPES[i], commentTypeButton);
                ++i;
            }
        }
        this.fStackComposite = new Composite(composite, 0);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 400;
        gd.widthHint = 800;
        this.fStackComposite.setLayoutData((Object)gd);
        this.fStackComposite.setLayout((Layout)new StackLayout());
        this.fWaiverFilterComposite = new Composite(this.fStackComposite, 0);
        gd = new GridData(4, 4, true, true);
        gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fWaiverFilterComposite.setLayout((Layout)gl);
        ((StackLayout)this.fStackComposite.getLayout()).topControl = this.fWaiverFilterComposite;
        this.fStackComposite.layout();
        Composite labelComposite = new Composite(this.fWaiverFilterComposite, 16384);
        labelComposite.setLayout((Layout)new GridLayout(2, false));
        this.fStatusLabel = new Label(labelComposite, 16384);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = mainPartWidthOffset;
        this.fStatusLabel.setLayoutData((Object)gd);
        this.fStatusLabel.setFont(fontFactory.createFont("info", 1));
        this.fStatusLabel.setText("Status:");
        Composite statusButtons = new Composite(labelComposite, 0);
        statusButtons.setLayoutData((Object)new GridData(4, 4, true, false));
        gl = new GridLayout(4, false);
        gl.marginHeight = 20;
        gl.marginWidth = 0;
        statusButtons.setLayout((Layout)gl);
        this.fStatusButtons = new LinkedHashMap<String, Button>();
        WaiverStatus[] validStatuses = WaiverStatus.getValid();
        int i = 0;
        while (i < validStatuses.length) {
            Button statusButton = new Button(statusButtons, 16);
            statusButton.setLayoutData((Object)new GridData());
            statusButton.setText(validStatuses[i].toString());
            this.fStatusButtons.put(validStatuses[i].toString(), statusButton);
            ++i;
        }
        if (!this.fCodeWaiverEnabled) {
            Composite applyOnComposite = new Composite(this.fWaiverFilterComposite, 16384);
            applyOnComposite.setLayout((Layout)new GridLayout(2, false));
            label = new Label(applyOnComposite, 16384);
            gd = new GridData(16384, 0x1000000, false, false);
            gd.widthHint = mainPartWidthOffset;
            label.setLayoutData((Object)gd);
            label.setText("Apply on:");
            Composite applyOnButtons = new Composite(applyOnComposite, 0);
            applyOnButtons.setLayoutData((Object)new GridData(4, 4, false, false));
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            applyOnButtons.setLayout((Layout)gl);
            this.fApplyOnMatched = new Button(applyOnButtons, 16);
            this.fApplyOnMatched.setLayoutData((Object)new GridData());
            this.fApplyOnMatched.setText("matched".toUpperCase());
            this.fApplyOnNonMatched = new Button(applyOnButtons, 16);
            this.fApplyOnNonMatched.setLayoutData((Object)new GridData());
            this.fApplyOnNonMatched.setText("not-matched".toUpperCase());
        }
        Composite content = new Composite(this.fWaiverFilterComposite, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        content.setLayout((Layout)new GridLayout(1, true));
        TabFolder tFolder = new TabFolder(content, 2048);
        tFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite pathComposite = new Composite((Composite)tFolder, 0);
        gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 150;
        pathComposite.setLayoutData((Object)gd);
        pathComposite.setLayout((Layout)new GridLayout(1, false));
        if (!this.fCodeWaiverEnabled) {
            Composite pathChoicesComposite = new Composite(pathComposite, 4);
            pathChoicesComposite.setLayoutData((Object)new GridData(4, 128, false, false, 6, 1));
            gl = new GridLayout(6, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            pathChoicesComposite.setLayout((Layout)gl);
            Label pathsApplyOnLabel = new Label(pathChoicesComposite, 4);
            pathsApplyOnLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            pathsApplyOnLabel.setText("Apply On:");
            Composite pathApplyOnComposite = new Composite(pathChoicesComposite, 4);
            pathApplyOnComposite.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            pathApplyOnComposite.setLayout((Layout)gl);
            this.fPathsApplyOnMatched = new Button(pathApplyOnComposite, 16);
            this.fPathsApplyOnMatched.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fPathsApplyOnMatched.setText(StringUtils.capitalize((String)"matched"));
            this.fPathsApplyOnNonMatched = new Button(pathApplyOnComposite, 16);
            this.fPathsApplyOnNonMatched.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fPathsApplyOnNonMatched.setText(StringUtils.capitalize((String)"not-matched"));
            Label pathRegexTypeLabel = new Label(pathChoicesComposite, 131072);
            gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 90;
            pathRegexTypeLabel.setLayoutData((Object)gd);
            pathRegexTypeLabel.setText("Regex Type:");
            Composite regexTypeComposite = new Composite(pathChoicesComposite, 131072);
            regexTypeComposite.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            regexTypeComposite.setLayout((Layout)gl);
            this.fPathPerlRegexRadio = new Button(regexTypeComposite, 16);
            this.fPathPerlRegexRadio.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fPathPerlRegexRadio.setText("Perl");
            this.fPathSimpleRegexRadio = new Button(regexTypeComposite, 16);
            this.fPathSimpleRegexRadio.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fPathSimpleRegexRadio.setText("Simple");
        }
        Composite pathButtonsComposite = new Composite(pathComposite, 4);
        pathButtonsComposite.setLayoutData((Object)new GridData(4, 128, false, false, 4, 1));
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        pathButtonsComposite.setLayout((Layout)gl);
        if (!this.fCodeWaiverEnabled) {
            this.fInsertFileButton = new Button(pathButtonsComposite, 8);
            this.fInsertFileButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fInsertFileButton.setText("Add File...");
            this.fInsertDirectoryButton = new Button(pathButtonsComposite, 8);
            this.fInsertDirectoryButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fInsertDirectoryButton.setText("Insert Directory...");
            this.fInsideMacroPathCheckBox = new Button(pathButtonsComposite, 32);
            this.fInsideMacroPathCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fInsideMacroPathCheckBox.setText("Inside Macro");
            if (this.isWaiverForFailure()) {
                this.fIsMatchingOriginalPathLabel = new Label(pathButtonsComposite, 32);
                gd = new GridData(16384, 0x1000000, false, false);
                gd.widthHint = 250;
                this.fIsMatchingOriginalPathLabel.setLayoutData((Object)gd);
                this.setNotMatchedForGenericLabel(this.fPathsText, this.fIsMatchingOriginalPathLabel, null);
            }
        }
        Composite textAreaComposite = new Composite(pathComposite, 4);
        gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 50;
        textAreaComposite.setLayoutData((Object)gd);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        if (this.isWaiverForFailure()) {
            gl.marginHeight = 2;
            gl.marginWidth = 2;
        }
        textAreaComposite.setLayout((Layout)gl);
        this.fPathsText = new Text(textAreaComposite, 2818);
        this.fPathsText.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        this.fPathsText.setEnabled(!this.fCodeWaiverEnabled);
        if (this.isWaiverForFailure()) {
            Composite failurePathComposite = new Composite(pathComposite, 4);
            gd = new GridData(4, 1024, false, false, 1, 1);
            gd.heightHint = 50;
            failurePathComposite.setLayoutData((Object)gd);
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            failurePathComposite.setLayout((Layout)gl);
            this.fOriginalPathPatternLabel = new Label(failurePathComposite, 32);
            this.fOriginalPathPatternLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOriginalPathPatternLabel.setText("Failure Path: ");
            this.fOriginalPathPatternText = new Text(failurePathComposite, 2826);
            this.fOriginalPathPatternText.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fOriginalPathPatternText.setText(this.fOriginalPathPattern);
        }
        this.pathItems = new TabItem(tFolder, 2048);
        this.pathItems.setText("Paths [0]");
        this.pathItems.setControl((Control)pathComposite);
        Composite checkComposite = new Composite((Composite)tFolder, 0);
        checkComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        checkComposite.setLayout((Layout)new GridLayout());
        this.fInsertCheckNameButton = new Button(checkComposite, 8);
        this.fInsertCheckNameButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fInsertCheckNameButton.setText("Insert Check Name...");
        this.fChecksText = new Text(checkComposite, 2818);
        this.fChecksText.setLayoutData((Object)new GridData(1808));
        this.checkItems = new TabItem(tFolder, 2048);
        this.checkItems.setText("Check Names [0]");
        this.checkItems.setControl((Control)checkComposite);
        Composite mPatternsComposite = new Composite((Composite)tFolder, 0);
        gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 120;
        mPatternsComposite.setLayoutData((Object)gd);
        mPatternsComposite.setLayout((Layout)new GridLayout(1, false));
        Composite firstLineOfMPatternsComposite = new Composite(mPatternsComposite, 0);
        firstLineOfMPatternsComposite.setLayoutData((Object)new GridData(131072, 4, false, false, 4, 1));
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        firstLineOfMPatternsComposite.setLayout((Layout)gl);
        if (this.isWaiverForFailure()) {
            firstLineOfMPatternsComposite.setLayoutData((Object)new GridData(4, 4, false, false, 4, 1));
            this.fIsMatchingOriginalMessageLabel = new Label(firstLineOfMPatternsComposite, 32);
            gd = new GridData(16384, 0x1000000, true, false);
            gd.widthHint = 250;
            this.fIsMatchingOriginalMessageLabel.setLayoutData((Object)gd);
            this.setNotMatchedForGenericLabel(this.fPathsText, this.fIsMatchingOriginalMessageLabel, null);
        }
        Label messageRegexTypeLabel = new Label(firstLineOfMPatternsComposite, 0);
        messageRegexTypeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        messageRegexTypeLabel.setText("Regex Type:");
        this.fMessagePerlRegexRadio = new Button(firstLineOfMPatternsComposite, 16);
        this.fMessagePerlRegexRadio.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fMessagePerlRegexRadio.setText("Perl");
        this.fMessageSimpleRegexRadio = new Button(firstLineOfMPatternsComposite, 16);
        this.fMessageSimpleRegexRadio.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fMessageSimpleRegexRadio.setText("Simple");
        Composite mPatternsTextComposite = new Composite(mPatternsComposite, 4);
        gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 50;
        mPatternsTextComposite.setLayoutData((Object)gd);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        mPatternsTextComposite.setLayout((Layout)gl);
        SashForm mPatternsSashForm = new SashForm(mPatternsTextComposite, 512);
        mPatternsSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Composite messagePatternsComposite = new Composite((Composite)mPatternsSashForm, 4);
        messagePatternsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        if (this.isWaiverForFailure()) {
            gl.marginHeight = 2;
            gl.marginWidth = 2;
        }
        messagePatternsComposite.setLayout((Layout)gl);
        this.fMessagePatternsText = new Text(messagePatternsComposite, 2818);
        this.fMessagePatternsText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (this.isWaiverForFailure()) {
            Composite failureMessageComposite = new Composite((Composite)mPatternsSashForm, 4);
            gd = new GridData(4, 4, true, true, 1, 1);
            gd.heightHint = 50;
            failureMessageComposite.setLayoutData((Object)gd);
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            failureMessageComposite.setLayout((Layout)gl);
            this.fOriginalFailureMessagePatternLabel = new Label(failureMessageComposite, 32);
            this.fOriginalFailureMessagePatternLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOriginalFailureMessagePatternLabel.setText("Failure Message: ");
            this.fOriginalMessagePatternText = new Text(failureMessageComposite, 2826);
            this.fOriginalMessagePatternText.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fOriginalMessagePatternText.setText(this.fOriginalMessagePattern);
        }
        if (!this.fCodeWaiverEnabled) {
            this.mPatternsItems = new TabItem(tFolder, 2048);
            this.mPatternsItems.setText("Message Patterns [0]");
            this.mPatternsItems.setControl((Control)mPatternsComposite);
        }
        Composite lRangesComposite = new Composite((Composite)tFolder, 0);
        lRangesComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        lRangesComposite.setLayout((Layout)new GridLayout());
        this.fLineRangesText = new Text(lRangesComposite, 2818);
        this.fLineRangesText.setLayoutData((Object)new GridData(1808));
        this.fLineRangesText.setEnabled(!this.fCodeWaiverEnabled);
        this.lRangesItems = new TabItem(tFolder, 2048);
        this.lRangesItems.setText("Line Ranges [0]");
        this.lRangesItems.setControl((Control)lRangesComposite);
        Composite waiverElementsGroup = new Composite((Composite)tFolder, 0);
        waiverElementsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        waiverElementsGroup.setLayout((Layout)new GridLayout(3, false));
        Composite firstLineOfElementsGroupComposite = new Composite(waiverElementsGroup, 4);
        firstLineOfElementsGroupComposite.setLayoutData((Object)new GridData(131072, 4, true, false, 3, 1));
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        firstLineOfElementsGroupComposite.setLayout((Layout)gl);
        Label elementsRegexTypeLabel = new Label(firstLineOfElementsGroupComposite, 0);
        elementsRegexTypeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        elementsRegexTypeLabel.setText("Regex Type:");
        this.fElementPerlRegexRadio = new Button(firstLineOfElementsGroupComposite, 16);
        this.fElementPerlRegexRadio.setLayoutData((Object)new GridData());
        this.fElementPerlRegexRadio.setText("Perl");
        this.fElementSimpleRegexRadio = new Button(firstLineOfElementsGroupComposite, 16);
        this.fElementSimpleRegexRadio.setLayoutData((Object)new GridData());
        this.fElementSimpleRegexRadio.setText("Simple");
        Composite secondLineOfElementsGroupComposite = new Composite(waiverElementsGroup, 0);
        secondLineOfElementsGroupComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        secondLineOfElementsGroupComposite.setLayout((Layout)gl);
        this.fModuleBox = new Label(secondLineOfElementsGroupComposite, 32);
        this.fModuleBox.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fModuleBox.setText("Module");
        this.fModuleNamePattern = new Text(secondLineOfElementsGroupComposite, 2818);
        this.fModuleNamePattern.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fInterfaceBox = new Label(secondLineOfElementsGroupComposite, 32);
        this.fInterfaceBox.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fInterfaceBox.setText("Interface");
        this.fInterfaceNamePattern = new Text(secondLineOfElementsGroupComposite, 2818);
        this.fInterfaceNamePattern.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPackageBox = new Label(secondLineOfElementsGroupComposite, 32);
        this.fPackageBox.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fPackageBox.setText("Package");
        this.fPackageNamePattern = new Text(secondLineOfElementsGroupComposite, 2818);
        this.fPackageNamePattern.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTopBox = new Label(secondLineOfElementsGroupComposite, 32);
        this.fTopBox.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fTopBox.setText("Top");
        this.fTopNamePattern = new Text(secondLineOfElementsGroupComposite, 2818);
        this.fTopNamePattern.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!this.fCodeWaiverEnabled) {
            this.elementsItems = new TabItem(tFolder, 2048);
            this.elementsItems.setText("Elements [0]");
            this.elementsItems.setControl((Control)waiverElementsGroup);
        }
        this.fPreWaiverFilterComposite = new Composite(this.fStackComposite, 0);
        gd = new GridData(4, 4, true, true);
        gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fPreWaiverFilterComposite.setLayout((Layout)gl);
        Composite applyOnComposite = new Composite(this.fPreWaiverFilterComposite, 16384);
        applyOnComposite.setLayout((Layout)new GridLayout(2, false));
        label = new Label(applyOnComposite, 16384);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = mainPartWidthOffset;
        label.setLayoutData((Object)gd);
        label.setText("Apply on:");
        Composite applyOnButtonsComposite = new Composite(applyOnComposite, 0);
        applyOnButtonsComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        applyOnButtonsComposite.setLayout((Layout)gl);
        this.fPreWaiverApplyOnMatched = new Button(applyOnButtonsComposite, 16);
        this.fPreWaiverApplyOnMatched.setLayoutData((Object)new GridData());
        this.fPreWaiverApplyOnMatched.setText("matched".toUpperCase());
        this.fPreWaiverApplyOnNonMatched = new Button(applyOnButtonsComposite, 16);
        this.fPreWaiverApplyOnNonMatched.setLayoutData((Object)new GridData());
        this.fPreWaiverApplyOnNonMatched.setText("not-matched".toUpperCase());
        content = new Composite(this.fPreWaiverFilterComposite, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        content.setLayout((Layout)new GridLayout(1, true));
        TabFolder tPreWaiverFolder = new TabFolder(content, 2048);
        tPreWaiverFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite preWaiverPathComposite = new Composite((Composite)tPreWaiverFolder, 0);
        preWaiverPathComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        preWaiverPathComposite.setLayout((Layout)new GridLayout(1, false));
        Composite preWaiverPathChoicesComposite = new Composite(preWaiverPathComposite, 4);
        preWaiverPathChoicesComposite.setLayoutData((Object)new GridData(4, 128, false, false, 6, 1));
        gl = new GridLayout(6, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        preWaiverPathChoicesComposite.setLayout((Layout)gl);
        Label preWaiverPathsApplyOnLabel = new Label(preWaiverPathChoicesComposite, 16384);
        preWaiverPathsApplyOnLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        preWaiverPathsApplyOnLabel.setText("Apply On:");
        Composite preWaiverPathApplyOnComposite = new Composite(preWaiverPathChoicesComposite, 16384);
        preWaiverPathApplyOnComposite.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        preWaiverPathApplyOnComposite.setLayout((Layout)gl);
        this.fPreWaiverPathsApplyOnMatched = new Button(preWaiverPathApplyOnComposite, 16);
        this.fPreWaiverPathsApplyOnMatched.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fPreWaiverPathsApplyOnMatched.setText(StringUtils.capitalize((String)"matched"));
        this.fPreWaiverPathsApplyOnNonMatched = new Button(preWaiverPathApplyOnComposite, 16);
        this.fPreWaiverPathsApplyOnNonMatched.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fPreWaiverPathsApplyOnNonMatched.setText(StringUtils.capitalize((String)"not-matched"));
        Label preWaiverPathRegexTypeLabel = new Label(preWaiverPathChoicesComposite, 131072);
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 90;
        preWaiverPathRegexTypeLabel.setLayoutData((Object)gd);
        preWaiverPathRegexTypeLabel.setText("Regex Type:");
        Composite preWaiverRegexTypeComposite = new Composite(preWaiverPathChoicesComposite, 131072);
        preWaiverRegexTypeComposite.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        preWaiverRegexTypeComposite.setLayout((Layout)gl);
        this.fPreWaiverPathPerlRegexRadio = new Button(preWaiverRegexTypeComposite, 16);
        this.fPreWaiverPathPerlRegexRadio.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fPreWaiverPathPerlRegexRadio.setText("Perl");
        this.fPreWaiverPathSimpleRegexRadio = new Button(preWaiverRegexTypeComposite, 16);
        this.fPreWaiverPathSimpleRegexRadio.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fPreWaiverPathSimpleRegexRadio.setText("Simple");
        Composite preWaiverPathButtonsComposite = new Composite(preWaiverPathComposite, 4);
        preWaiverPathButtonsComposite.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
        gl = new GridLayout(7, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        preWaiverPathButtonsComposite.setLayout((Layout)gl);
        this.fPreWaiverInsertFileButton = new Button(preWaiverPathButtonsComposite, 8);
        this.fPreWaiverInsertFileButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fPreWaiverInsertFileButton.setText("Add File...");
        this.fPreWaiverInsertDirectoryButton = new Button(preWaiverPathButtonsComposite, 8);
        this.fPreWaiverInsertDirectoryButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fPreWaiverInsertDirectoryButton.setText("Insert Directory...");
        if (this.isWaiverForFailure()) {
            this.fPreWaiverIsMatchingOriginalPathLabel = new Label(preWaiverPathButtonsComposite, 32);
            gd = new GridData(16384, 0x1000000, true, false);
            gd.widthHint = 250;
            this.fPreWaiverIsMatchingOriginalPathLabel.setLayoutData((Object)gd);
            this.setNotMatchedForGenericLabel(this.fPreWaiverPathsText, this.fPreWaiverIsMatchingOriginalPathLabel, null);
        }
        Composite preWaiverTextAreaComposite = new Composite(preWaiverPathComposite, 4);
        gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 50;
        preWaiverTextAreaComposite.setLayoutData((Object)gd);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        if (this.isWaiverForFailure()) {
            gl.marginHeight = 2;
            gl.marginWidth = 2;
        }
        preWaiverTextAreaComposite.setLayout((Layout)gl);
        this.fPreWaiverPathsText = new Text(preWaiverTextAreaComposite, 2818);
        this.fPreWaiverPathsText.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        if (this.isWaiverForFailure()) {
            Composite preWaiverFailurePathComposite = new Composite(preWaiverPathComposite, 4);
            gd = new GridData(4, 1024, false, false, 1, 1);
            gd.heightHint = 50;
            preWaiverFailurePathComposite.setLayoutData((Object)gd);
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            preWaiverFailurePathComposite.setLayout((Layout)gl);
            this.fPreWaiverOriginalPathPatternLabel = new Label(preWaiverFailurePathComposite, 32);
            this.fPreWaiverOriginalPathPatternLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fPreWaiverOriginalPathPatternLabel.setText("Failure Path: ");
            this.fPreWaiverOriginalPathPatternText = new Text(preWaiverFailurePathComposite, 2826);
            this.fPreWaiverOriginalPathPatternText.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fPreWaiverOriginalPathPatternText.setText(this.fOriginalPathPattern);
        }
        this.reWaiverPathItems = new TabItem(tPreWaiverFolder, 2048);
        this.reWaiverPathItems.setText("Paths [0]");
        this.reWaiverPathItems.setControl((Control)preWaiverPathComposite);
        Composite preWaiverCheckComposite = new Composite((Composite)tPreWaiverFolder, 0);
        preWaiverCheckComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        preWaiverCheckComposite.setLayout((Layout)new GridLayout());
        this.fPreWaiverInsertCheckNameButton = new Button(preWaiverCheckComposite, 8);
        this.fPreWaiverInsertCheckNameButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fPreWaiverInsertCheckNameButton.setText("Insert Check Name...");
        this.fPreWaiverChecksText = new Text(preWaiverCheckComposite, 2818);
        this.fPreWaiverChecksText.setLayoutData((Object)new GridData(1808));
        this.preWaiverCheckItems = new TabItem(tPreWaiverFolder, 2048);
        this.preWaiverCheckItems.setText("Check Names [0]");
        this.preWaiverCheckItems.setControl((Control)preWaiverCheckComposite);
        Composite preWaiverElementsGroupComposite = new Composite((Composite)tPreWaiverFolder, 0);
        preWaiverElementsGroupComposite.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        preWaiverElementsGroupComposite.setLayout((Layout)new GridLayout(4, false));
        firstLineOfElementsGroupComposite = new Composite(preWaiverElementsGroupComposite, 0);
        firstLineOfElementsGroupComposite.setLayoutData((Object)new GridData(131072, 4, true, false, 4, 1));
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        firstLineOfElementsGroupComposite.setLayout((Layout)gl);
        elementsRegexTypeLabel = new Label(firstLineOfElementsGroupComposite, 0);
        elementsRegexTypeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        elementsRegexTypeLabel.setText("Regex Type:");
        this.fPreWaiverElementPerlRegexRadio = new Button(firstLineOfElementsGroupComposite, 16);
        this.fPreWaiverElementPerlRegexRadio.setLayoutData((Object)new GridData());
        this.fPreWaiverElementPerlRegexRadio.setText("Perl");
        this.fPreWaiverElementSimpleRegexRadio = new Button(firstLineOfElementsGroupComposite, 16);
        this.fPreWaiverElementSimpleRegexRadio.setLayoutData((Object)new GridData());
        this.fPreWaiverElementSimpleRegexRadio.setText("Simple");
        secondLineOfElementsGroupComposite = new Composite(preWaiverElementsGroupComposite, 0);
        secondLineOfElementsGroupComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        secondLineOfElementsGroupComposite.setLayout((Layout)gl);
        this.fPreWaiverModuleBox = new Label(secondLineOfElementsGroupComposite, 32);
        this.fPreWaiverModuleBox.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fPreWaiverModuleBox.setText("Module");
        this.fPreWaiverModuleNamePattern = new Text(secondLineOfElementsGroupComposite, 2818);
        this.fPreWaiverModuleNamePattern.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.fPreWaiverInterfaceBox = new Label(secondLineOfElementsGroupComposite, 32);
        this.fPreWaiverInterfaceBox.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fPreWaiverInterfaceBox.setText("Interface");
        this.fPreWaiverInterfaceNamePattern = new Text(secondLineOfElementsGroupComposite, 2818);
        this.fPreWaiverInterfaceNamePattern.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.fPreWaiverPackageBox = new Label(secondLineOfElementsGroupComposite, 32);
        this.fPreWaiverPackageBox.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fPreWaiverPackageBox.setText("Package");
        this.fPreWaiverPackageNamePattern = new Text(secondLineOfElementsGroupComposite, 2818);
        this.fPreWaiverPackageNamePattern.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.fPreWaiverTopBox = new Label(secondLineOfElementsGroupComposite, 32);
        this.fPreWaiverTopBox.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fPreWaiverTopBox.setText("Top");
        this.fPreWaiverTopNamePattern = new Text(secondLineOfElementsGroupComposite, 2818);
        this.fPreWaiverTopNamePattern.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.preWaiverElementsItems = new TabItem(tPreWaiverFolder, 2048);
        this.preWaiverElementsItems.setText("Elements [0]");
        this.preWaiverElementsItems.setControl((Control)preWaiverElementsGroupComposite);
        if (this.fCodeWaiverEnabled && this.fUselessCodeWaiverWarning) {
            Composite uselessWaiverWarningLine = new Composite(composite, 0);
            uselessWaiverWarningLine.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            uselessWaiverWarningLine.setLayout((Layout)gl);
            info = new Label(uselessWaiverWarningLine, 64);
            info.setImage(DVTImages.imageCache.getImage(DVTImages.WARNING_ICON));
            info = new Label(uselessWaiverWarningLine, 64);
            info.setFont(fontFactory.createFont("info", 1));
            info.setLayoutData((Object)new GridData(4, 4, true, false));
            info.setText("WARNING: This code waiver will have no effect because it will be overwritten by another waiver!");
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 0, "Save and apply", true);
    }

    private void addWidgetListeners() {
        this.fNameText.addModifyListener(e -> this.setErrorAction(1, ((Text)e.widget).getText().length() == 0));
        if (!this.fCodeWaiverEnabled) {
            this.fWaiverFileCombo.addModifyListener(e -> this.checkEffectOfWaiver());
        }
        if (this.fCodeWaiverEnabled) {
            for (Button button : this.fCommentTypeButtons.values()) {
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        WaiverDialog.this.checkIfCommentExists();
                        WaiverDialog.this.checkIfMacroExists();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
        }
        if (!this.fCodeWaiverEnabled) {
            this.fPathsText.addModifyListener(e -> {
                this.updateLabelsWaiver();
                this.checkEffectOfWaiver();
                this.checkPathPatterns(((Text)e.widget).getText());
            });
            this.fPreWaiverPathsText.addModifyListener(e -> {
                this.updateLabelsPreWaiver();
                this.checkEffectOfWaiver();
                this.checkPathPatterns(((Text)e.widget).getText());
            });
            this.fMessagePatternsText.addModifyListener(e -> {
                this.updateLabelsWaiver();
                String content = ((Text)e.widget).getText();
                this.checkMessagePatterns(content);
            });
        }
        this.fChecksText.addModifyListener(e -> {
            this.updateLabelsWaiver();
            this.checkEffectOfWaiver();
        });
        this.fLineRangesText.addModifyListener(e -> {
            String[] lines;
            this.updateLabelsWaiver();
            String content = ((Text)e.widget).getText();
            String[] stringArray = lines = lineSepPattern.split(content);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!LineRange.isValid(line)) {
                    this.setErrorAction(2, true);
                    return;
                }
                ++n2;
            }
            this.setErrorAction(2, false);
        });
        if (!this.fCodeWaiverEnabled) {
            this.fTypeWaiver.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (WaiverDialog.this.fTypeWaiver.getSelection()) {
                        WaiverDialog.this.swapValuesFromPreWaiversToWaivers();
                    }
                    if (WaiverDialog.this.getSelectedStatus() < 0) {
                        WaiverDialog.this.fStatusButtons.get(WaiverStatus.getValid()[0].toString()).setSelection(true);
                    }
                    WaiverDialog.this.checkPathPatterns(WaiverDialog.this.fPathsText.getText());
                    WaiverDialog.this.checkMessagePatterns(WaiverDialog.this.fMessagePatternsText.getText());
                    WaiverDialog.this.checkElementPatternsPostWaiver();
                    ((StackLayout)WaiverDialog.this.fStackComposite.getLayout()).topControl = WaiverDialog.this.fWaiverFilterComposite;
                    WaiverDialog.this.fStackComposite.layout();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fTypePreWaiver.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (WaiverDialog.this.fTypePreWaiver.getSelection()) {
                        WaiverDialog.this.swapValuesFromWaiversToPreWaivers();
                    }
                    WaiverDialog.this.checkPathPatterns(WaiverDialog.this.fPreWaiverPathsText.getText());
                    WaiverDialog.this.checkMessagePatterns(WaiverDialog.this.fMessagePatternsText.getText());
                    WaiverDialog.this.checkElementPatternsPreWaiver();
                    ((StackLayout)WaiverDialog.this.fStackComposite.getLayout()).topControl = WaiverDialog.this.fPreWaiverFilterComposite;
                    WaiverDialog.this.fStackComposite.layout();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fApplyOnMatched.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkEffectOfWaiver();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fApplyOnNonMatched.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkEffectOfWaiver();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fPreWaiverApplyOnMatched.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkEffectOfWaiver();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fPreWaiverApplyOnNonMatched.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkEffectOfWaiver();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fInsertFileButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.updateLabelsWaiver();
                    WaiverDialog.this.insertFileAction();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fInsertDirectoryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.updateLabelsWaiver();
                    WaiverDialog.this.insertDirectoryAction();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fPreWaiverInsertFileButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.updateLabelsPreWaiver();
                    WaiverDialog.this.insertFileAction();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fPreWaiverInsertDirectoryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.updateLabelsPreWaiver();
                    WaiverDialog.this.insertDirectoryAction();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.fInsertCheckNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiverDialog.this.updateLabelsWaiver();
                WaiverDialog.this.insertCheckNameAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (!this.fCodeWaiverEnabled) {
            this.fPathPerlRegexRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkPathPatterns(WaiverDialog.this.fPathsText.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fPathSimpleRegexRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkPathPatterns(WaiverDialog.this.fPathsText.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fPreWaiverPathPerlRegexRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkPathPatterns(WaiverDialog.this.fPreWaiverPathsText.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fPreWaiverPathSimpleRegexRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkPathPatterns(WaiverDialog.this.fPreWaiverPathsText.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.fPreWaiverInsertCheckNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiverDialog.this.updateLabelsPreWaiver();
                WaiverDialog.this.insertCheckNameAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fPreWaiverChecksText.addModifyListener(e -> {
            this.updateLabelsPreWaiver();
            this.checkEffectOfWaiver();
        });
        this.fElementPerlRegexRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiverDialog.this.checkElementPatternsPostWaiver();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fElementSimpleRegexRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiverDialog.this.checkElementPatternsPostWaiver();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fPreWaiverElementPerlRegexRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiverDialog.this.checkElementPatternsPreWaiver();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fPreWaiverElementSimpleRegexRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiverDialog.this.checkElementPatternsPreWaiver();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (!this.fCodeWaiverEnabled) {
            this.fMessagePerlRegexRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkMessagePatterns(WaiverDialog.this.fMessagePatternsText.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fMessageSimpleRegexRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WaiverDialog.this.checkMessagePatterns(WaiverDialog.this.fMessagePatternsText.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fModuleNamePattern.addModifyListener(e -> {
                this.checkElementPatternsPostWaiver();
                this.updateLabelsWaiver();
            });
            this.fInterfaceNamePattern.addModifyListener(e -> {
                this.checkElementPatternsPostWaiver();
                this.updateLabelsWaiver();
            });
            this.fPackageNamePattern.addModifyListener(e -> {
                this.checkElementPatternsPostWaiver();
                this.updateLabelsWaiver();
            });
            this.fTopNamePattern.addModifyListener(e -> {
                this.checkElementPatternsPostWaiver();
                this.updateLabelsWaiver();
            });
            this.fPreWaiverModuleNamePattern.addModifyListener(e -> {
                this.checkElementPatternsPreWaiver();
                this.updateLabelsPreWaiver();
            });
            this.fPreWaiverInterfaceNamePattern.addModifyListener(e -> {
                this.checkElementPatternsPreWaiver();
                this.updateLabelsPreWaiver();
            });
            this.fPreWaiverPackageNamePattern.addModifyListener(e -> {
                this.checkElementPatternsPreWaiver();
                this.updateLabelsPreWaiver();
            });
            this.fPreWaiverTopNamePattern.addModifyListener(e -> {
                this.checkElementPatternsPreWaiver();
                this.updateLabelsPreWaiver();
            });
        }
    }

    private void swapValuesFromWaiversToPreWaivers() {
        this.fPreWaiverApplyOnMatched.setSelection(this.fApplyOnMatched.getSelection());
        this.fPreWaiverApplyOnMatched.notifyListeners(13, new Event());
        this.fPreWaiverApplyOnNonMatched.setSelection(this.fApplyOnNonMatched.getSelection());
        this.fPreWaiverApplyOnNonMatched.notifyListeners(13, new Event());
        this.fPreWaiverPathsApplyOnMatched.setSelection(this.fPathsApplyOnMatched.getSelection());
        this.fPreWaiverPathsApplyOnMatched.notifyListeners(13, new Event());
        this.fPreWaiverPathsApplyOnNonMatched.setSelection(this.fPathsApplyOnNonMatched.getSelection());
        this.fPreWaiverPathsApplyOnNonMatched.notifyListeners(13, new Event());
        this.fPreWaiverPathsText.setText(this.fPathsText.getText());
        this.fPreWaiverPathPerlRegexRadio.setSelection(this.fPathPerlRegexRadio.getSelection());
        this.fPreWaiverPathPerlRegexRadio.notifyListeners(13, new Event());
        this.fPreWaiverPathSimpleRegexRadio.setSelection(this.fPathSimpleRegexRadio.getSelection());
        this.fPreWaiverPathSimpleRegexRadio.notifyListeners(13, new Event());
        this.fPreWaiverChecksText.setText(this.fChecksText.getText());
        this.fPreWaiverElementPerlRegexRadio.setSelection(this.fElementPerlRegexRadio.getSelection());
        this.fPreWaiverElementPerlRegexRadio.notifyListeners(13, new Event());
        this.fPreWaiverElementSimpleRegexRadio.setSelection(this.fElementSimpleRegexRadio.getSelection());
        this.fPreWaiverElementSimpleRegexRadio.notifyListeners(13, new Event());
        this.fPreWaiverModuleNamePattern.setText(this.fModuleNamePattern.getText());
        this.fPreWaiverInterfaceNamePattern.setText(this.fInterfaceNamePattern.getText());
        this.fPreWaiverPackageNamePattern.setText(this.fPackageNamePattern.getText());
        this.fPreWaiverTopNamePattern.setText(this.fTopNamePattern.getText());
    }

    private void swapValuesFromPreWaiversToWaivers() {
        this.fApplyOnMatched.setSelection(this.fPreWaiverApplyOnMatched.getSelection());
        this.fApplyOnMatched.notifyListeners(13, new Event());
        this.fApplyOnNonMatched.setSelection(this.fPreWaiverApplyOnNonMatched.getSelection());
        this.fApplyOnNonMatched.notifyListeners(13, new Event());
        this.fPathsApplyOnMatched.setSelection(this.fPreWaiverPathsApplyOnMatched.getSelection());
        this.fPathsApplyOnMatched.notifyListeners(13, new Event());
        this.fPathsApplyOnNonMatched.setSelection(this.fPreWaiverPathsApplyOnNonMatched.getSelection());
        this.fPathsApplyOnNonMatched.notifyListeners(13, new Event());
        this.fPathsText.setText(this.fPreWaiverPathsText.getText());
        this.fPathPerlRegexRadio.setSelection(this.fPreWaiverPathPerlRegexRadio.getSelection());
        this.fPathPerlRegexRadio.notifyListeners(13, new Event());
        this.fPathSimpleRegexRadio.setSelection(this.fPreWaiverPathSimpleRegexRadio.getSelection());
        this.fPathPerlRegexRadio.notifyListeners(13, new Event());
        this.fChecksText.setText(this.fPreWaiverChecksText.getText());
        this.fElementPerlRegexRadio.setSelection(this.fPreWaiverElementPerlRegexRadio.getSelection());
        this.fElementPerlRegexRadio.notifyListeners(13, new Event());
        this.fElementSimpleRegexRadio.setSelection(this.fPreWaiverElementSimpleRegexRadio.getSelection());
        this.fElementSimpleRegexRadio.notifyListeners(13, new Event());
        this.fModuleNamePattern.setText(this.fPreWaiverModuleNamePattern.getText());
        this.fInterfaceNamePattern.setText(this.fPreWaiverInterfaceNamePattern.getText());
        this.fPackageNamePattern.setText(this.fPreWaiverPackageNamePattern.getText());
        this.fTopNamePattern.setText(this.fPreWaiverTopNamePattern.getText());
    }

    private void updateLabelsWaiver() {
        this.pathItems.setText("Path [" + this.getNumberOfLines(this.fPathsText.getText()) + "]");
        this.checkItems.setText("Check Names [" + this.getNumberOfLines(this.fChecksText.getText()) + "]");
        this.lRangesItems.setText("Line Ranges [" + this.getNumberOfLines(this.fLineRangesText.getText()) + "]");
        if (!this.fCodeWaiverEnabled) {
            this.mPatternsItems.setText("Message Patterns [" + this.getNumberOfLines(this.fMessagePatternsText.getText()) + "]");
            this.elementsItems.setText("Elements [" + (Math.min(this.getNumberOfLines(this.fModuleNamePattern.getText()), 1) + Math.min(this.getNumberOfLines(this.fInterfaceNamePattern.getText()), 1) + Math.min(this.getNumberOfLines(this.fPackageNamePattern.getText()), 1) + Math.min(this.getNumberOfLines(this.fTopNamePattern.getText()), 1)) + "]");
        }
    }

    private void updateLabelsPreWaiver() {
        this.reWaiverPathItems.setText("Path [" + this.getNumberOfLines(this.fPreWaiverPathsText.getText()) + "]");
        this.preWaiverCheckItems.setText("Check Names [" + this.getNumberOfLines(this.fPreWaiverChecksText.getText()) + "]");
        this.preWaiverElementsItems.setText("Elements [" + (Math.min(this.getNumberOfLines(this.fPreWaiverModuleNamePattern.getText()), 1) + Math.min(this.getNumberOfLines(this.fPreWaiverInterfaceNamePattern.getText()), 1) + Math.min(this.getNumberOfLines(this.fPreWaiverPackageNamePattern.getText()), 1) + Math.min(this.getNumberOfLines(this.fPreWaiverTopNamePattern.getText()), 1)) + "]");
    }

    private int getNumberOfLines(String str) {
        String[] lines = lineSepPattern.split(str);
        int count = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!"".equals(line.trim())) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private void setNotMatchedForGenericLabel(Text textArea, Label isMatchingLabel, String additionalText) {
        if (additionalText == null) {
            isMatchingLabel.setText(notMatchedText);
        } else {
            isMatchingLabel.setText("NOT MATCHED " + additionalText);
        }
        isMatchingLabel.setForeground(isMatchingLabel.getDisplay().getSystemColor(3));
        if (textArea != null) {
            textArea.getParent().setBackground(isMatchingLabel.getDisplay().getSystemColor(3));
        }
    }

    private void setMatchedForGenericLabel(Text textArea, Label isMatchingLabel, String additionalText) {
        if (additionalText == null) {
            isMatchingLabel.setText(matchedText);
        } else {
            isMatchingLabel.setText("MATCHED " + additionalText);
        }
        isMatchingLabel.setForeground(this.fIsMatchingOriginalMessageLabel.getDisplay().getSystemColor(5));
        if (textArea != null) {
            textArea.getParent().setBackground(isMatchingLabel.getDisplay().getSystemColor(5));
        }
    }

    private String getCommentType() {
        for (Map.Entry<String, Button> entry : this.fCommentTypeButtons.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            return entry.getKey();
        }
        return null;
    }

    private int getSelectedStatus() {
        int index = 0;
        for (Map.Entry<String, Button> entry : this.fStatusButtons.entrySet()) {
            if (entry.getValue().getSelection()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private String getApplyOnStatus(boolean isWaiver) {
        if (this.fCodeWaiverEnabled) {
            return "matched";
        }
        if (isWaiver) {
            if (this.fApplyOnMatched.getSelection()) {
                return "matched";
            }
            return "not-matched";
        }
        if (this.fPreWaiverApplyOnMatched.getSelection()) {
            return "matched";
        }
        return "not-matched";
    }

    private String getPathsApplyOnStatus(boolean isWaiver) {
        if (this.fCodeWaiverEnabled) {
            return "matched";
        }
        if (isWaiver) {
            if (this.fPathsApplyOnMatched.getSelection()) {
                return "matched";
            }
            return "not-matched";
        }
        if (this.fPreWaiverPathsApplyOnMatched.getSelection()) {
            return "matched";
        }
        return "not-matched";
    }

    private void checkElementPatternsPostWaiver() {
        if (!this.fTypeWaiver.getSelection()) {
            this.setErrorAction(64, false);
            return;
        }
        if (!PathEntry.isValid(this.fModuleNamePattern.getText(), !this.fElementPerlRegexRadio.getSelection() && this.fElementSimpleRegexRadio.getSelection())) {
            this.setErrorAction(64, true);
            return;
        }
        if (!PathEntry.isValid(this.fInterfaceNamePattern.getText(), !this.fElementPerlRegexRadio.getSelection() && this.fElementSimpleRegexRadio.getSelection())) {
            this.setErrorAction(64, true);
            return;
        }
        if (!PathEntry.isValid(this.fPackageNamePattern.getText(), !this.fElementPerlRegexRadio.getSelection() && this.fElementSimpleRegexRadio.getSelection())) {
            this.setErrorAction(64, true);
            return;
        }
        if (!PathEntry.isValid(this.fTopNamePattern.getText(), !this.fElementPerlRegexRadio.getSelection() && this.fElementSimpleRegexRadio.getSelection())) {
            this.setErrorAction(64, true);
            return;
        }
        this.setErrorAction(64, false);
    }

    private void checkElementPatternsPreWaiver() {
        if (!this.fTypePreWaiver.getSelection()) {
            this.setErrorAction(64, false);
            return;
        }
        if (!PathEntry.isValid(this.fPreWaiverModuleNamePattern.getText(), !this.fPreWaiverElementPerlRegexRadio.getSelection() && this.fPreWaiverElementSimpleRegexRadio.getSelection())) {
            this.setErrorAction(64, true);
            return;
        }
        if (!PathEntry.isValid(this.fPreWaiverInterfaceNamePattern.getText(), !this.fPreWaiverElementPerlRegexRadio.getSelection() && this.fPreWaiverElementSimpleRegexRadio.getSelection())) {
            this.setErrorAction(64, true);
            return;
        }
        if (!PathEntry.isValid(this.fPreWaiverPackageNamePattern.getText(), !this.fPreWaiverElementPerlRegexRadio.getSelection() && this.fPreWaiverElementSimpleRegexRadio.getSelection())) {
            this.setErrorAction(64, true);
            return;
        }
        if (!PathEntry.isValid(this.fPreWaiverTopNamePattern.getText(), !this.fPreWaiverElementPerlRegexRadio.getSelection() && this.fPreWaiverElementSimpleRegexRadio.getSelection())) {
            this.setErrorAction(64, true);
            return;
        }
        this.setErrorAction(64, false);
    }

    private void checkPathPatterns(String content) {
        String[] lines;
        String[] stringArray = lines = lineSepPattern.split(content);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (this.fTypeWaiver.getSelection() && !PathEntry.isValid(line.trim(), !this.fPathPerlRegexRadio.getSelection() && this.fPathSimpleRegexRadio.getSelection())) {
                if (this.isWaiverForFailure()) {
                    this.setNotMatchedForGenericLabel(this.fPathsText, this.fIsMatchingOriginalPathLabel, "(Invalid Pattern)");
                }
                this.setErrorAction(32, true);
                return;
            }
            if (this.fTypePreWaiver.getSelection() && !PathEntry.isValid(line.trim(), !this.fPreWaiverPathPerlRegexRadio.getSelection() && this.fPreWaiverPathSimpleRegexRadio.getSelection())) {
                if (this.isWaiverForFailure()) {
                    this.setNotMatchedForGenericLabel(this.fPreWaiverPathsText, this.fPreWaiverIsMatchingOriginalPathLabel, "(Invalid Pattern)");
                }
                this.setErrorAction(32, true);
                return;
            }
            if (this.isWaiverForFailure()) {
                String originalPath;
                PathEntry pathEntry = this.fTypeWaiver.getSelection() ? new PathEntry(line.trim(), !this.fPathPerlRegexRadio.getSelection() && this.fPathSimpleRegexRadio.getSelection()) : new PathEntry(line.trim(), !this.fPreWaiverPathPerlRegexRadio.getSelection() && this.fPreWaiverPathSimpleRegexRadio.getSelection());
                String string = originalPath = this.fTypeWaiver.getSelection() ? this.fOriginalPathPatternText.getText().trim() : this.fPreWaiverOriginalPathPatternText.getText();
                if (line.trim().isEmpty()) {
                    this.setMatchedForGenericLabel(this.fTypeWaiver.getSelection() ? this.fPathsText : this.fPreWaiverPathsText, this.fTypeWaiver.getSelection() ? this.fIsMatchingOriginalPathLabel : this.fPreWaiverIsMatchingOriginalPathLabel, "(Matches Everything)");
                    this.setErrorAction(32, false);
                    return;
                }
                if (pathEntry.matches(originalPath)) {
                    this.setMatchedForGenericLabel(this.fTypeWaiver.getSelection() ? this.fPathsText : this.fPreWaiverPathsText, this.fTypeWaiver.getSelection() ? this.fIsMatchingOriginalPathLabel : this.fPreWaiverIsMatchingOriginalPathLabel, null);
                    this.setErrorAction(32, false);
                    return;
                }
            }
            ++n2;
        }
        if (this.isWaiverForFailure()) {
            this.setNotMatchedForGenericLabel(this.fTypeWaiver.getSelection() ? this.fPathsText : this.fPreWaiverPathsText, this.fTypeWaiver.getSelection() ? this.fIsMatchingOriginalPathLabel : this.fPreWaiverIsMatchingOriginalPathLabel, null);
        }
        this.setErrorAction(32, false);
    }

    private void checkMessagePatterns(String content) {
        String[] lines;
        if (!this.fTypeWaiver.getSelection()) {
            this.setErrorAction(8, false);
            return;
        }
        String[] stringArray = lines = lineSepPattern.split(content);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MessagePattern messagePattern;
            String line = stringArray[n2];
            try {
                messagePattern = new MessagePattern(line.trim(), !this.fMessagePerlRegexRadio.getSelection() && this.fMessageSimpleRegexRadio.getSelection(), false);
            }
            catch (PatternSyntaxException e) {
                String error = String.valueOf(e.getDescription()) + " (index " + (e.getIndex() + 1) + ")";
                if (this.isWaiverForFailure()) {
                    this.setNotMatchedForGenericLabel(this.fMessagePatternsText, this.fIsMatchingOriginalMessageLabel, "(Invalid Pattern)");
                }
                this.setErrorAction(8, true, error);
                return;
            }
            if (this.isWaiverForFailure()) {
                String originalMessage = this.fOriginalMessagePatternText.getText();
                if (line.trim().isEmpty()) {
                    this.setMatchedForGenericLabel(this.fMessagePatternsText, this.fIsMatchingOriginalMessageLabel, "(Matches Everything)");
                    this.setErrorAction(8, false);
                    return;
                }
                if (messagePattern.matches(originalMessage)) {
                    this.setMatchedForGenericLabel(this.fMessagePatternsText, this.fIsMatchingOriginalMessageLabel, null);
                    this.setErrorAction(8, false);
                    return;
                }
            }
            ++n2;
        }
        if (this.isWaiverForFailure()) {
            this.setNotMatchedForGenericLabel(this.fMessagePatternsText, this.fIsMatchingOriginalMessageLabel, null);
        }
        this.setErrorAction(8, false);
    }

    protected void okPressed() {
        this.collectResults();
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void collectResults() {
        String waiverType = "";
        if (this.fCodeWaiverEnabled || this.fTypeWaiver.getSelection()) {
            waiverType = "WAIVER";
        } else if (this.fTypePreWaiver.getSelection()) {
            waiverType = "PRE-WAIVER";
        }
        if (this.fWaiver == null) {
            if (waiverType.equals("WAIVER")) {
                this.fWaiver = new PostWaiver();
            } else {
                if (!waiverType.equals("PRE-WAIVER")) return;
                this.fWaiver = new PreWaiver();
            }
        } else {
            if (this.fWaiver instanceof PostWaiver && waiverType.equals("PRE-WAIVER")) {
                this.fWaiver = new PreWaiver();
            }
            if (this.fWaiver instanceof PreWaiver && waiverType.equals("WAIVER")) {
                this.fWaiver = new PostWaiver();
            }
        }
        this.fWaiver.setName(this.fNameText.getText());
        if (!this.fCodeWaiverEnabled) {
            this.fWaiver.setDescription(this.fDescriptionText.getText());
            int waiverFileIndex = this.fWaiverFileCombo.getSelectionIndex();
            if (waiverFileIndex >= 0) {
                this.fWaiver.setFilePath(this.fWaiverFileCombo.getItem(waiverFileIndex));
            }
        }
        if (this.fCodeWaiverEnabled) {
            this.fWaiver.setCommentType(this.getCommentType());
        }
        if (this.fWaiver instanceof PostWaiver) {
            String[] path;
            this.fWaiver.setApplyOn(this.getApplyOnStatus(true));
            this.fWaiver.setPathsApplyOn(this.getPathsApplyOnStatus(true));
            isPerlRegex = this.fCodeWaiverEnabled ? false : this.fPathPerlRegexRadio.getSelection() || !this.fPathSimpleRegexRadio.getSelection();
            this.fWaiver.setPathRegexType(isPerlRegex ? "perl" : "simple");
            String content = null;
            String[] lines = null;
            this.fWaiver.clearPaths();
            this.fWaiver.clearRawPaths();
            content = this.fPathsText.getText();
            String[] stringArray = lines = lineSepPattern.split(content);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.trim().length() > 0) {
                    path = !isPerlRegex ? DVTStringUtil.intern((String)Utils.canonicPath((String)line.trim())) : DVTStringUtil.intern((String)line.trim());
                    this.fWaiver.addPath((String)path);
                    this.fWaiver.addRawPath((String)path);
                }
                ++n2;
            }
            int statusIndex = this.getSelectedStatus();
            ((PostWaiver)this.fWaiver).setStatus(WaiverStatus.getValid()[statusIndex]);
            ((PostWaiver)this.fWaiver).clearCheckNames();
            content = this.fChecksText.getText();
            path = lines = lineSepPattern.split(content);
            int n3 = lines.length;
            n = 0;
            while (n < n3) {
                String line = path[n];
                if (line.trim().length() > 0) {
                    ((PostWaiver)this.fWaiver).addCheckName(line.trim());
                }
                ++n;
            }
            if (!this.fCodeWaiverEnabled) {
                ((PostWaiver)this.fWaiver).setInsideMacroPath(this.fInsideMacroPathCheckBox.getSelection());
            }
            ((PostWaiver)this.fWaiver).clearLineRanges();
            content = this.fLineRangesText.getText();
            path = lines = lineSepPattern.split(content);
            n3 = lines.length;
            n = 0;
            while (n < n3) {
                String line = path[n];
                if (line.trim().length() > 0) {
                    ((PostWaiver)this.fWaiver).addLineRange(new LineRange(line.trim()));
                }
                ++n;
            }
            ((PostWaiver)this.fWaiver).setMessageRegexType(this.fMessagePerlRegexRadio.getSelection() || !this.fMessageSimpleRegexRadio.getSelection() ? "perl" : "simple");
            ((PostWaiver)this.fWaiver).clearMessagePatterns();
            content = this.fMessagePatternsText.getText();
            path = lines = lineSepPattern.split(content);
            n3 = lines.length;
            n = 0;
            while (n < n3) {
                String line = path[n];
                if (line.trim().length() > 0) {
                    ((PostWaiver)this.fWaiver).addMessagePattern(new MessagePattern(line.trim(), !this.fMessagePerlRegexRadio.getSelection() && this.fMessageSimpleRegexRadio.getSelection()));
                }
                ++n;
            }
            ((PostWaiver)this.fWaiver).setElementsRegexType(this.fElementPerlRegexRadio.getSelection() || !this.fElementSimpleRegexRadio.getSelection() ? "perl" : "simple");
            ((PostWaiver)this.fWaiver).clearElements();
            if (!"".equals(this.fModuleNamePattern.getText())) {
                ((PostWaiver)this.fWaiver).addElement("module", this.fModuleNamePattern.getText());
            }
            if (!"".equals(this.fInterfaceNamePattern.getText())) {
                ((PostWaiver)this.fWaiver).addElement("interface", this.fInterfaceNamePattern.getText());
            }
            if (!"".equals(this.fPackageNamePattern.getText())) {
                ((PostWaiver)this.fWaiver).addElement("package", this.fPackageNamePattern.getText());
            }
            if ("".equals(this.fTopNamePattern.getText())) return;
            ((PostWaiver)this.fWaiver).addElement("top", this.fTopNamePattern.getText());
            return;
        } else {
            String line;
            if (!(this.fWaiver instanceof PreWaiver)) return;
            this.fWaiver.setApplyOn(this.getApplyOnStatus(false));
            this.fWaiver.setPathsApplyOn(this.getPathsApplyOnStatus(false));
            isPerlRegex = this.fCodeWaiverEnabled ? false : this.fPreWaiverPathPerlRegexRadio.getSelection() || !this.fPreWaiverPathSimpleRegexRadio.getSelection();
            this.fWaiver.setPathRegexType(isPerlRegex ? "perl" : "simple");
            String content = null;
            String[] lines = null;
            this.fWaiver.clearPaths();
            this.fWaiver.clearRawPaths();
            content = this.fPreWaiverPathsText.getText();
            String[] stringArray = lines = lineSepPattern.split(content);
            int n = lines.length;
            int n4 = 0;
            while (n4 < n) {
                line = stringArray[n4];
                if (line.trim().length() > 0) {
                    String path = !isPerlRegex ? DVTStringUtil.intern((String)Utils.canonicPath((String)line.trim())) : DVTStringUtil.intern((String)line.trim());
                    this.fWaiver.addPath(path);
                    this.fWaiver.addRawPath(path);
                }
                ++n4;
            }
            ((PreWaiver)this.fWaiver).clearCheckNames();
            content = this.fPreWaiverChecksText.getText();
            stringArray = lines = lineSepPattern.split(content);
            n = lines.length;
            n4 = 0;
            while (n4 < n) {
                line = stringArray[n4];
                if (line.trim().length() > 0) {
                    ((PreWaiver)this.fWaiver).addCheckName(line.trim());
                }
                ++n4;
            }
            ((PreWaiver)this.fWaiver).setElementsRegexType(this.fPreWaiverElementPerlRegexRadio.getSelection() || !this.fPreWaiverElementSimpleRegexRadio.getSelection() ? "perl" : "simple");
            ((PreWaiver)this.fWaiver).clearElements();
            if (!"".equals(this.fPreWaiverModuleNamePattern.getText())) {
                ((PreWaiver)this.fWaiver).addElement("module", this.fPreWaiverModuleNamePattern.getText());
            }
            if (!"".equals(this.fPreWaiverInterfaceNamePattern.getText())) {
                ((PreWaiver)this.fWaiver).addElement("interface", this.fPreWaiverInterfaceNamePattern.getText());
            }
            if (!"".equals(this.fPreWaiverPackageNamePattern.getText())) {
                ((PreWaiver)this.fWaiver).addElement("package", this.fPreWaiverPackageNamePattern.getText());
            }
            if ("".equals(this.fPreWaiverTopNamePattern.getText())) return;
            ((PreWaiver)this.fWaiver).addElement("top", this.fPreWaiverTopNamePattern.getText());
        }
    }

    private void setInputValues() {
        this.fMessagePerlRegexRadio.setSelection(true);
        this.fElementPerlRegexRadio.setSelection(true);
        this.fPreWaiverPathPerlRegexRadio.setSelection(true);
        this.fPreWaiverElementPerlRegexRadio.setSelection(true);
        if (!this.fCodeWaiverEnabled) {
            this.fPathPerlRegexRadio.setSelection(true);
        }
        if (this.fWaiver == null) {
            this.fNameText.setText("Waiver Name");
            for (Map.Entry<String, Button> entry : this.fStatusButtons.entrySet()) {
                entry.getValue().setSelection(false);
            }
            this.fStatusButtons.get(WaiverStatus.getValid()[0].toString()).setSelection(true);
            if (!this.fCodeWaiverEnabled) {
                this.fDescriptionText.setText("");
                this.fWaiverFileCombo.select(0);
                this.fTypeWaiver.setSelection(true);
                this.fTypePreWaiver.setSelection(false);
                this.fApplyOnMatched.setSelection(true);
                this.fApplyOnNonMatched.setSelection(false);
                this.fPreWaiverApplyOnMatched.setSelection(true);
                this.fPreWaiverApplyOnNonMatched.setSelection(false);
                this.fPathsApplyOnMatched.setSelection(true);
                this.fPathsApplyOnNonMatched.setSelection(false);
                this.fPreWaiverPathsApplyOnMatched.setSelection(true);
                this.fPreWaiverPathsApplyOnNonMatched.setSelection(false);
            }
            if (this.fCodeWaiverEnabled) {
                for (Map.Entry<String, Button> entry : this.fCommentTypeButtons.entrySet()) {
                    entry.getValue().setSelection(false);
                }
                this.fCommentTypeButtons.get(IWaiver.COMMENT_TYPES[0]).setSelection(true);
            }
            ((StackLayout)this.fStackComposite.getLayout()).topControl = this.fWaiverFilterComposite;
            return;
        }
        this.fNameText.setText(this.fWaiver.getName());
        int index = 0;
        if (!this.fCodeWaiverEnabled) {
            this.fDescriptionText.setText(this.fWaiver.getDescription());
            String filePath = this.fWaiver.getFilePath();
            if (filePath == null) {
                this.fWaiverFileCombo.select(0);
            } else {
                this.fWaiverFileCombo.select(this.fWaiverFileCombo.indexOf(filePath));
            }
            String applyOn = this.fWaiver.getApplyOn();
            index = 0;
            while (index < IWaiver.APPLY_ON_TYPES.length) {
                if (IWaiver.APPLY_ON_TYPES[index].equals(applyOn)) break;
                ++index;
            }
            this.fApplyOnMatched.setSelection(false);
            this.fPreWaiverApplyOnMatched.setSelection(false);
            this.fApplyOnNonMatched.setSelection(false);
            this.fPreWaiverApplyOnNonMatched.setSelection(false);
            if (index == 0) {
                this.fApplyOnMatched.setSelection(true);
                this.fPreWaiverApplyOnMatched.setSelection(true);
            } else {
                this.fApplyOnNonMatched.setSelection(true);
                this.fPreWaiverApplyOnNonMatched.setSelection(true);
            }
            String pathsApplyOn = this.fWaiver.getPathsApplyOn();
            index = 0;
            while (index < IWaiver.APPLY_ON_TYPES.length) {
                if (IWaiver.APPLY_ON_TYPES[index].equals(pathsApplyOn)) break;
                ++index;
            }
            this.fPathsApplyOnMatched.setSelection(false);
            this.fPathsApplyOnNonMatched.setSelection(false);
            this.fPreWaiverPathsApplyOnMatched.setSelection(false);
            this.fPreWaiverPathsApplyOnNonMatched.setSelection(false);
            if (index == 1) {
                this.fPathsApplyOnNonMatched.setSelection(true);
                this.fPreWaiverPathsApplyOnNonMatched.setSelection(true);
            } else {
                this.fPathsApplyOnMatched.setSelection(true);
                this.fPreWaiverPathsApplyOnMatched.setSelection(true);
            }
        }
        if (this.fCodeWaiverEnabled) {
            for (Map.Entry<String, Button> entry : this.fCommentTypeButtons.entrySet()) {
                entry.getValue().setSelection(false);
            }
            this.fCommentTypeButtons.get(IWaiver.COMMENT_TYPES[0]).setSelection(true);
        }
        if (this.fWaiver instanceof PostWaiver) {
            if (!this.fCodeWaiverEnabled) {
                this.fTypeWaiver.setSelection(true);
                this.fTypeWaiver.notifyListeners(13, new Event());
                this.fPathPerlRegexRadio.setSelection("perl".equals(this.fWaiver.getPathRegexType()));
                this.fPathSimpleRegexRadio.setSelection("simple".equals(this.fWaiver.getPathRegexType()));
                this.fInsideMacroPathCheckBox.setSelection(((PostWaiver)this.fWaiver).isInsideMacroPath());
            }
            sb = new StringBuilder();
            WaiverStatus status = ((PostWaiver)this.fWaiver).getStatus();
            WaiverStatus[] validStatuses = WaiverStatus.getValid();
            index = 0;
            while (index < validStatuses.length) {
                if (validStatuses[index] == status) break;
                ++index;
            }
            if (index == validStatuses.length) {
                this.setErrorAction(4, true);
            }
            for (Map.Entry<String, Button> entry : this.fStatusButtons.entrySet()) {
                entry.getValue().setSelection(false);
            }
            this.fStatusButtons.get(WaiverStatus.getValid()[index].toString()).setSelection(true);
            List<String> paths = this.fWaiver.getRawPaths();
            for (String path : paths) {
                sb.append(path).append(DVTStringUtil.LINE_SEPARATOR);
            }
            this.fPathsText.setText(sb.toString());
            this.fPreWaiverPathsText.setText(sb.toString());
            sb = new StringBuilder();
            List<String> checkNames = ((PostWaiver)this.fWaiver).getCheckNames();
            for (String checkName : checkNames) {
                sb.append(checkName).append(DVTStringUtil.LINE_SEPARATOR);
            }
            this.fChecksText.setText(sb.toString());
            this.fPreWaiverChecksText.setText(sb.toString());
            sb = new StringBuilder();
            LinkedList<LineRange> lineRanges = ((PostWaiver)this.fWaiver).getLineRanges();
            for (LineRange lineRange : lineRanges) {
                sb.append(lineRange.toString()).append(DVTStringUtil.LINE_SEPARATOR);
            }
            this.fLineRangesText.setText(sb.toString());
            this.fMessagePerlRegexRadio.setSelection("perl".equals(((PostWaiver)this.fWaiver).getMessageRegexType()));
            this.fMessageSimpleRegexRadio.setSelection("simple".equals(((PostWaiver)this.fWaiver).getMessageRegexType()));
            sb = new StringBuilder();
            LinkedList<MessagePattern> messagePatterns = ((PostWaiver)this.fWaiver).getMessagePatterns();
            for (MessagePattern messagePattern : messagePatterns) {
                sb.append(messagePattern.toString()).append(DVTStringUtil.LINE_SEPARATOR);
            }
            this.fMessagePatternsText.setText(sb.toString());
            if (this.getMessage() == null || this.getMessage().isEmpty()) {
                this.checkEffectOfWaiver();
            }
            this.fElementPerlRegexRadio.setSelection("perl".equals(((PostWaiver)this.fWaiver).getElementsRegexType()));
            this.fElementSimpleRegexRadio.setSelection("simple".equals(((PostWaiver)this.fWaiver).getElementsRegexType()));
            HashMap<String, String> elements = ((PostWaiver)this.fWaiver).getElements();
            if (elements != null && !elements.isEmpty()) {
                String topNamePattern;
                String packageNamePattern;
                String interfaceNamePattern;
                String moduleNamePattern = elements.get("module");
                if (moduleNamePattern != null) {
                    this.fModuleNamePattern.setText(moduleNamePattern);
                }
                if ((interfaceNamePattern = elements.get("interface")) != null) {
                    this.fInterfaceNamePattern.setText(interfaceNamePattern);
                }
                if ((packageNamePattern = elements.get("package")) != null) {
                    this.fPackageNamePattern.setText(packageNamePattern);
                }
                if ((topNamePattern = elements.get("top")) != null) {
                    this.fTopNamePattern.setText(topNamePattern);
                }
            }
            ((StackLayout)this.fStackComposite.getLayout()).topControl = this.fWaiverFilterComposite;
            this.fStackComposite.layout();
        } else if (this.fWaiver instanceof PreWaiver) {
            sb = new StringBuilder();
            this.fTypePreWaiver.setSelection(true);
            this.fTypePreWaiver.notifyListeners(13, new Event());
            this.fPreWaiverPathPerlRegexRadio.setSelection("perl".equals(this.fWaiver.getPathRegexType()));
            this.fPreWaiverPathSimpleRegexRadio.setSelection("simple".equals(this.fWaiver.getPathRegexType()));
            List<String> paths = this.fWaiver.getRawPaths();
            for (String path : paths) {
                sb.append(path).append(DVTStringUtil.LINE_SEPARATOR);
            }
            this.fPathsText.setText(sb.toString());
            this.fPreWaiverPathsText.setText(sb.toString());
            sb = new StringBuilder();
            List<String> checkNames = ((PreWaiver)this.fWaiver).getCheckNames();
            for (String checkName : checkNames) {
                sb.append(checkName).append(DVTStringUtil.LINE_SEPARATOR);
            }
            this.fPreWaiverChecksText.setText(sb.toString());
            this.fChecksText.setText(sb.toString());
            this.fPreWaiverElementPerlRegexRadio.setSelection("perl".equals(((PreWaiver)this.fWaiver).getElementsRegexType()));
            this.fPreWaiverElementSimpleRegexRadio.setSelection("simple".equals(((PreWaiver)this.fWaiver).getElementsRegexType()));
            HashMap<String, String> elements = ((PreWaiver)this.fWaiver).getElements();
            if (elements != null && !elements.isEmpty()) {
                String topNamePattern;
                String packageNamePattern;
                String interfaceNamePattern;
                String moduleNamePattern = elements.get("module");
                if (moduleNamePattern != null) {
                    this.fPreWaiverModuleNamePattern.setText(moduleNamePattern);
                }
                if ((interfaceNamePattern = elements.get("interface")) != null) {
                    this.fPreWaiverInterfaceNamePattern.setText(interfaceNamePattern);
                }
                if ((packageNamePattern = elements.get("package")) != null) {
                    this.fPreWaiverPackageNamePattern.setText(packageNamePattern);
                }
                if ((topNamePattern = elements.get("top")) != null) {
                    this.fPreWaiverTopNamePattern.setText(topNamePattern);
                }
            }
            ((StackLayout)this.fStackComposite.getLayout()).topControl = this.fPreWaiverFilterComposite;
            this.fStackComposite.layout();
        }
    }

    private void insertFileAction() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
        String path = dialog.open();
        if (path == null || path.length() == 0) {
            return;
        }
        this.insertCommonAction(path);
    }

    private void insertDirectoryAction() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
        String path = dialog.open();
        if (path == null || path.length() == 0) {
            return;
        }
        this.insertCommonAction(path);
    }

    private void insertCommonAction(String path) {
        String waiverType = "";
        if (this.fTypeWaiver.getSelection()) {
            waiverType = "WAIVER";
        } else if (this.fTypePreWaiver.getSelection()) {
            waiverType = "PRE-WAIVER";
        }
        boolean isPerlRegex = false;
        if (waiverType.equals("WAIVER")) {
            isPerlRegex = this.fPathPerlRegexRadio.getSelection();
        } else if (waiverType.equals("PRE-WAIVER")) {
            isPerlRegex = this.fPreWaiverPathPerlRegexRadio.getSelection();
        }
        Text pathText = null;
        pathText = waiverType.equals("WAIVER") ? this.fPathsText : this.fPreWaiverPathsText;
        pathText.append(isPerlRegex ? DVTStringUtil.escapeRegex((String)path) : path);
        pathText.append(DVTStringUtil.LINE_SEPARATOR);
        DVTFileUtils.getInstance().setLastDirectory(path);
    }

    private void insertCheckNameAction() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof OVMComplianceCheck) {
                    return String.valueOf(((OVMComplianceCheck)element).getName()) + " : " + ((OVMComplianceCheck)element).getTitle();
                }
                return super.getText(element);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Choose Check Name");
        dialog.setMessage("Choose one or more check names from the list.");
        dialog.setMultipleSelection(true);
        ArrayList<OVMComplianceCheck> checks = this.fOVMProject.getChecks();
        dialog.setElements((Object[])checks.toArray(new OVMComplianceCheck[checks.size()]));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object check = objectArray[n2];
                sb.append(((OVMComplianceCheck)check).getName()).append(DVTStringUtil.LINE_SEPARATOR);
                ++n2;
            }
            String waiverType = "";
            if (this.fCodeWaiverEnabled) {
                this.fChecksText.append(sb.toString());
                return;
            }
            if (this.fTypeWaiver.getSelection()) {
                waiverType = "WAIVER";
            } else if (this.fTypePreWaiver.getSelection()) {
                waiverType = "PRE-WAIVER";
            }
            if (waiverType.equals("WAIVER")) {
                this.fChecksText.append(sb.toString());
            } else if (waiverType.equals("PRE-WAIVER")) {
                this.fPreWaiverChecksText.append(sb.toString());
            }
        }
    }

    private void setErrorAction(int error, boolean set) {
        this.setErrorAction(error, set, null);
    }

    private void setErrorAction(int error, boolean set, String additionalMessage) {
        int n = this.fErrors = set ? this.fErrors | error : this.fErrors & ~error;
        if (this.fErrors != 0) {
            StringBuilder message = new StringBuilder("Error!");
            if ((this.fErrors & 1) == 1) {
                message = new StringBuilder("Insert waiver name!");
            } else if ((this.fErrors & 2) == 2) {
                message = new StringBuilder("Line range format error (use single value or min_line:max_line)!");
            } else if ((this.fErrors & 4) == 4) {
                message = new StringBuilder("Invalid status value!");
            } else if ((this.fErrors & 0x200) == 512) {
                message = new StringBuilder("You cannot add a a single line comment on a line with a define!");
            } else if ((this.fErrors & 0x100) == 256) {
                message = new StringBuilder("You cannot add a code waiver, this line already contains a comment!");
            } else if ((this.fErrors & 0x80) == 128) {
                message = new StringBuilder("You cannot add a single line comment, this line already contains a comment!");
            } else if ((this.fErrors & 8) == 8) {
                message = new StringBuilder("Invalid message pattern!");
            } else if ((this.fErrors & 0x10) == 16) {
                message = new StringBuilder("Invalid waiver type!");
            } else if ((this.fErrors & 0x20) == 32) {
                message = new StringBuilder("Invalid path pattern!");
            } else if ((this.fErrors & 0x40) == 64) {
                message = new StringBuilder("Invalid element pattern!");
            }
            if (additionalMessage != null) {
                message.append(" ");
                message.append(additionalMessage);
            }
            this.setMessage(message.toString(), 3);
            this.getButton(0).setEnabled(false);
        } else {
            this.setMessage(null);
            this.getButton(0).setEnabled(true);
            this.checkEffectOfWaiver();
        }
    }

    private void checkEffectOfWaiver() {
        String[] lines;
        if (this.fCodeWaiverEnabled || !this.fTypeWaiver.getSelection()) {
            return;
        }
        if (!this.isDisableCheckWaiver()) {
            this.setMessage(null);
            return;
        }
        WaiversModel waiversModel = this.fOVMProject.getProjectWaivers();
        String file = this.fWaiverFileCombo.getText();
        LinkedList<PostWaiver> waivers = new LinkedList<PostWaiver>();
        if (waiversModel.getPostWaivers() != null) {
            waivers.addAll(waiversModel.getPostWaivers());
        }
        HashSet<String> disabledChecks = new HashSet<String>();
        String content = this.fChecksText.getText();
        String[] stringArray = lines = lineSepPattern.split(content);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() > 0) {
                disabledChecks.add(line.trim());
            }
            ++n2;
        }
        boolean showWarning = false;
        boolean applyOnMatched = false;
        String applyOn = this.getApplyOnStatus(true);
        if (applyOn.equals("matched")) {
            applyOnMatched = true;
        }
        if (this.fPreviousWaiver != null) {
            if (file != null && !file.equals(this.fPreviousWaiver.getFilePath())) {
                waivers.remove(this.fPreviousWaiver);
                iterator = waivers.descendingIterator();
                while (iterator.hasNext()) {
                    PostWaiver waiver = (PostWaiver)iterator.next();
                    if (!(waiver.getFilePath().equals(file) || this.isFileAfter(waiversModel.getWaiverFiles(), file, waiver.getFilePath()) || (showWarning = this.compareWaiver(disabledChecks, applyOnMatched, waiver)))) {
                        continue;
                    }
                    break;
                }
            } else {
                iterator = waivers.descendingIterator();
                while (iterator.hasNext()) {
                    PostWaiver waiver = (PostWaiver)iterator.next();
                    if (!waiver.equals(this.fPreviousWaiver) && !(showWarning = this.compareWaiver(disabledChecks, applyOnMatched, waiver))) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            iterator = waivers.descendingIterator();
            while (iterator.hasNext()) {
                PostWaiver waiver = (PostWaiver)iterator.next();
                if (!(file.equals(waiver.getFilePath()) || this.isFileAfter(waiversModel.getWaiverFiles(), file, waiver.getFilePath()) || (showWarning = this.compareWaiver(disabledChecks, applyOnMatched, waiver)))) {
                    continue;
                }
                break;
            }
        }
        if (showWarning) {
            this.setWarningAction();
        } else {
            this.setMessage(null);
        }
    }

    private boolean compareWaiver(Set<String> disabledChecks, boolean applyOnMatched, PostWaiver waiver) {
        return applyOnMatched && waiver.getApplyOn().equals("matched") ? !Collections.disjoint(waiver.getCheckNames(), disabledChecks) && waiver.getStatus() != WaiverStatus.DISABLE : applyOnMatched != waiver.getApplyOn().equals("matched") && (!disabledChecks.containsAll(waiver.getCheckNames()) || !waiver.getCheckNames().containsAll(disabledChecks)) && waiver.getStatus() != WaiverStatus.DISABLE;
    }

    private boolean isFileAfter(Set<String> waiverFiles, String currentFile, String waiverfile) {
        String lastFound = "";
        for (String file : waiverFiles) {
            if (file.equals(currentFile)) {
                lastFound = currentFile;
                break;
            }
            if (!file.equals(waiverfile)) continue;
            lastFound = waiverfile;
            break;
        }
        if (lastFound.equals(currentFile)) {
            return true;
        }
        if (lastFound.equals(waiverfile)) {
            return false;
        }
        return false;
    }

    private boolean isDisableCheckWaiver() {
        String path = this.fPathsText.getText();
        String lineRanges = this.fLineRangesText.getText();
        String messagePatterns = this.fMessagePatternsText.getText();
        String checkNames = this.fChecksText.getText();
        return path.trim().isEmpty() && lineRanges.trim().isEmpty() && messagePatterns.trim().isEmpty() && !checkNames.isEmpty() && this.fStatusButtons.get(WaiverStatus.DISABLE.toString()).getSelection();
    }

    private void setWarningAction() {
        this.setMessage("This waiver will not fully disable the specified checks because there are other waivers defined after it that might re-enable its failures.", 2);
    }

    private void checkIfCommentExists() {
        try {
            String path = this.fWaiver.getPaths().get(0);
            ParserPath parserPath = new ParserPath(path);
            IDocument document = this.fDocumentManager.getDocument(parserPath, this.fOVMProject.getProject());
            int line = ((PostWaiver)this.fWaiver).getLineRanges().get(0).getStartLine();
            int offset = DVTDocumentUtils.convertLineToOffset((IDocument)document, (int)line);
            int commentOffset = DVTFileUtils.getInstance().getCommentOffset(this.fOVMProject.getProject(), document, path, line);
            if (commentOffset != -1) {
                offset += commentOffset;
            }
            ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__vlog_partitioning", offset, false);
            String contentType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset, false);
            boolean set = "SINGLE LINE".equals(this.getCommentType()) && (contentType.equals("__vlog_sl_comment") || contentType.equals("__vlog_ml_comment"));
            boolean invalidCodeWaiver = false;
            if (contentType.equals("__vlog_ml_comment")) {
                int partitionCommentOffset = partition.getOffset();
                int currentLineOffset = DVTDocumentUtils.convertLineToOffset((IDocument)document, (int)line);
                if (commentOffset != -1) {
                    currentLineOffset += commentOffset;
                }
                if (currentLineOffset - partitionCommentOffset > 0) {
                    set = true;
                    invalidCodeWaiver = true;
                }
            }
            this.setErrorAction(128, set);
            this.setErrorAction(256, set && invalidCodeWaiver);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    private void checkIfMacroExists() {
        try {
            boolean macroExistsOnLine;
            String path = this.fWaiver.getPaths().get(0);
            ParserPath parserPath = new ParserPath(path);
            IDocument document = this.fDocumentManager.getDocument(parserPath, this.fOVMProject.getProject());
            int line = ((PostWaiver)this.fWaiver).getLineRanges().get(0).getStartLine();
            this.fDefineOnLine = macroExistsOnLine = DVTFileUtils.getInstance().checkIfMacroExists(this.fOVMProject.getProject(), document, path, line);
            boolean isSingleLineComment = "SINGLE LINE".equals(this.getCommentType());
            boolean set = false;
            if (isSingleLineComment && macroExistsOnLine) {
                set = true;
            }
            this.setErrorAction(512, set);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    public boolean isDefineOnLine() {
        return this.fDefineOnLine;
    }

    IWaiver getWaiver() {
        return this.fWaiver;
    }
}

