/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.ui.WaiverItem;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.MessagePattern;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiversModel;

public class WaiverTreeContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement == null) {
            return new WaiverItem[0];
        }
        if (parentElement instanceof PostWaiver) {
            ArrayList<WaiverItem> result = new ArrayList<WaiverItem>();
            PostWaiver waiver = (PostWaiver)parentElement;
            WaiverItem waiverType = new WaiverItem();
            waiverType.columnText0 = "Waiver Type";
            waiverType.columnText1 = "WAIVER";
            result.add(waiverType);
            WaiverItem statusItem = new WaiverItem();
            statusItem.columnText0 = "Status";
            statusItem.columnText1 = waiver.getStatus().toString();
            result.add(statusItem);
            WaiverItem applyOnItem = new WaiverItem();
            applyOnItem.columnText0 = "Apply On";
            applyOnItem.columnText1 = waiver.getApplyOn().toUpperCase();
            result.add(applyOnItem);
            WaiverItem checkNamesItem = new WaiverItem();
            checkNamesItem.columnText0 = "Check Names";
            checkNamesItem.checkNames = waiver.getCheckNames();
            result.add(checkNamesItem);
            WaiverItem pathsItem = new WaiverItem();
            pathsItem.columnText0 = "Paths";
            pathsItem.paths = waiver.getRawPaths();
            pathsItem.pathsApplyOn = waiver.getPathsApplyOn();
            result.add(pathsItem);
            WaiverItem elementsItem = new WaiverItem();
            elementsItem.columnText0 = "Elements";
            elementsItem.elements = waiver.getElements();
            result.add(elementsItem);
            WaiverItem lineRangesItem = new WaiverItem();
            lineRangesItem.columnText0 = "Line Ranges";
            lineRangesItem.lineRanges = waiver.getLineRanges();
            result.add(lineRangesItem);
            WaiverItem messagePatternsItem = new WaiverItem();
            messagePatternsItem.columnText0 = "Message Patterns";
            messagePatternsItem.messagePatterns = waiver.getMessagePatterns();
            result.add(messagePatternsItem);
            WaiverItem waiverFile = new WaiverItem();
            waiverFile.columnText0 = "Waiver File";
            waiverFile.columnText1 = waiver.getFilePath();
            result.add(waiverFile);
            WaiverItem waivedFailures = new WaiverItem();
            waivedFailures.columnText0 = "Waived Failures";
            waivedFailures.waivedFailures = waiver.getWaivedFailures();
            result.add(waivedFailures);
            return result.toArray();
        }
        if (parentElement instanceof PreWaiver) {
            ArrayList<WaiverItem> result = new ArrayList<WaiverItem>();
            PreWaiver waiver = (PreWaiver)parentElement;
            WaiverItem waiverType = new WaiverItem();
            waiverType.columnText0 = "Waiver Type";
            waiverType.columnText1 = "PRE-WAIVER";
            result.add(waiverType);
            WaiverItem applyOnItem = new WaiverItem();
            applyOnItem.columnText0 = "Apply On";
            applyOnItem.columnText1 = waiver.getApplyOn().toUpperCase();
            result.add(applyOnItem);
            WaiverItem checkNamesItem = new WaiverItem();
            checkNamesItem.columnText0 = "Check Names";
            checkNamesItem.checkNames = waiver.getCheckNames();
            result.add(checkNamesItem);
            WaiverItem pathsItem = new WaiverItem();
            pathsItem.columnText0 = "Paths";
            pathsItem.paths = waiver.getRawPaths();
            pathsItem.pathsApplyOn = waiver.getPathsApplyOn();
            result.add(pathsItem);
            WaiverItem elementsItem = new WaiverItem();
            elementsItem.columnText0 = "Elements";
            elementsItem.elements = waiver.getElements();
            result.add(elementsItem);
            WaiverItem waiverFile = new WaiverItem();
            waiverFile.columnText0 = "Waiver File";
            waiverFile.columnText1 = waiver.getFilePath();
            result.add(waiverFile);
            return result.toArray();
        }
        if (parentElement instanceof WaiverItem) {
            WaiverItem waiverItem = (WaiverItem)parentElement;
            if (waiverItem.paths != null) {
                List<String> paths = waiverItem.paths;
                ArrayList<WaiverItem> result = new ArrayList<WaiverItem>();
                WaiverItem pathsApplyOnItem = new WaiverItem();
                pathsApplyOnItem.columnText0 = "Apply on";
                pathsApplyOnItem.columnText1 = waiverItem.pathsApplyOn != null && !"".equals(waiverItem.pathsApplyOn) ? waiverItem.pathsApplyOn.toUpperCase() : "matched".toUpperCase();
                result.add(pathsApplyOnItem);
                for (String path : paths) {
                    WaiverItem item = new WaiverItem();
                    item.columnText0 = "Path";
                    item.columnText1 = path;
                    result.add(item);
                }
                return result.toArray();
            }
            if (waiverItem.elements != null) {
                Map<String, String> elements = waiverItem.elements;
                ArrayList<WaiverItem> result = new ArrayList<WaiverItem>();
                for (Map.Entry<String, String> entry : elements.entrySet()) {
                    WaiverItem item = new WaiverItem();
                    item.columnText0 = entry.getKey();
                    item.columnText1 = entry.getValue();
                    result.add(item);
                }
                return result.toArray();
            }
            if (waiverItem.checkNames != null) {
                List<String> checkNames = waiverItem.checkNames;
                ArrayList<WaiverItem> result = new ArrayList<WaiverItem>();
                for (String checkName : checkNames) {
                    WaiverItem item = new WaiverItem();
                    item.columnText0 = "Check Name";
                    item.columnText1 = checkName;
                    result.add(item);
                }
                return result.toArray();
            }
            if (waiverItem.lineRanges != null) {
                List<LineRange> lineRanges = waiverItem.lineRanges;
                ArrayList<WaiverItem> result = new ArrayList<WaiverItem>();
                for (LineRange lineRange : lineRanges) {
                    WaiverItem item = new WaiverItem();
                    item.columnText0 = "Line Range";
                    item.columnText1 = lineRange.toString();
                    result.add(item);
                }
                return result.toArray();
            }
            if (waiverItem.messagePatterns != null) {
                List<MessagePattern> messagePatterns = waiverItem.messagePatterns;
                ArrayList<WaiverItem> result = new ArrayList<WaiverItem>();
                for (MessagePattern messagePattern : messagePatterns) {
                    WaiverItem item = new WaiverItem();
                    item.columnText0 = "Message Pattern";
                    item.columnText1 = messagePattern.toString();
                    result.add(item);
                }
                return result.toArray();
            }
            if (waiverItem.waivedFailures != null) {
                List<OVMComplianceCheckHit> waivedFailures = waiverItem.waivedFailures;
                ArrayList<WaiverItem> result = new ArrayList<WaiverItem>();
                for (OVMComplianceCheckHit failure : waivedFailures) {
                    WaiverItem item = new WaiverItem();
                    item.columnText0 = String.valueOf(failure.getShortFileNameAndMacroPath()) + "@" + failure.getLine();
                    item.columnText1 = failure.getDetails();
                    result.add(item);
                }
                return result.toArray();
            }
        }
        return new WaiverItem[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IWaiver) {
            return true;
        }
        if (element instanceof WaiverItem) {
            WaiverItem waiverItem = (WaiverItem)element;
            if (waiverItem.paths != null) {
                return !waiverItem.paths.isEmpty();
            }
            if (waiverItem.elements != null) {
                return waiverItem.elements.size() > 0;
            }
            if (waiverItem.checkNames != null) {
                return !waiverItem.checkNames.isEmpty();
            }
            if (waiverItem.lineRanges != null) {
                return !waiverItem.lineRanges.isEmpty();
            }
            if (waiverItem.messagePatterns != null) {
                return !waiverItem.messagePatterns.isEmpty();
            }
            if (waiverItem.waivedFailures != null) {
                return !waiverItem.waivedFailures.isEmpty();
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            return new Object[0];
        }
        WaiversModel waiversModel = (WaiversModel)inputElement;
        List<PostWaiver> postWaivers = waiversModel.getPostWaivers();
        List<PreWaiver> preWaivers = waiversModel.getPreWaivers();
        ArrayList<IWaiver> result = new ArrayList<IWaiver>();
        if (postWaivers != null) {
            result.addAll(postWaivers);
        }
        if (preWaivers != null) {
            result.addAll(preWaivers);
        }
        return result.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

