/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.vlogdt.linter.ui.FontFactory;
import ro.amiq.vlogdt.linter.ui.IReportUpdateListener;
import ro.amiq.vlogdt.linter.ui.IWaiversChangeListener;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.linter.ui.OVMComplianceChecksUtilUI;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReport;
import ro.amiq.vlogdt.linter.ui.WaiverDialog;
import ro.amiq.vlogdt.linter.ui.WaiverFileValidator;
import ro.amiq.vlogdt.linter.ui.WaiverItem;
import ro.amiq.vlogdt.linter.ui.WaiverTreeContentProvider;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.linter.waivers.WaiversModel;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class WaiversEditor
extends Composite
implements IReportUpdateListener {
    private FontFactory fFontFactory;
    private Color fBackgroundColor;
    private Button fCollapseAllButton;
    private Button fExpandAllButton;
    private Button fNewButton;
    private Button fDuplicateButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private IProject fProject;
    private OVMComplianceReport fComplianceReport;
    private boolean fWaivedFailuresOutOfSync;
    private WaiversModel fWaiversModel;
    private final LinkedList<IWaiversChangeListener> fWaiversChangeListeners;
    private TreeViewer fTree;

    public WaiversEditor(Composite parent, int style, IProject project, OVMComplianceReport complianceReport) {
        super(parent, style);
        this.fProject = project;
        this.fComplianceReport = complianceReport;
        this.fWaiversChangeListeners = new LinkedList();
        this.fBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoBackgroundColor());
        this.fFontFactory = new FontFactory(parent.getDisplay());
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        Composite titleComposite = new Composite((Composite)this, 0);
        titleComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        titleComposite.setLayout((Layout)new GridLayout(1, true));
        DVTColorUtil.INSTANCE.setBackground((Control)titleComposite, this.fBackgroundColor, true);
        Composite subTitleComposite = new Composite(titleComposite, 0);
        subTitleComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        subTitleComposite.setLayout((Layout)new GridLayout(2, true));
        DVTColorUtil.INSTANCE.setBackground((Control)subTitleComposite, this.fBackgroundColor, true);
        Label titleLabel = new Label(subTitleComposite, 64);
        titleLabel.setLayoutData((Object)new GridData(0, 0x1000000, false, false, 1, 1));
        titleLabel.setFont(this.fFontFactory.createFont("title", 18, 1));
        titleLabel.setText("Waivers");
        DVTColorUtil.INSTANCE.setBackground((Control)titleLabel, this.fBackgroundColor, true);
        Composite container = new Composite((Composite)this, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        DVTColorUtil.INSTANCE.setBackground((Control)container, this.fBackgroundColor, true);
        this.fTree = new TreeViewer(container, 67588);
        this.fTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 7));
        this.fTree.setContentProvider((IContentProvider)new WaiverTreeContentProvider());
        this.fTree.getTree().setHeaderVisible(true);
        this.fTree.getTree().setLinesVisible(true);
        TreeViewerColumn column = new TreeViewerColumn(this.fTree, 16384);
        column.getColumn().setWidth(300);
        column.getColumn().setText("Name");
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof PostWaiver) {
                    PostWaiver waiver = (PostWaiver)element;
                    if (WaiversEditor.this.fWaivedFailuresOutOfSync) {
                        cell.setText(String.valueOf(waiver.getName()) + " [?]");
                    } else {
                        cell.setText(String.valueOf(waiver.getName()) + " [" + waiver.getWaivedFailures().size() + "]");
                    }
                    cell.setImage(OVMComplianceChecksUtilUI.getImage(waiver.getStatus()));
                } else if (element instanceof PreWaiver) {
                    PreWaiver waiver = (PreWaiver)element;
                    cell.setText(waiver.getName());
                    cell.setImage(DVTImages.imageCache.getImage(DVTImages.PREWAIVER));
                } else if (element instanceof WaiverItem) {
                    WaiverItem waiverItem = (WaiverItem)element;
                    cell.setText(waiverItem.columnText0);
                }
            }
        });
        column = new TreeViewerColumn(this.fTree, 16384);
        column.getColumn().setWidth(300);
        column.getColumn().setText("Description");
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof PostWaiver) {
                    PostWaiver waiver = (PostWaiver)element;
                    cell.setText(waiver.getDescription());
                } else if (element instanceof PreWaiver) {
                    PreWaiver waiver = (PreWaiver)element;
                    cell.setText(waiver.getDescription());
                } else if (element instanceof WaiverItem) {
                    WaiverItem waiverItem = (WaiverItem)element;
                    cell.setText(waiverItem.columnText1);
                }
            }
        });
        this.fExpandAllButton = new Button(container, 8);
        this.fExpandAllButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fExpandAllButton.setText("Expand All");
        this.fCollapseAllButton = new Button(container, 8);
        this.fCollapseAllButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fCollapseAllButton.setText("Collapse All");
        Label separator = new Label(container, 258);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.verticalIndent = 20;
        separator.setLayoutData((Object)gd);
        this.fNewButton = new Button(container, 8);
        gd = new GridData(4, 128, false, false);
        gd.verticalIndent = 20;
        this.fNewButton.setLayoutData((Object)gd);
        this.fNewButton.setText("New...");
        this.fDuplicateButton = new Button(container, 8);
        this.fDuplicateButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fDuplicateButton.setText("Duplicate...");
        this.fEditButton = new Button(container, 8);
        this.fEditButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fEditButton.setText("Edit...");
        this.fRemoveButton = new Button(container, 8);
        this.fRemoveButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fRemoveButton.setText("Remove");
        this.addWidgetListeners();
        this.setButtonsEnable(false);
    }

    private void addWidgetListeners() {
        this.fTree.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IWaiver selection = WaiversEditor.this.getSelection();
                WaiversEditor.this.setButtonsEnable(selection != null && selection.getType() == WaiverType.FILE);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fTree.getTree().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                WaiversEditor.this.editAction();
            }
        });
        this.fExpandAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiversEditor.this.fTree.expandAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fCollapseAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiversEditor.this.fTree.collapseAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fNewButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiversEditor.this.newAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fDuplicateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiversEditor.this.duplicateAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fEditButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiversEditor.this.editAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaiversEditor.this.removeAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void setInput(WaiversModel waiversModel) {
        Assert.isNotNull((Object)waiversModel);
        this.fWaiversModel = waiversModel;
        this.fTree.setInput((Object)this.fWaiversModel);
    }

    public void setWaivedFailuresOutOfSync(boolean waivedFailuresOutOfSync) {
        this.fWaivedFailuresOutOfSync = waivedFailuresOutOfSync;
    }

    public void dispose() {
        this.fWaiversChangeListeners.clear();
        if (this.fFontFactory != null) {
            this.fFontFactory.dispose();
        }
        super.dispose();
    }

    private void newAction() {
        if (this.fWaiversModel.hasOnlyReadOnlyWaiverFiles()) {
            MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)"All waiver files are read-only.", (String)"The existing waiver files are all read-only. You cannot add new waivers");
            return;
        }
        WaiverDialog dialog = new WaiverDialog(this.getShell(), this.fWaiversModel.getProject());
        if (dialog.open() == 0) {
            IWaiver waiver = dialog.getWaiver();
            if (WaiverFileValidator.INSTANCE.validate(this.fWaiversModel.getProject().getProject(), waiver.getFilePath())) {
                this.fWaiversModel.addWaiver(waiver);
                this.fTree.add(this.fTree.getTree().getData(), (Object)waiver);
                this.fTree.setSelection((ISelection)new StructuredSelection((Object)waiver));
                this.setButtonsEnable(true);
                this.fWaiversModel.save();
                this.fWaiversModel.load();
                if (waiver instanceof PostWaiver) {
                    this.notifyChangeListeners(true);
                } else if (waiver instanceof PreWaiver) {
                    this.notifyChangeListeners(false);
                }
                if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                    return;
                }
                try {
                    this.fWaiversModel.reapplyWaivers(waiver);
                    this.fComplianceReport.updateListeners();
                    LintingProblemsManager.getInstance().updateMarkersAfterWaivers(this.fProject);
                }
                finally {
                    DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                }
            }
        }
    }

    private void duplicateAction() {
        IWaiver selectedWaiver = this.getSelection();
        if (selectedWaiver == null) {
            return;
        }
        if (this.fWaiversModel.hasOnlyReadOnlyWaiverFiles()) {
            MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)"All waiver files are read-only", (String)"The existing waiver files are all read-only. You cannot duplicate any waiver");
            return;
        }
        IWaiver waiver = null;
        if (selectedWaiver instanceof PreWaiver) {
            waiver = ((PreWaiver)selectedWaiver).clone();
        } else if (selectedWaiver instanceof PostWaiver) {
            waiver = ((PostWaiver)selectedWaiver).clone();
        }
        if (waiver == null) {
            return;
        }
        waiver.setName("Copy of " + waiver.getName());
        WaiverDialog dialog = new WaiverDialog(this.getShell(), this.fWaiversModel.getProject());
        dialog.setInput(waiver);
        if (dialog.open() == 0) {
            IWaiver waiverResult = dialog.getWaiver();
            waiverResult.setLineNoInXMLFile(-1);
            if (WaiverFileValidator.INSTANCE.validate(this.fWaiversModel.getProject().getProject(), waiverResult.getFilePath())) {
                this.fWaiversModel.addWaiver(waiverResult);
                this.fTree.add(this.fTree.getTree().getData(), (Object)waiverResult);
                this.fTree.setSelection((ISelection)new StructuredSelection((Object)waiverResult));
                this.fWaiversModel.save();
                this.fWaiversModel.load();
                if (waiver instanceof PostWaiver) {
                    this.notifyChangeListeners(true);
                } else if (waiver instanceof PreWaiver) {
                    this.notifyChangeListeners(false);
                }
                if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                    return;
                }
                try {
                    this.fWaiversModel.reapplyWaivers(waiver);
                    this.fComplianceReport.updateListeners();
                    LintingProblemsManager.getInstance().updateMarkersAfterWaivers(this.fProject);
                }
                finally {
                    DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                }
            }
        }
    }

    private void editAction() {
        File file;
        IWaiver waiver = this.getSelection();
        if (waiver == null) {
            return;
        }
        String filePath = waiver.getFilePath();
        if (filePath != null && !(file = new File(filePath)).canWrite()) {
            MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)"The waiver file cannot be edited", (String)"The waiver you are trying to edit is in a read-only file. You cannot edit it.");
            return;
        }
        if (waiver.getType() == WaiverType.FILE) {
            WaiverDialog dialog = new WaiverDialog(this.getShell(), this.fWaiversModel.getProject(), false, false, null, null, waiver);
            dialog.setInput(waiver);
            if (dialog.open() == 0) {
                IWaiver newWaiver = dialog.getWaiver();
                String newFilePath = newWaiver.getFilePath();
                if (WaiverFileValidator.INSTANCE.validate(this.fWaiversModel.getProject().getProject(), newWaiver.getFilePath())) {
                    if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                        return;
                    }
                    try {
                        this.fWaiversModel.reapplyWaivers(waiver);
                        this.fWaiversModel.changedWaiver(newWaiver);
                        if (filePath != null && !filePath.equals(newWaiver.getFilePath()) || waiver.getClass() != newWaiver.getClass()) {
                            waiver.setFilePath(filePath);
                            this.fWaiversModel.removeWaiver(waiver);
                            newWaiver.setFilePath(newFilePath);
                            this.fWaiversModel.addWaiver(newWaiver);
                            this.fTree.add(this.fTree.getTree().getData(), (Object)newWaiver);
                            this.fTree.setSelection((ISelection)new StructuredSelection((Object)newWaiver));
                        }
                        this.fWaiversModel.save();
                        this.fWaiversModel.load();
                        this.fTree.refresh();
                        this.fWaiversModel.reapplyWaivers(newWaiver);
                        if (newWaiver instanceof PreWaiver || waiver instanceof PreWaiver) {
                            this.notifyChangeListeners(false);
                        } else {
                            this.notifyChangeListeners(true);
                        }
                        LintingProblemsManager.getInstance().updateMarkersAfterWaivers(this.fProject);
                    }
                    finally {
                        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                    }
                }
            }
        } else if ((waiver.getType() == WaiverType.PRAGMA || waiver.getType() == WaiverType.UVMF_CUSTOM_PRAGMA) && waiver instanceof PostWaiver) {
            String fileName = waiver.getPaths().get(0);
            int line = ((PostWaiver)waiver).getLineRanges().get(0).getStartLine();
            File file2 = new File(fileName);
            if (file2.isFile() && file2.canRead()) {
                VlogFileUtils.getInstance().openFile(this.fWaiversModel.getProject().getProject(), fileName, line);
            }
        }
    }

    private void removeAction() {
        File file;
        IWaiver selection = this.getSelection();
        IWaiver waiver = selection;
        if (waiver == null) {
            return;
        }
        String filePath = waiver.getFilePath();
        if (filePath != null && !(file = new File(filePath)).canWrite()) {
            MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)"The waiver file cannot be removed", (String)"The waiver you are trying to remove is in a read-only file.");
            return;
        }
        if (!WaiverFileValidator.INSTANCE.validate(this.fWaiversModel.getProject().getProject(), waiver.getFilePath())) {
            return;
        }
        this.fWaiversModel.removeWaiver(waiver);
        IWaiver next = this.getNextSelected(waiver);
        this.fTree.remove((Object)waiver);
        if (next == null) {
            this.setButtonsEnable(false);
        } else {
            this.fTree.setSelection((ISelection)new StructuredSelection((Object)next));
            this.setButtonsEnable(selection != null && selection.getType() == WaiverType.FILE);
        }
        this.fWaiversModel.save();
        this.fWaiversModel.load();
        if (waiver instanceof PostWaiver) {
            this.notifyChangeListeners(true);
        } else if (waiver instanceof PreWaiver) {
            this.notifyChangeListeners(false);
        }
        this.fWaiversModel.reapplyWaivers(waiver);
        LintingProblemsManager.getInstance().updateMarkersAfterWaivers(this.fProject);
    }

    private IWaiver getSelection() {
        TreeItem[] selection = this.fTree.getTree().getSelection();
        if (selection.length > 0) {
            TreeItem element = selection[0];
            TreeItem prevElement = null;
            while (element != null) {
                prevElement = element;
                element = element.getParentItem();
            }
            if (prevElement == null) {
                return null;
            }
            Object data = prevElement.getData();
            if (data instanceof PostWaiver) {
                return (PostWaiver)data;
            }
            if (data instanceof PreWaiver) {
                return (PreWaiver)data;
            }
        }
        return null;
    }

    private IWaiver getNextSelected(IWaiver selection) {
        TreeItem[] items = this.fTree.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() == selection) {
                Object waiver = null;
                if (i + 1 < items.length) {
                    waiver = items[i + 1].getData();
                } else if (i - 1 >= 0) {
                    waiver = items[i - 1].getData();
                } else {
                    return null;
                }
                if (waiver instanceof PostWaiver) {
                    return (PostWaiver)waiver;
                }
                if (waiver instanceof PreWaiver) {
                    return (PreWaiver)waiver;
                }
            }
            ++i;
        }
        return null;
    }

    private void setButtonsEnable(boolean enable) {
        this.fRemoveButton.setEnabled(enable);
        this.fDuplicateButton.setEnabled(enable);
        this.fEditButton.setEnabled(enable);
    }

    @Override
    public void reportUpdate() {
        this.fTree.setInput((Object)this.fWaiversModel);
    }

    private void notifyChangeListeners(boolean isPostWaiver) {
        for (IWaiversChangeListener listener : this.fWaiversChangeListeners) {
            listener.waiversChanged(isPostWaiver);
        }
    }

    public void addChangeListener(IWaiversChangeListener listener) {
        if (listener != null) {
            this.fWaiversChangeListeners.add(listener);
        }
    }

    public void removeChangeListener(IWaiversChangeListener listener) {
        if (listener != null) {
            this.fWaiversChangeListeners.remove(listener);
        }
    }
}

