/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReport;
import ro.amiq.vlogdt.linter.ui.WaiverDialog;
import ro.amiq.vlogdt.linter.ui.WaiverFileValidator;
import ro.amiq.vlogdt.linter.ui.WaiversUtils;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;

public class WaiversManager {
    private static WaiversManager fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaiversManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new WaiversManager();
            }
        }
        return fInstance;
    }

    public void addWaiver(OVMComplianceCheckHit hit) {
        if (hit == null) {
            return;
        }
        OVMProject ovmProject = hit.getCheck().getOVMProject();
        if (!this.checkReadOnlyWaiverFiles(ovmProject)) {
            return;
        }
        WaiverDialog dialog = this.createWaiverDialog(hit, ovmProject);
        IProject project = ovmProject.getProject();
        if (dialog.open() == 0) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                IWaiver waiverResult = dialog.getWaiver();
                if (WaiverFileValidator.INSTANCE.validate(project, waiverResult.getFilePath())) {
                    ovmProject.getProjectWaivers().addWaiver(waiverResult);
                    ovmProject.getProjectWaivers().save();
                    ovmProject.getProjectWaivers().load();
                    if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                        return;
                    }
                    try {
                        if (waiverResult instanceof PostWaiver) {
                            this.reapplyWaivers((PostWaiver)waiverResult, ovmProject);
                        } else if (waiverResult instanceof PreWaiver) {
                            hit.getCheck().reapplyWaivers();
                        }
                        if (ovmProject.lintProject()) {
                            IEditorReference[] references;
                            IWorkbench workbench = PlatformUI.getWorkbench();
                            IEditorReference[] iEditorReferenceArray = references = workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                            int n = references.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IEditorReference reference = iEditorReferenceArray[n2];
                                IEditorPart editor = reference.getEditor(false);
                                if (editor != null && editor instanceof OVMComplianceReport && project.equals((Object)((OVMComplianceReport)editor).getProject())) {
                                    ((OVMComplianceReport)editor).notifyWaiversChangedListeners(waiverResult instanceof PostWaiver);
                                }
                                ++n2;
                            }
                        }
                        LintingProblemsManager.getInstance().updateMarkersAfterWaivers(project);
                    }
                    finally {
                        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                    }
                }
            });
        }
    }

    public WaiverDialog createWaiverDialog(OVMComplianceCheckHit hit, OVMProject ovmProject) {
        PostWaiver waiver = WaiversUtils.INSTANCE.createHitPostWaiver(hit.getCheck().getName(), hit.getParserPath().path, hit.getLine(), hit.getDetails());
        WaiverDialog dialog = new WaiverDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ovmProject, false, false, hit.getParserPath().path, hit.getDetails(), null);
        dialog.setInput(waiver);
        return dialog;
    }

    public void reapplyWaivers(PostWaiver waiver, OVMProject ovmProject) {
        List<String> checkNames = waiver.getCheckNames();
        if (checkNames == null || checkNames.isEmpty()) {
            for (OVMComplianceCheck check : ovmProject.getChecks()) {
                check.reapplyWaivers();
            }
        } else {
            for (String waiverCheckName : checkNames) {
                OVMComplianceCheck check = ovmProject.getCheck(waiverCheckName);
                if (check == null) continue;
                check.reapplyWaivers();
            }
        }
    }

    public boolean checkReadOnlyWaiverFiles(OVMProject ovmProject) {
        if (ovmProject.getProjectWaivers().hasOnlyReadOnlyWaiverFiles()) {
            this.openReadOnlyWarningDialog();
            return false;
        }
        return true;
    }

    private void openReadOnlyWarningDialog() {
        MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)"All waiver files are read-only", (String)"The existing waiver files are all read-only. You cannot add new waivers.");
    }
}

