/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.io.File;
import java.util.List;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.MessagePattern;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;

public enum WaiversUtils {
    INSTANCE;


    public PostWaiver createHitPostWaiver(String checkName, String hitPath, int hitLine, String hitDetails) {
        PostWaiver waiver = new PostWaiver();
        waiver.setStatus(WaiverStatus.DISABLE);
        waiver.addCheckName(checkName);
        String path = DVTStringUtil.intern((String)DVTStringUtil.escapeRegex((String)hitPath));
        waiver.addRawPath(path);
        waiver.addPath(path);
        waiver.addLineRange(new LineRange(hitLine, hitLine));
        waiver.addMessagePattern(new MessagePattern(hitDetails));
        waiver.setRegexType("perl");
        String fileName = new File(waiver.getPaths().get(0)).getName();
        waiver.setName(String.valueOf(checkName) + " @" + fileName + "-" + hitLine);
        waiver.setDescription("Check " + checkName + " in file " + fileName + " at line " + hitLine + " is DISABLED");
        return waiver;
    }

    public PostWaiver createPragmaPostWaiver(String checkName, String hitPath, int hitLine) {
        PostWaiver waiver = new PostWaiver();
        waiver.setType(WaiverType.PRAGMA);
        waiver.setStatus(WaiverStatus.DISABLE);
        waiver.addCheckName(checkName);
        waiver.addRawPath(hitPath);
        waiver.addPath(hitPath);
        waiver.addLineRange(new LineRange(hitLine, hitLine));
        waiver.setName("Generated Code Waiver");
        waiver.setPathRegexType("simple");
        return waiver;
    }

    public PostWaiver createCheckPostWaiver(String checkName) {
        PostWaiver postWaiver = new PostWaiver();
        postWaiver.setStatus(WaiverStatus.DISABLE);
        postWaiver.addCheckName(checkName);
        postWaiver.setName(checkName);
        postWaiver.setDescription("Check " + checkName + " DISABLED");
        return postWaiver;
    }

    public String computeWaiverComment(PostWaiver waiver) {
        StringBuilder sb = new StringBuilder();
        sb.append("@DVT_LINTER_WAIVER \"").append(waiver.getName()).append("\" ").append(waiver.getStatus().toString());
        List<String> checkNames = waiver.getCheckNames();
        if (!checkNames.isEmpty()) {
            sb.append(' ');
            for (String checkName : checkNames) {
                sb.append(checkName).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean isUselessInlineWaiver(OVMComplianceCheckHit hit, OVMProject ovmProject) {
        WaiverStatus status = ovmProject.getProjectWaivers().getStatus(hit);
        return status != null && status != WaiverStatus.NONE;
    }
}

