/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import ro.amiq.dvt.startup.core.DVTLogger;

public class IndentParser {
    private static final int INDENT_SIZE = 2;
    private static final char TT_STRING_DELIM = '\"';
    private static final char TT_SPACE = ' ';
    private static final HashMap<String, String[]> BLOCKS = new HashMap();
    private static final HashMap<String, String[]> ESCAPE_WORDS;
    private static final HashSet<String> ONE_LINE_BLOCK;
    private final File fFile;
    private LinkedList<Integer> fBadIndentationLines;
    private LinkedList<String> fOpenWordsStack;
    private HashSet<String> fLastWords;
    private int fCurrentIndentSpaces;
    private int fLevelDelta;
    private int fExpectedLevel;
    private boolean fIsFristWordClose;
    private int fWordNumber;
    private int fCloseDelta;

    static {
        BLOCKS.put("{", new String[]{"}"});
        BLOCKS.put("(", new String[]{")"});
        BLOCKS.put("begin", new String[]{"end"});
        BLOCKS.put("class", new String[]{"endclass"});
        BLOCKS.put("module", new String[]{"endmodule"});
        BLOCKS.put("macromodule", new String[]{"endmodule"});
        BLOCKS.put("interface", new String[]{"endinterface"});
        BLOCKS.put("program", new String[]{"endprogram"});
        BLOCKS.put("checker", new String[]{"endchecker"});
        BLOCKS.put("clocking", new String[]{"endclocking"});
        BLOCKS.put("config", new String[]{"endconfig"});
        BLOCKS.put("function", new String[]{"endfunction"});
        BLOCKS.put("task", new String[]{"endtask"});
        BLOCKS.put("generate", new String[]{"endgenerate"});
        BLOCKS.put("group", new String[]{"endgroup"});
        BLOCKS.put("package", new String[]{"endpackage"});
        BLOCKS.put("primitive", new String[]{"endprimitive"});
        BLOCKS.put("specify", new String[]{"endspecify"});
        BLOCKS.put("table", new String[]{"endtable"});
        BLOCKS.put("covergroup", new String[]{"endgroup"});
        BLOCKS.put("case", new String[]{"endcase"});
        BLOCKS.put("casex", new String[]{"endcase"});
        BLOCKS.put("casez", new String[]{"endcase"});
        BLOCKS.put("do", new String[]{"while"});
        BLOCKS.put("randcase", new String[]{"endcase"});
        BLOCKS.put("randsequence", new String[]{"endsequence"});
        BLOCKS.put("sequence", new String[]{"endsequence"});
        BLOCKS.put("property", new String[]{"endproperty"});
        BLOCKS.put("fork", new String[]{"join_none", "join_any", "join"});
        ESCAPE_WORDS = new HashMap();
        ESCAPE_WORDS.put("function", new String[]{"extern", "pure", "import", "export"});
        ESCAPE_WORDS.put("task", new String[]{"extern", "pure", "import", "export"});
        ESCAPE_WORDS.put("module", new String[]{"extern"});
        ESCAPE_WORDS.put("program", new String[]{"extern"});
        ESCAPE_WORDS.put("interface", new String[]{"extern"});
        ESCAPE_WORDS.put("primitive", new String[]{"extern"});
        ESCAPE_WORDS.put("property", new String[]{"assume", "assert", "cover", "restrict"});
        ESCAPE_WORDS.put("sequence", new String[]{"cover", "default"});
        ESCAPE_WORDS.put("fork", new String[]{"disable"});
        ESCAPE_WORDS.put("class", new String[]{"typedef"});
        ESCAPE_WORDS.put("clocking", new String[]{"modport"});
        ONE_LINE_BLOCK = new HashSet();
        ONE_LINE_BLOCK.add("if");
        ONE_LINE_BLOCK.add("else");
        ONE_LINE_BLOCK.add("for");
        ONE_LINE_BLOCK.add("forever");
        ONE_LINE_BLOCK.add("foreach");
        ONE_LINE_BLOCK.add("while");
        ONE_LINE_BLOCK.add("initial");
        ONE_LINE_BLOCK.add("repeat");
        ONE_LINE_BLOCK.add("always");
        ONE_LINE_BLOCK.add("always_comb");
        ONE_LINE_BLOCK.add("always_latch");
        ONE_LINE_BLOCK.add("always_ff");
    }

    public static final LinkedList<Integer> getBadIndentationLines(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.canRead()) {
            return null;
        }
        IndentParser parser = new IndentParser(file);
        parser.parse();
        return parser.fBadIndentationLines;
    }

    private IndentParser(File file) {
        this.fFile = file;
        this.fBadIndentationLines = new LinkedList();
        this.fOpenWordsStack = new LinkedList();
        this.fLastWords = new HashSet();
        this.fCurrentIndentSpaces = -1;
        this.fLevelDelta = 0;
        this.fExpectedLevel = 0;
        this.fIsFristWordClose = false;
        this.fWordNumber = 0;
        this.fCloseDelta = 0;
    }

    private void clear() {
        this.fBadIndentationLines.clear();
        this.fLastWords.clear();
        this.fOpenWordsStack.clear();
        this.fCurrentIndentSpaces = -1;
        this.fLevelDelta = 0;
        this.fExpectedLevel = 0;
        this.fIsFristWordClose = false;
        this.fWordNumber = 0;
        this.fCloseDelta = 0;
    }

    private void parse() {
        try {
            int k;
            this.clear();
            BufferedReader reader = new BufferedReader(new FileReader(this.fFile));
            StreamTokenizer s = new StreamTokenizer(reader);
            s.resetSyntax();
            s.whitespaceChars(0, 31);
            s.wordChars(97, 122);
            s.wordChars(65, 90);
            s.wordChars(95, 95);
            s.wordChars(48, 57);
            s.eolIsSignificant(true);
            boolean isIndentation = true;
            int indentSpaces = 0;
            while ((k = s.nextToken()) != -1) {
                if (k == 47) {
                    k = s.nextToken();
                    if (k == 47) {
                        while (k != 10 && k != -1) {
                            k = s.nextToken();
                        }
                    } else if (k == 42) {
                        while (k != -1) {
                            k = s.nextToken();
                            if (k != 42) continue;
                            k = s.nextToken();
                            if (k == 47) {
                                k = s.nextToken();
                                break;
                            }
                            s.pushBack();
                        }
                    } else {
                        k = 47;
                        s.pushBack();
                    }
                }
                if (k == 34) {
                    if (isIndentation) {
                        isIndentation = false;
                        this.fCurrentIndentSpaces = indentSpaces;
                    }
                    while (k != -1) {
                        int kk = k;
                        k = s.nextToken();
                        if (k != 34 || kk == 92) continue;
                        k = s.nextToken();
                        break;
                    }
                }
                if (k == -1) break;
                if (k == 10) {
                    isIndentation = true;
                    indentSpaces = 0;
                    this.newEol(s.lineno() - 1);
                    continue;
                }
                if (isIndentation && k == 32) {
                    ++indentSpaces;
                    continue;
                }
                if (isIndentation) {
                    isIndentation = false;
                    this.fCurrentIndentSpaces = indentSpaces;
                }
                if (k == -3) {
                    this.newWord(s.sval);
                    continue;
                }
                if (k == 40 || k == 41 || k == 123 || k == 125) {
                    this.newWord(Character.toString((char)k));
                    continue;
                }
                if (k != 59) continue;
                this.fLastWords.clear();
            }
            this.newEol(s.lineno());
            reader.close();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void newWord(String word) {
        this.fLastWords.add(word);
        ++this.fWordNumber;
        if (BLOCKS.containsKey(word)) {
            boolean isEscaped = false;
            String[] escapeWords = ESCAPE_WORDS.get(word);
            if (escapeWords != null) {
                String[] stringArray = escapeWords;
                int n = escapeWords.length;
                int n2 = 0;
                while (n2 < n) {
                    String escapeWord = stringArray[n2];
                    if (this.fLastWords.contains(escapeWord)) {
                        isEscaped = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!isEscaped) {
                this.fOpenWordsStack.push(word);
                ++this.fLevelDelta;
            }
        } else if (BLOCKS.containsKey(this.fOpenWordsStack.peek())) {
            String[] endWords;
            String[] stringArray = endWords = BLOCKS.get(this.fOpenWordsStack.peek());
            int n = endWords.length;
            int n3 = 0;
            while (n3 < n) {
                String endWord = stringArray[n3];
                if (endWord.equals(word)) {
                    this.fOpenWordsStack.pop();
                    --this.fLevelDelta;
                    if (this.fWordNumber == 1) {
                        this.fIsFristWordClose = true;
                    }
                    if (this.fWordNumber + this.fLevelDelta != 0) break;
                    ++this.fCloseDelta;
                    break;
                }
                ++n3;
            }
        }
    }

    private void newEol(int line) {
        if (this.fCurrentIndentSpaces < 0) {
            return;
        }
        int tmpExpectedLevel = this.fExpectedLevel - (this.fIsFristWordClose ? this.fCloseDelta : 0);
        if (this.fCurrentIndentSpaces != tmpExpectedLevel * 2) {
            this.fBadIndentationLines.add(line);
        }
        this.fExpectedLevel += this.fLevelDelta;
        this.fLevelDelta = 0;
        this.fCurrentIndentSpaces = -1;
        this.fIsFristWordClose = false;
        this.fWordNumber = 0;
        this.fCloseDelta = 0;
    }
}

