/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class LintDHUtils {
    public static Map<ElementPath, ELInstance> computeDHWithElaborationForElement(RfProject rfProject, IRfNamedElement topNamedElement) {
        TreePath topTreePath = TreePathUtils.getElabTopTrimmedTreePath((IProject)rfProject.getProject(), (IRfNamedElement)topNamedElement);
        ElementPath topTreePathElementPath = TreePathUtils.getElementPathFromTreePath((TreePath)topTreePath);
        if (topTreePathElementPath == null) {
            return null;
        }
        Map treeMap = rfProject.getELManager().getMemory().subtreeOf(topTreePathElementPath, false);
        return treeMap;
    }

    public static Map<ElementPath, ELInstance> computeDHWithElaborationForElementPath(RfProject rfProject, ElementPath topTreePathElementPath) {
        if (topTreePathElementPath == null) {
            return null;
        }
        Map treeMap = rfProject.getELManager().getMemory().subtreeOf(topTreePathElementPath, false);
        return treeMap;
    }

    public static void computeBindsForElement(IRfNamedElement element, Map<IRfNamedElement, Set<IRfNamedElement>> moduleToBindChildMap) {
        if (!(element instanceof RfModule) && !(element instanceof RfInstance)) {
            return;
        }
        ArrayList<? extends IRfInstanceElement> binds = new ArrayList<IRfInstanceElement>();
        List<? extends IRfInstanceElement> b = null;
        b = element instanceof RfInstance ? ((RfInstance)element).getBindInstances(Integer.MAX_VALUE) : ((RfModule)element).getBindInstances(Integer.MAX_VALUE);
        if (b == null) {
            return;
        }
        binds.addAll(b);
        for (IRfInstanceElement iRfInstanceElement : binds) {
            IRfNamedElement bscope = iRfInstanceElement.getBindInstanceScope();
            Set<IRfNamedElement> bindsForScope = moduleToBindChildMap.get(bscope);
            if (bindsForScope == null) {
                bindsForScope = new HashSet<IRfNamedElement>();
            }
            bindsForScope.add(element);
            moduleToBindChildMap.put(bscope, bindsForScope);
        }
    }

    public static GetTopsResult getTops(IProject project, boolean isElab) {
        List allSelectedTops;
        if (project == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        List list = allSelectedTops = isElab ? LintDHUtils.getTopsForElab(mixedLangProject) : mixedLangProject.getAllSelectedTops();
        if (allSelectedTops == null || allSelectedTops.isEmpty()) {
            return null;
        }
        return new GetTopsResult(GetTopsResultType.COMPUTED_FROM_BUILD_CONFIG, new ArrayList<IRfNamedElement>(allSelectedTops));
    }

    public static List<IRfDesignElement> getTopsForElab(RfMixedLangProject rfProject) {
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return Collections.emptyList();
        }
        List tops = elManager.getTopDesigns();
        if (tops == null || tops.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(tops, (o1, o2) -> {
            String o1Name = o1.getName();
            String o2Name = o2.getName();
            return o1Name.compareTo(o2Name);
        });
        return tops;
    }

    public static ElementPath computeElementPathFromModuleName(RfProject rfProject, String top) {
        RfModule[] allmodules = rfProject.getAllModules();
        if (allmodules == null) {
            return null;
        }
        RfModule[] rfModuleArray = allmodules;
        int n = allmodules.length;
        int n2 = 0;
        while (n2 < n) {
            RfModule module = rfModuleArray[n2];
            if (top.equals(module.getName())) {
                TreePath topTreePath = TreePathUtils.getElabTopTrimmedTreePath((IProject)rfProject.getProject(), (IRfNamedElement)module);
                return TreePathUtils.getElementPathFromTreePath((TreePath)topTreePath);
            }
            ++n2;
        }
        return null;
    }

    public static ElementPath getElementPathFromHierarchyPath(String path) {
        if (path == null) {
            return null;
        }
        String[] segments = path.split("\\.");
        int i = 0;
        while (i < segments.length - 1) {
            String segment = segments[i];
            int indexOf = segment.indexOf("@(");
            if (indexOf >= 0) {
                segments[i] = segment.substring(0, indexOf);
            }
            ++i;
        }
        return ElementPath.create((String[])segments);
    }

    public static class GetTopsResult {
        private List<IRfNamedElement> tops;
        private GetTopsResultType resultType;
        private String topConfigName;

        public GetTopsResult(GetTopsResultType resultType, List<IRfNamedElement> tops) {
            this.resultType = resultType;
            this.tops = tops;
        }

        public List<IRfNamedElement> getTops() {
            return this.tops;
        }

        public GetTopsResultType getResultType() {
            return this.resultType;
        }

        public String getTopConfigName() {
            return this.topConfigName;
        }

        public void setConfigName(String configName) {
            this.topConfigName = configName;
        }

        public boolean isEmpty() {
            return this.tops == null || this.tops.isEmpty();
        }
    }

    static enum GetTopsResultType {
        RECOVERD_FROM_BUILD_CONFIG_XML,
        COMPUTED_FROM_BUILD_CONFIG;

    }
}

