/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.util.Deque;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.utils.LintExprTypeCompareResult;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class LintExpr {
    private RfNamedElement fElement;
    private RfNamedElement fElementType;
    private DataTypeDimensions fDimensions;
    private IRfNamedElementAndScope fWNamedElementAndScope;

    public LintExpr(RfNamedElement aElement, RfNamedElement aElementType, IRfNamedElementAndScope aWNamedElementAndScope, DataTypeDimensions aDimensions) {
        this.fElement = aElement;
        this.fElementType = aElementType;
        this.fWNamedElementAndScope = aWNamedElementAndScope;
        this.fDimensions = aDimensions;
    }

    public RfNamedElement getElement() {
        return this.fElement;
    }

    public RfNamedElement getElementType() {
        return this.fElementType;
    }

    public RfNamedElement getFinalElementType() {
        RfNamedElement result = this.fElementType;
        if (result instanceof RfAssociatedType) {
            HashSet<String> typeAliasNames = new HashSet<String>();
            RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)result, result.getRfProject(), 6);
            result = ((RfAssociatedType)result).getAssociatedType(typesResolver);
            while (result != null && (result instanceof RfListType || result instanceof RfTypeAlias)) {
                if (typeAliasNames.contains(result.getName())) break;
                if (result instanceof RfListType) {
                    typeAliasNames.add(result.getName());
                    result = ((RfListType)result).getAssociatedType(typesResolver);
                }
                if (!(result instanceof RfTypeAlias)) continue;
                typeAliasNames.add(result.getName());
                result = ((RfTypeAlias)result).getTranslatedType(typesResolver, false, this.fDimensions, null);
            }
        }
        if (result instanceof RfNamedElement) {
            return result;
        }
        return null;
    }

    public IRfNamedElementAndScope getWNamedElementAndScope() {
        return this.fWNamedElementAndScope;
    }

    public Deque<? extends IRfNamedElementAndScope> getElementAndScopeStack() {
        if (this.fWNamedElementAndScope == null) {
            return null;
        }
        return this.fWNamedElementAndScope.getElementAndScopeStack();
    }

    public LintExprTypeCompareResult compareWith(LintExpr other) {
        if (other == null) {
            return null;
        }
        RfNamedElement myFinalElementType = this.getFinalElementType();
        RfNamedElement otherFinalElementType = other.getFinalElementType();
        if (myFinalElementType == null || otherFinalElementType == null) {
            String thisInfo = myFinalElementType != null ? myFinalElementType.getName() : "unknown";
            String otherInfo = otherFinalElementType != null ? otherFinalElementType.getName() : "unknown";
            return new LintExprTypeCompareResult(1, thisInfo, otherInfo);
        }
        if (!myFinalElementType.checkEquals(otherFinalElementType)) {
            return new LintExprTypeCompareResult(1, this.fElementType.getFullName(), other.fElementType.getFullName());
        }
        if (this.fDimensions == null && other.fDimensions == null) {
            return new LintExprTypeCompareResult(0, null, null);
        }
        if (this.fDimensions == null || other.fDimensions == null) {
            String thisInfo = this.fDimensions != null ? "" + this.fDimensions : "unknown";
            String otherInfo = other.fDimensions != null ? "" + other.fDimensions : "unknown";
            return new LintExprTypeCompareResult(2, thisInfo, otherInfo);
        }
        if (!this.fDimensions.compareUnpackedDimension(other.fDimensions)) {
            return new LintExprTypeCompareResult(4, this.fDimensions.getUnpackedDimensionForMsg(), other.fDimensions.getUnpackedDimensionForMsg());
        }
        if (!this.fDimensions.comparePackedDimension(other.fDimensions)) {
            return new LintExprTypeCompareResult(3, this.fDimensions.getPackedDimensionForMsg(), other.fDimensions.getPackedDimensionForMsg());
        }
        return new LintExprTypeCompareResult(0, null, null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LintExpr)) {
            return false;
        }
        LintExprTypeCompareResult compareResult = this.compareWith((LintExpr)obj);
        return compareResult != null && compareResult.fMatch == 0;
    }
}

