/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.utils.HierarchicalId;
import ro.amiq.vlogdt.linter.utils.LintExpr;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class LintExprFactory {
    private RfProject fRfProject;
    private Map<HierarchicalId, Object> map;

    public LintExprFactory(RfProject aRfProject) {
        this.fRfProject = aRfProject;
        this.map = new HashMap<HierarchicalId, Object>();
    }

    private Object get(String aExprString, ParserPath aParserPath, int aStartLine, int aStartOffset, int aEndLine, ReparseInfo aReparseInfo) {
        HierarchicalId hid = new HierarchicalId(aExprString, aParserPath, aStartLine, aStartOffset, aEndLine, aReparseInfo);
        if (this.map.containsKey(hid)) {
            return this.map.get(hid);
        }
        return null;
    }

    private void put(String aExprString, ParserPath aParserPath, int aStartLine, int aStartOffset, int aEndLine, ReparseInfo aReparseInfo, Object aLintExpr) {
        HierarchicalId hid = new HierarchicalId(aExprString, aParserPath, aStartLine, aStartOffset, aEndLine, aReparseInfo);
        this.map.put(hid, aLintExpr);
    }

    public LintExpr createLintExpr(String aExprString, ParserPath aParserPath, int aStartLine, int aStartOffset, int aEndLine, ReparseInfo aReparseInfo) {
        if (aExprString == null) {
            return null;
        }
        Object cachedLintExpr = this.get(aExprString, aParserPath, aStartLine, aStartOffset, aEndLine, aReparseInfo);
        if (cachedLintExpr != null) {
            if (cachedLintExpr instanceof LintExpr) {
                return (LintExpr)cachedLintExpr;
            }
            return null;
        }
        RfFileDef filedef = this.fRfProject.getFileDefUsingParserPath(aParserPath);
        if (filedef == null) {
            this.put(aExprString, aParserPath, aStartLine, aStartOffset, aEndLine, aReparseInfo, this);
            return null;
        }
        RfDefElement defScope = filedef.getScope(aStartOffset, true);
        if (defScope == null) {
            this.put(aExprString, aParserPath, aStartLine, aStartOffset, aEndLine, aReparseInfo, this);
            return null;
        }
        LintExpr result = this.createLintExpr(String.valueOf(aExprString) + "." + "_____dummy", defScope, aStartOffset);
        if (result != null) {
            this.put(aExprString, aParserPath, aStartLine, aStartOffset, aEndLine, aReparseInfo, result);
            return result;
        }
        this.put(aExprString, aParserPath, aStartLine, aStartOffset, aEndLine, aReparseInfo, this);
        return null;
    }

    public LintExpr createLintExpr(String aExprString, IRfScope aScope, int aStartOffset) {
        IRfScopeElement peekScope;
        RfWNamedElementAndScope elementAndScopePeek;
        RfWNamedElementAndScope exprWNamedElementAndScope = LintUtils.getWNamedElementAndScope(this.fRfProject, aScope, aStartOffset, aExprString, true);
        if (exprWNamedElementAndScope == null) {
            return null;
        }
        RfNamedElement element = exprWNamedElementAndScope.getNamedElement();
        if (element == null) {
            return null;
        }
        RfNamedElement elementType = null;
        DataTypeDimensions dimensions = null;
        Deque<RfWNamedElementAndScope> elementAndScopeStack = exprWNamedElementAndScope.getElementAndScopeStack();
        if (elementAndScopeStack != null && !elementAndScopeStack.isEmpty() && (elementAndScopePeek = elementAndScopeStack.peek()) != null && (peekScope = elementAndScopePeek.getScope()) != null && peekScope instanceof RfNamedElement) {
            elementType = (RfNamedElement)peekScope;
            dimensions = elementAndScopePeek.getDimensions();
        }
        return new LintExpr(element, elementType, exprWNamedElementAndScope, dimensions);
    }
}

