/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IReparseElement;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintExpr;
import ro.amiq.vlogdt.linter.utils.LintExprFactory;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.NamedElementAndString;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssertExpectDef;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfParamsHolder;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequenceDef;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

public class LintUtils {
    public static final String WREALXSTATE = "wrealXState";
    public static final String WREALZSTATE = "wrealZState";
    public static final String IFDEF = "ifdef";
    public static final String IFNDEF = "ifndef";
    public static final String ELSE = "else";
    public static final String ENDIF = "endif";
    public static final String ELSIF = "elsif";
    public static final Set<String> ALL_COMPILER_DIRECTIVES = new HashSet<String>(Arrays.asList("ifdef", "ifndef", "else", "elsif", "endif"));
    public static final Pattern DATE_PATTERN = Pattern.compile("^\\d+-\\d+-\\d+$");
    public static final Pattern VERSION_PATTERN = Pattern.compile("^\\d+(?:\\.\\d+){1,3}$");
    public static final String LINTER_PRAGMA_UNAVAILABLE = "Rule information is available only when a Verissimo session is active.";
    private static final Pattern INLINE_PRAGMA_DESCRIPTION_PATTERN = Pattern.compile("\"[^\"]*\"");
    public static final String FULL_TYPE_PREFX_FIXED_SIZE = "[fixed_size_array]";
    public static final String FULL_TYPE_PREFX_DYNAMIC_ARRAY = "[dynamic_array]";
    public static final String FULL_TYPE_PREFX_ASSOCIATIVE_ARRAY = "[associative_array]";
    public static final String FULL_TYPE_PREFX_QUEUE = "[queue]";
    public static final String FULL_TYPE_PREFX_ENUM = "[enum]";
    public static final String FULL_TYPE_PREFIX_SCALAR = "[scalar]";
    public static final Set<String> REAL_BASE_TYPES = new HashSet<String>();
    public static final Set<String> INTEGRAL_BASE_TYPES;
    private static final Set<String> FOUR_STATE_BASE_TYPES;
    public static final Pattern TIME_VALUE_PATTERN;
    public static final Pattern DEC_NUM_PATTERN;
    public static final Pattern OCT_NUM_PATTERN;
    public static final Pattern HEX_NUM_PATTERN;
    public static final Pattern BIN_NUM_PATTERN;
    public static final Pattern REAL_NUM_PATTERN;

    static {
        REAL_BASE_TYPES.add("real");
        REAL_BASE_TYPES.add("realtime");
        REAL_BASE_TYPES.add("shortreal");
        INTEGRAL_BASE_TYPES = new HashSet<String>();
        INTEGRAL_BASE_TYPES.add("bit");
        INTEGRAL_BASE_TYPES.add("shortint");
        INTEGRAL_BASE_TYPES.add("int");
        INTEGRAL_BASE_TYPES.add("longint");
        INTEGRAL_BASE_TYPES.add("logic");
        INTEGRAL_BASE_TYPES.add("reg");
        INTEGRAL_BASE_TYPES.add("integer");
        INTEGRAL_BASE_TYPES.add("time");
        INTEGRAL_BASE_TYPES.add("byte");
        FOUR_STATE_BASE_TYPES = new HashSet<String>();
        FOUR_STATE_BASE_TYPES.add("logic");
        FOUR_STATE_BASE_TYPES.add("reg");
        FOUR_STATE_BASE_TYPES.add("integer");
        FOUR_STATE_BASE_TYPES.add("time");
        TIME_VALUE_PATTERN = Pattern.compile("[_0-9]+(\\.[_0-9]+)?[munpf]?s");
        DEC_NUM_PATTERN = Pattern.compile("[_0-9]+('[sS]?[dD][_0-9xXzZ]*)?");
        OCT_NUM_PATTERN = Pattern.compile("[_0-9]*('([sS])?o|'([sS])?O)[xXzZ\\?0-7][xXzZ_\\?0-7]*");
        HEX_NUM_PATTERN = Pattern.compile("[_0-9]*('([sS])?h|'([sS])?H)[xXzZaAbBcCdDeEfF\\?0-9][xXzZ_aAbBcCdDeEfF\\?0-9]*");
        BIN_NUM_PATTERN = Pattern.compile("[_0-9]*('([sS])?b|'([sS])?B)[01xXzZ\\?][01xXzZ_\\?]*");
        REAL_NUM_PATTERN = Pattern.compile("[1-9][_0-9]*\\.[_0-9]*");
    }

    public static String createRunTimeMessage(long runTime, int messageLength, boolean inBatchMode) {
        int nofDots = Math.max(72 - (Long.toString(runTime).length() + messageLength), 3);
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        int i = 0;
        while (i <= nofDots) {
            sb.append('.');
            ++i;
        }
        sb.append(' ').append(runTime).append(" ms");
        if (inBatchMode) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String replaceAllSystemVariables(IProject project, String headerFilePath, DVTUtilsCommon.ReplaceSysvarsPolicy policy) {
        return DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)headerFilePath, policy, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)project, (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
    }

    public static boolean startsWithPrefixes(String aName, Set<String> aPrefixes) {
        if (aName == null || aPrefixes == null || aPrefixes.isEmpty()) {
            return false;
        }
        for (String prefix : aPrefixes) {
            if (!aName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInsideMacroWithPrefix(RfNamedElement aNamedElement, Set<String> aMacroPrefixes) {
        ReparseInfo.ReparseElement[] macroStack;
        if (aNamedElement == null || aMacroPrefixes == null || aMacroPrefixes.isEmpty()) {
            return false;
        }
        if (aNamedElement.getDeclaration() == null) {
            return false;
        }
        ReparseInfo reparseInfo = aNamedElement.getDeclaration().getReparseInfo();
        if (reparseInfo == null || reparseInfo.getReparseStackSize() == 0) {
            return false;
        }
        ReparseInfo.ReparseElement[] reparseElementArray = macroStack = reparseInfo.getReparseStack();
        int n = macroStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseInfo.ReparseElement macroElm = reparseElementArray[n2];
            VlogMacroInfo macroInfo = macroElm.getTransientReparseMacroInfo();
            if (macroInfo != null && LintUtils.startsWithPrefixes(macroInfo.getName(), aMacroPrefixes)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isInsideMacroWithName(RfNamedElement aNamedElement, Set<String> aMacroNames) {
        ReparseInfo.ReparseElement[] macroStack;
        if (aNamedElement == null || aMacroNames == null || aMacroNames.isEmpty()) {
            return false;
        }
        if (aNamedElement.getDeclaration() == null) {
            return false;
        }
        ReparseInfo reparseInfo = aNamedElement.getDeclaration().getReparseInfo();
        if (reparseInfo == null || reparseInfo.getReparseStackSize() == 0) {
            return false;
        }
        ReparseInfo.ReparseElement[] reparseElementArray = macroStack = reparseInfo.getReparseStack();
        int n = macroStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseInfo.ReparseElement macroElm = reparseElementArray[n2];
            VlogMacroInfo macroInfo = macroElm.getTransientReparseMacroInfo();
            if (macroInfo != null) {
                for (String name : aMacroNames) {
                    if (!macroInfo.getName().equals(name)) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean isInsideMacroWithPrefix(HidOccurrence aHidOccurrence, Set<String> aMacroPrefixes) {
        ReparseInfo.ReparseElement[] macroStack;
        if (aHidOccurrence == null || aMacroPrefixes == null || aMacroPrefixes.isEmpty()) {
            return false;
        }
        ReparseInfo reparseInfo = (ReparseInfo)aHidOccurrence.getReparseInfo(ReparseInfo.class);
        if (reparseInfo == null || reparseInfo.getReparseStackSize() == 0) {
            return false;
        }
        ReparseInfo.ReparseElement[] reparseElementArray = macroStack = reparseInfo.getReparseStack();
        int n = macroStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseInfo.ReparseElement macroElment = reparseElementArray[n2];
            VlogMacroInfo macroInfo = macroElment.getTransientReparseMacroInfo();
            if (macroInfo != null && LintUtils.startsWithPrefixes(macroInfo.getName(), aMacroPrefixes)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isInsidePackageWithPrefix(RfNamedElement aNamedElement, Set<String> aPrefixes) {
        if (aNamedElement == null || aPrefixes == null || aPrefixes.isEmpty()) {
            return false;
        }
        RfPackage enclosingPackage = aNamedElement.getEnclosingPackage();
        if (enclosingPackage == null) {
            return false;
        }
        return LintUtils.startsWithPrefixes(enclosingPackage.getName(), aPrefixes);
    }

    public static boolean isDeclaredInAParentClassWithPrefixes(RfNamedElement aNamedElement, Set<String> aPrefixes) {
        RfClass enclosingClass;
        if (aNamedElement == null || aPrefixes == null || aPrefixes.isEmpty()) {
            return false;
        }
        RfClass parent = enclosingClass = aNamedElement.getEnclosingScope(RfClass.class);
        while (parent != null) {
            DVTLinkedHashMap<String, RfNamedElement> members = parent.getLocalMembers(true);
            if (members != null && members.containsKey((Object)aNamedElement.getName()) && LintUtils.startsWithPrefixes(parent.getFullName(), aPrefixes)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isConditionalCode(RfNamedElement element, List<RfFunction> allFctTsks) {
        RfNamedElement enclosingScope = element.getEnclosingScope();
        while (enclosingScope != null) {
            if (enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isConditional()) {
                return true;
            }
            if (enclosingScope instanceof RfFunction) {
                if (allFctTsks == null) {
                    return false;
                }
                NullProtectedList<RfFunctionCall> indirectCalls = new NullProtectedList<RfFunctionCall>();
                for (RfFunction fctTsk : allFctTsks) {
                    indirectCalls.addAll(fctTsk.getFunctionCallsWithPrefix(enclosingScope.getName(), 1));
                }
                if (indirectCalls.isEmpty()) {
                    return false;
                }
                boolean isConditional = true;
                for (RfFunctionCall indirectCall : indirectCalls) {
                    if (indirectCall == null) continue;
                    isConditional &= LintUtils.isConditionalCode(indirectCall, allFctTsks);
                }
                return isConditional;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return false;
    }

    public static RfNamedElement getTranslatedFinalType(IRfNamedElement type) {
        if (type == null) {
            return null;
        }
        IRfNamedElement translatedType = type;
        while (translatedType instanceof RfTypeAlias) {
            translatedType = ((RfTypeAlias)translatedType).getTranslatedType();
        }
        return translatedType instanceof RfNamedElement ? (RfNamedElement)translatedType : null;
    }

    public static RfNamedElement getAssociatedFinalType(IRfAssociatedTypeElement aAssociatedType) {
        if (aAssociatedType == null) {
            return null;
        }
        IRfNamedElement associatedType = aAssociatedType.getAssociatedType();
        while (associatedType instanceof RfListType || associatedType instanceof RfTypeAlias) {
            if (associatedType instanceof RfListType) {
                associatedType = ((RfListType)associatedType).getAssociatedBaseType();
            }
            if (!(associatedType instanceof RfTypeAlias)) continue;
            associatedType = ((RfTypeAlias)associatedType).getTranslatedType();
        }
        return associatedType instanceof RfNamedElement ? (RfNamedElement)associatedType : null;
    }

    public static RfNamedElement getAssociatedFinalType(IRfAssociatedTypeElement aAssociatedType, RfTypesResolver typesResolver) {
        if (aAssociatedType == null) {
            return null;
        }
        IRfNamedElement associatedType = aAssociatedType instanceof RfAssociatedType ? ((RfAssociatedType)aAssociatedType).getAssociatedType(typesResolver) : aAssociatedType.getAssociatedType();
        while (associatedType instanceof RfListType || associatedType instanceof RfTypeAlias) {
            if (associatedType instanceof RfListType) {
                associatedType = ((RfListType)associatedType).getAssociatedBaseType();
            }
            if (!(associatedType instanceof RfTypeAlias)) continue;
            associatedType = ((RfTypeAlias)associatedType).getTranslatedType();
        }
        return associatedType instanceof RfNamedElement ? (RfNamedElement)associatedType : null;
    }

    public static FullTypeData getAssociatedFinalDataType(RfAssociatedType candidate) {
        if (candidate == null) {
            return null;
        }
        IRfNamedElement assocType = candidate.getAssociatedType();
        DataType assocDataType = candidate.getDataType();
        while (assocType != null && (assocType instanceof RfListType || assocType instanceof RfTypeAlias)) {
            if (assocType instanceof RfListType) {
                assocDataType = ((RfListType)assocType).getDataType();
                assocType = ((RfListType)assocType).getAssociatedType();
            }
            if (!(assocType instanceof RfTypeAlias)) continue;
            assocDataType = ((RfTypeAlias)assocType).getDataType();
            assocType = ((RfTypeAlias)assocType).getAssociatedType();
        }
        return new FullTypeData(assocDataType, assocType);
    }

    public static IRfNamedElement getFieldType(RfField field) {
        RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
        if (fieldType instanceof RfStruct) {
            if (((RfStruct)fieldType).isEnum()) {
                fieldType = ((RfStruct)fieldType).getEnumBaseType();
            } else {
                List<RfField> localFields = ((RfStruct)fieldType).getLocalMembers(RfField.class);
                if (localFields != null && !localFields.isEmpty()) {
                    RfNamedElement structFieldType = null;
                    for (RfField localField : localFields) {
                        if (structFieldType == null) {
                            structFieldType = LintUtils.getAssociatedFinalType(localField);
                            continue;
                        }
                        RfNamedElement localFieldType = LintUtils.getAssociatedFinalType(localField);
                        if (((Object)structFieldType).equals(localFieldType)) continue;
                        return null;
                    }
                    fieldType = structFieldType;
                }
            }
        }
        return fieldType;
    }

    public static boolean isSigned(DataType dataType) {
        return dataType.isSigned() && dataType.getSign() != 2;
    }

    public static boolean isSigned(RfHidImplicit implicit) {
        if (LintUtils.isImplicitUnsized(implicit)) {
            return true;
        }
        return implicit.getName().indexOf(83) >= 0 || implicit.getName().indexOf(115) >= 0;
    }

    public static boolean isImplicitUnsized(RfHidImplicit implicit) {
        return implicit.getName().indexOf(39) <= 0;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isVirtualInterface(RfField aRfField) {
        if (aRfField == null) {
            return false;
        }
        dataType = aRfField.getDataType();
        if (dataType != null && dataType.isVirtualInterface()) {
            return true;
        }
        associatedType = aRfField.getAssociatedType();
        if (!(associatedType instanceof RfInterface)) ** GOTO lbl14
        return true;
lbl-1000:
        // 1 sources

        {
            typeAlias = (RfTypeAlias)associatedType;
            dataType = typeAlias.getDataType();
            if (dataType != null && dataType.isVirtualInterface()) {
                return true;
            }
            associatedType = typeAlias.getAssociatedType();
lbl14:
            // 2 sources

            ** while (associatedType != null && associatedType instanceof RfTypeAlias)
        }
lbl15:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isVirtualInterface(RfField aRfField, RfTypesResolver typesResolver) {
        if (aRfField == null) {
            return false;
        }
        dataType = aRfField.getDataType();
        if (dataType != null && dataType.isVirtualInterface()) {
            return true;
        }
        associatedType = aRfField.getAssociatedType(typesResolver);
        if (!(associatedType instanceof RfInterface)) ** GOTO lbl14
        return true;
lbl-1000:
        // 1 sources

        {
            typeAlias = (RfTypeAlias)associatedType;
            dataType = typeAlias.getDataType();
            if (dataType != null && dataType.isVirtualInterface()) {
                return true;
            }
            associatedType = typeAlias.getAssociatedType();
lbl14:
            // 2 sources

            ** while (associatedType != null && associatedType instanceof RfTypeAlias)
        }
lbl15:
        // 1 sources

        return false;
    }

    public static RfClass getFieldFinalClassTypeOrNull(RfField aField) {
        RfNamedElement fieldType = LintUtils.getAssociatedFinalType(aField);
        if (fieldType == null || !(fieldType instanceof RfClass)) {
            return null;
        }
        return (RfClass)fieldType;
    }

    public static RfClass getFieldFinalClassTypeOrNull(RfField aField, RfTypesResolver typesResolver) {
        RfNamedElement fieldType = LintUtils.getAssociatedFinalType(aField, typesResolver);
        if (fieldType == null || !(fieldType instanceof RfClass)) {
            return null;
        }
        return (RfClass)fieldType;
    }

    public static RfClass getFunctionResultFinalClassTypeOrNull(RfFunction aFunction) {
        RfNamedElement resultType = LintUtils.getAssociatedFinalType(aFunction);
        if (resultType == null || !(resultType instanceof RfClass)) {
            return null;
        }
        return (RfClass)resultType;
    }

    public static RfClass getFunctionResultFinalClassTypeOrNull(RfFunction aFunction, RfTypesResolver typesResolver) {
        RfNamedElement resultType = LintUtils.getAssociatedFinalType(aFunction, typesResolver);
        if (resultType == null || !(resultType instanceof RfClass)) {
            return null;
        }
        return (RfClass)resultType;
    }

    public static String getAssociatedTypeAsString(RfAssociatedType aAssociatedType) {
        if (aAssociatedType == null) {
            return null;
        }
        DataType associatedTypeInfo = aAssociatedType.getDataType();
        if (associatedTypeInfo == null) {
            return null;
        }
        return associatedTypeInfo.getTypeNameWithParamAssignments();
    }

    public static String getElementSignature(IRfNamedElement elem, RfHid hid, IRfScopeElement scope, int qualifiedNameOptions) {
        if (elem instanceof RfNamedElement) {
            RfTypesResolver resolver = RfTypesResolver.create(scope != null ? scope : elem.getEnclosingScope(), ((RfNamedElement)elem).getRfProject(), 14);
            if (hid != null && hid.getParentAccess() != null) {
                resolver.update((RfHidAccess)hid.getParentAccess(), null);
            }
            return ((RfNamedElement)elem).getQualifiedName(resolver, scope, qualifiedNameOptions);
        }
        return elem.getQualifiedName(scope != null ? scope : elem.getEnclosingScope(), null, qualifiedNameOptions);
    }

    public static boolean isChildOf(RfClass aClass, RfClass aPotentialParent) {
        if (aPotentialParent == null) {
            return false;
        }
        RfClass parent = aClass;
        while (parent.getParent() != null) {
            if (!(parent = parent.getParent()).getFullName().equals(aPotentialParent.getFullName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassChildOf(RfClass aClass, HashMap<String, RfClass> aPotentialParents) {
        if (aClass == null || aPotentialParents == null) {
            return false;
        }
        RfClass parent = aClass;
        while (parent.getParent() != null) {
            if (!aPotentialParents.containsKey((parent = parent.getParent()).getFullName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassEqualOrChildOf(RfClass aClass, HashMap<String, RfClass> aPotentialParents) {
        if (aClass == null || aPotentialParents == null) {
            return false;
        }
        RfClass parent = aClass;
        while (parent != null) {
            if (aPotentialParents.containsKey(parent.getFullName())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static String getNamedElementFullName(RfNamedElement aNamedElement) {
        String fullName = aNamedElement.getFullName();
        RfNamedElement enclosingScope = aNamedElement.getEnclosingScope();
        if (enclosingScope instanceof RfListType) {
            if (((RfListType)enclosingScope).isDynamicArray()) {
                return "[dynamic_array]." + fullName;
            }
            if (((RfListType)enclosingScope).isAssociativeArray()) {
                return "[associative_array]." + fullName;
            }
            if (((RfListType)enclosingScope).isQueue()) {
                return "[queue]." + fullName;
            }
            return "[fixed_size_array]." + fullName;
        }
        if (enclosingScope instanceof RfStruct && enclosingScope.getName() != null && enclosingScope.getName().startsWith("enum")) {
            return "[enum]." + fullName;
        }
        if (enclosingScope instanceof RfScalarType) {
            return "[scalar]." + enclosingScope.getName() + "." + fullName;
        }
        return fullName;
    }

    public static RfClass getAssociativeArrayKeyClassType(RfField aField) {
        if (aField == null) {
            return null;
        }
        if (!aField.isAssociativeArray()) {
            return null;
        }
        RfNamedElement fieldEnclosingScope = aField.getEnclosingScope();
        if (fieldEnclosingScope == null) {
            return null;
        }
        RfDefElement fieldEnclosingScopeDeclaration = fieldEnclosingScope.getDeclaration();
        if (fieldEnclosingScopeDeclaration == null) {
            return null;
        }
        DataType typeInfo = aField.getDataType();
        if (typeInfo == null) {
            return null;
        }
        List<DataType> indexDataTypes = typeInfo.getIndexTypes();
        if (indexDataTypes == null) {
            return null;
        }
        for (DataType indexDataType : indexDataTypes) {
            RfClass candidate;
            if (indexDataType == null || (candidate = fieldEnclosingScopeDeclaration.getClassWithPrefix(indexDataType.getTypeName("logic", null), 1, 3)) == null) continue;
            return candidate;
        }
        return null;
    }

    public static List<MacroCallItem> getMacroCallsInSet(MacroCallInfo aMacroCallInfo, Set<String> aMacroNames) {
        return LintUtils.getMacroCallsInSet(aMacroCallInfo, aMacroNames, true, false, true);
    }

    public static List<MacroCallItem> getMacroCallsInSet(MacroCallInfo aMacroCallInfo, Set<String> aMacroNames, boolean aIncludeTrackedByDeprecatedComment, boolean aIncludeNestedMacros) {
        return LintUtils.getMacroCallsInSet(aMacroCallInfo, aMacroNames, true, aIncludeTrackedByDeprecatedComment, aIncludeNestedMacros);
    }

    public static List<MacroCallItem> getMacroCallsNotInSet(MacroCallInfo aMacroCallInfo, Set<String> aMacroNames) {
        return LintUtils.getMacroCallsInSet(aMacroCallInfo, aMacroNames, false, false, true);
    }

    private static List<MacroCallItem> getMacroCallsInSet(MacroCallInfo aMacroCallInfo, Set<String> aMacroNames, boolean aInSet, boolean aIncludeTrackedByDeprecatedComment, boolean aIncludeNestedMacros) {
        if (aMacroCallInfo == null || aMacroNames == null) {
            return null;
        }
        List<MacroCallItem> macroItems = aMacroCallInfo.getItems();
        if (macroItems == null) {
            return null;
        }
        ArrayList<MacroCallItem> result = new ArrayList<MacroCallItem>();
        for (MacroCallItem item : macroItems) {
            if (item == null || !aIncludeNestedMacros && item.getReparseInfo().getReparseStackSize() > 0) continue;
            String macroName = item.getName();
            if (aMacroNames.contains(macroName)) {
                if (aInSet) {
                    result.add(item);
                    continue;
                }
            } else if (!aInSet) {
                result.add(item);
                continue;
            }
            if (!aIncludeTrackedByDeprecatedComment || item.fLintTrackedByTag != 2) continue;
            result.add(item);
        }
        return result;
    }

    public static List<RfFunctionCall> getIndirectFunctionCallsWithPrefix(RfFunction aFunction, String aPrefix, int matchType) {
        return LintUtils.getIndirectFunctionCallsBuildingStack(aFunction, aPrefix, matchType, new LinkedHashSet<RfFunction>());
    }

    private static List<RfFunctionCall> getIndirectFunctionCallsBuildingStack(RfFunction function, String prefix, int matchType, LinkedHashSet<RfFunction> callStack) {
        NullProtectedList<RfFunctionCall> result = new NullProtectedList<RfFunctionCall>();
        NullProtectedList<RfFunctionCall> otherFunctionCalls = new NullProtectedList<RfFunctionCall>();
        if (function == null) {
            return result;
        }
        callStack.add(function);
        List<RfFunctionCall> functionCallsWithPrefix = function.getFunctionCallsWithPrefix("", 2);
        if (matchType == 2 && "".equals(prefix)) {
            result.addAll(functionCallsWithPrefix);
        } else {
            result.addAll(function.getFunctionCallsWithPrefix(prefix, matchType));
        }
        otherFunctionCalls.addAll(functionCallsWithPrefix);
        for (RfFunctionCall call : otherFunctionCalls) {
            RfFunction functionCalled = call.getFunction();
            if (functionCalled == null || callStack.contains(functionCalled)) continue;
            result.addAll(LintUtils.getIndirectFunctionCallsBuildingStack(functionCalled, prefix, matchType, callStack));
        }
        callStack.remove(function);
        return result;
    }

    public static boolean findFunctionCall(RfProject aRfProject, RfFunction aSourceFunction, RfFunction aTargetFunction) {
        RfClass targetFunctionClass;
        final ArrayList result = new ArrayList();
        final HashSet<String> visitedFunctions = new HashSet<String>();
        final ArrayList<RfFunction> functionsToVisit = new ArrayList<RfFunction>();
        final HashSet<String> targetFunctions = new HashSet<String>();
        targetFunctions.add(aTargetFunction.getFullName());
        RfFunction topVirtualFunction = LintUtils.getTopVirtualFunction(aTargetFunction);
        if (topVirtualFunction != null && (targetFunctionClass = aTargetFunction.getEnclosingScope(RfClass.class)) != null) {
            RfClass parentClass = targetFunctionClass.getParent();
            while (parentClass != null) {
                RfFunction parentFunction = parentClass.getLocalMember(RfFunction.class, aTargetFunction.getName(), false);
                if (parentFunction != null) {
                    targetFunctions.add(parentFunction.getFullName());
                }
                if (parentFunction == topVirtualFunction) break;
                parentClass = parentClass.getParent();
            }
        }
        functionsToVisit.add(aSourceFunction);
        int visitIndex = 0;
        while (visitIndex < functionsToVisit.size()) {
            RfFunction functionToVisit = (RfFunction)functionsToVisit.get(visitIndex);
            visitedFunctions.add(functionToVisit.getFullName());
            RfHidVisitor hidVisitor = new RfHidVisitor(){

                public boolean visit(RfHid hid) {
                    if (!result.isEmpty()) {
                        return false;
                    }
                    IRfNamedElement hidNamedElement = hid.getElement();
                    if (hidNamedElement instanceof RfFunction) {
                        RfFunction hidFunction = (RfFunction)hidNamedElement;
                        if (targetFunctions.contains(hidFunction.getFullName())) {
                            result.add(hid);
                            return false;
                        }
                        if (!visitedFunctions.contains(((RfFunction)hidNamedElement).getFullName())) {
                            functionsToVisit.add((RfFunction)hidNamedElement);
                        }
                    }
                    return true;
                }
            };
            functionToVisit.visitHidObject(aRfProject, hidVisitor);
            ++visitIndex;
        }
        return !result.isEmpty();
    }

    public static LintExpr createLintExpr(RfProject aRfProject, String aExprString, ParserPath aParserPath, int aStartLine, int aStartOffset, int aEndLine, ReparseInfo aReparseInfo) {
        if (aRfProject == null || aExprString == null) {
            return null;
        }
        LintExprFactory lintExprFactory = aRfProject.getLintExprFactory();
        if (lintExprFactory == null) {
            return null;
        }
        return lintExprFactory.createLintExpr(aExprString, aParserPath, aStartLine, aStartOffset, aEndLine, aReparseInfo);
    }

    public static RfWNamedElementAndScope getWNamedElementAndScope(RfProject aRfProject, IRfScope aScope, int aStartOffset, String aExprString, boolean aOnlyHierarchicalId) {
        if (aRfProject == null || aScope == null || aExprString == null) {
            return null;
        }
        String expr = aExprString;
        if (aOnlyHierarchicalId) {
            expr = LintUtils.getHierarchicalId(aExprString);
        }
        if (expr == null) {
            return null;
        }
        expr = LintUtils.trimParens(expr);
        return aRfProject.getWNamedElementAndScope(aRfProject, aScope, aStartOffset, expr, aOnlyHierarchicalId, null, RfTypesResolver.create((IRfScopeElement)aScope, aRfProject, 6), true);
    }

    public static RfNamedElement getElementFromString(RfProject aRfProject, IRfScope aScope, int aStartOffset, String aString) {
        LintExprFactory lintExprFactory = aRfProject.getLintExprFactory();
        if (lintExprFactory == null) {
            return null;
        }
        LintExpr lintExpr = lintExprFactory.createLintExpr(aString, aScope, aStartOffset);
        if (lintExpr == null) {
            return null;
        }
        return lintExpr.getElement();
    }

    public static RfNamedElement getCoverpointNamedElement(RfProject aRfProject, RfCoverpoint aCoverpoint, IRfScope aScope, int aStartOffset) {
        if (aCoverpoint == null) {
            return null;
        }
        String coverpointExprString = aCoverpoint.getCoverpointExpr();
        if (coverpointExprString == null || coverpointExprString.isEmpty()) {
            coverpointExprString = aCoverpoint.getName();
        }
        if (coverpointExprString != null && !coverpointExprString.isEmpty()) {
            LintExprFactory lintExprFactory = aRfProject.getLintExprFactory();
            if (lintExprFactory == null) {
                return null;
            }
            LintExpr coverpointLintExpr = lintExprFactory.createLintExpr(coverpointExprString, aScope, aStartOffset);
            if (coverpointLintExpr == null) {
                return null;
            }
            return coverpointLintExpr.getElement();
        }
        return null;
    }

    public static RfNamedElement getTypeFromString(RfNamedElement scope, String name, boolean translateTypedefs) {
        if (scope == null || name == null) {
            return null;
        }
        RfAssociatedTypeWrapper wrap = new RfAssociatedTypeWrapper(new DataType(name), scope);
        IRfNamedElement type = wrap.getAssociatedType();
        if (!translateTypedefs) {
            return type instanceof RfNamedElement ? (RfNamedElement)type : null;
        }
        if (type instanceof RfTypeAlias) {
            type = ((RfTypeAlias)type).getTranslatedType();
        }
        return type instanceof RfNamedElement ? (RfNamedElement)type : null;
    }

    public static String getCalledText(RfFunctionCall aFunctionCall) {
        int lastDot = aFunctionCall.getName().lastIndexOf(46);
        if (lastDot == -1) {
            RfNamedElement closestContainer = aFunctionCall.getClosestTypeContainer();
            if (closestContainer != null) {
                return closestContainer.getName();
            }
            return "";
        }
        return aFunctionCall.getName().substring(0, lastDot);
    }

    public static NamedElementAndString getCalledElementAndSelect(RfFunctionCall aFunctionCall) {
        String calledText = LintUtils.getCalledText(aFunctionCall);
        if (calledText == null) {
            return null;
        }
        String[] nameAndSelect = NamedElementAndString.getNameAndSelect(calledText);
        calledText = nameAndSelect[0];
        String select = nameAndSelect[1];
        RfNamedElement element = LintUtils.getElementFromString(aFunctionCall.getRfProject(), aFunctionCall.getEnclosingScope(), aFunctionCall.getStartOffset(), calledText);
        return new NamedElementAndString(element, select);
    }

    public static String[] getNameAndSelect(String name) {
        return NamedElementAndString.getNameAndSelect(name);
    }

    public static String removeTrailingParens(String aText) {
        if (aText == null) {
            return aText;
        }
        if (!(aText = aText.trim()).endsWith(")")) {
            return aText;
        }
        int nofClosedParens = 0;
        int currPos = aText.length() - 1;
        while (currPos >= 0) {
            if (aText.charAt(currPos) == '(') {
                if (--nofClosedParens == 0) {
                    break;
                }
            } else if (aText.charAt(currPos) == ')') {
                ++nofClosedParens;
            }
            --currPos;
        }
        if (currPos != -1) {
            return aText.substring(0, currPos);
        }
        return aText;
    }

    public static String getHierarchicalId(String aExpr) {
        boolean insideString = false;
        int openParens = 0;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < aExpr.length()) {
            char c = aExpr.charAt(i);
            if (insideString) {
                result.append(c);
                if ('\"' == c && (i == 0 || '\\' != aExpr.charAt(i - 1))) {
                    insideString = !insideString;
                }
            } else {
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        ++openParens;
                        result.append(c);
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        if (openParens > 0) {
                            --openParens;
                            result.append(c);
                            break;
                        }
                        return null;
                    }
                    case '\"': {
                        insideString = true;
                        result.append(c);
                        break;
                    }
                    case '\'': {
                        return result.toString();
                    }
                    default: {
                        if (insideString || openParens > 0) {
                            result.append(c);
                            break;
                        }
                        if ('.' == c || ':' == c || '_' == c || '$' == c || '#' == c || Character.isLetter(c) || Character.isDigit(c) || Character.isWhitespace(c)) {
                            result.append(c);
                            break;
                        }
                        return null;
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String trimParens(String aString) {
        if (aString == null) {
            return null;
        }
        String result = aString.trim();
        while (result.startsWith("(") && result.endsWith(")")) {
            result = result.substring(1, result.length() - 1);
            result = result.trim();
        }
        return result;
    }

    public static boolean isFourStateType(IRfNamedElement type, boolean withTime) {
        if (type instanceof RfBitVectorScalarType) {
            type = ((RfBitVectorScalarType)type).getScalarWithDefaultSign();
            if (!withTime && "time".equals(type.getName())) {
                return false;
            }
            if (FOUR_STATE_BASE_TYPES.contains(type.getName())) {
                return true;
            }
        }
        if (type instanceof RfTypeAlias) {
            IRfNamedElement elementType = ((RfTypeAlias)type).getTranslatedType();
            return elementType instanceof RfNamedElement && LintUtils.isFourStateType(elementType, withTime);
        }
        if (type instanceof RfListType && ((RfListType)type).isPacked()) {
            IRfNamedElement elementType = ((RfListType)type).getAssociatedType();
            return elementType instanceof RfNamedElement && LintUtils.isFourStateType(elementType, withTime);
        }
        if (type instanceof RfStruct) {
            if ((((RfStruct)type).isStruct() || ((RfStruct)type).isUnion()) && ((RfStruct)type).isPacked()) {
                List<RfField> localFields = ((RfStruct)type).getLocalMembers(RfField.class);
                for (RfField field : localFields) {
                    if (!LintUtils.isFourStateType(field.getAssociatedType(), withTime)) continue;
                    return true;
                }
                return false;
            }
            if (((RfStruct)type).isEnum()) {
                return LintUtils.isFourStateType(((RfStruct)type).getEnumBaseType(), withTime);
            }
        }
        return false;
    }

    public static boolean isTimeValue(String str) {
        if (str == null) {
            return false;
        }
        Matcher m = TIME_VALUE_PATTERN.matcher(str);
        return m.matches();
    }

    public static boolean isIntegralNumber(String str) {
        return LintUtils.isDecimalNumber(str) || LintUtils.isOctalNumber(str) || LintUtils.isHexNumber(str) || LintUtils.isBinaryNumber(str);
    }

    public static boolean isDecimalNumber(String str) {
        if (str == null) {
            return false;
        }
        Matcher m = DEC_NUM_PATTERN.matcher(str);
        return m.matches();
    }

    public static boolean isOctalNumber(String str) {
        if (str == null) {
            return false;
        }
        Matcher m = OCT_NUM_PATTERN.matcher(str);
        return m.matches();
    }

    public static boolean isHexNumber(String str) {
        if (str == null) {
            return false;
        }
        Matcher m = HEX_NUM_PATTERN.matcher(str);
        return m.matches();
    }

    public static boolean isBinaryNumber(String str) {
        if (str == null) {
            return false;
        }
        Matcher m = BIN_NUM_PATTERN.matcher(str);
        return m.matches();
    }

    public static boolean isRealNumber(String str) {
        if (str == null) {
            return false;
        }
        Matcher m = REAL_NUM_PATTERN.matcher(str);
        return m.matches();
    }

    public static boolean isStringLiteral(String str) {
        boolean insideString = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (insideString) {
                if (c == '\"' && (i == 0 || '\\' != str.charAt(i - 1))) {
                    insideString = false;
                }
            } else if (c == '\"') {
                insideString = true;
            } else if (!Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInConditionalActionBlock(IRfScope scope) {
        IRfScope enclScope = scope;
        while (enclScope != null) {
            if (enclScope instanceof RfActionBlock && ((RfActionBlock)enclScope).isConditional()) {
                return true;
            }
            enclScope = enclScope.getEnclosingScope();
        }
        return false;
    }

    public static int stringOperatorToVlogLexerTokenType(String operator) {
        if (operator != null) {
            if ("**".equals(operator = operator.trim())) {
                return 506;
            }
            if ("*".equals(operator)) {
                return 462;
            }
            if ("/".equals(operator)) {
                return 463;
            }
            if ("%".equals(operator)) {
                return 464;
            }
            if ("+".equals(operator)) {
                return 465;
            }
            if ("-".equals(operator)) {
                return 467;
            }
            if (">>".equals(operator)) {
                return 469;
            }
            if ("<<".equals(operator)) {
                return 470;
            }
            if (">>>".equals(operator)) {
                return 507;
            }
            if ("<<<".equals(operator)) {
                return 508;
            }
            if (">".equals(operator)) {
                return 487;
            }
            if ("<".equals(operator)) {
                return 486;
            }
            if (">=".equals(operator)) {
                return 489;
            }
            if ("<=".equals(operator)) {
                return 488;
            }
            if ("inside".equals(operator)) {
                return 128;
            }
            if ("==".equals(operator)) {
                return 482;
            }
            if ("!=".equals(operator)) {
                return 483;
            }
            if ("===".equals(operator)) {
                return 484;
            }
            if ("!==".equals(operator)) {
                return 485;
            }
            if ("==?".equals(operator)) {
                return 502;
            }
            if ("!=?".equals(operator)) {
                return 504;
            }
            if ("&".equals(operator)) {
                return 471;
            }
            if ("^".equals(operator)) {
                return 475;
            }
            if ("^~".equals(operator)) {
                return 476;
            }
            if ("~^".equals(operator)) {
                return 476;
            }
            if ("|".equals(operator)) {
                return 473;
            }
            if ("&&".equals(operator)) {
                return 480;
            }
            if ("||".equals(operator)) {
                return 481;
            }
            if ("?".equals(operator)) {
                return 499;
            }
            if ("->".equals(operator)) {
                return 534;
            }
            if ("<->".equals(operator)) {
                return 535;
            }
        }
        return -1;
    }

    public static int getMacroCallLevel(RfNamedElement elem) {
        int macroStackSize = 0;
        if (elem.getDeclaration().getReparseInfo() == null) {
            return macroStackSize;
        }
        macroStackSize = elem.getDeclaration().getReparseInfo().getReparseStackSize();
        return macroStackSize;
    }

    public static String getMacroCallString(MacroCallItem aMacroCall) {
        if (aMacroCall == null) {
            return "";
        }
        StringBuilder macroSignature = new StringBuilder();
        macroSignature.append(String.valueOf(aMacroCall.getName()) + "(");
        String[] macroArgs = aMacroCall.getMacroParameters();
        if (macroArgs != null) {
            int i = 0;
            while (i < macroArgs.length) {
                if (i != 0) {
                    macroSignature.append(", ");
                }
                macroSignature.append(macroArgs[i]);
                ++i;
            }
        }
        macroSignature.append(")");
        return "" + macroSignature;
    }

    public static String getFileShortName(String fileName) {
        if (fileName == null) {
            return "";
        }
        File f2 = new File(fileName);
        String name = f2.getName();
        return name == null ? "" : name;
    }

    public static String getFileRelativePathName(String fileName, String projectPath) {
        if (fileName == null) {
            return "";
        }
        Path filePath = Paths.get(fileName, new String[0]);
        Path refsPath = Paths.get(projectPath, new String[0]);
        Path basePathToPath = refsPath.relativize(filePath);
        return basePathToPath == null ? "" : basePathToPath.normalize().toString();
    }

    public static RfNamedElement getEnclosingPhysicalType(RfProject aRfProject, ParserPath aParserPath, int aStartOffset) {
        RfFileDef filedef = aRfProject.getFileDefUsingParserPath(aParserPath);
        if (filedef == null) {
            return null;
        }
        RfDefElement defElement = filedef.getScope(aStartOffset, true);
        if (defElement == null) {
            return null;
        }
        RfNamedElement result = defElement.getNamedElement();
        while (result != null) {
            if (LintUtils.isPhysicalType(result)) {
                return result;
            }
            result = result.getEnclosingScope();
        }
        return null;
    }

    public static RfNamedElement getCalledInPhysicalType(RfFunctionCall aCall) {
        if (aCall == null || aCall.getRfProject() == null || aCall.getFile() == null || aCall.getDeclaration() == null) {
            return null;
        }
        return LintUtils.getEnclosingPhysicalType(aCall.getRfProject(), aCall.getFile().getParserPath(), aCall.getDeclaration().getStartOffset());
    }

    public static RfNamedElement getCallOfPhysicalType(RfFunctionCall aCall) {
        RfNamedElement result = aCall.getCalledFromScope();
        while (result != null) {
            if (LintUtils.isPhysicalType(result)) {
                return result;
            }
            result = result.getEnclosingScope();
        }
        return result;
    }

    private static boolean isPhysicalType(RfNamedElement aNamedElement) {
        return aNamedElement instanceof RfClass || aNamedElement instanceof RfModule || aNamedElement instanceof RfProgram || aNamedElement instanceof RfInterface || aNamedElement instanceof RfPackage;
    }

    public static RfFunction getVirtualFunction(RfFunction function) {
        if (function == null) {
            return null;
        }
        if (function.hasVirtualQualifier()) {
            return function;
        }
        return function.getParentVirtual(false);
    }

    public static RfFunction getTopVirtualFunction(RfFunction function) {
        RfFunction parentVirtual;
        if (function == null) {
            return null;
        }
        RfFunction result = null;
        if (function.hasVirtualQualifier()) {
            result = function;
        }
        if ((parentVirtual = function.getParentVirtual(true)) != null) {
            result = parentVirtual;
        }
        return result;
    }

    public static RfFunction getTopFunction(RfFunction function) {
        if (function == null) {
            return null;
        }
        RfFunction result = function;
        RfNamedElement enclosingScope = function.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
            return result;
        }
        RfClass classs = (RfClass)enclosingScope;
        RfClass parentClass = classs.getParent();
        while (parentClass != null) {
            RfFunction parentFunction = parentClass.getLocalMember(RfFunction.class, function.getName(), false);
            if (parentFunction != null) {
                result = parentFunction;
            }
            parentClass = parentClass.getParent();
        }
        return result;
    }

    public static String getElementKind(RfNamedElement element) {
        RfNamedElement enclosingScope = element.getEnclosingScope();
        String globalPrefix = "";
        if (enclosingScope instanceof RfLibrary) {
            globalPrefix = "global ";
        }
        if (element instanceof RfField) {
            RfField fieldElement = (RfField)element;
            if (fieldElement instanceof RfPort) {
                RfPort portElement = (RfPort)element;
                if (portElement.isInput()) {
                    return "input port";
                }
                if (portElement.isOutput()) {
                    return "output port";
                }
                if (portElement.isInout()) {
                    return "inout port";
                }
                if (portElement.isRef()) {
                    return "ref port";
                }
                if (portElement.isInterfacePort()) {
                    return "interface port";
                }
                if (portElement.isModportPort()) {
                    return "modport port";
                }
                return "port";
            }
            if (fieldElement.isVariable()) {
                return "variable";
            }
            if (fieldElement instanceof RfInstance) {
                return "instance";
            }
            if (fieldElement.isLocalParameter()) {
                return "localparam";
            }
            if (fieldElement.isSpecParam()) {
                return "specparam";
            }
            if (fieldElement.isAliasParam()) {
                return "aliasparam";
            }
            if (fieldElement.isDynamicParam()) {
                return "dynamicparam";
            }
            if (fieldElement.isTypeParameter()) {
                return "type parameter";
            }
            if (fieldElement.isParameter()) {
                return "parameter";
            }
            if (fieldElement.isArgument()) {
                return "argument";
            }
            if (fieldElement.isEvent()) {
                return "event";
            }
            if (fieldElement.isEnumElement()) {
                return "enum item";
            }
            if (fieldElement instanceof RfCovercross) {
                return "covercross";
            }
            if (fieldElement instanceof RfCoverpoint) {
                return "coverpoint";
            }
            if (enclosingScope instanceof RfClass) {
                return "field";
            }
            if (enclosingScope instanceof RfModule) {
                return "module signal";
            }
            if (enclosingScope instanceof RfInterface) {
                return "interface signal";
            }
            if (enclosingScope instanceof RfPackage) {
                return "package variable";
            }
            if (enclosingScope instanceof RfLibrary) {
                return "global variable";
            }
            if (enclosingScope instanceof RfStruct) {
                if (((RfStruct)enclosingScope).isUnion()) {
                    return "union member";
                }
                return "struct member";
            }
            return "field";
        }
        if (element instanceof RfFunction) {
            if (((RfFunction)element).isTask()) {
                return String.valueOf(globalPrefix) + "task";
            }
            return String.valueOf(globalPrefix) + "function";
        }
        if (element instanceof RfTypeAlias) {
            return String.valueOf(globalPrefix) + "typedef";
        }
        if (element instanceof RfClass) {
            return String.valueOf(globalPrefix) + "class";
        }
        if (element instanceof RfStruct) {
            RfStruct structElement = (RfStruct)element;
            if (structElement.isUnion()) {
                return String.valueOf(globalPrefix) + "union";
            }
            if (structElement.isEnum()) {
                return String.valueOf(globalPrefix) + "enum";
            }
            return String.valueOf(globalPrefix) + "struct";
        }
        if (element instanceof RfModule) {
            return "module";
        }
        if (element instanceof RfInterface) {
            return "interface";
        }
        if (element instanceof RfModport) {
            return "modport";
        }
        if (element instanceof RfClockingBlock) {
            return "clocking block";
        }
        if (element instanceof RfCovergroup) {
            return "covergroup";
        }
        if (element instanceof RfConstraint) {
            return "constraint";
        }
        if (element instanceof RfAssertExpect) {
            RfAssertExpect assertElement = (RfAssertExpect)element;
            if (assertElement.isAssert()) {
                return "assert";
            }
            if (assertElement.isAssume()) {
                return "assume";
            }
            if (assertElement.isExpect()) {
                return "expect";
            }
            if (assertElement.isCover()) {
                return "cover";
            }
            if (assertElement.isRestrict()) {
                return "restrict";
            }
        }
        if (element instanceof RfPackage) {
            return "package";
        }
        if (element instanceof RfGenerateBlock) {
            return "generate block";
        }
        if (element instanceof RfActionBlock) {
            return "action block";
        }
        if (element instanceof RfPrimitive) {
            return "primitive";
        }
        if (element instanceof RfProgram) {
            return "program";
        }
        if (element instanceof RfChecker) {
            return "checker";
        }
        if (element instanceof RfConfiguration) {
            return "configuration";
        }
        if (element instanceof VlogMacroInfo) {
            return "macro";
        }
        return "";
    }

    public static String getScopeDetails(RfProject rfProject, ParserPath parserPath, int offset) {
        if (rfProject == null || parserPath == null) {
            return "";
        }
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return "";
        }
        RfDefElement defScope = fileDef.getScope(offset, true);
        if (defScope == null) {
            return "";
        }
        return LintUtils.getScopeDetails(defScope);
    }

    public static String getScopeDetails(RfDefElement defScope) {
        RfNamedElement scope = defScope.getNamedElement();
        if (scope == null) {
            return "";
        }
        DVTStringBuilder result = new DVTStringBuilder();
        boolean isPrevBlock = false;
        while (scope != null) {
            boolean isCurrBlock = false;
            if (scope instanceof RfActionBlock || scope instanceof RfGenerateBlock) {
                isCurrBlock = true;
            }
            if (!isPrevBlock || !isCurrBlock) {
                String scopeName = LintUtils.getScopeName(scope);
                if (result.length() != 0 && scopeName.length() != 0) {
                    result.prepend(" ");
                }
                result.prepend(scopeName);
            }
            isPrevBlock = isCurrBlock;
            scope = scope.getEnclosingScope();
        }
        return result.toString();
    }

    public static String getScopeName(RfNamedElement scope) {
        if (scope == null) {
            return "";
        }
        if (scope instanceof RfLibrary) {
            return "library '" + scope.getName() + "'";
        }
        if (scope instanceof RfChecker) {
            return "checker '" + scope.getName() + "'";
        }
        if (scope instanceof RfPackage) {
            return "package '" + scope.getName() + "'";
        }
        if (scope instanceof RfModule) {
            return "module '" + scope.getName() + "'";
        }
        if (scope instanceof RfInterface) {
            return "interface '" + scope.getName() + "'";
        }
        if (scope instanceof RfClass) {
            return "class '" + scope.getName() + "'";
        }
        if (scope instanceof RfTypeAlias) {
            return "typedef '" + scope.getName() + "'";
        }
        if (scope instanceof RfCovergroup) {
            return "covergroup '" + scope.getName() + "'";
        }
        if (scope instanceof RfPrimitive) {
            return "primitive'" + scope.getName() + "'";
        }
        if (scope instanceof RfProgram) {
            return "program'" + scope.getName() + "'";
        }
        if (scope instanceof RfConstraint) {
            return "constraint '" + scope.getName() + "'";
        }
        if (scope instanceof RfStruct) {
            RfStruct structElement = (RfStruct)scope;
            if (structElement.isUnion()) {
                return "union";
            }
            if (structElement.isEnum()) {
                return "enum";
            }
            return "struct";
        }
        if (scope instanceof RfFunction) {
            if (((RfFunction)scope).isTask()) {
                return "task '" + scope.getName() + "'";
            }
            return "function '" + scope.getName() + "'";
        }
        if (scope instanceof RfActionBlock) {
            return "block";
        }
        if (scope instanceof RfGenerateBlock) {
            return "block";
        }
        return "";
    }

    public static String getCallText(RfFunctionCall call) {
        StringBuilder callString = new StringBuilder(call.getName()).append("(");
        List<String> arguments = call.getArguments();
        if (arguments != null) {
            int i = 0;
            while (i < arguments.size()) {
                if (i != 0) {
                    callString.append(", ");
                }
                callString.append(arguments.get(i));
                ++i;
            }
        }
        callString.append(")");
        return callString.toString();
    }

    public static String getHierarchicalPath(Hid hid) {
        StringBuilder result = new StringBuilder();
        LintUtils.getHierarchicalPath(hid, result);
        return result.toString();
    }

    private static void getHierarchicalPath(Hid hid, StringBuilder result) {
        Hid parentHid;
        if (hid == null) {
            return;
        }
        HidAccess hidAccess = hid.getParentAccess();
        if (hidAccess != null && (parentHid = hidAccess.getParentHid()) != null) {
            int accessKind = hidAccess.getAccessKind();
            switch (accessKind) {
                case 0: {
                    LintUtils.getHierarchicalPath(parentHid, result);
                    result.append('.');
                    break;
                }
                case 1: {
                    LintUtils.getHierarchicalPath(parentHid, result);
                    result.append(':');
                    break;
                }
                case 2: {
                    LintUtils.getHierarchicalPath(parentHid, result);
                    result.append("::");
                    break;
                }
            }
        }
        result.append(hid.getName());
    }

    public static Set<String> getValidTypedefsForMacroRegistration(final RfClass classs) {
        HashSet<String> validTypeDefs = new HashSet<String>();
        RfNamedElement[] allTypedefs = classs.getAllTypedefs(true);
        List<RfField> parameters = classs.getParametersWithPrefix("", 384, 2, 1);
        final ArrayList<String> paramNames = new ArrayList<String>();
        for (RfField param : parameters) {
            if (!param.isInParameterPortList()) continue;
            paramNames.add(param.getName());
        }
        RfNamedElement[] rfNamedElementArray = allTypedefs;
        int n = allTypedefs.length;
        int n2 = 0;
        while (n2 < n) {
            RfHidHolder paramValuesHolder;
            DataType translatedDataType;
            IRfNamedElement translatedType;
            RfNamedElement typeDef = rfNamedElementArray[n2];
            if (typeDef instanceof RfTypeAlias && (translatedType = ((RfTypeAlias)typeDef).getTranslatedType()) != null && (translatedType.equals(classs) || translatedType instanceof RfClass && ((RfClass)translatedType).getGenericClass().equals(classs)) && (translatedDataType = ((RfTypeAlias)typeDef).getTranslatedDataType()) != null && ((paramValuesHolder = translatedDataType.getParamValuesHolder()) != null || paramNames.isEmpty())) {
                final boolean[] invalidTypedef = new boolean[1];
                if (paramValuesHolder != null) {
                    paramValuesHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidOperator>(){

                        public boolean visit(IHidOperator hidObject) {
                            IRfNamedElement element;
                            if (!(hidObject instanceof RfHidOperator)) {
                                return true;
                            }
                            HidOperator hidop = (HidOperator)hidObject;
                            IHidObject lhValue = hidop.getLHValue();
                            if (lhValue instanceof RfHid) {
                                IRfNamedElement element2 = ((RfHid)lhValue).getElement();
                                if (element2 == null) {
                                    return true;
                                }
                                IRfScopeElement enclosingScope = element2.getEnclosingScope();
                                if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
                                    return true;
                                }
                                if (!enclosingScope.equals(classs) && !((RfClass)enclosingScope).getGenericClass().equals(classs)) {
                                    return true;
                                }
                                if (!paramNames.contains(element2.getName())) {
                                    invalidTypedef[0] = true;
                                    return false;
                                }
                            } else {
                                invalidTypedef[0] = true;
                                return false;
                            }
                            ListContainer rhValues = hidop.getRHValues();
                            if (rhValues == null || rhValues.isEmpty()) {
                                return false;
                            }
                            IHidObject iHidObject = (IHidObject)rhValues.get(0);
                            if (iHidObject instanceof RfHid) {
                                element = ((RfHid)iHidObject).getElement();
                                if (element == null) {
                                    return true;
                                }
                                IRfScopeElement enclosingScope = element.getEnclosingScope();
                                if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
                                    return true;
                                }
                                if (!enclosingScope.equals(classs) && !((RfClass)enclosingScope).getGenericClass().equals(classs)) {
                                    return true;
                                }
                                if (!paramNames.contains(element.getName())) {
                                    invalidTypedef[0] = true;
                                    return false;
                                }
                            } else {
                                invalidTypedef[0] = true;
                                return false;
                            }
                            paramNames.remove(element.getName());
                            return true;
                        }

                        public Class<IHidOperator> getType() {
                            return IHidOperator.class;
                        }
                    });
                }
                if (!invalidTypedef[0]) {
                    if (paramNames.isEmpty()) {
                        validTypeDefs.add(typeDef.getName());
                    }
                    paramNames.clear();
                    for (RfField param : parameters) {
                        if (!param.isInParameterPortList()) continue;
                        paramNames.add(param.getName());
                    }
                }
            }
            ++n2;
        }
        return validTypeDefs;
    }

    public static RfFunction getStrictFirstDefinition(RfFunction function) {
        if (function == null) {
            return null;
        }
        RfFunction result = function;
        RfNamedElement enclosingScope = function.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
            return result;
        }
        RfClass classs = (RfClass)enclosingScope;
        RfClass parentClass = classs.getParent();
        while (parentClass != null) {
            RfFunction parentFunction = parentClass.getLocalMember(RfFunction.class, function.getName(), false);
            if (parentFunction != null && LintUtils.checkSameSignature(parentFunction, function, classs)) {
                result = parentFunction;
            }
            parentClass = parentClass.getParent();
        }
        return result;
    }

    public static boolean checkSameSignature(RfFunction virtualMethod, RfFunction overrideMethod, RfClass clazz) {
        RfDefElement overrideMethodDecl = overrideMethod.getDeclaration();
        if (overrideMethodDecl == null) {
            return false;
        }
        RfFileDef defFile = overrideMethodDecl.getDefFile();
        if (defFile == null) {
            return false;
        }
        RfDefElement virtualMethodDecl = virtualMethod.getDeclaration();
        if (virtualMethodDecl == null) {
            return false;
        }
        boolean virtualMethodIsTask = virtualMethod.isTask();
        boolean overrideMethodIsTask = overrideMethod.isTask();
        if (virtualMethodIsTask && !overrideMethodIsTask) {
            return false;
        }
        if (!virtualMethodIsTask && overrideMethodIsTask) {
            return false;
        }
        if (!LintUtils.checkFunctionType(virtualMethod, overrideMethod, clazz)) {
            return false;
        }
        return LintUtils.checkArguments(virtualMethodDecl, overrideMethodDecl, virtualMethod, overrideMethod, clazz);
    }

    private static boolean checkFunctionType(RfFunction virtualMethod, RfFunction overrideMethod, RfClass clazz) {
        String typeName = virtualMethod.implicitSpecificTypeName();
        RfDefElement virtualMethodDecl = virtualMethod.getDeclaration();
        DataType virtualMethodDataType = ((RfFunctionDef)virtualMethodDecl).getTypeInfoOrImplicit(typeName, virtualMethod);
        RfDefElement overrideMethodDecl = overrideMethod.getDeclaration();
        DataType overrideMethodDataType = ((RfFunctionDef)overrideMethodDecl).getTypeInfoOrImplicit(typeName, overrideMethod);
        if (overrideMethodDataType == null || virtualMethodDataType == null || overrideMethodDataType.equalsDataTypeTypeName(virtualMethodDataType)) {
            return true;
        }
        if ("void".equals(overrideMethodDataType.getType()) || "void".equals(virtualMethodDataType.getType())) {
            return false;
        }
        return LintUtils.isMatchingTypes(virtualMethodDataType, overrideMethodDataType, virtualMethod, overrideMethod, false, clazz);
    }

    private static boolean checkArguments(RfDefElement virtualMethodDecl, RfDefElement overrideMethodDecl, RfFunction virtualMethodNamedElement, RfFunction overrideMethodNamedElement, RfClass clazz) {
        if (virtualMethodNamedElement == null || overrideMethodNamedElement == null) {
            return false;
        }
        List<ArgInfo> virtualMethodArgsInfo = ((RfFunctionDef)virtualMethodDecl).getArgumentInfos();
        List<ArgInfo> overrideMethodArgsInfo = ((RfFunctionDef)overrideMethodDecl).getArgumentInfos();
        if (virtualMethodArgsInfo == null && overrideMethodArgsInfo == null) {
            return true;
        }
        if (overrideMethodArgsInfo == null && virtualMethodArgsInfo != null) {
            return false;
        }
        if (virtualMethodArgsInfo == null && overrideMethodArgsInfo != null) {
            return false;
        }
        if (virtualMethodArgsInfo == null || overrideMethodArgsInfo == null) {
            return false;
        }
        if (virtualMethodArgsInfo.size() != overrideMethodArgsInfo.size()) {
            return false;
        }
        int i = 0;
        while (i < virtualMethodArgsInfo.size()) {
            ArgInfo virtualMethodArgInfo = virtualMethodArgsInfo.get(i);
            ArgInfo overrideMethodArgInfo = overrideMethodArgsInfo.get(i);
            if (virtualMethodArgInfo != null && overrideMethodArgInfo != null) {
                String virtualMethodArgName = virtualMethodArgInfo.getName();
                String overrideMethodArgName = overrideMethodArgInfo.getName();
                DataType virtualMethodArgDataType = virtualMethodArgInfo.getDataType();
                DataType overrideMethodArgDataType = overrideMethodArgInfo.getDataType();
                if (virtualMethodArgDataType != null && overrideMethodArgDataType != null) {
                    byte overrideMethodArgDirection;
                    if (!LintUtils.isMatchingTypes(virtualMethodArgDataType, overrideMethodArgDataType, virtualMethodNamedElement, overrideMethodNamedElement, true, clazz)) {
                        return false;
                    }
                    if (!virtualMethodArgName.equals(overrideMethodArgName)) {
                        return false;
                    }
                    byte virtualMethodArgDirection = virtualMethodArgDataType.getDirection();
                    if (virtualMethodArgDirection != (overrideMethodArgDirection = overrideMethodArgDataType.getDirection())) {
                        return false;
                    }
                    String virtualMethodArgInitValue = virtualMethodArgInfo.getInitialValue();
                    String overrideMethodArgInitValue = overrideMethodArgInfo.getInitialValue();
                    if (virtualMethodArgInitValue != null && overrideMethodArgInitValue == null) {
                        return false;
                    }
                    if (virtualMethodArgInitValue == null && overrideMethodArgInitValue != null) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private static boolean isMatchingTypes(DataType virtualDataType, DataType overrideDataType, RfFunction virtualMethod, RfFunction overrideMethod, boolean forceClassMatching, RfClass clazz) {
        RfProject rfProject = clazz.getRfProject();
        ConfigInfo configInfo = new ConfigInfo(false, rfProject, null, false, rfProject.getToolCompat());
        RfPredefinedField dummyLHSide = new RfPredefinedField("", virtualDataType, 1, 0, null, null);
        dummyLHSide.setEnclosingScope(virtualMethod);
        RfPredefinedField dummyRHSide = new RfPredefinedField("", overrideDataType, 1, 0, null, null);
        dummyRHSide.setEnclosingScope(overrideMethod);
        ISDataAbstract result = SEvaluator.INSTANCE.checkTypeCompatibility(dummyLHSide, dummyRHSide, forceClassMatching, true, (IRfNamedElement)clazz, configInfo);
        return !SDataUtils.isIllegalDataType((ISDataAbstract)result);
    }

    public static boolean isSubClassOf(RfClass child, RfClass baseClass) {
        if (child == null || baseClass == null) {
            return false;
        }
        RfClass parent = child;
        do {
            if (!parent.equals(baseClass) && !parent.getGenericClass().equals(baseClass)) continue;
            return true;
        } while ((parent = parent.getParent()) != null);
        return false;
    }

    public static boolean isSubClassOfAny(RfClass child, Set<RfClass> baseClasses) {
        if (child == null || baseClasses == null) {
            return false;
        }
        RfClass parent = child;
        do {
            if (!baseClasses.contains(parent) && !baseClasses.contains(parent.getGenericClass())) continue;
            return true;
        } while ((parent = parent.getParent()) != null);
        return false;
    }

    public static Map<ParserPath, List<SVTBIssues>> removeCycleDelayIssuesInAssertions(RfProject rfProject, Map<ParserPath, List<SVTBIssues>> issuesMap) {
        HashMap<ParserPath, List<SVTBIssues>> result = new HashMap<ParserPath, List<SVTBIssues>>();
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : issuesMap.entrySet()) {
            ParserPath path = entry.getKey();
            RfFileDef fileDefUsingParserPath = rfProject.getFileDefUsingParserPath(path);
            if (fileDefUsingParserPath == null) continue;
            ArrayList<SVTBIssues> resultIssues = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue : entry.getValue()) {
                RfNamedElement assertElement;
                RfDefElement defScope = fileDefUsingParserPath.getScope(issue.getOffset(), true);
                if (defScope instanceof RfPropertySequenceDef) continue;
                if (defScope instanceof RfAssertExpectDef && (assertElement = defScope.getNamedElement()) instanceof RfAssertExpect) {
                    IHidObject expression = ((RfAssertExpect)assertElement).getExpression();
                    boolean inAssertExpression = false;
                    if (expression instanceof IHidOperator) {
                        Set implicits = HidUtils.flattenToOperators((IHidOperator)((IHidOperator)expression));
                        for (IHidOperator implicit : implicits) {
                            if (implicit.getOccurrence().getOffset() != issue.getOffset()) continue;
                            inAssertExpression = true;
                            break;
                        }
                    }
                    if (inAssertExpression) continue;
                }
                resultIssues.add(issue);
            }
            if (resultIssues.isEmpty()) continue;
            result.put(path, resultIssues);
        }
        return result;
    }

    public static boolean isSetOrGetConfigurationFunction(RfHid hid, List<String> setFunctionWrappers, List<String> getFunctionWrappers, boolean checkSetConfig, boolean checkGetConfig) {
        HidAccess parentAccess = hid.getParentAccess();
        IRfNamedElement associatedType = parentAccess != null ? (parentAccess.getAssociatedType() instanceof RfAssociatedType ? LintUtils.getAssociatedFinalType((RfAssociatedType)parentAccess.getAssociatedType()) : parentAccess.getAssociatedType()) : null;
        IRfNamedElement hidNamedElement = hid.getElement();
        if (hidNamedElement == null) {
            return false;
        }
        String hidName = hidNamedElement.getName();
        if (hidName == null) {
            return false;
        }
        if (setFunctionWrappers.contains(hidName) && checkSetConfig || getFunctionWrappers.contains(hidName) && checkGetConfig) {
            if (associatedType == null) {
                associatedType = (IRfNamedElement)hidNamedElement.getEnclosingScope();
            }
            if (associatedType instanceof RfPackage && "uvm_pkg".equals(((RfPackage)associatedType).getName())) {
                return true;
            }
            if (associatedType instanceof RfClass && ((RfClass)associatedType).isSubClass("uvm_component", true)) {
                return true;
            }
        } else if (("set".equals(hidNamedElement.getName()) && checkSetConfig || "get".equals(hidNamedElement.getName()) && checkGetConfig) && associatedType instanceof RfClass && ("uvm_config_db".equals(associatedType.getName()) || ((RfClass)associatedType).isSubClass("uvm_config_db", true))) {
            return true;
        }
        return false;
    }

    public static String getHidName(IHid hid) {
        RfNamedElement element = (RfNamedElement)hid.getElement();
        if (element == RfHid.SYSTEM_TASK_UNRESOLVED_HID) {
            return hid.getName();
        }
        return element.getName();
    }

    public static String getHidFullName(IHid hid) {
        RfNamedElement element = (RfNamedElement)hid.getElement();
        if (element == RfHid.SYSTEM_TASK_UNRESOLVED_HID) {
            return hid.getName();
        }
        return element.getFullName();
    }

    public static boolean isSingletonCall(RfHid objectHid, RfHid callHid, IRfNamedElement scope, boolean checkCreate, boolean checkNew) {
        boolean createOrNew = false;
        if (checkCreate) {
            createOrNew = LintUtils.checkIsCreateCall(callHid);
        }
        if (checkNew && !createOrNew) {
            createOrNew = LintUtils.checkIsNewCall(callHid);
        }
        if ((checkCreate || checkNew) && !createOrNew) {
            return false;
        }
        RfClass enclosingClass = null;
        enclosingClass = scope instanceof RfClass ? (RfClass)scope : (RfClass)scope.getEnclosingScope(RfClass.class);
        if (enclosingClass == null) {
            return false;
        }
        RfFunction enclosingFunction = null;
        enclosingFunction = scope instanceof RfFunction ? (RfFunction)scope : (RfFunction)scope.getEnclosingScope(RfFunction.class);
        if (enclosingFunction == null) {
            return false;
        }
        if (!enclosingFunction.isObjectStatic()) {
            return false;
        }
        RfActionBlock enclosingBlock = null;
        enclosingBlock = scope instanceof RfActionBlock ? (RfActionBlock)scope : (RfActionBlock)scope.getEnclosingScope(RfActionBlock.class);
        if (enclosingBlock == null) {
            return false;
        }
        if (!enclosingBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.IF)) {
            return false;
        }
        IHidObject enclosingBlockExpression = enclosingBlock.getConditionalBlockExpression();
        if (enclosingBlockExpression == null) {
            return false;
        }
        if (!(enclosingBlockExpression instanceof RfHidOperator)) {
            return false;
        }
        RfHidOperator blockHidOperator = (RfHidOperator)enclosingBlockExpression;
        if (!blockHidOperator.isEquality()) {
            return false;
        }
        if (blockHidOperator.getLHValue() instanceof RfHid) {
            RfHid lhBlockValue = (RfHid)blockHidOperator.getLHValue();
            if (lhBlockValue == null || lhBlockValue.getElement() == null || !lhBlockValue.getElement().getName().equals(objectHid.getElement().getName())) {
                return false;
            }
            ListContainer rhBlockValues = blockHidOperator.getRHValues();
            if (rhBlockValues == null || rhBlockValues.isEmpty() || rhBlockValues.size() > 1) {
                return false;
            }
            IHidObject rhBlockValue = (IHidObject)rhBlockValues.get(0);
            if (!rhBlockValue.toString().equals("null")) {
                return false;
            }
        } else if (blockHidOperator.getLHValue() instanceof RfHidImplicit && ((RfHidImplicit)blockHidOperator.getLHValue()).getName().equals("null")) {
            ListContainer rhBlockValues = blockHidOperator.getRHValues();
            if (rhBlockValues == null || rhBlockValues.isEmpty() || rhBlockValues.size() > 1) {
                return false;
            }
            if (!(rhBlockValues.get(0) instanceof RfHid)) {
                return false;
            }
            RfHid rhBlockValue = (RfHid)((Object)rhBlockValues.get(0));
            if (rhBlockValue == null || rhBlockValue.getElement() == null || !rhBlockValue.getElement().getName().equals(objectHid.getElement().getName())) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkIsCreateCall(RfHid hid) {
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfFunction)) {
            return false;
        }
        if (!element.getName().equals("create")) {
            return false;
        }
        IRfScopeElement enclosingScope = element.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
            return false;
        }
        Hid typeIDHid = hid.getParentHid();
        if (!(typeIDHid instanceof RfHid) || !typeIDHid.getName().equals("type_id")) {
            return false;
        }
        Hid parentHid = typeIDHid.getParentHid();
        return parentHid instanceof RfHid;
    }

    public static boolean checkIsNewCall(RfHid hid) {
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfFunction)) {
            return false;
        }
        if (!element.getName().equals("new")) {
            return false;
        }
        IRfScopeElement enclosingScope = element.getEnclosingScope();
        return enclosingScope != null && enclosingScope instanceof RfClass;
    }

    public static boolean compareOperatorTrees(RfHidOperator op1, RfHidOperator op2, Set<DVTPair<String, String>> revertedRelationalPairs, Set<String> nonSymmetricOperators, boolean isSymmetric) {
        boolean leftValueFound = false;
        boolean rightValueFound = false;
        String operatorText1 = op1.getOperatorText();
        String operatorText2 = op2.getOperatorText();
        if (operatorText1 == null || operatorText2 == null) {
            return false;
        }
        DVTPair currentPair = new DVTPair((Object)operatorText1, (Object)operatorText2);
        IHidObject letfValue1 = op1.getLHValue();
        IHidObject letfValue2 = op2.getLHValue();
        ListContainer rightValues1 = op1.getRHValues();
        ListContainer rightValues2 = op2.getRHValues();
        if (rightValues1 == null || rightValues2 == null) {
            return false;
        }
        if (op1.isVLOGConcatenation(true) && !op2.isVLOGConcatenation(true) || !op1.isVLOGConcatenation(true) && op2.isVLOGConcatenation(true)) {
            return false;
        }
        if (op1.isVLOGConcatenation(true)) {
            if (rightValues1.size() != rightValues2.size()) {
                return false;
            }
            int index = 0;
            while (index < rightValues1.size()) {
                IHidObject concatElem2;
                IHidObject concatElem1 = (IHidObject)rightValues1.get(index);
                if (!LintUtils.compareExpressions(concatElem1, concatElem2 = (IHidObject)rightValues2.get(index), revertedRelationalPairs, nonSymmetricOperators)) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        IHidObject rightValue1 = (IHidObject)rightValues1.get(0);
        IHidObject rightValue2 = (IHidObject)rightValues2.get(0);
        if (LintUtils.compareExpressions(letfValue1, letfValue2, revertedRelationalPairs, nonSymmetricOperators)) {
            leftValueFound = true;
            if (LintUtils.compareExpressions(rightValue1, rightValue2, revertedRelationalPairs, nonSymmetricOperators)) {
                if (!operatorText1.equals(operatorText2)) {
                    return false;
                }
                rightValueFound = true;
            }
        } else if (isSymmetric && LintUtils.compareExpressions(letfValue1, rightValue2, revertedRelationalPairs, nonSymmetricOperators)) {
            leftValueFound = true;
            if (LintUtils.compareExpressions(rightValue1, letfValue2, revertedRelationalPairs, nonSymmetricOperators)) {
                rightValueFound = true;
            }
        } else if (revertedRelationalPairs != null && revertedRelationalPairs.contains(currentPair) && LintUtils.compareExpressions(letfValue1, rightValue2, revertedRelationalPairs, nonSymmetricOperators)) {
            leftValueFound = true;
            if (LintUtils.compareExpressions(rightValue1, letfValue2, revertedRelationalPairs, nonSymmetricOperators)) {
                rightValueFound = true;
            }
        }
        return rightValueFound && leftValueFound;
    }

    public static boolean compareExpressions(IHidObject o1, IHidObject o2) {
        HashSet<String> nonSymmetricOperators = new HashSet<String>(Arrays.asList("-", "/", "%", "**", "<", "<=", ">", ">=", "&", "|", "^", "^~", "~^", ">>", "<<", ">>>", "<<<", "->"));
        HashSet<DVTPair<String, String>> revertedRelationalPairs = new HashSet<DVTPair<String, String>>(Arrays.asList(new DVTPair((Object)"<", (Object)">"), new DVTPair((Object)">", (Object)"<"), new DVTPair((Object)"<=", (Object)">="), new DVTPair((Object)">=", (Object)"<=")));
        return LintUtils.compareExpressions(o1, o2, revertedRelationalPairs, nonSymmetricOperators);
    }

    public static boolean isImplicitFromMacro(RfHidImplicit implicit, String macroName) {
        IReparseElement ireparseElement = implicit.getLastReparseElement();
        if (!(ireparseElement instanceof ReparseInfo.ReparseElement)) {
            return false;
        }
        ReparseInfo.ReparseElement reparseElement = (ReparseInfo.ReparseElement)ireparseElement;
        return macroName.equals(reparseElement.getReparseMacroName());
    }

    public static boolean compareExpressions(IHidObject o1, IHidObject o2, Set<DVTPair<String, String>> revertedRelationalPairs, Set<String> nonSymmetricOperators) {
        if (o1 instanceof RfHidImplicit && !(o2 instanceof RfHidImplicit) || !(o1 instanceof RfHidImplicit) && o2 instanceof RfHidImplicit) {
            return false;
        }
        if (o1 instanceof RfHid && !(o2 instanceof RfHid) || !(o1 instanceof RfHid) && o2 instanceof RfHid) {
            return false;
        }
        if (o1 instanceof RfHidOperator && !(o2 instanceof RfHidOperator) || !(o1 instanceof RfHidOperator) && o2 instanceof RfHidOperator) {
            return false;
        }
        if (o1 instanceof RfHidAccessArgs && !(o2 instanceof RfHidAccessArgs) || !(o1 instanceof RfHidAccessArgs) && o2 instanceof RfHidAccessArgs) {
            return false;
        }
        if (o1 instanceof RfHidAccess && !(o2 instanceof RfHidAccess) || !(o1 instanceof RfHidAccess) && o2 instanceof RfHidAccess) {
            return false;
        }
        if (o1 instanceof RfHidImplicit) {
            String o1Name = ((RfHidImplicit)o1).getName();
            if (o1Name == null) {
                return false;
            }
            String o2Name = ((RfHidImplicit)o2).getName();
            if (o2Name == null) {
                return false;
            }
            boolean isO1FromMacro = false;
            boolean isO2FromMacro = false;
            if (LintUtils.isImplicitFromMacro((RfHidImplicit)o1, WREALXSTATE)) {
                o1Name = "1'bX";
                isO1FromMacro = true;
            } else if (LintUtils.isImplicitFromMacro((RfHidImplicit)o1, WREALZSTATE)) {
                o1Name = "1'bZ";
                isO1FromMacro = true;
            }
            if (LintUtils.isImplicitFromMacro((RfHidImplicit)o2, WREALXSTATE)) {
                o2Name = "1'bX";
                isO2FromMacro = true;
            } else if (LintUtils.isImplicitFromMacro((RfHidImplicit)o2, WREALZSTATE)) {
                o2Name = "1'bZ";
                isO2FromMacro = true;
            }
            return o1Name.equals(o2Name) && isO1FromMacro == isO2FromMacro;
        }
        if (o1 instanceof RfHid) {
            if (((RfHid)o1).getElement() == null || !((RfHid)o1).getElement().equals(((RfHid)o2).getElement())) {
                return false;
            }
            return LintUtils.checkParentsEquals((RfHid)o1, (RfHid)o2, revertedRelationalPairs, nonSymmetricOperators);
        }
        if (o1 instanceof RfHidAccessArgs) {
            Hid hid1 = ((RfHidAccessArgs)o1).getParentHid();
            Hid hid2 = ((RfHidAccessArgs)o2).getParentHid();
            if (hid1 == null || hid2 == null) {
                return false;
            }
            IRfNamedElement element1 = hid1.getElement();
            if (element1 == null) {
                return false;
            }
            if (!element1.equals(hid2.getElement())) {
                return false;
            }
            if (!hid1.isMethodCall(false) || !hid2.isMethodCall(false)) {
                return false;
            }
            List methodCalls1 = MethodCallUtils.getMethodCalls((IHid)hid1);
            List methodCalls2 = MethodCallUtils.getMethodCalls((IHid)hid2);
            if (methodCalls1.size() != 1 || methodCalls2.size() != 1) {
                return false;
            }
            Map hidArguments1 = ((MethodCall)methodCalls1.get((int)0)).argumentValuesMapRaw;
            Map hidArguments2 = ((MethodCall)methodCalls2.get((int)0)).argumentValuesMapRaw;
            if (hidArguments1 == null || hidArguments2 == null) {
                return false;
            }
            if (hidArguments1.size() != hidArguments2.size()) {
                return false;
            }
            for (Map.Entry entry : hidArguments1.entrySet()) {
                IHidObject firstFunctionArgument = (IHidObject)entry.getValue();
                IHidObject secondFunctionArgument = (IHidObject)hidArguments2.get(entry.getKey());
                if (secondFunctionArgument == null) {
                    return false;
                }
                if (LintUtils.compareExpressions(firstFunctionArgument, secondFunctionArgument, revertedRelationalPairs, nonSymmetricOperators)) continue;
                return false;
            }
            return LintUtils.checkParentsEquals(hid1, hid2, revertedRelationalPairs, nonSymmetricOperators);
        }
        if (o1 instanceof RfHidAccess) {
            List selects2;
            Hid hid1 = ((RfHidAccess)o1).getParentHid();
            Hid hid2 = ((RfHidAccess)o2).getParentHid();
            if (hid1 == null || hid2 == null || hid1.getElement() == null || !hid1.getElement().equals(hid2.getElement())) {
                return false;
            }
            List selects1 = ((RfHidAccess)o1).getSelects();
            if (!LintUtils.compareSelects(selects1, selects2 = ((RfHidAccess)o2).getSelects())) {
                return false;
            }
            return LintUtils.checkParentsEquals(hid1, hid2, revertedRelationalPairs, nonSymmetricOperators);
        }
        if (o1 instanceof RfHidOperator) {
            String o1Text = ((RfHidOperator)o1).getOperatorText();
            String o2Text = ((RfHidOperator)o1).getOperatorText();
            boolean isSymmetric = nonSymmetricOperators != null && !nonSymmetricOperators.contains(o1Text) && !nonSymmetricOperators.contains(o2Text);
            return LintUtils.compareOperatorTrees((RfHidOperator)o1, (RfHidOperator)o2, revertedRelationalPairs, nonSymmetricOperators, isSymmetric);
        }
        return false;
    }

    private static boolean checkParentsEquals(Hid o1, Hid o2, Set<DVTPair<String, String>> revertedRelationalPairs, Set<String> nonSymmetricOperators) {
        HidAccess parent1 = o1.getParentAccess();
        HidAccess parent2 = o2.getParentAccess();
        while (parent1 != null && parent2 != null) {
            List selects2;
            Hid parentHid1 = parent1.getParentHid();
            Hid parentHid2 = parent2.getParentHid();
            if (parentHid1 == null || parentHid2 == null || parentHid1.getElement() == null || !parentHid1.getElement().equals(parentHid2.getElement())) {
                return false;
            }
            List selects1 = parent1.getSelects();
            if (!LintUtils.compareSelects(selects1, selects2 = parent2.getSelects())) {
                return false;
            }
            if (parent1 instanceof RfHidAccessArgs && parent2 instanceof RfHidAccessArgs) {
                if (!parentHid1.isMethodCall(false) || !parentHid2.isMethodCall(false)) {
                    return false;
                }
                List methodCalls1 = MethodCallUtils.getMethodCalls((IHid)parentHid1);
                List methodCalls2 = MethodCallUtils.getMethodCalls((IHid)parentHid2);
                if (methodCalls1.size() != 1 || methodCalls2.size() != 1) {
                    return false;
                }
                Map hidArguments1 = ((MethodCall)methodCalls1.get((int)0)).argumentValuesMapRaw;
                Map hidArguments2 = ((MethodCall)methodCalls2.get((int)0)).argumentValuesMapRaw;
                if (hidArguments1 == null || hidArguments2 == null) {
                    return false;
                }
                if (hidArguments1.size() != hidArguments2.size()) {
                    return false;
                }
                for (Map.Entry entry : hidArguments1.entrySet()) {
                    IHidObject firstFunctionArgument = (IHidObject)entry.getValue();
                    IHidObject secondFunctionArgument = (IHidObject)hidArguments2.get(entry.getKey());
                    if (secondFunctionArgument == null) {
                        return false;
                    }
                    if (LintUtils.compareExpressions(firstFunctionArgument, secondFunctionArgument, revertedRelationalPairs, nonSymmetricOperators)) continue;
                    return false;
                }
            }
            parent1 = parentHid1.getParentAccess();
            parent2 = parentHid2.getParentAccess();
        }
        return parent1 == null && parent2 == null;
    }

    private static boolean compareSelects(List<IHidObject> selects1, List<IHidObject> selects2) {
        if (selects1 == null && selects2 == null) {
            return true;
        }
        if (selects1 == null || selects2 == null) {
            return false;
        }
        if (selects1.size() != selects2.size()) {
            return false;
        }
        int index = 0;
        while (index < selects1.size()) {
            if (!selects1.get(index).equals(selects2.get(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static Set<RfNamedElement> getTopModules(OVMProject ovmProject) {
        HashSet<RfNamedElement> topModules = new HashSet<RfNamedElement>();
        List invocations = BuildConfigManager.getInvocations((IProject)ovmProject.getProject());
        if (invocations != null && !invocations.isEmpty()) {
            for (Invocation invocation : invocations) {
                List allProperties = invocation.getProperties();
                if (allProperties == null) continue;
                for (BuildConfigProperty property : allProperties) {
                    List<Object> array;
                    int index;
                    NullProtectedList<RfNamedElement> allModules;
                    if (property.getKind() != 15 || (allModules = ovmProject.getAllModules()) == null || (index = (array = Arrays.asList(allModules.stream().map(element -> element.getName()).toArray())).indexOf(property.getValue())) < 0) continue;
                    RfNamedElement rfNamedElement = (RfNamedElement)allModules.get(index);
                    topModules.add(rfNamedElement);
                }
            }
        }
        return topModules;
    }

    public static Set<RfNamedElement> getTopModulesCallingRunTest(OVMProject ovmProject) {
        final String runTestName = OVMUtils.prependLibraryPrefixTo(ovmProject.getLibraryKind(), "_pkg::run_test");
        final HashSet<RfNamedElement> desiredModules = new HashSet<RfNamedElement>();
        for (final RfNamedElement module : ovmProject.getAllModules()) {
            module.visitHidObject(ovmProject.getRfProject(), new RfHidVisitor(){

                public boolean visit(RfHid hidObject) {
                    if (hidObject == null) {
                        return true;
                    }
                    IRfNamedElement element = hidObject.getElement();
                    if (!(element instanceof RfFunction)) {
                        return true;
                    }
                    RfFunction method = (RfFunction)element;
                    if (runTestName.equals(method.getFullName())) {
                        desiredModules.add(module);
                        return false;
                    }
                    return true;
                }
            });
        }
        return desiredModules;
    }

    public static RfFunction getValidVirtualFunction(RfFunction function, RfHid hid, RfClass localFunctionClass) {
        if (localFunctionClass == null) {
            return null;
        }
        if (LintUtils.isSuper(hid)) {
            return null;
        }
        if (hid.getParentAccess() != null) {
            return null;
        }
        RfClass scopeClass = function.getEnclosingScope(RfClass.class);
        if (scopeClass == null) {
            return null;
        }
        RfFunction localFunction = null;
        while (LintUtils.isSubClassOf(localFunctionClass, scopeClass)) {
            Collection<RfNamedElement> members = localFunctionClass.getMembers();
            for (RfNamedElement member : members) {
                RfFunction tempFunction;
                if (!(member instanceof RfFunction) || !(tempFunction = (RfFunction)member).getName().equals(function.getName())) continue;
                localFunction = tempFunction;
                break;
            }
            if (localFunction != null) break;
            localFunctionClass = localFunctionClass.getParent();
        }
        return localFunction;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isBitSelect(Hid hidObject, Set<String> allowedBaseTypes) {
        firstAccess = hidObject.getFirstAccess();
        if (firstAccess == null || !firstAccess.isBitSelect() && !firstAccess.isRangeSelect() || firstAccess.getSelects() == null) {
            return false;
        }
        accessSize = firstAccess.getSelects().size();
        elementSize = 0;
        element = hidObject.getElement();
        if (element == null || !(element instanceof RfField)) {
            return false;
        }
        associatedType = ((RfField)element).getAssociatedType();
        if (associatedType != null) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
lbl13:
            // 2 sources

            ** while (associatedType instanceof RfTypeAlias)
        }
lbl14:
        // 1 sources

        associatedBaseType = associatedType;
        if (associatedBaseType instanceof RfAssociatedType) {
            associatedBaseType = ((RfAssociatedType)associatedBaseType).getAssociatedBaseType();
        }
        if (allowedBaseTypes != null && associatedBaseType != null && !allowedBaseTypes.contains(associatedBaseType.getName())) {
            return false;
        }
        if (associatedType instanceof RfListType) {
            elementSize = ((RfListType)associatedType).getNofDimensions();
        }
        return accessSize > elementSize;
    }

    public static boolean isSuper(RfHid hid) {
        HidAccess hidAccess = hid.getParentAccess();
        if (hidAccess == null) {
            return false;
        }
        Hid parentHid = hidAccess.getParentHid();
        if (parentHid == null) {
            return false;
        }
        return parentHid.getName().startsWith("super");
    }

    public static List<RfField> getParamsFromDataType(DataType dataType, RfNamedElement scope) {
        String typeName;
        RfNamedElement scopeCandidate = scope.getPackageOrClassScope(dataType);
        if (scopeCandidate != null) {
            scope = scopeCandidate;
        }
        if ((typeName = dataType.getType()) == null) {
            return null;
        }
        RfParamsHolder candidate = scope.getClassWithPrefix(typeName, 1, 3);
        if (candidate == null) {
            candidate = scope.getModuleWithPrefix(typeName, 1, 3);
        }
        if (candidate == null) {
            candidate = scope.getInterfaceWithPrefix(typeName, 1, 3);
        }
        if (candidate == null) {
            candidate = scope.getProgramWithPrefix(typeName, 1, 3);
        }
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof RfClass && dataType.getInnerClassesInfo() != null && !dataType.getInnerClassesInfo().isEmpty()) {
            for (DataType innerClassInfo : dataType.getInnerClassesInfo()) {
                if (innerClassInfo == null || (candidate = candidate.getClassWithPrefix(innerClassInfo.getType(), 1, 3)) != null) continue;
                return null;
            }
        }
        List<RfField> params = candidate.getParametersWithPrefix("", 384, 2, 1);
        return params;
    }

    public static boolean isVirtualSequence(RfClass sequence, RfClass sequenceBaseClass, RfClass baseSequenceItemClass) {
        sequence = sequence.getDefaultSpecialization(null);
        RfClass parentClass = sequence.getParent();
        while (parentClass != null) {
            if (parentClass instanceof RfSpecializedClass && sequenceBaseClass.equals(((RfSpecializedClass)parentClass).getGenericClass())) break;
            parentClass = parentClass.getParent();
        }
        if (!(parentClass instanceof RfSpecializedClass)) {
            return false;
        }
        Map<String, IELParamValue> params = ((RfSpecializedClass)parentClass).getLocalElabConstantValues();
        if (params.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, IELParamValue> entry : params.entrySet()) {
            if (!(entry.getValue() instanceof ELParamValues.ParamValueType)) {
                return false;
            }
            ELParamValues.ParamValueType paramValue = (ELParamValues.ParamValueType)entry.getValue();
            if (!(paramValue.getNamedElement() instanceof RfClass)) {
                return false;
            }
            RfClass paramClass = (RfClass)paramValue.getNamedElement();
            if (paramClass.equals(baseSequenceItemClass) || paramClass.getGenericClass().equals(baseSequenceItemClass)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVirtualSequencer(RfClass sequencer, RfClass sequencerBaseClass, RfClass baseSequencerItemClass) {
        return LintUtils.isVirtualSequence(sequencer, sequencerBaseClass, baseSequencerItemClass);
    }

    public static boolean isDriverSequencer(RfClass sequencer, RfClass sequencerBaseClass, RfClass baseSequencerItemClass) {
        return LintUtils.isSubClassOf(sequencer, sequencerBaseClass) && !LintUtils.isVirtualSequencer(sequencer, sequencerBaseClass, baseSequencerItemClass);
    }

    public static PathType getAccessType(RfHid functionCall, String methodName) {
        ListContainer accessArgs = functionCall.getAccesses();
        for (HidAccess currentAccess : accessArgs) {
            List<? extends IHidObject> argumentValues;
            if (!(currentAccess instanceof RfHidAccessArgs) || (argumentValues = ((RfHidAccessArgs)currentAccess).getArgumentValues()) == null || argumentValues.isEmpty()) continue;
            for (IHidObject iHidObject : argumentValues) {
                IHidObject rightOperand;
                IHidObject leftOperand;
                if (!(iHidObject instanceof RfHidOperator) || !((leftOperand = ((RfHidOperator)iHidObject).getLHValue()) instanceof RfHid) || !((RfHid)leftOperand).getElement().getName().equals("path") || !((rightOperand = (IHidObject)((RfHidOperator)iHidObject).getRHValues().get(0)) instanceof RfHid)) continue;
                if (((RfHid)rightOperand).getName().equals("UVM_BACKDOOR")) {
                    return PathType.BACKDOOR;
                }
                if (!((RfHid)rightOperand).getName().equals("UVM_FRONTDOOR")) continue;
                return PathType.FRONTDOOR;
            }
        }
        if (methodName.equals("predict")) {
            return PathType.FRONTDOOR;
        }
        return PathType.DEFAULT;
    }

    public static Map<ParserPath, List<DirectiveInfo>> getAllDirectives(List<ParserPath> allFilesInProject, VlogPreprocessingInfo preprocessingTable, SVTBWhitespaceParser wsParser) {
        if (preprocessingTable == null || allFilesInProject == null || wsParser == null) {
            return null;
        }
        Map<ParserPath, CodePreprocFileInfo> codePreprocFileInfos = preprocessingTable.getCodePreprocFileInfos();
        if (codePreprocFileInfos == null) {
            return null;
        }
        HashMap<ParserPath, List<DirectiveInfo>> allDirectives = new HashMap<ParserPath, List<DirectiveInfo>>();
        for (ParserPath path : allFilesInProject) {
            TreeSet<Integer> lines;
            ArrayList<DirectiveInfo> directivesInFile = new ArrayList<DirectiveInfo>();
            CodePreprocFileInfo preprocInfo = codePreprocFileInfos.get(path);
            if (preprocInfo == null || (lines = preprocInfo.getLines()) == null) continue;
            ArrayDeque<DirectiveInfo> openDirectives = new ArrayDeque<DirectiveInfo>();
            for (Integer line : lines) {
                DirectiveInfo currentDirective;
                DirectiveInfo directive;
                CodePreprocLineInfo info = preprocInfo.getInfo(line);
                if (info == null || (directive = LintUtils.getDirective(wsParser, path, info, true)) == null) continue;
                if (directive.getDirectiveType().equals(IFDEF) || directive.getDirectiveType().equals(IFNDEF)) {
                    openDirectives.push(directive);
                    continue;
                }
                if (directive.getDirectiveType().equals(ELSE)) {
                    if (openDirectives.isEmpty()) continue;
                    currentDirective = (DirectiveInfo)openDirectives.pop();
                    currentDirective.setEndOffset(directive.getStartOffset());
                    directivesInFile.add(currentDirective);
                    directive.setDirectiveArg(currentDirective.getDirectiveArg());
                    directive.setIsPositiveBranch(!currentDirective.isPositiveBranch());
                    openDirectives.push(directive);
                    continue;
                }
                if (!directive.getDirectiveType().equals(ENDIF) || openDirectives.isEmpty()) continue;
                currentDirective = (DirectiveInfo)openDirectives.pop();
                currentDirective.setEndOffset(directive.getStartOffset());
                directivesInFile.add(currentDirective);
            }
            if (directivesInFile.isEmpty()) continue;
            allDirectives.put(path, directivesInFile);
        }
        return allDirectives;
    }

    public static boolean isOffsetInsideGuard(Map<ParserPath, List<DirectiveInfo>> allDirectives, ParserPath parserPath, int offset, Set<String> pAllowedGuardNames, boolean isPositivePolarityAllowed, boolean isNegativePolarityAllowed) {
        List<DirectiveInfo> directives = allDirectives.get(parserPath);
        if (directives == null || directives.isEmpty()) {
            return false;
        }
        ArrayList<DirectiveInfo> directivesAtLine = new ArrayList<DirectiveInfo>();
        for (DirectiveInfo directive : directives) {
            if (directive.getStartOffset() > offset || directive.getEndOffset() < offset) continue;
            directivesAtLine.add(directive);
        }
        if (directivesAtLine.isEmpty()) {
            return false;
        }
        if (pAllowedGuardNames.isEmpty()) {
            if (isPositivePolarityAllowed && isNegativePolarityAllowed) {
                return true;
            }
            for (DirectiveInfo directive : directivesAtLine) {
                if ((!isNegativePolarityAllowed || !directive.isPositiveBranch()) && (!isPositivePolarityAllowed || directive.isPositiveBranch())) continue;
                return false;
            }
            return true;
        }
        for (DirectiveInfo directive : directivesAtLine) {
            if (!pAllowedGuardNames.contains(directive.getDirectiveArg()) || (!isNegativePolarityAllowed || directive.isPositiveBranch()) && (!isPositivePolarityAllowed || !directive.isPositiveBranch())) continue;
            return true;
        }
        return false;
    }

    public static DirectiveInfo getDirective(SVTBWhitespaceParser wsParser, ParserPath path, CodePreprocLineInfo info, boolean getDirectiveArg) {
        int line = info.getLine();
        for (LiteralToken token : wsParser.getTokensOnLine(path, line)) {
            if (token.getLineNumber() != line) continue;
            String directive = token.getStringToken();
            for (String directiveType : ALL_COMPILER_DIRECTIVES) {
                if (!directive.contains(directiveType)) continue;
                String directiveArg = null;
                if (getDirectiveArg && (directive.contains(IFDEF) || directive.contains(IFNDEF))) {
                    LiteralToken argToken = wsParser.getNextCodeToken(token, path);
                    directiveArg = argToken == null ? null : argToken.getStringToken();
                }
                return new DirectiveInfo(path, directiveType, directiveArg, token, info.getType() == 1, directiveType.equals(IFDEF));
            }
        }
        return null;
    }

    public static void createPrewaiverForPrecompiledCode(OVMProject ovmProject) {
        PreWaiver preWaiver2;
        for (PreWaiver preWaiver2 : ovmProject.getProjectWaivers().getPreWaivers()) {
            if (preWaiver2.getType() != WaiverType.READ_ONLY || !preWaiver2.getName().equals("Prewaiver generated for precompiled code")) continue;
            ovmProject.getProjectWaivers().getPreWaivers().remove(preWaiver2);
            break;
        }
        preWaiver2 = new PreWaiver();
        preWaiver2.setType(WaiverType.READ_ONLY);
        preWaiver2.setName("Prewaiver generated for precompiled code");
        preWaiver2.setPathRegexType("simple");
        for (ParserPath parserPath : ovmProject.getAllFilesInOrder()) {
            if (!PrecompiledDBUtils.isPrecompiledFile((IProject)ovmProject.getProject(), (ParserPath)parserPath)) continue;
            String path = DVTStringUtil.intern((String)Utils.canonicPath((String)parserPath.path));
            preWaiver2.addPath(path);
            preWaiver2.addRawPath(path);
        }
        ovmProject.getProjectWaivers().addPreWaiver(preWaiver2);
        ovmProject.getProjectWaivers().computePrewaivedPaths();
    }

    public static String getTooltipContent(String linterPragmaComment, RfProject rfProject) {
        OVMProject ovmProject = rfProject.getOvmProject();
        if (ovmProject == null) {
            return LINTER_PRAGMA_UNAVAILABLE;
        }
        StringBuilder result = new StringBuilder();
        linterPragmaComment = DVTStringUtil.replaceAll((Pattern)INLINE_PRAGMA_DESCRIPTION_PATTERN, (CharSequence)linterPragmaComment, (String)"");
        String commentRules = null;
        String severity = null;
        String upperCaseComment = linterPragmaComment.toUpperCase();
        WaiverStatus[] waiverStatusArray = WaiverStatus.getValid();
        int n = waiverStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            WaiverStatus waiverStatus = waiverStatusArray[n2];
            int index = upperCaseComment.indexOf(waiverStatus.toString());
            if (index != -1) {
                commentRules = linterPragmaComment.substring(index + waiverStatus.toString().length());
                severity = waiverStatus.toString();
                break;
            }
            ++n2;
        }
        if (commentRules == null || severity == null) {
            return "";
        }
        String[] ruleNames = DVTStringUtil.split((Pattern)DVTStringUtil.COMMA, commentRules);
        if (ruleNames == null || ruleNames.length == 0) {
            return "";
        }
        String[] stringArray = ruleNames;
        int n3 = ruleNames.length;
        n = 0;
        while (n < n3) {
            String ruleName = stringArray[n];
            OVMComplianceCheck check = ovmProject.getCheck(ruleName.trim());
            if (check != null) {
                if (!result.isEmpty()) {
                    result.append(CommentUtils.getInstance().getNewLine());
                }
                result.append(severity).append(" ").append(check.getName()).append(":").append(" ").append(check.getTitle());
            }
            ++n;
        }
        return result.toString().trim();
    }

    public static boolean isInsideXVMReportingMacro(boolean isUVM, IReparseInfo reparseInfo) {
        List<String> macros;
        List<String> list = macros = isUVM ? XVMMacros.UVM_REPORT_MACROS : XVMMacros.OVM_REPORT_MACROS;
        if (!(reparseInfo instanceof ReparseInfo)) {
            return false;
        }
        ReparseInfo.ReparseElement[] reparseElementArray = ((ReparseInfo)reparseInfo).getReparseStack();
        int n = reparseElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseInfo.ReparseElement reparseElement = reparseElementArray[n2];
            if (macros.contains("`" + reparseElement.getReparseMacroName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final class DirectiveInfo {
        private ParserPath path;
        private String directiveType;
        private String directiveArg;
        private LiteralToken directiveToken;
        private int endOffset;
        private boolean isSkipDirective;
        private boolean isPositiveBranch;

        public DirectiveInfo(ParserPath path, String directiveType, String directiveArg, LiteralToken directiveToken, boolean isSkipDirective, boolean isPositiveBranch) {
            this.path = path;
            this.directiveType = directiveType;
            this.directiveArg = directiveArg;
            this.directiveToken = directiveToken;
            this.endOffset = -1;
            this.isSkipDirective = isSkipDirective;
            this.isPositiveBranch = isPositiveBranch;
        }

        public void setDirectiveArg(String directiveArg) {
            this.directiveArg = directiveArg;
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public void setIsPositiveBranch(boolean isPositiveBranch) {
            this.isPositiveBranch = isPositiveBranch;
        }

        public ParserPath getDirectivePath() {
            return this.path;
        }

        public String getDirectiveType() {
            return this.directiveType;
        }

        public String getDirectiveArg() {
            return this.directiveArg;
        }

        public LiteralToken getDirectiveToken() {
            return this.directiveToken;
        }

        public int getStartOffset() {
            return this.directiveToken.getOffsetFile();
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public boolean isSkipDirective() {
            return this.isSkipDirective;
        }

        public boolean isPositiveBranch() {
            return this.isPositiveBranch;
        }
    }

    public static class FullTypeData {
        private DataType assocDataType;
        private IRfNamedElement assocType;

        public FullTypeData(DataType assocDataType, IRfNamedElement assocType) {
            this.assocDataType = assocDataType;
            this.assocType = assocType;
        }

        public DataType getAssocDataType() {
            return this.assocDataType;
        }

        public void setAssocDataType(DataType assocDataType) {
            this.assocDataType = assocDataType;
        }

        public IRfNamedElement getAssocType() {
            return this.assocType;
        }

        public void setAssocType(IRfNamedElement assocType) {
            this.assocType = assocType;
        }
    }

    public static enum PathType {
        BACKDOOR,
        FRONTDOOR,
        DEFAULT;

    }
}

