/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

public class LiteralToken {
    public static final int UNDEFINED = -1;
    private SVTBWhitespaceParser.ZoneType zone;
    private String stringToken;
    private int length;
    private int offsetFilePrevToken;
    private int offsetFileNextToken;
    private int offsetFile;
    private int offsetLine;
    private int lineNumber;
    private int noSpacesBefore;
    private int noSpacesAfter;
    private int noTabsBefore;
    private int noTabsAfter;
    private boolean isFirstTokenOnLine;
    private boolean isLastTokenOnLine;

    public LiteralToken(String stringToken, int offsetFile, int offsetLine, int lineNumber) {
        this.stringToken = stringToken;
        this.length = stringToken == null ? 0 : stringToken.length();
        this.offsetFile = offsetFile;
        this.offsetLine = offsetLine;
        this.lineNumber = lineNumber;
        this.offsetFilePrevToken = -1;
        this.offsetFileNextToken = -1;
        this.noSpacesAfter = -1;
        this.noSpacesBefore = -1;
        this.noTabsAfter = -1;
        this.noTabsBefore = -1;
    }

    public LiteralToken(int offset) {
        this(null, offset, -1, -1);
    }

    public SVTBWhitespaceParser.ZoneType getZone() {
        return this.zone;
    }

    public void setZone(SVTBWhitespaceParser.ZoneType zone) {
        this.zone = zone;
    }

    public String getStringToken() {
        return this.stringToken;
    }

    public void setStringToken(String stringToken) {
        this.stringToken = stringToken;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getOffsetFile() {
        return this.offsetFile;
    }

    public void setOffsetFile(int offsetFile) {
        this.offsetFile = offsetFile;
    }

    public int getOffsetLine() {
        return this.offsetLine;
    }

    public void setOffsetLine(int offsetLine) {
        this.offsetLine = offsetLine;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getNoSpacesBefore() {
        return this.noSpacesBefore;
    }

    public void setNoSpacesBefore(int noSpacesBefore) {
        this.noSpacesBefore = noSpacesBefore;
    }

    public int getNoSpacesAfter() {
        return this.noSpacesAfter;
    }

    public void setNoSpacesAfter(int noSpacesAfter) {
        this.noSpacesAfter = noSpacesAfter;
    }

    public boolean isFirstTokenOnLine() {
        return this.isFirstTokenOnLine;
    }

    public void setFirstTokenOnLine(boolean isFirstTokenOnLine) {
        this.isFirstTokenOnLine = isFirstTokenOnLine;
    }

    public boolean isLastTokenOnLine() {
        return this.isLastTokenOnLine;
    }

    public void setLastTokenOnLine(boolean isLastTokenOnLine) {
        this.isLastTokenOnLine = isLastTokenOnLine;
    }

    public boolean isOnlyTokenOnLine() {
        return this.isFirstTokenOnLine && this.isLastTokenOnLine;
    }

    public int getNoTabsBefore() {
        return this.noTabsBefore;
    }

    public void setNoTabsBefore(int noTabsBefore) {
        this.noTabsBefore = noTabsBefore;
    }

    public int getNoTabsAfter() {
        return this.noTabsAfter;
    }

    public void setNoTabsAfter(int noTabsAfter) {
        this.noTabsAfter = noTabsAfter;
    }

    public int getNextTokenOnLineOffset() {
        if (this.isLastTokenOnLine) {
            return -1;
        }
        return this.offsetFile + this.length + this.noSpacesAfter + this.noTabsAfter;
    }

    public int getOffsetFilePrevToken() {
        return this.offsetFilePrevToken;
    }

    public void setOffsetFilePrevToken(int offsetFilePrevToken) {
        this.offsetFilePrevToken = offsetFilePrevToken;
    }

    public int getOffsetFileNextToken() {
        return this.offsetFileNextToken;
    }

    public void setOffsetFileNextToken(int offsetFileNextToken) {
        this.offsetFileNextToken = offsetFileNextToken;
    }

    public boolean isComment() {
        return this.zone == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || this.zone == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT;
    }

    public String toString() {
        return this.stringToken;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LiteralToken)) {
            return false;
        }
        LiteralToken token = (LiteralToken)object;
        if (this.offsetFile != token.getOffsetFile()) {
            return false;
        }
        if (this.length != token.getLength()) {
            return false;
        }
        return this.stringToken.equals(token.getStringToken());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.offsetFile;
        result = 31 * result + this.length;
        result = 31 * result + (this.stringToken == null ? 0 : this.stringToken.hashCode());
        return result;
    }
}

