/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.dvt.utils.XMLValidatorBatchUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.utils.OVMUtilsCommon;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class OVMUtils
extends OVMUtilsCommon {
    public static File getPathToPropertyFile(IProject project, String launchTypeName, String fileName) {
        String underscore = "_";
        if (launchTypeName == null || launchTypeName.isEmpty()) {
            underscore = "";
        }
        return new File(String.valueOf(project.getLocation().toOSString()) + File.separator + ".dvt" + File.separator + launchTypeName + underscore + fileName);
    }

    public static void configError(XMLException e) {
        if (e.getCause() instanceof IOException) {
            OVMUtils.ioReadError((IOException)e.getCause(), e.getFileName());
        } else if (e.getCause() instanceof Exception) {
            XMLValidatorBatchUtils.showError((Exception)((Exception)e.getCause()), (String)e.getFileName());
        }
    }

    public static void ioWriteError(IOException e, String fileName) {
        Display.getDefault().asyncExec(() -> {
            Status status = new Status(4, "ro.amiq.vlogdt", 0, e.getMessage(), (Throwable)e);
            DVTExceptionHandler.handle((CoreException)new CoreException((IStatus)status), (Shell)Display.getDefault().getActiveShell(), (String)"Error Saving File", (String)("I/O error writing '" + fileName + "' file, please check the write permission."));
        });
    }

    public static void ioReadError(IOException e, String fileName) {
        Display.getDefault().asyncExec(() -> {
            Status status = new Status(4, "ro.amiq.vlogdt", 0, e.getMessage(), (Throwable)e);
            DVTExceptionHandler.handle((CoreException)new CoreException((IStatus)status), (Shell)Display.getDefault().getActiveShell(), (String)"Error Reading File", (String)("I/O error reading '" + fileName + "' file, please check the read permission."));
        });
    }

    protected static StringBuilder appendMessage(StringBuilder sb, StringBuilder message) {
        return sb.append(MessageFormat.format("*** {0}" + System.lineSeparator(), message.toString()));
    }

    protected static String getWarningTag() {
        return "Warning";
    }

    protected static String getErrorTag() {
        return "Error";
    }

    protected static void printErrorToConsole(IProject project, StringBuilder problemMessage) {
        DVTBuildConsoleRegistry.getConsole((IProject)project).print(problemMessage.toString());
    }

    public static RfProject getRfProject(IProject project) {
        return RfManager.getInstance().getRfProject(project);
    }

    public static URL getDefaultRulesetURL(RulesetKind rulesetKind) {
        return VlogPlugin.getDefault().getBundle().getResource("ro/amiq/vlogdt/linter/ruleset/" + rulesetKind.getXML());
    }
}

