/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.utils.OVMUtils;

public abstract class OVMUtilsCommon {
    public static final String WAIVERS_FILE = "waivers.xml";
    public static final String RULESET_FILE = "ruleset.xml";
    public static final String MANUAL_CHECKS_STATUS_FILE = "manual_checks_status.xml";
    public static final int OVM_LIBRARY_KIND = 1;
    public static final int UVM_LIBRARY_KIND = 2;

    public static boolean isOVMFile(String fileName, boolean fLintLibraryContents, Pattern fXVMFileNamePattern) {
        if (fLintLibraryContents) {
            return false;
        }
        return fXVMFileNamePattern != null && fXVMFileNamePattern.matcher(fileName).matches();
    }

    public static File getProjectPath(IProject project) {
        return new Path(project.getLocation().toOSString()).toFile();
    }

    public static void parseProblem(IProject project, Map<String, List<String>> problemFiles, String problemCause, boolean isError, boolean isRulesetError) {
        if (problemFiles.isEmpty()) {
            return;
        }
        StringBuilder problemMessage = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : problemFiles.entrySet()) {
            StringBuilder localMessage = new StringBuilder();
            if (!isError) {
                localMessage.append(String.valueOf(OVMUtils.getWarningTag()) + ": '");
            } else {
                localMessage.append(String.valueOf(OVMUtils.getErrorTag()) + ": '");
            }
            localMessage.append(entry.getKey()).append("' includes " + problemCause + ":\n");
            for (String file : entry.getValue()) {
                localMessage.append("\t'").append(file).append("'\n");
            }
            problemMessage = OVMUtils.appendMessage(problemMessage, localMessage);
        }
        problemMessage.deleteCharAt(problemMessage.length() - 1);
        SAXParseException exception = null;
        if (isError) {
            exception = isRulesetError ? new SAXParseException("RULESET CONFIG ERROR " + problemMessage.toString(), "", "", 0, 0) : new SAXParseException("VERISSIMO WAIVER CONFIG ERROR " + problemMessage.toString(), "", "", 0, 0);
            OVMUtils.printErrorToConsole(project, problemMessage);
            throw new XMLException((Throwable)exception, "");
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).print(problemMessage.toString());
    }

    public static String prependLibraryPrefixTo(int kind, String input) {
        if (kind == 2) {
            return "uvm" + input;
        }
        if (input.startsWith("_tlm_")) {
            return input.substring(1);
        }
        return "ovm" + input;
    }

    public static String prependCapitalizedLibraryPrefixTo(int kind, String input) {
        if (kind == 2) {
            return "UVM" + input;
        }
        return "OVM" + input;
    }
}

