/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.IndentParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

public class SVTBCharParser {
    private static final Pattern PRAGMA_WAIVER_PATTERN = Pattern.compile("//\\s*@DVT_LINTER_WAIVER");
    private static final Pattern PRAGMA_WAIVER_PATTERN_NO_COMMENT = Pattern.compile("@DVT_LINTER_WAIVER");

    public static Map<ParserPath, List<SVTBIssues>> getAllCharIssues(OVMProject ovmProject, Set<ParserPath> fileNames, Config parserConfig, OVMComplianceCheck check) throws IOException {
        RfProject rfProject = ovmProject.getRfProject();
        boolean doLookForLongLines = rfProject.lintIsTrackedP2LInfo(127);
        HashMap<ParserPath, List<SVTBIssues>> allCharIssues = new HashMap<ParserPath, List<SVTBIssues>>();
        Set<String> skipLinesWithPrefixes = parserConfig.getSkipLinesWithPrefix();
        Set<String> skipLinesWithPreviousLineSuffix = parserConfig.getSkipLinesWithPreviousLineSuffix();
        Set<Pattern> allowLinesWithPattern = parserConfig.getAllowLinesWithPattern();
        boolean checkSuffix = false;
        boolean checkPattern = false;
        boolean skipComments = parserConfig.isSkipingComments();
        if (skipLinesWithPreviousLineSuffix != null && !skipLinesWithPreviousLineSuffix.isEmpty()) {
            checkSuffix = true;
        }
        if (!allowLinesWithPattern.isEmpty() && doLookForLongLines) {
            checkPattern = true;
        }
        for (ParserPath fileName : fileNames) {
            if (ovmProject.getProjectWaivers().pathIsPrewaived(fileName, check)) continue;
            check.notifyCheckAlive();
            int line = 1;
            int lineStart = 0;
            boolean lineHasComment = false;
            boolean inBlockComment = false;
            boolean endBlockComment = false;
            boolean inLineComment = false;
            boolean skip = false;
            boolean skipIndent = false;
            boolean countBeginSpaces = true;
            int nofSpaces = 0;
            int commentStart = 0;
            int commentStartLine = 0;
            int i = 0;
            int c = 0;
            char c2 = '\u0000';
            char c1 = '\u0000';
            int firstLineWithCode = -1;
            int lastLineWithCode = -1;
            int lookForLongLine = 1;
            StringBuilder comment = new StringBuilder();
            StringBuilder suffixToken = new StringBuilder();
            StringBuilder commentSuffixToken = new StringBuilder();
            StringBuilder prefixToken = new StringBuilder();
            StringBuilder currentLine = new StringBuilder();
            boolean skipNextLine = false;
            boolean foundSuffix = false;
            boolean foundCommentSuffix = false;
            boolean checkPrefix = false;
            int commentLine = 1;
            ArrayList<SVTBIssues> possibleIndentIssues = new ArrayList<SVTBIssues>();
            Throwable throwable = null;
            Object var46_47 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(fileName.path));){
                c2 = (char)reader.read();
                while ((c = reader.read()) != -1) {
                    String tokenString;
                    c1 = c2;
                    c2 = (char)c;
                    if (countBeginSpaces) {
                        if (c1 == ' ') {
                            ++nofSpaces;
                        } else {
                            countBeginSpaces = false;
                            for (Integer nofWhiteSpacesTracked : parserConfig.getNofWhitespacesAsIndent()) {
                                if (skipNextLine || skipIndent || nofSpaces % nofWhiteSpacesTracked == 0 || SVTBCharParser.isSkippedComment(inBlockComment, c1, c2, skipComments) || c1 == '\n' || c1 == '\r') continue;
                                boolean hasSkipLinesWithPrefix = skipLinesWithPrefixes != null && !skipLinesWithPrefixes.isEmpty();
                                SVTBCharParser.addNofSpacesIssue(rfProject, allCharIssues, possibleIndentIssues, fileName, line, i, nofWhiteSpacesTracked, nofSpaces, !hasSkipLinesWithPrefix);
                                if (!hasSkipLinesWithPrefix) continue;
                                checkPrefix = true;
                            }
                            nofSpaces = 0;
                            skipNextLine = false;
                        }
                    }
                    if (checkPattern && c1 != '\n') {
                        currentLine.append(c1);
                    }
                    if (!(!checkSuffix || Character.isWhitespace(c1) || inBlockComment || c1 == '*' && c2 == '/' || endBlockComment && c1 == '/' || inLineComment || c1 == '/' && c2 == '/' || c1 == '/' && c2 == '*')) {
                        suffixToken.append(c1);
                        foundSuffix = false;
                        foundCommentSuffix = false;
                    }
                    if (checkSuffix && !Character.isWhitespace(c1) && (inBlockComment || c1 == '*' && c2 == '/' || endBlockComment && c1 == '/' || inLineComment || c1 == '/' && c2 == '/' || c1 == '/' && c2 == '*')) {
                        commentSuffixToken.append(c1);
                        foundCommentSuffix = false;
                    }
                    if (checkSuffix && Character.isWhitespace(c1) && !inBlockComment && !inLineComment && suffixToken.length() > 0) {
                        tokenString = suffixToken.toString();
                        suffixToken = new StringBuilder();
                        if (skipLinesWithPreviousLineSuffix != null && !skipLinesWithPreviousLineSuffix.isEmpty()) {
                            if (skipLinesWithPreviousLineSuffix.contains(tokenString)) {
                                foundSuffix = true;
                            }
                            for (String skipSuffix : skipLinesWithPreviousLineSuffix) {
                                if (!tokenString.endsWith(skipSuffix)) continue;
                                foundSuffix = true;
                            }
                        }
                    }
                    if (checkSuffix && Character.isWhitespace(c1) && commentSuffixToken.length() > 0) {
                        tokenString = commentSuffixToken.toString();
                        commentSuffixToken = new StringBuilder();
                        if (skipLinesWithPreviousLineSuffix != null && !skipLinesWithPreviousLineSuffix.isEmpty()) {
                            if (skipLinesWithPreviousLineSuffix.contains(tokenString)) {
                                foundCommentSuffix = true;
                            } else {
                                for (String skipSuffix : skipLinesWithPreviousLineSuffix) {
                                    if (!tokenString.endsWith(skipSuffix)) continue;
                                    foundCommentSuffix = true;
                                }
                            }
                        }
                    }
                    if (endBlockComment && c1 == '/') {
                        endBlockComment = false;
                    }
                    if (checkPrefix && !Character.isWhitespace(c1) && !inBlockComment && !inLineComment) {
                        prefixToken.append(c1);
                    }
                    if (checkPrefix && Character.isWhitespace(c1) && !inBlockComment && !inLineComment && prefixToken.length() > 0) {
                        tokenString = prefixToken.toString();
                        prefixToken = new StringBuilder();
                        boolean foundPrefix = false;
                        if (skipLinesWithPrefixes != null) {
                            if (skipLinesWithPrefixes.contains(tokenString)) {
                                foundPrefix = true;
                            }
                            for (String skipPrefix : skipLinesWithPrefixes) {
                                if (!tokenString.startsWith(skipPrefix)) continue;
                                foundPrefix = true;
                            }
                        }
                        if (!foundPrefix) {
                            for (SVTBIssues indentIssue : possibleIndentIssues) {
                                if (indentIssue.getLine() != line) continue;
                                List<SVTBIssues> issues = allCharIssues.get(fileName);
                                if (issues == null) {
                                    issues = new ArrayList<SVTBIssues>();
                                    allCharIssues.put(fileName, issues);
                                }
                                issues.add(indentIssue);
                            }
                        }
                        checkPrefix = false;
                    }
                    if (Character.isWhitespace(c1) && c1 != '\n' && c1 != '\r' && (c2 == '\n' || c2 == '\r')) {
                        SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 134);
                    }
                    if (skip) {
                        skip = false;
                        if (c1 == '\n') {
                            countBeginSpaces = true;
                        }
                    } else if (!(c1 != '\t' || parserConfig.isSkipTabsInComments() && (inLineComment || inBlockComment))) {
                        SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 25);
                    } else if (c1 == '\n') {
                        if ((inBlockComment || lineHasComment && commentStartLine < line) && i - lineStart > parserConfig.getMaxNofCharsPerMultiLineComment()) {
                            SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 26);
                        }
                        if (doLookForLongLines && lookForLongLine == line && i - lineStart > parserConfig.getMaxNofCharsPerLine()) {
                            boolean patternFound = false;
                            if (checkPattern) {
                                for (Pattern pattern : allowLinesWithPattern) {
                                    if (pattern == null || !pattern.matcher(currentLine.toString().trim()).matches()) continue;
                                    patternFound = true;
                                    break;
                                }
                            }
                            currentLine = new StringBuilder();
                            if (!patternFound) {
                                if (parserConfig.isAllowingLongComments()) {
                                    if (inLineComment || lineHasComment) {
                                        if (commentStart - lineStart > parserConfig.getMaxNofCharsPerLine()) {
                                            SVTBCharParser.addNofCharsPerLineIssue(rfProject, allCharIssues, fileName, line, commentStart, commentStart - lineStart);
                                            ++lookForLongLine;
                                        }
                                    } else if (!inBlockComment) {
                                        SVTBCharParser.addNofCharsPerLineIssue(rfProject, allCharIssues, fileName, line, i, i - lineStart);
                                        ++lookForLongLine;
                                    }
                                } else if (SVTBCharParser.isPragmaWaiver(comment.toString()) && parserConfig.isAllowingPragmaWaivers()) {
                                    if (commentStart - lineStart > parserConfig.getMaxNofCharsPerLine()) {
                                        SVTBCharParser.addNofCharsPerLineIssue(rfProject, allCharIssues, fileName, line, commentStart, commentStart - lineStart);
                                        ++lookForLongLine;
                                    }
                                } else {
                                    SVTBCharParser.addNofCharsPerLineIssue(rfProject, allCharIssues, fileName, line, i, i - lineStart);
                                    ++lookForLongLine;
                                }
                            }
                        }
                        if (lookForLongLine == line) {
                            ++lookForLongLine;
                        }
                        ++line;
                        currentLine = new StringBuilder();
                        if (foundSuffix || foundCommentSuffix) {
                            skipNextLine = true;
                        }
                        checkPrefix = false;
                        lineStart = i + 1;
                        inLineComment = false;
                        commentStart = 0;
                        lineHasComment = inBlockComment;
                        if (!lineHasComment && comment.length() != 0) {
                            SVTBCharParser.addCommentIssue(rfProject, allCharIssues, fileName, line - 1, i, comment.toString());
                            comment = new StringBuilder();
                        }
                        commentStartLine = inBlockComment ? commentStartLine : line;
                        countBeginSpaces = true;
                    } else if (c1 == '\r') {
                        if ((inBlockComment || lineHasComment && commentStartLine < line) && i - lineStart > parserConfig.getMaxNofCharsPerMultiLineComment()) {
                            SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 26);
                        }
                        if (c2 == '\n') {
                            SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 27);
                            skip = true;
                            lineStart = i + 2;
                        } else {
                            lineStart = i + 1;
                        }
                        ++line;
                        if (foundSuffix || foundCommentSuffix) {
                            skipNextLine = true;
                        }
                        checkPrefix = false;
                        inLineComment = false;
                        lineHasComment = inBlockComment;
                        if (!lineHasComment && comment.length() != 0) {
                            SVTBCharParser.addCommentIssue(rfProject, allCharIssues, fileName, line, i, comment.toString());
                            comment = new StringBuilder();
                        }
                        commentStartLine = inBlockComment ? commentStartLine : line;
                        countBeginSpaces = true;
                    } else if (c1 == '/' && c2 == '/' && !inBlockComment && !inLineComment) {
                        comment.append(c1);
                        inLineComment = true;
                        commentStart = i;
                        skip = true;
                    } else if (c1 == '/' && c2 == '*' && !inLineComment && !inBlockComment) {
                        comment.append(c1);
                        commentStart = i;
                        commentLine = line;
                        lineHasComment = true;
                        inBlockComment = true;
                        skip = true;
                    } else if (c1 == '*' && c2 == '/' && !inLineComment && inBlockComment) {
                        comment.append(c2);
                        SVTBCharParser.addCommentIssue(rfProject, allCharIssues, fileName, commentLine, i, comment.toString());
                        comment = new StringBuilder();
                        lineHasComment = true;
                        inBlockComment = false;
                        skip = true;
                        endBlockComment = true;
                        if (i + 2 - lineStart > parserConfig.getMaxNofCharsPerMultiLineComment()) {
                            SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 26);
                        }
                    } else if (!(Character.isWhitespace(c) || inLineComment || inBlockComment || countBeginSpaces)) {
                        if (firstLineWithCode == -1) {
                            firstLineWithCode = line;
                        }
                        lastLineWithCode = line;
                    }
                    if (inBlockComment || inLineComment) {
                        comment.append(c2);
                    }
                    ++i;
                }
                if (doLookForLongLines && lookForLongLine == line && i - lineStart > parserConfig.getMaxNofCharsPerLine()) {
                    SVTBCharParser.checkLastLine(parserConfig, rfProject, allCharIssues, allowLinesWithPattern, checkPattern, fileName, line, lineStart, lineHasComment, inBlockComment, inLineComment, commentStart, i, comment, currentLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (comment.length() != 0) {
                SVTBCharParser.addCommentIssue(rfProject, allCharIssues, fileName, line, i, comment.toString());
                comment = new StringBuilder();
            }
            if (checkPrefix && !Character.isWhitespace(c1) && !inBlockComment && !inLineComment) {
                prefixToken.append(c1);
            }
            if (checkPrefix && !inBlockComment && !inLineComment && prefixToken.length() > 0) {
                String tokenString = prefixToken.toString();
                prefixToken = new StringBuilder();
                boolean foundPrefix = false;
                if (skipLinesWithPrefixes != null) {
                    if (skipLinesWithPrefixes.contains(tokenString)) {
                        foundPrefix = true;
                    }
                    for (String skipPrefix : skipLinesWithPrefixes) {
                        if (!tokenString.startsWith(skipPrefix)) continue;
                        foundPrefix = true;
                    }
                }
                if (!foundPrefix) {
                    for (SVTBIssues indentIssue : possibleIndentIssues) {
                        if (indentIssue.getLine() != line) continue;
                        List<SVTBIssues> issues = allCharIssues.get(fileName);
                        if (issues == null) {
                            issues = new ArrayList<SVTBIssues>();
                            allCharIssues.put(fileName, issues);
                        }
                        issues.add(indentIssue);
                    }
                }
            }
            if (line > parserConfig.getMaxNofLinesPerFile()) {
                SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 501);
            }
            if ((inBlockComment || lineHasComment && commentStartLine < line) && i - lineStart > parserConfig.getMaxNofCharsPerMultiLineComment()) {
                SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 26);
            }
            if (!(c2 != '\t' || parserConfig.isSkipTabsInComments() && (inLineComment || inBlockComment))) {
                SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 25);
            }
            if (Character.isWhitespace(c2) && c2 != '\r' && c2 != '\n') {
                SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, line, i, 134);
            }
            SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, firstLineWithCode, i, 120);
            SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, lastLineWithCode, i, 121);
            LinkedList<Integer> problemLines = IndentParser.getBadIndentationLines(fileName.path);
            for (Integer problemLine : problemLines) {
                SVTBCharParser.addIssue(rfProject, allCharIssues, fileName, problemLine, i, 48);
            }
        }
        return allCharIssues;
    }

    private static void checkLastLine(Config parserConfig, RfProject rfProject, HashMap<ParserPath, List<SVTBIssues>> allCharIssues, Set<Pattern> allowLinesWithPattern, boolean checkPattern, ParserPath fileName, int line, int lineStart, boolean lineHasComment, boolean inBlockComment, boolean inLineComment, int commentStart, int i, StringBuilder comment, StringBuilder currentLine) {
        boolean patternFound = false;
        if (checkPattern) {
            for (Pattern pattern : allowLinesWithPattern) {
                if (pattern == null || !pattern.matcher(currentLine.toString().trim()).matches()) continue;
                patternFound = true;
                break;
            }
        }
        if (patternFound) {
            return;
        }
        if (parserConfig.isAllowingLongComments()) {
            if (inLineComment || lineHasComment) {
                if (commentStart - lineStart > parserConfig.getMaxNofCharsPerLine()) {
                    SVTBCharParser.addNofCharsPerLineIssue(rfProject, allCharIssues, fileName, line, commentStart, commentStart - lineStart);
                }
            } else if (!inBlockComment) {
                SVTBCharParser.addNofCharsPerLineIssue(rfProject, allCharIssues, fileName, line, i, i - lineStart);
            }
        } else if (SVTBCharParser.isPragmaWaiver(comment.toString()) && parserConfig.isAllowingPragmaWaivers()) {
            if (commentStart - lineStart > parserConfig.getMaxNofCharsPerLine()) {
                SVTBCharParser.addNofCharsPerLineIssue(rfProject, allCharIssues, fileName, line, commentStart, commentStart - lineStart);
            }
        } else {
            SVTBCharParser.addNofCharsPerLineIssue(rfProject, allCharIssues, fileName, line, i, i - lineStart);
        }
    }

    public static boolean isPragmaWaiver(String comment) {
        return PRAGMA_WAIVER_PATTERN.matcher(comment).find() || PRAGMA_WAIVER_PATTERN_NO_COMMENT.matcher(comment).find();
    }

    public static String getPragmaWaiverFromText(String text, int offsetOnLine) {
        int index = -1;
        try {
            Matcher m = PRAGMA_WAIVER_PATTERN_NO_COMMENT.matcher(text);
            String result = "";
            while (m.find()) {
                index = m.start();
                if (index > offsetOnLine) break;
                int indexEndComment = text.indexOf("*/", index);
                if (indexEndComment == -1) {
                    indexEndComment = text.length();
                }
                result = text.substring(index, indexEndComment);
            }
            return result;
        }
        catch (IllegalStateException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    private static boolean isSkippedComment(boolean inBlockComment, char c1, char c2, boolean skipComments) {
        if (inBlockComment || c1 == '/' && (c2 == '/' || c2 == '*')) {
            return skipComments;
        }
        return false;
    }

    private static void addIssue(RfProject rfProject, HashMap<ParserPath, List<SVTBIssues>> allCharIssues, ParserPath fileName, int line, int offset, int kind) {
        if (!rfProject.lintIsTrackedP2LInfo(kind)) {
            return;
        }
        List<SVTBIssues> issuesInFile = allCharIssues.get(fileName);
        if (issuesInFile == null) {
            issuesInFile = new ArrayList<SVTBIssues>();
            allCharIssues.put(fileName, issuesInFile);
        }
        issuesInFile.add(new SVTBIssues(kind, line, offset, 0, 0, null, null, null, null, null));
    }

    private static void addCommentIssue(RfProject rfProject, HashMap<ParserPath, List<SVTBIssues>> allCharIssues, ParserPath fileName, int line, int offset, String commentString) {
        if (!rfProject.lintIsTrackedP2LInfo(136)) {
            return;
        }
        List<SVTBIssues> issuesInFile = allCharIssues.get(fileName);
        if (issuesInFile == null) {
            issuesInFile = new ArrayList<SVTBIssues>();
            allCharIssues.put(fileName, issuesInFile);
        }
        issuesInFile.add(new SVTBIssues(136, line, offset, 0, 0, commentString, null, null, null, null));
    }

    private static void addNofCharsPerLineIssue(RfProject rfProject, HashMap<ParserPath, List<SVTBIssues>> allCharIssues, ParserPath fileName, int line, int offset, int nofCharsPerLine) {
        if (!rfProject.lintIsTrackedP2LInfo(127)) {
            return;
        }
        List<SVTBIssues> issuesInFile = allCharIssues.get(fileName);
        if (issuesInFile == null) {
            issuesInFile = new ArrayList<SVTBIssues>();
            allCharIssues.put(fileName, issuesInFile);
        }
        issuesInFile.add(new SVTBIssues(127, line, offset, 0, 0, Integer.toString(nofCharsPerLine), null, null, null, null));
    }

    private static void addNofSpacesIssue(RfProject rfProject, HashMap<ParserPath, List<SVTBIssues>> allCharIssues, List<SVTBIssues> possibleIndentIssues, ParserPath fileName, int line, int offset, int nofWhiteSpacesTracked, int nofSpacesOnLine, boolean addToCharIssues) {
        if (!rfProject.lintIsTrackedP2LInfo(43)) {
            return;
        }
        SVTBIssues svtbIssue = new SVTBIssues(43, line, offset, 0, 0, Integer.toString(nofWhiteSpacesTracked), Integer.toString(nofSpacesOnLine), null, null, null);
        List<SVTBIssues> issuesInFile = allCharIssues.get(fileName);
        if (issuesInFile == null) {
            issuesInFile = new ArrayList<SVTBIssues>();
            allCharIssues.put(fileName, issuesInFile);
        }
        if (addToCharIssues) {
            issuesInFile.add(svtbIssue);
        } else {
            possibleIndentIssues.add(svtbIssue);
        }
    }

    public static class Config {
        public static final Config DEFAULT = new Config();
        private int maxNofCharsPerLine = 120;
        private boolean allowLongComments = true;
        private boolean allowPragmaWaivers = true;
        private boolean skipComments;
        private int maxNofCharsPerMultiLineComment = 80;
        private int maxNofLinesPerFile = 400;
        private boolean skipTabsInComments = false;
        private Set<Integer> nofWhitespacesAsIndent = new HashSet<Integer>();
        private Set<String> skipLinesWithPrefix = new HashSet<String>();
        private Set<String> skipLinesWithPreviousLineSuffix = new HashSet<String>();
        private Set<Pattern> allowLinesWithPattern = new HashSet<Pattern>();

        private Config() {
        }

        public Config(boolean skipTabsInComments) {
            this.skipTabsInComments = skipTabsInComments;
        }

        public Config(int maxNofCharsPerLine, boolean allowLongComments, boolean allowPragmaWaivers, HashSet<Pattern> allowLinesWithPattern) {
            this.maxNofCharsPerLine = maxNofCharsPerLine;
            this.allowLongComments = allowLongComments;
            this.allowPragmaWaivers = allowPragmaWaivers;
            this.allowLinesWithPattern = allowLinesWithPattern;
        }

        public Config(int maxNofCharsPerMultiLineComment) {
            this.maxNofCharsPerMultiLineComment = maxNofCharsPerMultiLineComment;
        }

        public Config(boolean padding, int maxNofLinesPerFile) {
            this.maxNofLinesPerFile = maxNofLinesPerFile;
        }

        public Config(Set<Integer> nofWhitespaces, Set<String> skipLinesWithPrefix, Set<String> skipLinesWithPreviousLineSuffix, boolean skipComments) {
            this.nofWhitespacesAsIndent = nofWhitespaces;
            this.skipLinesWithPrefix = skipLinesWithPrefix;
            this.skipLinesWithPreviousLineSuffix = skipLinesWithPreviousLineSuffix;
            this.skipComments = skipComments;
        }

        public int getMaxNofCharsPerLine() {
            return this.maxNofCharsPerLine;
        }

        public boolean isAllowingPragmaWaivers() {
            return this.allowPragmaWaivers;
        }

        public boolean isAllowingLongComments() {
            return this.allowLongComments;
        }

        public boolean isSkipingComments() {
            return this.skipComments;
        }

        public int getMaxNofCharsPerMultiLineComment() {
            return this.maxNofCharsPerMultiLineComment;
        }

        public int getMaxNofLinesPerFile() {
            return this.maxNofLinesPerFile;
        }

        public boolean isSkipTabsInComments() {
            return this.skipTabsInComments;
        }

        public Set<Integer> getNofWhitespacesAsIndent() {
            return this.nofWhitespacesAsIndent;
        }

        public Set<String> getSkipLinesWithPrefix() {
            return this.skipLinesWithPrefix;
        }

        public Set<String> getSkipLinesWithPreviousLineSuffix() {
            return this.skipLinesWithPreviousLineSuffix;
        }

        public Set<Pattern> getAllowLinesWithPattern() {
            return this.allowLinesWithPattern;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.allowLongComments ? 1231 : 1237);
            result = 31 * result + this.maxNofCharsPerLine;
            result = 31 * result + this.maxNofCharsPerMultiLineComment;
            result = 31 * result + this.maxNofLinesPerFile;
            result = 31 * result + (this.nofWhitespacesAsIndent == null ? 0 : this.nofWhitespacesAsIndent.hashCode());
            result = 31 * result + (this.skipLinesWithPrefix == null ? 0 : this.skipLinesWithPrefix.hashCode());
            result = 31 * result + (this.skipLinesWithPreviousLineSuffix == null ? 0 : this.skipLinesWithPreviousLineSuffix.hashCode());
            result = 31 * result + (this.skipTabsInComments ? 1231 : 1237);
            result = 31 * result + (this.allowLinesWithPattern.isEmpty() ? 0 : this.allowLinesWithPattern.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Config other = (Config)obj;
            if (this.allowLongComments != other.allowLongComments) {
                return false;
            }
            if (this.maxNofCharsPerLine != other.maxNofCharsPerLine) {
                return false;
            }
            if (this.maxNofCharsPerMultiLineComment != other.maxNofCharsPerMultiLineComment) {
                return false;
            }
            if (this.maxNofLinesPerFile != other.maxNofLinesPerFile) {
                return false;
            }
            if (this.nofWhitespacesAsIndent == null ? other.nofWhitespacesAsIndent != null : !this.nofWhitespacesAsIndent.equals(other.nofWhitespacesAsIndent)) {
                return false;
            }
            if (this.skipLinesWithPrefix == null ? other.skipLinesWithPrefix != null : !this.skipLinesWithPrefix.equals(other.skipLinesWithPrefix)) {
                return false;
            }
            if (this.skipLinesWithPreviousLineSuffix == null ? other.skipLinesWithPreviousLineSuffix != null : !this.skipLinesWithPreviousLineSuffix.equals(other.skipLinesWithPreviousLineSuffix)) {
                return false;
            }
            if (this.skipTabsInComments != other.skipTabsInComments) {
                return false;
            }
            if (this.allowPragmaWaivers != other.allowPragmaWaivers) {
                return false;
            }
            return this.skipComments == other.skipComments;
        }
    }
}

