/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.IOVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;

public class SVTBWhitespaceParser {
    public static final String DVT_DEBUG_DATA_WHITESPACE_PARSER = "DVT_DEBUG_DATA_WHITESPACE_PARSER";
    public static final String SINGLELINE_COMMENT = "//";
    private static final String FORMMATER_OFF = "@formatter:off";
    private static final String FORMMATER_ON = "@formatter:on";
    private static final String FORMMATER_SKIP = "@formatter:skip";
    private static final char BACKSLASH_CHAR = '\\';
    private static final char QUOTE_CHAR = '\"';
    private static final char NEWLINE_CHAR = '\n';
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final char SPACE_CHAR = ' ';
    private static final char TAB_CHAR = '\t';
    private static final char STAR_CHAR = '*';
    private static final char SLASH_CHAR = '/';
    private HashMap<ParserPath, Map<Integer, LiteralToken>> fAllTokensInFiles;
    private HashMap<ParserPath, Map<Integer, LiteralToken>> fAllTokensInFilesByEnding;
    private HashMap<ParserPath, Map<Integer, List<LiteralToken>>> fAllTokensOnLine;
    private HashMap<ParserPath, Set<DVTPair<Integer, Integer>>> fAllFormattingPragmasInFiles;
    private HashMap<ParserPath, List<LiteralToken>> fTokensInFilesCache;
    private HashSet<ParserPath> fAllImportedFiles;
    private LiteralToken fPrevToken;
    private Map<ParserPath, LiteralToken> fFirstCodeTokenInFiles;
    private Map<ParserPath, LiteralToken> fLastCodeTokenInFiles;
    private boolean fFoundFirstCodeToken;
    private LiteralToken fLastCodeToken;
    private boolean fEndingsGenerated;
    private boolean fTokensGenerated;
    private Set<ParserPath> fFilesWithGeneratedTokens = new HashSet<ParserPath>();
    private Set<ParserPath> fFilesWithEndingsGenerated = new HashSet<ParserPath>();
    private Set<String> fChecksWithGeneratedTokens = new HashSet<String>();

    private void generateOffsetsEndings(OVMProject ovmProject, IWhitespaceParserCheck check) {
        if (this.fAllTokensInFilesByEnding == null) {
            this.fAllTokensInFilesByEnding = new HashMap();
        }
        this.fAllImportedFiles = ovmProject.getAllImportedFiles();
        for (ParserPath fileName : this.fAllImportedFiles) {
            if (check instanceof OVMComplianceCheck && ovmProject.getProjectWaivers().pathIsPrewaived(fileName, (OVMComplianceCheck)((Object)check)) || this.fFilesWithEndingsGenerated.contains(fileName)) continue;
            this.fFilesWithEndingsGenerated.add(fileName);
            Map<Integer, LiteralToken> literalTokensInFile = this.fAllTokensInFiles.get(fileName);
            HashMap<Integer, LiteralToken> literalTokensInFileByEnding = new HashMap<Integer, LiteralToken>();
            for (Map.Entry<Integer, LiteralToken> entry : literalTokensInFile.entrySet()) {
                literalTokensInFileByEnding.put(entry.getKey() + entry.getValue().getLength(), entry.getValue());
            }
            this.fAllTokensInFilesByEnding.put(fileName, literalTokensInFileByEnding);
        }
    }

    private void generateAllTokensInFiles(OVMProject ovmProject, IOVMComplianceCheck check) throws IOException {
        if (this.fAllTokensInFiles == null) {
            this.fAllTokensInFiles = new HashMap();
        }
        if (this.fAllTokensOnLine == null) {
            this.fAllTokensOnLine = new HashMap();
        }
        if (this.fFirstCodeTokenInFiles == null) {
            this.fFirstCodeTokenInFiles = new HashMap<ParserPath, LiteralToken>();
        }
        if (this.fLastCodeTokenInFiles == null) {
            this.fLastCodeTokenInFiles = new HashMap<ParserPath, LiteralToken>();
        }
        this.fAllImportedFiles = ovmProject.getAllImportedFiles();
        if (this.fTokensInFilesCache == null) {
            this.fTokensInFilesCache = new HashMap();
        }
        if (this.fAllFormattingPragmasInFiles == null) {
            this.fAllFormattingPragmasInFiles = new HashMap();
        }
        for (ParserPath fileName : this.fAllImportedFiles) {
            LinkedHashMap<Integer, List<LiteralToken>> tokensOnLine;
            LinkedHashMap<Integer, LiteralToken> tokens;
            block119: {
                if (check instanceof OVMComplianceCheck && ovmProject.getProjectWaivers().pathIsPrewaived(fileName, (OVMComplianceCheck)check) || this.fFilesWithGeneratedTokens.contains(fileName)) continue;
                this.fFilesWithGeneratedTokens.add(fileName);
                if (fileName.path.startsWith("__vlog__") && fileName.path.endsWith(".libfile")) continue;
                check.notifyCheckAlive();
                tokens = new LinkedHashMap<Integer, LiteralToken>();
                tokensOnLine = new LinkedHashMap<Integer, List<LiteralToken>>();
                ZoneType zoneType = ZoneType.CODE;
                StringBuilder tokenBuffer = new StringBuilder();
                int bufferChar = 0;
                int offsetFile = 0;
                int offsetLine = 0;
                int lineNumber = 1;
                int noSpaces = 0;
                int noTabs = 0;
                char prev = '\u0000';
                boolean hasAddLiteral = false;
                boolean firstTokenOnLineFlag = true;
                this.fPrevToken = null;
                this.fFoundFirstCodeToken = false;
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(fileName.path));
                        while ((bufferChar = reader.read()) != -1) {
                            char current = (char)bufferChar;
                            if (zoneType == ZoneType.CODE) {
                                if (current == '/' && prev == '/') {
                                    if (tokenBuffer.length() != 0 && !tokenBuffer.toString().equals(Character.toString(prev))) {
                                        tokenBuffer.setLength(tokenBuffer.length() - 1);
                                        this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile - 1, offsetLine - 1, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                        this.fPrevToken.setNoSpacesAfter(noSpaces);
                                        this.fPrevToken.setNoTabsAfter(noTabs);
                                        this.fPrevToken.setOffsetFileNextToken(offsetFile - 1);
                                        tokenBuffer.append(prev);
                                    }
                                    tokenBuffer.append(current);
                                    this.addTokenIfExists(tokens, tokensOnLine, ZoneType.SINGLE_COMMENT, tokenBuffer, offsetFile + 1, offsetLine + 1, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    noSpaces = 0;
                                    noTabs = 0;
                                    firstTokenOnLineFlag = false;
                                    zoneType = ZoneType.SINGLE_COMMENT;
                                } else if (current == '*' && prev == '/') {
                                    if (tokenBuffer.length() != 0 && !tokenBuffer.toString().equals(Character.toString(prev))) {
                                        tokenBuffer.setLength(tokenBuffer.length() - 1);
                                        this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile - 1, offsetLine - 1, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                        this.fPrevToken.setNoSpacesAfter(noSpaces);
                                        this.fPrevToken.setNoTabsAfter(noTabs);
                                        this.fPrevToken.setOffsetFileNextToken(offsetFile - 1);
                                        tokenBuffer.append(prev);
                                    }
                                    tokenBuffer.append(current);
                                    this.addTokenIfExists(tokens, tokensOnLine, ZoneType.MULTILINE_COMMENT, tokenBuffer, offsetFile + 1, offsetLine + 1, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    noSpaces = 0;
                                    noTabs = 0;
                                    firstTokenOnLineFlag = false;
                                    zoneType = ZoneType.MULTILINE_COMMENT;
                                } else if (current == '\\') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    if (tokenBuffer.length() == 0 && this.fPrevToken != null) {
                                        if (!firstTokenOnLineFlag) {
                                            this.fPrevToken.setNoSpacesAfter(noSpaces);
                                            this.fPrevToken.setNoTabsAfter(noTabs);
                                        }
                                        this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                    }
                                    tokenBuffer.append(current);
                                    zoneType = ZoneType.ESCAPE_IDENTIFIER;
                                } else if (current == '\"') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    if (tokenBuffer.length() == 0 && this.fPrevToken != null) {
                                        if (!firstTokenOnLineFlag) {
                                            this.fPrevToken.setNoSpacesAfter(noSpaces);
                                            this.fPrevToken.setNoTabsAfter(noTabs);
                                        }
                                        this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                    }
                                    tokenBuffer.append(current);
                                    zoneType = ZoneType.STRING;
                                } else if (current == '\t') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    ++noTabs;
                                } else if (current == ' ') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    ++noSpaces;
                                } else if (current != '\r') {
                                    if (current == '\n') {
                                        hasAddLiteral = prev == '\r' ? this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile - 1, offsetLine - 1, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName) : this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName);
                                        if (this.fPrevToken != null) {
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                            if (!hasAddLiteral && this.fPrevToken.getLineNumber() == lineNumber) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                                this.fPrevToken.setLastTokenOnLine(true);
                                            }
                                        }
                                        firstTokenOnLineFlag = true;
                                        noSpaces = 0;
                                        noTabs = 0;
                                        offsetLine = -1;
                                        ++lineNumber;
                                    } else {
                                        if (tokenBuffer.length() == 0 && this.fPrevToken != null) {
                                            if (!firstTokenOnLineFlag) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                            }
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                        }
                                        tokenBuffer.append(current);
                                    }
                                }
                            } else if (zoneType == ZoneType.SINGLE_COMMENT) {
                                if (current == '\t') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    ++noTabs;
                                } else if (current == ' ') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    ++noSpaces;
                                } else if (current != '\r') {
                                    if (current == '\n') {
                                        hasAddLiteral = prev == '\r' ? this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile - 1, offsetLine - 1, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName) : this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName);
                                        if (this.fPrevToken != null && !hasAddLiteral && this.fPrevToken.getLineNumber() == lineNumber) {
                                            this.fPrevToken.setNoSpacesAfter(noSpaces);
                                            this.fPrevToken.setNoTabsAfter(noTabs);
                                            this.fPrevToken.setLastTokenOnLine(true);
                                        }
                                        zoneType = ZoneType.CODE;
                                        firstTokenOnLineFlag = true;
                                        noSpaces = 0;
                                        noTabs = 0;
                                        offsetLine = -1;
                                        ++lineNumber;
                                    } else {
                                        if (tokenBuffer.length() == 0 && this.fPrevToken != null) {
                                            if (!firstTokenOnLineFlag) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                            }
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                        }
                                        tokenBuffer.append(current);
                                    }
                                }
                            } else if (zoneType == ZoneType.MULTILINE_COMMENT) {
                                if (current == '/' && prev == '*' && offsetFile - 1 > this.fPrevToken.getOffsetFile() + 1) {
                                    tokenBuffer.append(current);
                                    if (tokenBuffer.length() > 2) {
                                        tokenBuffer.delete(tokenBuffer.length() - 2, tokenBuffer.length());
                                        hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile - 1, offsetLine - 1, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                        if (hasAddLiteral) {
                                            noSpaces = 0;
                                            noTabs = 0;
                                            firstTokenOnLineFlag = false;
                                            this.fPrevToken.setNoSpacesAfter(noSpaces);
                                            this.fPrevToken.setNoTabsAfter(noTabs);
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile - 1);
                                        }
                                    }
                                    this.addTokenIfExists(tokens, tokensOnLine, ZoneType.MULTILINE_COMMENT, new StringBuilder("*/"), offsetFile + 1, offsetLine + 1, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    tokenBuffer.setLength(0);
                                    noSpaces = 0;
                                    noTabs = 0;
                                    firstTokenOnLineFlag = false;
                                    zoneType = ZoneType.CODE;
                                } else if (current == '\t') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    ++noTabs;
                                } else if (current == ' ') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    ++noSpaces;
                                } else if (current != '\r') {
                                    if (current == '\n') {
                                        hasAddLiteral = prev == '\r' ? this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile - 1, offsetLine - 1, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName) : this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName);
                                        if (this.fPrevToken != null) {
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                            if (!hasAddLiteral && this.fPrevToken.getLineNumber() == lineNumber) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                                this.fPrevToken.setLastTokenOnLine(true);
                                            }
                                        }
                                        firstTokenOnLineFlag = true;
                                        noSpaces = 0;
                                        noTabs = 0;
                                        offsetLine = -1;
                                        ++lineNumber;
                                    } else {
                                        if (tokenBuffer.length() == 0 && this.fPrevToken != null) {
                                            if (!firstTokenOnLineFlag) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                            }
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                        }
                                        tokenBuffer.append(current);
                                    }
                                }
                            } else if (zoneType == ZoneType.ESCAPE_IDENTIFIER) {
                                if (current == '\t') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    zoneType = ZoneType.CODE;
                                    ++noTabs;
                                } else if (current == ' ') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    zoneType = ZoneType.CODE;
                                    ++noSpaces;
                                } else if (current != '\r') {
                                    if (current == '\n') {
                                        if (tokenBuffer.length() == 1) {
                                            zoneType = ZoneType.CODE;
                                        }
                                        hasAddLiteral = prev == '\r' ? this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile - 1, offsetLine - 1, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName) : this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName);
                                        if (this.fPrevToken != null) {
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                            if (!hasAddLiteral && this.fPrevToken.getLineNumber() == lineNumber) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                                this.fPrevToken.setLastTokenOnLine(true);
                                            }
                                        }
                                        zoneType = ZoneType.CODE;
                                        firstTokenOnLineFlag = true;
                                        noSpaces = 0;
                                        noTabs = 0;
                                        offsetLine = -1;
                                        ++lineNumber;
                                    } else {
                                        if (tokenBuffer.length() == 0 && this.fPrevToken != null) {
                                            if (!firstTokenOnLineFlag) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                            }
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                        }
                                        tokenBuffer.append(current);
                                    }
                                }
                            } else if (zoneType == ZoneType.STRING) {
                                if (current == '\"' && !this.isSequenceEscaping(tokenBuffer)) {
                                    tokenBuffer.append(current);
                                    if (tokenBuffer.length() == 1) {
                                        if (!firstTokenOnLineFlag) {
                                            this.fPrevToken.setNoSpacesAfter(noSpaces);
                                            this.fPrevToken.setNoTabsAfter(noTabs);
                                        }
                                        this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                    }
                                    if (hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile + 1, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName)) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    zoneType = ZoneType.CODE;
                                } else if (current == '\t') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    ++noTabs;
                                } else if (current == ' ') {
                                    hasAddLiteral = this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, false, firstTokenOnLineFlag, fileName);
                                    if (hasAddLiteral) {
                                        noSpaces = 0;
                                        noTabs = 0;
                                        firstTokenOnLineFlag = false;
                                    }
                                    ++noSpaces;
                                } else if (current != '\r') {
                                    if (current == '\n') {
                                        hasAddLiteral = prev == '\r' ? this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile - 1, offsetLine - 1, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName) : this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName);
                                        if (this.fPrevToken != null) {
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                            if (!hasAddLiteral && this.fPrevToken.getLineNumber() == lineNumber) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                                this.fPrevToken.setLastTokenOnLine(true);
                                            }
                                        }
                                        firstTokenOnLineFlag = true;
                                        noSpaces = 0;
                                        noTabs = 0;
                                        offsetLine = -1;
                                        ++lineNumber;
                                    } else {
                                        if (tokenBuffer.length() == 0 && this.fPrevToken != null) {
                                            if (!firstTokenOnLineFlag) {
                                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                                                this.fPrevToken.setNoTabsAfter(noTabs);
                                            }
                                            this.fPrevToken.setOffsetFileNextToken(offsetFile);
                                        }
                                        tokenBuffer.append(current);
                                    }
                                }
                            }
                            prev = current;
                            ++offsetFile;
                            ++offsetLine;
                        }
                        this.addTokenIfExists(tokens, tokensOnLine, zoneType, tokenBuffer, offsetFile, offsetLine, lineNumber, noSpaces, noTabs, true, firstTokenOnLineFlag, fileName);
                        if (this.fPrevToken != null) {
                            if (this.fPrevToken.getNoSpacesAfter() == -1) {
                                this.fPrevToken.setNoSpacesAfter(noSpaces);
                            }
                            if (this.fPrevToken.getNoTabsAfter() == -1) {
                                this.fPrevToken.setNoTabsAfter(noTabs);
                            }
                            this.fPrevToken.setLastTokenOnLine(true);
                            this.fPrevToken.setOffsetFileNextToken(-1);
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        if (reader != null) {
                            reader.close();
                        }
                        break block119;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                if (reader != null) {
                    reader.close();
                }
            }
            this.fAllTokensInFiles.put(fileName, tokens);
            this.fAllTokensOnLine.put(fileName, tokensOnLine);
            this.fLastCodeTokenInFiles.put(fileName, this.fLastCodeToken);
            this.generateFormattingPragmas(fileName, tokens);
        }
        if (BuildConfigManager.getUserDefinedEnvVar((IProject)ovmProject.getProject(), (String)DVT_DEBUG_DATA_WHITESPACE_PARSER, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION) != null) {
            this.printDebugInformation();
        }
    }

    private boolean isSequenceEscaping(StringBuilder token) {
        int counter = 0;
        int i = token.length() - 1;
        while (i >= 0) {
            if (token.charAt(i) != '\\') break;
            ++counter;
            --i;
        }
        return counter % 2 != 0;
    }

    private void printDebugInformation() {
        String headlineTable = String.format("%-40s %25s %8s %8s %8s %8s %8s %8s %8s %8s %8s %8s %8s \n", "Token", "Zone", "OffsetP", "Offset", "OffsetN", "LineNo", "OffsetL", "NoSpaceB", "NoSpaceA", "NoTabsB", "NoTabsA", "FirstL", "LastL");
        StringBuilder data = new StringBuilder();
        List paths = this.fAllTokensInFiles.keySet().stream().sorted((p1, p2) -> p1.compareTo(p2)).collect(Collectors.toList());
        for (ParserPath path : paths) {
            String pathString = path.toString().substring(path.toString().lastIndexOf(47) + 1);
            data.append("Path = ").append(pathString).append("\n");
            data.append(headlineTable);
            LinkedList<LiteralToken> tokens = new LinkedList<LiteralToken>(this.fAllTokensInFiles.get(path).values());
            int i = 0;
            while (i < tokens.size() - 1) {
                LiteralToken current = (LiteralToken)tokens.get(i);
                LiteralToken next = (LiteralToken)tokens.get(i + 1);
                if (current.getOffsetFileNextToken() != next.getOffsetFile()) {
                    data.append("Offfset next-chain check FAILED: error at token: '" + current.getStringToken() + "' at line " + current.getLineNumber() + "!\n");
                }
                if (current.getOffsetFile() != next.getOffsetFilePrevToken()) {
                    data.append("Offfset prev-chain check FAILED: error at token: '" + current.getStringToken() + "' at line " + current.getLineNumber() + "!\n");
                }
                ++i;
            }
            for (LiteralToken token : tokens) {
                String tokenInfo = String.format("%-40s %25s %8s %8s %8s %8s %8s %8s %8s %8s %8s %8s %8s \n", token.getStringToken(), token.getZone().toString(), token.getOffsetFilePrevToken(), token.getOffsetFile(), token.getOffsetFileNextToken(), token.getLineNumber(), token.getOffsetLine(), token.getNoSpacesBefore(), token.getNoSpacesAfter(), token.getNoTabsBefore(), token.getNoTabsAfter(), token.isFirstTokenOnLine(), token.isLastTokenOnLine());
                data.append(tokenInfo);
            }
            data.append("\n");
        }
        try {
            PrintStream commandOutputFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File("dump_whitespace_parser.txt"))));
            commandOutputFile.println(data.toString());
            commandOutputFile.close();
        }
        catch (FileNotFoundException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean addTokenIfExists(Map<Integer, LiteralToken> tokens, Map<Integer, List<LiteralToken>> tokensOnLine, ZoneType zone, StringBuilder tokenBuffer, int offsetFile, int offsetLine, int lineNumber, int noSpaces, int noTabs, boolean endOfLineFlag, boolean firstTokenOnLineFlag, ParserPath parserPath) {
        if (tokenBuffer.length() == 0) {
            return false;
        }
        LiteralToken currentToken = SVTBWhitespaceParser.createToken(tokenBuffer, offsetFile, offsetLine, lineNumber);
        currentToken.setZone(zone);
        currentToken.setNoSpacesBefore(noSpaces);
        currentToken.setNoTabsBefore(noTabs);
        if (endOfLineFlag) {
            currentToken.setNoSpacesAfter(0);
            currentToken.setNoTabsAfter(0);
        }
        currentToken.setLastTokenOnLine(endOfLineFlag);
        currentToken.setFirstTokenOnLine(firstTokenOnLineFlag);
        if (this.fPrevToken != null) {
            currentToken.setOffsetFilePrevToken(this.fPrevToken.getOffsetFile());
        }
        tokens.put(currentToken.getOffsetFile(), currentToken);
        tokensOnLine.putIfAbsent(lineNumber, new LinkedList());
        tokensOnLine.get(lineNumber).add(currentToken);
        this.fPrevToken = currentToken;
        if (zone == ZoneType.CODE) {
            if (!this.fFoundFirstCodeToken) {
                this.fFoundFirstCodeToken = true;
                this.fFirstCodeTokenInFiles.put(parserPath, currentToken);
            }
            this.fLastCodeToken = currentToken;
        }
        tokenBuffer.setLength(0);
        return true;
    }

    private static LiteralToken createToken(StringBuilder tokenBuffer, int offsetFile, int offsetLine, int lineNumber) {
        String token = tokenBuffer.toString();
        LiteralToken literalToken = new LiteralToken(token, offsetFile - tokenBuffer.length(), offsetLine - tokenBuffer.length(), lineNumber);
        return literalToken;
    }

    public Map<Integer, LiteralToken> getTokens(ParserPath file) {
        if (this.fAllTokensInFiles == null || this.fAllTokensInFiles.isEmpty()) {
            return null;
        }
        return this.fAllTokensInFiles.get(file);
    }

    public LiteralToken getToken(int offset, ParserPath file) {
        if (this.fAllTokensInFiles == null || this.fAllTokensInFiles.isEmpty() || file == null || offset == -1) {
            return null;
        }
        Map<Integer, LiteralToken> tokens = this.fAllTokensInFiles.get(file);
        return tokens == null ? null : tokens.get(offset);
    }

    public LiteralToken getTokenByEnding(int offset, ParserPath file) {
        if (this.fAllTokensInFilesByEnding == null || this.fAllTokensInFilesByEnding.isEmpty() || file == null || offset == -1) {
            return null;
        }
        Map<Integer, LiteralToken> tokens = this.fAllTokensInFilesByEnding.get(file);
        return tokens == null ? null : tokens.get(offset);
    }

    public LiteralToken getTokenContainingOffset(int offset, ParserPath file) {
        int tokenIndex;
        LiteralToken token = this.getToken(offset, file);
        if (token != null) {
            return token;
        }
        if (this.fAllTokensInFiles == null || this.fAllTokensInFiles.isEmpty() || this.fAllTokensInFiles.get(file) == null || this.fTokensInFilesCache == null) {
            return null;
        }
        if (file == null || offset == -1) {
            return null;
        }
        LiteralToken dummyToken = new LiteralToken(offset);
        List<LiteralToken> tokensList = this.fTokensInFilesCache.get(file);
        if (tokensList == null) {
            tokensList = new ArrayList<LiteralToken>(this.fAllTokensInFiles.get(file).values());
            this.fTokensInFilesCache.put(file, tokensList);
        }
        if ((tokenIndex = Math.abs(SVTBWhitespaceParser.indexOfTokenInFile(tokensList, dummyToken)) - 2) < 0 || tokenIndex >= tokensList.size()) {
            return null;
        }
        token = tokensList.get(tokenIndex);
        if (token.getOffsetFile() > offset || offset >= token.getOffsetFile() + token.getLength()) {
            return null;
        }
        return token;
    }

    public List<LiteralToken> getTokensOnLine(ParserPath file, int line) {
        if (this.fAllTokensOnLine == null || this.fAllTokensOnLine.isEmpty() || this.fAllTokensOnLine.get(file) == null) {
            return new ArrayList<LiteralToken>();
        }
        List<LiteralToken> tokensOnLine = this.fAllTokensOnLine.get(file).get(line);
        if (tokensOnLine == null) {
            return new ArrayList<LiteralToken>();
        }
        return tokensOnLine;
    }

    public LiteralToken getFirstTokenOnLine(ParserPath file, int line) {
        List<LiteralToken> tokensOnLine = this.getTokensOnLine(file, line);
        for (LiteralToken token : tokensOnLine) {
            if (!token.isFirstTokenOnLine()) continue;
            return token;
        }
        return null;
    }

    private static int indexOfTokenInFile(List<LiteralToken> tokensList, LiteralToken token) {
        int tokenIndex = Collections.binarySearch(tokensList, token, new Comparator<LiteralToken>(){

            @Override
            public int compare(LiteralToken o1, LiteralToken o2) {
                return o1.getOffsetFile() - o2.getOffsetFile();
            }
        });
        return tokenIndex;
    }

    public LiteralToken getPrevToken(LiteralToken token, ParserPath file) {
        if (token == null || file == null) {
            return null;
        }
        return this.getToken(token.getOffsetFilePrevToken(), file);
    }

    public LiteralToken getNextToken(LiteralToken token, ParserPath file) {
        if (token == null || file == null) {
            return null;
        }
        return this.getToken(token.getOffsetFileNextToken(), file);
    }

    public Set<DVTPair<Integer, Integer>> getFormattingPragmas(ParserPath file) {
        if (this.fAllFormattingPragmasInFiles == null || this.fAllFormattingPragmasInFiles.isEmpty()) {
            return null;
        }
        return this.fAllFormattingPragmasInFiles.get(file);
    }

    public void clean() {
        this.fTokensGenerated = false;
        this.fEndingsGenerated = false;
        if (this.fFilesWithGeneratedTokens != null) {
            this.fFilesWithGeneratedTokens.clear();
        }
        if (this.fFilesWithEndingsGenerated != null) {
            this.fFilesWithEndingsGenerated.clear();
        }
        if (this.fChecksWithGeneratedTokens != null) {
            this.fChecksWithGeneratedTokens.clear();
        }
        this.fPrevToken = null;
        if (this.fAllTokensInFiles != null) {
            this.fAllTokensInFiles.clear();
        }
        if (this.fAllTokensInFilesByEnding != null) {
            this.fAllTokensInFilesByEnding.clear();
        }
        if (this.fAllTokensOnLine != null) {
            this.fAllTokensOnLine.clear();
        }
        if (this.fTokensInFilesCache != null) {
            this.fTokensInFilesCache.clear();
        }
        if (this.fAllImportedFiles != null) {
            this.fAllImportedFiles.clear();
        }
        if (this.fAllFormattingPragmasInFiles != null) {
            this.fAllFormattingPragmasInFiles.clear();
        }
    }

    public void initLazy(OVMProject ovmProject, IWhitespaceParserCheck check) {
        try {
            if (this.fChecksWithGeneratedTokens.contains(check.getName())) {
                return;
            }
            if (this.shouldGenerateTokens(ovmProject)) {
                this.generateAllTokensInFiles(ovmProject, check);
            }
            if (this.shouldGenerateEndings(ovmProject) && check.requiresLineEndings()) {
                this.generateOffsetsEndings(ovmProject, check);
            }
            this.fChecksWithGeneratedTokens.add(check.getName());
        }
        catch (IOException e) {
            ovmProject.notifyCheckException(check, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.clean();
        }
    }

    public boolean shouldGenerateTokens(OVMProject ovmProject) {
        if (this.fTokensGenerated) {
            return false;
        }
        if (ovmProject.getAllImportedFiles().size() != this.fFilesWithGeneratedTokens.size()) {
            return true;
        }
        this.fTokensGenerated = true;
        return false;
    }

    public boolean shouldGenerateEndings(OVMProject ovmProject) {
        if (this.fEndingsGenerated) {
            return false;
        }
        if (ovmProject.getAllImportedFiles().size() != this.fFilesWithEndingsGenerated.size()) {
            return true;
        }
        this.fEndingsGenerated = true;
        return false;
    }

    private void generateFormattingPragmas(ParserPath fileName, Map<Integer, LiteralToken> tokens) {
        int lastFormatterOffLine = -1;
        for (Map.Entry<Integer, LiteralToken> entry : tokens.entrySet()) {
            Set<DVTPair<Integer, Integer>> fileFormattingPragmas;
            LiteralToken token = entry.getValue();
            if (token.getZone() != ZoneType.SINGLE_COMMENT && token.getZone() != ZoneType.MULTILINE_COMMENT) continue;
            if (token.getStringToken().contains(FORMMATER_OFF)) {
                lastFormatterOffLine = token.getLineNumber();
                continue;
            }
            if (token.getStringToken().contains(FORMMATER_ON)) {
                if (lastFormatterOffLine == -1) continue;
                fileFormattingPragmas = this.getFormaterPragmasInFile(fileName);
                fileFormattingPragmas.add((DVTPair<Integer, Integer>)new DVTPair((Object)lastFormatterOffLine, (Object)token.getLineNumber()));
                lastFormatterOffLine = -1;
                continue;
            }
            if (!token.getStringToken().contains(FORMMATER_SKIP)) continue;
            fileFormattingPragmas = this.getFormaterPragmasInFile(fileName);
            fileFormattingPragmas.add((DVTPair<Integer, Integer>)new DVTPair((Object)token.getLineNumber(), (Object)token.getLineNumber()));
            lastFormatterOffLine = -1;
        }
    }

    private Set<DVTPair<Integer, Integer>> getFormaterPragmasInFile(ParserPath fileName) {
        Set<DVTPair<Integer, Integer>> fileFormattingPragmas = this.fAllFormattingPragmasInFiles.get(fileName);
        if (fileFormattingPragmas == null) {
            fileFormattingPragmas = new LinkedHashSet<DVTPair<Integer, Integer>>();
            this.fAllFormattingPragmasInFiles.put(fileName, fileFormattingPragmas);
        }
        return fileFormattingPragmas;
    }

    public LiteralToken getFirstCodeToken(ParserPath fileName) {
        if (this.fFirstCodeTokenInFiles == null || this.fFirstCodeTokenInFiles.isEmpty() || this.fFirstCodeTokenInFiles.get(fileName) == null) {
            return null;
        }
        return this.fFirstCodeTokenInFiles.get(fileName);
    }

    public LiteralToken getLastCodeToken(ParserPath fileName) {
        if (this.fLastCodeTokenInFiles == null || this.fLastCodeTokenInFiles.isEmpty() || this.fLastCodeTokenInFiles.get(fileName) == null) {
            return null;
        }
        return this.fLastCodeTokenInFiles.get(fileName);
    }

    public LiteralToken getNextCodeToken(LiteralToken token, ParserPath file) {
        if (token == null || file == null) {
            return null;
        }
        LiteralToken nextToken = this.getToken(token.getOffsetFileNextToken(), file);
        while (nextToken != null && nextToken.getZone() != ZoneType.CODE) {
            nextToken = this.getToken(nextToken.getOffsetFileNextToken(), file);
        }
        return nextToken;
    }

    public LiteralToken getPrevCodeToken(LiteralToken token, ParserPath file) {
        if (token == null || file == null) {
            return null;
        }
        LiteralToken prevToken = this.getToken(token.getOffsetFilePrevToken(), file);
        while (prevToken != null && !prevToken.getZone().equals((Object)ZoneType.CODE)) {
            prevToken = this.getToken(prevToken.getOffsetFilePrevToken(), file);
        }
        return prevToken;
    }

    public static enum ZoneType {
        CODE,
        SINGLE_COMMENT,
        MULTILINE_COMMENT,
        STRING,
        ESCAPE_IDENTIFIER;

    }
}

