/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.util.HashSet;
import java.util.Set;

public class XVMDocumentedAPI {
    private static Set<String> documentedConstants;
    private static Set<String> documentedClassesCompleteName;
    private static Set<String> documentedClassesPatternName;
    private static Set<String> documentedMacroNames;
    private static Set<String> documentedMethodNames;
    private static Set<String> documentedMethodPatternNames;
    private static Set<String> documentedPorts;
    private static Set<String> documentedTypes;
    private static Set<String> documentedVariables;

    public static boolean isDocumentedConstant(String in) {
        if (documentedConstants == null) {
            XVMDocumentedAPI.addConstants();
        }
        return documentedConstants.contains(in);
    }

    public static boolean isDocumentedClass(String in) {
        if (documentedClassesCompleteName == null) {
            XVMDocumentedAPI.addClassesCompleteName();
        }
        if (documentedClassesPatternName == null) {
            XVMDocumentedAPI.addClassesPattern();
        }
        if (documentedClassesCompleteName.contains(in)) {
            return true;
        }
        for (String pattern : documentedClassesPatternName) {
            if (!in.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDocumentedMacro(String in) {
        if (documentedMacroNames == null) {
            XVMDocumentedAPI.addMacroNames();
        }
        return documentedMacroNames.contains(in);
    }

    public static boolean isDocumentedMethod(String in) {
        if (documentedMethodNames == null) {
            XVMDocumentedAPI.addMethodNames();
        }
        if (documentedMethodPatternNames == null) {
            XVMDocumentedAPI.addMethodPatternNames();
        }
        if (documentedMethodNames.contains(in)) {
            return true;
        }
        for (String pattern : documentedMethodPatternNames) {
            if (!in.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDocumentedPort(String in) {
        if (documentedPorts == null) {
            XVMDocumentedAPI.addPorts();
        }
        return documentedPorts.contains(in);
    }

    public static boolean isDocumentedType(String in) {
        if (documentedTypes == null) {
            XVMDocumentedAPI.addTypes();
        }
        return documentedTypes.contains(in);
    }

    public static boolean isDocumentedVariable(String in) {
        if (documentedVariables == null) {
            XVMDocumentedAPI.addVariables();
        }
        return documentedVariables.contains(in);
    }

    private static void addConstants() {
        documentedConstants = new HashSet<String>();
        documentedConstants.add("uvm_pkg::BEGIN_REQ");
        documentedConstants.add("uvm_pkg::BEGIN_RESP");
        documentedConstants.add("uvm_pkg::END_REQ");
        documentedConstants.add("uvm_pkg::END_RESP");
        documentedConstants.add("uvm_pkg::UNINITIALIZED_PHASE");
        documentedConstants.add("uvm_pkg::UVM_ACTIVE");
        documentedConstants.add("uvm_pkg::UVM_ALL_DROPPED");
        documentedConstants.add("uvm_pkg::UVM_BACKDOOR");
        documentedConstants.add("uvm_pkg::UVM_BIG_ENDIAN");
        documentedConstants.add("uvm_pkg::UVM_BIG_FIFO");
        documentedConstants.add("uvm_pkg::UVM_BIN");
        documentedConstants.add("uvm_pkg::UVM_BODY");
        documentedConstants.add("uvm_pkg::UVM_CALL_HOOK");
        documentedConstants.add("uvm_pkg::UVM_CHECK");
        documentedConstants.add("uvm_pkg::UVM_COUNT");
        documentedConstants.add("uvm_pkg::UVM_CREATED");
        documentedConstants.add("uvm_pkg::UVM_CVR_ADDR_MAP");
        documentedConstants.add("uvm_pkg::UVM_CVR_ALL");
        documentedConstants.add("uvm_pkg::UVM_CVR_FIELD_VALS");
        documentedConstants.add("uvm_pkg::UVM_CVR_REG_BITS");
        documentedConstants.add("uvm_pkg::UVM_DEC");
        documentedConstants.add("uvm_pkg::UVM_DEEP");
        documentedConstants.add("uvm_pkg::UVM_DEFAULT_PATH");
        documentedConstants.add("uvm_pkg::UVM_DISPLAY");
        documentedConstants.add("uvm_pkg::UVM_DO_ALL_REG_MEM_TESTS");
        documentedConstants.add("uvm_pkg::UVM_DO_MEM_ACCESS");
        documentedConstants.add("uvm_pkg::UVM_DO_MEM_WALK");
        documentedConstants.add("uvm_pkg::UVM_DO_REG_ACCESS");
        documentedConstants.add("uvm_pkg::UVM_DO_REG_BIT_BASH");
        documentedConstants.add("uvm_pkg::UVM_DO_REG_HW_RESET");
        documentedConstants.add("uvm_pkg::UVM_DO_SHARED_ACCESS");
        documentedConstants.add("uvm_pkg::UVM_DROPPED");
        documentedConstants.add("uvm_pkg::UVM_ENDED");
        documentedConstants.add("uvm_pkg::UVM_ENUM");
        documentedConstants.add("uvm_pkg::UVM_EQ");
        documentedConstants.add("uvm_pkg::UVM_ERROR");
        documentedConstants.add("uvm_pkg::UVM_EXIT");
        documentedConstants.add("uvm_pkg::UVM_EXPORT");
        documentedConstants.add("uvm_pkg::UVM_FATAL");
        documentedConstants.add("uvm_pkg::UVM_FIELD");
        documentedConstants.add("uvm_pkg::UVM_FINISHED");
        documentedConstants.add("uvm_pkg::UVM_FRONTDOOR");
        documentedConstants.add("uvm_pkg::UVM_FULL");
        documentedConstants.add("uvm_pkg::UVM_GT");
        documentedConstants.add("uvm_pkg::UVM_GTE");
        documentedConstants.add("uvm_pkg::UVM_HAS_X");
        documentedConstants.add("uvm_pkg::UVM_HEX");
        documentedConstants.add("uvm_pkg::UVM_HIER");
        documentedConstants.add("uvm_pkg::UVM_HIGH");
        documentedConstants.add("uvm_pkg::UVM_IMPLEMENTATION");
        documentedConstants.add("uvm_pkg::UVM_INFO");
        documentedConstants.add("uvm_pkg::UVM_IS_OK");
        documentedConstants.add("uvm_pkg::UVM_LITTLE_ENDIAN");
        documentedConstants.add("uvm_pkg::UVM_LITTLE_FIFO");
        documentedConstants.add("uvm_pkg::UVM_LOG");
        documentedConstants.add("uvm_pkg::UVM_LOW");
        documentedConstants.add("uvm_pkg::UVM_LT");
        documentedConstants.add("uvm_pkg::UVM_LTE");
        documentedConstants.add("uvm_pkg::UVM_MEDIUM");
        documentedConstants.add("uvm_pkg::UVM_MEM");
        documentedConstants.add("uvm_pkg::UVM_NE");
        documentedConstants.add("uvm_pkg::UVM_NO_ACTION");
        documentedConstants.add("uvm_pkg::UVM_NO_CHECK");
        documentedConstants.add("uvm_pkg::UVM_NO_COVERAGE");
        documentedConstants.add("uvm_pkg::UVM_NO_ENDIAN");
        documentedConstants.add("uvm_pkg::UVM_NO_HIER");
        documentedConstants.add("uvm_pkg::UVM_NONE");
        documentedConstants.add("uvm_pkg::UVM_NOT_OK");
        documentedConstants.add("uvm_pkg::UVM_OCT");
        documentedConstants.add("uvm_pkg::UVM_PASSIVE");
        documentedConstants.add("uvm_pkg::UVM_PHASE_CLEANUP");
        documentedConstants.add("uvm_pkg::UVM_PHASE_DOMAIN");
        documentedConstants.add("uvm_pkg::UVM_PHASE_DONE");
        documentedConstants.add("uvm_pkg::UVM_PHASE_DORMANT");
        documentedConstants.add("uvm_pkg::UVM_PHASE_ENDED");
        documentedConstants.add("uvm_pkg::UVM_PHASE_EXECUTING");
        documentedConstants.add("uvm_pkg::UVM_PHASE_IMP");
        documentedConstants.add("uvm_pkg::UVM_PHASE_JUMPING");
        documentedConstants.add("uvm_pkg::UVM_PHASE_NODE");
        documentedConstants.add("uvm_pkg::UVM_PHASE_READY_TO_END");
        documentedConstants.add("uvm_pkg::UVM_PHASE_SCHEDULE");
        documentedConstants.add("uvm_pkg::UVM_PHASE_SCHEDULED");
        documentedConstants.add("uvm_pkg::UVM_PHASE_STARTED");
        documentedConstants.add("uvm_pkg::UVM_PHASE_SYNCING");
        documentedConstants.add("uvm_pkg::UVM_PHASE_TERMINAL");
        documentedConstants.add("uvm_pkg::UVM_PHASE_UNINITIALIZED");
        documentedConstants.add("uvm_pkg::UVM_PORT");
        documentedConstants.add("uvm_pkg::UVM_POST_BODY");
        documentedConstants.add("uvm_pkg::UVM_POST_START");
        documentedConstants.add("uvm_pkg::UVM_PRE_BODY");
        documentedConstants.add("uvm_pkg::UVM_PRE_START");
        documentedConstants.add("uvm_pkg::UVM_PREDICT");
        documentedConstants.add("uvm_pkg::UVM_PREDICT_DIRECT");
        documentedConstants.add("uvm_pkg::UVM_PREDICT_READ");
        documentedConstants.add("uvm_pkg::UVM_PREDICT_WRITE");
        documentedConstants.add("uvm_pkg::UVM_RAISED");
        documentedConstants.add("uvm_pkg::UVM_READ");
        documentedConstants.add("uvm_pkg::UVM_REAL");
        documentedConstants.add("uvm_pkg::UVM_REAL_DEC");
        documentedConstants.add("uvm_pkg::UVM_REAL_EXP");
        documentedConstants.add("uvm_pkg::UVM_REFERENCE");
        documentedConstants.add("uvm_pkg::UVM_REG");
        documentedConstants.add("uvm_pkg::UVM_RM_RECORD");
        documentedConstants.add("uvm_pkg::UVM_SEQ_ARB_FIFO");
        documentedConstants.add("uvm_pkg::UVM_SEQ_ARB_RANDOM");
        documentedConstants.add("uvm_pkg::UVM_SEQ_ARB_STRICT_FIFO");
        documentedConstants.add("uvm_pkg::UVM_SEQ_ARB_STRICT_RANDOM");
        documentedConstants.add("uvm_pkg::UVM_SEQ_ARB_USER");
        documentedConstants.add("uvm_pkg::UVM_SEQ_ARB_WEIGHTED");
        documentedConstants.add("uvm_pkg::UVM_SEQ_LIB_ITEM");
        documentedConstants.add("uvm_pkg::UVM_SEQ_LIB_RAND");
        documentedConstants.add("uvm_pkg::UVM_SEQ_LIB_RANDC");
        documentedConstants.add("uvm_pkg::UVM_SEQ_LIB_USER");
        documentedConstants.add("uvm_pkg::UVM_SHALLOW");
        documentedConstants.add("uvm_pkg::UVM_STOP");
        documentedConstants.add("uvm_pkg::UVM_STOPPED");
        documentedConstants.add("uvm_pkg::UVM_STRING");
        documentedConstants.add("uvm_pkg::UVM_TIME");
        documentedConstants.add("uvm_pkg::UVM_TLM_ACCEPTED");
        documentedConstants.add("uvm_pkg::UVM_TLM_ADDRESS_ERROR_RESPONSE");
        documentedConstants.add("uvm_pkg::UVM_TLM_BURST_ERROR_RESPONSE");
        documentedConstants.add("uvm_pkg::UVM_TLM_BYTE_ENABLE_ERROR_RESPONSE");
        documentedConstants.add("uvm_pkg::UVM_TLM_COMMAND_ERROR_RESPONSE");
        documentedConstants.add("uvm_pkg::UVM_TLM_COMPLETED");
        documentedConstants.add("uvm_pkg::UVM_TLM_GENERIC_ERROR_RESPONSE");
        documentedConstants.add("uvm_pkg::UVM_TLM_IGNORE_COMMAND");
        documentedConstants.add("uvm_pkg::UVM_TLM_INCOMPLETE_RESPONSE");
        documentedConstants.add("uvm_pkg::UVM_TLM_OK_RESPONSE");
        documentedConstants.add("uvm_pkg::UVM_TLM_READ_COMMAND");
        documentedConstants.add("uvm_pkg::UVM_TLM_UPDATED");
        documentedConstants.add("uvm_pkg::UVM_TLM_WRITE_COMMAND");
        documentedConstants.add("uvm_pkg::UVM_UNFORMAT2");
        documentedConstants.add("uvm_pkg::UVM_UNFORMAT4");
        documentedConstants.add("uvm_pkg::UVM_UNSIGNED");
        documentedConstants.add("uvm_pkg::UVM_WARNING");
        documentedConstants.add("uvm_pkg::UVM_WRITE");
    }

    private static void addClassesCompleteName() {
        documentedClassesCompleteName = new HashSet<String>();
        documentedClassesCompleteName.add("uvm_pkg::uvm_agent");
        documentedClassesCompleteName.add("uvm_pkg::uvm_algorithmic_comparator");
        documentedClassesCompleteName.add("uvm_pkg::uvm_analysis_export");
        documentedClassesCompleteName.add("uvm_pkg::uvm_analysis_imp");
        documentedClassesCompleteName.add("uvm_pkg::uvm_analysis_port");
        documentedClassesCompleteName.add("uvm_pkg::uvm_barrier");
        documentedClassesCompleteName.add("uvm_pkg::uvm_bottom_up_visitor_adapter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_bottomup_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_build_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_built_in_clone");
        documentedClassesCompleteName.add("uvm_pkg::uvm_built_in_comp");
        documentedClassesCompleteName.add("uvm_pkg::uvm_built_in_converter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_built_in_pair");
        documentedClassesCompleteName.add("uvm_pkg::uvm_by_level_visitor_adapter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_callback");
        documentedClassesCompleteName.add("uvm_pkg::uvm_callback_iter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_callbacks");
        documentedClassesCompleteName.add("uvm_pkg::uvm_cause_effect_link");
        documentedClassesCompleteName.add("uvm_pkg::uvm_check_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_class_clone");
        documentedClassesCompleteName.add("uvm_pkg::uvm_class_comp");
        documentedClassesCompleteName.add("uvm_pkg::uvm_class_converter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_class_pair");
        documentedClassesCompleteName.add("uvm_pkg::uvm_cmdline_processor");
        documentedClassesCompleteName.add("uvm_pkg::uvm_comparer");
        documentedClassesCompleteName.add("uvm_pkg::uvm_component");
        documentedClassesCompleteName.add("uvm_pkg::uvm_component_name_check_visitor");
        documentedClassesCompleteName.add("uvm_pkg::uvm_component_proxy");
        documentedClassesCompleteName.add("uvm_pkg::uvm_component_registry");
        documentedClassesCompleteName.add("uvm_pkg::uvm_config_db");
        documentedClassesCompleteName.add("uvm_pkg::uvm_config_db_options");
        documentedClassesCompleteName.add("uvm_pkg::uvm_configure_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_connect_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_coreservice_t");
        documentedClassesCompleteName.add("uvm_pkg::uvm_default_coreservice_t");
        documentedClassesCompleteName.add("uvm_pkg::uvm_default_factory");
        documentedClassesCompleteName.add("uvm_pkg::uvm_default_report_server");
        documentedClassesCompleteName.add("uvm_pkg::uvm_domain");
        documentedClassesCompleteName.add("uvm_pkg::uvm_driver");
        documentedClassesCompleteName.add("uvm_pkg::uvm_end_of_elaboration_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_enum_wrapper");
        documentedClassesCompleteName.add("uvm_pkg::uvm_env");
        documentedClassesCompleteName.add("uvm_pkg::uvm_event");
        documentedClassesCompleteName.add("uvm_pkg::uvm_event_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_event_callback");
        documentedClassesCompleteName.add("uvm_pkg::uvm_extract_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_factory");
        documentedClassesCompleteName.add("uvm_pkg::uvm_final_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_get_to_lock_dap");
        documentedClassesCompleteName.add("uvm_pkg::uvm_hdl_path_concat");
        documentedClassesCompleteName.add("uvm_pkg::uvm_heartbeat");
        documentedClassesCompleteName.add("uvm_pkg::uvm_in_order_built_in_comparator");
        documentedClassesCompleteName.add("uvm_pkg::uvm_in_order_class_comparator");
        documentedClassesCompleteName.add("uvm_pkg::uvm_in_order_comparator");
        documentedClassesCompleteName.add("uvm_pkg::uvm_line_printer");
        documentedClassesCompleteName.add("uvm_pkg::uvm_link_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_main_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_access_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_mam");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_mam_cfg");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_mam_policy");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_region");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_shared_access_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_single_access_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_single_walk_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_mem_walk_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_monitor");
        documentedClassesCompleteName.add("uvm_pkg::uvm_object");
        documentedClassesCompleteName.add("uvm_pkg::uvm_object_registry");
        documentedClassesCompleteName.add("uvm_pkg::uvm_object_string_pool");
        documentedClassesCompleteName.add("uvm_pkg::uvm_object_wrapper");
        documentedClassesCompleteName.add("uvm_pkg::uvm_objection");
        documentedClassesCompleteName.add("uvm_pkg::uvm_objection_callback");
        documentedClassesCompleteName.add("uvm_pkg::uvm_packer");
        documentedClassesCompleteName.add("uvm_pkg::uvm_parent_child_link");
        documentedClassesCompleteName.add("uvm_pkg::uvm_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_phase_cb");
        documentedClassesCompleteName.add("uvm_pkg::uvm_phase_state_change");
        documentedClassesCompleteName.add("uvm_pkg::uvm_pool");
        documentedClassesCompleteName.add("uvm_pkg::uvm_port_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_port_component");
        documentedClassesCompleteName.add("uvm_pkg::uvm_port_component_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_post_configure_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_post_main_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_post_reset_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_post_shutdown_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_pre_configure_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_pre_main_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_pre_reset_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_pre_shutdown_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_printer");
        documentedClassesCompleteName.add("uvm_pkg::uvm_printer_knobs");
        documentedClassesCompleteName.add("uvm_pkg::uvm_push_driver");
        documentedClassesCompleteName.add("uvm_pkg::uvm_push_sequencer");
        documentedClassesCompleteName.add("uvm_pkg::uvm_queue");
        documentedClassesCompleteName.add("uvm_pkg::uvm_random_stimulus");
        documentedClassesCompleteName.add("uvm_pkg::uvm_recorder");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_access_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_adapter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_backdoor");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_bit_bash_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_block");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_cbs");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_field");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_fifo");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_file");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_frontdoor");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_hw_reset_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_indirect_data");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_item");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_map");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_mem_access_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_mem_built_in_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_mem_hdl_paths_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_mem_shared_access_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_predictor");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_read_only_cbs");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_sequence");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_shared_access_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_single_access_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_single_bit_bash_seq");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_tlm_adapter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_transaction_order_policy");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reg_write_only_cbs");
        documentedClassesCompleteName.add("uvm_pkg::uvm_related_link");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_catcher");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_handler");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_message");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_message_element_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_message_element_container");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_message_int_element");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_message_object_element");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_message_string_element");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_object");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_report_server");
        documentedClassesCompleteName.add("uvm_pkg::uvm_reset_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_resource");
        documentedClassesCompleteName.add("uvm_pkg::uvm_resource_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_resource_db");
        documentedClassesCompleteName.add("uvm_pkg::uvm_resource_db_options");
        documentedClassesCompleteName.add("uvm_pkg::uvm_resource_options");
        documentedClassesCompleteName.add("uvm_pkg::uvm_resource_pool");
        documentedClassesCompleteName.add("uvm_pkg::uvm_resource_types");
        documentedClassesCompleteName.add("uvm_pkg::uvm_root");
        documentedClassesCompleteName.add("uvm_pkg::uvm_run_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_scoreboard");
        documentedClassesCompleteName.add("uvm_pkg::uvm_seq_item_pull_export");
        documentedClassesCompleteName.add("uvm_pkg::uvm_seq_item_pull_imp");
        documentedClassesCompleteName.add("uvm_pkg::uvm_seq_item_pull_port");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sequence");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sequence_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sequence_item");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sequence_library");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sequence_library_cfg");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sequencer");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sequencer_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sequencer_param_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_set_before_get_dap");
        documentedClassesCompleteName.add("uvm_pkg::uvm_set_get_dap_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_shutdown_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_simple_lock_dap");
        documentedClassesCompleteName.add("uvm_pkg::uvm_sqr_if_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_start_of_simulation_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_structure_proxy");
        documentedClassesCompleteName.add("uvm_pkg::uvm_subscriber");
        documentedClassesCompleteName.add("uvm_pkg::uvm_table_printer");
        documentedClassesCompleteName.add("uvm_pkg::uvm_task_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_test");
        documentedClassesCompleteName.add("uvm_pkg::uvm_text_recorder");
        documentedClassesCompleteName.add("uvm_pkg::uvm_text_tr_database");
        documentedClassesCompleteName.add("uvm_pkg::uvm_text_tr_stream");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_analysis_fifo");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_initiator_socket");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_initiator_socket_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_passthrough_initiator_socket");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_passthrough_initiator_socket_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_passthrough_target_socket");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_passthrough_target_socket_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_target_socket");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_target_socket_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_transport_export");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_transport_imp");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_b_transport_port");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_extension");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_extension_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_fifo");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_fifo_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_generic_payload");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_if");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_if_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_initiator_socket");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_initiator_socket_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_passthrough_initiator_socket");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_passthrough_initiator_socket_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_passthrough_target_socket");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_passthrough_target_socket_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_target_socket");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_target_socket_base");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_transport_bw_export");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_transport_bw_imp");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_transport_bw_port");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_transport_fw_export");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_transport_fw_imp");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_nb_transport_fw_port");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_req_rsp_channel");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_time");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tlm_transport_channel");
        documentedClassesCompleteName.add("uvm_pkg::uvm_top_down_visitor_adapter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_topdown_phase");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tr_database");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tr_stream");
        documentedClassesCompleteName.add("uvm_pkg::uvm_transaction");
        documentedClassesCompleteName.add("uvm_pkg::uvm_tree_printer");
        documentedClassesCompleteName.add("uvm_pkg::uvm_utils");
        documentedClassesCompleteName.add("uvm_pkg::uvm_visitor");
        documentedClassesCompleteName.add("uvm_pkg::uvm_visitor_adapter");
        documentedClassesCompleteName.add("uvm_pkg::uvm_void");
        documentedClassesCompleteName.add("uvm_pkg::uvm_vreg");
        documentedClassesCompleteName.add("uvm_pkg::uvm_vreg_cbs");
        documentedClassesCompleteName.add("uvm_pkg::uvm_vreg_field");
    }

    private static void addClassesPattern() {
        documentedClassesPatternName = new HashSet<String>();
        documentedClassesPatternName.add("uvm_pkg::uvm_.*_export");
        documentedClassesPatternName.add("uvm_pkg::uvm_.*_export");
        documentedClassesPatternName.add("uvm_pkg::uvm_.*_imp");
        documentedClassesPatternName.add("uvm_pkg::uvm_.*_imp");
        documentedClassesPatternName.add("uvm_pkg::uvm_.*_port");
        documentedClassesPatternName.add("uvm_pkg::uvm_.*_port");
    }

    private static void addMacroNames() {
        documentedMacroNames = new HashSet<String>();
        documentedMacroNames.add("uvm_add_to_sequence_library");
        documentedMacroNames.add("uvm_analysis_imp_decl");
        documentedMacroNames.add("uvm_blocking_get_imp_decl");
        documentedMacroNames.add("uvm_blocking_get_peek_imp_decl");
        documentedMacroNames.add("uvm_blocking_master_imp_decl");
        documentedMacroNames.add("uvm_blocking_peek_imp_decl");
        documentedMacroNames.add("uvm_blocking_put_imp_decl");
        documentedMacroNames.add("uvm_blocking_slave_imp_decl");
        documentedMacroNames.add("uvm_blocking_transport_imp_decl");
        documentedMacroNames.add("uvm_component_end");
        documentedMacroNames.add("uvm_component_param_utils");
        documentedMacroNames.add("uvm_component_param_utils_begin");
        documentedMacroNames.add("uvm_component_registry");
        documentedMacroNames.add("uvm_component_utils");
        documentedMacroNames.add("uvm_component_utils_begin");
        documentedMacroNames.add("uvm_create");
        documentedMacroNames.add("uvm_create_on");
        documentedMacroNames.add("uvm_declare_p_sequencer");
        documentedMacroNames.add("UVM_DEFAULT_TIMEOUT");
        documentedMacroNames.add("uvm_do");
        documentedMacroNames.add("uvm_do_callbacks");
        documentedMacroNames.add("uvm_do_callbacks_exit_on");
        documentedMacroNames.add("uvm_do_obj_callbacks");
        documentedMacroNames.add("uvm_do_obj_callbacks_exit_on");
        documentedMacroNames.add("uvm_do_on");
        documentedMacroNames.add("uvm_do_on_pri");
        documentedMacroNames.add("uvm_do_on_pri_with");
        documentedMacroNames.add("uvm_do_on_with");
        documentedMacroNames.add("uvm_do_pri");
        documentedMacroNames.add("uvm_do_pri_with");
        documentedMacroNames.add("uvm_do_with");
        documentedMacroNames.add("uvm_error");
        documentedMacroNames.add("uvm_error_begin");
        documentedMacroNames.add("uvm_error_context");
        documentedMacroNames.add("uvm_error_context_begin");
        documentedMacroNames.add("uvm_error_context_end");
        documentedMacroNames.add("uvm_error_end");
        documentedMacroNames.add("uvm_fatal");
        documentedMacroNames.add("uvm_fatal_begin");
        documentedMacroNames.add("uvm_fatal_context");
        documentedMacroNames.add("uvm_fatal_context_begin");
        documentedMacroNames.add("uvm_fatal_context_end");
        documentedMacroNames.add("uvm_fatal_end");
        documentedMacroNames.add("uvm_field_aa_int_byte");
        documentedMacroNames.add("uvm_field_aa_int_byte_unsigned");
        documentedMacroNames.add("uvm_field_aa_int_enumkey");
        documentedMacroNames.add("uvm_field_aa_int_int");
        documentedMacroNames.add("uvm_field_aa_int_int_unsigned");
        documentedMacroNames.add("uvm_field_aa_int_integer");
        documentedMacroNames.add("uvm_field_aa_int_integer_unsigned");
        documentedMacroNames.add("uvm_field_aa_int_key");
        documentedMacroNames.add("uvm_field_aa_int_longint");
        documentedMacroNames.add("uvm_field_aa_int_longint_unsigned");
        documentedMacroNames.add("uvm_field_aa_int_shortint");
        documentedMacroNames.add("uvm_field_aa_int_shortint_unsigned");
        documentedMacroNames.add("uvm_field_aa_int_string");
        documentedMacroNames.add("uvm_field_aa_object_int");
        documentedMacroNames.add("uvm_field_aa_object_string");
        documentedMacroNames.add("uvm_field_aa_string_string");
        documentedMacroNames.add("uvm_field_array_enum");
        documentedMacroNames.add("uvm_field_array_int");
        documentedMacroNames.add("uvm_field_array_object");
        documentedMacroNames.add("uvm_field_array_string");
        documentedMacroNames.add("uvm_field_enum");
        documentedMacroNames.add("uvm_field_event");
        documentedMacroNames.add("uvm_field_int");
        documentedMacroNames.add("uvm_field_object");
        documentedMacroNames.add("uvm_field_queue_enum");
        documentedMacroNames.add("uvm_field_queue_int");
        documentedMacroNames.add("uvm_field_queue_object");
        documentedMacroNames.add("uvm_field_queue_string");
        documentedMacroNames.add("uvm_field_real");
        documentedMacroNames.add("uvm_field_sarray_enum");
        documentedMacroNames.add("uvm_field_sarray_int");
        documentedMacroNames.add("uvm_field_sarray_object");
        documentedMacroNames.add("uvm_field_sarray_string");
        documentedMacroNames.add("uvm_field_string");
        documentedMacroNames.add("uvm_field_utils_begin");
        documentedMacroNames.add("uvm_field_utils_end");
        documentedMacroNames.add("uvm_get_imp_decl");
        documentedMacroNames.add("uvm_get_peek_imp_decl");
        documentedMacroNames.add("uvm_info");
        documentedMacroNames.add("uvm_info_begin");
        documentedMacroNames.add("uvm_info_context");
        documentedMacroNames.add("uvm_info_context_begin");
        documentedMacroNames.add("uvm_info_context_end");
        documentedMacroNames.add("uvm_info_end");
        documentedMacroNames.add("uvm_master_imp_decl");
        documentedMacroNames.add("UVM_MAX_STREAMBITS");
        documentedMacroNames.add("uvm_message_add_int");
        documentedMacroNames.add("uvm_message_add_object");
        documentedMacroNames.add("uvm_message_add_string");
        documentedMacroNames.add("uvm_message_add_tag");
        documentedMacroNames.add("uvm_nonblocking_get_imp_decl");
        documentedMacroNames.add("uvm_nonblocking_get_peek_imp_decl");
        documentedMacroNames.add("uvm_nonblocking_master_imp_decl");
        documentedMacroNames.add("uvm_nonblocking_peek_imp_decl");
        documentedMacroNames.add("uvm_nonblocking_put_imp_decl");
        documentedMacroNames.add("uvm_nonblocking_slave_imp_decl");
        documentedMacroNames.add("uvm_nonblocking_transport_imp_decl");
        documentedMacroNames.add("uvm_object_param_utils");
        documentedMacroNames.add("uvm_object_param_utils_begin");
        documentedMacroNames.add("uvm_object_registry");
        documentedMacroNames.add("uvm_object_utils");
        documentedMacroNames.add("uvm_object_utils_begin");
        documentedMacroNames.add("uvm_object_utils_end");
        documentedMacroNames.add("uvm_pack_array");
        documentedMacroNames.add("uvm_pack_arrayN");
        documentedMacroNames.add("uvm_pack_enum");
        documentedMacroNames.add("uvm_pack_enumN");
        documentedMacroNames.add("uvm_pack_int");
        documentedMacroNames.add("uvm_pack_intN");
        documentedMacroNames.add("uvm_pack_queue");
        documentedMacroNames.add("uvm_pack_queueN");
        documentedMacroNames.add("uvm_pack_real");
        documentedMacroNames.add("uvm_pack_sarray");
        documentedMacroNames.add("uvm_pack_sarrayN");
        documentedMacroNames.add("uvm_pack_string");
        documentedMacroNames.add("UVM_PACKER_MAX_BYTES");
        documentedMacroNames.add("uvm_peek_imp_decl");
        documentedMacroNames.add("uvm_put_imp_decl");
        documentedMacroNames.add("uvm_rand_send");
        documentedMacroNames.add("uvm_rand_send_pri");
        documentedMacroNames.add("uvm_rand_send_pri_with");
        documentedMacroNames.add("uvm_rand_send_with");
        documentedMacroNames.add("uvm_record_attribute");
        documentedMacroNames.add("uvm_record_field");
        documentedMacroNames.add("uvm_record_int");
        documentedMacroNames.add("uvm_record_real");
        documentedMacroNames.add("uvm_record_string");
        documentedMacroNames.add("uvm_record_time");
        documentedMacroNames.add("UVM_REG_ADDR_WIDTH");
        documentedMacroNames.add("UVM_REG_BYTENABLE_WIDTH");
        documentedMacroNames.add("UVM_REG_CVR_WIDTH");
        documentedMacroNames.add("UVM_REG_DATA_WIDTH");
        documentedMacroNames.add("uvm_register_cb");
        documentedMacroNames.add("uvm_send");
        documentedMacroNames.add("uvm_send_pri");
        documentedMacroNames.add("uvm_sequence_library_utils");
        documentedMacroNames.add("uvm_set_super_type");
        documentedMacroNames.add("uvm_slave_imp_decl");
        documentedMacroNames.add("UVM_TLM_B_MASK");
        documentedMacroNames.add("UVM_TLM_B_TRANSPORT_IMP");
        documentedMacroNames.add("UVM_TLM_FUNCTION_ERROR");
        documentedMacroNames.add("UVM_TLM_NB_BW_MASK");
        documentedMacroNames.add("UVM_TLM_NB_FW_MASK");
        documentedMacroNames.add("UVM_TLM_NB_TRANSPORT_BW_IMP");
        documentedMacroNames.add("UVM_TLM_NB_TRANSPORT_FW_IMP");
        documentedMacroNames.add("UVM_TLM_TASK_ERROR");
        documentedMacroNames.add("uvm_transport_imp_decl");
        documentedMacroNames.add("uvm_unpack_array");
        documentedMacroNames.add("uvm_unpack_arrayN");
        documentedMacroNames.add("uvm_unpack_enum");
        documentedMacroNames.add("uvm_unpack_enumN");
        documentedMacroNames.add("uvm_unpack_int");
        documentedMacroNames.add("uvm_unpack_intN");
        documentedMacroNames.add("uvm_unpack_queue");
        documentedMacroNames.add("uvm_unpack_queueN");
        documentedMacroNames.add("uvm_unpack_real");
        documentedMacroNames.add("uvm_unpack_sarray");
        documentedMacroNames.add("uvm_unpack_sarrayN");
        documentedMacroNames.add("uvm_unpack_string");
        documentedMacroNames.add("uvm_warning");
        documentedMacroNames.add("uvm_warning_begin");
        documentedMacroNames.add("uvm_warning_context");
        documentedMacroNames.add("uvm_warning_context_begin");
        documentedMacroNames.add("uvm_warning_context_end");
        documentedMacroNames.add("uvm_warning_end");
        documentedMacroNames.add("UVM_FIX_REV");
        documentedMacroNames.add("UVM_MAJOR_REV");
        documentedMacroNames.add("UVM_MAJOR_REV_1");
        documentedMacroNames.add("UVM_MINOR_REV");
        documentedMacroNames.add("UVM_MINOR_REV_2");
        documentedMacroNames.add("UVM_NAME");
        documentedMacroNames.add("UVM_POST_VERSION_1_1");
        documentedMacroNames.add("uvm_sequence_library_utils");
        documentedMacroNames.add("UVM_VERSION_1_2");
        documentedMacroNames.add("UVM_VERSION_STRING");
    }

    private static void addMethodPatternNames() {
        documentedMethodPatternNames = new HashSet<String>();
        documentedMethodPatternNames.add("uvm_pkg::uvm_.*\\.new");
    }

    private static void addMethodNames() {
        documentedMethodNames = new HashSet<String>();
        documentedMethodNames.add("uvm_pkg::uvm_visitor_adapter.accept");
        documentedMethodNames.add("uvm_pkg::uvm_component.accept_tr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.accept_tr");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.add");
        documentedMethodNames.add("uvm_pkg::uvm_heartbeat.add");
        documentedMethodNames.add("uvm_pkg::uvm_phase.add");
        documentedMethodNames.add("uvm_pkg::uvm_pool.add");
        documentedMethodNames.add("uvm_pkg::uvm_reg_read_only_cbs.add");
        documentedMethodNames.add("uvm_pkg::uvm_reg_write_only_cbs.add");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.add_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_event.add_callback");
        documentedMethodNames.add("uvm_pkg::uvm_mem.add_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg.add_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.add_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_mem.add_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg.add_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.add_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.add_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_mem.add_hdl_path_slice");
        documentedMethodNames.add("uvm_pkg::uvm_reg.add_hdl_path_slice");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.add_int");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.add_int");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_container.add_int");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.add_mem");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.add_object");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.add_object");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_container.add_object");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_path_concat.add_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.add_reg");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.add_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.add_sequences");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_path_concat.add_slice");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.add_string");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.add_string");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_container.add_string");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.add_submap");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.add_typewide_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.add_typewide_sequences");
        documentedMethodNames.add("uvm_pkg::uvm_domain.add_uvm_phases");
        documentedMethodNames.add("uvm_pkg::uvm_printer.adjust_name");
        documentedMethodNames.add("uvm_pkg::uvm_component.all_dropped");
        documentedMethodNames.add("uvm_pkg::uvm_objection.all_dropped");
        documentedMethodNames.add("uvm_pkg::uvm_objection_callback.all_dropped");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.allocate");
        documentedMethodNames.add("uvm_pkg::uvm_component.apply_config_settings");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if.b_transport");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.backdoor");
        documentedMethodNames.add("uvm_pkg::uvm_mem.backdoor_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg.backdoor_read");
        documentedMethodNames.add("uvm_pkg::uvm_mem.backdoor_read_func");
        documentedMethodNames.add("uvm_pkg::uvm_reg.backdoor_read_func");
        documentedMethodNames.add("uvm_pkg::uvm_reg.backdoor_watch");
        documentedMethodNames.add("uvm_pkg::uvm_mem.backdoor_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg.backdoor_write");
        documentedMethodNames.add("uvm_pkg::uvm_component.begin_child_tr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.begin_child_tr");
        documentedMethodNames.add("uvm_pkg::uvm_component.begin_tr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.begin_tr");
        documentedMethodNames.add("uvm_pkg::uvm_visitor.begin_v");
        documentedMethodNames.add("uvm_pkg::uvm_mem_access_seq.body");
        documentedMethodNames.add("uvm_pkg::uvm_mem_single_walk_seq.body");
        documentedMethodNames.add("uvm_pkg::uvm_mem_walk_seq.body");
        documentedMethodNames.add("uvm_pkg::uvm_reg_access_seq.body");
        documentedMethodNames.add("uvm_pkg::uvm_reg_bit_bash_seq.body");
        documentedMethodNames.add("uvm_pkg::uvm_reg_mem_built_in_seq.body");
        documentedMethodNames.add("uvm_pkg::uvm_reg_mem_shared_access_seq.body");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.body");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.body");
        documentedMethodNames.add("uvm_pkg::uvm_mem.build_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg.build_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.build_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_component.build_phase");
        documentedMethodNames.add("uvm_pkg::uvm_mem.burst_read");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.burst_read");
        documentedMethodNames.add("uvm_pkg::uvm_mem.burst_write");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.burst_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_adapter.bus2reg");
        documentedMethodNames.add("uvm_pkg::uvm_reg_tlm_adapter.bus2reg");
        documentedMethodNames.add("uvm_pkg::uvm_callback.callback_mode");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.can_get");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.can_peek");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.can_put");
        documentedMethodNames.add("uvm_pkg::uvm_barrier.cancel");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.cancel");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.capacity");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.catch");
        documentedMethodNames.add("uvm_pkg::uvm_component.check_config_usage");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.check_data_width");
        documentedMethodNames.add("uvm_pkg::uvm_component.check_phase");
        documentedMethodNames.add("uvm_pkg::uvm_reg_predictor.check_phase");
        documentedMethodNames.add("uvm_pkg::uvm_objection.clear");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.clear_extension");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.clear_extensions");
        documentedMethodNames.add("uvm_pkg::uvm_mem.clear_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg.clear_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.clear_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.clear_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.clear_response_queue");
        documentedMethodNames.add("uvm_pkg::uvm_object.clone");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.close");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.close");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.close_db");
        documentedMethodNames.add("uvm_pkg::uvm_object.compare");
        documentedMethodNames.add("uvm_pkg::uvm_comparer.compare_field");
        documentedMethodNames.add("uvm_pkg::uvm_comparer.compare_field_int");
        documentedMethodNames.add("uvm_pkg::uvm_comparer.compare_field_real");
        documentedMethodNames.add("uvm_pkg::uvm_comparer.compare_object");
        documentedMethodNames.add("uvm_pkg::uvm_comparer.compare_string");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.compose_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.compose_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_mem.configure");
        documentedMethodNames.add("uvm_pkg::uvm_reg.configure");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.configure");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.configure");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.configure");
        documentedMethodNames.add("uvm_pkg::uvm_reg_indirect_data.configure");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.configure");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.configure");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.configure");
        documentedMethodNames.add("uvm_pkg::uvm_component.configure_phase");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.connect");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_nb_passthrough_target_socket.connect");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_nb_target_socket.connect");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_b_initiator_socket.Connect");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_b_target_socket.Connect");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_nb_initiator_socket.Connect");
        documentedMethodNames.add("uvm_pkg::uvm_component.connect_phase");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.convert2string");
        documentedMethodNames.add("uvm_pkg::uvm_object.convert2string");
        documentedMethodNames.add("uvm_pkg::uvm_reg_item.convert2string");
        documentedMethodNames.add("uvm_pkg::uvm_object.copy");
        documentedMethodNames.add("uvm_pkg::uvm_component_registry.create");
        documentedMethodNames.add("uvm_pkg::uvm_object.create");
        documentedMethodNames.add("uvm_pkg::uvm_object_registry.create");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_extension_base.create");
        documentedMethodNames.add("uvm_pkg::uvm_component.create_component");
        documentedMethodNames.add("uvm_pkg::uvm_component_registry.create_component");
        documentedMethodNames.add("uvm_pkg::uvm_object_wrapper.create_component");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.create_component_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_factory.create_component_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.create_component_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_factory.create_component_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.create_item");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.create_map");
        documentedMethodNames.add("uvm_pkg::uvm_component.create_object");
        documentedMethodNames.add("uvm_pkg::uvm_object_registry.create_object");
        documentedMethodNames.add("uvm_pkg::uvm_object_wrapper.create_object");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.create_object_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_factory.create_object_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.create_object_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_factory.create_object_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.current_grabber");
        documentedMethodNames.add("uvm_pkg::debug_connected_to.current_grabber");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.current_grabber");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.debug_create_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_factory.debug_create_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.debug_create_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_factory.debug_create_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.debug_provided_to");
        documentedMethodNames.add("uvm_pkg::uvm_reg_cbs.decode");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.decr");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.define_access");
        documentedMethodNames.add("uvm_pkg::uvm_component.define_domain");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.delete");
        documentedMethodNames.add("uvm_pkg::uvm_object_string_pool.delete");
        documentedMethodNames.add("uvm_pkg::uvm_pool.delete");
        documentedMethodNames.add("uvm_pkg::uvm_queue.delete");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_container.delete");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.delete_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_event.delete_callback");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_container.delete_elements");
        documentedMethodNames.add("uvm_pkg::uvm_root.die");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.disable_auto_item_recording");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.disable_recording");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.display");
        documentedMethodNames.add("uvm_pkg::uvm_objection.display_objections");
        documentedMethodNames.add("uvm_pkg::uvm_component.do_accept_tr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.do_accept_tr");
        documentedMethodNames.add("uvm_pkg::uvm_component.do_begin_tr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.do_begin_tr");
        documentedMethodNames.add("uvm_pkg::uvm_mem_access_seq.do_block");
        documentedMethodNames.add("uvm_pkg::uvm_mem_walk_seq.do_block");
        documentedMethodNames.add("uvm_pkg::uvm_reg_access_seq.do_block");
        documentedMethodNames.add("uvm_pkg::uvm_reg_bit_bash_seq.do_block");
        documentedMethodNames.add("uvm_pkg::uvm_reg_hw_reset_seq.do_block");
        documentedMethodNames.add("uvm_pkg::uvm_reg_mem_shared_access_seq.do_block");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.do_bus_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.do_bus_write");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_close");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_close");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_stream.do_close");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.do_close");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_database.do_close_db");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.do_close_db");
        documentedMethodNames.add("uvm_pkg::uvm_object.do_compare");
        documentedMethodNames.add("uvm_pkg::uvm_object.do_copy");
        documentedMethodNames.add("uvm_pkg::uvm_reg_item.do_copy");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.do_copy");
        documentedMethodNames.add("uvm_pkg::uvm_component.do_end_tr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.do_end_tr");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_database.do_establish_link");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.do_establish_link");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_free");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_free");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_stream.do_free");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.do_free");
        documentedMethodNames.add("uvm_pkg::uvm_cause_effect_link.do_get_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.do_get_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_parent_child_link.do_get_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_related_link.do_get_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_cause_effect_link.do_get_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.do_get_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_parent_child_link.do_get_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_related_link.do_get_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.do_kill");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_open");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_open");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_stream.do_open");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.do_open");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_database.do_open_db");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.do_open_db");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_stream.do_open_recorder");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.do_open_recorder");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_database.do_open_stream");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.do_open_stream");
        documentedMethodNames.add("uvm_pkg::uvm_object.do_pack");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.do_post_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.do_post_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.do_pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.do_pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.do_predict");
        documentedMethodNames.add("uvm_pkg::uvm_object.do_print");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.do_print");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.do_read");
        documentedMethodNames.add("uvm_pkg::uvm_object.do_record");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_record_field");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_record_field");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_record_field_int");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_record_field_int");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_record_field_real");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_record_field_real");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_record_generic");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_record_generic");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_record_object");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_record_object");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_record_string");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_record_string");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.do_record_time");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.do_record_time");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.do_reg_item");
        documentedMethodNames.add("uvm_pkg::uvm_cause_effect_link.do_set_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.do_set_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_parent_child_link.do_set_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_related_link.do_set_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_cause_effect_link.do_set_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.do_set_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_parent_child_link.do_set_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_related_link.do_set_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_object.do_unpack");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.do_write");
        documentedMethodNames.add("uvm_pkg::uvm_objection.drop_objection");
        documentedMethodNames.add("uvm_pkg::uvm_phase.drop_objection");
        documentedMethodNames.add("uvm_pkg::uvm_component.dropped");
        documentedMethodNames.add("uvm_pkg::uvm_objection.dropped");
        documentedMethodNames.add("uvm_pkg::uvm_objection_callback.dropped");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.dump");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.dump");
        documentedMethodNames.add("uvm_pkg::uvm_printer.emit");
        documentedMethodNames.add("uvm_pkg::uvm_table_printer.emit");
        documentedMethodNames.add("uvm_pkg::uvm_tree_printer.emit");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.enable_recording");
        documentedMethodNames.add("uvm_pkg::uvm_reg_cbs.encode");
        documentedMethodNames.add("uvm_pkg::uvm_component.end_of_elaboration_phase");
        documentedMethodNames.add("uvm_pkg::uvm_phase.end_prematurely");
        documentedMethodNames.add("uvm_pkg::uvm_component.end_tr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.end_tr");
        documentedMethodNames.add("uvm_pkg::uvm_visitor.end_v");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.establish_link");
        documentedMethodNames.add("uvm_pkg::uvm_phase.exec_func");
        documentedMethodNames.add("uvm_pkg::uvm_phase.exec_task");
        documentedMethodNames.add("uvm_pkg::uvm_bottomup_phase.execute");
        documentedMethodNames.add("uvm_pkg::uvm_task_phase.execute");
        documentedMethodNames.add("uvm_pkg::uvm_topdown_phase.execute");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.execute_item");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.execute_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.execute_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_config_db.exists");
        documentedMethodNames.add("uvm_pkg::uvm_pool.exists");
        documentedMethodNames.add("uvm_pkg::uvm_component.extract_phase");
        documentedMethodNames.add("uvm_pkg::uvm_component.final_phase");
        documentedMethodNames.add("uvm_pkg::uvm_phase.find");
        documentedMethodNames.add("uvm_pkg::uvm_root.find");
        documentedMethodNames.add("uvm_pkg::uvm_root.find_all");
        documentedMethodNames.add("uvm_pkg::uvm_utils.find_all");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.find_block");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.find_blocks");
        documentedMethodNames.add("uvm_pkg::uvm_phase.find_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.find_override_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_factory.find_override_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.find_override_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_factory.find_override_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.find_unused_resources");
        documentedMethodNames.add("uvm_pkg::uvm_factory.find_wrapper_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.finish_item");
        documentedMethodNames.add("uvm_pkg::uvm_callback_iter.first");
        documentedMethodNames.add("uvm_pkg::uvm_pool.first");
        documentedMethodNames.add("uvm_pkg::uvm_in_order_comparator.flush");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_fifo.flush");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.for_each");
        documentedMethodNames.add("uvm_pkg::uvm_report_handler.format_action");
        documentedMethodNames.add("uvm_pkg::uvm_printer.format_footer");
        documentedMethodNames.add("uvm_pkg::uvm_printer.format_header");
        documentedMethodNames.add("uvm_pkg::uvm_printer.format_row");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.free");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.free");
        documentedMethodNames.add("uvm_pkg::uvm_component.free_tr_stream");
        documentedMethodNames.add("uvm_pkg::uvm_enum_wrapper.from_name");
        documentedMethodNames.add("uvm_pkg::generate_stimulus.from_name");
        documentedMethodNames.add("uvm_pkg::uvm_random_stimulus.from_name");
        documentedMethodNames.add("uvm_pkg::uvm_build_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_check_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_component_registry.get");
        documentedMethodNames.add("uvm_pkg::uvm_config_db.get");
        documentedMethodNames.add("uvm_pkg::uvm_configure_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_connect_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.get");
        documentedMethodNames.add("uvm_pkg::uvm_end_of_elaboration_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_extract_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_factory.get");
        documentedMethodNames.add("uvm_pkg::uvm_final_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_get_to_lock_dap.get");
        documentedMethodNames.add("uvm_pkg::uvm_main_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_object_registry.get");
        documentedMethodNames.add("uvm_pkg::uvm_object_string_pool.get");
        documentedMethodNames.add("uvm_pkg::uvm_pool.get");
        documentedMethodNames.add("uvm_pkg::uvm_post_configure_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_post_main_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_post_reset_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_post_shutdown_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_pre_configure_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_pre_main_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_pre_reset_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_pre_shutdown_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_queue.get");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.get");
        documentedMethodNames.add("uvm_pkg::uvm_report_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_reset_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.get");
        documentedMethodNames.add("uvm_pkg::uvm_root.get");
        documentedMethodNames.add("uvm_pkg::uvm_run_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.get");
        documentedMethodNames.add("uvm_pkg::uvm_set_before_get_dap.get");
        documentedMethodNames.add("uvm_pkg::uvm_set_get_dap_base.get");
        documentedMethodNames.add("uvm_pkg::uvm_shutdown_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_simple_lock_dap.get");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.get");
        documentedMethodNames.add("uvm_pkg::uvm_start_of_simulation_phase.get");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.get");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.get_abstime");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.get_accept_time");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_access");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_access");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_access");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.get_access");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_action");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_action");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_base.get_action");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_adapter");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_addr_unit_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_address");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_address");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_address");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_address");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_addresses");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_addresses");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_adjacent_predecessor_nodes");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_adjacent_successor_nodes");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.get_arbitration");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_arg_matches");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_arg_value");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_arg_values");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_args");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_auto_predict");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.get_automatic_phase_objection");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_backdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_backdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_backdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_base_addr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.get_begin_time");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_block_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_blocks");
        documentedMethodNames.add("uvm_pkg::uvm_resource.get_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.get_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.get_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource.get_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.get_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.get_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_byte_enable");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_byte_enable_length");
        documentedMethodNames.add("uvm_pkg::uvm_callback_iter.get_cb");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_check_on_read");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_child");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_children");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_client");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.get_close_time");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_command");
        documentedMethodNames.add("uvm_pkg::uvm_domain.get_common_domain");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.get_comp");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_compare");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.get_component_visitor");
        documentedMethodNames.add("uvm_pkg::uvm_default_coreservice_t.get_component_visitor");
        documentedMethodNames.add("uvm_pkg::uvm_utils.get_config");
        documentedMethodNames.add("uvm_pkg::uvm_port_component_base.get_connected_to");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_context");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_context");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_sequence.get_current_item");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.get_current_item");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_data");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_data_length");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.get_db");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_default_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.get_default_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_default_path");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.get_default_tr_database");
        documentedMethodNames.add("uvm_pkg::uvm_default_coreservice_t.get_default_tr_database");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_depth");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.get_depth");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_domain");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_domain");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_domain_name");
        documentedMethodNames.add("uvm_pkg::uvm_domain.get_domains");
        documentedMethodNames.add("uvm_pkg::uvm_objection.get_drain_time");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_element_container");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_element_container");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_container.get_elements");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.get_end_offset");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.get_end_time");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.get_event_pool");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_extension");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.get_factory");
        documentedMethodNames.add("uvm_pkg::uvm_default_coreservice_t.get_factory");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_field_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_field_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_field_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_fields");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_fields");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_fields");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_fields");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_file");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_filename");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.get_first");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_first_child");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_fname");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_frontdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_frontdoor");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_full_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_full_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_full_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.get_full_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_object.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.get_full_name");
        documentedMethodNames.add("uvm_pkg::uvm_object_string_pool.get_global");
        documentedMethodNames.add("uvm_pkg::uvm_pool.get_global");
        documentedMethodNames.add("uvm_pkg::uvm_queue.get_global");
        documentedMethodNames.add("uvm_pkg::uvm_object_string_pool.get_global_pool");
        documentedMethodNames.add("uvm_pkg::uvm_pool.get_global_pool");
        documentedMethodNames.add("uvm_pkg::uvm_queue.get_global_queue");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.get_handle");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.get_handle");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.get_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_hdl_path_kinds");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_hdl_path_kinds");
        documentedMethodNames.add("uvm_pkg::uvm_resource.get_highest_precedence");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.get_highest_precedence");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_id");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_id");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.get_id_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.get_id_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.get_id_set");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.get_if");
        documentedMethodNames.add("uvm_pkg::uvm_structure_proxy.get_immediate_children");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_imp");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_incr");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.get_initiator");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_inst");
        documentedMethodNames.add("uvm_pkg::uvm_object.get_inst_count");
        documentedMethodNames.add("uvm_pkg::uvm_object.get_inst_id");
        documentedMethodNames.add("uvm_pkg::uvm_agent.get_is_active");
        documentedMethodNames.add("uvm_pkg::uvm_reg_adapter.get_item");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_jump_target");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.get_last");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.get_len");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.get_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_line");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_line");
        documentedMethodNames.add("uvm_pkg::uvm_cause_effect_link.get_link");
        documentedMethodNames.add("uvm_pkg::uvm_parent_child_link.get_link");
        documentedMethodNames.add("uvm_pkg::uvm_related_link.get_link");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_lsb_pos");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.get_lsb_pos_in_register");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_map_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_maps");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_maps");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_maps");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_maps");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.get_max_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.get_max_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_max_size");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_max_size");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_max_size");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_mem_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_mem_by_offset");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_memories");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_memories");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.get_memory");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.get_memory");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_memory");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_message");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_message");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.get_message_database");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.get_message_database");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_mirrored_value");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_mirrored_value");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_n_bits");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_n_bits");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_n_bits");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.get_n_bits");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_n_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.get_n_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_n_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_n_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_n_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_n_maps");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_n_maps");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_n_maps");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_n_memlocs");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_object.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_base.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.get_name");
        documentedMethodNames.add("uvm_pkg::uvm_component_name_check_visitor.get_name_constraint");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.get_next");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_next_child");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.get_next_item");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.get_next_item");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_num_children");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_num_extensions");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.get_num_last_reqs");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.get_num_last_rsps");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.get_num_reqs_sent");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.get_num_rsps_received");
        documentedMethodNames.add("uvm_pkg::uvm_barrier.get_num_waiters");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.get_num_waiters");
        documentedMethodNames.add("uvm_pkg::uvm_object.get_object_type");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_objection");
        documentedMethodNames.add("uvm_pkg::uvm_objection.get_objection_count");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_objection_count");
        documentedMethodNames.add("uvm_pkg::uvm_objection.get_objection_total");
        documentedMethodNames.add("uvm_pkg::uvm_objection.get_objectors");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_offset");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_offset");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_offset_in_memory");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.get_open_time");
        documentedMethodNames.add("uvm_pkg::uvm_packer.get_packed_size");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.get_parent");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_parent_map");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.get_parent_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_phase_type");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_physical_addresses");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_plusargs");
        documentedMethodNames.add("uvm_pkg::uvm_port_component.get_port");
        documentedMethodNames.add("uvm_pkg::uvm_callbacks.get_prev");
        documentedMethodNames.add("uvm_pkg::uvm_phase_state_change.get_prev_state");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.get_priority");
        documentedMethodNames.add("uvm_pkg::uvm_objection.get_propagate_mode");
        documentedMethodNames.add("uvm_pkg::uvm_port_component_base.get_provided_to");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.get_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.get_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_printer_knobs.get_radix_str");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.get_realtime");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.get_record_attribute_handle");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.get_recorder_from_handle");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.get_recorders");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_reg_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_reg_by_offset");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_regfile");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.get_regfile");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_region");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_registers");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_registers");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.get_report_action");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_report_catcher");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.get_report_file_handle");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_report_handler");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.get_report_handler");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.get_report_max_verbosity_level");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_report_object");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.get_report_server");
        documentedMethodNames.add("uvm_pkg::uvm_default_coreservice_t.get_report_server");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_report_server");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.get_report_verbosity_level");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_reset");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.get_reset");
        documentedMethodNames.add("uvm_pkg::uvm_sequence.get_response");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.get_response_queue_depth");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.get_response_queue_error_report_disabled");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_response_status");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_response_string");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.get_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_rights");
        documentedMethodNames.add("uvm_pkg::uvm_reg.get_rights");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_rights");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.get_root");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_root_blocks");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_root_map");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.get_root_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.get_root_sequence_name");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_run_count");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_schedule");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_schedule_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.get_scope");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.get_scope");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.get_sequence_id");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.get_sequence_path");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.get_sequence_state");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_sequencer");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.get_sequencer");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.get_sequences");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.get_server");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_severity");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_severity");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.get_severity_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.get_severity_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.get_severity_set");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_size");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.get_size");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.get_start_offset");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.get_starting_phase");
        documentedMethodNames.add("uvm_pkg::uvm_phase.get_state");
        documentedMethodNames.add("uvm_pkg::uvm_phase_state_change.get_state");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.get_stream");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.get_stream_from_handle");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.get_stream_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.get_streaming_width");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.get_streams");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_submap_offset");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_submaps");
        documentedMethodNames.add("uvm_pkg::uvm_barrier.get_threshold");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_tool_name");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_tool_version");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.get_tr_handle");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.get_tr_handle");
        documentedMethodNames.add("uvm_pkg::uvm_component.get_tr_stream");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.get_transaction_id");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_transaction_order_policy");
        documentedMethodNames.add("uvm_pkg::uvm_event.get_trigger_data");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.get_trigger_time");
        documentedMethodNames.add("uvm_pkg::uvm_object.get_type");
        documentedMethodNames.add("uvm_pkg::uvm_resource.get_type");
        documentedMethodNames.add("uvm_pkg::uvm_resource.get_type_handle");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.get_type_handle");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_extension_base.get_type_handle");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_extension_base.get_type_handle_name");
        documentedMethodNames.add("uvm_pkg::uvm_callback.get_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_component_registry.get_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_object.get_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_object_registry.get_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_object_string_pool.get_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_object_wrapper.get_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.get_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.get_type_name");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.get_use_response_handler");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.get_use_sequence_info");
        documentedMethodNames.add("uvm_pkg::uvm_domain.get_uvm_domain");
        documentedMethodNames.add("uvm_pkg::uvm_domain.get_uvm_schedule");
        documentedMethodNames.add("uvm_pkg::uvm_cmdline_processor.get_uvmargs");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_int_element.get_value");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_object_element.get_value");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_string_element.get_value");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.get_verbosity");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.get_verbosity");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_vfield_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_vfield_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_virtual_fields");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_virtual_fields");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_virtual_fields");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_virtual_registers");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.get_virtual_registers");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_virtual_registers");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.get_virtual_registers");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_vreg_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.get_vreg_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_mem.get_vreg_by_offset");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.grab");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.grab");
        documentedMethodNames.add("uvm_pkg::has_child.grab");
        documentedMethodNames.add("uvm_pkg::uvm_component.grab");
        documentedMethodNames.add("uvm_pkg::uvm_mem.has_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg.has_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.has_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.has_do_available");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.has_do_available");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.has_do_available");
        documentedMethodNames.add("uvm_pkg::uvm_mem.has_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg.has_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.has_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.has_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.has_lock");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.has_lock");
        documentedMethodNames.add("uvm_pkg::uvm_reg.has_reset");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.has_reset");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_extension.ID");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.implement");
        documentedMethodNames.add("uvm_pkg::uvm_reg.include_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.incr");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.incr_id_count");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.incr_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.incr_severity_count");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.init_access_record");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.init_sequence_library");
        documentedMethodNames.add("uvm_pkg::uvm_queue.insert");
        documentedMethodNames.add("uvm_pkg::uvm_phase.is");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.is_active");
        documentedMethodNames.add("uvm_pkg::uvm_phase.is_after");
        documentedMethodNames.add("uvm_pkg::uvm_resource_options.is_auditing");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.is_auto_item_recording_enabled");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.is_auto_updated");
        documentedMethodNames.add("uvm_pkg::uvm_phase.is_before");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.is_blocked");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.is_blocked");
        documentedMethodNames.add("uvm_pkg::uvm_reg.is_busy");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.is_child");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.is_closed");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.is_closed");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.is_dmi_allowed");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_fifo.is_empty");
        documentedMethodNames.add("uvm_pkg::uvm_callback.is_enabled");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.is_export");
        documentedMethodNames.add("uvm_pkg::uvm_port_component_base.is_export");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_fifo.is_full");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.is_grabbed");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.is_hdl_path_root");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.is_imp");
        documentedMethodNames.add("uvm_pkg::uvm_port_component_base.is_imp");
        documentedMethodNames.add("uvm_pkg::uvm_mem.is_in_map");
        documentedMethodNames.add("uvm_pkg::uvm_reg.is_in_map");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.is_in_map");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.is_indv_accessible");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.is_item");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.is_item");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.is_known_access");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.is_locked");
        documentedMethodNames.add("uvm_pkg::uvm_simple_lock_dap.is_locked");
        documentedMethodNames.add("uvm_pkg::uvm_packer.is_null");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.is_off");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.is_on");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.is_open");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.is_open");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.is_open");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.is_port");
        documentedMethodNames.add("uvm_pkg::uvm_port_component_base.is_port");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.is_quit_count_reached");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.is_read");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.is_read_only");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.is_recording_enabled");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.is_relevant");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.is_response_error");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.is_response_ok");
        documentedMethodNames.add("uvm_pkg::uvm_config_db_options.is_tracing");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db_options.is_tracing");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.is_unbounded");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.is_volatile");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.is_write");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.issue");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.item_done");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.item_done");
        documentedMethodNames.add("uvm_pkg::uvm_domain.jump");
        documentedMethodNames.add("uvm_pkg::uvm_phase.jump");
        documentedMethodNames.add("uvm_pkg::uvm_phase_state_change.jump_to");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.kill");
        documentedMethodNames.add("uvm_pkg::uvm_callback_iter.last");
        documentedMethodNames.add("uvm_pkg::uvm_pool.last");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.last_req");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.last_rsp");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.lock");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.lock");
        documentedMethodNames.add("uvm_pkg::uvm_simple_lock_dap.lock");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.lock_model");
        documentedMethodNames.add("uvm_pkg::uvm_component.lookup");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.lookup_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.lookup_regex");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.lookup_regex_names");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.lookup_scope");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.lookup_type");
        documentedMethodNames.add("uvm_pkg::uvm_component.main_phase");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.match_scope");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.max_size");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.mid_do");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.min_size");
        documentedMethodNames.add("uvm_pkg::uvm_reg.mirror");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.mirror");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.mirror");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.mirror");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.mirror_reg");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.nb_transport");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if.nb_transport_bw");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if.nb_transport_fw");
        documentedMethodNames.add("uvm_pkg::uvm_reg.needs_update");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.needs_update");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.needs_update");
        documentedMethodNames.add("uvm_pkg::uvm_agent.new");
        documentedMethodNames.add("uvm_pkg::uvm_algorithmic_comparator.new");
        documentedMethodNames.add("uvm_pkg::uvm_analysis_export.new");
        documentedMethodNames.add("uvm_pkg::uvm_barrier.new");
        documentedMethodNames.add("uvm_pkg::uvm_bottomup_phase.new");
        documentedMethodNames.add("uvm_pkg::uvm_built_in_pair.new");
        documentedMethodNames.add("uvm_pkg::uvm_callback.new");
        documentedMethodNames.add("uvm_pkg::uvm_callback_iter.new");
        documentedMethodNames.add("uvm_pkg::uvm_cause_effect_link.new");
        documentedMethodNames.add("uvm_pkg::uvm_class_pair.new");
        documentedMethodNames.add("uvm_pkg::uvm_component.new");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.new");
        documentedMethodNames.add("uvm_pkg::uvm_domain.new");
        documentedMethodNames.add("uvm_pkg::uvm_driver.new");
        documentedMethodNames.add("uvm_pkg::uvm_env.new");
        documentedMethodNames.add("uvm_pkg::uvm_event.new");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_event_callback.new");
        documentedMethodNames.add("uvm_pkg::uvm_get_to_lock_dap.new");
        documentedMethodNames.add("uvm_pkg::uvm_heartbeat.new");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_mem.new");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.new");
        documentedMethodNames.add("uvm_pkg::uvm_mem_single_walk_seq.new");
        documentedMethodNames.add("uvm_pkg::uvm_monitor.new");
        documentedMethodNames.add("uvm_pkg::uvm_object.new");
        documentedMethodNames.add("uvm_pkg::uvm_object_string_pool.new");
        documentedMethodNames.add("uvm_pkg::uvm_objection.new");
        documentedMethodNames.add("uvm_pkg::uvm_parent_child_link.new");
        documentedMethodNames.add("uvm_pkg::uvm_phase.new");
        documentedMethodNames.add("uvm_pkg::uvm_phase_cb.new");
        documentedMethodNames.add("uvm_pkg::uvm_pool.new");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_push_driver.new");
        documentedMethodNames.add("uvm_pkg::uvm_push_sequencer.new");
        documentedMethodNames.add("uvm_pkg::uvm_queue.new");
        documentedMethodNames.add("uvm_pkg::uvm_random_stimulus.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_adapter.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_frontdoor.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_indirect_data.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_item.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_predictor.new");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.new");
        documentedMethodNames.add("uvm_pkg::uvm_related_link.new");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.new");
        documentedMethodNames.add("uvm_pkg::uvm_report_handler.new");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.new");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_container.new");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.new");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_scoreboard.new");
        documentedMethodNames.add("uvm_pkg::uvm_seq_item_pull_imp.new");
        documentedMethodNames.add("uvm_pkg::uvm_sequence.new");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.new");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.new");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.new");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_set_before_get_dap.new");
        documentedMethodNames.add("uvm_pkg::uvm_set_get_dap_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_simple_lock_dap.new");
        documentedMethodNames.add("uvm_pkg::uvm_subscriber.new");
        documentedMethodNames.add("uvm_pkg::uvm_task_phase.new");
        documentedMethodNames.add("uvm_pkg::uvm_test.new");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.new");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_database.new");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_stream.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_analysis_fifo.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_b_initiator_socket.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_b_target_socket.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_extension.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_extension_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_fifo.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_fifo_base.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_nb_initiator_socket.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_nb_target_socket.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_nb_transport_bw_export.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_nb_transport_bw_port.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_req_rsp_channel.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.new");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_transport_channel.new");
        documentedMethodNames.add("uvm_pkg::uvm_topdown_phase.new");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.new");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.new");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.new");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.new");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.new");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.new_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_callback_iter.next");
        documentedMethodNames.add("uvm_pkg::uvm_pool.next");
        documentedMethodNames.add("uvm_pkg::uvm_pool.num");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.open_db");
        documentedMethodNames.add("uvm_pkg::uvm_tr_stream.open_recorder");
        documentedMethodNames.add("uvm_pkg::uvm_tr_database.open_stream");
        documentedMethodNames.add("uvm_pkg::uvm_reg_transaction_order_policy.order");
        documentedMethodNames.add("uvm_pkg::pack.order");
        documentedMethodNames.add("uvm_pkg::uvm_object.order");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_bits");
        documentedMethodNames.add("uvm_pkg::uvm_object.pack_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_field");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_field_int");
        documentedMethodNames.add("uvm_pkg::uvm_object.pack_ints");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_ints");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_object");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_real");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_string");
        documentedMethodNames.add("uvm_pkg::uvm_packer.pack_time");
        documentedMethodNames.add("uvm_pkg::uvm_mem.peek");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.peek");
        documentedMethodNames.add("uvm_pkg::uvm_reg.peek");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.peek");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.peek");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.peek");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.peek");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.peek");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.peek");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.peek_mem");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.peek_reg");
        documentedMethodNames.add("uvm_pkg::uvm_component.phase_ended");
        documentedMethodNames.add("uvm_pkg::uvm_component.phase_ready_to_end");
        documentedMethodNames.add("uvm_pkg::uvm_component.phase_started");
        documentedMethodNames.add("uvm_pkg::uvm_phase_cb.phase_state_change");
        documentedMethodNames.add("uvm_pkg::uvm_mem.poke");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.poke");
        documentedMethodNames.add("uvm_pkg::uvm_reg.poke");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.poke");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.poke");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.poke");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.poke_mem");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.poke_reg");
        documentedMethodNames.add("uvm_pkg::uvm_queue.pop_back");
        documentedMethodNames.add("uvm_pkg::uvm_queue.pop_front");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.post_body");
        documentedMethodNames.add("uvm_pkg::uvm_component.post_configure_phase");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.post_do");
        documentedMethodNames.add("uvm_pkg::uvm_component.post_main_phase");
        documentedMethodNames.add("uvm_pkg::uvm_reg_cbs.post_predict");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.post_randomize");
        documentedMethodNames.add("uvm_pkg::uvm_mem.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_cbs.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_cbs.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field_cbs.post_read");
        documentedMethodNames.add("uvm_pkg::uvm_component.post_reset_phase");
        documentedMethodNames.add("uvm_pkg::uvm_component.post_shutdown_phase");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.post_start");
        documentedMethodNames.add("uvm_pkg::uvm_event_callback.post_trigger");
        documentedMethodNames.add("uvm_pkg::uvm_mem.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_cbs.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_cbs.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field_cbs.post_write");
        documentedMethodNames.add("uvm_pkg::uvm_component.pre_abort");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.pre_body");
        documentedMethodNames.add("uvm_pkg::uvm_component.pre_configure_phase");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.pre_do");
        documentedMethodNames.add("uvm_pkg::uvm_component.pre_main_phase");
        documentedMethodNames.add("uvm_pkg::uvm_reg_predictor.pre_predict");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.pre_randomize");
        documentedMethodNames.add("uvm_pkg::uvm_mem.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_cbs.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_write_only_cbs.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_cbs.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field_cbs.pre_read");
        documentedMethodNames.add("uvm_pkg::uvm_component.pre_reset_phase");
        documentedMethodNames.add("uvm_pkg::uvm_component.pre_shutdown_phase");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.pre_start");
        documentedMethodNames.add("uvm_pkg::uvm_event_callback.pre_trigger");
        documentedMethodNames.add("uvm_pkg::uvm_mem.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_cbs.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_read_only_cbs.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_cbs.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field_cbs.pre_write");
        documentedMethodNames.add("uvm_pkg::uvm_reg.predict");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.predict");
        documentedMethodNames.add("uvm_pkg::uvm_callback_iter.prev");
        documentedMethodNames.add("uvm_pkg::uvm_pool.prev");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.print");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.print");
        documentedMethodNames.add("uvm_pkg::uvm_factory.print");
        documentedMethodNames.add("uvm_pkg::uvm_object.print");
        documentedMethodNames.add("uvm_pkg::uvm_report_handler.print");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.print");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.print_accessors");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_array_footer");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_array_header");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_array_range");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.print_catcher");
        documentedMethodNames.add("uvm_pkg::uvm_component.print_config");
        documentedMethodNames.add("uvm_pkg::uvm_component.print_config_settings");
        documentedMethodNames.add("uvm_pkg::uvm_component.print_config_with_audit");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_field");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_field_int");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_generic");
        documentedMethodNames.add("uvm_pkg::uvm_comparer.print_msg");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_object");
        documentedMethodNames.add("uvm_pkg::uvm_component.print_override_info");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_real");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.print_resources");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_string");
        documentedMethodNames.add("uvm_pkg::uvm_printer.print_time");
        documentedMethodNames.add("uvm_pkg::uvm_root.print_topology");
        documentedMethodNames.add("uvm_pkg::uvm_report_handler.process_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_queue.push_back");
        documentedMethodNames.add("uvm_pkg::uvm_queue.push_front");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.put");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.put");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.put");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.put_response");
        documentedMethodNames.add("uvm_pkg::uvm_objection.raise_objection");
        documentedMethodNames.add("uvm_pkg::uvm_phase.raise_objection");
        documentedMethodNames.add("uvm_pkg::uvm_component.raised");
        documentedMethodNames.add("uvm_pkg::uvm_objection.raised");
        documentedMethodNames.add("uvm_pkg::uvm_objection_callback.raised");
        documentedMethodNames.add("uvm_pkg::uvm_mem.read");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.read");
        documentedMethodNames.add("uvm_pkg::uvm_reg.read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.read");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.read");
        documentedMethodNames.add("uvm_pkg::uvm_resource.read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.read");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.read");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.read_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.read_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.read_func");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.read_mem");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.read_mem_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.read_reg");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.read_reg_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.reconfigure");
        documentedMethodNames.add("uvm_pkg::uvm_object.record");
        documentedMethodNames.add("uvm_pkg::uvm_component.record_error_tr");
        documentedMethodNames.add("uvm_pkg::uvm_component.record_event_tr");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.record_field");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.record_field_int");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.record_field_real");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.record_generic");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.record_object");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.record_read_access");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.record_string");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.record_time");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.record_write_access");
        documentedMethodNames.add("uvm_pkg::uvm_reg_adapter.reg2bus");
        documentedMethodNames.add("uvm_pkg::uvm_reg_tlm_adapter.reg2bus");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.register");
        documentedMethodNames.add("uvm_pkg::uvm_factory.register");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.release_all_regions");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.release_region");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.release_region");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.release_region");
        documentedMethodNames.add("uvm_pkg::uvm_heartbeat.remove");
        documentedMethodNames.add("uvm_pkg::uvm_reg_read_only_cbs.remove");
        documentedMethodNames.add("uvm_pkg::uvm_reg_write_only_cbs.remove");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.remove_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_component.report_phase");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.report_summarize");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.report_summarize");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.request_region");
        documentedMethodNames.add("uvm_pkg::uvm_object.reseed");
        documentedMethodNames.add("uvm_pkg::uvm_mem_mam.reserve_region");
        documentedMethodNames.add("uvm_pkg::uvm_barrier.reset");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.reset");
        documentedMethodNames.add("uvm_pkg::uvm_reg.reset");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.reset");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.reset");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.reset");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.reset");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.reset");
        documentedMethodNames.add("uvm_pkg::uvm_mem_access_seq.reset_blk");
        documentedMethodNames.add("uvm_pkg::uvm_mem_walk_seq.reset_blk");
        documentedMethodNames.add("uvm_pkg::uvm_reg_access_seq.reset_blk");
        documentedMethodNames.add("uvm_pkg::uvm_reg_bit_bash_seq.reset_blk");
        documentedMethodNames.add("uvm_pkg::uvm_reg_hw_reset_seq.reset_blk");
        documentedMethodNames.add("uvm_pkg::uvm_reg_mem_shared_access_seq.reset_blk");
        documentedMethodNames.add("uvm_pkg::uvm_component.reset_phase");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.reset_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.reset_report_handler");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.reset_severity_counts");
        documentedMethodNames.add("uvm_pkg::uvm_component.resolve_bindings");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.resolve_bindings");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.response_handler");
        documentedMethodNames.add("uvm_pkg::uvm_component.resume");
        documentedMethodNames.add("uvm_pkg::uvm_component.run_phase");
        documentedMethodNames.add("uvm_pkg::uvm_push_sequencer.run_phase");
        documentedMethodNames.add("uvm_pkg::run_test");
        documentedMethodNames.add("uvm_pkg::uvm_root.run_test");
        documentedMethodNames.add("uvm_pkg::sample.run_test");
        documentedMethodNames.add("uvm_pkg::uvm_mem.run_test");
        documentedMethodNames.add("uvm_pkg::uvm_reg.run_test");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.run_test");
        documentedMethodNames.add("uvm_pkg::uvm_reg.sample_values");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.sample_values");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_library.select_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_sequence.send_request");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.send_request");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.send_request");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.send_request");
        documentedMethodNames.add("uvm_pkg::uvm_config_db.set");
        documentedMethodNames.add("uvm_pkg::uvm_get_to_lock_dap.set");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_path_concat.set");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.set");
        documentedMethodNames.add("uvm_pkg::uvm_reg.set");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.set");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.set");
        documentedMethodNames.add("uvm_pkg::uvm_resource.set");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.set");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.set");
        documentedMethodNames.add("uvm_pkg::uvm_set_before_get_dap.set");
        documentedMethodNames.add("uvm_pkg::uvm_set_get_dap_base.set");
        documentedMethodNames.add("uvm_pkg::uvm_simple_lock_dap.set");
        documentedMethodNames.add("uvm_pkg::uvm_resource.set priority");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.set priority");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.set_abstime");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.set_access");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.set_action");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_action");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_base.set_action");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_address");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.set_anonymous");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.set_arbitration");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.set_auto_predict");
        documentedMethodNames.add("uvm_pkg::uvm_barrier.set_auto_reset");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.set_automatic_phase_objection");
        documentedMethodNames.add("uvm_pkg::uvm_mem.set_backdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg.set_backdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.set_backdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.set_base_addr");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_byte_enable");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_byte_enable_length");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.set_check_on_read");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_command");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.set_compare");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.set_compare");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.set_component_visitor");
        documentedMethodNames.add("uvm_pkg::uvm_default_coreservice_t.set_component_visitor");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.set_context");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_context");
        documentedMethodNames.add("uvm_pkg::uvm_mem.set_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg.set_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.set_coverage");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_data");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_data_length");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.set_default");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.set_default_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_reg_file.set_default_hdl_path");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.set_default_index");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.set_default_map");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.set_default_tr_database");
        documentedMethodNames.add("uvm_pkg::uvm_default_coreservice_t.set_default_tr_database");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.set_depth");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_dmi_allowed");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_domain");
        documentedMethodNames.add("uvm_pkg::uvm_objection.set_drain_time");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_extension");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.set_factory");
        documentedMethodNames.add("uvm_pkg::uvm_default_coreservice_t.set_factory");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_file");
        documentedMethodNames.add("uvm_pkg::uvm_text_tr_database.set_file_name");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_filename");
        documentedMethodNames.add("uvm_pkg::uvm_mem.set_frontdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg.set_frontdoor");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.set_hdl_path_root");
        documentedMethodNames.add("uvm_pkg::uvm_heartbeat.set_heartbeat");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.set_id");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_id");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.set_id_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.set_id_count");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.set_id_info");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.set_initiator");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_inst_override");
        documentedMethodNames.add("uvm_pkg::uvm_component_registry.set_inst_override");
        documentedMethodNames.add("uvm_pkg::uvm_object_registry.set_inst_override");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.set_inst_override_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_factory.set_inst_override_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_inst_override_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.set_inst_override_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_factory.set_inst_override_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_object.set_int_local");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.set_item_context");
        documentedMethodNames.add("uvm_pkg::uvm_phase.set_jump_phase");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.set_lhs");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_line");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.set_max_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.set_max_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.set_max_zero_time_wait_relevant_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.set_message");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_message");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.set_message_database");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.set_message_database");
        documentedMethodNames.add("uvm_pkg::uvm_heartbeat.set_mode");
        documentedMethodNames.add("uvm_pkg::uvm_object.set_name");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_base.set_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.set_name_override");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.set_num_last_reqs");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_param_base.set_num_last_rsps");
        documentedMethodNames.add("uvm_pkg::uvm_object.set_object_local");
        documentedMethodNames.add("uvm_pkg::uvm_mem.set_offset");
        documentedMethodNames.add("uvm_pkg::uvm_reg.set_offset");
        documentedMethodNames.add("uvm_pkg::uvm_resource.set_override");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.set_override");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.set_parent_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_phase_imp");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.set_priority");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.set_priority");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.set_priority_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.set_priority_type");
        documentedMethodNames.add("uvm_pkg::uvm_objection.set_propagate_mode");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.set_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.set_quit_count");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_read");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.set_read_only");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_default_file");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_default_file_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_report_handler");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_handler");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_id_action");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_id_action_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_id_file");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_id_file_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_id_verbosity");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_id_verbosity_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_report_object");
        documentedMethodNames.add("uvm_pkg::uvm_coreservice_t.set_report_server");
        documentedMethodNames.add("uvm_pkg::uvm_default_coreservice_t.set_report_server");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_report_server");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_severity_action");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_severity_action_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_severity_file");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_severity_file_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_severity_id_action");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_severity_id_action_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_severity_id_file");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_severity_id_file_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_severity_id_override");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_severity_id_verbosity");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_severity_id_verbosity_hier");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_severity_override");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.set_report_verbosity_level");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_report_verbosity_level_hier");
        documentedMethodNames.add("uvm_pkg::uvm_reg.set_reset");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.set_reset");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.set_response_queue_depth");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.set_response_queue_error_report_disabled");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_response_status");
        documentedMethodNames.add("uvm_pkg::uvm_link_base.set_rhs");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.set_scope");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.set_sequencer");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.set_sequencer");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.set_server");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.set_severity");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_severity");
        documentedMethodNames.add("uvm_pkg::uvm_default_report_server.set_severity_count");
        documentedMethodNames.add("uvm_pkg::uvm_report_server.set_severity_count");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.set_starting_phase");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_streaming_width");
        documentedMethodNames.add("uvm_pkg::uvm_object.set_string_local");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.set_submap_offset");
        documentedMethodNames.add("uvm_pkg::uvm_barrier.set_threshold");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_time.set_time_resolution");
        documentedMethodNames.add("uvm_pkg::uvm_root.set_timeout");
        documentedMethodNames.add("uvm_pkg::uvm_transaction.set_transaction_id");
        documentedMethodNames.add("uvm_pkg::uvm_reg_map.set_transaction_order_policy");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_type_override");
        documentedMethodNames.add("uvm_pkg::uvm_component_registry.set_type_override");
        documentedMethodNames.add("uvm_pkg::uvm_object_registry.set_type_override");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.set_type_override");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.set_type_override_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_factory.set_type_override_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_component.set_type_override_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_default_factory.set_type_override_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_factory.set_type_override_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.set_use_sequence_info");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_int_element.set_value");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_object_element.set_value");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_string_element.set_value");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.set_verbosity");
        documentedMethodNames.add("uvm_pkg::uvm_report_message.set_verbosity");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.set_volatility");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_generic_payload.set_write");
        documentedMethodNames.add("uvm_pkg::uvm_component.shutdown_phase");
        documentedMethodNames.add("uvm_pkg::uvm_port_base.size");
        documentedMethodNames.add("uvm_pkg::uvm_queue.size");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.size");
        documentedMethodNames.add("uvm_pkg::uvm_report_message_element_container.size");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_fifo.size");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.sort_by_precedence");
        documentedMethodNames.add("uvm_pkg::uvm_resource_pool.spell_check");
        documentedMethodNames.add("uvm_pkg::uvm_object.sprint");
        documentedMethodNames.add("uvm_pkg::uvm_heartbeat.start");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.start");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.start_item");
        documentedMethodNames.add("uvm_pkg::uvm_component.start_of_simulation_phase");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.start_phase_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_heartbeat.stop");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.stop_phase_sequence");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.stop_sequences");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.stop_sequences");
        documentedMethodNames.add("uvm_pkg::uvm_random_stimulus.stop_stimulus_generation");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.summarize");
        documentedMethodNames.add("uvm_pkg::uvm_component.suspend");
        documentedMethodNames.add("uvm_pkg::uvm_phase.sync");
        documentedMethodNames.add("uvm_pkg::uvm_objection.trace_mode");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.transport");
        documentedMethodNames.add("uvm_pkg::uvm_bottomup_phase.traverse");
        documentedMethodNames.add("uvm_pkg::uvm_task_phase.traverse");
        documentedMethodNames.add("uvm_pkg::uvm_topdown_phase.traverse");
        documentedMethodNames.add("uvm_pkg::uvm_event.trigger");
        documentedMethodNames.add("uvm_pkg::uvm_get_to_lock_dap.try_get");
        documentedMethodNames.add("uvm_pkg::uvm_set_before_get_dap.try_get");
        documentedMethodNames.add("uvm_pkg::uvm_set_get_dap_base.try_get");
        documentedMethodNames.add("uvm_pkg::uvm_simple_lock_dap.try_get");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.try_get");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.try_next_item");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.try_next_item");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.try_peek");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.try_put");
        documentedMethodNames.add("uvm_pkg::uvm_get_to_lock_dap.try_set");
        documentedMethodNames.add("uvm_pkg::uvm_set_before_get_dap.try_set");
        documentedMethodNames.add("uvm_pkg::uvm_set_get_dap_base.try_set");
        documentedMethodNames.add("uvm_pkg::uvm_simple_lock_dap.try_set");
        documentedMethodNames.add("uvm_pkg::uvm_resource_options.turn_off_auditing");
        documentedMethodNames.add("uvm_pkg::uvm_config_db_options.turn_off_tracing");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db_options.turn_off_tracing");
        documentedMethodNames.add("uvm_pkg::uvm_resource_options.turn_on_auditing");
        documentedMethodNames.add("uvm_pkg::uvm_config_db_options.turn_on_tracing");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db_options.turn_on_tracing");
        documentedMethodNames.add("uvm_pkg::ungrab.turn_on_tracing");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.turn_on_tracing");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.turn_on_tracing");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.ungrab");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.unlock");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.unlock");
        documentedMethodNames.add("uvm_pkg::uvm_simple_lock_dap.unlock");
        documentedMethodNames.add("uvm_pkg::uvm_object.unpack");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_bits");
        documentedMethodNames.add("uvm_pkg::uvm_object.unpack_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_bytes");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_field");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_field_int");
        documentedMethodNames.add("uvm_pkg::uvm_object.unpack_ints");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_ints");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_object");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_real");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_string");
        documentedMethodNames.add("uvm_pkg::uvm_packer.unpack_time");
        documentedMethodNames.add("uvm_pkg::uvm_phase.unsync");
        documentedMethodNames.add("uvm_pkg::uvm_reg.update");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.update");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.update");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.update_reg");
        documentedMethodNames.add("uvm_pkg::uvm_recorder.use_record_attribute");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.use_response_handler");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_fifo.used");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.user_priority_arbitration");
        documentedMethodNames.add("uvm_pkg::uvm_bits_to_string");
        documentedMethodNames.add("uvm_pkg::uvm_get_report_object");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.uvm_get_report_object");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_check_path");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_deposit");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_force");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_force_time");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_read");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_release");
        documentedMethodNames.add("uvm_pkg::uvm_hdl_release_and_read");
        documentedMethodNames.add("uvm_pkg::uvm_is_match");
        documentedMethodNames.add("uvm_pkg::uvm_process_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.uvm_process_report_message");
        documentedMethodNames.add("uvm_pkg::uvm_report");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.uvm_report");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.uvm_report");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.uvm_report");
        documentedMethodNames.add("uvm_pkg::uvm_report_enabled");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.uvm_report_enabled");
        documentedMethodNames.add("uvm_pkg::uvm_report_error");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.uvm_report_error");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.uvm_report_error");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.uvm_report_error");
        documentedMethodNames.add("uvm_pkg::uvm_report_fatal");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.uvm_report_fatal");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.uvm_report_fatal");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.uvm_report_fatal");
        documentedMethodNames.add("uvm_pkg::uvm_report_info");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.uvm_report_info");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.uvm_report_info");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.uvm_report_info");
        documentedMethodNames.add("uvm_pkg::uvm_report_warning");
        documentedMethodNames.add("uvm_pkg::uvm_report_catcher.uvm_report_warning");
        documentedMethodNames.add("uvm_pkg::uvm_report_object.uvm_report_warning");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_item.uvm_report_warning");
        documentedMethodNames.add("uvm_pkg::uvm_split_string");
        documentedMethodNames.add("uvm_pkg::uvm_string_to_bits");
        documentedMethodNames.add("uvm_pkg::uvm_wait_for_nba_region");
        documentedMethodNames.add("uvm_pkg::uvm_visitor.visit");
        documentedMethodNames.add("uvm_pkg::uvm_barrier.wait_for");
        documentedMethodNames.add("uvm_pkg::uvm_objection.wait_for");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.wait_for_change");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.wait_for_grant");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.wait_for_grant");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.wait_for_item_done");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.wait_for_item_done");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.wait_for_relevant");
        documentedMethodNames.add("uvm_pkg::uvm_sequence_base.wait_for_sequence_state");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer.wait_for_sequences");
        documentedMethodNames.add("uvm_pkg::uvm_sequencer_base.wait_for_sequences");
        documentedMethodNames.add("uvm_pkg::uvm_sqr_if_base.wait_for_sequences");
        documentedMethodNames.add("uvm_pkg::uvm_phase.wait_for_state");
        documentedMethodNames.add("uvm_pkg::uvm_config_db.wait_modified");
        documentedMethodNames.add("uvm_pkg::uvm_resource_base.wait_modified");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.wait_off");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.wait_on");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.wait_ptrigger");
        documentedMethodNames.add("uvm_pkg::uvm_event.wait_ptrigger_data");
        documentedMethodNames.add("uvm_pkg::uvm_event_base.wait_trigger");
        documentedMethodNames.add("uvm_pkg::uvm_event.wait_trigger_data");
        documentedMethodNames.add("uvm_pkg::uvm_analysis_port.write");
        documentedMethodNames.add("uvm_pkg::uvm_mem.write");
        documentedMethodNames.add("uvm_pkg::uvm_mem_region.write");
        documentedMethodNames.add("uvm_pkg::uvm_reg.write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_backdoor.write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_field.write");
        documentedMethodNames.add("uvm_pkg::uvm_reg_fifo.write");
        documentedMethodNames.add("uvm_pkg::uvm_resource.write");
        documentedMethodNames.add("uvm_pkg::uvm_subscriber.write");
        documentedMethodNames.add("uvm_pkg::uvm_tlm_if_base.write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg.write");
        documentedMethodNames.add("uvm_pkg::uvm_vreg_field.write");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.write_attribute");
        documentedMethodNames.add("uvm_pkg::uvm_text_recorder.write_attribute_int");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.write_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_resource_db.write_by_type");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.write_mem");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.write_mem_by_name");
        documentedMethodNames.add("uvm_pkg::uvm_reg_sequence.write_reg");
        documentedMethodNames.add("uvm_pkg::uvm_reg_block.write_reg_by_name");
    }

    private static void addPorts() {
        documentedPorts = new HashSet<String>();
        documentedPorts.add("uvm_pkg::uvm_algorithmic_comparator.after_export");
        documentedPorts.add("uvm_pkg::uvm_in_order_comparator.after_export");
        documentedPorts.add("uvm_pkg::uvm_subscriber.analysis_export");
        documentedPorts.add("uvm_pkg::uvm_tlm_analysis_fifo.analysis_export");
        documentedPorts.add("uvm_pkg::uvm_algorithmic_comparator.before_export");
        documentedPorts.add("uvm_pkg::uvm_in_order_comparator.before_export");
        documentedPorts.add("uvm_pkg::uvm_random_stimulus.blocking_put_port");
        documentedPorts.add("uvm_pkg::uvm_tlm_fifo_base.get_ap");
        documentedPorts.add("uvm_pkg::uvm_tlm_fifo_base.get_peek_export");
        documentedPorts.add("uvm_pkg::uvm_tlm_req_rsp_channel.get_peek_request_export");
        documentedPorts.add("uvm_pkg::uvm_tlm_req_rsp_channel.get_peek_response_export");
        documentedPorts.add("uvm_pkg::uvm_tlm_req_rsp_channel.master_export");
        documentedPorts.add("uvm_pkg::uvm_in_order_comparator.pair_ap");
        documentedPorts.add("uvm_pkg::uvm_tlm_fifo_base.put_ap");
        documentedPorts.add("uvm_pkg::uvm_tlm_fifo_base.put_export");
        documentedPorts.add("uvm_pkg::uvm_tlm_req_rsp_channel.put_request_export");
        documentedPorts.add("uvm_pkg::uvm_tlm_req_rsp_channel.put_response_export");
        documentedPorts.add("uvm_pkg::uvm_push_driver.req_export");
        documentedPorts.add("uvm_pkg::uvm_push_sequencer.req_port");
        documentedPorts.add("uvm_pkg::uvm_tlm_req_rsp_channel.request_ap");
        documentedPorts.add("uvm_pkg::uvm_tlm_req_rsp_channel.response_ap");
        documentedPorts.add("uvm_pkg::uvm_sequencer_param_base.rsp_export");
        documentedPorts.add("uvm_pkg::uvm_driver.rsp_port");
        documentedPorts.add("uvm_pkg::uvm_push_driver.rsp_port");
        documentedPorts.add("uvm_pkg::uvm_driver.seq_item_port");
        documentedPorts.add("uvm_pkg::uvm_tlm_req_rsp_channel.slave_export");
        documentedPorts.add("uvm_pkg::uvm_tlm_transport_channel.transport_export");
    }

    private static void addTypes() {
        documentedTypes = new HashSet<String>();
        documentedTypes.add("uvm_pkg::uvm_mem_mam.alloc_mode_e");
        documentedTypes.add("uvm_pkg::uvm_mem_mam.locality_e");
        documentedTypes.add("uvm_pkg::uvm_access_e");
        documentedTypes.add("uvm_pkg::uvm_action");
        documentedTypes.add("uvm_pkg::uvm_action_type");
        documentedTypes.add("uvm_pkg::uvm_active_passive_enum");
        documentedTypes.add("uvm_pkg::uvm_apprepend");
        documentedTypes.add("uvm_pkg::uvm_barrier_pool");
        documentedTypes.add("uvm_pkg::uvm_bitstream_t");
        documentedTypes.add("uvm_pkg::uvm_check_e");
        documentedTypes.add("uvm_pkg::uvm_config_int");
        documentedTypes.add("uvm_pkg::uvm_config_object");
        documentedTypes.add("uvm_pkg::uvm_config_string");
        documentedTypes.add("uvm_pkg::uvm_config_wrapper");
        documentedTypes.add("uvm_pkg::uvm_coverage_model_e");
        documentedTypes.add("uvm_pkg::uvm_elem_kind_e");
        documentedTypes.add("uvm_pkg::uvm_endianness_e");
        documentedTypes.add("uvm_pkg::uvm_event_pool");
        documentedTypes.add("uvm_pkg::UVM_FILE");
        documentedTypes.add("uvm_pkg::uvm_hdl_data_t");
        documentedTypes.add("uvm_pkg::uvm_hdl_path_slice");
        documentedTypes.add("uvm_pkg::uvm_heartbeat_modes");
        documentedTypes.add("uvm_pkg::uvm_hier_e");
        documentedTypes.add("uvm_pkg::uvm_integral_t");
        documentedTypes.add("uvm_pkg::uvm_mem_cb");
        documentedTypes.add("uvm_pkg::uvm_mem_cb_iter");
        documentedTypes.add("uvm_pkg::uvm_objection_cbs_t");
        documentedTypes.add("uvm_pkg::uvm_objection_event");
        documentedTypes.add("uvm_pkg::uvm_path_e");
        documentedTypes.add("uvm_pkg::uvm_phase_cb_pool");
        documentedTypes.add("uvm_pkg::uvm_tlm_gp");
        documentedTypes.add("uvm_pkg::uvm_phase_state");
        documentedTypes.add("uvm_pkg::uvm_phase_type");
        documentedTypes.add("uvm_pkg::uvm_port_list");
        documentedTypes.add("uvm_pkg::uvm_port_type_e");
        documentedTypes.add("uvm_pkg::uvm_predict_e");
        documentedTypes.add("uvm_pkg::uvm_printer_row_info");
        documentedTypes.add("uvm_pkg::uvm_radix_enum");
        documentedTypes.add("uvm_pkg::uvm_recursion_policy_enum");
        documentedTypes.add("uvm_pkg::uvm_reg_addr_logic_t");
        documentedTypes.add("uvm_pkg::uvm_reg_addr_t");
        documentedTypes.add("uvm_pkg::uvm_reg_bd_cb");
        documentedTypes.add("uvm_pkg::uvm_reg_bd_cb_iter");
        documentedTypes.add("uvm_pkg::uvm_reg_bus_op");
        documentedTypes.add("uvm_pkg::uvm_reg_byte_en_t");
        documentedTypes.add("uvm_pkg::uvm_reg_cb");
        documentedTypes.add("uvm_pkg::uvm_reg_cb_iter");
        documentedTypes.add("uvm_pkg::uvm_reg_cvr_t");
        documentedTypes.add("uvm_pkg::uvm_reg_data_logic_t");
        documentedTypes.add("uvm_pkg::uvm_reg_data_t");
        documentedTypes.add("uvm_pkg::uvm_reg_field_cb");
        documentedTypes.add("uvm_pkg::uvm_reg_field_cb_iter");
        documentedTypes.add("uvm_pkg::uvm_reg_mem_tests_e");
        documentedTypes.add("uvm_pkg::uvm_report_catcher.action_e");
        documentedTypes.add("uvm_pkg::uvm_report_cb");
        documentedTypes.add("uvm_pkg::uvm_resource_db.rsrc_t");
        documentedTypes.add("uvm_pkg::uvm_resource_types.access_t");
        documentedTypes.add("uvm_pkg::uvm_resource_types.rsrc_q_t");
        documentedTypes.add("uvm_pkg::uvm_resource_types.override_t");
        documentedTypes.add("uvm_pkg::uvm_resource_types.priority_e");
        documentedTypes.add("uvm_pkg::uvm_sequence_lib_mode");
        documentedTypes.add("uvm_pkg::uvm_sequence_state");
        documentedTypes.add("uvm_pkg::uvm_sequence_state_enum");
        documentedTypes.add("uvm_pkg::uvm_sequencer_arb_mode");
        documentedTypes.add("uvm_pkg::uvm_severity");
        documentedTypes.add("uvm_pkg::UVM_SEQ_ARB_TYPE");
        documentedTypes.add("uvm_pkg::uvm_status_e");
        documentedTypes.add("uvm_pkg::uvm_tlm_command_e");
        documentedTypes.add("uvm_pkg::uvm_tlm_phase_e");
        documentedTypes.add("uvm_pkg::uvm_tlm_response_status_e");
        documentedTypes.add("uvm_pkg::uvm_tlm_sync_e");
        documentedTypes.add("uvm_pkg::uvm_verbosity");
        documentedTypes.add("uvm_pkg::uvm_vreg_cbs.uvm_vreg_cb");
        documentedTypes.add("uvm_pkg::uvm_vreg_cbd.uvm_vreg_cb_iter");
        documentedTypes.add("uvm_pkg::uvm_vreg_field_cbd.uvm_vreg_field_cb");
        documentedTypes.add("uvm_pkg::uvm_vreg_field_cbs.uvm_vreg_field_cb_iter");
        documentedTypes.add("uvm_pkg::uvm_wait_op");
    }

    private static void addVariables() {
        documentedVariables = new HashSet<String>();
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_CONFIG_DB_TRACE");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_DUMP_CMDLINE_ARGS");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_MAX_QUIT_COUNT");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_OBJECTION_TRACE");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_PHASE_TRACE");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_RESOURCE_DB_TRACE");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.uvm_set_action");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.uvm_set_config_int");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.uvm_set_config_string");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.uvm_set_default_sequence");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.uvm_set_inst_override");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.uvm_set_severity");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.uvm_set_type_override");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.uvm_set_verbosity");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_TESTNAME");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_TIMEOUT");
        documentedVariables.add("uvm_pkg::uvm_cmdline_processor.UVM_VERBOSITY");
        documentedVariables.add("uvm_pkg::uvm_comparer.abstract");
        documentedVariables.add("uvm_pkg::uvm_packer.abstract");
        documentedVariables.add("uvm_pkg::uvm_recorder.abstract");
        documentedVariables.add("uvm_pkg::uvm_reg_mem_hdl_paths_seq.abstractions");
        documentedVariables.add("uvm_pkg::uvm_reg_predictor.adapter");
        documentedVariables.add("uvm_pkg::uvm_reg_sequence.adapter");
        documentedVariables.add("uvm_pkg::uvm_reg_bus_op.addr");
        documentedVariables.add("uvm_pkg::uvm_reg_item.bd_kind");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.begin_elements");
        documentedVariables.add("uvm_pkg::uvm_transaction.begin_event");
        documentedVariables.add("uvm_pkg::uvm_packer.big_endian");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.bin_radix");
        documentedVariables.add("uvm_pkg::uvm_reg_hw_reset_seq.body");
        documentedVariables.add("uvm_pkg::uvm_reg_predictor.bus_in");
        documentedVariables.add("uvm_pkg::uvm_reg_bus_op.byte_en");
        documentedVariables.add("uvm_pkg::uvm_comparer.check_type");
        documentedVariables.add("uvm_pkg::uvm_reg_bus_op.data");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.dec_radix");
        documentedVariables.add("uvm_pkg::uvm_mem_mam.default_alloc");
        documentedVariables.add("uvm_pkg::uvm_reg_block.default_map");
        documentedVariables.add("uvm_pkg::uvm_reg_block.default_path");
        documentedVariables.add("uvm_pkg::uvm_resource_base.default_precedence");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.default_radix");
        documentedVariables.add("uvm_pkg::uvm_recorder.default_radix");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.depth");
        documentedVariables.add("uvm_pkg::uvm_sequence_base.do_not_randomize");
        documentedVariables.add("uvm_pkg::uvm_reg_item.element");
        documentedVariables.add("uvm_pkg::uvm_reg_item.element_kind");
        documentedVariables.add("uvm_pkg::uvm_root.enable_print_topology");
        documentedVariables.add("uvm_pkg::uvm_default_report_server.enable_report_id_count_summary");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.end_elements");
        documentedVariables.add("uvm_pkg::uvm_transaction.end_event");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_cfg.end_offset");
        documentedVariables.add("uvm_pkg::uvm_transaction.events");
        documentedVariables.add("uvm_pkg::uvm_reg_item.extension");
        documentedVariables.add("uvm_pkg::uvm_reg_fifo.fifo");
        documentedVariables.add("uvm_pkg::uvm_root.finish_on_completion");
        documentedVariables.add("uvm_pkg::uvm_reg_item.fname");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.footer");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.full_name");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.header");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.hex_radix");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.identifier");
        documentedVariables.add("uvm_pkg::uvm_recorder.identifier");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_policy.in_use");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.indent");
        documentedVariables.add("uvm_pkg::uvm_reg_bus_op.kind");
        documentedVariables.add("uvm_pkg::uvm_reg_item.kind");
        documentedVariables.add("uvm_pkg::uvm_printer.knobs");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_policy.len");
        documentedVariables.add("uvm_pkg::uvm_reg_item.lineno");
        documentedVariables.add("uvm_pkg::uvm_reg_item.local_map");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_cfg.locality");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_address");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_byte_enable");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_byte_enable_length");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_command");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_data");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_dmi");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_length");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_response_status");
        documentedVariables.add("uvm_pkg::uvm_tlm_generic_payload.m_streaming_width");
        documentedVariables.add("uvm_pkg::uvm_mem.mam");
        documentedVariables.add("uvm_pkg::uvm_reg_item.map");
        documentedVariables.add("uvm_pkg::uvm_reg_predictor.map");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_policy.max_offset");
        documentedVariables.add("uvm_pkg::uvm_sequence_library.max_random_count");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.mcd");
        documentedVariables.add("uvm_pkg::uvm_mem_shared_access_seq.mem");
        documentedVariables.add("uvm_pkg::uvm_mem_single_access_seq.mem");
        documentedVariables.add("uvm_pkg::uvm_mem_single_walk_seq.mem");
        documentedVariables.add("uvm_pkg::uvm_mem_access_seq.mem_seq");
        documentedVariables.add("uvm_pkg::uvm_mem_walk_seq.mem_seq");
        documentedVariables.add("uvm_pkg::uvm_reg_mem_shared_access_seq.mem_seq");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_policy.min_offset");
        documentedVariables.add("uvm_pkg::uvm_sequence_library.min_random_count");
        documentedVariables.add("uvm_pkg::uvm_comparer.miscompares");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_cfg.mode");
        documentedVariables.add("uvm_pkg::uvm_mem_access_seq.model");
        documentedVariables.add("uvm_pkg::uvm_mem_walk_seq.model");
        documentedVariables.add("uvm_pkg::uvm_reg_access_seq.model");
        documentedVariables.add("uvm_pkg::uvm_reg_bit_bash_seq.model");
        documentedVariables.add("uvm_pkg::uvm_reg_hw_reset_seq.model");
        documentedVariables.add("uvm_pkg::uvm_reg_mem_built_in_seq.model");
        documentedVariables.add("uvm_pkg::uvm_reg_mem_shared_access_seq.model");
        documentedVariables.add("uvm_pkg::uvm_reg_sequence.model");
        documentedVariables.add("uvm_pkg::uvm_reg_bus_op.n_bits");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_cfg.n_bytes");
        documentedVariables.add("uvm_pkg::uvm_line_printer.new");
        documentedVariables.add("uvm_pkg::uvm_table_printer.new");
        documentedVariables.add("uvm_pkg::uvm_tree_printer.new");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.oct_radix");
        documentedVariables.add("uvm_pkg::uvm_reg_item.offset");
        documentedVariables.add("uvm_pkg::uvm_reg_item.parent");
        documentedVariables.add("uvm_pkg::uvm_reg_adapter.parent_sequence");
        documentedVariables.add("uvm_pkg::uvm_reg_item.path");
        documentedVariables.add("uvm_pkg::uvm_comparer.physical");
        documentedVariables.add("uvm_pkg::uvm_packer.physical");
        documentedVariables.add("uvm_pkg::uvm_recorder.physical");
        documentedVariables.add("uvm_pkg::uvm_comparer.policy");
        documentedVariables.add("uvm_pkg::uvm_resource_base.precedence");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.prefix");
        documentedVariables.add("uvm_pkg::uvm_component.print_config_matches");
        documentedVariables.add("uvm_pkg::uvm_component.print_enabled");
        documentedVariables.add("uvm_pkg::uvm_reg_item.prior");
        documentedVariables.add("uvm_pkg::uvm_reg_adapter.provides_responses");
        documentedVariables.add("uvm_pkg::uvm_default_report_server.record_all_messages");
        documentedVariables.add("uvm_pkg::uvm_recorder.recursion_policy");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.reference");
        documentedVariables.add("uvm_pkg::uvm_reg_predictor.reg_ap");
        documentedVariables.add("uvm_pkg::uvm_reg_access_seq.reg_seq");
        documentedVariables.add("uvm_pkg::uvm_reg_bit_bash_seq.reg_seq");
        documentedVariables.add("uvm_pkg::uvm_reg_mem_shared_access_seq.reg_seq");
        documentedVariables.add("uvm_pkg::uvm_reg_sequence.reg_seqr");
        documentedVariables.add("uvm_pkg::uvm_sequence.req");
        documentedVariables.add("uvm_pkg::uvm_comparer.result");
        documentedVariables.add("uvm_pkg::uvm_reg_shared_access_seq.rg");
        documentedVariables.add("uvm_pkg::uvm_reg_single_access_seq.rg");
        documentedVariables.add("uvm_pkg::uvm_reg_single_bit_bash_seq.rg");
        documentedVariables.add("uvm_pkg::uvm_sequence.rsp");
        documentedVariables.add("uvm_pkg::uvm_reg_frontdoor.rw_info");
        documentedVariables.add("uvm_pkg::uvm_sequence_library.select_rand");
        documentedVariables.add("uvm_pkg::uvm_sequence_library.select_randc");
        documentedVariables.add("uvm_pkg::uvm_sequence_library.selection_mode");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.separator");
        documentedVariables.add("uvm_pkg::uvm_sequencer.seq_item_export");
        documentedVariables.add("uvm_pkg::uvm_sequence_library.sequence_count");
        documentedVariables.add("uvm_pkg::uvm_reg_frontdoor.sequencer");
        documentedVariables.add("uvm_pkg::uvm_sequence_library.sequences_executed");
        documentedVariables.add("uvm_pkg::uvm_comparer.sev");
        documentedVariables.add("uvm_pkg::uvm_comparer.show_max");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.show_radix");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.show_root");
        documentedVariables.add("uvm_pkg::uvm_default_report_server.show_terminator");
        documentedVariables.add("uvm_pkg::uvm_default_report_server.show_verbosity");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.size");
        documentedVariables.add("uvm_pkg::uvm_hdl_path_concat.slices");
        documentedVariables.add("uvm_pkg::uvm_mem_mam_policy.start_offset");
        documentedVariables.add("uvm_pkg::uvm_reg_bus_op.status");
        documentedVariables.add("uvm_pkg::uvm_reg_item.status");
        documentedVariables.add("uvm_pkg::uvm_reg_adapter.supports_byte_enable");
        documentedVariables.add("uvm_pkg::uvm_built_in_pair.T1 first");
        documentedVariables.add("uvm_pkg::uvm_class_pair.T1 first");
        documentedVariables.add("uvm_pkg::uvm_built_in_pair.T2 second");
        documentedVariables.add("uvm_pkg::uvm_class_pair.T2 second");
        documentedVariables.add("uvm_pkg::uvm_reg_mem_built_in_seq.tests");
        documentedVariables.add("uvm_pkg::uvm_root.top_levels");
        documentedVariables.add("uvm_pkg::uvm_component.tr_database");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.type_name");
        documentedVariables.add("uvm_pkg::uvm_printer_knobs.unsigned_radix");
        documentedVariables.add("uvm_pkg::uvm_packer.use_metadata");
        documentedVariables.add("uvm_pkg::uvm_object.use_uvm_seeding");
        documentedVariables.add("uvm_pkg::uvm_default_comparer");
        documentedVariables.add("uvm_pkg::uvm_default_line_printer");
        documentedVariables.add("uvm_pkg::uvm_default_packer");
        documentedVariables.add("uvm_pkg::uvm_default_printer");
        documentedVariables.add("uvm_pkg::uvm_default_table_printer");
        documentedVariables.add("uvm_pkg::uvm_default_tree_printer");
        documentedVariables.add("uvm_pkg::UVM_HDL_MAX_WIDTH");
        documentedVariables.add("uvm_pkg::uvm_root.uvm_top");
        documentedVariables.add("uvm_pkg::uvm_top");
        documentedVariables.add("uvm_pkg::uvm_reg_field.value");
        documentedVariables.add("uvm_pkg::uvm_reg_item.value");
        documentedVariables.add("uvm_pkg::uvm_comparer.verbosity");
    }
}

