/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class XVMLintUtils {
    private static final String XVM_ACTIVE_PASSIVE_ENUM = "_active_passive_enum";

    public static boolean isInOVMMacroCall(OVMProject aOVMProject, RfNamedElement elem) {
        ReparseInfo.ReparseElement[] macroStack;
        if (elem == null) {
            return false;
        }
        if (elem.getDeclaration() == null) {
            return false;
        }
        ReparseInfo reparseInfo = elem.getDeclaration().getReparseInfo();
        if (reparseInfo == null || reparseInfo.getReparseStackSize() == 0) {
            return false;
        }
        ReparseInfo.ReparseElement[] reparseElementArray = macroStack = reparseInfo.getReparseStack();
        int n = macroStack.length;
        int n2 = 0;
        while (n2 < n) {
            String macroFile;
            ReparseInfo.ReparseElement macroElm = reparseElementArray[n2];
            VlogMacroInfo macroInfo = macroElm.getTransientReparseMacroInfo();
            if (macroInfo != null && macroInfo.getFileInstance() != null && macroInfo.getFileInstance().getParserPath() != null && (macroFile = LintUtils.getFileShortName(macroInfo.getFileInstance().getParserPath().path)) != null && aOVMProject.isOVMFile(macroFile)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isConditionalCode(OVMProject aOVMProject, RfNamedElement element) {
        return XVMLintUtils.isConditionalCode(aOVMProject, element, false);
    }

    public static boolean isConditionalCode(OVMProject aOVMProject, RfNamedElement element, boolean allowInstantiationByActiveFieldCheckingValue) {
        RfNamedElement enclosingScope = element.getEnclosingScope();
        while (enclosingScope != null && enclosingScope instanceof RfActionBlock) {
            RfActionBlock block;
            if (((RfActionBlock)enclosingScope).isConditional() && XVMLintUtils.isActiveConditionalBlock(block = (RfActionBlock)enclosingScope, allowInstantiationByActiveFieldCheckingValue, new HashSet<String>(Arrays.asList(OVMUtils.prependLibraryPrefixTo(aOVMProject.getLibraryKind(), XVM_ACTIVE_PASSIVE_ENUM))))) {
                return true;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return false;
    }

    public static boolean isActiveConditionalBlock(OVMProject aOVMProject, RfActionBlock aBlock) {
        return XVMLintUtils.isActiveConditionalBlock(aBlock, false, new HashSet<String>(Arrays.asList(OVMUtils.prependLibraryPrefixTo(aOVMProject.getLibraryKind(), XVM_ACTIVE_PASSIVE_ENUM))));
    }

    public static boolean isActiveConditionalBlock(OVMProject aOVMProject, RfActionBlock aBlock, boolean allowInstantiationByActiveFieldCheckingValue) {
        return XVMLintUtils.isActiveConditionalBlock(aBlock, allowInstantiationByActiveFieldCheckingValue, new HashSet<String>(Arrays.asList(OVMUtils.prependLibraryPrefixTo(aOVMProject.getLibraryKind(), XVM_ACTIVE_PASSIVE_ENUM))));
    }

    public static boolean isActiveConditionalBlock(RfActionBlock aBlock, boolean allowInstantiationByActiveFieldCheckingValue, Set<String> conditionalExpressionEnums) {
        if (!aBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.IF)) {
            return false;
        }
        IHidObject conditionalBlockExpression = aBlock.getConditionalBlockExpression();
        if (conditionalBlockExpression == null) {
            return false;
        }
        return XVMLintUtils.isHidObjectActiveConditionalBlockForAgent(conditionalBlockExpression, allowInstantiationByActiveFieldCheckingValue, conditionalExpressionEnums);
    }

    public static boolean isHidObjectActiveConditionalBlockForAgent(OVMProject aOVMProject, IHidObject conditionalBlockExpression) {
        return XVMLintUtils.isHidObjectActiveConditionalBlockForAgent(conditionalBlockExpression, false, new HashSet<String>(Arrays.asList(OVMUtils.prependLibraryPrefixTo(aOVMProject.getLibraryKind(), XVM_ACTIVE_PASSIVE_ENUM))));
    }

    public static boolean isHidObjectActiveConditionalBlockForAgent(IHidObject conditionalBlockExpression, boolean allowInstantiationByActiveFieldCheckingValue, Set<String> conditionalExpressionEnums) {
        if (conditionalBlockExpression instanceof RfHidAccessArgs) {
            conditionalBlockExpression = ((RfHidAccessArgs)conditionalBlockExpression).getParentHid();
        }
        if (conditionalBlockExpression instanceof RfHid) {
            String type;
            RfNamedElement associatedFinalType;
            IRfNamedElement element = ((RfHid)conditionalBlockExpression).getElement();
            if (element instanceof RfFunction && element.getName().equals("get_is_active")) {
                return true;
            }
            if (element instanceof RfField && element.getName().equals("is_active")) {
                return true;
            }
            if (allowInstantiationByActiveFieldCheckingValue && element instanceof RfField && (associatedFinalType = LintUtils.getAssociatedFinalType((RfField)element)) instanceof RfStruct && conditionalExpressionEnums.contains(type = ((RfStruct)associatedFinalType).getAliasName())) {
                return true;
            }
        } else if (conditionalBlockExpression instanceof RfHidOperator) {
            if (((RfHidOperator)conditionalBlockExpression).isEquality()) {
                return XVMLintUtils.isValidGuard((RfHidOperator)conditionalBlockExpression, true, conditionalExpressionEnums);
            }
            if (((RfHidOperator)conditionalBlockExpression).isInequality()) {
                return XVMLintUtils.isValidGuard((RfHidOperator)conditionalBlockExpression, false, conditionalExpressionEnums);
            }
        }
        return false;
    }

    public static boolean isValidGuard(RfHidOperator conditionalBlockExpression, boolean isEquality, Set<String> conditionalExpressionEnums) {
        IHidObject lhValue = conditionalBlockExpression.getLHValue();
        if (lhValue instanceof RfHid && XVMLintUtils.isValidGuard((RfHid)lhValue, isEquality, conditionalExpressionEnums)) {
            return true;
        }
        ListContainer rhValues = conditionalBlockExpression.getRHValues();
        if (rhValues == null || rhValues.isEmpty()) {
            return false;
        }
        for (IHidObject val : rhValues) {
            if (!(val instanceof RfHid) || !XVMLintUtils.isValidGuard((RfHid)val, isEquality, conditionalExpressionEnums)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidGuard(RfHid hid, boolean isEquality, Set<String> conditionalExpressionEnums) {
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfField)) {
            return false;
        }
        RfField field = (RfField)element;
        if (!field.isEnumElement()) {
            return false;
        }
        if (isEquality && field.getName().contains("PASSIVE")) {
            return false;
        }
        if (!isEquality && field.getName().contains("ACTIVE")) {
            return false;
        }
        RfStruct enumScope = (RfStruct)((RfField)element).getEnclosingScope();
        return conditionalExpressionEnums.contains(enumScope.getAliasName());
    }

    public static RfActionBlock findActiveConditionalCodeInMethod(OVMProject aOVMProject, RfFunction method, RfClass agent) {
        return XVMLintUtils.findBlockWithActiveConditionalCode(aOVMProject, method, agent);
    }

    public static RfActionBlock findActiveConditionalCodeInMethod(OVMProject aOVMProject, RfFunction method, RfClass agent, boolean allowInstantiationByActiveFieldCheckingValue, Set<String> conditionalExpressionEnums) {
        return XVMLintUtils.findBlockWithActiveConditionalCode(aOVMProject, method, agent, allowInstantiationByActiveFieldCheckingValue, conditionalExpressionEnums);
    }

    private static RfActionBlock findBlockWithActiveConditionalCode(OVMProject aOVMProject, RfNamedElement scope, RfClass aAgent) {
        return XVMLintUtils.findBlockWithActiveConditionalCode(aOVMProject, scope, aAgent, false, new HashSet<String>(Arrays.asList(OVMUtils.prependLibraryPrefixTo(aOVMProject.getLibraryKind(), XVM_ACTIVE_PASSIVE_ENUM))));
    }

    private static RfActionBlock findBlockWithActiveConditionalCode(OVMProject aOVMProject, RfNamedElement scope, RfClass aAgent, boolean allowInstantiationByActiveFieldCheckingValue, Set<String> conditionalExpressionEnums) {
        List<RfActionBlock> blocks = scope.getLocalMembers(RfActionBlock.class);
        if (blocks == null || blocks.isEmpty()) {
            return null;
        }
        for (RfActionBlock block : blocks) {
            if (!XVMLintUtils.isActiveConditionalBlock(block, allowInstantiationByActiveFieldCheckingValue, conditionalExpressionEnums)) continue;
            return block;
        }
        for (RfActionBlock block : blocks) {
            RfActionBlock result = XVMLintUtils.findBlockWithActiveConditionalCode(aOVMProject, block, aAgent, false, conditionalExpressionEnums);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getCreatedTypeSubString(RfFunctionCall createCall) {
        int type_idIndex = createCall.getName().lastIndexOf("::type_id::create");
        if (type_idIndex < 0) {
            return null;
        }
        String createdTypeName = createCall.getName().substring(0, type_idIndex);
        int firstPound = createdTypeName.indexOf(35);
        if (firstPound > 0) {
            createdTypeName = createdTypeName.substring(0, firstPound);
        }
        return createdTypeName;
    }

    public static List<RfFunctionCall> getCreateCallsForField(OVMProject aOVMProject, RfField aField) {
        ArrayList<RfFunctionCall> result = new ArrayList<RfFunctionCall>();
        RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(aField);
        if (aField != null && fieldType != null) {
            DataType dataType = aField.getDataType();
            for (RfFunctionCall createCall : aOVMProject.getAllCreateCalls()) {
                if (dataType != null && createCall.getName().equals(String.valueOf(dataType.getTypeNameWithParamAssignments().replace(", ", ",").replace("interface ", "")) + "::type_id::create")) {
                    result.add(createCall);
                    continue;
                }
                String[] splittedCreateCall = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)createCall.getName(), (int)2);
                if (!XVMLintUtils.checkIfAncestor(fieldType, splittedCreateCall[0]) || !splittedCreateCall[1].equals("type_id::create")) continue;
                result.add(createCall);
            }
        }
        return result;
    }

    private static boolean checkIfAncestor(RfClass ancestor, String className) {
        if (ancestor.getName().equals(className)) {
            return true;
        }
        if (ancestor.getChildren() != null) {
            for (RfClass child : ancestor.getChildren()) {
                if (!XVMLintUtils.checkIfAncestor(child, className)) continue;
                return true;
            }
        }
        return false;
    }

    public static RfNamedElement getCreatedInstance(RfFunctionCall createCall) {
        return createCall.getLeftValue();
    }

    public static List<RfField> getVirtualInterfaceFieldsInClass(RfClass clazz, int scope) {
        List<RfField> fields = clazz.getFieldsWithPrefix("", 2, scope, scope == 2 ? IRfNamedElement.AccessModifier.SHOW_PROTECTED : IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        ArrayList<RfField> result = new ArrayList<RfField>();
        if (fields == null || fields.isEmpty()) {
            return Collections.emptyList();
        }
        for (RfField field : fields) {
            if (!LintUtils.isVirtualInterface(field, RfTypesResolver.create((IRfScopeElement)clazz, clazz.getRfProject(), 6))) continue;
            result.add(field);
        }
        return result;
    }

    public static RfField getVirtualInterfaceFieldInClass(RfClass classs) {
        List<RfField> virtualInterfaceFields = XVMLintUtils.getVirtualInterfaceFieldsInClass(classs, 1);
        if (virtualInterfaceFields == null || virtualInterfaceFields.isEmpty()) {
            return null;
        }
        return virtualInterfaceFields.get(0);
    }
}

