/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

public class LineRange {
    private int fStartLine;
    private int fEndLine;

    public LineRange(String lineRange, boolean checkLineRange) throws IllegalArgumentException {
        int endLine;
        int startLine;
        String[] parts = lineRange.trim().split(":");
        if (parts.length < 1 || parts.length > 2) {
            throw new IllegalArgumentException("Invalid line range format '" + lineRange + "'!");
        }
        try {
            endLine = startLine = Integer.parseInt(parts[0].trim());
            if (parts.length == 2) {
                endLine = Integer.parseInt(parts[1].trim());
            }
            if (checkLineRange && startLine > endLine) {
                throw new IllegalArgumentException("Invalid line range format '" + lineRange + "', start line > end line!");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid line range format '" + lineRange + "', line number is not a positive integer!");
        }
        this.fStartLine = startLine;
        this.fEndLine = endLine;
    }

    public LineRange(String lineRange) throws IllegalArgumentException {
        this(lineRange, true);
    }

    public LineRange(int startLine, int endLine) {
        this.fStartLine = startLine;
        this.fEndLine = endLine;
    }

    public void setStartLine(int startLine) {
        this.fStartLine = startLine;
    }

    public void setEndLine(int endLine) {
        this.fEndLine = endLine;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public boolean contains(int line) {
        return line >= this.fStartLine && line <= this.fEndLine;
    }

    public String toString() {
        if (this.fStartLine == this.fEndLine) {
            return Integer.toString(this.fStartLine);
        }
        return String.valueOf(this.fStartLine) + ":" + this.fEndLine;
    }

    public static boolean isValid(String lineRange) {
        block5: {
            if (lineRange == null || lineRange.isEmpty()) {
                return true;
            }
            String[] parts = lineRange.split(":");
            try {
                if (parts.length == 1) {
                    Integer.parseInt(parts[0].trim());
                    break block5;
                }
                if (parts.length == 2) {
                    return Integer.parseInt(parts[0].trim()) <= Integer.parseInt(parts[1].trim());
                }
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }
}

