/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class MessagePattern {
    private final Pattern fCompiledPattern;
    private final String fPattern;
    private final String fRawPattern;

    public MessagePattern(String pattern, boolean isSimpleRegex) {
        this(pattern, isSimpleRegex, true);
    }

    public MessagePattern(String pattern, boolean isSimpleRegex, boolean catchRegexException) {
        String tmpPattern = pattern.trim();
        Pattern tmpCompiledPattern = null;
        try {
            tmpCompiledPattern = isSimpleRegex ? DVTUtilsCommon.INSTANCE.compileSimpleRegex(tmpPattern) : Pattern.compile(tmpPattern);
        }
        catch (PatternSyntaxException e) {
            if (catchRegexException) {
                throw new IllegalArgumentException("Invalid message pattern '" + tmpPattern + "', it must be a valid regular expression!");
            }
            throw e;
        }
        this.fRawPattern = pattern;
        this.fPattern = tmpPattern;
        this.fCompiledPattern = tmpCompiledPattern;
    }

    public MessagePattern(String message) {
        String[] lines;
        StringBuilder tempPattern = new StringBuilder();
        String[] stringArray = lines = message.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            tempPattern.append("\\Q");
            tempPattern.append(line);
            tempPattern.append("\\E");
            tempPattern.append("\\R");
            ++n2;
        }
        if (!message.endsWith("\n")) {
            tempPattern.delete(tempPattern.length() - 2, tempPattern.length());
        }
        this.fRawPattern = message;
        this.fPattern = tempPattern.toString();
        this.fCompiledPattern = Pattern.compile(this.fPattern);
    }

    public boolean matches(String string) {
        return this.fCompiledPattern.matcher(string).matches();
    }

    public String toString() {
        return this.fPattern;
    }

    public String getRawPattern() {
        return this.fRawPattern;
    }

    public static boolean isValid(String pattern, boolean isSimpleRegex) {
        if (pattern == null || pattern.isEmpty()) {
            return true;
        }
        try {
            if (isSimpleRegex) {
                DVTUtilsCommon.INSTANCE.compileSimpleRegex(pattern);
            } else {
                Pattern.compile(pattern, 32);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        return true;
    }
}

