/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;

public class PathEntry {
    private final String fPath;
    private final IPath fTranslatedPath;
    private final StringMatcher fWildcardMatcher;
    private final Pattern fCompiledPattern;
    private String fApplyOn;

    public PathEntry(String path, boolean isSimpleRegex) {
        this(path, isSimpleRegex, "matched");
    }

    public PathEntry(String path, boolean isSimpleRegex, String applyOn) {
        if (path == null) {
            throw new IllegalArgumentException("Path is null!");
        }
        this.fPath = path;
        this.fTranslatedPath = Path.fromOSString((String)DVTStringUtil.translatePathPatternToOSPattern((String)path.trim()));
        String osTranslatedPath = this.fTranslatedPath.toOSString();
        this.fWildcardMatcher = osTranslatedPath.contains("*") || osTranslatedPath.contains("?") ? new StringMatcher(osTranslatedPath, false, false, true) : null;
        try {
            this.fCompiledPattern = isSimpleRegex ? null : Pattern.compile(path.trim());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Invalid path pattern '" + path + "', it must be a valid regular expression!");
        }
        this.fApplyOn = applyOn;
    }

    public boolean matches(ParserPath path) {
        return this.matches(path.path);
    }

    public boolean matches(String path) {
        boolean applyOn;
        if (path == null || path.equals("none")) {
            return false;
        }
        boolean bl = applyOn = this.fApplyOn == null || "matched".equals(this.fApplyOn);
        if (this.fCompiledPattern != null) {
            return applyOn ? this.fCompiledPattern.matcher(path).matches() : !this.fCompiledPattern.matcher(path).matches();
        }
        if (this.fWildcardMatcher != null) {
            return applyOn ? this.fWildcardMatcher.match(Path.fromOSString((String)path).toOSString()) : !this.fWildcardMatcher.match(Path.fromOSString((String)path).toOSString());
        }
        return applyOn ? this.fTranslatedPath.isPrefixOf(Path.fromOSString((String)path)) : !this.fTranslatedPath.isPrefixOf(Path.fromOSString((String)path));
    }

    public static boolean isValid(String pattern, boolean isSimpleRegex) {
        if (pattern == null || pattern.isEmpty()) {
            return true;
        }
        try {
            if (isSimpleRegex) {
                DVTUtilsCommon.INSTANCE.compileSimpleRegex(pattern);
            } else {
                Pattern.compile(pattern, 32);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.fPath;
    }

    public String getApplyOn() {
        return this.fApplyOn;
    }
}

