/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.MessagePattern;
import ro.amiq.vlogdt.linter.waivers.PathEntry;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;

public class PostWaiver
implements IWaiver {
    private String fFilePath = null;
    private String fName = "Waiver Name";
    private String fDescription = "";
    private WaiverStatus fStatus = WaiverStatus.DISABLE;
    private WaiverType fType = WaiverType.FILE;
    private final LinkedHashMap<String, PathEntry> fPaths = new LinkedHashMap();
    private final List<String> fRawPaths = new ArrayList<String>();
    private final List<String> fCheckNames = new LinkedList<String>();
    private final List<String> fUVMFCheckNames = new LinkedList<String>();
    private final LinkedList<LineRange> fLineRanges = new LinkedList();
    private final LinkedList<MessagePattern> fMessagePatterns = new LinkedList();
    private final LinkedList<OVMComplianceCheckHit> fWaivedFailures = new LinkedList();
    private String fRegexType = "perl";
    private String fPathRegexType = "perl";
    private final LinkedHashMap<String, PathEntry> fPostwaivedPaths = new LinkedHashMap();
    private String fMessageRegexType = "perl";
    private String fWaiverApplyOn = "matched";
    private String fPathsApplyOn = "matched";
    private String fElementsRegexType = "perl";
    private HashMap<String, String> fElements = new HashMap();
    private String fCommentType;
    private boolean fInsideMacroPath = false;
    private int fLineNoInXMLFile = -1;

    @Override
    public String getFilePath() {
        return this.fFilePath;
    }

    @Override
    public void setFilePath(String filePath) {
        this.fFilePath = filePath;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.fName = name.trim();
        }
    }

    @Override
    public void setDescription(String description) {
        if (description != null) {
            this.fDescription = description.trim();
        }
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    public WaiverStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(WaiverStatus status) {
        this.fStatus = status;
    }

    public void addWaivedFailure(OVMComplianceCheckHit hit) {
        this.fWaivedFailures.add(hit);
    }

    public LinkedList<OVMComplianceCheckHit> getWaivedFailures() {
        return this.fWaivedFailures;
    }

    public void addMatchedPostwaivedPath(String path) {
        if (path == null) {
            return;
        }
        this.fPostwaivedPaths.put(path, new PathEntry(path, this.fPathRegexType.equals("simple"), "matched"));
    }

    public void addPostwaivedPath(String path) {
        if (path == null) {
            return;
        }
        this.fPostwaivedPaths.put(path, new PathEntry(path, this.fPathRegexType.equals("simple"), this.fPathsApplyOn));
    }

    public LinkedHashMap<String, PathEntry> getPostwaivedPaths() {
        return this.fPostwaivedPaths;
    }

    @Override
    public WaiverType getType() {
        return this.fType;
    }

    @Override
    public WaiverType setType(WaiverType type) {
        this.fType = type;
        return this.fType;
    }

    public void addElement(String type, String name) {
        this.fElements.put(type, name);
    }

    public HashMap<String, String> getElements() {
        return this.fElements;
    }

    public void clearElements() {
        this.fElements.clear();
    }

    public void setElementsRegexType(String elementsRegexType) {
        String tmpRegexType = null;
        tmpRegexType = elementsRegexType == null || elementsRegexType.isEmpty() ? "perl" : elementsRegexType.toLowerCase();
        this.fElementsRegexType = tmpRegexType;
    }

    public String getElementsRegexType() {
        return this.fElementsRegexType;
    }

    @Override
    public List<String> getPaths() {
        LinkedList<String> paths = new LinkedList<String>();
        for (String path : this.fPaths.keySet()) {
            paths.add(path);
        }
        return paths;
    }

    @Override
    public List<String> getRawPaths() {
        return this.fRawPaths;
    }

    @Override
    public List<String> getCheckNames() {
        return this.fCheckNames;
    }

    public List<String> getUVMFCheckNames() {
        return this.fUVMFCheckNames;
    }

    public LinkedList<LineRange> getLineRanges() {
        return this.fLineRanges;
    }

    public LinkedList<MessagePattern> getMessagePatterns() {
        return this.fMessagePatterns;
    }

    @Override
    public void addPath(String path) {
        if (path == null) {
            return;
        }
        this.fPaths.put(path, new PathEntry(path, this.fPathRegexType.equals("simple"), this.fPathsApplyOn));
    }

    @Override
    public void addRawPath(String path) {
        if (path == null) {
            return;
        }
        this.fRawPaths.add(path);
    }

    @Override
    public void addCheckName(String checkName) {
        if (checkName != null) {
            this.fCheckNames.add(checkName.trim());
        }
    }

    public void addUVMFCheckName(String checkName) {
        if (checkName != null) {
            this.fUVMFCheckNames.add(checkName.trim());
        }
    }

    public void addLineRange(LineRange lineRange) {
        if (lineRange != null) {
            this.fLineRanges.add(lineRange);
        }
    }

    public void addMessagePattern(MessagePattern messagePattern) {
        if (messagePattern != null) {
            this.fMessagePatterns.add(messagePattern);
        }
    }

    @Override
    public void setRegexType(String regexType) {
        String tmpRegexType = null;
        tmpRegexType = regexType == null || regexType.isEmpty() ? "perl" : regexType.toLowerCase();
        this.fRegexType = tmpRegexType;
    }

    @Override
    public void setApplyOn(String applyOn) {
        String tmpApplyOn = null;
        tmpApplyOn = applyOn == null || applyOn.isEmpty() ? "matched" : applyOn.toLowerCase();
        this.fWaiverApplyOn = tmpApplyOn;
    }

    @Override
    public void setCommentType(String commentType) {
        String tmpCommentType = null;
        tmpCommentType = commentType == null || commentType.isEmpty() ? "MULTI LINE" : commentType.toLowerCase();
        this.fCommentType = tmpCommentType;
    }

    @Override
    public String getCommentType() {
        return this.fCommentType;
    }

    @Override
    public String getRegexType() {
        return this.fRegexType;
    }

    @Override
    public void setPathRegexType(String regexType) {
        String tmpRegexType = null;
        tmpRegexType = regexType == null || regexType.isEmpty() ? "perl" : regexType.toLowerCase();
        this.fPathRegexType = tmpRegexType;
    }

    @Override
    public String getPathRegexType() {
        return this.fPathRegexType;
    }

    public void setMessageRegexType(String regexType) {
        String tmpRegexType = null;
        tmpRegexType = regexType == null || regexType.isEmpty() ? "perl" : regexType.toLowerCase();
        this.fMessageRegexType = tmpRegexType;
    }

    public String getMessageRegexType() {
        return this.fMessageRegexType;
    }

    @Override
    public String getApplyOn() {
        return this.fWaiverApplyOn;
    }

    @Override
    public void setPathsApplyOn(String pathsApplyOn) {
        String tmpApplyOn = null;
        tmpApplyOn = pathsApplyOn == null || pathsApplyOn.isEmpty() ? "matched" : pathsApplyOn.toLowerCase();
        this.fPathsApplyOn = tmpApplyOn;
    }

    @Override
    public String getPathsApplyOn() {
        return this.fPathsApplyOn;
    }

    public void setInsideMacroPath(boolean macroPath) {
        this.fInsideMacroPath = macroPath;
    }

    public boolean isInsideMacroPath() {
        return this.fInsideMacroPath;
    }

    @Override
    public int getLineNoInXMLFile() {
        return this.fLineNoInXMLFile;
    }

    @Override
    public void setLineNoInXMLFile(int lineNoInXMLFile) {
        this.fLineNoInXMLFile = lineNoInXMLFile;
    }

    @Override
    public void clearPaths() {
        this.fPaths.clear();
    }

    @Override
    public void clearRawPaths() {
        this.fRawPaths.clear();
    }

    public void clearCheckNames() {
        this.fCheckNames.clear();
    }

    public void clearUVMFCheckNames() {
        this.fUVMFCheckNames.clear();
    }

    public void clearLineRanges() {
        this.fLineRanges.clear();
    }

    public void clearMessagePatterns() {
        this.fMessagePatterns.clear();
    }

    public boolean isCheckWaiver() {
        return this.fPaths.isEmpty() && this.fLineRanges.isEmpty() && this.fMessagePatterns.isEmpty() && !this.fCheckNames.isEmpty();
    }

    public boolean matchesPath(ParserPath fileName) {
        for (PathEntry pathEntry : this.fPaths.values()) {
            if (!pathEntry.matches(fileName)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesPath(String fileName) {
        for (PathEntry pathEntry : this.fPaths.values()) {
            if (!pathEntry.matches(fileName)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesCheck(String checkName) {
        return this.fCheckNames.contains(checkName);
    }

    public boolean matchesHit(OVMComplianceCheckHit hit) {
        boolean matches;
        if (this.fPostwaivedPaths.isEmpty() && !this.fElements.isEmpty()) {
            return false;
        }
        if (!this.fCheckNames.isEmpty() && !this.fCheckNames.contains(hit.getCheck().getName())) {
            return false;
        }
        if (!this.fInsideMacroPath) {
            if (!this.fPostwaivedPaths.isEmpty()) {
                matches = false;
                for (PathEntry pathEntry : this.fPostwaivedPaths.values()) {
                    if (!pathEntry.matches(hit.getParserPath())) continue;
                    matches = true;
                    break;
                }
                if (!matches) {
                    return false;
                }
            }
        } else if (!this.fPostwaivedPaths.isEmpty()) {
            if (hit.getInsideMacroPaths() == null) {
                return false;
            }
            matches = false;
            for (PathEntry pathEntry : this.fPostwaivedPaths.values()) {
                ParserPath[] parserPathArray = hit.getInsideMacroPaths();
                int n = parserPathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ParserPath insideMacroPath = parserPathArray[n2];
                    if (pathEntry.matches(insideMacroPath)) {
                        matches = true;
                        break;
                    }
                    ++n2;
                }
                if (matches) break;
            }
            if (!matches) {
                return false;
            }
        }
        if (!this.fInsideMacroPath && !this.fLineRanges.isEmpty()) {
            matches = false;
            for (LineRange lineRange : this.fLineRanges) {
                if (!lineRange.contains(hit.getLine())) continue;
                matches = true;
                break;
            }
            if (!matches) {
                return false;
            }
        }
        if (!this.fMessagePatterns.isEmpty()) {
            matches = false;
            for (MessagePattern messagePattern : this.fMessagePatterns) {
                if (!messagePattern.matches(hit.getDetails())) continue;
                matches = true;
                break;
            }
            if (!matches) {
                return false;
            }
        }
        return true;
    }

    public PostWaiver clone() {
        PostWaiver waiver = new PostWaiver();
        waiver.setFilePath(this.fFilePath);
        waiver.setName(this.fName);
        waiver.setDescription(this.fDescription);
        waiver.setStatus(this.fStatus);
        waiver.setType(this.fType);
        waiver.setRegexType(this.fRegexType);
        waiver.setPathRegexType(this.fPathRegexType);
        waiver.setApplyOn(this.fWaiverApplyOn);
        waiver.setPathsApplyOn(this.fPathsApplyOn);
        waiver.setInsideMacroPath(this.fInsideMacroPath);
        waiver.setLineNoInXMLFile(this.fLineNoInXMLFile);
        waiver.setMessageRegexType(this.fMessageRegexType);
        waiver.setElementsRegexType(this.fElementsRegexType);
        waiver.setCommentType(this.fCommentType);
        waiver.setInsideMacroPath(this.fInsideMacroPath);
        waiver.setLineNoInXMLFile(this.fLineNoInXMLFile);
        for (String string : this.fPaths.keySet()) {
            waiver.addPath(string);
        }
        for (String string : this.fRawPaths) {
            waiver.addRawPath(string);
        }
        for (String string : this.fCheckNames) {
            waiver.addCheckName(string);
        }
        for (LineRange lineRange : this.fLineRanges) {
            waiver.addLineRange(lineRange);
        }
        for (MessagePattern messagePattern : this.fMessagePatterns) {
            waiver.addMessagePattern(messagePattern);
        }
        for (String string : this.fUVMFCheckNames) {
            waiver.addUVMFCheckName(string);
        }
        for (OVMComplianceCheckHit oVMComplianceCheckHit : this.fWaivedFailures) {
            waiver.addWaivedFailure(oVMComplianceCheckHit);
        }
        for (Map.Entry entry : this.fPostwaivedPaths.entrySet()) {
            String path = (String)entry.getKey();
            String applyOn = ((PathEntry)entry.getValue()).getApplyOn();
            if (applyOn == null || applyOn.equals("matched")) {
                waiver.addMatchedPostwaivedPath(path);
                continue;
            }
            waiver.addPostwaivedPath(path);
        }
        for (Map.Entry entry : this.fElements.entrySet()) {
            waiver.addElement((String)entry.getKey(), (String)entry.getValue());
        }
        return waiver;
    }
}

