/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.PathEntry;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfPackageDef;

public class PreWaiver
implements IWaiver {
    public static final Map<String, Class<? extends RfDefElement>> ELEMENTS = ImmutableMap.of((Object)"module", RfModuleDef.class, (Object)"interface", RfInterfaceDef.class, (Object)"package", RfPackageDef.class);
    private String fFilePath = null;
    private String fName = "Waiver Name";
    private String fDescription = "";
    private WaiverType fType = WaiverType.FILE;
    private String fRegexType = "perl";
    private String fPathRegexType = "perl";
    private LinkedHashMap<String, PathEntry> fPrewaivedPaths = new LinkedHashMap();
    private final LinkedHashMap<String, PathEntry> fPathPatterns = new LinkedHashMap();
    private final List<String> fRawPathPatterns = new ArrayList<String>();
    private String fPreWaiverApplyOn = "matched";
    private String fPathsApplyOn = "matched";
    private String fElementsRegexType = "perl";
    private HashMap<String, String> fElements = new HashMap();
    private List<String> fCheckNames = new LinkedList<String>();
    private Set<String> fPrewaivedFiles = new LinkedHashSet<String>();
    private int fLineNoInXMLFile = -1;

    @Override
    public void addCheckName(String name) {
        this.fCheckNames.add(name);
    }

    @Override
    public List<String> getCheckNames() {
        return this.fCheckNames;
    }

    public void addElement(String type, String name) {
        this.fElements.put(type, name);
    }

    public HashMap<String, String> getElements() {
        return this.fElements;
    }

    public void clearElements() {
        this.fElements.clear();
    }

    @Override
    public String getFilePath() {
        return this.fFilePath;
    }

    @Override
    public void setFilePath(String filePath) {
        this.fFilePath = filePath;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.fName = name.trim();
        }
    }

    @Override
    public void setDescription(String description) {
        if (description != null) {
            this.fDescription = description.trim();
        }
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public WaiverType getType() {
        return this.fType;
    }

    @Override
    public WaiverType setType(WaiverType type) {
        this.fType = type;
        return this.fType;
    }

    @Override
    public List<String> getPaths() {
        LinkedList<String> paths = new LinkedList<String>();
        for (String path : this.fPathPatterns.keySet()) {
            paths.add(path);
        }
        return paths;
    }

    @Override
    public List<String> getRawPaths() {
        return this.fRawPathPatterns;
    }

    @Override
    public void addPath(String path) {
        if (path == null) {
            return;
        }
        this.fPathPatterns.put(path, new PathEntry(path, this.fPathRegexType.equals("simple"), this.fPathsApplyOn));
    }

    @Override
    public void addRawPath(String path) {
        if (path == null) {
            return;
        }
        this.fRawPathPatterns.add(path);
    }

    public void addMatchedPrewaivedPath(String path) {
        if (path == null) {
            return;
        }
        this.fPrewaivedPaths.put(path, new PathEntry(path, this.fPathRegexType.equals("simple"), "matched"));
    }

    public void addPrewaivedPath(String path) {
        if (path == null) {
            return;
        }
        this.fPrewaivedPaths.put(path, new PathEntry(path, this.fPathRegexType.equals("simple"), this.fPathsApplyOn));
    }

    public void addPrewaivedFile(String file) {
        if (file == null) {
            return;
        }
        this.fPrewaivedFiles.add(file);
    }

    public Set<String> getPrewaivedFiles() {
        return this.fPrewaivedFiles;
    }

    public LinkedHashMap<String, PathEntry> getPrewaivedPaths() {
        return this.fPrewaivedPaths;
    }

    public void setPrewaivedPaths(LinkedHashMap<String, PathEntry> prewaivedPaths) {
        this.fPrewaivedPaths = prewaivedPaths;
    }

    public boolean matchesPath(ParserPath fileName) {
        for (PathEntry pathEntry : this.fPathPatterns.values()) {
            if (!pathEntry.matches(fileName)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesCheck(String checkName) {
        return this.fCheckNames.contains(checkName);
    }

    public boolean isPrewaived(ParserPath fileName) {
        for (PathEntry pathEntry : this.fPrewaivedPaths.values()) {
            if (!pathEntry.matches(fileName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRegexType(String regexType) {
        String tmpRegexType = null;
        tmpRegexType = regexType == null || regexType.isEmpty() ? "perl" : regexType.toLowerCase();
        this.fRegexType = tmpRegexType;
    }

    @Override
    public String getRegexType() {
        return this.fRegexType;
    }

    @Override
    public void setPathRegexType(String regexType) {
        String tmpRegexType = null;
        tmpRegexType = regexType == null || regexType.isEmpty() ? "perl" : regexType.toLowerCase();
        this.fPathRegexType = tmpRegexType;
    }

    @Override
    public String getPathRegexType() {
        return this.fPathRegexType;
    }

    @Override
    public void setApplyOn(String applyOn) {
        String tmpApplyOn = null;
        tmpApplyOn = applyOn == null || applyOn.isEmpty() ? "matched" : applyOn.toLowerCase();
        this.fPreWaiverApplyOn = tmpApplyOn;
    }

    @Override
    public String getApplyOn() {
        return this.fPreWaiverApplyOn;
    }

    @Override
    public void setPathsApplyOn(String pathsApplyOn) {
        String tmpApplyOn = null;
        tmpApplyOn = pathsApplyOn == null || pathsApplyOn.isEmpty() ? "matched" : pathsApplyOn.toLowerCase();
        this.fPathsApplyOn = tmpApplyOn;
    }

    @Override
    public String getPathsApplyOn() {
        return this.fPathsApplyOn;
    }

    @Override
    public void setCommentType(String commentType) {
    }

    @Override
    public String getCommentType() {
        return null;
    }

    @Override
    public void clearPaths() {
        this.fPathPatterns.clear();
        this.fPrewaivedPaths.clear();
    }

    @Override
    public void clearRawPaths() {
        this.fRawPathPatterns.clear();
    }

    public void clearCheckNames() {
        this.fCheckNames.clear();
    }

    public boolean isCheckPreWaiver() {
        return this.fPathPatterns.isEmpty() && this.fElements.isEmpty() && !this.fCheckNames.isEmpty();
    }

    @Override
    public int getLineNoInXMLFile() {
        return this.fLineNoInXMLFile;
    }

    @Override
    public void setLineNoInXMLFile(int lineNoInXMLFile) {
        this.fLineNoInXMLFile = lineNoInXMLFile;
    }

    public void setElementsRegexType(String elementsRegexType) {
        String tmpRegexType = null;
        tmpRegexType = elementsRegexType == null || elementsRegexType.isEmpty() ? "perl" : elementsRegexType.toLowerCase();
        this.fElementsRegexType = tmpRegexType;
    }

    public String getElementsRegexType() {
        return this.fElementsRegexType;
    }

    public PreWaiver clone() {
        PreWaiver waiver = new PreWaiver();
        waiver.setFilePath(this.fFilePath);
        waiver.setName(this.fName);
        waiver.setDescription(this.fDescription);
        waiver.setType(this.fType);
        waiver.setRegexType(this.fRegexType);
        waiver.setPathRegexType(this.fPathRegexType);
        waiver.setApplyOn(this.fPreWaiverApplyOn);
        waiver.setLineNoInXMLFile(this.fLineNoInXMLFile);
        waiver.setElementsRegexType(this.fElementsRegexType);
        for (String string : this.fPathPatterns.keySet()) {
            waiver.addPath(string);
        }
        for (String string : this.fRawPathPatterns) {
            waiver.addRawPath(string);
        }
        for (Map.Entry entry : this.fPrewaivedPaths.entrySet()) {
            String path = (String)entry.getKey();
            String applyOn = ((PathEntry)entry.getValue()).getApplyOn();
            if (applyOn == null || applyOn.equals("matched")) {
                waiver.addMatchedPrewaivedPath(path);
                continue;
            }
            waiver.addPrewaivedPath(path);
        }
        for (Map.Entry entry : this.fElements.entrySet()) {
            waiver.addElement((String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : this.fCheckNames) {
            waiver.addCheckName(string);
        }
        for (String string : this.fPrewaivedFiles) {
            waiver.addPrewaivedFile(string);
        }
        return waiver;
    }
}

