/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.xml.sax.SAXException;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.dvt.utils.XMLValidatorBatchUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ReportManager;
import ro.amiq.vlogdt.linter.launch.VerissimoAfterCompilationLauncher;
import ro.amiq.vlogdt.linter.utils.LintDHUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;

public class WaiversModel {
    public static final String PREWAIVE_UNCHANGED = "Prewaiver generated by prewaive_unchanged_files";
    public static final String PREWAIVE_PRECOMPILED = "Prewaiver generated for precompiled code";
    private OVMProject fOVMProject;
    private File fFile;
    private final LinkedList<PostWaiver> fPostWaivers = new LinkedList();
    private final LinkedList<PreWaiver> fPreWaivers = new LinkedList();
    private final LinkedHashMap<String, WaiversXMLParser> fFileParsersMap = new LinkedHashMap();
    private final LinkedHashMap<OVMComplianceCheck, Set<String>> fCheckPrewaivedPathsMap = new LinkedHashMap();
    private final LinkedHashMap<OVMComplianceCheck, Set<String>> fCheckNoMatchPrewaivedPathsMap = new LinkedHashMap();
    private final Set<String> fModifiedFiles = new HashSet<String>();
    private final Set<String> fPrewaivedPaths = new HashSet<String>();

    public void initialize(OVMProject project) throws IllegalArgumentException {
        this.fOVMProject = project;
        if (this.fOVMProject == null) {
            throw new IllegalArgumentException("OVMProject can't be null");
        }
        if (this.fOVMProject.getProject() == null) {
            throw new IllegalArgumentException("IProject can't be null");
        }
        this.fFile = this.fOVMProject.getConfiguration().getWaiversFile();
        this.fPreWaivers.clear();
        this.fPostWaivers.clear();
        this.fFileParsersMap.clear();
        this.fCheckPrewaivedPathsMap.clear();
        this.fCheckNoMatchPrewaivedPathsMap.clear();
        this.fModifiedFiles.clear();
    }

    public List<PostWaiver> getPostWaivers() {
        return this.fPostWaivers;
    }

    public List<PreWaiver> getPreWaivers() {
        return this.fPreWaivers;
    }

    public Set<String> getWaiverFiles() {
        return this.fFileParsersMap.keySet();
    }

    private void clearWaivers() {
        LinkedList<PreWaiver> hiddenPrewaivers = new LinkedList<PreWaiver>();
        for (PreWaiver preWaiver : this.fPreWaivers) {
            if (preWaiver.getType() != WaiverType.READ_ONLY) continue;
            hiddenPrewaivers.add(preWaiver);
        }
        this.fPreWaivers.clear();
        this.fPreWaivers.addAll(hiddenPrewaivers);
        this.fPostWaivers.clear();
        this.fFileParsersMap.clear();
        this.fCheckPrewaivedPathsMap.clear();
        this.fCheckNoMatchPrewaivedPathsMap.clear();
        this.fModifiedFiles.clear();
        this.fPrewaivedPaths.clear();
    }

    public void addWaiver(IWaiver waiver) {
        if (waiver instanceof PostWaiver) {
            this.addPostWaiver((PostWaiver)waiver);
        } else if (waiver instanceof PreWaiver) {
            this.addPreWaiver((PreWaiver)waiver);
        }
        this.fModifiedFiles.add(waiver.getFilePath());
    }

    public void addPostWaiver(PostWaiver waiver) {
        this.addPostWaiver(waiver, false);
    }

    public void addPostWaiver(PostWaiver waiver, boolean addFirst) {
        if (addFirst) {
            this.fPostWaivers.addFirst(waiver);
        } else {
            this.fPostWaivers.add(waiver);
        }
    }

    public void addPreWaiver(PreWaiver waiver) {
        this.fPreWaivers.add(waiver);
    }

    public void changedWaiver(IWaiver waiver) {
        if (waiver.getType() == WaiverType.FILE) {
            this.fModifiedFiles.add(waiver.getFilePath());
        }
    }

    public void removeWaiver(IWaiver waiver) {
        if (waiver instanceof PostWaiver) {
            this.removePostWaiver((PostWaiver)waiver);
        } else if (waiver instanceof PreWaiver) {
            this.removePreWaiver((PreWaiver)waiver);
        }
    }

    public void removePostWaiver(PostWaiver waiver) {
        this.fPostWaivers.remove(waiver);
        if (waiver.getType() == WaiverType.FILE) {
            this.fModifiedFiles.add(waiver.getFilePath());
        }
    }

    public void removePreWaiver(PreWaiver waiver) {
        this.fPreWaivers.remove(waiver);
        if (waiver.getType() == WaiverType.FILE) {
            this.fModifiedFiles.add(waiver.getFilePath());
        }
    }

    public OVMProject getProject() {
        return this.fOVMProject;
    }

    /*
     * Exception decompiling
     */
    public void save() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void load() {
        try {
            if (this.fOVMProject == null) {
                return;
            }
            this.clearWaivers();
            RfProject rfProject = this.fOVMProject.getRfProject();
            Map<String, List<IWaiver>> fileWaiversMap = null;
            if (this.fFile != null) {
                LinkedHashMap<String, List<String>> inexistentFiles = new LinkedHashMap<String, List<String>>();
                WaiversXMLParser.createParsers(this.fOVMProject.getProject(), this.fFileParsersMap, WaiversXMLParser.resolvePath(this.fFile.getAbsolutePath(), null, false), null, inexistentFiles);
                fileWaiversMap = this.getWaiversMap();
            }
            ArrayList<PostWaiver> UVMFCustomPragmaWaivers = new ArrayList<PostWaiver>();
            boolean isAllowedUVMFCustomPragmaWaivers = false;
            for (WaiversXMLParser waiversXMLParser : this.fFileParsersMap.values()) {
                if (!waiversXMLParser.areUVMFCustomPragmaWaiversEnabled()) continue;
                isAllowedUVMFCustomPragmaWaivers = true;
                for (PostWaiver waiver : waiversXMLParser.getUVMFCustomPragmaWaivers()) {
                    UVMFCustomPragmaWaivers.add(waiver);
                    this.addPostWaiver(waiver);
                }
            }
            this.handleUVMFCustomPragmaWaivers(isAllowedUVMFCustomPragmaWaivers, rfProject.getPreprocessingTable().getAllWaivers(), UVMFCustomPragmaWaivers);
            if (fileWaiversMap != null) {
                for (Map.Entry entry : fileWaiversMap.entrySet()) {
                    List waivers = (List)entry.getValue();
                    if (waivers == null) continue;
                    for (IWaiver waiver : waivers) {
                        if (waiver instanceof PostWaiver) {
                            this.addPostWaiver((PostWaiver)waiver);
                            continue;
                        }
                        if (!(waiver instanceof PreWaiver)) continue;
                        this.addPreWaiver((PreWaiver)waiver);
                    }
                }
            }
            for (OVMComplianceCheck oVMComplianceCheck : this.fOVMProject.getChecks()) {
                PreWaiver exclude;
                PreWaiver include = oVMComplianceCheck.getIncludePreWaiver();
                if (include != null) {
                    this.addPreWaiver(include);
                }
                if ((exclude = oVMComplianceCheck.getExcludePreWaiver()) == null) continue;
                this.addPreWaiver(exclude);
            }
            this.computePrewaivedPaths();
            this.computePostwaivedPaths();
            ReportManager.setDirtyReports(true);
        }
        catch (SAXException e) {
            XMLValidatorBatchUtils.showError((Exception)e, (String)this.fFile.getAbsolutePath());
        }
        catch (IOException e) {
            OVMUtils.ioReadError(e, this.fFile.getName());
        }
        catch (IllegalArgumentException e) {
            XMLValidatorBatchUtils.showError((Exception)e, (String)this.fFile.getAbsolutePath());
        }
        catch (XMLException e) {
            if (e.getCause() instanceof Exception) {
                XMLValidatorBatchUtils.showError((Exception)((Exception)e.getCause()), (String)this.fFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void handleUVMFCustomPragmaWaivers(boolean isAllowedUVMFCustomPragmaWaivers, List<PostWaiver> inlinePostWaivers, List<PostWaiver> UVMFCustomPragmaNodes) {
        LinkedList<PostWaiver> uvmfPragmaWaivers = new LinkedList<PostWaiver>();
        LinkedList<PostWaiver> regularInlineWaivers = new LinkedList<PostWaiver>();
        for (PostWaiver postWaiver : inlinePostWaivers) {
            if (postWaiver.getType() == WaiverType.UVMF_CUSTOM_PRAGMA) {
                uvmfPragmaWaivers.add(postWaiver);
                continue;
            }
            regularInlineWaivers.add(postWaiver);
        }
        if (isAllowedUVMFCustomPragmaWaivers) {
            for (PostWaiver waiver : uvmfPragmaWaivers) {
                for (PostWaiver UVMFNode : UVMFCustomPragmaNodes) {
                    if (!UVMFNode.matchesPath(waiver.getPaths().get(0))) continue;
                    for (String checkName : UVMFNode.getUVMFCheckNames()) {
                        waiver.addCheckName(checkName);
                    }
                }
                waiver.setDescription("UVMF Custom Pragma Waiver in file " + new File(waiver.getPaths().get(0)).getName() + " lines " + waiver.getLineRanges().get(0).getStartLine() + ":" + waiver.getLineRanges().get(0).getEndLine());
                this.fPostWaivers.add(waiver);
            }
        }
        this.fPostWaivers.addAll(regularInlineWaivers);
    }

    private Map<String, List<IWaiver>> getWaiversMap() throws Exception {
        HashMap<String, List<IWaiver>> result = new HashMap<String, List<IWaiver>>();
        for (Map.Entry<String, WaiversXMLParser> entry : this.fFileParsersMap.entrySet()) {
            String path = entry.getKey();
            WaiversXMLParser parser2 = entry.getValue();
            if (path == null || parser2 == null) continue;
            result.put(path, parser2.load());
        }
        LinkedList<WaiversXMLParser> parsers = new LinkedList<WaiversXMLParser>(this.fFileParsersMap.values());
        HashSet<String> visitedPaths = new HashSet<String>();
        boolean noModification = false;
        while (!noModification) {
            noModification = true;
            String includedPath = parsers.stream().filter(parser -> !parser.hasIncludesInXML() && !visitedPaths.contains(parser.getFilePath())).map(WaiversXMLParser::getFilePath).findFirst().orElse(null);
            if (includedPath == null) break;
            for (WaiversXMLParser parser3 : parsers) {
                Integer lineNo;
                if (visitedPaths.contains(includedPath) || (lineNo = parser3.getLineNumberForWaiverResolvedPath(includedPath)) == -1) continue;
                String parentPath = parser3.getFilePath();
                ArrayList<IWaiver> mergedWaivers = new ArrayList<IWaiver>();
                mergedWaivers.addAll((Collection)result.get(includedPath));
                mergedWaivers.forEach(x -> x.setLineNoInXMLFile(lineNo));
                mergedWaivers.addAll((Collection)result.get(parentPath));
                mergedWaivers.sort(Comparator.comparing(IWaiver::getLineNoInXMLFile));
                result.remove(includedPath);
                result.put(parentPath, mergedWaivers);
                Iterator<WaiversXMLParser.WaiverIncludeInfo> iterator = parser3.getIncludes().iterator();
                while (iterator.hasNext()) {
                    WaiversXMLParser.WaiverIncludeInfo includeInfo = iterator.next();
                    if (!includeInfo.getPath().equals(includedPath)) continue;
                    iterator.remove();
                }
                visitedPaths.add(includedPath);
                noModification = false;
            }
        }
        return result;
    }

    public void computePostwaivedPaths() {
        Iterator<PostWaiver> iterator = this.fPostWaivers.descendingIterator();
        while (iterator.hasNext()) {
            HashSet<String> resultedPathsFromElementsFilter = new HashSet<String>();
            PostWaiver postWaiver = iterator.next();
            List<String> postwaiverPathPatterns = postWaiver.getPaths();
            HashMap<String, String> postwaiverElements = postWaiver.getElements();
            if (postwaiverElements.isEmpty()) {
                resultedPathsFromElementsFilter.addAll(postwaiverPathPatterns);
                for (String path : resultedPathsFromElementsFilter) {
                    postWaiver.addPostwaivedPath(path);
                }
            } else {
                HashSet<ParserPath> elementPaths = this.computePathsByElementType(postwaiverElements, postWaiver.getElementsRegexType().equals("simple"));
                if (postwaiverPathPatterns == null || postwaiverPathPatterns.isEmpty()) {
                    for (ParserPath parserPath : elementPaths) {
                        resultedPathsFromElementsFilter.add(parserPath.path);
                    }
                } else {
                    for (ParserPath parserPath : elementPaths) {
                        if (!postWaiver.matchesPath(parserPath)) continue;
                        resultedPathsFromElementsFilter.add(parserPath.path);
                    }
                }
                for (String path : resultedPathsFromElementsFilter) {
                    postWaiver.addMatchedPostwaivedPath(path);
                }
            }
            String postwaivedTopPattern = postwaiverElements.get("top");
            if (postwaivedTopPattern == null || postwaivedTopPattern.isEmpty()) continue;
            resultedPathsFromElementsFilter.clear();
            HashSet<String> matchingModules = new HashSet<String>();
            for (RfNamedElement module : this.fOVMProject.getAllModules()) {
                if (postWaiver.getElementsRegexType().equals("simple")) {
                    StringMatcher strMatcher = new StringMatcher(postwaivedTopPattern, false, false, true);
                    if (!strMatcher.match(module.getName())) continue;
                    matchingModules.add(module.getName());
                    if (postwaiverPathPatterns != null && !postwaiverPathPatterns.isEmpty() && !postWaiver.matchesPath(module.getDeclaration().getParserPath())) continue;
                    resultedPathsFromElementsFilter.add(module.getDeclaration().getParserPath().path);
                    continue;
                }
                if (!Pattern.matches(postwaivedTopPattern, module.getName())) continue;
                matchingModules.add(module.getName());
                if (postwaiverPathPatterns != null && !postwaiverPathPatterns.isEmpty() && !postWaiver.matchesPath(module.getDeclaration().getParserPath())) continue;
                resultedPathsFromElementsFilter.add(module.getDeclaration().getParserPath().path);
            }
            VlogFileInstance topFileInstance = this.fOVMProject.getRfProject().getPreprocessingTable().getTopFileInstance();
            List filtredInstances = this.getAllFileInstances(topFileInstance).stream().filter(e -> e.getSemanticScope() instanceof RfModule).collect(Collectors.toList());
            IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
            if (elMemory == null) continue;
            HashSet<IRfNamedElement> allBindings = new HashSet<IRfNamedElement>();
            for (String moduleName : matchingModules) {
                ElementPath topElementPath = LintDHUtils.computeElementPathFromModuleName(this.fOVMProject.getRfProject(), moduleName);
                if (topElementPath == null) {
                    DVTBuildConsoleRegistry.getConsole((IProject)this.getProject().getProject()).printStartSection("WARNING: Waiver top element is not found under specified top");
                    continue;
                }
                Map topSubTree = elMemory.subtreeOf(topElementPath, false);
                if (topSubTree == null || topSubTree.isEmpty()) continue;
                for (Map.Entry entry : topSubTree.entrySet()) {
                    IRfNamedElement binding = ((ELInstance)entry.getValue()).getBinding(false);
                    if (binding == null || binding.getDeclaration() == null) continue;
                    if (postwaiverPathPatterns == null || postwaiverPathPatterns.isEmpty() || postWaiver.matchesPath(binding.getDeclaration().getParserPath())) {
                        resultedPathsFromElementsFilter.add(binding.getDeclaration().getParserPath().path);
                    }
                    allBindings.add(binding);
                }
            }
            for (VlogFileInstance fileInstance : filtredInstances) {
                if (!allBindings.contains(fileInstance.getSemanticScope()) || postwaiverPathPatterns != null && !postwaiverPathPatterns.isEmpty() && !postWaiver.matchesPath(fileInstance.getParserPath())) continue;
                resultedPathsFromElementsFilter.add(fileInstance.getParserPath().path);
            }
            for (String path : resultedPathsFromElementsFilter) {
                postWaiver.addMatchedPostwaivedPath(path);
            }
            resultedPathsFromElementsFilter.clear();
        }
    }

    public void computePrewaivedPaths() {
        HashSet<String> resultedPathsFromElementsFilter = new HashSet<String>();
        Iterator<PreWaiver> iterator = this.fPreWaivers.descendingIterator();
        while (iterator.hasNext()) {
            PreWaiver preWaiver = iterator.next();
            if (preWaiver.getType() == WaiverType.RULESET) {
                for (String path : preWaiver.getPrewaivedPaths().keySet()) {
                    preWaiver.addRawPath(path);
                }
                continue;
            }
            HashMap<String, String> prewaiverElements = preWaiver.getElements();
            List<String> prewaiverPathPatterns = preWaiver.getPaths();
            if (prewaiverElements.isEmpty()) {
                resultedPathsFromElementsFilter.addAll(prewaiverPathPatterns);
                for (String path : resultedPathsFromElementsFilter) {
                    preWaiver.addPrewaivedPath(path);
                }
            } else {
                HashSet<ParserPath> elementPaths = this.computePathsByElementType(prewaiverElements, preWaiver.getElementsRegexType().equals("simple"));
                if (prewaiverPathPatterns.isEmpty()) {
                    for (ParserPath parserPath : elementPaths) {
                        resultedPathsFromElementsFilter.add(parserPath.path);
                    }
                } else {
                    for (ParserPath parserPath : elementPaths) {
                        if (!preWaiver.matchesPath(parserPath)) continue;
                        resultedPathsFromElementsFilter.add(parserPath.path);
                    }
                }
                for (String path : resultedPathsFromElementsFilter) {
                    preWaiver.addMatchedPrewaivedPath(path);
                }
            }
            resultedPathsFromElementsFilter.clear();
            String prewaivedTopPattern = prewaiverElements.get("top");
            if (prewaivedTopPattern == null || prewaivedTopPattern.isEmpty()) continue;
            HashSet<String> matchingModules = new HashSet<String>();
            for (RfNamedElement module : this.fOVMProject.getAllModules()) {
                if (preWaiver.getElementsRegexType().equals("simple")) {
                    StringMatcher strMatcher = new StringMatcher(prewaivedTopPattern, false, false, true);
                    if (!strMatcher.match(module.getName())) continue;
                    matchingModules.add(module.getName());
                    if (prewaiverPathPatterns != null && !prewaiverPathPatterns.isEmpty() && !preWaiver.matchesPath(module.getDeclaration().getParserPath())) continue;
                    resultedPathsFromElementsFilter.add(module.getDeclaration().getParserPath().path);
                    continue;
                }
                if (!Pattern.matches(prewaivedTopPattern, module.getName())) continue;
                matchingModules.add(module.getName());
                if (prewaiverPathPatterns != null && !prewaiverPathPatterns.isEmpty() && !preWaiver.matchesPath(module.getDeclaration().getParserPath())) continue;
                resultedPathsFromElementsFilter.add(module.getDeclaration().getParserPath().path);
            }
            VlogFileInstance topFileInstance = this.fOVMProject.getRfProject().getPreprocessingTable().getTopFileInstance();
            List filtredInstances = this.getAllFileInstances(topFileInstance).stream().filter(e -> e.getSemanticScope() instanceof RfModule).collect(Collectors.toList());
            IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
            if (elMemory == null) continue;
            HashSet<IRfNamedElement> allBindings = new HashSet<IRfNamedElement>();
            for (String moduleName : matchingModules) {
                ElementPath topElementPath = LintDHUtils.computeElementPathFromModuleName(this.fOVMProject.getRfProject(), moduleName);
                if (topElementPath == null) {
                    DVTBuildConsoleRegistry.getConsole((IProject)this.getProject().getProject()).printStartSection("WARNING: Pre-waiver top element is not found under specified top");
                    continue;
                }
                Map topSubTree = elMemory.subtreeOf(topElementPath, false);
                if (topSubTree == null || topSubTree.isEmpty()) continue;
                for (Map.Entry entry : topSubTree.entrySet()) {
                    IRfNamedElement binding = ((ELInstance)entry.getValue()).getBinding(false);
                    if (binding == null || binding.getDeclaration() == null) continue;
                    if (prewaiverPathPatterns == null || prewaiverPathPatterns.isEmpty() || preWaiver.matchesPath(binding.getDeclaration().getParserPath())) {
                        resultedPathsFromElementsFilter.add(binding.getDeclaration().getParserPath().path);
                    }
                    allBindings.add(binding);
                }
            }
            for (VlogFileInstance fileInstance : filtredInstances) {
                if (!allBindings.contains(fileInstance.getSemanticScope()) || prewaiverPathPatterns != null && !prewaiverPathPatterns.isEmpty() && !preWaiver.matchesPath(fileInstance.getParserPath())) continue;
                resultedPathsFromElementsFilter.add(fileInstance.getParserPath().path);
            }
            for (String path : resultedPathsFromElementsFilter) {
                preWaiver.addMatchedPrewaivedPath(path);
            }
            resultedPathsFromElementsFilter.clear();
        }
    }

    public List<VlogFileInstance> getAllFileInstances(VlogFileInstance root) {
        ArrayList<VlogFileInstance> localList = new ArrayList<VlogFileInstance>();
        List<VlogFileInstance> files = root.getIncludedInstances();
        if (files != null && !files.isEmpty()) {
            for (VlogFileInstance file : files) {
                localList.addAll(this.getAllFileInstances(file));
            }
        }
        localList.add(root);
        return localList;
    }

    public HashSet<ParserPath> computePathsByElementType(HashMap<String, String> elementsToExclude, boolean isSimpleRegex) {
        HashSet<ParserPath> result = new HashSet<ParserPath>();
        List<ParserPath> allFilesInOrder = this.fOVMProject.getAllFilesInOrder();
        if (allFilesInOrder == null || allFilesInOrder.isEmpty()) {
            return result;
        }
        ArrayList excludedElements = new ArrayList();
        for (ParserPath parserPath : allFilesInOrder) {
            Collection<RfDefElement> children;
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
            if (fileDef == null || (children = fileDef.getChildren()) == null || children.isEmpty()) continue;
            ArrayList<RfDefElement> allElements = new ArrayList<RfDefElement>(children);
            for (Map.Entry<String, Class<? extends RfDefElement>> entry : PreWaiver.ELEMENTS.entrySet()) {
                String namePattern = elementsToExclude.get(entry.getKey());
                if (namePattern == null) continue;
                StringMatcher strMatcher = new StringMatcher(namePattern, false, false, true);
                excludedElements.addAll(allElements.stream().filter(e -> ((Class)entry.getValue()).isInstance(e)).filter(e -> namePattern.isEmpty() || isSimpleRegex && strMatcher.match(e.getName()) || !isSimpleRegex && Pattern.matches(namePattern, e.getName())).collect(Collectors.toList()));
            }
            allElements.removeAll(excludedElements);
            if (allElements.isEmpty() && !excludedElements.isEmpty()) {
                HashMap<ParserPath, HashMap<ParserPath, List<Integer>>> allFilesWithIncludes = this.fOVMProject.getAllFilesWithIncludes();
                HashMap<ParserPath, List<Integer>> includedFiles = allFilesWithIncludes.get(parserPath);
                if (includedFiles == null) {
                    result.add(parserPath);
                    continue;
                }
                for (RfDefElement element : excludedElements) {
                    for (Map.Entry<ParserPath, List<Integer>> entry : includedFiles.entrySet()) {
                        List<Integer> includeLines = entry.getValue();
                        for (Integer includeLine : includeLines) {
                            if (includeLine <= element.getStartLine() || includeLine >= element.getEndLine()) continue;
                            result.add(entry.getKey());
                            this.getIncludedPaths(entry.getKey(), result, allFilesWithIncludes);
                        }
                    }
                }
                result.add(parserPath);
            }
            excludedElements.clear();
        }
        return result;
    }

    private void getIncludedPaths(ParserPath parserPath, Set<ParserPath> fPrewaivedPaths, HashMap<ParserPath, HashMap<ParserPath, List<Integer>>> allFilesWithIncludes) {
        HashMap<ParserPath, List<Integer>> includedFiles = allFilesWithIncludes.get(parserPath);
        if (includedFiles == null || includedFiles.isEmpty()) {
            return;
        }
        for (Map.Entry<ParserPath, List<Integer>> entry : includedFiles.entrySet()) {
            if (fPrewaivedPaths.contains(entry.getKey())) continue;
            fPrewaivedPaths.add(entry.getKey());
            this.getIncludedPaths(entry.getKey(), fPrewaivedPaths, allFilesWithIncludes);
        }
    }

    public WaiverStatus getStatus(OVMComplianceCheckHit hit) {
        boolean prewaivedResult = this.pathIsPrewaived(hit.getParserPath(), hit.getCheck());
        if (prewaivedResult) {
            return WaiverStatus.DISABLE;
        }
        WaiverStatus status = WaiverStatus.NONE;
        Iterator<PostWaiver> iterator = this.fPostWaivers.descendingIterator();
        while (iterator.hasNext()) {
            PostWaiver waiver = iterator.next();
            if (waiver.getApplyOn().equals("not-matched") && !waiver.matchesHit(hit)) {
                status = waiver.getStatus();
                waiver.addWaivedFailure(hit);
                break;
            }
            if (!waiver.getApplyOn().equals("matched") || !waiver.matchesHit(hit)) continue;
            status = waiver.getStatus();
            waiver.addWaivedFailure(hit);
            break;
        }
        return status;
    }

    public Boolean isDisabled(OVMComplianceCheck check) {
        IWaiver waiver;
        String checkName = check.getName();
        Iterator<PostWaiver> iterator = this.fPostWaivers.descendingIterator();
        while (iterator.hasNext()) {
            waiver = iterator.next();
            if ((!((PostWaiver)waiver).getApplyOn().equals("not-matched") || ((PostWaiver)waiver).getCheckNames().isEmpty() || ((PostWaiver)waiver).matchesCheck(checkName)) && (!((PostWaiver)waiver).getApplyOn().equals("matched") || !((PostWaiver)waiver).getCheckNames().isEmpty() && !((PostWaiver)waiver).matchesCheck(checkName))) continue;
            if (((PostWaiver)waiver).isCheckWaiver()) {
                if (WaiverStatus.DISABLE == ((PostWaiver)waiver).getStatus()) {
                    return true;
                }
                return false;
            }
            if (WaiverStatus.DISABLE == ((PostWaiver)waiver).getStatus()) continue;
            return false;
        }
        Iterator<PreWaiver> preWaiverIterator = this.fPreWaivers.descendingIterator();
        while (preWaiverIterator.hasNext()) {
            waiver = preWaiverIterator.next();
            if (((PreWaiver)waiver).getType() == WaiverType.RULESET || (!((PreWaiver)waiver).getApplyOn().equals("not-matched") || ((PreWaiver)waiver).getCheckNames().isEmpty() || ((PreWaiver)waiver).matchesCheck(checkName)) && (!((PreWaiver)waiver).getApplyOn().equals("matched") || !((PreWaiver)waiver).getCheckNames().isEmpty() && !((PreWaiver)waiver).matchesCheck(checkName)) || !((PreWaiver)waiver).isCheckPreWaiver()) continue;
            return true;
        }
        return null;
    }

    public boolean hasOnlyReadOnlyWaiverFiles() {
        Set<String> files = this.fFileParsersMap.keySet();
        if (files == null || files.isEmpty()) {
            return false;
        }
        for (String filePath : files) {
            File file = new File(filePath);
            if (file.exists() && !file.canWrite()) continue;
            return false;
        }
        return true;
    }

    public boolean pathIsPrewaived(ParserPath parserPath, OVMComplianceCheck check) {
        PreWaiver preWaiver;
        boolean skipPrewaivers;
        if (parserPath == null) {
            return false;
        }
        if ("none".equals(parserPath.path)) {
            return false;
        }
        boolean bl = skipPrewaivers = !this.fOVMProject.lintProject();
        if (this.fPrewaivedPaths.contains(parserPath.path)) {
            return true;
        }
        if (check != null && this.fCheckPrewaivedPathsMap.containsKey(check) && this.fCheckPrewaivedPathsMap.get(check).contains(parserPath.path)) {
            return true;
        }
        if (check != null && this.fCheckNoMatchPrewaivedPathsMap.containsKey(check) && this.fCheckNoMatchPrewaivedPathsMap.get(check).contains(parserPath.path)) {
            return false;
        }
        if (check != null && !skipPrewaivers) {
            PreWaiver include = check.getIncludePreWaiver();
            PreWaiver exclude = check.getExcludePreWaiver();
            boolean included = false;
            boolean excluded = false;
            if (include != null || exclude != null) {
                if (include != null) {
                    included = include.isPrewaived(parserPath);
                    if (!included) {
                        this.fCheckPrewaivedPathsMap.putIfAbsent(check, new HashSet());
                        this.fCheckPrewaivedPathsMap.get(check).add(parserPath.path);
                        include.addPrewaivedFile(parserPath.path);
                    }
                } else {
                    included = true;
                }
                if (exclude != null) {
                    boolean bl2 = excluded = !exclude.isPrewaived(parserPath);
                    if (!excluded) {
                        this.fCheckPrewaivedPathsMap.putIfAbsent(check, new HashSet());
                        this.fCheckPrewaivedPathsMap.get(check).add(parserPath.path);
                        exclude.addPrewaivedFile(parserPath.path);
                    }
                } else {
                    excluded = true;
                }
                if (!included || !excluded) {
                    return true;
                }
            }
        }
        Iterator<PreWaiver> iterator = this.fPreWaivers.descendingIterator();
        while (iterator.hasNext()) {
            preWaiver = iterator.next();
            if (preWaiver.getType() == WaiverType.RULESET || skipPrewaivers && preWaiver.getType() == WaiverType.FILE || !preWaiver.getApplyOn().equals("matched")) continue;
            if (check != null && preWaiver.isPrewaived(parserPath) && preWaiver.matchesCheck(check.getName())) {
                this.fCheckPrewaivedPathsMap.putIfAbsent(check, new HashSet());
                this.fCheckPrewaivedPathsMap.get(check).add(parserPath.path);
                preWaiver.addPrewaivedFile(parserPath.path);
                return true;
            }
            if (!preWaiver.isPrewaived(parserPath) || !preWaiver.getCheckNames().isEmpty()) continue;
            this.fPrewaivedPaths.add(parserPath.path);
            preWaiver.addPrewaivedFile(parserPath.path);
            return true;
        }
        iterator = this.fPreWaivers.descendingIterator();
        while (iterator.hasNext()) {
            preWaiver = iterator.next();
            if (skipPrewaivers && preWaiver.getType() == WaiverType.FILE || preWaiver.getType() == WaiverType.RULESET || !preWaiver.getApplyOn().equals("not-matched") || preWaiver.getType() == WaiverType.READ_ONLY && "Lint modified files".equals(preWaiver.getName()) && VerissimoAfterCompilationLauncher.getInstance().isEnabled(this.fOVMProject.getProject(), true) && check != null && !check.isApplicableAfterIncremental()) continue;
            if (!(check == null || preWaiver.getCheckNames().isEmpty() || preWaiver.getPaths().isEmpty() && preWaiver.getElements().isEmpty() || preWaiver.isPrewaived(parserPath) && preWaiver.matchesCheck(check.getName()))) {
                this.fCheckPrewaivedPathsMap.putIfAbsent(check, new HashSet());
                this.fCheckPrewaivedPathsMap.get(check).add(parserPath.path);
                preWaiver.addPrewaivedFile(parserPath.path);
                return true;
            }
            if (preWaiver.isPrewaived(parserPath) || !preWaiver.getCheckNames().isEmpty()) continue;
            this.fPrewaivedPaths.add(parserPath.path);
            preWaiver.addPrewaivedFile(parserPath.path);
            return true;
        }
        this.fCheckNoMatchPrewaivedPathsMap.putIfAbsent(check, new HashSet());
        this.fCheckNoMatchPrewaivedPathsMap.get(check).add(parserPath.path);
        return false;
    }

    public void parseWaiversXML(boolean clearWaivers) {
        if (this.fOVMProject == null) {
            return;
        }
        if (clearWaivers) {
            this.clearWaivers();
        }
        LinkedHashMap<String, List<String>> inexistentFiles = new LinkedHashMap<String, List<String>>();
        WaiversXMLParser.resetUnresolvedVariables();
        if (this.fFile != null) {
            WaiversXMLParser.createParsers(this.fOVMProject.getProject(), this.fFileParsersMap, WaiversXMLParser.resolvePath(this.fFile.getAbsolutePath(), null, false), null, inexistentFiles);
        }
        try {
            LinkedList<WaiversXMLParser> parsers = new LinkedList<WaiversXMLParser>(this.fFileParsersMap.values());
            Iterator<WaiversXMLParser> iterator = parsers.descendingIterator();
            while (iterator.hasNext()) {
                iterator.next().load();
            }
        }
        catch (XMLException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            if (this.fFile != null) {
                throw new XMLException((Throwable)e, this.fFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        Map<String, List<String>> unresolvedVariables = WaiversXMLParser.getUnresolvedVariables();
        OVMUtils.parseProblem(this.fOVMProject.getProject(), unresolvedVariables, "unresolved environment variables", true, false);
        OVMUtils.parseProblem(this.fOVMProject.getProject(), inexistentFiles, "non existent files", true, false);
        if (clearWaivers) {
            this.clearWaivers();
        }
    }

    public void setWaiversFile(File file) {
        this.fFile = file;
    }

    public String getWaiversFile() {
        String canonical;
        block4: {
            if (this.fFile == null) {
                return "";
            }
            try {
                canonical = this.fFile.getCanonicalPath();
                if (canonical != null) break block4;
                return "";
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "";
            }
        }
        return canonical;
    }

    public PreWaiver createPrewaiverForFiles(Set<ParserPath> modifiedFiles, ArrayList<OVMComplianceCheck> checks) {
        PreWaiver preWaiver = new PreWaiver();
        preWaiver.setType(WaiverType.READ_ONLY);
        preWaiver.setName("Lint modified files");
        preWaiver.setPathRegexType("simple");
        preWaiver.setApplyOn("not-matched");
        for (ParserPath file : modifiedFiles) {
            preWaiver.addPath(file.path);
            preWaiver.addRawPath(file.path);
        }
        for (OVMComplianceCheck check : checks) {
            if (!check.isApplicableAfterIncremental()) continue;
            preWaiver.addCheckName(check.getName());
        }
        this.addPreWaiver(preWaiver);
        this.computePrewaivedPaths();
        return preWaiver;
    }

    public void clean() {
        if (this.fPostWaivers != null) {
            this.fPostWaivers.clear();
        }
        if (this.fPreWaivers != null) {
            this.fPreWaivers.clear();
        }
        if (this.fFileParsersMap != null) {
            this.fFileParsersMap.clear();
        }
        if (this.fCheckPrewaivedPathsMap != null) {
            this.fCheckPrewaivedPathsMap.clear();
        }
        if (this.fCheckNoMatchPrewaivedPathsMap != null) {
            this.fCheckNoMatchPrewaivedPathsMap.clear();
        }
        if (this.fModifiedFiles != null) {
            this.fModifiedFiles.clear();
        }
        if (this.fPrewaivedPaths != null) {
            this.fPrewaivedPaths.clear();
        }
    }

    public void reapplyWaivers(IWaiver waiver) {
        List<String> checkNames = waiver.getCheckNames();
        if (checkNames == null || checkNames.isEmpty()) {
            for (OVMComplianceCheck check : this.fOVMProject.getChecks()) {
                check.reapplyWaivers();
            }
        } else {
            for (String waiverCheckName : checkNames) {
                OVMComplianceCheck check = this.fOVMProject.getCheck(waiverCheckName);
                if (check == null) continue;
                check.reapplyWaivers();
            }
        }
    }
}

