/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser1;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser2;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser3;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser4;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser5;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser6;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser7;

public abstract class WaiversXMLParser {
    protected static final String TAG_PATH = "path";
    protected static final String TAG_INCLUDE = "include";
    protected static final String ATTR_FILE_PATH_RELATIVE = "relative";
    protected static final String ATTR_FILE_OPTIONAL = "optional";
    protected static final String TAG_UVMF_CUSTOM_PRAGMAS = "uvmf_generated_code";
    private static Map<String, List<String>> fUnresolvedVariables = new LinkedHashMap<String, List<String>>();
    private final String fFilePath;
    private final File fFile;
    protected boolean UVMFCustomPragmaWaiversEnabled;
    protected List<PostWaiver> UVMFCustomPragmaWaivers;
    protected List<WaiverIncludeInfo> fIncludes;
    protected List<WaiverIncludeInfo> fRawIncludes;
    private IProject fProject;
    private static final String LAST_VERSION = "7";

    protected WaiversXMLParser(IProject project, String filePath) {
        this.fFilePath = filePath;
        this.fFile = new File(filePath);
        this.fIncludes = new ArrayList<WaiverIncludeInfo>();
        this.fProject = project;
        this.UVMFCustomPragmaWaiversEnabled = false;
        this.UVMFCustomPragmaWaivers = new ArrayList<PostWaiver>();
    }

    public abstract void save(List<IWaiver> var1) throws Exception;

    public abstract List<IWaiver> load() throws Exception;

    public boolean areUVMFCustomPragmaWaiversEnabled() {
        return this.UVMFCustomPragmaWaiversEnabled;
    }

    public void setUVMFCustomPragmaWaiversEnabled(boolean areEnabled) {
        this.UVMFCustomPragmaWaiversEnabled = areEnabled;
    }

    public List<PostWaiver> getUVMFCustomPragmaWaivers() {
        return this.UVMFCustomPragmaWaivers;
    }

    public void addUVMFCustomPragmaWaiver(PostWaiver waiver) {
        this.UVMFCustomPragmaWaivers.add(waiver);
    }

    public File getFile() {
        return this.fFile;
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public static void resetUnresolvedVariables() {
        fUnresolvedVariables = new LinkedHashMap<String, List<String>>();
    }

    public static Map<String, List<String>> getUnresolvedVariables() {
        return fUnresolvedVariables;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public boolean hasIncludesInXML() {
        return !this.fIncludes.isEmpty();
    }

    public Integer getLineNumberForWaiverResolvedPath(String resolvedPath) {
        for (WaiverIncludeInfo include : this.fIncludes) {
            if (!include.getPath().equals(resolvedPath)) continue;
            return include.getLineNumber();
        }
        return -1;
    }

    public List<WaiverIncludeInfo> getIncludes() throws Exception {
        if (!this.getFile().exists()) {
            return null;
        }
        if (this.fIncludes.isEmpty()) {
            this.fRawIncludes = new ArrayList<WaiverIncludeInfo>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.getFile()));
            Document document = PositionalXMLReader.readXML((InputStream)stream);
            ((InputStream)stream).close();
            String content = null;
            String rawContent = null;
            NodeList nodes = document.getElementsByTagName(TAG_INCLUDE);
            int i = 0;
            while (i < nodes.getLength()) {
                try {
                    Boolean isRelative = Boolean.valueOf(((Element)nodes.item(i)).getAttribute(ATTR_FILE_PATH_RELATIVE));
                    Boolean isOptional = Boolean.valueOf(((Element)nodes.item(i)).getAttribute(ATTR_FILE_OPTIONAL));
                    content = rawContent = nodes.item(i).getTextContent();
                    content = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)content, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
                    if (content != null) {
                        content = WaiversXMLParser.resolvePath(content.trim(), this.fFilePath, isRelative);
                        Object lineNo = nodes.item(i).getUserData("lineNumber");
                        if (lineNo instanceof String) {
                            Integer lineNumber = Integer.parseInt((String)lineNo);
                            this.fIncludes.add(new WaiverIncludeInfo(content, isRelative, isOptional, lineNumber));
                            this.fRawIncludes.add(new WaiverIncludeInfo(rawContent, isRelative, isOptional, lineNumber));
                        }
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        return this.fIncludes;
    }

    public List<String> getUnresolvedVariables(String canonicalPath) throws Exception {
        String replacedString;
        String includeFile;
        if (!this.getFile().exists()) {
            return null;
        }
        ArrayList<String> unresolvedVariables = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(new File(canonicalPath));
        NodeList nodes = document.getElementsByTagName(TAG_INCLUDE);
        int i = 0;
        while (i < nodes.getLength()) {
            includeFile = nodes.item(i).getTextContent();
            replacedString = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)includeFile, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject().getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
            if (replacedString == null) {
                unresolvedVariables.add(includeFile);
            }
            ++i;
        }
        nodes = document.getElementsByTagName(TAG_PATH);
        i = 0;
        while (i < nodes.getLength()) {
            includeFile = nodes.item(i).getTextContent();
            replacedString = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)includeFile, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject().getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
            if (replacedString == null) {
                unresolvedVariables.add(includeFile);
            }
            ++i;
        }
        return unresolvedVariables;
    }

    protected final void appendIncludes(Element root, Document document) {
        if (this.fRawIncludes != null && !this.fRawIncludes.isEmpty()) {
            for (WaiverIncludeInfo include : this.fRawIncludes) {
                Element elem = document.createElement(TAG_INCLUDE);
                root.appendChild(elem);
                if (include.isRelative().booleanValue()) {
                    elem.setAttribute(ATTR_FILE_PATH_RELATIVE, "true");
                }
                Text text = document.createTextNode(include.getPath());
                elem.appendChild(text);
            }
        }
    }

    public boolean shouldSave() {
        return this.getFile().exists();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaiversXMLParser)) {
            return false;
        }
        WaiversXMLParser other = (WaiversXMLParser)obj;
        return !(this.fFilePath == null ? other.fFilePath != null : !this.fFilePath.equals(other.fFilePath));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fFilePath == null ? 0 : this.fFilePath.hashCode());
        return result;
    }

    public static WaiversXMLParser newParser(IProject project, String filePath, boolean uvmfCustomPragmaWaiverEnabled, boolean useLastVersion) throws Exception {
        WaiversXMLParser parser = WaiversXMLParser.newParser(project, filePath, useLastVersion);
        parser.setUVMFCustomPragmaWaiversEnabled(uvmfCustomPragmaWaiverEnabled);
        return parser;
    }

    public static WaiversXMLParser newParser(IProject project, String filePath, boolean useLastVersion) throws Exception {
        File file = new File(filePath);
        String version = LAST_VERSION;
        if (file.exists()) {
            try {
                version = WaiversXMLParser.detectVersion(file);
            }
            catch (IOException iOException) {
                version = LAST_VERSION;
            }
        }
        if (useLastVersion) {
            return WaiversXMLParser.newParser(project, filePath, LAST_VERSION);
        }
        return WaiversXMLParser.newParser(project, filePath, version);
    }

    private static WaiversXMLParser newParser(IProject project, String filePath, String version) throws Exception {
        if ("1".equals(version)) {
            return new WaiversXMLParser1(project, filePath);
        }
        if ("2".equals(version)) {
            return new WaiversXMLParser2(project, filePath);
        }
        if ("3".equals(version)) {
            return new WaiversXMLParser3(project, filePath);
        }
        if ("4".equals(version)) {
            return new WaiversXMLParser4(project, filePath);
        }
        if ("5".equals(version)) {
            return new WaiversXMLParser5(project, filePath);
        }
        if ("6".equals(version)) {
            return new WaiversXMLParser6(project, filePath);
        }
        if (LAST_VERSION.equals(version)) {
            return new WaiversXMLParser7(project, filePath);
        }
        throw new IllegalArgumentException("Unknown waivers file version " + version + ".");
    }

    private static String detectVersion(File file) throws Exception {
        if (!file.exists()) {
            return LAST_VERSION;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList waiversNodes = document.getElementsByTagName("waivers");
        if (waiversNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)waiversNodes.item(0);
        return waiversNode.getAttribute("version");
    }

    public static void createParsers(IProject project, LinkedHashMap<String, WaiversXMLParser> fParsersMap, String canonicalPath, String parentPath, Map<String, List<String>> inexistentFiles) {
        WaiversXMLParser.createParsers(project, fParsersMap, canonicalPath, parentPath, inexistentFiles, false);
    }

    public static void createParsers(IProject project, LinkedHashMap<String, WaiversXMLParser> fParsersMap, String canonicalPath, String parentPath, Map<String, List<String>> inexistentFiles, boolean isOptional) {
        boolean inexistentFile;
        File file = new File(canonicalPath);
        boolean bl = inexistentFile = parentPath != null && !file.exists();
        if (inexistentFile && !isOptional) {
            if (!inexistentFiles.containsKey(parentPath)) {
                children = new ArrayList<String>();
                children.add(canonicalPath);
                inexistentFiles.put(parentPath, children);
            } else {
                children = inexistentFiles.get(parentPath);
                children.add(canonicalPath);
                inexistentFiles.put(parentPath, children);
            }
        }
        WaiversXMLParser parser = null;
        try {
            parser = WaiversXMLParser.newParser(project, canonicalPath, false);
        }
        catch (IOException | IllegalArgumentException | SAXException e) {
            throw new XMLException((Throwable)e, file.getAbsolutePath());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (parser != null && !fParsersMap.containsKey(canonicalPath) && !fParsersMap.containsValue(parser)) {
            if (!inexistentFile) {
                fParsersMap.put(canonicalPath, parser);
            }
            try {
                List<WaiverIncludeInfo> includes;
                List<String> unresolvedVariables = parser.getUnresolvedVariables(canonicalPath);
                if (unresolvedVariables != null && !unresolvedVariables.isEmpty()) {
                    List<String> variables = fUnresolvedVariables.get(canonicalPath);
                    if (variables == null) {
                        variables = new ArrayList<String>();
                    }
                    variables.addAll(unresolvedVariables);
                    fUnresolvedVariables.put(canonicalPath, variables);
                }
                if ((includes = parser.getIncludes()) != null && !includes.isEmpty()) {
                    for (WaiverIncludeInfo include : includes) {
                        WaiversXMLParser.createParsers(project, fParsersMap, include.getPath(), canonicalPath, inexistentFiles, include.isOptional);
                    }
                }
            }
            catch (IOException | IllegalArgumentException | SAXException e) {
                throw new XMLException((Throwable)e, file.getAbsolutePath());
            }
            catch (XMLException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public static String resolvePath(String filePath, String parentFilePath, boolean isRelative) {
        String expandedPath;
        File parentFile;
        if (isRelative && parentFilePath != null && !parentFilePath.isEmpty() && (parentFile = new File(parentFilePath)).getParentFile() != null) {
            String absolutePath = parentFile.getParentFile().getPath();
            filePath = String.valueOf(absolutePath) + DVTFileUtils.FILE_SEPARATOR + filePath;
        }
        if ((expandedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)filePath.trim())) == null) {
            expandedPath = filePath.trim();
        }
        File file = new File(expandedPath);
        String canonicalPath = null;
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            canonicalPath = file.getAbsolutePath();
        }
        return canonicalPath;
    }

    protected static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    protected static class WaiverIncludeInfo {
        String path;
        Boolean isRelative;
        Boolean isOptional;
        Integer lineNumber;

        public WaiverIncludeInfo(String path, Boolean isRelative, Boolean isOptional, Integer lineNumber) {
            this.path = path;
            this.isRelative = isRelative;
            this.isOptional = isOptional;
            this.lineNumber = lineNumber;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public String getPath() {
            return this.path;
        }

        public Boolean isRelative() {
            return this.isRelative;
        }

        public Boolean isOptional() {
            return this.isOptional;
        }
    }
}

