/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.dvt.utils.XMLValidator;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser;

public class WaiversXMLParser2
extends WaiversXMLParser {
    public static final String VERSION_ID = "2";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String TAG_WAIVERS = "waivers";
    private static final String TAG_WAIVER = "waiver";
    private static final String TAG_STATUS = "status";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_CHECKS = "checks";
    private static final String TAG_CHECK = "check";
    private static final String TAG_PATHS = "paths";
    private static final String TAG_PATH = "path";
    private static final String TAG_LINE_RANGES = "line-ranges";
    private static final String TAG_LINE_RANGE = "line-range";

    public WaiversXMLParser2(IProject project, String path) {
        super(project, path);
    }

    @Override
    public void save(List<IWaiver> waivers) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.newDocument();
        Element elem = document.createElement(TAG_WAIVERS);
        document.appendChild(elem);
        elem.setAttribute(ATTR_VERSION, VERSION_ID);
        this.appendWaiverNodes(waivers, elem, document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendWaiverNodes(List<IWaiver> waivers, Element root, Document document) {
        this.appendIncludes(root, document);
        for (IWaiver waiver : waivers) {
            if (waiver instanceof PreWaiver) continue;
            Element elem = document.createElement(TAG_WAIVER);
            root.appendChild(elem);
            elem.setAttribute(ATTR_NAME, waiver.getName());
            this.appendStatusNode(((PostWaiver)waiver).getStatus(), elem, document);
            this.appendDescriptionNode(waiver.getDescription(), elem, document);
            this.appendPathNodes(waiver.getRawPaths(), elem, document);
            this.appendCheckIDNodes(((PostWaiver)waiver).getCheckNames(), elem, document);
            this.appendLineRangeNodes(((PostWaiver)waiver).getLineRanges(), elem, document);
        }
    }

    private void appendStatusNode(WaiverStatus status, Element root, Document document) {
        Element elem = document.createElement(TAG_STATUS);
        root.appendChild(elem);
        Text text = document.createTextNode(status.toString());
        elem.appendChild(text);
    }

    private void appendDescriptionNode(String description, Element root, Document document) {
        if (description.isEmpty()) {
            return;
        }
        Element elem = document.createElement(TAG_DESCRIPTION);
        root.appendChild(elem);
        Text text = document.createTextNode(description);
        elem.appendChild(text);
    }

    private void appendPathNodes(List<String> paths, Element root, Document document) {
        Element elem;
        if (paths.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_PATHS);
            root.appendChild(elem);
        }
        for (String path : paths) {
            Element subelem = document.createElement(TAG_PATH);
            elem.appendChild(subelem);
            Text text = document.createTextNode(path);
            subelem.appendChild(text);
        }
    }

    private void appendCheckIDNodes(List<String> checkIDs, Element root, Document document) {
        Element elem;
        if (checkIDs.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_CHECKS);
            root.appendChild(elem);
        }
        for (String checkID : checkIDs) {
            Element subelem = document.createElement(TAG_CHECK);
            elem.appendChild(subelem);
            Text text = document.createTextNode(checkID);
            subelem.appendChild(text);
        }
    }

    private void appendLineRangeNodes(List<LineRange> lineRanges, Element root, Document document) {
        Element elem;
        if (lineRanges.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_LINE_RANGES);
            root.appendChild(elem);
        }
        for (LineRange lineRange : lineRanges) {
            Element subelem = document.createElement(TAG_LINE_RANGE);
            elem.appendChild(subelem);
            Text text = document.createTextNode(lineRange.toString());
            subelem.appendChild(text);
        }
    }

    @Override
    public List<IWaiver> load() throws Exception {
        LinkedList<IWaiver> waivers = new LinkedList<IWaiver>();
        if (!this.getFile().exists()) {
            return waivers;
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.getFile()));
        Document document = PositionalXMLReader.readXML((InputStream)stream);
        ((InputStream)stream).close();
        NodeList nodeList = null;
        Element elem = null;
        String content = null;
        LineRange lineRange = null;
        NodeList waiversNodes = document.getElementsByTagName(TAG_WAIVERS);
        XMLValidator.checkUniqueRootNode((NodeList)waiversNodes, (String)TAG_WAIVERS, (String)this.getFilePath());
        Element waiversElement = (Element)waiversNodes.item(0);
        XMLValidator.checkChildren((Element)waiversElement, new HashSet<String>(Arrays.asList("include", TAG_WAIVER)), (String)this.getFilePath());
        XMLValidator.checkAttributes((Element)waiversElement, new HashSet<String>(Arrays.asList(ATTR_VERSION)), (String)this.getFilePath());
        NodeList nodes = waiversElement.getElementsByTagName(TAG_WAIVER);
        int i = 0;
        while (i < nodes.getLength()) {
            PostWaiver waiver = new PostWaiver();
            waiver.setFilePath(this.getFilePath());
            elem = (Element)nodes.item(i);
            XMLValidator.checkAttributes((Element)elem, new HashSet<String>(Arrays.asList(ATTR_NAME)), (String)this.getFilePath());
            XMLValidator.checkChildren((Element)elem, new HashSet<String>(Arrays.asList(TAG_STATUS, TAG_DESCRIPTION, TAG_PATHS, TAG_PATH, TAG_CHECKS, TAG_CHECK, TAG_LINE_RANGES, TAG_LINE_RANGE)), (String)this.getFilePath());
            String name = elem.getAttribute(ATTR_NAME);
            if (name == null || name.equals("")) {
                Object lineNumber = elem.getUserData("lineNumber");
                int line = 0;
                if (lineNumber instanceof String) {
                    line = Integer.parseInt((String)lineNumber);
                }
                SAXParseException saxParseException = new SAXParseException("Waiver has no name attribute", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)saxParseException, this.getFilePath());
            }
            waiver.setName(name);
            Object lineNo = elem.getUserData("lineNumber");
            if (lineNo instanceof String) {
                waiver.setLineNoInXMLFile(Integer.valueOf((String)lineNo));
            }
            NodeList statusNodes = elem.getElementsByTagName(TAG_STATUS);
            XMLValidator.checkMandatoryUniqueElement((NodeList)statusNodes, (String)TAG_STATUS, (String)TAG_WAIVER, (Element)elem, (String)this.getFilePath());
            Element statusElement = (Element)statusNodes.item(0);
            if (statusElement != null && (content = statusElement.getTextContent()) != null) {
                WaiverStatus status = WaiverStatus.from(content);
                if (status == WaiverStatus.NONE) {
                    throw new IllegalArgumentException("Invalid status '" + content + "', use only DISABLE, ERROR, WARNING, INFO!");
                }
                waiver.setStatus(status);
                NodeList descriptionNodes = elem.getElementsByTagName(TAG_DESCRIPTION);
                XMLValidator.checkOptionalOneElement((NodeList)descriptionNodes, (String)TAG_DESCRIPTION, (String)TAG_WAIVER, (Element)elem, (String)this.getFilePath());
                Element descriptionElement = (Element)descriptionNodes.item(0);
                if (descriptionElement != null && (content = descriptionElement.getTextContent()) != null) {
                    waiver.setDescription(content);
                }
                waiver.setPathRegexType("simple");
                nodeList = elem.getElementsByTagName(TAG_PATH);
                int j = 0;
                while (j < nodeList.getLength()) {
                    content = nodeList.item(j).getTextContent();
                    if (content != null) {
                        waiver.addRawPath(DVTStringUtil.intern((String)Utils.canonicPath((String)content)));
                        waiver.addPath(DVTStringUtil.intern((String)Utils.canonicPath((String)DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)content, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION)))));
                    }
                    ++j;
                }
                nodeList = elem.getElementsByTagName(TAG_CHECK);
                j = 0;
                while (j < nodeList.getLength()) {
                    content = nodeList.item(j).getTextContent();
                    if (content != null) {
                        waiver.addCheckName(content);
                    }
                    ++j;
                }
                nodeList = elem.getElementsByTagName(TAG_LINE_RANGE);
                j = 0;
                while (j < nodeList.getLength()) {
                    block16: {
                        content = nodeList.item(j).getTextContent();
                        if (content != null) {
                            try {
                                lineRange = new LineRange(content);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                break block16;
                            }
                            waiver.addLineRange(lineRange);
                        }
                    }
                    ++j;
                }
                waivers.add(waiver);
            }
            ++i;
        }
        return waivers;
    }
}

