/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.dvt.utils.XMLValidator;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.MessagePattern;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser;

public class WaiversXMLParser6
extends WaiversXMLParser {
    public static final String VERSION_ID = "6";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_APPLY_ON = "apply-on";
    private static final String TAG_WAIVERS = "waivers";
    private static final String TAG_WAIVER = "waiver";
    private static final String TAG_PRE_WAIVER = "pre-waiver";
    private static final String TAG_STATUS = "status";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_CHECKS = "checks";
    private static final String TAG_CHECK = "check";
    private static final String TAG_PATHS = "paths";
    private static final String TAG_PATH = "path";
    private static final String TAG_LINE_RANGES = "line-ranges";
    private static final String TAG_LINE_RANGE = "line-range";
    private static final String TAG_MESSAGE_PATTERNS = "message-patterns";
    private static final String TAG_MESSAGE_PATTERN = "message-pattern";
    private static final String ATTR_REGEX = "regex";
    private static final String ATTR_MACRO_PATH = "macro-path";

    public WaiversXMLParser6(IProject project, String path) {
        super(project, path);
    }

    @Override
    public void save(List<IWaiver> waivers) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.newDocument();
        Element elem = document.createElement(TAG_WAIVERS);
        document.appendChild(elem);
        elem.setAttribute(ATTR_VERSION, VERSION_ID);
        this.appendWaiverNodes(waivers, elem, document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendWaiverNodes(List<IWaiver> waivers, Element root, Document document) {
        this.appendIncludes(root, document);
        for (IWaiver waiver : waivers) {
            Element elem;
            if (waiver instanceof PostWaiver) {
                if (waiver.getType() == WaiverType.UVMF_CUSTOM_PRAGMA) {
                    elem = document.createElement("uvmf_generated_code");
                    root.appendChild(elem);
                    this.addUVMFCustomPragmaWaiverAttributesAndNodes(document, waiver, elem);
                    continue;
                }
                elem = document.createElement(TAG_WAIVER);
                root.appendChild(elem);
                elem.setAttribute(ATTR_NAME, waiver.getName());
                elem.setAttribute(ATTR_REGEX, waiver.getRegexType());
                elem.setAttribute(ATTR_APPLY_ON, waiver.getApplyOn());
                if (((PostWaiver)waiver).isInsideMacroPath()) {
                    elem.setAttribute(ATTR_MACRO_PATH, "true");
                }
                this.appendStatusNode(((PostWaiver)waiver).getStatus(), elem, document);
                this.appendDescriptionNode(waiver.getDescription(), elem, document);
                this.appendPathNodes(waiver.getRawPaths(), elem, document);
                this.appendCheckIDNodes(((PostWaiver)waiver).getCheckNames(), elem, document);
                this.appendLineRangeNodes(((PostWaiver)waiver).getLineRanges(), elem, document);
                this.appendMessagePatternNodes(((PostWaiver)waiver).getMessagePatterns(), elem, document);
                continue;
            }
            if (!(waiver instanceof PreWaiver)) continue;
            elem = document.createElement(TAG_PRE_WAIVER);
            root.appendChild(elem);
            elem.setAttribute(ATTR_NAME, waiver.getName());
            elem.setAttribute(ATTR_APPLY_ON, waiver.getApplyOn());
            this.appendDescriptionNode(waiver.getDescription(), elem, document);
            this.appendPathNodes(waiver.getRawPaths(), elem, document);
        }
    }

    private void addUVMFCustomPragmaWaiverAttributesAndNodes(Document document, IWaiver waiver, Element elem) {
        this.appendPathNodes(waiver.getRawPaths(), elem, document);
        this.appendCheckIDNodes(((PostWaiver)waiver).getUVMFCheckNames(), elem, document);
    }

    private void appendStatusNode(WaiverStatus status, Element root, Document document) {
        Element elem = document.createElement(TAG_STATUS);
        root.appendChild(elem);
        Text text = document.createTextNode(status.toString());
        elem.appendChild(text);
    }

    private void appendDescriptionNode(String description, Element root, Document document) {
        if (description.isEmpty()) {
            return;
        }
        Element elem = document.createElement(TAG_DESCRIPTION);
        root.appendChild(elem);
        Text text = document.createTextNode(description);
        elem.appendChild(text);
    }

    private void appendPathNodes(List<String> paths, Element root, Document document) {
        Element elem;
        if (paths.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_PATHS);
            root.appendChild(elem);
        }
        for (String path : paths) {
            Element subelem = document.createElement(TAG_PATH);
            elem.appendChild(subelem);
            Text text = document.createTextNode(path);
            subelem.appendChild(text);
        }
    }

    private void appendCheckIDNodes(List<String> checkIDs, Element root, Document document) {
        Element elem;
        if (checkIDs.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_CHECKS);
            root.appendChild(elem);
        }
        for (String checkID : checkIDs) {
            Element subelem = document.createElement(TAG_CHECK);
            elem.appendChild(subelem);
            Text text = document.createTextNode(checkID);
            subelem.appendChild(text);
        }
    }

    private void appendLineRangeNodes(List<LineRange> lineRanges, Element root, Document document) {
        Element elem;
        if (lineRanges.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_LINE_RANGES);
            root.appendChild(elem);
        }
        for (LineRange lineRange : lineRanges) {
            Element subelem = document.createElement(TAG_LINE_RANGE);
            elem.appendChild(subelem);
            Text text = document.createTextNode(lineRange.toString());
            subelem.appendChild(text);
        }
    }

    private void appendMessagePatternNodes(List<MessagePattern> messagePatterns, Element root, Document document) {
        Element elem;
        if (messagePatterns.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_MESSAGE_PATTERNS);
            root.appendChild(elem);
        }
        for (MessagePattern messagePattern : messagePatterns) {
            Element subelem = document.createElement(TAG_MESSAGE_PATTERN);
            elem.appendChild(subelem);
            Text text = document.createTextNode(messagePattern.toString());
            subelem.appendChild(text);
        }
    }

    @Override
    public List<IWaiver> load() throws Exception {
        Object lineNo;
        LinkedList<IWaiver> waivers = new LinkedList<IWaiver>();
        if (!this.getFile().exists()) {
            return waivers;
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.getFile()));
        Document document = PositionalXMLReader.readXML((InputStream)stream);
        ((InputStream)stream).close();
        IWaiver waiver = null;
        NodeList nodeList = null;
        Element elem = null;
        Element subElem = null;
        String name = null;
        String content = null;
        String regexType = null;
        String applyOn = null;
        String macroPath = null;
        LineRange lineRange = null;
        MessagePattern messagePattern = null;
        WaiverStatus status = null;
        NodeList waiversNodes = document.getElementsByTagName(TAG_WAIVERS);
        XMLValidator.checkUniqueRootNode((NodeList)waiversNodes, (String)TAG_WAIVERS, (String)this.getFilePath());
        Element waiversElement = (Element)waiversNodes.item(0);
        XMLValidator.checkChildren((Element)waiversElement, new HashSet<String>(Arrays.asList("include", TAG_WAIVER, TAG_PRE_WAIVER, "uvmf_generated_code")), (String)this.getFilePath());
        XMLValidator.checkAttributes((Element)waiversElement, new HashSet<String>(Arrays.asList(ATTR_VERSION)), (String)this.getFilePath());
        NodeList uvmfCustomPragmaNodes = waiversElement.getElementsByTagName("uvmf_generated_code");
        this.UVMFCustomPragmaWaiversEnabled = uvmfCustomPragmaNodes.getLength() != 0;
        int i = 0;
        while (i < uvmfCustomPragmaNodes.getLength()) {
            waiver = new PostWaiver();
            waiver.setFilePath(this.getFilePath());
            Element pragmaElement = (Element)uvmfCustomPragmaNodes.item(i);
            XMLValidator.checkChildren((Element)pragmaElement, new HashSet<String>(Arrays.asList(TAG_PATHS, TAG_PATH, TAG_CHECKS, TAG_CHECK)), (String)this.getFilePath());
            lineNo = pragmaElement.getUserData("lineNumber");
            if (lineNo instanceof String) {
                waiver.setLineNoInXMLFile(Integer.valueOf((String)lineNo));
            }
            waiver.setName("Waive all UVMF Custom Pragmas");
            ((PostWaiver)waiver).setStatus(WaiverStatus.DISABLE);
            waiver.setType(WaiverType.UVMF_CUSTOM_PRAGMA);
            waiver.setDescription("This waiver will erase all failures from files specified inside the <uvmf_generated_code> tag.");
            NodeList pragmaPathsNodes = pragmaElement.getElementsByTagName(TAG_PATHS);
            XMLValidator.checkOptionalOneElement((NodeList)pragmaPathsNodes, (String)TAG_PATHS, (String)"uvmf_generated_code", (Element)pragmaElement, (String)this.getFilePath());
            Element pragmaPathsElement = (Element)pragmaPathsNodes.item(0);
            if (pragmaPathsElement != null) {
                XMLValidator.checkAttributes((Element)pragmaPathsElement, new HashSet<String>(Arrays.asList(ATTR_REGEX)), (String)this.getFilePath());
                regexType = pragmaPathsElement.getAttribute(ATTR_REGEX);
                if (!IWaiver.isValidRegexType(regexType)) {
                    throw new IllegalArgumentException("Invalid path pattern regex type '" + regexType.trim() + "', it must be " + Arrays.toString(IWaiver.REGEX_TYPES) + "!");
                }
                waiver.setPathRegexType(regexType);
                XMLValidator.checkChildren((Element)pragmaPathsElement, new HashSet<String>(Arrays.asList(TAG_PATH)), (String)this.getFilePath());
            }
            boolean isSimpleRegexPragma = regexType == null || regexType.equals("simple");
            nodeList = pragmaElement.getElementsByTagName(TAG_PATH);
            int j = 0;
            while (j < nodeList.getLength()) {
                subElem = (Element)nodeList.item(j);
                content = subElem.getTextContent();
                if (content != null) {
                    String rawPath = isSimpleRegexPragma ? DVTStringUtil.intern((String)Utils.canonicPath((String)content)) : DVTStringUtil.intern((String)content);
                    String path = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)content, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
                    path = isSimpleRegexPragma ? DVTStringUtil.intern((String)Utils.canonicPath((String)path)) : DVTStringUtil.intern((String)path);
                    waiver.addRawPath(rawPath);
                    waiver.addPath(path);
                }
                ++j;
            }
            nodeList = pragmaElement.getElementsByTagName(TAG_CHECK);
            j = 0;
            while (j < nodeList.getLength()) {
                content = nodeList.item(j).getTextContent();
                if (content != null) {
                    ((PostWaiver)waiver).addUVMFCheckName(content);
                }
                ++j;
            }
            this.UVMFCustomPragmaWaivers.add((PostWaiver)waiver);
            ++i;
        }
        NodeList nodes = waiversElement.getElementsByTagName(TAG_WAIVER);
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            waiver = new PostWaiver();
            waiver.setFilePath(this.getFilePath());
            elem = (Element)nodes.item(i2);
            XMLValidator.checkAttributes((Element)elem, new HashSet<String>(Arrays.asList(ATTR_NAME, ATTR_APPLY_ON, ATTR_MACRO_PATH, ATTR_REGEX)), (String)this.getFilePath());
            XMLValidator.checkChildren((Element)elem, new HashSet<String>(Arrays.asList(TAG_STATUS, TAG_DESCRIPTION, TAG_PATHS, TAG_PATH, TAG_CHECKS, TAG_CHECK, TAG_LINE_RANGES, TAG_LINE_RANGE, TAG_MESSAGE_PATTERNS, TAG_MESSAGE_PATTERN)), (String)this.getFilePath());
            name = elem.getAttribute(ATTR_NAME);
            if (name == null || name.equals("")) {
                Object lineNumber = elem.getUserData("lineNumber");
                int line = 0;
                if (lineNumber instanceof String) {
                    line = Integer.parseInt((String)lineNumber);
                }
                SAXParseException saxParseException = new SAXParseException("Waiver has no name attribute", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)saxParseException, this.getFilePath());
            }
            waiver.setName(name);
            lineNo = elem.getUserData("lineNumber");
            if (lineNo instanceof String) {
                waiver.setLineNoInXMLFile(Integer.valueOf((String)lineNo));
            }
            if (!IWaiver.isValidRegexType(regexType = elem.getAttribute(ATTR_REGEX))) {
                throw new IllegalArgumentException("Invalid message pattern regex type '" + regexType.trim() + "', it must be " + Arrays.toString(IWaiver.REGEX_TYPES) + "!");
            }
            waiver.setPathRegexType("simple");
            ((PostWaiver)waiver).setMessageRegexType(regexType);
            applyOn = elem.getAttribute(ATTR_APPLY_ON);
            if (!IWaiver.isValidApplyOn(applyOn)) {
                throw new IllegalArgumentException("Invalid apply-on scope '" + applyOn.trim() + "', it must be " + Arrays.toString(IWaiver.APPLY_ON_TYPES) + "!");
            }
            waiver.setApplyOn(applyOn);
            macroPath = elem.getAttribute(ATTR_MACRO_PATH);
            if ("true".equalsIgnoreCase(macroPath)) {
                ((PostWaiver)waiver).setInsideMacroPath(true);
            } else if (macroPath == null || macroPath.isEmpty() || "false".equalsIgnoreCase(macroPath)) {
                ((PostWaiver)waiver).setInsideMacroPath(false);
            } else {
                throw new IllegalArgumentException("Invalid macro path '" + macroPath.trim() + "', it must be 'true' or 'false'!");
            }
            NodeList statusNodes = elem.getElementsByTagName(TAG_STATUS);
            XMLValidator.checkMandatoryUniqueElement((NodeList)statusNodes, (String)TAG_STATUS, (String)TAG_WAIVER, (Element)elem, (String)this.getFilePath());
            Element statusElement = (Element)statusNodes.item(0);
            if (statusElement != null && (content = statusElement.getTextContent()) != null) {
                status = WaiverStatus.from(content);
                if (status == WaiverStatus.NONE) {
                    throw new IllegalArgumentException("Invalid status '" + content + "', use only DISABLE, ERROR, WARNING, INFO!");
                }
                ((PostWaiver)waiver).setStatus(status);
                NodeList descriptionNodes = elem.getElementsByTagName(TAG_DESCRIPTION);
                XMLValidator.checkOptionalOneElement((NodeList)descriptionNodes, (String)TAG_DESCRIPTION, (String)TAG_WAIVER, (Element)elem, (String)this.getFilePath());
                Element descriptionElement = (Element)descriptionNodes.item(0);
                if (descriptionElement != null && (content = descriptionElement.getTextContent()) != null) {
                    waiver.setDescription(content);
                }
                nodeList = elem.getElementsByTagName(TAG_PATH);
                int j = 0;
                while (j < nodeList.getLength()) {
                    content = nodeList.item(j).getTextContent();
                    if (content != null) {
                        waiver.addRawPath(DVTStringUtil.intern((String)Utils.canonicPath((String)content)));
                        waiver.addPath(DVTStringUtil.intern((String)Utils.canonicPath((String)DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)content, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION)))));
                    }
                    ++j;
                }
                nodeList = elem.getElementsByTagName(TAG_CHECK);
                j = 0;
                while (j < nodeList.getLength()) {
                    content = nodeList.item(j).getTextContent();
                    if (content != null) {
                        ((PostWaiver)waiver).addCheckName(content);
                    }
                    ++j;
                }
                nodeList = elem.getElementsByTagName(TAG_LINE_RANGE);
                j = 0;
                while (j < nodeList.getLength()) {
                    content = nodeList.item(j).getTextContent();
                    if (content != null) {
                        lineRange = new LineRange(content);
                        ((PostWaiver)waiver).addLineRange(lineRange);
                    }
                    ++j;
                }
                nodeList = elem.getElementsByTagName(TAG_MESSAGE_PATTERN);
                j = 0;
                while (j < nodeList.getLength()) {
                    subElem = (Element)nodeList.item(j);
                    content = subElem.getTextContent();
                    if (content != null) {
                        messagePattern = new MessagePattern(content, ((PostWaiver)waiver).getMessageRegexType().equals("simple"));
                        ((PostWaiver)waiver).addMessagePattern(messagePattern);
                    }
                    ++j;
                }
                waivers.add(waiver);
            }
            ++i2;
        }
        NodeList preWaiverNodes = waiversElement.getElementsByTagName(TAG_PRE_WAIVER);
        int i3 = 0;
        while (i3 < preWaiverNodes.getLength()) {
            waiver = new PreWaiver();
            waiver.setFilePath(this.getFilePath());
            elem = (Element)preWaiverNodes.item(i3);
            XMLValidator.checkAttributes((Element)elem, new HashSet<String>(Arrays.asList(ATTR_NAME, ATTR_APPLY_ON)), (String)this.getFilePath());
            XMLValidator.checkChildren((Element)elem, new HashSet<String>(Arrays.asList(TAG_DESCRIPTION, TAG_PATHS, TAG_PATH)), (String)this.getFilePath());
            name = elem.getAttribute(ATTR_NAME);
            if (name != null && !name.equals("")) {
                waiver.setName(name);
                Object lineNo2 = elem.getUserData("lineNumber");
                if (lineNo2 instanceof String) {
                    waiver.setLineNoInXMLFile(Integer.valueOf((String)lineNo2));
                }
                if (!IWaiver.isValidApplyOn(applyOn = elem.getAttribute(ATTR_APPLY_ON))) {
                    throw new IllegalArgumentException("Invalid apply-on scope '" + applyOn.trim() + "', it must be " + Arrays.toString(IWaiver.APPLY_ON_TYPES) + "!");
                }
                waiver.setApplyOn(applyOn);
                subElem = (Element)elem.getElementsByTagName(TAG_DESCRIPTION).item(0);
                if (subElem != null && (content = subElem.getTextContent()) != null) {
                    waiver.setDescription(content);
                }
                waiver.setPathRegexType("simple");
                nodeList = elem.getElementsByTagName(TAG_PATH);
                int j = 0;
                while (j < nodeList.getLength()) {
                    content = nodeList.item(j).getTextContent();
                    if (content != null) {
                        waiver.addRawPath(DVTStringUtil.intern((String)Utils.canonicPath((String)content)));
                        waiver.addPath(DVTStringUtil.intern((String)Utils.canonicPath((String)DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)content, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION)))));
                    }
                    ++j;
                }
                waivers.add(waiver);
            }
            ++i3;
        }
        return waivers;
    }
}

