/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.waivers;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.dvt.utils.XMLValidator;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.MessagePattern;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.linter.waivers.WaiversXMLParser;

public class WaiversXMLParser7
extends WaiversXMLParser {
    public static final String VERSION_ID = "7";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_APPLY_ON = "apply-on";
    private static final String TAG_WAIVERS = "waivers";
    private static final String TAG_WAIVER = "waiver";
    private static final String TAG_PRE_WAIVER = "pre-waiver";
    private static final String TAG_STATUS = "status";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_CHECKS = "checks";
    private static final String TAG_CHECK = "check";
    private static final String TAG_PATHS = "paths";
    private static final String TAG_PATH = "path";
    private static final String TAG_LINE_RANGES = "line-ranges";
    private static final String TAG_LINE_RANGE = "line-range";
    private static final String TAG_MESSAGE_PATTERNS = "message-patterns";
    private static final String TAG_MESSAGE_PATTERN = "message-pattern";
    private static final String ATTR_REGEX = "regex";
    private static final String ATTR_MACRO_PATH = "macro-path";
    private static final String TAG_ELEMENTS = "elements";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_ELEMENT_TYPE = "type";
    private static final String TAG_ELEMENT_NAME = "name";
    private static final Set<String> ELEMENT_TYPES = new HashSet<String>(Arrays.asList("module", "interface", "package", "top"));

    public WaiversXMLParser7(IProject project, String path) {
        super(project, path);
    }

    @Override
    public void save(List<IWaiver> waivers) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.newDocument();
        Element elem = document.createElement(TAG_WAIVERS);
        document.appendChild(elem);
        elem.setAttribute(ATTR_VERSION, VERSION_ID);
        this.appendWaiverNodes(waivers, elem, document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendWaiverNodes(List<IWaiver> waivers, Element root, Document document) {
        HashMap<Object, Integer> elems = new HashMap<Object, Integer>();
        if (this.fRawIncludes != null && this.fIncludes != null) {
            if (this.fRawIncludes.size() != this.fIncludes.size()) {
                DVTLogger.INSTANCE.logError("Size mismatch between includes and raw includes for waivers file!");
            }
            int i = 0;
            while (i < this.fRawIncludes.size()) {
                elems.put(this.fRawIncludes.get(i), ((WaiversXMLParser.WaiverIncludeInfo)this.fRawIncludes.get(i)).getLineNumber());
                ++i;
            }
        }
        for (IWaiver waiver : waivers) {
            int line = waiver.getLineNoInXMLFile();
            if (line < 0) {
                line = Integer.MAX_VALUE;
            }
            if (waiver.getType() == WaiverType.UVMF_CUSTOM_PRAGMA && (!(waiver instanceof PostWaiver) || ((PostWaiver)waiver).getStatus() != WaiverStatus.DISABLE)) continue;
            elems.put(waiver, line);
        }
        List sortedElems = elems.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
        for (Object e : sortedElems) {
            Element elem;
            if (e instanceof IWaiver) {
                IWaiver waiver = (IWaiver)e;
                if (waiver instanceof PostWaiver) {
                    if (waiver.getType() == WaiverType.UVMF_CUSTOM_PRAGMA) {
                        elem = document.createElement("uvmf_generated_code");
                        root.appendChild(elem);
                        this.addUVMFCustomPragmaWaiverAttributesAndNodes(document, waiver, elem);
                        continue;
                    }
                    elem = document.createElement(TAG_WAIVER);
                    root.appendChild(elem);
                    this.addPostWaiverAttributesAndNodes(document, waiver, elem);
                    continue;
                }
                if (!(waiver instanceof PreWaiver)) continue;
                elem = document.createElement(TAG_PRE_WAIVER);
                root.appendChild(elem);
                this.addPreWaiverAttributesAndNodes(document, waiver, elem);
                continue;
            }
            if (!(e instanceof WaiversXMLParser.WaiverIncludeInfo)) continue;
            WaiversXMLParser.WaiverIncludeInfo include = (WaiversXMLParser.WaiverIncludeInfo)e;
            elem = document.createElement("include");
            root.appendChild(elem);
            if (include.isRelative().booleanValue()) {
                elem.setAttribute("relative", "true");
            }
            if (include.isOptional.booleanValue()) {
                elem.setAttribute("optional", "true");
            }
            Text text = document.createTextNode(include.getPath());
            elem.appendChild(text);
        }
    }

    private void addUVMFCustomPragmaWaiverAttributesAndNodes(Document document, IWaiver waiver, Element elem) {
        this.appendPathNodes(waiver.getRawPaths(), waiver.getPathRegexType(), waiver.getPathsApplyOn(), elem, document);
        this.appendCheckIDNodes(((PostWaiver)waiver).getUVMFCheckNames(), elem, document);
    }

    private void addPostWaiverAttributesAndNodes(Document document, IWaiver waiver, Element elem) {
        elem.setAttribute("name", waiver.getName());
        elem.setAttribute(ATTR_APPLY_ON, waiver.getApplyOn());
        if (((PostWaiver)waiver).isInsideMacroPath()) {
            elem.setAttribute(ATTR_MACRO_PATH, "true");
        }
        this.appendStatusNode(((PostWaiver)waiver).getStatus(), elem, document);
        this.appendDescriptionNode(waiver.getDescription(), elem, document);
        this.appendPathNodes(waiver.getRawPaths(), waiver.getPathRegexType(), waiver.getPathsApplyOn(), elem, document);
        this.appendElementNodes(((PostWaiver)waiver).getElements(), ((PostWaiver)waiver).getElementsRegexType(), elem, document);
        this.appendCheckIDNodes(((PostWaiver)waiver).getCheckNames(), elem, document);
        this.appendLineRangeNodes(((PostWaiver)waiver).getLineRanges(), elem, document);
        this.appendMessagePatternNodes(((PostWaiver)waiver).getMessagePatterns(), ((PostWaiver)waiver).getMessageRegexType(), elem, document);
    }

    private void addPreWaiverAttributesAndNodes(Document document, IWaiver waiver, Element elem) {
        elem.setAttribute("name", waiver.getName());
        elem.setAttribute(ATTR_APPLY_ON, waiver.getApplyOn());
        this.appendDescriptionNode(waiver.getDescription(), elem, document);
        this.appendPathNodes(waiver.getRawPaths(), waiver.getPathRegexType(), waiver.getPathsApplyOn(), elem, document);
        this.appendCheckIDNodes(((PreWaiver)waiver).getCheckNames(), elem, document);
        this.appendElementNodes(((PreWaiver)waiver).getElements(), ((PreWaiver)waiver).getElementsRegexType(), elem, document);
    }

    private void appendStatusNode(WaiverStatus status, Element root, Document document) {
        Element elem = document.createElement(TAG_STATUS);
        root.appendChild(elem);
        Text text = document.createTextNode(status.toString());
        elem.appendChild(text);
    }

    private void appendDescriptionNode(String description, Element root, Document document) {
        if (description.isEmpty()) {
            return;
        }
        Element elem = document.createElement(TAG_DESCRIPTION);
        root.appendChild(elem);
        Text text = document.createTextNode(description);
        elem.appendChild(text);
    }

    private void appendElementNodes(HashMap<String, String> elements, String elementRegexType, Element root, Document document) {
        if (elements.isEmpty()) {
            return;
        }
        Element elem = document.createElement(TAG_ELEMENTS);
        elem.setAttribute(ATTR_REGEX, elementRegexType);
        root.appendChild(elem);
        for (Map.Entry<String, String> entry : elements.entrySet()) {
            Element subElem = document.createElement(TAG_ELEMENT);
            elem.appendChild(subElem);
            Element elemName = document.createElement(TAG_ELEMENT_TYPE);
            subElem.appendChild(elemName);
            Text text = document.createTextNode(entry.getKey());
            elemName.appendChild(text);
            Element elemType = document.createElement("name");
            subElem.appendChild(elemType);
            text = document.createTextNode(entry.getValue());
            elemType.appendChild(text);
        }
    }

    private void appendPathNodes(List<String> paths, String pathRegexType, String pathsApplyOn, Element root, Document document) {
        if (paths.isEmpty()) {
            return;
        }
        Element elem = document.createElement(TAG_PATHS);
        elem.setAttribute(ATTR_REGEX, pathRegexType);
        elem.setAttribute(ATTR_APPLY_ON, pathsApplyOn);
        root.appendChild(elem);
        for (String path : paths) {
            Element subelem = document.createElement(TAG_PATH);
            elem.appendChild(subelem);
            Text text = document.createTextNode(path);
            subelem.appendChild(text);
        }
    }

    private void appendCheckIDNodes(List<String> checkIDs, Element root, Document document) {
        Element elem;
        if (checkIDs.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_CHECKS);
            root.appendChild(elem);
        }
        for (String checkID : checkIDs) {
            Element subelem = document.createElement(TAG_CHECK);
            elem.appendChild(subelem);
            Text text = document.createTextNode(checkID);
            subelem.appendChild(text);
        }
    }

    private void appendLineRangeNodes(List<LineRange> lineRanges, Element root, Document document) {
        Element elem;
        if (lineRanges.size() <= 1) {
            elem = root;
        } else {
            elem = document.createElement(TAG_LINE_RANGES);
            root.appendChild(elem);
        }
        for (LineRange lineRange : lineRanges) {
            Element subelem = document.createElement(TAG_LINE_RANGE);
            elem.appendChild(subelem);
            Text text = document.createTextNode(lineRange.toString());
            subelem.appendChild(text);
        }
    }

    private void appendMessagePatternNodes(List<MessagePattern> messagePatterns, String messageRegexType, Element root, Document document) {
        if (messagePatterns.isEmpty()) {
            return;
        }
        Element elem = document.createElement(TAG_MESSAGE_PATTERNS);
        elem.setAttribute(ATTR_REGEX, messageRegexType);
        root.appendChild(elem);
        for (MessagePattern messagePattern : messagePatterns) {
            Element subelem = document.createElement(TAG_MESSAGE_PATTERN);
            elem.appendChild(subelem);
            Text text = document.createTextNode(messagePattern.toString());
            subelem.appendChild(text);
        }
    }

    @Override
    public List<IWaiver> load() throws Exception {
        Object lineNo;
        LinkedList<IWaiver> waivers = new LinkedList<IWaiver>();
        if (!this.getFile().exists()) {
            return waivers;
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.getFile()));
        Document document = PositionalXMLReader.readXML((InputStream)stream);
        ((InputStream)stream).close();
        IWaiver waiver = null;
        NodeList nodeList = null;
        Element elem = null;
        Element subElem = null;
        String name = null;
        String content = null;
        String regexType = null;
        String applyOn = null;
        String macroPath = null;
        LineRange lineRange = null;
        WaiverStatus status = null;
        NodeList waiversNodes = document.getElementsByTagName(TAG_WAIVERS);
        XMLValidator.checkUniqueRootNode((NodeList)waiversNodes, (String)TAG_WAIVERS, (String)this.getFilePath());
        Element waiversElement = (Element)waiversNodes.item(0);
        XMLValidator.checkChildren((Element)waiversElement, new HashSet<String>(Arrays.asList("include", TAG_WAIVER, TAG_PRE_WAIVER, "uvmf_generated_code")), (String)this.getFilePath());
        XMLValidator.checkAttributes((Element)waiversElement, new HashSet<String>(Arrays.asList(ATTR_VERSION)), (String)this.getFilePath());
        NodeList uvmfCustomPragmaNodes = waiversElement.getElementsByTagName("uvmf_generated_code");
        this.UVMFCustomPragmaWaiversEnabled = uvmfCustomPragmaNodes.getLength() != 0;
        int i = 0;
        while (i < uvmfCustomPragmaNodes.getLength()) {
            waiver = new PostWaiver();
            waiver.setFilePath(this.getFilePath());
            Element pragmaElement = (Element)uvmfCustomPragmaNodes.item(i);
            XMLValidator.checkChildren((Element)pragmaElement, new HashSet<String>(Arrays.asList(TAG_PATHS, TAG_PATH, TAG_CHECKS, TAG_CHECK)), (String)this.getFilePath());
            Object lineNo2 = pragmaElement.getUserData("lineNumber");
            if (lineNo2 instanceof String) {
                waiver.setLineNoInXMLFile(Integer.valueOf((String)lineNo2));
            }
            waiver.setName("Waive all UVMF Custom Pragmas");
            ((PostWaiver)waiver).setStatus(WaiverStatus.DISABLE);
            waiver.setType(WaiverType.UVMF_CUSTOM_PRAGMA);
            waiver.setDescription("This waiver will erase all failures from files specified inside the <uvmf_generated_code> tag.");
            NodeList pragmaPathsNodes = pragmaElement.getElementsByTagName(TAG_PATHS);
            XMLValidator.checkOptionalOneElement((NodeList)pragmaPathsNodes, (String)TAG_PATHS, (String)"uvmf_generated_code", (Element)pragmaElement, (String)this.getFilePath());
            Element pragmaPathsElement = (Element)pragmaPathsNodes.item(0);
            if (pragmaPathsElement != null) {
                XMLValidator.checkAttributes((Element)pragmaPathsElement, new HashSet<String>(Arrays.asList(ATTR_REGEX, ATTR_APPLY_ON)), (String)this.getFilePath());
                regexType = pragmaPathsElement.getAttribute(ATTR_REGEX);
                if (!IWaiver.isValidRegexType(regexType)) {
                    throw new IllegalArgumentException("Invalid path pattern regex type '" + regexType.trim() + "', it must be " + Arrays.toString(IWaiver.REGEX_TYPES) + "!");
                }
                waiver.setPathRegexType(regexType);
                applyOn = pragmaPathsElement.getAttribute(ATTR_APPLY_ON);
                if (!IWaiver.isValidApplyOn(applyOn)) {
                    throw new IllegalArgumentException("Invalid paths apply-on scope '" + applyOn.trim() + "', it must be " + Arrays.toString(IWaiver.APPLY_ON_TYPES) + "!");
                }
                waiver.setPathsApplyOn(applyOn);
                XMLValidator.checkChildren((Element)pragmaPathsElement, new HashSet<String>(Arrays.asList(TAG_PATH)), (String)this.getFilePath());
            }
            boolean isSimpleRegexPragma = regexType == null || regexType.equals("simple");
            nodeList = pragmaElement.getElementsByTagName(TAG_PATH);
            int j = 0;
            while (j < nodeList.getLength()) {
                subElem = (Element)nodeList.item(j);
                content = subElem.getTextContent();
                if (content != null) {
                    String rawPath = isSimpleRegexPragma ? DVTStringUtil.intern((String)Utils.canonicPath((String)content)) : DVTStringUtil.intern((String)content);
                    String path = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)content, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
                    path = isSimpleRegexPragma ? DVTStringUtil.intern((String)Utils.canonicPath((String)path)) : DVTStringUtil.intern((String)path);
                    waiver.addRawPath(rawPath);
                    waiver.addPath(path);
                }
                ++j;
            }
            nodeList = pragmaElement.getElementsByTagName(TAG_CHECK);
            j = 0;
            while (j < nodeList.getLength()) {
                content = nodeList.item(j).getTextContent();
                if (content != null) {
                    ((PostWaiver)waiver).addUVMFCheckName(content);
                }
                ++j;
            }
            this.UVMFCustomPragmaWaivers.add((PostWaiver)waiver);
            ++i;
        }
        NodeList nodes = waiversElement.getElementsByTagName(TAG_WAIVER);
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            waiver = new PostWaiver();
            waiver.setFilePath(this.getFilePath());
            Element waiverElement = (Element)nodes.item(i2);
            XMLValidator.checkAttributes((Element)waiverElement, new HashSet<String>(Arrays.asList("name", ATTR_APPLY_ON, ATTR_MACRO_PATH)), (String)this.getFilePath());
            XMLValidator.checkChildren((Element)waiverElement, new HashSet<String>(Arrays.asList(TAG_STATUS, TAG_DESCRIPTION, TAG_PATHS, TAG_PATH, TAG_CHECKS, TAG_CHECK, TAG_LINE_RANGES, TAG_LINE_RANGE, TAG_MESSAGE_PATTERNS, TAG_MESSAGE_PATTERN, TAG_ELEMENTS, TAG_ELEMENT)), (String)this.getFilePath());
            lineNo = waiverElement.getUserData("lineNumber");
            if (lineNo instanceof String) {
                waiver.setLineNoInXMLFile(Integer.valueOf((String)lineNo));
            }
            if ((name = waiverElement.getAttribute("name")) == null || name.equals("")) {
                Object lineNumber = waiverElement.getUserData("lineNumber");
                int line = 0;
                if (lineNumber instanceof String) {
                    line = Integer.parseInt((String)lineNumber);
                }
                SAXParseException saxParseException = new SAXParseException("Waiver has no name attribute", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)saxParseException, this.getFilePath());
            }
            waiver.setName(name);
            applyOn = waiverElement.getAttribute(ATTR_APPLY_ON);
            if (!IWaiver.isValidApplyOn(applyOn)) {
                throw new IllegalArgumentException("Invalid apply-on scope '" + applyOn.trim() + "', it must be " + Arrays.toString(IWaiver.APPLY_ON_TYPES) + "!");
            }
            waiver.setApplyOn(applyOn);
            macroPath = waiverElement.getAttribute(ATTR_MACRO_PATH);
            if ("true".equalsIgnoreCase(macroPath)) {
                ((PostWaiver)waiver).setInsideMacroPath(true);
            } else if (macroPath == null || macroPath.isEmpty() || "false".equalsIgnoreCase(macroPath)) {
                ((PostWaiver)waiver).setInsideMacroPath(false);
            } else {
                throw new IllegalArgumentException("Invalid macro path '" + macroPath.trim() + "', it must be 'true' or 'false'!");
            }
            NodeList statusNodes = waiverElement.getElementsByTagName(TAG_STATUS);
            XMLValidator.checkMandatoryUniqueElement((NodeList)statusNodes, (String)TAG_STATUS, (String)TAG_WAIVER, (Element)waiverElement, (String)this.getFilePath());
            Element statusElement = (Element)statusNodes.item(0);
            if (statusElement != null && (content = statusElement.getTextContent()) != null) {
                status = WaiverStatus.from(content);
                if (status == WaiverStatus.NONE) {
                    throw new IllegalArgumentException("Invalid status '" + content + "', use only DISABLE, ERROR, WARNING, INFO!");
                }
                ((PostWaiver)waiver).setStatus(status);
                NodeList descriptionNodes = waiverElement.getElementsByTagName(TAG_DESCRIPTION);
                XMLValidator.checkOptionalOneElement((NodeList)descriptionNodes, (String)TAG_DESCRIPTION, (String)TAG_WAIVER, (Element)waiverElement, (String)this.getFilePath());
                Element descriptionElement = (Element)descriptionNodes.item(0);
                if (descriptionElement != null && (content = descriptionElement.getTextContent()) != null) {
                    waiver.setDescription(content);
                }
                NodeList pathsNodes = waiverElement.getElementsByTagName(TAG_PATHS);
                XMLValidator.checkOptionalOneElement((NodeList)pathsNodes, (String)TAG_PATHS, (String)TAG_WAIVER, (Element)waiverElement, (String)this.getFilePath());
                Element pathsElement = (Element)pathsNodes.item(0);
                if (pathsElement != null) {
                    XMLValidator.checkAttributes((Element)pathsElement, new HashSet<String>(Arrays.asList(ATTR_REGEX, ATTR_APPLY_ON)), (String)this.getFilePath());
                    regexType = pathsElement.getAttribute(ATTR_REGEX);
                    if (!IWaiver.isValidRegexType(regexType)) {
                        throw new IllegalArgumentException("Invalid path pattern regex type '" + regexType.trim() + "', it must be " + Arrays.toString(IWaiver.REGEX_TYPES) + "!");
                    }
                    waiver.setPathRegexType(regexType);
                    applyOn = pathsElement.getAttribute(ATTR_APPLY_ON);
                    if (!IWaiver.isValidApplyOn(applyOn)) {
                        throw new IllegalArgumentException("Invalid paths apply-on scope '" + applyOn.trim() + "', it must be " + Arrays.toString(IWaiver.APPLY_ON_TYPES) + "!");
                    }
                    waiver.setPathsApplyOn(applyOn);
                    XMLValidator.checkChildren((Element)pathsElement, new HashSet<String>(Arrays.asList(TAG_PATH)), (String)this.getFilePath());
                }
                boolean isSimpleRegex = regexType != null ? regexType.equals("simple") : true;
                nodeList = waiverElement.getElementsByTagName(TAG_PATH);
                int j = 0;
                while (j < nodeList.getLength()) {
                    subElem = (Element)nodeList.item(j);
                    content = subElem.getTextContent();
                    if (content != null) {
                        String rawPath = isSimpleRegex ? DVTStringUtil.intern((String)Utils.canonicPath((String)content)) : DVTStringUtil.intern((String)content);
                        String path = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)content, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
                        path = isSimpleRegex ? DVTStringUtil.intern((String)Utils.canonicPath((String)path)) : DVTStringUtil.intern((String)path);
                        waiver.addRawPath(rawPath);
                        waiver.addPath(path);
                    }
                    ++j;
                }
                nodeList = waiverElement.getElementsByTagName(TAG_CHECK);
                j = 0;
                while (j < nodeList.getLength()) {
                    content = nodeList.item(j).getTextContent();
                    if (content != null) {
                        ((PostWaiver)waiver).addCheckName(content);
                    }
                    ++j;
                }
                nodeList = waiverElement.getElementsByTagName(TAG_LINE_RANGE);
                j = 0;
                while (j < nodeList.getLength()) {
                    content = nodeList.item(j).getTextContent();
                    if (content != null) {
                        lineRange = new LineRange(content);
                        ((PostWaiver)waiver).addLineRange(lineRange);
                    }
                    ++j;
                }
                NodeList messagePatternsNodes = waiverElement.getElementsByTagName(TAG_MESSAGE_PATTERNS);
                XMLValidator.checkOptionalOneElement((NodeList)messagePatternsNodes, (String)TAG_MESSAGE_PATTERNS, (String)TAG_WAIVER, (Element)waiverElement, (String)this.getFilePath());
                Element messagePatternElement = (Element)messagePatternsNodes.item(0);
                if (messagePatternElement != null) {
                    XMLValidator.checkAttributes((Element)messagePatternElement, new HashSet<String>(Arrays.asList(ATTR_REGEX)), (String)this.getFilePath());
                    regexType = messagePatternElement.getAttribute(ATTR_REGEX);
                    if (!IWaiver.isValidRegexType(regexType)) {
                        throw new IllegalArgumentException("Invalid message pattern regex type '" + regexType.trim() + "', it must be " + Arrays.toString(IWaiver.REGEX_TYPES) + "!");
                    }
                    ((PostWaiver)waiver).setMessageRegexType(regexType);
                    XMLValidator.checkChildren((Element)messagePatternElement, new HashSet<String>(Arrays.asList(TAG_MESSAGE_PATTERN)), (String)this.getFilePath());
                }
                nodeList = waiverElement.getElementsByTagName(TAG_MESSAGE_PATTERN);
                int j2 = 0;
                while (j2 < nodeList.getLength()) {
                    subElem = (Element)nodeList.item(j2);
                    content = subElem.getTextContent();
                    if (content != null) {
                        ((PostWaiver)waiver).addMessagePattern(new MessagePattern(content, ((PostWaiver)waiver).getMessageRegexType().equals("simple")));
                    }
                    ++j2;
                }
                NodeList elementsNodes = waiverElement.getElementsByTagName(TAG_ELEMENTS);
                XMLValidator.checkOptionalOneElement((NodeList)elementsNodes, (String)TAG_ELEMENTS, (String)TAG_PRE_WAIVER, (Element)elem, (String)this.getFilePath());
                subElem = (Element)elementsNodes.item(0);
                if (subElem != null) {
                    XMLValidator.checkAttributes((Element)subElem, new HashSet<String>(Arrays.asList(ATTR_REGEX)), (String)this.getFilePath());
                    regexType = subElem.getAttribute(ATTR_REGEX);
                    if (!IWaiver.isValidRegexType(regexType)) {
                        throw new IllegalArgumentException("Invalid regex type '" + regexType.trim() + "', it must be " + Arrays.toString(IWaiver.REGEX_TYPES) + "!");
                    }
                    ((PostWaiver)waiver).setElementsRegexType(regexType);
                    XMLValidator.checkChildren((Element)subElem, new HashSet<String>(Arrays.asList(TAG_ELEMENT)), (String)this.getFilePath());
                }
                nodeList = waiverElement.getElementsByTagName(TAG_ELEMENT);
                int j3 = 0;
                while (j3 < nodeList.getLength()) {
                    subElem = (Element)nodeList.item(j3);
                    Element type = (Element)subElem.getElementsByTagName(TAG_ELEMENT_TYPE).item(0);
                    if (type != null) {
                        XMLValidator.checkNodeValue((Element)type, (String)this.getFilePath(), ELEMENT_TYPES);
                        Element namePattern = (Element)subElem.getElementsByTagName("name").item(0);
                        if (((PostWaiver)waiver).getElementsRegexType().equals("perl")) {
                            XMLValidator.checkRegexElement((Element)namePattern, (String)this.getFilePath());
                        }
                        if (namePattern == null) {
                            ((PostWaiver)waiver).addElement(type.getTextContent(), "");
                        } else {
                            ((PostWaiver)waiver).addElement(type.getTextContent(), namePattern.getTextContent());
                        }
                    }
                    ++j3;
                }
                waivers.add(waiver);
            }
            ++i2;
        }
        NodeList preWaiverNodes = waiversElement.getElementsByTagName(TAG_PRE_WAIVER);
        int i3 = 0;
        while (i3 < preWaiverNodes.getLength()) {
            waiver = new PreWaiver();
            waiver.setFilePath(this.getFilePath());
            elem = (Element)preWaiverNodes.item(i3);
            XMLValidator.checkAttributes((Element)elem, new HashSet<String>(Arrays.asList("name", ATTR_APPLY_ON)), (String)this.getFilePath());
            XMLValidator.checkChildren((Element)elem, new HashSet<String>(Arrays.asList(TAG_DESCRIPTION, TAG_PATHS, TAG_PATH, TAG_CHECKS, TAG_CHECK, TAG_ELEMENTS, TAG_ELEMENT)), (String)this.getFilePath());
            name = elem.getAttribute("name");
            if (name == null || name.equals("")) {
                Object lineNumber = elem.getUserData("lineNumber");
                int line = 0;
                if (lineNumber instanceof String) {
                    line = Integer.parseInt((String)lineNumber);
                }
                SAXParseException saxParseException = new SAXParseException("Pre-Waiver has no name attribute", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)saxParseException, this.getFilePath());
            }
            waiver.setName(name);
            lineNo = elem.getUserData("lineNumber");
            if (lineNo instanceof String) {
                waiver.setLineNoInXMLFile(Integer.valueOf((String)lineNo));
            }
            if (!IWaiver.isValidApplyOn(applyOn = elem.getAttribute(ATTR_APPLY_ON))) {
                throw new IllegalArgumentException("Invalid apply-on scope '" + applyOn.trim() + "', it must be " + Arrays.toString(IWaiver.APPLY_ON_TYPES) + "!");
            }
            waiver.setApplyOn(applyOn);
            NodeList descriptionNodes = elem.getElementsByTagName(TAG_DESCRIPTION);
            XMLValidator.checkOptionalOneElement((NodeList)descriptionNodes, (String)TAG_DESCRIPTION, (String)TAG_PRE_WAIVER, (Element)elem, (String)this.getFilePath());
            subElem = (Element)descriptionNodes.item(0);
            if (subElem != null && (content = subElem.getTextContent()) != null) {
                waiver.setDescription(content);
            }
            NodeList pathsNodes = elem.getElementsByTagName(TAG_PATHS);
            XMLValidator.checkOptionalOneElement((NodeList)pathsNodes, (String)TAG_PATHS, (String)TAG_PRE_WAIVER, (Element)elem, (String)this.getFilePath());
            subElem = (Element)pathsNodes.item(0);
            if (subElem != null) {
                XMLValidator.checkAttributes((Element)subElem, new HashSet<String>(Arrays.asList(ATTR_REGEX, ATTR_APPLY_ON)), (String)this.getFilePath());
                regexType = subElem.getAttribute(ATTR_REGEX);
                if (!IWaiver.isValidRegexType(regexType)) {
                    throw new IllegalArgumentException("Invalid path pattern regex type '" + regexType.trim() + "', it must be " + Arrays.toString(IWaiver.REGEX_TYPES) + "!");
                }
                waiver.setPathRegexType(regexType);
                applyOn = subElem.getAttribute(ATTR_APPLY_ON);
                if (!IWaiver.isValidApplyOn(applyOn)) {
                    throw new IllegalArgumentException("Invalid paths apply-on scope '" + applyOn.trim() + "', it must be " + Arrays.toString(IWaiver.APPLY_ON_TYPES) + "!");
                }
                waiver.setPathsApplyOn(applyOn);
                XMLValidator.checkChildren((Element)subElem, new HashSet<String>(Arrays.asList(TAG_PATH)), (String)this.getFilePath());
            }
            boolean isSimpleRegex = regexType != null ? regexType.equals("simple") : true;
            nodeList = elem.getElementsByTagName(TAG_PATH);
            int j = 0;
            while (j < nodeList.getLength()) {
                subElem = (Element)nodeList.item(j);
                content = subElem.getTextContent();
                if (content != null) {
                    String rawPath = isSimpleRegex ? DVTStringUtil.intern((String)Utils.canonicPath((String)content)) : DVTStringUtil.intern((String)content);
                    String path = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)content, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
                    path = isSimpleRegex ? DVTStringUtil.intern((String)Utils.canonicPath((String)path)) : DVTStringUtil.intern((String)path);
                    waiver.addRawPath(rawPath);
                    waiver.addPath(path);
                }
                ++j;
            }
            nodeList = elem.getElementsByTagName(TAG_CHECK);
            j = 0;
            while (j < nodeList.getLength()) {
                content = nodeList.item(j).getTextContent();
                if (content != null) {
                    ((PreWaiver)waiver).addCheckName(content);
                }
                ++j;
            }
            NodeList elementsNodes = elem.getElementsByTagName(TAG_ELEMENTS);
            XMLValidator.checkOptionalOneElement((NodeList)elementsNodes, (String)TAG_ELEMENTS, (String)TAG_PRE_WAIVER, (Element)elem, (String)this.getFilePath());
            subElem = (Element)elementsNodes.item(0);
            if (subElem != null) {
                XMLValidator.checkAttributes((Element)subElem, new HashSet<String>(Arrays.asList(ATTR_REGEX)), (String)this.getFilePath());
                regexType = subElem.getAttribute(ATTR_REGEX);
                if (!IWaiver.isValidRegexType(regexType)) {
                    throw new IllegalArgumentException("Invalid regex type '" + regexType.trim() + "', it must be " + Arrays.toString(IWaiver.REGEX_TYPES) + "!");
                }
                ((PreWaiver)waiver).setElementsRegexType(regexType);
                XMLValidator.checkChildren((Element)subElem, new HashSet<String>(Arrays.asList(TAG_ELEMENT)), (String)this.getFilePath());
            }
            nodeList = elem.getElementsByTagName(TAG_ELEMENT);
            int j4 = 0;
            while (j4 < nodeList.getLength()) {
                subElem = (Element)nodeList.item(j4);
                Element type = (Element)subElem.getElementsByTagName(TAG_ELEMENT_TYPE).item(0);
                if (type != null) {
                    XMLValidator.checkNodeValue((Element)type, (String)this.getFilePath(), ELEMENT_TYPES);
                    Element namePattern = (Element)subElem.getElementsByTagName("name").item(0);
                    if (((PreWaiver)waiver).getElementsRegexType().equals("perl")) {
                        XMLValidator.checkRegexElement((Element)namePattern, (String)this.getFilePath());
                    }
                    if (namePattern == null) {
                        ((PreWaiver)waiver).addElement(type.getTextContent(), "");
                    } else {
                        ((PreWaiver)waiver).addElement(type.getTextContent(), namePattern.getTextContent());
                    }
                }
                ++j4;
            }
            waivers.add(waiver);
            ++i3;
        }
        return waivers;
    }
}

