/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.builders.VlogBuilderUtils;
import ro.amiq.vlogdt.model.IVlogModel;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.IVlogProject;
import ro.amiq.vlogdt.model.VlogFileInfo;
import ro.amiq.vlogdt.model.VlogModel;
import ro.amiq.vlogdt.model.VlogModule;
import ro.amiq.vlogdt.model.VlogProject;
import ro.amiq.vlogdt.model.floatingwidgets.VlogFNotificationProvider;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogProblem;
import ro.amiq.vlogdt.parser.VlogSVlog;
import ro.amiq.vlogdt.ui.syntaxerrors.SyntaxErrorsManager;
import ro.amiq.vlogdt.utils.Utils;

public class VlogModelManager
extends DVTModelManager {
    private static volatile VlogModelManager fInstance;
    private final VlogModel fModel;
    private HashMap<IPath, ArrayList> fTopFilesErrors = new HashMap();
    private HashMap<IPath, ArrayList> fTopFilesWarnings = new HashMap();
    private RfManager fRfManager;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private VlogModelManager() {
        this.fModel = new VlogModel();
        this.fRfManager = RfManager.getInstance();
        this.addBuildListener(this.fRfManager);
    }

    public void cleanVlogProject(IProject project) {
        this.fModel.cleanIDVTProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogModelManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VlogModelManager();
            }
        }
        return fInstance;
    }

    public int getPriority() {
        return DVTMixedLangBuilder.getBuilderPriorityForNature((String)"ro.amiq.vlogdt.VlogNature");
    }

    public IVlogModel getVlogModel() {
        return this.fModel;
    }

    public IVlogProject getIVlogProject(IDVTProject iDVTProject) {
        return (IVlogProject)iDVTProject;
    }

    public IVlogModule getIVlogFile(IDVTFile iDVTFile) {
        return (IVlogModule)iDVTFile;
    }

    public VlogFileInfo getVlogFileInfo(DVTFileInfo dvtFileInfo) {
        return (VlogFileInfo)dvtFileInfo;
    }

    public void saveUnfinishedJobs(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        Utils.getInstance().saveRFDM(rfProject, false, false, true);
    }

    public void cbClean(IProject iProject) {
        this.fTopFilesErrors.clear();
        this.fTopFilesWarnings.clear();
        IVlogProject vlogProject = this.getVlogModel().getVlogProject(iProject);
        if (vlogProject == null) {
            return;
        }
        vlogProject.clean();
        IProject project = vlogProject.getProject();
        this.notifyReparseListeners(2, project);
        this.notifyBuildListenersClean(vlogProject, true);
    }

    public void cbBuild(DVTFileInfo dvtFileInfo) {
        try {
            VlogFileInfo info = this.getVlogFileInfo(dvtFileInfo);
            IVlogProject vlogProject = this.getVlogModel().getVlogProject(info.getProject());
            if (vlogProject != null) {
                vlogProject.addParserPath(info.getParserPath(), null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Map<ParserPath, Boolean> getPrecompiledPathsMap(RfProject rfProject) {
        HashMap<ParserPath, Boolean> precompiledPaths = new HashMap<ParserPath, Boolean>();
        VlogFileInstance topFileInstance = rfProject.getPreprocessingTable().getTopFileInstance();
        if (topFileInstance == null) {
            return precompiledPaths;
        }
        List<VlogFileInstance> allInstances = VlogBuilderUtils.getRecursiveFileInstances(topFileInstance.getIncludedInstances());
        if (allInstances == null) {
            return precompiledPaths;
        }
        allInstances.add(0, topFileInstance);
        for (VlogFileInstance instance : allInstances) {
            Boolean isPrecompiled = (Boolean)precompiledPaths.get(instance.getParserPath());
            if (isPrecompiled != null && !instance.isPrecompiledDbFile()) continue;
            precompiledPaths.put(instance.getParserPath(), instance.isPrecompiledDbFile());
        }
        return precompiledPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cbPostFullBuild(IProject project, boolean success) {
        DVTLogger.INSTANCE.logDebug("DEBUG: cbPostFullBuild start");
        IVlogProject vlogProject = this.getVlogModel().getVlogProject(project);
        if (vlogProject == null) {
            return;
        }
        VlogSVlog vlogParser = vlogProject.getVlogParser();
        if (vlogParser == null) {
            return;
        }
        NullProtectedList<VlogProblem> unreportedErrors = new NullProtectedList<VlogProblem>();
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        rfProject.setSyntacticErrorsMap(vlogParser.getErrorsMap());
        rfProject.setSyntacticWarningsMap(vlogParser.getWarningsMap());
        ArrayList<IVlogModule> vlogFiles = new ArrayList<IVlogModule>();
        Map<ParserPath, IFile> parserPaths = vlogProject.getParserPaths();
        for (Map.Entry<ParserPath, IFile> entry : parserPaths.entrySet()) {
            ParserPath parserPath = entry.getKey();
            IFile file = entry.getValue();
            if (file != null && file.getLocation() != null) {
                VlogSVlog vlogSVlog;
                IPath location = file.getLocation();
                String resourcePath = location.toOSString();
                IVlogModule vlogFile = this.getVlogModel().getOrCreateVlogModule(file);
                if (vlogFile != null) {
                    vlogFiles.add(vlogFile);
                    vlogSVlog = vlogParser;
                    synchronized (vlogSVlog) {
                        vlogFile.setEncrypted(vlogParser.isEncrypted(parserPath));
                        boolean updatePath = !resourcePath.equals(parserPath.path);
                        vlogFile.setErrors(vlogParser.getErrors(parserPath), updatePath, resourcePath);
                        vlogFile.setWarnings(vlogParser.getWarnings(parserPath), updatePath, resourcePath);
                        vlogFile.setTasks(vlogParser.getTasks(parserPath));
                        continue;
                    }
                }
                vlogSVlog = vlogParser;
                synchronized (vlogSVlog) {
                    unreportedErrors.addAll(vlogParser.getErrors(parserPath));
                    continue;
                }
            }
            VlogSVlog vlogSVlog = vlogParser;
            synchronized (vlogSVlog) {
                unreportedErrors.addAll(vlogParser.getErrors(parserPath));
            }
        }
        parserPaths.clear();
        int type = 6;
        this.notifyReparseListeners(1, type, vlogFiles);
        this.notifyReparseListeners(3, project);
        if (!unreportedErrors.isEmpty()) {
            SyntaxErrorsManager.getInstance().updateProblemsUI(project, unreportedErrors);
        }
        this.notifyBuildListenersPostFullBuild(vlogProject, success);
    }

    public void handleProblems(IProject project) {
        VlogProject vlogProject = (VlogProject)VlogModelManager.getInstance().getVlogModel().getVlogProject(project);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        Map<ParserPath, Set<VlogProblem>> errorsMap = rfProject.getSyntacticErrorsMap();
        Map<ParserPath, Set<VlogProblem>> warningsMap = rfProject.getSyntacticWarningsMap();
        ArrayList<IVlogModule> vlogFiles = new ArrayList<IVlogModule>();
        Map<ParserPath, IFile> parserPaths = vlogProject.getParserPaths();
        for (Map.Entry<ParserPath, IFile> entry : parserPaths.entrySet()) {
            IVlogModule vlogFile;
            ParserPath parserPath = entry.getKey();
            IFile file = entry.getValue();
            Set<VlogProblem> errors = errorsMap.get(parserPath);
            Set<VlogProblem> warnings = warningsMap.get(parserPath);
            if (file == null || file.getLocation() == null || (vlogFile = this.getVlogModel().getOrCreateVlogModule(file)) == null || (errors == null || errors.isEmpty()) && (warnings == null || warnings.isEmpty())) continue;
            vlogFiles.add(vlogFile);
            vlogFile.setErrors(errors);
            vlogFile.setWarnings(warnings);
        }
        parserPaths.clear();
        int type = 6;
        this.notifyReparseListeners(1, type, vlogFiles);
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo fileInfo, IDocument document, boolean saveRFDM) {
        if (monitor.isCanceled()) {
            return;
        }
        if (fileInfo == null) {
            return;
        }
        IFile file = fileInfo.getFile();
        if (file == null || !file.exists()) {
            return;
        }
        this.cbClean(file);
        IVlogModule vlogFile = this.getVlogModel().getOrCreateVlogModule(file);
        if (vlogFile == null) {
            return;
        }
        try {
            if (document != null) {
                vlogFile.reparse(monitor, document.get(), saveRFDM);
            } else {
                vlogFile.reparse(monitor, saveRFDM);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (vlogFile.isAutoBuildStop()) {
            return;
        }
        int type = 2;
        ParserPath parserPath = vlogFile.getParserPath();
        this.notifyReparseListeners(0, type |= 4, vlogFile);
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        IVlogProject vProject = this.getVlogModel().getVlogProject(project);
        VlogSVlog vParser = vProject.getVlogParser();
        if (vParser != null && parserPath != null) {
            this.handleFloatingNotification(VlogFNotificationProvider.getInstance(), project, file, vProject.isParserInterrupted());
            this.notifyBuildListenersPostIncrementalBuild(new VlogFileInfo(project, parserPath, null, file, -1, false));
        }
    }

    public void cbInstanceIncrementalBuild(VlogModule vlogFile, IDVTFileInstance instance, VlogSVlog vParser) {
        if (vlogFile == null) {
            return;
        }
        if (vlogFile.isAutoBuildStop()) {
            return;
        }
        IFile file = vlogFile.getFile();
        ParserPath parserPath = vlogFile.getParserPath();
        if (vParser != null && parserPath != null) {
            this.notifyBuildListenersIncrementalBuild(new VlogFileInfo(file.getProject(), parserPath, instance, file, -1, false));
        }
    }

    public void cbRemove(IFile file) {
        IVlogModule vModule = this.getVlogModel().getOrCreateVlogModule(file);
        if (vModule == null) {
            return;
        }
        this.notifyBuildListenersRemove(vModule);
    }

    public IVlogProject getIEProject(IDVTProject iDVTProject) {
        return (IVlogProject)iDVTProject;
    }

    public IVlogModule getIEModule(IDVTFile iDVTFile) {
        return (IVlogModule)iDVTFile;
    }

    public VlogFileInfo getModuleInfo(DVTFileInfo dvtFileInfo) {
        return (VlogFileInfo)dvtFileInfo;
    }

    public void addTopFile(String topFilePath) {
        IPath path = Path.fromOSString((String)topFilePath);
        this.fTopFilesErrors.put(path, null);
        this.fTopFilesWarnings.put(path, null);
    }

    public void cbClean(IFile file) {
        IVlogModule vlogFile = this.getVlogModel().getOrCreateVlogModule(file);
        if (vlogFile == null) {
            return;
        }
        this.notifyBuildListenersClean(vlogFile);
    }
}

