/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model;

import antlr.Token;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoDefineByNameFilter;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoFilter;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTFile;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.builders.VlogPoolingCancelThread;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.IVlogProject;
import ro.amiq.vlogdt.model.RebuildTriggerJob;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.ParamsProvider;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.parser.VlogProblem;
import ro.amiq.vlogdt.parser.VlogSVlog;
import ro.amiq.vlogdt.ui.persistenttask.PersistentTaskManager;
import ro.amiq.vlogdt.utils.Utils;

public class VlogModule
extends DVTFile
implements IVlogModule {
    private RebuildTriggerJob fRebuildJob = new RebuildTriggerJob(this);
    private boolean fForceBuild;
    private boolean fAutobuildStop;
    private boolean fEncrypted;
    private boolean fDirty;

    public VlogModule(IFile iFile) {
        super(iFile);
    }

    public void blockingReparse() {
        this.fRebuildJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void blockingReparse(IProgressMonitor progressMonitor, IDocument document) {
        if (document != null) {
            this.fRebuildJob.setDocument(document);
        }
        this.fRebuildJob.run((IProgressMonitor)(progressMonitor == null ? new NullProgressMonitor() : progressMonitor));
    }

    public void scheduleReparse(boolean wait, boolean force, long delay, boolean saveRFDM) {
        this.scheduleReparse(wait, force, delay, null, saveRFDM);
    }

    public void scheduleReparse(boolean wait, boolean force, long delay, IDocument document, boolean saveRFDM) {
        this.scheduleReparse(wait, force, delay, document, saveRFDM, false);
    }

    public void scheduleReparse(boolean wait, boolean force, long delay, IDocument document, boolean saveRFDM, boolean ignoreOngoingIncrementalCancel) {
        try {
            boolean cancelIncremental;
            boolean bl = cancelIncremental = !ignoreOngoingIncrementalCancel && PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
            if (cancelIncremental) {
                ChangedFilesManager.cancelBuildJob();
            } else {
                this.fRebuildJob.cancel();
            }
            this.fForceBuild = force;
            this.fRebuildJob.setDocument(document);
            if (wait) {
                DVTJobsUtils.scheduleAndJoin((Job)this.fRebuildJob, (long)delay);
            } else {
                this.fRebuildJob.schedule(delay);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void reparse(IProgressMonitor monitor, boolean saveRFDM) {
        this.reparse(monitor, null, saveRFDM);
    }

    @Override
    public boolean isAutoBuildStop() {
        return this.fAutobuildStop;
    }

    public void reparse(IProgressMonitor monitor, String documentContent, boolean saveRFDM) {
        this.parse(3, monitor, documentContent, null, null, null);
    }

    public void reparse(IProgressMonitor monitor, String libUnresolvedElement) {
        this.parse(8, monitor, null, null, null, libUnresolvedElement);
    }

    public void reparseLibFile(Map<String, Map<Token, Token>> cacheDefinedElements, IProgressMonitor monitor) {
        this.parse(7, monitor, null, null, cacheDefinedElements, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(int parseKind, IProgressMonitor monitor, String documentContent, ParamsProvider extendParams, Map<String, Map<Token, Token>> cacheDefinedElements, String libUnresolvedElement) {
        try {
            this.fAutobuildStop = false;
            IFile file = this.getFile();
            if (file == null) {
                return;
            }
            IPath location = file.getLocation();
            if (location == null) {
                return;
            }
            IProject project = file.getProject();
            IVlogProject vlogProject = VlogModelManager.getInstance().getVlogModel().getVlogProject(project);
            if (vlogProject == null) {
                return;
            }
            List invocations = BuildConfigManager.getInvocations((IProject)project);
            if (invocations == null || invocations.isEmpty()) {
                return;
            }
            String resourcePath = location.toOSString();
            ParserPath parserPath = this.getParserPath();
            if (BuildConfigManager.isBuildConfigFile((IProject)project, (ParserPath)parserPath)) {
                return;
            }
            VlogSVlog parser = vlogProject.getVlogParser();
            if (parser == null) {
                return;
            }
            long time = System.currentTimeMillis();
            monitor.worked(1);
            VlogSVlog vlogSVlog = parser;
            synchronized (vlogSVlog) {
                VlogPoolingCancelThread pooling;
                block26: {
                    RfProject rfProject;
                    block24: {
                        block25: {
                            pooling = null;
                            rfProject = RfManager.getInstance().getRfProject(project);
                            if (!monitor.isCanceled()) break block24;
                            IncrementalDeltaContainer incrementalDeltaContainer = rfProject.getIncrementalDeltaContainer();
                            incrementalDeltaContainer.restoreDefElementsOnCancelIncremental(rfProject, parserPath);
                            incrementalDeltaContainer.clearDefElementsBeforeIncremental();
                            rfProject.cleanIncrementalDeltaContainer();
                            this.fAutobuildStop = true;
                            parser.removeParsingInstanceListener(this);
                            if (pooling == null) break block25;
                            pooling.stopPoolingThread();
                        }
                        monitor.worked(1);
                        return;
                    }
                    try {
                        try {
                            if (BuildConfigManager.isSkip((IProject)project, (ParserPath)parserPath)) break block26;
                            monitor.worked(1);
                            VlogPreprocessingInfo preprocessing = rfProject.getPreprocessingTable();
                            Invocation lastInvocation = (Invocation)invocations.get(invocations.size() - 1);
                            String defaultKeywordSet = BuildConfigManager.getDefaultKeywordSet((Invocation)lastInvocation);
                            Map extensionKeywordsetMap = BuildConfigManager.getExtensionKeywordSetMap((Invocation)lastInvocation);
                            Set translatePragmas = BuildConfigManager.getPreprocessTranslatePragmas((IProject)project);
                            List customPragmas = BuildConfigManager.getCustomPragmas((IProject)project);
                            BuildConfigProperty buildConfigTimscaleProperty = BuildConfigManager.getTimescaleConfigurationProperty((IProject)project);
                            BuildConfigProperty buildConfigOverrideTimscaleProperty = BuildConfigManager.getOverrideTimescaleConfigurationProperty((IProject)project);
                            HidImplicit[] buildConfigTimscale = Utils.getInstance().computeTimescale(buildConfigTimscaleProperty);
                            HidImplicit[] buildConfigOverrideTimscale = Utils.getInstance().computeTimescale(buildConfigOverrideTimscaleProperty);
                            List incdirs = BuildConfigManager.getIncdirs((IProject)project, (Invocation)lastInvocation);
                            IBuildConfigParserConstants.ToolCompat toolCompat = lastInvocation.getToolCompat();
                            Set taskNames = PersistentTaskManager.getInstance().getAllTaskNames();
                            boolean hideTaskTags = PersistentTaskManager.getInstance().getHideTaskTags();
                            boolean caseSensitiveTaskTags = PersistentTaskManager.getInstance().getCaseSensitiveTaskTags();
                            boolean disableParallelLexParse = BuildConfigManager.isDisableParallelLexParse((IProject)project);
                            boolean enableIncludeEnvVarExpansion = BuildConfigManager.isEnableIncludeEnvVarExpansion((IProject)project);
                            boolean isSvxEnable = BuildConfigManager.isSvxMode((IProject)project);
                            boolean isCpreprocEnable = BuildConfigManager.isCpreprocEnabled((IProject)project);
                            boolean isSkipProtectedCode = BuildConfigManager.isSkipProtectedCode((IProject)project);
                            boolean disableTaskTags = BuildConfigManager.isTagMemoryConsumptionDebug((IProject)project);
                            boolean disableComments = BuildConfigManager.isCommentMemoryConsumptionDebug((IProject)project);
                            boolean compactMacros = BuildConfigManager.isCompactMacros((IProject)project);
                            EncryptedCodeAutoFilter encryptedCodeAutoFilter = BuildConfigManager.getEncryptedCodeAutoCloseFilter((IProject)project);
                            EncryptedCodeAutoDefineByNameFilter encryptedCodeAutoNameFilter = BuildConfigManager.getEncryptedCodeAutoDefineByNameFilter((IProject)project);
                            boolean encryptedCodeSupport = System.getenv("") != null;
                            boolean collectMacroCallsWithoutParams = false;
                            boolean collectMacroCallsWithParams = false;
                            DVTCodeCommentsPreferences commentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)project);
                            int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)project);
                            pooling = new VlogPoolingCancelThread();
                            pooling.startPoolingThread(monitor, parser, project, true, false);
                            pooling.setFileName(parserPath.path);
                            rfProject.setSwitchLibraryListener(null);
                            if (rfProject.isLintingEnabled()) {
                                commentsPreferences.setUseInlineComment(true);
                            }
                            parser.addParsingInstanceListener(this);
                            IPath topPath = RfProject.getVlogTopPath(project);
                            String topFilePath = topPath.toOSString();
                            boolean isPrecompiledDb = parser.isPrecompiledDb();
                            try {
                                parser.setPrecompiledDb(false);
                                parser.parseFile(parseKind, topFilePath, null, parserPath.path, parseKind == 7 ? null : incdirs, toolCompat, preprocessing, defaultKeywordSet, false, extensionKeywordsetMap, documentContent, null, null, null, encryptedCodeAutoFilter, encryptedCodeAutoNameFilter, encryptedCodeSupport, maxIssuesKindNumber, collectMacroCallsWithoutParams, collectMacroCallsWithParams, rfProject, false, false, false, commentsPreferences, null, cacheDefinedElements, false, true, customPragmas, translatePragmas, extendParams, -1, disableParallelLexParse, false, taskNames, caseSensitiveTaskTags, hideTaskTags, enableIncludeEnvVarExpansion, isSvxEnable, isCpreprocEnable, isSkipProtectedCode, false, disableTaskTags, disableComments, BuildConfigManager.shouldPrintLibScanDebug((IProject)project), compactMacros, libUnresolvedElement, true, buildConfigTimscale, buildConfigOverrideTimscale);
                            }
                            finally {
                                parser.setPrecompiledDb(isPrecompiledDb);
                            }
                        }
                        catch (Exception exception) {
                            if (pooling != null && pooling.getPoolingStatus() == 1) {
                                this.fAutobuildStop = true;
                            }
                            parser.removeParsingInstanceListener(this);
                            if (pooling != null) {
                                pooling.stopPoolingThread();
                            }
                            monitor.worked(1);
                        }
                    }
                    catch (Throwable throwable) {
                        parser.removeParsingInstanceListener(this);
                        if (pooling != null) {
                            pooling.stopPoolingThread();
                        }
                        monitor.worked(1);
                        throw throwable;
                    }
                }
                parser.removeParsingInstanceListener(this);
                if (pooling != null) {
                    pooling.stopPoolingThread();
                }
                monitor.worked(1);
                DVTLogger.INSTANCE.logDebug("DEBUG VLOG: Incremental done [" + (System.currentTimeMillis() - time) + " ms]");
                boolean updatePath = !resourcePath.equals(parserPath.path);
                this.setErrors(parser.getErrors(parserPath), updatePath, resourcePath);
                this.setWarnings(parser.getWarnings(parserPath), updatePath, resourcePath);
                this.setTasks(parser.getTasks(parserPath));
                this.setEncrypted(parser.isEncrypted(parserPath));
                this.setDirty(false);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void setErrors(List<VlogProblem> problems, boolean updatePath, String resourceFileName) {
        if (problems == null || problems.isEmpty() || !updatePath) {
            super.setErrors(problems);
            return;
        }
        for (VlogProblem problem : problems) {
            problem.setFileName(resourceFileName);
        }
        super.setErrors(problems);
    }

    @Override
    public void setWarnings(List<VlogProblem> problems, boolean updatePath, String resourceFileName) {
        if (problems == null || problems.isEmpty() || !updatePath) {
            super.setWarnings(problems);
            return;
        }
        for (VlogProblem problem : problems) {
            problem.setFileName(resourceFileName);
        }
        super.setWarnings(problems);
    }

    @Override
    public void notifyInstanceParsing(IDVTFileInstance instance, VlogSVlog parser) {
        VlogModelManager.getInstance().cbInstanceIncrementalBuild(this, instance, parser);
    }

    public void setAST(Object ast) {
    }

    public Object getAST() {
        return null;
    }

    public void cancelReparse() {
        this.fRebuildJob.cancel();
    }

    @Override
    public boolean isEncrypted() {
        return this.fEncrypted;
    }

    @Override
    public void setEncrypted(boolean encrypted) {
        this.fEncrypted = encrypted;
    }

    @Override
    public boolean isDirty() {
        return this.fDirty | this.fRebuildJob.getState() != 0;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public boolean isForceBuild() {
        return this.fForceBuild;
    }
}

