/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.DVTProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.model.IVlogConstants;
import ro.amiq.vlogdt.model.IVlogProject;
import ro.amiq.vlogdt.parser.VlogSVlog;

public class VlogProject
extends DVTProject
implements IVlogProject,
IVlogConstants {
    private Map<ParserPath, IFile> fParserPaths;
    private VlogSVlog fParser = null;
    private final Object fParserSynch = new Object();

    protected VlogProject(IProject project) {
        super(project);
        this.fParserPaths = new LinkedHashMap<ParserPath, IFile>();
    }

    @Override
    public VlogSVlog getVlogParser() {
        if (this.fParser == null) {
            this.createNewVlogParser();
        }
        return this.fParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VlogSVlog createNewVlogParser() {
        Object object = this.fParserSynch;
        synchronized (object) {
            this.fParser = new VlogSVlog();
        }
        return this.fParser;
    }

    @Override
    public void addParserPath(ParserPath parserPath, IFile file) {
        if (!this.fParserPaths.containsKey(parserPath) || file != null) {
            this.fParserPaths.put(parserPath, file);
        }
    }

    @Override
    public Map<ParserPath, IFile> getParserPaths() {
        return this.fParserPaths;
    }

    @Override
    public void clean() {
        this.fParserPaths.clear();
    }

    public boolean isParserInterrupted() {
        if (this.fParser == null) {
            return false;
        }
        return this.fParser.isInterrupted();
    }
}

