/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.persistence;

import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.indexer.AbstractIdentifierIndexer;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceBenchmark;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.persistence.VersionChangedException;
import ro.amiq.dvt.model.preproc.PreprocCompilationWrapper;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocMode;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.optimized.collections.fast.IdentityHSet;
import ro.amiq.dvt.precompiled.PrecompiledAutoDebugUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.indexer.IdentifierIndexer;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDefElementVisitorAdapter;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElementVisitor2Adapter;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

public class Persistence
extends PersistenceBase {
    private static final String RFDM_FILE = "vlog_rfdm";
    private static final String RFDM_FILE_COMP_FILES = "vlog_rfdm_comp_files";
    private static final String DIRTY_FILE = "vlog_dirty";
    private ArrayList<DVTPair<DataType, RfHidHolder>> dataTypesWithHidHolders;
    private ArrayList<DVTPair<RfFieldDef, Map<IRfNamedElement, DataType>>> fieldDefsWithDataTypes;
    private ArrayList<DVTPair<RfFunctionDef, Map<IRfNamedElement, DataType>>> functionDefsWithDataTypes;

    public Persistence(IProject project) {
        super(project);
    }

    protected String getDirtyFileName() {
        return DIRTY_FILE;
    }

    protected String getCompiledFilesFileName() {
        return RFDM_FILE_COMP_FILES;
    }

    protected String getRfProjectFileName() {
        return RFDM_FILE;
    }

    protected Class<? extends AbstractIdentifierIndexer> getIdentifierIndexerClass() {
        return IdentifierIndexer.class;
    }

    protected void fastSerialize(IRfSingleLangProject rfSingleLangProject, final PersistenceOutputStream stream) throws Exception {
        final RfProject rfProject = (RfProject)rfSingleLangProject;
        final BuildConfigManagerCommon.PersistenceMode persistenceMode = stream.getPersistenceModeWrapper().persistenceMode;
        if (persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE) {
            rfProject.accept(new PrecompiledDbActionBlockRemoveVisitor());
        }
        VlogPreprocessingInfo preprocessingTable = rfProject.getPreprocessingTable();
        this.writeObjectWrapper(stream, preprocessingTable);
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("PreprocTable", stream);
        this.dataTypesWithHidHolders = new ArrayList();
        this.fieldDefsWithDataTypes = new ArrayList();
        this.functionDefsWithDataTypes = new ArrayList();
        rfProject.accept(new RfDefElementVisitorAdapter(){

            @Override
            public void postVisit(RfDefElement defElement) throws Exception {
                if (defElement.shouldSave()) {
                    Persistence.this.writeObjectWrapper(stream, defElement);
                }
            }
        });
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("DefElements", stream);
        rfProject.accept(new RfNamedElementVisitor2Adapter(){

            @Override
            public void postVisit(RfNamedElement namedElement) throws Exception {
                if (persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE) {
                    namedElement.setQualifiers(namedElement.getQualifiers() | 2);
                }
                if (namedElement.shouldSave()) {
                    Persistence.this.writeObjectWrapper(stream, namedElement);
                }
            }

            @Override
            public boolean visitFunctionCalls() {
                return true;
            }
        });
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("NamedElements", stream);
        this.writeObjectWrapper(stream, rfProject);
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("RfProject", stream);
        VlogFileInstance topInstance = preprocessingTable.getTopFileInstance();
        if (topInstance != null) {
            topInstance.visitInstances(fileInstance -> {
                this.writeObjectWrapper(stream, fileInstance.getSemanticScope());
                return true;
            });
        }
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("SemanticScope", stream);
        for (ParserPath parserPath : rfProject.getCompiledFilesSet()) {
            RfFileDef rfFileDef = rfProject.getFileDefUsingParserPath(parserPath);
            rfFileDef.customWriteObject(stream);
        }
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("ParserPathsFileDefs", stream);
        for (RfLibrary library : rfProject.getLibraries()) {
            Map<String, List<RfInstance>> bindsMap = library.getRawBindsForPersistence();
            if (bindsMap == null) continue;
            for (List<RfInstance> binds : bindsMap.values()) {
                if (binds == null) continue;
                for (RfInstance bind : binds) {
                    this.writeObjectWrapper(stream, bind.getEnclosingScope());
                }
            }
        }
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("Binds", stream);
        IdentityHSet writtenOperators = new IdentityHSet(1);
        rfProject.accept(new RfNamedElementVisitor2Adapter((Set)writtenOperators, persistenceMode){
            private final /* synthetic */ Set val$writtenOperators;
            private final /* synthetic */ BuildConfigManagerCommon.PersistenceMode val$persistenceMode;
            {
                this.val$writtenOperators = set;
                this.val$persistenceMode = persistenceMode;
            }

            @Override
            public void postVisit(RfNamedElement namedElement) throws Exception {
                if (!namedElement.shouldSave()) {
                    return;
                }
                RfHidHolder hidHolder = namedElement.getHidHolder();
                if (hidHolder == null) {
                    Persistence.this.writeObjectWrapper(stream, (Object)NullHidHolder.INSTANCE);
                    return;
                }
                final boolean isPrecompiledDbRelevantScope = hidHolder.isPrecompiledDbRelevantScope();
                final ArrayDeque operatorsStack = new ArrayDeque();
                hidHolder.visitHidObject(rfProject, (IHidVisitor)new IHidVisitor<IHidOperator>(){

                    public boolean visit(IHidOperator operator) {
                        if (val$persistenceMode != BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE) {
                            operatorsStack.push(operator);
                            return true;
                        }
                        if (((HidOperator)operator).hasQualifier(HidQualifierCache.IS_ELABORATED_OPI_QUALIFIER) || isPrecompiledDbRelevantScope || RfXvmFactory.isCreateCall((IHidObject)operator) || RfXvmFactory.isConnectCall((IHidObject)operator)) {
                            operatorsStack.push(operator);
                        }
                        return true;
                    }

                    public Class<IHidOperator> getType() {
                        return IHidOperator.class;
                    }
                });
                while (!operatorsStack.isEmpty()) {
                    IHidOperator op = (IHidOperator)operatorsStack.pop();
                    if (this.val$writtenOperators.contains(op)) continue;
                    ArrayList<IHidOperator> traverseList = new ArrayList<IHidOperator>(1);
                    traverseList.add(op);
                    int idx = 0;
                    while (idx < traverseList.size()) {
                        ListContainer rhValues;
                        IHidOperator ho = (IHidOperator)traverseList.get(idx);
                        ++idx;
                        IHidObject lhValue = ho.getLHValue();
                        if (lhValue instanceof IHidOperator) {
                            traverseList.add((IHidOperator)lhValue);
                        }
                        if ((rhValues = ho.getRHValues()) == null) continue;
                        rhValues.forEach(r -> {
                            if (r instanceof IHidOperator) {
                                traverseList.add((IHidOperator)r);
                            }
                        });
                    }
                    ListIterator iterator = traverseList.listIterator(traverseList.size());
                    while (iterator.hasPrevious()) {
                        IHidOperator opToWrite = (IHidOperator)iterator.previous();
                        stream.writeObject((Object)opToWrite);
                    }
                    this.val$writtenOperators.addAll(traverseList);
                }
                Persistence.this.writeObjectWrapper(stream, (Object)hidHolder);
            }

            @Override
            public boolean visitFunctionCalls() {
                return true;
            }
        });
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("HidHolders", stream);
        this.writeObjectWrapper(stream, new ArrayList<DVTPair<RfFieldDef, Map<IRfNamedElement, DataType>>>(this.fieldDefsWithDataTypes));
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("FieldDefList", stream);
        this.writeObjectWrapper(stream, new ArrayList<DVTPair<RfFunctionDef, Map<IRfNamedElement, DataType>>>(this.functionDefsWithDataTypes));
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("FunctionDefList", stream);
        BuildConfigManagerCommon.PersistenceModeWrapper thisPersistenceMode = stream.getPersistenceModeWrapper();
        stream.setPersistenceModeWrapper(BuildConfigManagerCommon.PersistenceModeWrapper.regular());
        this.writeObjectWrapper(stream, new ArrayList<DVTPair<DataType, RfHidHolder>>(this.dataTypesWithHidHolders));
        stream.setPersistenceModeWrapper(thisPersistenceMode);
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("DataTypeMap", stream);
        this.dataTypesWithHidHolders = null;
        this.fieldDefsWithDataTypes = null;
        this.functionDefsWithDataTypes = null;
        this.serializePVlogObjects(stream);
        PrecompiledAutoDebugUtils.INSTANCE.printPrecompileAutoRfdmSizeDebugData("PVlog", stream);
    }

    private void serializePVlogObjects(PersistenceOutputStream stream) throws IOException {
        this.writeObjectWrapper(stream, PreprocUtils.getInstance().getPreprocCompilationWrapper(this.getProject()));
        this.writeObjectWrapper(stream, PreprocDiffManager.INSTANCE.getReplacementMap(this.getProject()));
        this.writeObjectWrapper(stream, PreprocUtils.getInstance().getPreprocMode(this.getProject()));
    }

    protected RfProject fastDeSerialize(final PersistenceInputStream stream) throws Exception {
        PersistenceBenchmark benchmark = this.getBenchmark(stream.getPersistenceModeWrapper());
        Object readObject = null;
        benchmark.start("[PHASE] PreprocessingTable");
        readObject = this.readObjectWrapper(stream);
        benchmark.stop("[PHASE] PreprocessingTable");
        benchmark.start("[PHASE] RfDefElements");
        readObject = this.readObjectWrapper(stream);
        while (!(readObject instanceof RfNamedElement)) {
            readObject = this.readObjectWrapper(stream);
        }
        benchmark.stop("[PHASE] RfDefElements");
        benchmark.start("[PHASE] RfNamedElements");
        while (!(readObject instanceof RfProject)) {
            readObject = this.readObjectWrapper(stream);
        }
        benchmark.stop("[PHASE] RfNamedElements");
        RfProject rfProject = (RfProject)readObject;
        benchmark.start("[PHASE] postReadObject");
        VlogPreprocessingInfo preprocessingTable = rfProject.getPreprocessingTable();
        Iterator<RfLibrary> topInstance = preprocessingTable.getTopFileInstance();
        if (topInstance != null) {
            ((VlogFileInstance)((Object)topInstance)).visitInstances(fileInstance -> {
                Object readObject2 = this.readObjectWrapper(stream);
                fileInstance.setSemanticScope((RfNamedElement)readObject2);
                return true;
            });
        }
        rfProject.postReadObject();
        for (ParserPath parserPath : rfProject.getCompiledFilesSet()) {
            RfFileDef rfFileDef = rfProject.getFileDefUsingParserPath(parserPath);
            rfFileDef.customReadObject(stream);
        }
        benchmark.stop("[PHASE] postReadObject");
        benchmark.start("[PHASE] setEnclosingScopeOfChildrenForRestore");
        rfProject.accept(new RfNamedElementVisitor2Adapter(){

            @Override
            public void postVisit(RfNamedElement rfNamedElement) {
                rfNamedElement.setEnclosingScopeOfChildrenForRestore();
            }

            @Override
            public boolean visitFunctionCalls() {
                return true;
            }
        });
        benchmark.stop("[PHASE] setEnclosingScopeOfChildrenForRestore");
        benchmark.start("[PHASE] fixBindEnclosingScopes");
        for (RfLibrary library : rfProject.getLibraries()) {
            Map<String, List<RfInstance>> bindsMap = library.getRawBindsForPersistence();
            if (bindsMap == null) continue;
            for (List<RfInstance> binds : bindsMap.values()) {
                if (binds == null) continue;
                for (RfInstance bind : binds) {
                    readObject = this.readObjectWrapper(stream);
                    if (!(readObject instanceof RfNamedElement)) {
                        throw new VersionChangedException();
                    }
                    bind.setEnclosingScope((RfNamedElement)readObject);
                }
            }
        }
        benchmark.stop("[PHASE] fixBindEnclosingScopes");
        benchmark.start("[PHASE] setHidHolders");
        rfProject.accept(new RfNamedElementVisitor2Adapter(){

            @Override
            public void postVisit(RfNamedElement namedElement) throws Exception {
                if (stream.getMonitor().isCanceled()) {
                    return;
                }
                Object readObject2 = Persistence.this.readObjectWrapper(stream);
                while (!(readObject2 instanceof IHidHolder)) {
                    readObject2 = Persistence.this.readObjectWrapper(stream);
                }
                if (stream.getMonitor().isCanceled()) {
                    return;
                }
                if (readObject2 != NullHidHolder.INSTANCE) {
                    namedElement.setHidHolder((RfHidHolder)((Object)readObject2));
                }
            }

            @Override
            public boolean visitFunctionCalls() {
                return true;
            }
        });
        benchmark.stop("[PHASE] setHidHolders");
        benchmark.start("[PHASE] setFieldDefDataTypes");
        if (stream.getMonitor().isCanceled()) {
            return null;
        }
        ArrayList defsWithDataTypes = (ArrayList)stream.readObject();
        if (defsWithDataTypes != null) {
            for (DVTPair defWithDataTypes : defsWithDataTypes) {
                RfFieldDef fieldDef = (RfFieldDef)defWithDataTypes.getKey();
                fieldDef.updateDataType((Map)defWithDataTypes.getValue());
            }
        }
        benchmark.stop("[PHASE] setFieldDefDataTypes");
        benchmark.start("[PHASE] setFunctionDefDataTypes");
        if (stream.getMonitor().isCanceled()) {
            return null;
        }
        defsWithDataTypes = (ArrayList)stream.readObject();
        if (defsWithDataTypes != null) {
            for (DVTPair defWithDataTypes : defsWithDataTypes) {
                RfFunctionDef functionDef = (RfFunctionDef)defWithDataTypes.getKey();
                functionDef.updateDataType((Map)defWithDataTypes.getValue());
            }
        }
        benchmark.stop("[PHASE] setFunctionDefDataTypes");
        benchmark.start("[PHASE] setDataTypeParamHolders");
        if (stream.getMonitor().isCanceled()) {
            return null;
        }
        ArrayList dataTypesWithHidHolders = (ArrayList)stream.readObject();
        if (dataTypesWithHidHolders != null) {
            for (DVTPair dataTypeWithHidHolder : dataTypesWithHidHolders) {
                DataType dataType = (DataType)dataTypeWithHidHolder.getKey();
                dataType.updateParamValuesHolder((IHidHolder)dataTypeWithHidHolder.getValue());
            }
        }
        benchmark.stop("[PHASE] setDataTypeParamHolders");
        this.deSerializePVlogObjects(stream);
        return rfProject;
    }

    private void deSerializePVlogObjects(PersistenceInputStream stream) throws IOException, ClassNotFoundException {
        PersistenceBenchmark benchmark = this.getBenchmark(stream.getPersistenceModeWrapper());
        benchmark.start("[PHASE] setPVerilogObjects");
        Object readObject = stream.readObject();
        PreprocUtils.getInstance().putPToGMap(this.getProject(), (PreprocCompilationWrapper)readObject);
        readObject = stream.readObject();
        PreprocDiffManager.INSTANCE.restore((Map)readObject);
        readObject = stream.readObject();
        PreprocUtils.getInstance().pverilogCompilePreprocDirective(this.getProject(), (PreprocMode)readObject);
        benchmark.stop("[PHASE] setPVerilogObjects");
    }

    public void writeObjectWrapper(PersistenceOutputStream s, Object o) throws IOException {
        this.threadYield(100L);
        s.writeObject(o);
    }

    public Object readObjectWrapper(PersistenceInputStream s) throws IOException, ClassNotFoundException {
        this.threadYield(300L);
        Object readObject = s.readObject();
        return readObject;
    }

    public void dataTypeWritten(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper, DataType dataType, RfHidHolder paramValuesHolder) {
        if (paramValuesHolder != null && persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE) {
            paramValuesHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidOperator>(){

                public boolean visit(IHidOperator operator) {
                    if (((HidOperator)operator).hasQualifier(HidQualifierCache.IS_ELABORATED_OPI_QUALIFIER)) {
                        Set hids = HidUtils.flattenToHids((IHidObject)operator, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                        for (IHid hid : hids) {
                            if (!(hid instanceof Hid)) continue;
                            ((Hid)hid).getAncestorHid().addQualifier(HidQualifierCache.ELABORATED_HID_QUALIFIER);
                        }
                    }
                    return true;
                }

                public Class<IHidOperator> getType() {
                    return IHidOperator.class;
                }
            });
        }
        this.dataTypesWithHidHolders.add((DVTPair<DataType, RfHidHolder>)new DVTPair((Object)dataType, (Object)paramValuesHolder));
    }

    public void fieldDefWritten(RfFieldDef fieldDef, Map<IRfNamedElement, DataType> dataType) {
        this.fieldDefsWithDataTypes.add((DVTPair<RfFieldDef, Map<IRfNamedElement, DataType>>)new DVTPair((Object)fieldDef, dataType));
    }

    public void functionDefWritten(RfFunctionDef fieldDef, Map<IRfNamedElement, DataType> dataType) {
        this.functionDefsWithDataTypes.add((DVTPair<RfFunctionDef, Map<IRfNamedElement, DataType>>)new DVTPair((Object)fieldDef, dataType));
    }

    protected Class<?> resolveClass(ObjectStreamClass desc) {
        block3: {
            try {
                String className = desc.getName();
                if (className.indexOf("ro.amiq.vlogdt.") != -1) break block3;
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return Class.forName(desc.getName());
    }

    static enum NullHidHolder implements IHidHolder
    {
        INSTANCE;


        public IHidObject.HidKind getHidKind() {
            return null;
        }

        public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
            return false;
        }

        public boolean isRegisterHid(boolean noReparseStack, int idType, IDVTFileInstance fileInstance) {
            return false;
        }

        public IHidHolder addIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
            return null;
        }

        public void updateHolder(IHidHolder updater) {
        }

        public void addIdentifiers(IHidHolder updater) {
        }

        public void addOperators(IHidHolder updater) {
        }

        public boolean removeIdentifier(String name) {
            return false;
        }

        public boolean isHidObjectsEmpty() {
            return false;
        }

        public HidOperator addOperator(IHidHolderConstants.OperatorRequest operatorRequest) {
            return null;
        }
    }

    private static class PrecompiledDbActionBlockRemoveVisitor
    implements IRfDefElementVisitor.IRfDefElementVisitor2 {
        private PrecompiledDbActionBlockRemoveVisitor() {
        }

        @Override
        public void postVisit(RfDefElement defParentElement, RfDefElement defElement) throws Exception {
            if (!defElement.shouldSave()) {
                return;
            }
            RfNamedElement namedElement = defElement.getNamedElement();
            if (namedElement instanceof RfActionBlock) {
                if (!namedElement.isAnonymous()) {
                    return;
                }
                if (namedElement.hasLocalMembers()) {
                    return;
                }
                if (namedElement.getHidHolder() != null && namedElement.getHidHolder().isPrecompiledDbRelevant()) {
                    return;
                }
                Collection declarations = namedElement.getDeclarations();
                for (RfDefElement declaration : declarations) {
                    defParentElement.removeChild(declaration);
                }
                namedElement.getEnclosingScope().getLocalMembers(true).remove((Object)namedElement.getName());
            }
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return true;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }
}

