/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.problems;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemKind;
import ro.amiq.dvt.model.problems.DVTProblemKinds;
import ro.amiq.dvt.model.problems.ISourceProblem;
import ro.amiq.dvt.model.problems.VlogProblemKinds;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.parser.VlogProblem;

public class Bridge {
    public static DVTProblem from(IProject project, VlogProblem p, String reportedPath, boolean toConsole) {
        DVTProblemKind problemKind = DVTProblemKinds.GENERIC;
        String message = "";
        boolean obsolete = false;
        if (p instanceof RfSemanticError) {
            message = p.getMessage(false);
            if (p.getSeverity() == 1) {
                problemKind = VlogProblemKinds.SEMANTIC_ERROR;
            } else if (p.getSeverity() == 2) {
                problemKind = VlogProblemKinds.SEMANTIC_WARNING;
            }
            obsolete = ((RfSemanticError)p).isObsolete();
        } else {
            message = p.getMessage(true);
            if (p.getSeverity() == 1) {
                problemKind = VlogProblemKinds.SYNTAX_ERROR;
            } else if (p.getSeverity() == 2) {
                problemKind = VlogProblemKinds.SYNTAX_WARNING;
            }
        }
        boolean outsideProject = false;
        if (reportedPath != null) {
            IPath reportedProblemPath;
            IPath actualProblemPath = Path.fromOSString((String)p.getFileName());
            outsideProject = !actualProblemPath.equals((Object)(reportedProblemPath = Path.fromOSString((String)reportedPath)));
        }
        String path = outsideProject ? reportedPath : p.getFileName();
        int line = p.getLine();
        int offsetStart = p.getOffsetStart();
        int offsetEnd = p.getOffsetEnd();
        if (outsideProject) {
            message = "[Outside Project] " + message;
        }
        if (p.getReparseInfo() != null) {
            message = String.valueOf(message) + " [Right click to show macro trace]";
        }
        DVTProblem result = new DVTProblem(project, problemKind, path, toConsole, line, new String[]{message});
        result.setObsolete(obsolete);
        result.setSourceProblem((ISourceProblem)p);
        if (outsideProject) {
            result.setAttribute("ro.amiq.dvt.file_name", (Object)p.getFileName());
            result.setAttribute("ro.amiq.dvt.line_number", (Object)p.getLine());
        }
        if (p.getReparseInfo() != null) {
            result.setAttribute("ro.amiq.dvt.ui.editor.MacroStackTrace", (Object)p.toString());
            result.setAttribute("ro.amiq.dvt.ui.editor.MacroPluginID", (Object)"ro.amiq.vlogdt");
            result.setAttribute("ro.amiq.dvt.ui.editor.MacroProjectName", (Object)project.getName());
        }
        if (offsetEnd > offsetStart) {
            result.setAttribute("charStart", (Object)offsetStart);
            result.setAttribute("charEnd", (Object)offsetEnd);
        }
        result.addAttributes(p.getAttributes());
        result.setFileIndex(p.getFileIndex());
        result.setInvocationNumber(p.getInvocNumber());
        return result;
    }
}

