/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.model.reflection.DataType;

public class ArgInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UNKNOWN_ARG_NAME_PREFIX = "<unknown_arg_name_";
    private String fName;
    private DataType fDataType;
    private String fInitialValue;
    private LineInfo fStartInfo;
    private CommentBlock fComment;
    private boolean isOptional;
    private IRfNamedElement transientAssociatedType;

    public ArgInfo(String name, DataType dataType, CommentBlock comment) {
        this(name, dataType, null, comment);
    }

    public ArgInfo(String name, DataType dataType, CommentBlock comment, boolean isOptional) {
        this(name, dataType, null, comment);
        this.isOptional = isOptional;
    }

    public ArgInfo(String name, DataType dataType, String initialValue, CommentBlock comment) {
        this.fName = name;
        this.fDataType = dataType;
        this.fInitialValue = initialValue;
        this.fComment = comment;
    }

    public ArgInfo(String name, LineInfo startInfo) {
        this.fName = name;
        this.fStartInfo = startInfo;
    }

    public String getName() {
        return this.fName;
    }

    public DataType getDataType() {
        return this.fDataType;
    }

    public String getInitialValue() {
        return this.fInitialValue;
    }

    public String toString() {
        return String.valueOf(this.getTypeName("")) + " " + this.fName;
    }

    public String getTypeName(String implicitTypeName) {
        if (this.fDataType == null) {
            return implicitTypeName;
        }
        return this.fDataType.getTypeName(implicitTypeName, null);
    }

    public void setDataType(DataType dataType) {
        this.fDataType = dataType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fDataType == null ? 0 : this.fDataType.hashCode());
        result = 31 * result + (this.fInitialValue == null ? 0 : this.fInitialValue.hashCode());
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArgInfo other = (ArgInfo)obj;
        if (this.fDataType == null ? other.fDataType != null : !this.fDataType.equals(other.fDataType)) {
            return false;
        }
        if (this.fInitialValue == null ? other.fInitialValue != null : !this.fInitialValue.equals(other.fInitialValue)) {
            return false;
        }
        return !(this.fName == null ? other.fName != null : !this.fName.equals(other.fName));
    }

    public void setStartInfo(LineInfo startInfo) {
        this.fStartInfo = startInfo;
    }

    public LineInfo getStartInfo() {
        return this.fStartInfo;
    }

    public CommentBlock getComment() {
        return this.fComment;
    }

    public int getStartLine() {
        return this.fStartInfo == null ? -1 : this.fStartInfo.line;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public IRfNamedElement getTransientAssociatedType() {
        return this.transientAssociatedType;
    }

    public void setTransientAssociatedType(IRfNamedElement transientAssociatedType) {
        this.transientAssociatedType = transientAssociatedType;
    }
}

