/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoFilter;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.BaseConfigInfo;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public class ConfigInfo
extends BaseConfigInfo {
    public IRfNamedElement closestTypeContainer;
    public IRfLibraryElement enclosingLibrary;
    private boolean resolveOnlyBindTargets;
    private boolean resolveOnlyBindLocalHids;
    private boolean resolveImplicitSignals;
    private boolean checkUsageBeforeDeclaration = true;
    private boolean setReferenceToIdentifierName = true;
    private boolean isInXVMFunctionAutomation;
    private EncryptedCodeAutoFilter encryptedCodeAutoDefine;
    private ELWidthCheckContext elabContext;
    private boolean elabWidthCheckDisabled;
    private boolean elabWidthCheckOperatorFiltered;

    public ConfigInfo(boolean incremental, IRfSingleLangProject rfProject, IRfLibraryElement enclosingLibrary, boolean disableRTLChecks, IBuildConfigParserConstants.ToolCompat toolCompat, EncryptedCodeAutoFilter encryptedCodeAutoDefine) {
        super(incremental, rfProject.getMixedLangProjectParent(), disableRTLChecks, toolCompat);
        this.enclosingLibrary = enclosingLibrary;
        this.encryptedCodeAutoDefine = encryptedCodeAutoDefine;
    }

    public ConfigInfo(boolean incremental, IRfSingleLangProject rfProject, IRfLibraryElement enclosingLibrary, boolean disableRTLChecks, IBuildConfigParserConstants.ToolCompat toolCompat) {
        this(incremental, rfProject, enclosingLibrary, disableRTLChecks, toolCompat, BuildConfigManager.getEncryptedCodeAutoDefineFilter((IProject)rfProject.getProject()));
    }

    public ConfigInfo(BaseConfigInfo configInfo) {
        super(configInfo.incremental, configInfo.rfMixedProject, configInfo.disableRTLChecks, configInfo.toolCompat);
        if (configInfo instanceof ConfigInfo) {
            ConfigInfo rfConfigInfo = (ConfigInfo)configInfo;
            this.enclosingLibrary = rfConfigInfo.enclosingLibrary;
            this.resolveOnlyBindTargets = rfConfigInfo.resolveOnlyBindTargets;
            this.resolveOnlyBindLocalHids = rfConfigInfo.resolveOnlyBindLocalHids;
            this.resolveImplicitSignals = rfConfigInfo.resolveImplicitSignals;
            this.encryptedCodeAutoDefine = rfConfigInfo.encryptedCodeAutoDefine;
            this.elabContext = rfConfigInfo.elabContext;
            this.elabWidthCheckDisabled = rfConfigInfo.elabWidthCheckDisabled;
            this.elabWidthCheckOperatorFiltered = rfConfigInfo.elabWidthCheckOperatorFiltered;
            this.isInXVMFunctionAutomation = rfConfigInfo.isInXVMFunctionAutomation;
            this.setReferenceToIdentifierName = rfConfigInfo.setReferenceToIdentifierName;
        }
    }

    public void addReferenceToIdentifierName(String name) {
        if (this.resolveImplicitSignals) {
            return;
        }
        if (!this.setReferenceToIdentifierName) {
            return;
        }
        if (this.closestTypeContainer != null && this.enclosingLibrary != null) {
            this.closestTypeContainer.addReferenceToIdentifierName(name);
        }
    }

    public void addReferenceToIdentifierName(DataType dataType) {
        if (this.resolveImplicitSignals) {
            return;
        }
        if (this.closestTypeContainer != null && this.enclosingLibrary != null) {
            ((RfNamedElement)this.closestTypeContainer).addReferenceToIdentifierName(dataType);
        }
    }

    public void addReference(String typeName) {
        if (this.resolveImplicitSignals) {
            return;
        }
        if (this.enclosingLibrary != null) {
            this.enclosingLibrary.addReference(typeName, this.closestTypeContainer);
        }
    }

    public void addReference(DataType dataType) {
        if (this.resolveImplicitSignals) {
            return;
        }
        if (this.enclosingLibrary != null) {
            ((RfLibrary)this.enclosingLibrary).addReference(dataType, this.closestTypeContainer);
        }
    }

    public boolean resolveOnlyBindTargets() {
        return this.resolveOnlyBindTargets;
    }

    public void setResolveOnlyBindTargets(boolean value) {
        this.resolveOnlyBindTargets = value;
    }

    public boolean resolveOnlyBindLocalHids() {
        return this.resolveOnlyBindLocalHids;
    }

    public void setResolveOnlyBindLocalHids(boolean value) {
        this.resolveOnlyBindLocalHids = value;
    }

    public void setElabContext(ELWidthCheckContext context) {
        this.elabContext = context;
    }

    public void setElabWidthCheckDisabled(boolean value) {
        this.elabWidthCheckDisabled = value;
    }

    public void setElabWidthCheckFiltered(boolean value) {
        this.elabWidthCheckOperatorFiltered = value;
    }

    public ELWidthCheckContext getElabContext() {
        return this.elabContext;
    }

    public boolean isSemanticShowAliasName() {
        return this.elabContext != null ? this.elabContext.getManager().getSemanticShowAliasName() : false;
    }

    public boolean isElabWidthCheckDisabled() {
        return this.elabWidthCheckDisabled;
    }

    public boolean isElabWidthCheckFiltered() {
        return this.elabWidthCheckOperatorFiltered;
    }

    public boolean resolveImplicitSignals() {
        return this.resolveImplicitSignals;
    }

    public void setResolveImplicitSignals(boolean resolveImplicitSignals) {
        this.resolveImplicitSignals = resolveImplicitSignals;
    }

    public boolean checkUsageBeforeDeclaration() {
        return this.checkUsageBeforeDeclaration;
    }

    public void setReferenceToIdentifierName(boolean setReferenceToIdentifierName) {
        this.setReferenceToIdentifierName = setReferenceToIdentifierName;
    }

    public void setCheckUsageBeforeDeclaration(boolean value) {
        this.checkUsageBeforeDeclaration = value;
    }

    public void setIsInXVMFieldAutomation(boolean value) {
        this.isInXVMFunctionAutomation = value;
    }

    public boolean isInXVMFieldAutomation() {
        return this.isInXVMFunctionAutomation;
    }

    public EncryptedCodeAutoFilter getEncryptedCodeAutoDefine() {
        return this.encryptedCodeAutoDefine;
    }

    public boolean isIrunRNMTech() {
        IRfSingleLangProject rfProject = this.getRfProject("ro.amiq.vlogdt.VlogNature");
        return rfProject != null && rfProject.isIrunRNMTech();
    }
}

