/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

public class DataExpressionType
extends DataType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DataType UNKNOWN_DATA_TYPE = new DataType("");
    private IHidObject expressionHidObject;
    private int expressionIndex;
    private transient RfAssociatedType implicitVarScope;

    public DataExpressionType(DataType dataType) {
        this.init(dataType);
    }

    @Override
    public DataType copy() {
        DataExpressionType copy = new DataExpressionType(this);
        copy.expressionHidObject = this.expressionHidObject;
        copy.expressionIndex = this.expressionIndex;
        return copy;
    }

    @Override
    public void combineWithAnother(DataType dataType) {
        super.combineWithAnother(dataType);
        if (dataType instanceof DataExpressionType) {
            this.implicitVarScope = null;
            if (this.expressionHidObject == null) {
                this.expressionHidObject = ((DataExpressionType)dataType).expressionHidObject;
            }
            if (this.expressionIndex == 0) {
                this.expressionIndex = ((DataExpressionType)dataType).expressionIndex;
            }
        }
    }

    @Override
    public void splitWithAnother(DataType dataType, ParserPath filterParserPath) {
        super.splitWithAnother(dataType, filterParserPath);
        if (dataType instanceof DataExpressionType) {
            this.implicitVarScope = null;
            if (this.expressionHidObject != null && this.expressionHidObject == ((DataExpressionType)dataType).expressionHidObject) {
                this.expressionHidObject = null;
            }
            if (this.expressionIndex != 0 && this.expressionIndex == ((DataExpressionType)dataType).expressionIndex) {
                this.expressionIndex = 0;
            }
        }
    }

    public void setExpression(IHidObject expressionHidObject, int expressionIndex) {
        this.expressionHidObject = expressionHidObject;
        this.expressionIndex = expressionIndex;
    }

    public int getExpressionIndex() {
        return this.expressionIndex;
    }

    public IHidObject getExpressionHidObject() {
        return this.expressionHidObject;
    }

    public int getComputedExpressionIndex(boolean isArrayMehtodItem, boolean isForLoopParameter) {
        RfHidAccess hidAccess;
        List selects;
        if (isArrayMehtodItem && this.expressionHidObject instanceof RfHid || this.expressionHidObject instanceof RfHidAccess) {
            return 0;
        }
        int indexIdx = this.expressionIndex;
        if (isForLoopParameter && this.expressionHidObject instanceof RfHid && ((RfHid)this.expressionHidObject).getFirstAccess() != null && (selects = (hidAccess = (RfHidAccess)((RfHid)this.expressionHidObject).getFirstAccess()).getSelects()) != null && selects.size() > 1) {
            indexIdx = indexIdx - selects.size() + 1;
        }
        return indexIdx;
    }

    public IHidObject getComputedExpressionHidObject(boolean isArrayMehtodItem, boolean isForLoopParameter) {
        if (isArrayMehtodItem && this.expressionHidObject instanceof RfHid) {
            return ((RfHid)this.expressionHidObject).upwardsCopy(true);
        }
        if (isArrayMehtodItem && this.expressionHidObject instanceof RfHidAccess) {
            return ((RfHidAccess)this.expressionHidObject).upwardsCopy(true);
        }
        Object hidObject = this.expressionHidObject;
        if (isForLoopParameter && hidObject instanceof RfHid && ((RfHid)((Object)hidObject)).getFirstAccess() != null) {
            RfHidAccess hidAccess = (RfHidAccess)((RfHid)((Object)hidObject)).getFirstAccess();
            ArrayList selects = hidAccess.getSelects();
            if (selects != null && selects.size() > 1) {
                selects = new ArrayList(selects);
                selects.remove(selects.size() - 1);
                hidObject = hidAccess.upwardsCopy(true);
                ((RfHidAccess)((Object)hidObject)).updateSelects(selects);
            } else {
                return ((RfHid)this.expressionHidObject).upwardsCopy(true);
            }
        }
        return hidObject;
    }

    public RfAssociatedType getImplicitVarScope() {
        return this.implicitVarScope;
    }

    public void setImplicitVarScope(RfAssociatedType implicitVarScope) {
        this.implicitVarScope = implicitVarScope;
    }
}

