/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

public class DataSelectType
extends DataType
implements Serializable {
    private static final long serialVersionUID = 2L;
    IHidObject portExpression;
    Set<HidFlatteningOption> FLATTENING_OPTIONS_NO_SELECT = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));

    public DataSelectType(IHidObject portExpression) {
        this.portExpression = portExpression instanceof HidOperator ? ((HidOperator)portExpression).getFirstRHValue() : portExpression;
    }

    @Override
    public DataType copy() {
        return new DataSelectType(this.portExpression);
    }

    public DataType getPortDataType(IRfNamedElement port) {
        if (port == null || this.portExpression == null) {
            return this;
        }
        IRfNamedElement nonSelectPort = null;
        switch (this.portExpression.getHidKind()) {
            case HID: {
                Hid hid = (Hid)this.portExpression;
                nonSelectPort = hid.getElement();
                if (nonSelectPort == null) {
                    nonSelectPort = this.resolvePortHid(hid, port.getEnclosingScope());
                }
                if (!(nonSelectPort instanceof RfPort)) {
                    return this;
                }
                DataType dataType = this.resolveNonPortListDataType((RfPort)nonSelectPort);
                if (dataType == null) {
                    return this;
                }
                return dataType;
            }
            case ACCESS: {
                HidAccess access = (HidAccess)this.portExpression;
                Hid parentHid = access.getParentHid();
                if (parentHid == null) {
                    return this;
                }
                nonSelectPort = parentHid.getElement();
                if (nonSelectPort == null) {
                    nonSelectPort = this.resolvePortHid(parentHid, port.getEnclosingScope());
                }
                if (!(nonSelectPort instanceof RfPort)) {
                    return this;
                }
                DataType dataType = this.resolveNonPortListDataType((RfPort)nonSelectPort);
                if (dataType == null) {
                    return this;
                }
                List selects = access.getSelects();
                if (selects != null && !selects.isEmpty()) {
                    DataType selectedDataType = dataType.copy();
                    for (IHidObject select : selects) {
                        if (HidUtils.isOperator((IHidObject)select) && ((HidOperator)select).isRangeOrPartSelect()) continue;
                        if (selectedDataType.hasUnpackedDimension()) {
                            selectedDataType.decreaseUnpackedDimension();
                            continue;
                        }
                        if (!selectedDataType.hasPackedDimension()) continue;
                        selectedDataType.decreasePackedDimension();
                    }
                    return selectedDataType;
                }
                return dataType;
            }
            case OPERATOR: {
                HidOperator operator = (HidOperator)this.portExpression;
                Set rhHids = operator.getRHHids(HidFlatteningOption.IMPLICITS_AND_SELECT_OBJECTS_EXCLUDED);
                if (rhHids.isEmpty()) {
                    return this;
                }
                for (IHid iHid : rhHids) {
                    if (!HidUtils.isHid((IHidObject)iHid)) continue;
                    RfHid memberHid = (RfHid)iHid;
                    nonSelectPort = memberHid.getElement();
                    if (nonSelectPort == null) {
                        nonSelectPort = this.resolvePortHid(memberHid, port.getEnclosingScope());
                    }
                    if (nonSelectPort instanceof RfPort) continue;
                    return this;
                }
                ArrayList listOfHids = new ArrayList(rhHids);
                IHid hidCandidate = (IHid)listOfHids.get(listOfHids.size() - 1);
                if (!HidUtils.isHid((IHidObject)hidCandidate)) {
                    return this;
                }
                nonSelectPort = ((Hid)hidCandidate).getElement();
                if (!(nonSelectPort instanceof RfPort)) {
                    return this;
                }
                return this.resolveNonPortListDataType((RfPort)nonSelectPort);
            }
        }
        return this;
    }

    private RfPort resolvePortHid(Hid hid, IRfScopeElement enclosingScope) {
        if (!(enclosingScope instanceof RfNamedElement)) {
            return null;
        }
        RfPort nonSelectPort = ((RfNamedElement)enclosingScope).getLocalMember(RfPort.class, hid.getName(), true, false);
        if (nonSelectPort != null) {
            hid.setElement((IRfNamedElement)nonSelectPort);
        }
        return nonSelectPort;
    }

    private DataType resolveNonPortListDataType(RfPort port) {
        Collection declarations = port.getDeclarations();
        if (declarations == null || declarations.isEmpty()) {
            return null;
        }
        DataType dataType = new DataType();
        for (RfDefElement declaration : declarations) {
            RfPortDef portDef;
            DataType portDefDataType;
            if (!(declaration instanceof RfPortDef) || (portDefDataType = (portDef = (RfPortDef)declaration).getDataType(port)) == null) continue;
            if (portDef.isInListOfPorts()) {
                dataType.setLine(portDefDataType.getLine());
                dataType.setOffset(portDefDataType.getOffset());
                continue;
            }
            dataType.mergePortDataType(portDefDataType);
        }
        return dataType;
    }

    public IHidObject getPortExpression() {
        return this.portExpression;
    }

    @Override
    public void combineWithAnother(DataType dataType) {
        super.combineWithAnother(dataType);
        if (dataType instanceof DataSelectType && this.portExpression == null) {
            this.portExpression = ((DataSelectType)dataType).portExpression;
        }
    }

    @Override
    public void splitWithAnother(DataType dataType, ParserPath filterParserPath) {
        super.splitWithAnother(dataType, filterParserPath);
        if (dataType instanceof DataSelectType && this.portExpression != null && this.portExpression == ((DataSelectType)dataType).portExpression) {
            this.portExpression = null;
        }
    }
}

