/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import antlr.CharBuffer;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.ElementFromCursorDetectionException;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.OverflowDimensionEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.precompiled.PrecompiledAutoDebugUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.VlogShortrealNumber;
import ro.amiq.vlogdt.model.persistence.Persistence;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.IndexTypeWithOffsets;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfVerilog;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.model.reflection.util.CharBufferCacher;

public class DataType
extends IndexType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final VlogBitVector STRING_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)0, (int)0, null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector BIT_SIGNED_CONTEXT = VlogBitVector.createForSize((boolean)true, (int)0, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector BIT_UNSIGNED_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)0, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector LOGIC_SIGNED_CONTEXT = VlogBitVector.createForSize((boolean)true, (int)0, (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector LOGIC_UNSIGNED_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)0, (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector BYTE_SIGNED_CONTEXT = VlogBitVector.createForSize((boolean)true, (int)7, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector BYTE_UNSIGNED_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)7, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector SHORT_SIGNED_CONTEXT = VlogBitVector.createForSize((boolean)true, (int)15, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector SHORT_UNSIGNED_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)15, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector INT_SIGNED_CONTEXT = VlogBitVector.createForSize((boolean)true, (int)31, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector INT_UNSIGNED_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)31, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector INTEGER_SIGNED_CONTEXT = VlogBitVector.createForSize((boolean)true, (int)31, (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector INTEGER_UNSIGNED_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)31, (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector TIME_SIGNED_CONTEXT = VlogBitVector.createForSize((boolean)true, (int)63, (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector TIME_UNSIGNED_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)63, (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector LONG_SIGNED_CONTEXT = VlogBitVector.createForSize((boolean)true, (int)63, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    public static final VlogBitVector LONG_UNSIGNED_CONTEXT = VlogBitVector.createForSize((boolean)false, (int)63, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null);
    protected boolean fIsVerilog;
    protected byte fSign;
    protected byte fDirection;
    protected byte fVirtualInterface;
    protected byte fParametricDependencyValue;
    protected String fNetType;
    protected String fDiscipline;
    protected String fEnumRange;
    protected DataType fPackageScope;
    protected List<IndexType> fPackedDimension;
    protected List<IndexType> fUnpackedDimension;
    protected List<DataType> fOrderedParamAssignments;
    protected Map<String, ArgInfo> fNamedParamAssignments;
    protected List<DataType> fInnerClassesInfo;
    protected transient RfHidHolder fParamValuesHolder;
    private int fLine;
    private int fOffset;
    private boolean fIsInsideMacro;
    private boolean fIsInherited;

    private DataType(String type, int sign, List<IndexType> packedDimension, List<IndexType> unpackedDimension) {
        super(type);
        this.fSign = (byte)sign;
        this.fPackedDimension = packedDimension;
        this.fUnpackedDimension = unpackedDimension;
    }

    public DataType inheritsFrom(DataType dataType, boolean unpacked) {
        this.fIsInherited = true;
        this.fDiscipline = dataType.fDiscipline;
        this.fIsVerilog = dataType.fIsVerilog;
        this.fType = dataType.fType;
        this.fEscaped = dataType.fEscaped;
        this.fSign = dataType.fSign;
        this.fPackageScope = dataType.fPackageScope;
        this.fPackedDimension = dataType.fPackedDimension;
        if (unpacked) {
            this.fUnpackedDimension = dataType.fUnpackedDimension;
        }
        this.fLine = dataType.fLine;
        this.fOffset = dataType.fOffset;
        this.fVirtualInterface = dataType.fVirtualInterface;
        return this;
    }

    public DataType() {
        this(null, 0, null, null);
    }

    public DataType(String type) {
        this(type, -1, -1, false);
    }

    public DataType(String type, int line, int offset, boolean isInsideMacro) {
        this(type, 0, null, null);
        this.fLine = line;
        this.fOffset = offset;
        this.fIsInsideMacro = isInsideMacro;
    }

    public DataType(String type, String netType, String discipline, DataType packageScope, List<DataType> innerClassesInfo, List<DataType> orderedParamAssignments, Map<String, ArgInfo> namedParamAssignments, int sign, List<IndexType> packedDimension, List<IndexType> dimension, RfHidHolder paramValuesHolder) {
        this(type, sign, packedDimension, dimension);
        this.fPackageScope = packageScope;
        this.fNetType = DVTStringUtil.intern((String)netType);
        this.fDiscipline = DVTStringUtil.intern((String)discipline);
        this.fOrderedParamAssignments = orderedParamAssignments;
        this.fNamedParamAssignments = namedParamAssignments;
        this.fParamValuesHolder = paramValuesHolder;
        this.fInnerClassesInfo = innerClassesInfo;
    }

    public void combineWithAnother(DataType dataType) {
        boolean addImplicitOffset;
        if (dataType == null || dataType == this) {
            return;
        }
        if (this.fType == null && dataType.fType != null) {
            this.fType = dataType.fType;
            this.fEscaped = dataType.fEscaped;
        }
        this.fLine = dataType.fLine;
        this.fOffset = dataType.fOffset;
        this.fIsInherited = dataType.fIsInherited;
        this.fIsInsideMacro = dataType.fIsInsideMacro;
        if (this.fRangeObject == null && dataType.fRangeObject != null) {
            this.fRangeObject = dataType.fRangeObject;
        }
        if (this.fSign == 0 && dataType.fSign != 0 || dataType.fSign == 1) {
            this.fSign = dataType.fSign;
        }
        if (this.fEnumRange == null && dataType.fEnumRange != null) {
            this.fEnumRange = dataType.fEnumRange;
        }
        if (this.fPackedDimension == null && dataType.fPackedDimension != null) {
            this.fPackedDimension = dataType.fPackedDimension;
        }
        if (this.fUnpackedDimension == null && dataType.fUnpackedDimension != null) {
            this.fUnpackedDimension = dataType.fUnpackedDimension;
        }
        this.fIsVerilog = dataType.fIsVerilog;
        if (this.fNetType == null) {
            this.fNetType = dataType.fNetType;
        }
        if (this.fDiscipline == null) {
            this.fDiscipline = dataType.fDiscipline;
        }
        byte cleanDirection = this.getDirection();
        byte dataTypeCleanDirection = dataType.getDirection();
        boolean bl = addImplicitOffset = this.hasImplicitDirection() || dataType.hasImplicitDirection();
        if (this.fDirection == 0) {
            this.fDirection = dataType.fDirection;
        } else if (cleanDirection == 1 && dataTypeCleanDirection == 3) {
            this.fDirection = (byte)(addImplicitOffset ? (int)RfElement.getImplicitDirection((byte)2) : 2);
        } else if (cleanDirection == 3 && dataTypeCleanDirection == 1) {
            this.fDirection = (byte)(addImplicitOffset ? (int)RfElement.getImplicitDirection((byte)2) : 2);
        }
        if (this.fVirtualInterface == 0 || dataType.fVirtualInterface == 2) {
            this.fVirtualInterface = dataType.fVirtualInterface;
        }
        if (dataType.fNamedParamAssignments != null) {
            if (this.fNamedParamAssignments == null) {
                this.fNamedParamAssignments = new LinkedHashMap<String, ArgInfo>();
            }
            this.fNamedParamAssignments.putAll(dataType.fNamedParamAssignments);
        }
        if (dataType.fOrderedParamAssignments != null) {
            if (this.fOrderedParamAssignments == null) {
                this.fOrderedParamAssignments = new ArrayList<DataType>();
            }
            this.fOrderedParamAssignments.addAll(dataType.fOrderedParamAssignments);
        }
        if (dataType.fInnerClassesInfo != null) {
            if (this.fInnerClassesInfo == null) {
                this.fInnerClassesInfo = new ArrayList<DataType>(dataType.fInnerClassesInfo.size());
            }
            for (DataType innerClass : dataType.fInnerClassesInfo) {
                this.fInnerClassesInfo.add(innerClass.copy());
            }
        }
        if (this.fPackageScope == null) {
            this.fPackageScope = dataType.fPackageScope;
        }
        this.updateParamValuesHolder((IHidHolder)dataType.fParamValuesHolder);
    }

    public void splitWithAnother(DataType dataType, final ParserPath filterParserPath) {
        boolean addImplicitOffset;
        if (dataType == null || dataType == this) {
            return;
        }
        if (this.fType != null && dataType.fType != null) {
            this.fType = null;
            this.fEscaped = false;
        }
        if (this.fRangeObject != null && this.fRangeObject.equals(dataType.fRangeObject)) {
            this.fRangeObject = null;
        }
        if (this.fSign != 0 && this.fSign == dataType.fSign) {
            this.fSign = 0;
        }
        if (this.fEnumRange != null && this.fEnumRange.equals(dataType.fEnumRange)) {
            this.fEnumRange = null;
        }
        if (this.fPackedDimension != null && dataType.fPackedDimension != null) {
            this.fPackedDimension = null;
        }
        if (this.fUnpackedDimension != null && dataType.fUnpackedDimension != null) {
            this.fUnpackedDimension = null;
        }
        if (this.fNetType != null && dataType.fNetType != null) {
            this.fNetType = null;
        }
        if (this.fDiscipline != null && dataType.fDiscipline != null) {
            this.fDiscipline = null;
        }
        byte cleanDirection = this.getDirection();
        byte dataTypeCleanDirection = dataType.getDirection();
        boolean bl = addImplicitOffset = this.hasImplicitDirection() && !dataType.hasImplicitDirection();
        if (this.fDirection != 0 && this.fDirection == dataType.fDirection) {
            this.fDirection = 0;
        } else if (cleanDirection == 2 && dataTypeCleanDirection == 3) {
            this.fDirection = addImplicitOffset ? RfElement.getImplicitDirection((byte)1) : (byte)1;
        } else if (cleanDirection == 2 && dataTypeCleanDirection == 1) {
            this.fDirection = (byte)(addImplicitOffset ? (int)RfElement.getImplicitDirection((byte)3) : 3);
        }
        if (this.fVirtualInterface != 0 && this.fVirtualInterface == dataType.fVirtualInterface) {
            this.fVirtualInterface = 0;
        }
        if (this.fNamedParamAssignments != null && dataType.fNamedParamAssignments != null && !dataType.fNamedParamAssignments.isEmpty()) {
            this.fNamedParamAssignments.keySet().removeAll(dataType.fNamedParamAssignments.keySet());
            if (this.fNamedParamAssignments.isEmpty()) {
                this.fNamedParamAssignments = null;
            }
        }
        if (this.fOrderedParamAssignments != null && dataType.fOrderedParamAssignments != null && !dataType.fOrderedParamAssignments.isEmpty()) {
            this.fOrderedParamAssignments.removeAll(dataType.fOrderedParamAssignments);
            if (this.fOrderedParamAssignments.isEmpty()) {
                this.fOrderedParamAssignments = null;
            }
        }
        if (this.fInnerClassesInfo != null && dataType.fInnerClassesInfo != null && !dataType.fInnerClassesInfo.isEmpty()) {
            this.fInnerClassesInfo.removeAll(dataType.fInnerClassesInfo);
            if (this.fInnerClassesInfo.isEmpty()) {
                this.fInnerClassesInfo = null;
            }
        }
        if (this.fPackageScope != null && this.fPackageScope.equals(dataType.fPackageScope)) {
            this.fPackageScope = null;
        }
        if (this.fParamValuesHolder != null && filterParserPath != null && dataType.fParamValuesHolder != null && !dataType.fParamValuesHolder.isHidObjectsEmpty()) {
            dataType.fParamValuesHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidObject>(){
                private ParserPath parserPath;

                public void setParserPath(ParserPath parserPath) {
                    this.parserPath = parserPath;
                }

                public boolean visit(IHidObject obj) {
                    if (filterParserPath.equals((Object)this.parserPath)) {
                        if (obj instanceof HidOperator) {
                            DataType.this.fParamValuesHolder.removeOpiAtParserPath((HidOperator)obj, this.parserPath);
                        } else if (obj instanceof Hid) {
                            DataType.this.fParamValuesHolder.removeHidAtParserPath((Hid)obj, this.parserPath);
                        }
                    }
                    return true;
                }

                public boolean enterMethodArguments() {
                    return false;
                }

                public Class<IHidObject> getType() {
                    return IHidObject.class;
                }
            });
            if (this.fParamValuesHolder.isHidObjectsEmpty()) {
                this.fParamValuesHolder = null;
            }
        }
    }

    public void mergePortDataType(DataType dataType) {
        boolean addImplicitOffset;
        if (this.fType == null) {
            this.fType = dataType.fType;
            this.fVirtualInterface = dataType.fVirtualInterface;
            this.fSign = dataType.fSign;
            this.fNetType = dataType.fNetType;
            this.fPackedDimension = dataType.fPackedDimension;
            this.fUnpackedDimension = dataType.fUnpackedDimension;
            this.fPackageScope = dataType.fPackageScope;
            this.fDiscipline = dataType.fDiscipline;
            boolean bl = this.fIsVerilog = this.fIsVerilog && dataType.fIsVerilog;
            if (dataType.fInnerClassesInfo != null) {
                this.fInnerClassesInfo = new ArrayList<DataType>(dataType.fInnerClassesInfo.size());
                for (DataType innerClass : dataType.fInnerClassesInfo) {
                    this.fInnerClassesInfo.add(innerClass.copy());
                }
            }
            if (dataType.fOrderedParamAssignments != null) {
                this.fOrderedParamAssignments = new ArrayList<DataType>(dataType.fOrderedParamAssignments);
            }
            if (dataType.fNamedParamAssignments != null) {
                this.fNamedParamAssignments = new LinkedHashMap<String, ArgInfo>(dataType.fNamedParamAssignments);
            }
            this.fParamValuesHolder = dataType.fParamValuesHolder;
            this.fRangeObject = dataType.fRangeObject;
        }
        byte cleanDirection = this.getDirection();
        byte dataTypeCleanDirection = dataType.getDirection();
        boolean bl = addImplicitOffset = this.hasImplicitDirection() || dataType.hasImplicitDirection();
        if (this.fDirection == 0) {
            this.fDirection = dataType.fDirection;
        } else if (cleanDirection == 1 && dataTypeCleanDirection == 3) {
            this.fDirection = (byte)(addImplicitOffset ? (int)RfElement.getImplicitDirection((byte)2) : 2);
        } else if (cleanDirection == 3 && dataTypeCleanDirection == 1) {
            this.fDirection = (byte)(addImplicitOffset ? (int)RfElement.getImplicitDirection((byte)2) : 2);
        }
    }

    public DataType copy() {
        DataType result = new DataType();
        result.init(this);
        return result;
    }

    protected void init(DataType dataType) {
        this.fIsVerilog = dataType.fIsVerilog;
        this.fType = dataType.fType;
        this.fEscaped = dataType.fEscaped;
        this.fDirection = dataType.fDirection;
        this.fSign = dataType.fSign;
        this.fLine = dataType.fLine;
        this.fOffset = dataType.fOffset;
        this.fIsInsideMacro = dataType.fIsInsideMacro;
        this.fPackedDimension = dataType.fPackedDimension;
        this.fUnpackedDimension = dataType.fUnpackedDimension;
        this.fNetType = dataType.fNetType;
        this.fDiscipline = dataType.fDiscipline;
        this.fIsInherited = dataType.fIsInherited;
        this.fPackageScope = dataType.fPackageScope;
        this.fOrderedParamAssignments = dataType.fOrderedParamAssignments != null ? new ArrayList<DataType>(dataType.fOrderedParamAssignments) : null;
        this.fNamedParamAssignments = dataType.fNamedParamAssignments != null ? new LinkedHashMap<String, ArgInfo>(dataType.fNamedParamAssignments) : null;
        this.fInnerClassesInfo = null;
        if (dataType.fInnerClassesInfo != null) {
            this.fInnerClassesInfo = new ArrayList<DataType>(dataType.fInnerClassesInfo.size());
            for (DataType innerClass : dataType.fInnerClassesInfo) {
                this.fInnerClassesInfo.add(innerClass.copy());
            }
        }
        this.fVirtualInterface = dataType.fVirtualInterface;
        this.fEnumRange = dataType.fEnumRange;
        this.updateParamValuesHolder((IHidHolder)dataType.fParamValuesHolder);
        this.fRangeObject = dataType.fRangeObject;
        this.fParametricDependencyValue = dataType.fParametricDependencyValue;
    }

    @Override
    public String getType() {
        if (this.fType == null) {
            return this.fIsVerilog ? this.fDiscipline : null;
        }
        return this.fType;
    }

    public String getRawType() {
        return this.fType;
    }

    public String getTypeName(String implicitTypeName, String implicitNetType) {
        return this.getTypeName(implicitTypeName, implicitNetType, null, false);
    }

    public String getTypeName(String implicitTypeName, String implicitNetType, ParserPath path, boolean keepMacros) {
        return this.getTypeName(implicitTypeName, implicitNetType, path, false, keepMacros, false);
    }

    public String getTypeName(String implicitTypeName, String implicitNetType, boolean variableDecl) {
        return this.getTypeName(implicitTypeName, implicitNetType, null, variableDecl, false, false);
    }

    public String getTypeName(String implicitTypeName, String implicitNetType, ParserPath path, boolean variableDecl, boolean keepMacros, boolean addUnpackedDimension) {
        return this.getCompleteTypeName(this.getScopeAndTypeName(implicitTypeName), implicitNetType, path, variableDecl, keepMacros, addUnpackedDimension);
    }

    public String getCompleteTypeName(String partialTypeName, String implicitNetType, ParserPath path, boolean variableDecl, boolean keepMacros, boolean addUnpackedDimensions) {
        if (partialTypeName == null) {
            return "";
        }
        StringBuilder result = new StringBuilder("interconnect".equals(this.fNetType) ? "" : partialTypeName);
        if (partialTypeName.startsWith("struct/")) {
            result = new StringBuilder("struct");
        } else if (partialTypeName.startsWith("union/")) {
            result = new StringBuilder("union");
        } else if (partialTypeName.startsWith("enum/")) {
            result = new StringBuilder("enum");
        }
        if (this.getSign() != 0) {
            result.append(this.getSign() == 1 ? " signed" : " unsigned");
        }
        if (this.fPackedDimension != null) {
            result.append(keepMacros ? this.getPackedDimensionWithMacros(path) : this.getPackedDimensionString());
        }
        if (this.fUnpackedDimension != null && addUnpackedDimensions) {
            result.append(" #").append(keepMacros ? this.getUnpackedDimensionWithMacros(path) : this.getUnpackedDimensionString());
        }
        if (variableDecl) {
            return result.toString();
        }
        if (this.fNetType != null) {
            result = new StringBuilder(this.fNetType).append(" ").append((CharSequence)result);
        } else if (implicitNetType != null && !implicitNetType.isEmpty()) {
            result = new StringBuilder(implicitNetType).append(" ").append((CharSequence)result);
        }
        result = this.fVirtualInterface == 2 ? new StringBuilder("virtual interface ").append((CharSequence)result) : (this.fVirtualInterface == 1 ? new StringBuilder("virtual ").append((CharSequence)result) : result);
        return result.toString();
    }

    public String getScopeAndTypeName(String implicitTypeName) {
        StringBuilder result = new StringBuilder();
        if (this.fDiscipline != null && !this.fDiscipline.isEmpty()) {
            if (this.fType != null && !this.fType.isEmpty() && !this.fType.equals(implicitTypeName)) {
                result.append(this.fType);
            }
            result.append(" ").append(this.fDiscipline);
        } else if (this.fType != null && !this.fType.isEmpty()) {
            if (this.fType.startsWith("struct/")) {
                result.append("struct");
            } else if (this.fType.startsWith("union/")) {
                result.append("union");
            } else if (this.fType.startsWith("enum/")) {
                result.append("enum");
            } else {
                if (this.fPackageScope != null) {
                    result.append(this.fPackageScope.getType()).append("::");
                }
                result.append(this.fType);
            }
        } else if (implicitTypeName != null) {
            if (this.fPackageScope != null) {
                result.append(this.fPackageScope.getType()).append("::");
            }
            result.append(implicitTypeName);
        } else if (this.fPackageScope != null) {
            result.append(this.fPackageScope.getType()).append("::");
        }
        if (this.fInnerClassesInfo != null) {
            for (DataType innerClass : this.fInnerClassesInfo) {
                result.append("::").append(innerClass.getTypeName(implicitTypeName, null));
            }
        }
        return result.toString();
    }

    public String getTypeNameWithParamAssignments() {
        return this.getTypeNameWithParamAssignments(null, false, false);
    }

    public String getTypeNameWithParamAssignments(ParserPath path, boolean keepMacros, boolean addUnpackedDimension) {
        return this.getTypeNameWithParamAssignments("logic", path, keepMacros, addUnpackedDimension);
    }

    public String getTypeNameWithParamAssignments(String implicitTypeName, boolean addUnpackedDimension) {
        return this.getTypeNameWithParamAssignments(implicitTypeName, null, false, addUnpackedDimension);
    }

    public String getTypeNameWithParamAssignments(String implicitTypeName, ParserPath path, boolean keepMacros, boolean addUnpackedDimension) {
        try {
            StringBuilder result = new StringBuilder(this.getTypeName(implicitTypeName, null, path, false, keepMacros, addUnpackedDimension));
            if (this.fOrderedParamAssignments != null && !this.fOrderedParamAssignments.isEmpty()) {
                result.append("#(");
                int size = this.fOrderedParamAssignments.size();
                int i = 0;
                while (i < size) {
                    DataType orderedParamDT = this.fOrderedParamAssignments.get(i);
                    result.append(orderedParamDT.getTypeNameWithParamAssignments(implicitTypeName, path, keepMacros, addUnpackedDimension));
                    if (i < size - 1) {
                        result.append(", ");
                    }
                    ++i;
                }
                result.append(')');
            } else if (this.fNamedParamAssignments != null && !this.fNamedParamAssignments.isEmpty()) {
                result.append("#(");
                Iterator<ArgInfo> iterator = this.fNamedParamAssignments.values().iterator();
                while (iterator.hasNext()) {
                    ArgInfo namedParam = iterator.next();
                    DataType namedParamDT = namedParam.getDataType();
                    if (namedParamDT == null) continue;
                    result.append('.').append(namedParam.getName()).append('(').append(namedParamDT.getTypeNameWithParamAssignments(implicitTypeName, path, keepMacros, addUnpackedDimension)).append(')');
                    if (!iterator.hasNext()) continue;
                    result.append(", ");
                }
                result.append(')');
            }
            String string = result.toString();
            return string;
        }
        finally {
            if (keepMacros) {
                CharBufferCacher.getInstance().clearCache();
            }
        }
    }

    public List<IndexType> getPackedDimension() {
        return this.fPackedDimension;
    }

    public String getPackedDimensionString() {
        if (this.fPackedDimension == null || this.fPackedDimension.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (IndexType indexType : this.fPackedDimension) {
            result.append('[').append(indexType.fType).append(']');
        }
        return result.toString();
    }

    public void setPackedDimension(List<IndexType> packedDimension) {
        this.fPackedDimension = packedDimension;
    }

    public void appendPackedDimension(IndexType dimension) {
        this.fPackedDimension = DataTypeDimensions.appendDimension(this.fPackedDimension, dimension);
    }

    public void appendPackedDimension(List<IndexType> dimensions) {
        this.fPackedDimension = DataTypeDimensions.appendDimension(this.fPackedDimension, dimensions);
    }

    public List<IndexType> getUnpackedDimension() {
        return this.fUnpackedDimension;
    }

    public String getUnpackedDimensionString() {
        if (this.fUnpackedDimension == null || this.fUnpackedDimension.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (IndexType indexType : this.fUnpackedDimension) {
            result.append('[');
            if (indexType instanceof DataType) {
                result.append(((DataType)indexType).getTypeName(null, null));
            } else {
                result.append(indexType.fType);
            }
            result.append(']');
        }
        return result.toString();
    }

    public static boolean is2State(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return false;
        }
        return "bit".equals(typeName) || "byte".equals(typeName) || "shortint".equals(typeName) || "int".equals(typeName) || "longint".equals(typeName);
    }

    public static boolean is4State(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return true;
        }
        return "logic".equals(typeName) || "reg".equals(typeName) || "integer".equals(typeName) || "time".equals(typeName);
    }

    public static boolean isPredefinedScalar(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return false;
        }
        return "bit".equals(typeName) || "byte".equals(typeName) || "shortint".equals(typeName) || "int".equals(typeName) || "longint".equals(typeName) || "logic".equals(typeName) || "reg".equals(typeName) || "integer".equals(typeName) || "time".equals(typeName) || "shortreal".equals(typeName) || "realtime".equals(typeName) || "real".equals(typeName) || "string".equals(typeName) || "chandle".equals(typeName);
    }

    @Deprecated
    public BitVectorContext getBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        BitVectorContext context = this.internalFastGetBitVectorContext(origin);
        if (context != null) {
            return context;
        }
        ELManager manager = evaluator.getManager();
        if (manager == null) {
            return this.internalGetBitVectorContext(evaluator, guardian, origin);
        }
        manager.state.incrementDataTypeCacheCounts();
        Map dataTypeContexts = manager.getDataTypeCache(Thread.currentThread());
        if (dataTypeContexts == null) {
            return this.internalGetBitVectorContext(evaluator, guardian, origin);
        }
        BitVectorContext cachedContext = (BitVectorContext)dataTypeContexts.get(this);
        if (cachedContext != null && !evaluator.noDataTypeCache()) {
            manager.state.incrementDataTypeCacheHits();
            return cachedContext;
        }
        BitVectorContext result = this.internalGetBitVectorContext(evaluator, guardian, origin);
        if (result != null && !evaluator.noDataTypeCache()) {
            dataTypeContexts.put(this, result);
        }
        return result;
    }

    private static DVTNumber internalGetSignedBitVectorContext(String type) {
        switch (type) {
            case "string": {
                return STRING_CONTEXT;
            }
            case "bit": {
                return BIT_SIGNED_CONTEXT;
            }
            case "reg": 
            case "logic": {
                return LOGIC_SIGNED_CONTEXT;
            }
            case "byte": {
                return BYTE_SIGNED_CONTEXT;
            }
            case "shortint": {
                return SHORT_SIGNED_CONTEXT;
            }
            case "int": {
                return INT_SIGNED_CONTEXT;
            }
            case "integer": {
                return INTEGER_SIGNED_CONTEXT;
            }
            case "time": {
                return TIME_SIGNED_CONTEXT;
            }
            case "longint": {
                return LONG_SIGNED_CONTEXT;
            }
            case "shortreal": {
                return VlogShortrealNumber.ZERO;
            }
            case "realtime": 
            case "real": {
                return VlogRealNumber.ZERO;
            }
        }
        return null;
    }

    private static DVTNumber internalGetUnsignedBitVectorContext(String type) {
        switch (type) {
            case "string": {
                return STRING_CONTEXT;
            }
            case "bit": {
                return BIT_UNSIGNED_CONTEXT;
            }
            case "reg": 
            case "logic": {
                return LOGIC_UNSIGNED_CONTEXT;
            }
            case "byte": {
                return BYTE_UNSIGNED_CONTEXT;
            }
            case "shortint": {
                return SHORT_UNSIGNED_CONTEXT;
            }
            case "int": {
                return INT_UNSIGNED_CONTEXT;
            }
            case "integer": {
                return INTEGER_UNSIGNED_CONTEXT;
            }
            case "time": {
                return TIME_UNSIGNED_CONTEXT;
            }
            case "longint": {
                return LONG_UNSIGNED_CONTEXT;
            }
            case "shortreal": {
                return VlogShortrealNumber.ZERO;
            }
            case "realtime": 
            case "real": {
                return VlogRealNumber.ZERO;
            }
        }
        return null;
    }

    private static DVTNumber internalGetDefaultBitVectorContext(String type) {
        switch (type) {
            case "string": {
                return STRING_CONTEXT;
            }
            case "bit": {
                return BIT_UNSIGNED_CONTEXT;
            }
            case "reg": 
            case "logic": {
                return LOGIC_UNSIGNED_CONTEXT;
            }
            case "byte": {
                return BYTE_SIGNED_CONTEXT;
            }
            case "shortint": {
                return SHORT_SIGNED_CONTEXT;
            }
            case "int": {
                return INT_SIGNED_CONTEXT;
            }
            case "integer": {
                return INTEGER_SIGNED_CONTEXT;
            }
            case "time": {
                return TIME_UNSIGNED_CONTEXT;
            }
            case "longint": {
                return LONG_SIGNED_CONTEXT;
            }
            case "shortreal": {
                return VlogShortrealNumber.ZERO;
            }
            case "realtime": 
            case "real": {
                return VlogRealNumber.ZERO;
            }
        }
        return null;
    }

    public BitVectorContext internalFastGetBitVectorContext(IRfNamedElement origin) {
        DVTNumber baseContextNumber;
        String type;
        List<IndexType> packed = this.getPackedDimension();
        List<IndexType> unpacked = this.getUnpackedDimension();
        if (packed != null || unpacked != null) {
            return null;
        }
        String string = type = this.fType != null && !this.fType.isEmpty() ? this.fType : "logic";
        DVTNumber dVTNumber = this.fSign == 2 ? DataType.internalGetUnsignedBitVectorContext(type) : (baseContextNumber = this.fSign == 1 ? DataType.internalGetSignedBitVectorContext(type) : DataType.internalGetDefaultBitVectorContext(type));
        if (baseContextNumber == null) {
            return null;
        }
        RfNamedElement namedElement = RfProject.getSimpleType(this);
        return BitVectorContext.of((DVTNumber)baseContextNumber, (IRfNamedElement)namedElement, (IRfNamedElement)origin);
    }

    private BitVectorContext internalGetBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        DVTNumber baseContextNumber;
        String type;
        String string = type = this.fType != null && !this.fType.isEmpty() ? this.fType : "logic";
        DVTNumber dVTNumber = this.fSign == 2 ? DataType.internalGetUnsignedBitVectorContext(type) : (baseContextNumber = this.fSign == 1 ? DataType.internalGetSignedBitVectorContext(type) : DataType.internalGetDefaultBitVectorContext(type));
        if (baseContextNumber == null) {
            BitVectorContext noContext;
            if ("chandle".equals(type)) {
                return null;
            }
            if ("void".equals(type)) {
                return null;
            }
            if ("*".equals(type)) {
                return null;
            }
            Hid hidForType = this.hidForType();
            IELParamValue typeValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)hidForType, (IHidEvaluator)evaluator, (BitVectorContext)(noContext = BitVectorContext.of((IRfNamedElement)origin, (boolean)true)), (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)typeValue)) {
                return null;
            }
            baseContextNumber = typeValue.getDVTNumber();
            if (DVTNumber.isUndefined((DVTNumber)baseContextNumber)) {
                return null;
            }
        }
        List<IndexType> packed = this.getPackedDimension();
        List<IndexType> unpacked = this.getUnpackedDimension();
        if (packed == null && unpacked == null) {
            return BitVectorContext.of((DVTNumber)baseContextNumber, null, (IRfNamedElement)origin);
        }
        int[] packedInts = null;
        if (baseContextNumber instanceof VlogBitVector && packed != null && !packed.isEmpty()) {
            boolean isString;
            int nofBitsFromPackedDimension = baseContextNumber.getSize();
            packedInts = new int[2 * packed.size()];
            BitVectorContext dummyContextOrigin = BitVectorContext.of((IRfNamedElement)origin, (boolean)true);
            int i = 0;
            while (i < packed.size()) {
                IHidObject rangeObject = packed.get(i).getRangeObject();
                if (rangeObject == null) {
                    return null;
                }
                switch (rangeObject.getHidKind()) {
                    case HID: 
                    case IMPLICIT: 
                    case ACCESS: {
                        IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)rangeObject, (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                        if (ELUtils.isUnsuccessfulEval((IELParamValue)value) || !(value instanceof ELParamValues.ParamValueNumber)) {
                            return null;
                        }
                        if (value.isUnknown()) {
                            return BitVectorContext.of((DVTNumber)VlogBitVector.createForSize((boolean)baseContextNumber.hasSign(), (int)0, (int)0, null, (boolean)baseContextNumber.is4State(), (boolean)((VlogBitVector)baseContextNumber).isString(), (boolean)false, (boolean)true, null, null), (IRfNamedElement)origin);
                        }
                        int intValue = value.intValue();
                        if (intValue <= 0) {
                            return null;
                        }
                        packedInts[2 * i] = 0;
                        packedInts[2 * i + 1] = intValue - 1;
                        nofBitsFromPackedDimension *= intValue;
                        break;
                    }
                    case OPERATOR: {
                        guardian.markEvaluated((IHidOperator)((RfHidOperator)rangeObject));
                        if (!((RfHidOperator)rangeObject).isRangeOrPartSelect()) {
                            IELParamValue exprValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)rangeObject, (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                            if (ELUtils.isUnsuccessfulEval((IELParamValue)exprValue) || !(exprValue instanceof ELParamValues.ParamValueNumber)) {
                                return null;
                            }
                            if (exprValue.isUnknown()) {
                                return BitVectorContext.of((DVTNumber)VlogBitVector.createForSize((boolean)baseContextNumber.hasSign(), (int)0, (int)0, null, (boolean)baseContextNumber.is4State(), (boolean)((VlogBitVector)baseContextNumber).isString(), (boolean)false, (boolean)true, null, null), (IRfNamedElement)origin);
                            }
                            int exprIntValue = exprValue.intValue();
                            if (exprIntValue <= 0) {
                                return null;
                            }
                            packedInts[2 * i] = 0;
                            packedInts[2 * i + 1] = exprIntValue - 1;
                            nofBitsFromPackedDimension *= exprIntValue;
                            break;
                        }
                        ListContainer rhValues = ((RfHidOperator)rangeObject).getRHValues();
                        if (rhValues == null || rhValues.isEmpty()) {
                            return null;
                        }
                        IELParamValue lhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((RfHidOperator)rangeObject).getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                        if (ELUtils.isUnsuccessfulEval((IELParamValue)lhValue) || !(lhValue instanceof ELParamValues.ParamValueNumber)) {
                            return null;
                        }
                        if (lhValue.isUnknown()) {
                            return BitVectorContext.of((DVTNumber)VlogBitVector.createForSize((boolean)baseContextNumber.hasSign(), (int)0, (int)0, null, (boolean)baseContextNumber.is4State(), (boolean)((VlogBitVector)baseContextNumber).isString(), (boolean)false, (boolean)true, null, null), (IRfNamedElement)origin);
                        }
                        IELParamValue rhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rhValues.get(0)), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                        if (ELUtils.isUnsuccessfulEval((IELParamValue)rhValue) || !(rhValue instanceof ELParamValues.ParamValueNumber)) {
                            return null;
                        }
                        if (rhValue.isUnknown()) {
                            return BitVectorContext.of((DVTNumber)VlogBitVector.createForSize((boolean)baseContextNumber.hasSign(), (int)0, (int)0, null, (boolean)baseContextNumber.is4State(), (boolean)((VlogBitVector)baseContextNumber).isString(), (boolean)false, (boolean)true, null, null), (IRfNamedElement)origin);
                        }
                        packedInts[2 * i] = lhValue.intValue();
                        packedInts[2 * i + 1] = rhValue.intValue();
                        int newDimensionSize = Math.abs(lhValue.intValue() - rhValue.intValue()) + 1;
                        if (newDimensionSize < 0) {
                            this.logOverflowError(rangeObject, origin, guardian);
                            return null;
                        }
                        nofBitsFromPackedDimension *= newDimensionSize;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ++i;
            }
            Map memberInfoToUpdate = null;
            boolean is4State = baseContextNumber.is4State();
            boolean bl = isString = baseContextNumber instanceof VlogBitVector && ((VlogBitVector)baseContextNumber).isString();
            if (baseContextNumber instanceof VlogBitVector && ((VlogBitVector)baseContextNumber).isStruct(true)) {
                memberInfoToUpdate = ((VlogBitVector)baseContextNumber).getMemberInfoByName();
                int[] dimensions = ((VlogBitVector)baseContextNumber).getArrayDimensions();
                newPackedInts = new int[packedInts.length + dimensions.length];
                System.arraycopy(packedInts, 0, newPackedInts, 0, packedInts.length);
                System.arraycopy(dimensions, 0, newPackedInts, packedInts.length, dimensions.length);
                packedInts = newPackedInts;
                baseContextNumber = VlogBitVector.createForSize((boolean)this.isSigned(), (int)(nofBitsFromPackedDimension - 1), (int)0, (int[])packedInts, (boolean)is4State, (boolean)isString, (boolean)((VlogBitVector)baseContextNumber).isUnion(), (boolean)false, (Map)memberInfoToUpdate, null);
            } else if (baseContextNumber instanceof VlogBitVector && ((VlogBitVector)baseContextNumber).getFirstDimensionSize() > 1) {
                int[] dimensions = ((VlogBitVector)baseContextNumber).getArrayDimensions();
                newPackedInts = new int[packedInts.length + dimensions.length];
                System.arraycopy(packedInts, 0, newPackedInts, 0, packedInts.length);
                System.arraycopy(dimensions, 0, newPackedInts, packedInts.length, dimensions.length);
                packedInts = newPackedInts;
                baseContextNumber = VlogBitVector.createForSize((boolean)this.isSigned(), (int)(nofBitsFromPackedDimension - 1), (int)0, (int[])packedInts, (boolean)is4State, (boolean)isString, (boolean)false, (boolean)false, (Map)memberInfoToUpdate, null);
            } else {
                baseContextNumber = VlogBitVector.createForSize((boolean)this.isSigned(), (int)(nofBitsFromPackedDimension - 1), (int)0, (int[])packedInts, (boolean)is4State, (boolean)isString, (boolean)false, (boolean)false, (Map)memberInfoToUpdate, null);
            }
        }
        if (unpacked == null || unpacked.isEmpty()) {
            return BitVectorContext.of((DVTNumber)baseContextNumber, null, (IRfNamedElement)origin);
        }
        int[][] unpackedInts = new int[unpacked.size()][2];
        int i = 0;
        while (i < unpacked.size()) {
            IHidObject rangeObject = unpacked.get(i).getRangeObject();
            if (rangeObject == null) {
                return null;
            }
            BitVectorContext dummyContextOrigin = BitVectorContext.of((IRfNamedElement)origin, (boolean)true);
            switch (rangeObject.getHidKind()) {
                case HID: 
                case IMPLICIT: 
                case ACCESS: {
                    RfHidImplicit rfHidImplicit;
                    if (rangeObject instanceof RfHidImplicit && ((rfHidImplicit = (RfHidImplicit)rangeObject).isEmptyType() || rfHidImplicit.isDollar() || rfHidImplicit.isStar())) {
                        unpackedInts[i] = new int[]{-1, -1};
                        break;
                    }
                    IHid hidFrom = HidUtils.getHidFrom((IHidObject)rangeObject);
                    if (hidFrom instanceof Hid && ((Hid)hidFrom).getElement() instanceof IRfTypeElement) {
                        unpackedInts[i] = new int[]{-1, -1};
                        break;
                    }
                    if (rangeObject instanceof RfHidImplicit && ((RfHidImplicit)rangeObject).getType() == 493 || rangeObject instanceof RfHidImplicit && ((RfHidImplicit)rangeObject).getType() == 244) break;
                    IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)rangeObject, (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                    if (ELUtils.isUnsuccessfulEval((IELParamValue)value) || !(value instanceof ELParamValues.ParamValueNumber) || value instanceof ELParamValues.ParamValueType) {
                        unpackedInts[i] = new int[]{-1, -1};
                        break;
                    }
                    int intValue = value.intValue();
                    if (intValue <= 0) {
                        return null;
                    }
                    int[] nArray = new int[2];
                    nArray[1] = intValue - 1;
                    unpackedInts[i] = nArray;
                    break;
                }
                case OPERATOR: {
                    if (!((RfHidOperator)rangeObject).isRangeOrPartSelect()) {
                        return null;
                    }
                    ListContainer rhValues = ((RfHidOperator)rangeObject).getRHValues();
                    if (rhValues == null || rhValues.isEmpty()) {
                        return null;
                    }
                    IHidObject lhRange = ((RfHidOperator)rangeObject).getLHValue();
                    if (HidUtils.isHidImplicit((IHidObject)lhRange) && ((IRfHidImplicitLayer)lhRange).isDollar()) {
                        unpackedInts[i] = new int[]{-1, -1};
                        break;
                    }
                    IELParamValue lhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)lhRange, (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                    if (ELUtils.isUnsuccessfulEval((IELParamValue)lhValue) || !(lhValue instanceof ELParamValues.ParamValueNumber)) {
                        return null;
                    }
                    IELParamValue rhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rhValues.get(0)), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                    if (ELUtils.isUnsuccessfulEval((IELParamValue)rhValue) || !(rhValue instanceof ELParamValues.ParamValueNumber)) {
                        return null;
                    }
                    int newDimensionSize = Math.abs(lhValue.intValue() - rhValue.intValue()) + 1;
                    if (newDimensionSize < 0) {
                        this.logOverflowError(rangeObject, origin, guardian);
                        return null;
                    }
                    unpackedInts[i] = new int[]{lhValue.intValue(), rhValue.intValue()};
                    break;
                }
                default: {
                    return null;
                }
            }
            ++i;
        }
        baseContextNumber = DVTUnpackedArray.of((int[][])unpackedInts, (DVTNumber)(baseContextNumber == null ? LOGIC_UNSIGNED_CONTEXT : baseContextNumber));
        return BitVectorContext.of((DVTNumber)baseContextNumber, null, (IRfNamedElement)origin);
    }

    private void logOverflowError(IHidObject rangeObject, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
        if (origin == null) {
            return;
        }
        if (guardian.isInterpreter()) {
            guardian.logError(MessageFormat.format("ARRAY_DIMENSION_OVERFLOW: Array dimension ''{0}'' of ''{1}'' overflows integer range", HidUtils.toStringBuilder((IHidObject)rangeObject, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false), origin.getName()));
        } else {
            guardian.report((UnknownEvaluationException)new OverflowDimensionEvaluationException(rangeObject, origin.getName()));
        }
    }

    protected Hid hidForType() {
        Hid hidForPackage;
        int dotPosition;
        if (this.fType == null || this.fType.isEmpty()) {
            return null;
        }
        Hid hidForType = null;
        int n = dotPosition = this.fType.startsWith("enum/") || this.fType.startsWith("struct/") || this.fType.startsWith("union/") ? -1 : this.fType.indexOf(46);
        if (dotPosition == -1) {
            hidForType = STransformer.BUILDERS.buildHid(this.fType, null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            hidForType.addQualifier(HidQualifierCache.TYPE_QUALIFIER);
        } else {
            Hid interfaceHid = STransformer.BUILDERS.buildHid(this.fType.substring(0, dotPosition), null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            Hid modportHid = STransformer.BUILDERS.buildHid(this.fType.substring(dotPosition + 1), null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            STransformer.BUILDERS.buildAccess(interfaceHid, modportHid, 0);
            hidForType = modportHid;
        }
        if (this.fPackageScope != null && (hidForPackage = this.fPackageScope.hidForType()) != null) {
            hidForPackage.addQualifier(HidQualifierCache.TYPE_QUALIFIER);
            STransformer.BUILDERS.buildAccess(hidForPackage, hidForType, 2);
        }
        return hidForType;
    }

    public String getUnpackedDimensionWithMacros(ParserPath path) {
        if (this.fUnpackedDimension == null || this.fUnpackedDimension.isEmpty() || path == null) {
            return "";
        }
        CharBuffer charBuffer = null;
        try {
            charBuffer = CharBufferCacher.getInstance().getBuffer(path.toString());
            StringBuilder result = new StringBuilder();
            int prevStartIndex = -1;
            int lastPosition = 0;
            for (IndexType indexType : this.fUnpackedDimension) {
                int[] offsets = indexType.getBoundaries();
                if (offsets == null) {
                    result.append("[").append(indexType.fType).append("]");
                    continue;
                }
                if (offsets[1] - offsets[0] <= 1) {
                    result.append("[").append(indexType.fType).append("]");
                    continue;
                }
                if (offsets[0] < prevStartIndex) {
                    CharBufferCacher.getInstance().clearCache();
                    charBuffer = CharBufferCacher.getInstance().getBuffer(path.toString());
                    lastPosition = 0;
                }
                prevStartIndex = offsets[0];
                lastPosition = DataType.readFromFileBetweenOffsetsInclusive(charBuffer, offsets, lastPosition, result);
            }
            return result.toString();
        }
        catch (Exception ex) {
            CharBufferCacher.getInstance().clearCache();
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return this.getUnpackedDimensionString();
        }
    }

    public String getPackedDimensionWithMacros(ParserPath path) {
        if (this.fPackedDimension == null || this.fPackedDimension.isEmpty() || path == null) {
            return "";
        }
        CharBuffer charBuffer = null;
        try {
            charBuffer = CharBufferCacher.getInstance().getBuffer(path.toString());
            StringBuilder result = new StringBuilder();
            int prevStartIndex = -1;
            int lastPosition = 0;
            for (IndexType indexType : this.fPackedDimension) {
                int[] offsets = indexType.getBoundaries();
                if (offsets == null) {
                    result.append("[").append(indexType.fType).append("]");
                    continue;
                }
                if (offsets[1] - offsets[0] <= 1) {
                    result.append("[").append(indexType.fType).append("]");
                    continue;
                }
                if (offsets[0] < prevStartIndex) {
                    CharBufferCacher.getInstance().clearCache();
                    charBuffer = CharBufferCacher.getInstance().getBuffer(path.toString());
                    lastPosition = 0;
                }
                prevStartIndex = offsets[0];
                lastPosition = DataType.readFromFileBetweenOffsetsInclusive(charBuffer, offsets, lastPosition, result);
            }
            return result.toString();
        }
        catch (Exception ex) {
            CharBufferCacher.getInstance().clearCache();
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return this.getPackedDimensionString();
        }
    }

    public static int readFromFileBetweenOffsetsInclusive(CharBuffer charBuffer, int[] offsets, int lastPosition, StringBuilder builder) throws Exception {
        if (charBuffer == null || builder == null || offsets == null || offsets.length != 2 || lastPosition < 0) {
            return 0;
        }
        if (offsets[1] <= offsets[0]) {
            return 0;
        }
        int i = lastPosition;
        while (i < offsets[0]) {
            charBuffer.consume();
            ++i;
        }
        i = offsets[0];
        while (i < offsets[1]) {
            char LA = charBuffer.LA(1);
            if (LA == '\uffff') {
                throw new FileOutOfBoundsException();
            }
            if (i == offsets[0] && LA != '[') {
                builder.append('[');
            }
            builder.append(LA);
            if (i == offsets[1] - 1 && LA != ']') {
                builder.append(']');
            }
            charBuffer.consume();
            ++i;
        }
        return offsets[1];
    }

    public void setUnpackedDimension(List<IndexType> dimension) {
        this.fUnpackedDimension = dimension;
    }

    public void appendUnpackedDimension(IndexType dimension) {
        this.fUnpackedDimension = DataTypeDimensions.appendDimension(this.fUnpackedDimension, dimension);
    }

    public void appendUnpackedDimension(List<IndexType> dimensions) {
        this.fUnpackedDimension = DataTypeDimensions.appendDimension(this.fUnpackedDimension, dimensions);
    }

    public byte getDirection() {
        return RfElement.getDirection(this.fDirection);
    }

    public byte getRawDirection() {
        return this.fDirection;
    }

    public void setDirection(int direction) {
        this.fDirection = (byte)direction;
    }

    public void setType(String type, int line, int offset) {
        this.setType(type);
        this.fLine = line;
        this.fOffset = offset;
    }

    public void setType(String type) {
        this.fType = DVTStringUtil.unescapeIdentifier((String)type, (boolean)true);
        this.fEscaped = type != null && type.length() != this.fType.length();
    }

    public void setDiscipline(String discipline) {
        this.fDiscipline = DVTStringUtil.unescapeIdentifier((String)discipline, (boolean)true);
        this.fEscaped = discipline != null && discipline.length() != this.fDiscipline.length();
    }

    public int getLine() {
        return this.fLine;
    }

    public void setLine(int line) {
        this.fLine = line;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public boolean isInsideMacro() {
        return this.fIsInsideMacro;
    }

    public void setIsInsideMacro(boolean isInsideMacroCall) {
        this.fIsInsideMacro = isInsideMacroCall;
    }

    public void setEnumRange(String range) {
        this.fEnumRange = DVTStringUtil.intern((String)range);
    }

    public String getEnumRange() {
        return this.fEnumRange;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.fDirection;
        result = 31 * result + (this.fEnumRange == null ? 0 : this.fEnumRange.hashCode());
        result = 31 * result + (this.fEscaped ? 1231 : 1237);
        result = 31 * result + (this.fInnerClassesInfo == null ? 0 : this.fInnerClassesInfo.hashCode());
        result = 31 * result + (this.fNamedParamAssignments == null ? 0 : this.fNamedParamAssignments.hashCode());
        result = 31 * result + (this.fNetType == null ? 0 : this.fNetType.hashCode());
        result = 31 * result + (this.fDiscipline == null ? 0 : this.fDiscipline.hashCode());
        result = 31 * result + (this.fOrderedParamAssignments == null ? 0 : this.fOrderedParamAssignments.hashCode());
        result = 31 * result + (this.fPackedDimension == null ? 0 : this.fPackedDimension.hashCode());
        result = 31 * result + (this.fPackageScope == null ? 0 : this.fPackageScope.hashCode());
        result = 31 * result + this.fSign;
        result = 31 * result + (this.fUnpackedDimension == null ? 0 : this.fUnpackedDimension.hashCode());
        result = 31 * result + this.fVirtualInterface;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.fDirection != other.fDirection) {
            return false;
        }
        if (this.fSign != other.fSign) {
            return false;
        }
        if (this.fVirtualInterface != other.fVirtualInterface) {
            return false;
        }
        if (this.fType == null ? other.fType != null : !this.fType.equals(other.fType)) {
            return false;
        }
        if (this.fNetType == null ? other.fNetType != null : !this.fNetType.equals(other.fNetType)) {
            return false;
        }
        if (this.fDiscipline == null ? other.fDiscipline != null : !this.fDiscipline.equals(other.fDiscipline)) {
            return false;
        }
        if (this.fPackageScope == null ? other.fPackageScope != null : !this.fPackageScope.equals(other.fPackageScope)) {
            return false;
        }
        if (this.fUnpackedDimension == null ? other.fUnpackedDimension != null && !other.fUnpackedDimension.isEmpty() : !this.fUnpackedDimension.equals(other.fUnpackedDimension)) {
            return false;
        }
        if (this.fEnumRange == null ? other.fEnumRange != null : !this.fEnumRange.equals(other.fEnumRange)) {
            return false;
        }
        if (this.fPackedDimension == null ? other.fPackedDimension != null && !other.fPackedDimension.isEmpty() : !this.fPackedDimension.equals(other.fPackedDimension)) {
            return false;
        }
        if (this.fOrderedParamAssignments == null ? other.fOrderedParamAssignments != null : !this.fOrderedParamAssignments.equals(other.fOrderedParamAssignments)) {
            return false;
        }
        return !(this.fNamedParamAssignments == null ? other.fNamedParamAssignments != null : !this.fNamedParamAssignments.equals(other.fNamedParamAssignments));
    }

    public boolean equalsChangedFieldAndMethodDataType(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.fSign != other.fSign) {
            return false;
        }
        if (this.fType == null ? other.fType != null : !this.fType.equals(other.fType)) {
            return false;
        }
        if (this.fPackageScope == null ? other.fPackageScope != null : !this.fPackageScope.equals(other.fPackageScope)) {
            return false;
        }
        if (this.fUnpackedDimension == null ? other.fUnpackedDimension != null && !other.fUnpackedDimension.isEmpty() : !this.fUnpackedDimension.equals(other.fUnpackedDimension)) {
            return false;
        }
        return !(this.fPackedDimension == null ? other.fPackedDimension != null && !other.fPackedDimension.isEmpty() : !this.fPackedDimension.equals(other.fPackedDimension));
    }

    public boolean equalsDataTypeClassParent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.fType == null ? other.fType != null : !this.fType.equals(other.fType)) {
            return false;
        }
        if (this.fPackageScope == null ? other.fPackageScope != null : !this.fPackageScope.equals(other.fPackageScope)) {
            return false;
        }
        if (this.fOrderedParamAssignments == null ? other.fOrderedParamAssignments != null : !this.fOrderedParamAssignments.equals(other.fOrderedParamAssignments)) {
            return false;
        }
        if (this.fNamedParamAssignments == null ? other.fNamedParamAssignments != null : !this.fNamedParamAssignments.equals(other.fNamedParamAssignments)) {
            return false;
        }
        return !(this.fInnerClassesInfo == null ? other.fInnerClassesInfo != null : !this.fInnerClassesInfo.equals(other.fInnerClassesInfo));
    }

    @Override
    public boolean equalsDataTypeTypeName(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.fType == null ? other.fType != null : !this.fType.equals(other.fType)) {
            return false;
        }
        if (this.fNetType == null ? other.fNetType != null : !this.fNetType.equals(other.fNetType)) {
            return false;
        }
        return !(this.fDiscipline == null ? other.fDiscipline != null : !this.fDiscipline.equals(other.fDiscipline));
    }

    public boolean equalsDataTypeDimension(Object obj, String classPrefixIgnore) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.fUnpackedDimension == null ? other.fUnpackedDimension != null && !other.fUnpackedDimension.isEmpty() : !this.equalsDataTypeDimension(this.fUnpackedDimension, other.fUnpackedDimension, classPrefixIgnore)) {
            return false;
        }
        return !(this.fPackedDimension == null ? other.fPackedDimension != null && !other.fPackedDimension.isEmpty() : !this.equalsDataTypeDimension(this.fPackedDimension, other.fPackedDimension, classPrefixIgnore));
    }

    public boolean isInherited() {
        return this.fIsInherited;
    }

    public boolean hasParameterValues() {
        return this.fParamValuesHolder != null && !this.fParamValuesHolder.isEmpty();
    }

    public void setIsInherited(boolean isInherited) {
        this.fIsInherited = isInherited;
    }

    public boolean isVirtualInterface() {
        return this.fVirtualInterface != 0;
    }

    public byte getVirtualInterface() {
        return this.fVirtualInterface;
    }

    public void setVirtualInterface(int virtualInterface) {
        this.fVirtualInterface = (byte)virtualInterface;
    }

    public Map<String, ArgInfo> getNamedParamAssignments() {
        return this.fNamedParamAssignments;
    }

    public List<DataType> getOrderedParamAssignments() {
        return this.fOrderedParamAssignments;
    }

    public void addOrderedParamAssignment(DataType orderedAsg) {
        if (this.fOrderedParamAssignments == null) {
            this.fOrderedParamAssignments = new ArrayList<DataType>(4);
        }
        this.fOrderedParamAssignments.add(orderedAsg);
    }

    public void addNamedParamAssignment(ArgInfo namedArg) {
        if (this.fNamedParamAssignments == null) {
            this.fNamedParamAssignments = new LinkedHashMap<String, ArgInfo>(4);
        }
        this.fNamedParamAssignments.put(namedArg.getName(), namedArg);
    }

    public void setParamAssignments(DataType anotherDT) {
        if (anotherDT == null) {
            return;
        }
        if (anotherDT.fNamedParamAssignments != null) {
            if (this.fNamedParamAssignments == null) {
                this.fNamedParamAssignments = new LinkedHashMap<String, ArgInfo>(anotherDT.fNamedParamAssignments);
            } else {
                this.fNamedParamAssignments.clear();
                this.fNamedParamAssignments.putAll(anotherDT.fNamedParamAssignments);
            }
        }
        if (anotherDT.fOrderedParamAssignments != null) {
            if (this.fOrderedParamAssignments == null) {
                this.fOrderedParamAssignments = new ArrayList<DataType>(anotherDT.fOrderedParamAssignments);
            } else {
                this.fOrderedParamAssignments.clear();
                this.fOrderedParamAssignments.addAll(anotherDT.fOrderedParamAssignments);
            }
        }
    }

    public void updateParamValuesHolder(IHidHolder updater, final ParserPath filterParserPath) {
        if (!(updater instanceof HidHolder) || updater.isHidObjectsEmpty()) {
            return;
        }
        if (filterParserPath == null) {
            this.updateParamValuesHolder(updater);
            return;
        }
        if (this.fParamValuesHolder == null) {
            this.fParamValuesHolder = new RfHidHolder(null);
        }
        ((HidHolder)updater).visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidObject>(){
            private ParserPath parserPath;

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(IHidObject obj) {
                if (!filterParserPath.equals((Object)this.parserPath)) {
                    if (obj instanceof HidOperator) {
                        DataType.this.fParamValuesHolder.addOpi((HidOperator)obj, this.parserPath);
                    } else if (obj instanceof Hid) {
                        DataType.this.fParamValuesHolder.addHid((Hid)obj, this.parserPath);
                    }
                }
                return true;
            }

            public boolean enterMethodArguments() {
                return false;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
        if (this.fParamValuesHolder.isHidObjectsEmpty()) {
            this.fParamValuesHolder = null;
        }
    }

    public void updateParamValuesHolder(IHidHolder updater) {
        if (this.fParamValuesHolder == null) {
            this.fParamValuesHolder = new RfHidHolder(null);
        }
        this.fParamValuesHolder.updateHolder(updater);
        if (this.fParamValuesHolder.isHidObjectsEmpty()) {
            this.fParamValuesHolder = null;
        }
    }

    public void updateParamValuesOperators(IHidHolder updater) {
        if (this.fParamValuesHolder == null) {
            this.fParamValuesHolder = new RfHidHolder(null);
        }
        this.fParamValuesHolder.addOperators(updater);
        if (this.fParamValuesHolder.isHidObjectsEmpty()) {
            this.fParamValuesHolder = null;
        }
    }

    public void updateParamValuesHids(IHidHolder updater) {
        if (this.fParamValuesHolder == null) {
            this.fParamValuesHolder = new RfHidHolder(null);
        }
        this.fParamValuesHolder.addIdentifiers(updater);
        if (this.fParamValuesHolder.isHidObjectsEmpty()) {
            this.fParamValuesHolder = null;
        }
    }

    public RfHidHolder getParamValuesHolder() {
        return this.fParamValuesHolder;
    }

    public List<DataType> getInnerClassesInfo() {
        return this.fInnerClassesInfo;
    }

    public void addInnerClassInfo(DataType innerClass) {
        if (this.fInnerClassesInfo == null) {
            this.fInnerClassesInfo = new ArrayList<DataType>(4);
        }
        this.fInnerClassesInfo.add(innerClass);
    }

    public IndexType getFirstIndexType() {
        if (this.fUnpackedDimension == null || this.fUnpackedDimension.isEmpty()) {
            return null;
        }
        return this.fUnpackedDimension.get(0);
    }

    public IndexType getFirstAssocArrayIndexType() {
        if (this.fUnpackedDimension == null || this.fUnpackedDimension.isEmpty()) {
            return null;
        }
        for (IndexType unpackedDimension : this.fUnpackedDimension) {
            if (!(unpackedDimension instanceof DataType)) continue;
            return unpackedDimension;
        }
        return null;
    }

    public List<DataType> getIndexTypes() {
        if (this.fUnpackedDimension == null || this.fUnpackedDimension.isEmpty()) {
            return null;
        }
        ArrayList<DataType> result = null;
        for (IndexType indexType : this.fUnpackedDimension) {
            if (!(indexType instanceof DataType)) continue;
            if (result == null) {
                result = new ArrayList<DataType>(this.fUnpackedDimension.size());
            }
            result.add((DataType)indexType);
        }
        return result;
    }

    public byte getSign() {
        return this.fSign;
    }

    public void setSign(int sign) {
        this.fSign = (byte)sign;
    }

    /*
     * Exception decompiling
     */
    public boolean isSigned() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[14] lbl75 : CaseStatement: default:\u000a, @NONE, blocks:[14] lbl75 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasUnpackedDimension() {
        return this.fUnpackedDimension != null && !this.fUnpackedDimension.isEmpty();
    }

    public boolean hasPackedDimension() {
        return this.fPackedDimension != null && !this.fPackedDimension.isEmpty();
    }

    public boolean isEmpty() {
        return this.fType == null || "".equals(this.fType);
    }

    public boolean isFullyEmpty() {
        return !(!this.hasImplicitDirection() || this.fType != null && !"".equals(this.fType) || this.fNetType != null && !"".equals(this.fNetType) || this.fIsVerilog && this.fDiscipline != null && !"".equals(this.fDiscipline));
    }

    public boolean isArray() {
        return this.hasUnpackedDimension() || this.hasPackedDimension();
    }

    public boolean isQueue() {
        IndexType firstElem = this.getFirstIndexType();
        if (firstElem == null || firstElem instanceof DataType && firstElem.fType == null) {
            return false;
        }
        return firstElem.fType.startsWith("$");
    }

    public boolean isBoundQueue() {
        IndexType firstElem = this.getFirstIndexType();
        if (firstElem == null || firstElem instanceof DataType || firstElem.fType == null) {
            return false;
        }
        return firstElem.fType.startsWith("$:");
    }

    public boolean isDynamicArray() {
        IndexType firstElem = this.getFirstIndexType();
        if (firstElem == null || firstElem instanceof DataType) {
            return false;
        }
        return firstElem.fType == null || firstElem.fType.isEmpty();
    }

    public boolean isAssociativeWildcardArray() {
        IndexType firstElem = this.getFirstIndexType();
        if (firstElem == null || firstElem instanceof DataType) {
            return false;
        }
        return "*".equals(firstElem.fType);
    }

    public boolean isAssociativeWildcardArrayForCompliance() {
        if (this.fUnpackedDimension == null) {
            return false;
        }
        for (IndexType dimension : this.fUnpackedDimension) {
            if (dimension instanceof DataType || !"*".equals(dimension.fType)) continue;
            return true;
        }
        return false;
    }

    public int getParametricDependencyValue() {
        return this.fParametricDependencyValue;
    }

    public void updateParametricDependencyValue(int value) {
        this.fParametricDependencyValue = (byte)(this.fParametricDependencyValue | (byte)value);
    }

    public void resetParametricDependencyValue() {
        this.fParametricDependencyValue = 1;
    }

    public String getNetType() {
        return this.fNetType;
    }

    public void setNetType(String netType) {
        if (netType != null) {
            this.fNetType = DVTStringUtil.intern((String)netType);
        }
    }

    public String getDiscipline() {
        return this.fDiscipline;
    }

    public boolean isVerilog() {
        return this.fIsVerilog;
    }

    public void setIsVerilog(boolean isVerilog) {
        this.fIsVerilog = isVerilog;
    }

    public boolean containsTypeName(String typeName) {
        if (typeName == null) {
            return false;
        }
        if (typeName.equals(this.fType)) {
            return true;
        }
        if (this.fOrderedParamAssignments != null) {
            for (DataType dt : this.fOrderedParamAssignments) {
                if (!dt.containsTypeName(typeName)) continue;
                return true;
            }
        }
        if (this.fNamedParamAssignments != null) {
            for (ArgInfo argInfo : this.fNamedParamAssignments.values()) {
                if (!argInfo.getDataType().containsTypeName(typeName)) continue;
                return true;
            }
        }
        return false;
    }

    public void decreaseUnpackedDimension() {
        this.fUnpackedDimension = DataTypeDimensions.decreaseDimension(this.fUnpackedDimension);
    }

    public void increaseUnpackedDimension(IndexType newDimension) {
        this.fUnpackedDimension = DataTypeDimensions.increaseDimension(this.fUnpackedDimension, newDimension);
    }

    public void decreasePackedDimension() {
        this.fPackedDimension = DataTypeDimensions.decreaseDimension(this.fPackedDimension);
    }

    public void increasePackedDimension(IndexType newDimension) {
        this.fPackedDimension = DataTypeDimensions.increaseDimension(this.fPackedDimension, newDimension);
    }

    public void updateImplicit(DataType dataType) {
        if (dataType != null) {
            if (this.fType == null && this.fDirection == 0) {
                this.fType = dataType.fType;
                if (this.fPackageScope == null) {
                    this.fPackageScope = dataType.fPackageScope;
                }
            }
            if (this.fDirection == 0) {
                this.fDirection = RfElement.getImplicitDirection(dataType.fDirection);
            }
        } else if (this.fDirection == 0) {
            this.fDirection = RfElement.getImplicitDirection((byte)1);
        }
    }

    public boolean hasImplicitDirection() {
        return this.fDirection == 0 | this.fDirection > 8;
    }

    public boolean hasImplicitType() {
        return this.getType() == null;
    }

    public boolean hasOnlyAmsDiscipline() {
        return this.isVerilog() && this.getDiscipline() != null && this.getRawType() == null;
    }

    public boolean dependsOnParameters() {
        if (this.fNamedParamAssignments != null && !this.fNamedParamAssignments.isEmpty() || this.fOrderedParamAssignments != null && !this.fOrderedParamAssignments.isEmpty()) {
            return true;
        }
        if (this.fInnerClassesInfo == null || this.fInnerClassesInfo.isEmpty()) {
            return false;
        }
        for (DataType innerClassDT : this.fInnerClassesInfo) {
            if (!innerClassDT.dependsOnParameters()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getTypeName("logic", null, null, false, false, true);
    }

    public boolean equalsIgnoringDirection(DataType dataType) {
        if (this == dataType) {
            return true;
        }
        if (dataType == null) {
            return false;
        }
        if (this.fUnpackedDimension == null ? dataType.fUnpackedDimension != null && !dataType.fUnpackedDimension.isEmpty() : !this.fUnpackedDimension.equals(dataType.fUnpackedDimension)) {
            return false;
        }
        if (this.fNetType == null ? dataType.fNetType != null : !this.fNetType.equals(dataType.fNetType)) {
            return false;
        }
        if (this.fDiscipline == null ? dataType.fDiscipline != null : !this.fDiscipline.equals(dataType.fDiscipline)) {
            return false;
        }
        if (this.fEnumRange == null ? dataType.fEnumRange != null : !this.fEnumRange.equals(dataType.fEnumRange)) {
            return false;
        }
        if (this.fPackedDimension == null ? dataType.fPackedDimension != null && !dataType.fPackedDimension.isEmpty() : !this.fPackedDimension.equals(dataType.fPackedDimension)) {
            return false;
        }
        if (this.fSign != dataType.fSign) {
            return false;
        }
        if (this.fType == null ? dataType.fType != null : !this.fType.equals(dataType.fType)) {
            return false;
        }
        if (this.fPackageScope == null ? dataType.fPackageScope != null : !this.fPackageScope.equals(dataType.fPackageScope)) {
            return false;
        }
        if (this.fOrderedParamAssignments == null ? dataType.fOrderedParamAssignments != null : !this.fOrderedParamAssignments.equals(dataType.fOrderedParamAssignments)) {
            return false;
        }
        return !(this.fNamedParamAssignments == null ? dataType.fNamedParamAssignments != null : !this.fNamedParamAssignments.equals(dataType.fNamedParamAssignments));
    }

    public void setPackageScope(DataType dataType) {
        this.fPackageScope = dataType;
    }

    public DataType getPackageScope() {
        return this.fPackageScope;
    }

    public int getOffsetOf(RfAssociatedType.RfUnresolvedTypeInfo type) {
        if (type == null) {
            return this.getOffsetForOuterDataType();
        }
        if (type.getfOffset() < 0) {
            String typeName = type.getName();
            if (typeName == null) {
                return this.getOffsetForOuterDataType();
            }
            if (this.fPackageScope != null && typeName.equals(this.fPackageScope.getType())) {
                return this.fPackageScope.getOffset();
            }
            if (typeName.equals(this.getType())) {
                return this.getOffset();
            }
            if (this.fInnerClassesInfo == null || this.fInnerClassesInfo.isEmpty()) {
                return this.getOffsetForOuterDataType();
            }
            for (DataType innerClassesInfo : this.fInnerClassesInfo) {
                if (!typeName.equals(innerClassesInfo.getType())) continue;
                return innerClassesInfo.getOffset();
            }
            return this.getOffsetForOuterDataType();
        }
        return type.getfOffset();
    }

    private int getOffsetForOuterDataType() {
        if (this.fPackageScope != null) {
            return this.fPackageScope.getOffset();
        }
        return this.getOffset();
    }

    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        try {
            if (this.fParamValuesHolder != null) {
                this.fParamValuesHolder.visitHidObject(rfProject, visitor);
            }
            if (this.fOrderedParamAssignments != null) {
                for (DataType dataType : this.fOrderedParamAssignments) {
                    dataType.visitHidObject(rfProject, visitor);
                }
            }
            if (this.fNamedParamAssignments != null) {
                for (ArgInfo argInfo : this.fNamedParamAssignments.values()) {
                    if (argInfo.getDataType() == null) continue;
                    argInfo.getDataType().visitHidObject(rfProject, visitor);
                }
            }
        }
        catch (OperationCanceledException | BuildCancelException | ElementFromCursorDetectionException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public boolean isPredefinedType() {
        return this.fType != null && RfVerilog.PREDEFINED_TYPE_NAMES.contains(this.fType);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PrecompiledAutoDebugUtils.INSTANCE.objectWritten((Object)this);
        if (!(out instanceof PersistenceOutputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceOutputStream)out).getPersistence();
        if (!(persistence instanceof Persistence)) {
            return;
        }
        if (this.fParamValuesHolder != null) {
            ((Persistence)persistence).dataTypeWritten(((PersistenceOutputStream)out).getPersistenceModeWrapper(), this, this.fParamValuesHolder);
            PrecompiledAutoDebugUtils.INSTANCE.objectWritten((Object)this.fParamValuesHolder);
        }
    }

    public int xGetUnpackedSize(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        List<IndexType> unpacked = this.getUnpackedDimension();
        if (unpacked == null) {
            return -1;
        }
        IHidObject rangeObject = unpacked.get(0).getRangeObject();
        if (rangeObject == null) {
            return -1;
        }
        BitVectorContext dummyContextOrigin = BitVectorContext.of(null, (boolean)false);
        switch (rangeObject.getHidKind()) {
            case HID: 
            case IMPLICIT: 
            case ACCESS: {
                RfHidImplicit rfHidImplicit;
                if (rangeObject instanceof RfHidImplicit && ((rfHidImplicit = (RfHidImplicit)rangeObject).isEmptyType() || rfHidImplicit.isDollar() || rfHidImplicit.isStar())) {
                    return -1;
                }
                if (rangeObject instanceof RfHidImplicit && ((RfHidImplicit)rangeObject).getType() == 493) {
                    return -1;
                }
                if (rangeObject instanceof RfHidImplicit && ((RfHidImplicit)rangeObject).getType() == 244) {
                    return -1;
                }
                IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)rangeObject, (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)value) || !(value instanceof ELParamValues.ParamValueNumber) || value instanceof ELParamValues.ParamValueType) {
                    return -1;
                }
                int intValue = value.intValue();
                if (intValue <= 0) {
                    return -1;
                }
                return intValue;
            }
            case OPERATOR: {
                if (!((RfHidOperator)rangeObject).isRangeOrPartSelect()) {
                    return -1;
                }
                ListContainer rhValues = ((RfHidOperator)rangeObject).getRHValues();
                if (rhValues == null || rhValues.isEmpty()) {
                    return -1;
                }
                IELParamValue lhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((RfHidOperator)rangeObject).getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)lhValue) || !(lhValue instanceof ELParamValues.ParamValueNumber)) {
                    return -1;
                }
                IELParamValue rhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rhValues.get(0)), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)rhValue) || !(rhValue instanceof ELParamValues.ParamValueNumber)) {
                    return -1;
                }
                return Math.abs(lhValue.intValue() - rhValue.intValue()) + 1;
            }
        }
        return -1;
    }

    public MaskType initMaskType() {
        if (this.fNetType == null || this.fNetType.equals("trireg")) {
            return MaskType.X;
        }
        return MaskType.Z;
    }

    public boolean isFixedSizeUnpackedArray() {
        return this.fUnpackedDimension != null && this.fUnpackedDimension.stream().map(element -> element instanceof IndexTypeWithOffsets).collect(Collectors.toList()).contains(true);
    }

    public static class FileOutOfBoundsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

