/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;

public class DataTypeDimensions {
    public List<IndexType> packed;
    public List<IndexType> unpacked;
    public List<IndexType> packedResized;
    public List<IndexType> unpackedResized;

    public DataTypeDimensions(IRfNamedElement element) {
        DataType dataType;
        if (element instanceof RfAssociatedType && (dataType = ((RfAssociatedType)element).getDataType()) != null) {
            this.packed = dataType.getPackedDimension();
            this.unpacked = dataType.getUnpackedDimension();
        }
    }

    public String toString() {
        return "Packed:" + this.packed + " Unpacked:" + this.unpacked;
    }

    public boolean comparePackedDimension(DataTypeDimensions other) {
        int otherNofBits;
        boolean result;
        if (other == null) {
            return false;
        }
        boolean bl = result = this.packed != null && this.packed.equals(other.packed);
        if (result) {
            return true;
        }
        int thisNofBits = this.getNofBitsFromPackedDimension();
        return thisNofBits == (otherNofBits = other.getNofBitsFromPackedDimension());
    }

    public boolean compareUnpackedDimension(DataTypeDimensions other) {
        if (other == null) {
            return false;
        }
        if (this.unpacked == null || this.unpacked.isEmpty()) {
            return other.unpacked == null || other.unpacked.isEmpty();
        }
        if (other.unpacked == null || other.unpacked.isEmpty()) {
            return this.unpacked == null || this.unpacked.isEmpty();
        }
        return this.unpacked.equals(other.unpacked);
    }

    public String getPackedDimensionForMsg() {
        if (this.packed == null || this.packed.isEmpty()) {
            return "NONE";
        }
        StringBuilder result = new StringBuilder();
        for (IndexType indexType : this.packed) {
            result.append('[').append(indexType.fType).append(']');
        }
        return result.toString();
    }

    public String getUnpackedDimensionForMsg() {
        if (this.unpacked == null || this.unpacked.isEmpty()) {
            return "NONE";
        }
        StringBuilder result = new StringBuilder();
        for (IndexType indexType : this.unpacked) {
            result.append('[').append(indexType.fType).append(']');
        }
        return result.toString();
    }

    public int getNofBitsFromPackedDimension() {
        if (this.packed == null || this.packed.isEmpty()) {
            return 1;
        }
        int result = 1;
        int i = 0;
        while (i < this.packed.size()) {
            if ((result *= DataTypeDimensions.getRangeWidth(this.packed.get(i).getType())) < 0) {
                return -1;
            }
            ++i;
        }
        return result;
    }

    public static int getRangeWidth(String rangeExpr) {
        String[] rangeElements;
        if (rangeExpr == null || rangeExpr.isEmpty()) {
            return 1;
        }
        if (rangeExpr.startsWith("[")) {
            rangeExpr = rangeExpr.substring(1, rangeExpr.length() - 1);
        }
        if ((rangeElements = rangeExpr.split(":")).length != 2) {
            return -1;
        }
        if (DVTStringUtil.isNumber((String)rangeElements[0]) && DVTStringUtil.isNumber((String)rangeElements[1])) {
            try {
                int leftRange = Integer.parseInt(rangeElements[0]);
                int rigthRange = Integer.parseInt(rangeElements[1]);
                return Math.abs(leftRange - rigthRange) + 1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    public final void appendPackedDimension(List<IndexType> dimension) {
        this.packed = DataTypeDimensions.appendDimension(this.packed, dimension);
    }

    public final void appendUnpackedDimension(List<IndexType> dimension) {
        this.unpacked = DataTypeDimensions.appendDimension(this.unpacked, dimension);
    }

    public static final List<IndexType> appendDimension(List<IndexType> existing, IndexType dimension) {
        if (dimension == null) {
            return existing;
        }
        existing = OptimizedUtils.listAdd(existing, (Object)dimension);
        return existing;
    }

    public static final List<IndexType> appendDimension(List<IndexType> existing, List<IndexType> dimension) {
        if (dimension == null || dimension.isEmpty()) {
            return existing;
        }
        ArrayList<IndexType> result = new ArrayList<IndexType>(dimension.size() + (existing == null ? 0 : existing.size()));
        if (existing != null) {
            result.addAll(existing);
        }
        result.addAll(dimension);
        return result;
    }

    public static final List<IndexType> decreaseDimension(List<IndexType> dimension) {
        if (dimension == null || dimension.isEmpty()) {
            return null;
        }
        if (dimension.size() == 1) {
            return null;
        }
        List result = OptimizedUtils.listCreate(dimension.subList(1, dimension.size()));
        return result;
    }

    public static final List<IndexType> increaseDimension(List<IndexType> dimension, IndexType firstIndex) {
        List result = OptimizedUtils.listCreate((int)(dimension == null ? 1 : dimension.size() + 1));
        result.add(firstIndex);
        if (dimension != null) {
            result.addAll(dimension);
        }
        return result;
    }
}

