/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyMacro;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DeltaFileKind;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;
import ro.amiq.dvt.model.reflection.IIncrementalDeltaContainer;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.OptimizedIdentityHashSet;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.IVlogModel;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCuname;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFragment;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNetTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.ams.RfDiscipline;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedEventType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;

public final class IncrementalDeltaContainer
implements IIncrementalDeltaContainer {
    public static final Set<Class<? extends IRfScopeElement>> CLOSEST_TYPE_CONTAINER = new HashSet<Class<? extends IRfScopeElement>>();
    private Set<RfNamedElement> elementsBeforeIncremental = Collections.newSetFromMap(new IdentityHashMap());
    private Map<String, RfNamedElement> elementsUnderGeneratesBeforeIncremental;
    private Set<RfNamedElement> elementsAfterIncremental;
    private Map<String, RfNamedElement> elementsUnderGeneratesAfterIncremental;
    private List<RfDefElement> defElementsBeforeIncremental = new ArrayList<RfDefElement>();
    protected Set<RfInstance> changedBinds;
    protected Set<RfNamedElement> changedDataTypeElements;
    protected Set<RfNamedElement> diffArgumentsExternalFunctions;
    protected Set<RfNamedElement> visitedExternalFunctionsArguments;
    protected HashSet<String> changedTypeNames;
    protected Set<ImportInfo> addedImportInfos;
    protected HashMap<String, List<RfNamedElement>> changedImportPackageNames;
    protected Set<RfClass> classesWithChangedParent;
    private Set<ParserPathWrapper> parserPaths;
    protected boolean changedImports = false;
    protected Map<ParserPath, Set<IRfNamedElement>> delta;
    protected Set<RfClass> deltaSpecializedClasses;
    protected Map<ParserPath, Collection<RfNamedElement>> firstLevelElements;
    protected Collection<RfNamedElement> currentFileScopes;
    protected Set<String> updateViewsIds;
    private Set<String> changedMacros;
    public Map<String, String> anonymousNewToOldNameMap;
    public Map<RfField, DataType> oldCompleteDataType;
    public Map<RfField, Integer> oldCompleteFieldQualifiers;
    private Set<IDVTFile> reparsedFiles;

    static {
        CLOSEST_TYPE_CONTAINER.add(RfPredefinedScalarType.class);
        CLOSEST_TYPE_CONTAINER.add(RfPredefinedEventType.class);
        CLOSEST_TYPE_CONTAINER.add(RfScalarType.class);
        CLOSEST_TYPE_CONTAINER.add(RfPrimitive.class);
        CLOSEST_TYPE_CONTAINER.add(RfInterface.class);
        CLOSEST_TYPE_CONTAINER.add(RfInstance.class);
        CLOSEST_TYPE_CONTAINER.add(RfInstance.RfBindInstance.class);
        CLOSEST_TYPE_CONTAINER.add(RfModule.class);
        CLOSEST_TYPE_CONTAINER.add(RfProgram.class);
        CLOSEST_TYPE_CONTAINER.add(RfChecker.class);
        CLOSEST_TYPE_CONTAINER.add(RfStruct.class);
        CLOSEST_TYPE_CONTAINER.add(RfCovergroup.class);
        CLOSEST_TYPE_CONTAINER.add(RfConfiguration.class);
        CLOSEST_TYPE_CONTAINER.add(RfTypeAlias.class);
        CLOSEST_TYPE_CONTAINER.add(RfNetTypeAlias.class);
        CLOSEST_TYPE_CONTAINER.add(RfClass.class);
        CLOSEST_TYPE_CONTAINER.add(RfSpecializedClass.class);
        CLOSEST_TYPE_CONTAINER.add(RfPredefinedClass.class);
        CLOSEST_TYPE_CONTAINER.add(RfDiscipline.class);
        CLOSEST_TYPE_CONTAINER.add(RfPackage.class);
        CLOSEST_TYPE_CONTAINER.add(RfCuname.class);
        CLOSEST_TYPE_CONTAINER.add(RfLibrary.class);
        CLOSEST_TYPE_CONTAINER.add(RfFragment.class);
        CLOSEST_TYPE_CONTAINER.add(RfForwardTypedef.class);
    }

    protected IncrementalDeltaContainer() {
        this.elementsUnderGeneratesBeforeIncremental = new HashMap<String, RfNamedElement>();
        this.changedTypeNames = new HashSet();
        this.changedDataTypeElements = new LinkedHashSet<RfNamedElement>();
        this.diffArgumentsExternalFunctions = Collections.newSetFromMap(new IdentityHashMap());
        this.visitedExternalFunctionsArguments = Collections.newSetFromMap(new IdentityHashMap());
        this.changedMacros = new LinkedHashSet<String>();
        this.reparsedFiles = new LinkedHashSet<IDVTFile>();
        this.addedImportInfos = Collections.newSetFromMap(new IdentityHashMap());
        this.changedImportPackageNames = new HashMap();
        this.parserPaths = new LinkedHashSet<ParserPathWrapper>();
        this.classesWithChangedParent = Collections.newSetFromMap(new IdentityHashMap());
        this.firstLevelElements = new LinkedHashMap<ParserPath, Collection<RfNamedElement>>();
        this.delta = new LinkedHashMap<ParserPath, Set<IRfNamedElement>>();
        this.deltaSpecializedClasses = new LinkedHashSet<RfClass>();
        this.elementsAfterIncremental = Collections.newSetFromMap(new IdentityHashMap());
        this.elementsUnderGeneratesAfterIncremental = new HashMap<String, RfNamedElement>();
        this.changedBinds = Collections.newSetFromMap(new IdentityHashMap());
        this.updateViewsIds = new HashSet<String>();
        this.anonymousNewToOldNameMap = new HashMap<String, String>();
        this.oldCompleteDataType = new IdentityHashMap<RfField, DataType>();
        this.oldCompleteFieldQualifiers = new IdentityHashMap<RfField, Integer>();
        if (TestHelper.isTestMode()) {
            this.updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
        } else {
            this.updateViewsIds.addAll(ViewsUtils.ALL_BUT_DH_VIEWS);
        }
    }

    public IncrementalDeltaContainer(IncrementalDeltaContainer incrementalDeltaContainer) {
        this();
        if (incrementalDeltaContainer.elementsBeforeIncremental != null) {
            this.elementsBeforeIncremental.addAll(incrementalDeltaContainer.elementsBeforeIncremental);
        }
        if (incrementalDeltaContainer.defElementsBeforeIncremental != null) {
            this.defElementsBeforeIncremental.addAll(incrementalDeltaContainer.defElementsBeforeIncremental);
        }
        if (incrementalDeltaContainer.elementsUnderGeneratesBeforeIncremental != null) {
            this.elementsUnderGeneratesBeforeIncremental.putAll(incrementalDeltaContainer.elementsUnderGeneratesBeforeIncremental);
        }
        if (incrementalDeltaContainer.changedTypeNames != null) {
            this.changedTypeNames.addAll(incrementalDeltaContainer.changedTypeNames);
        }
        if (incrementalDeltaContainer.addedImportInfos != null) {
            this.addedImportInfos.addAll(incrementalDeltaContainer.addedImportInfos);
        }
        if (incrementalDeltaContainer.changedImportPackageNames != null) {
            this.changedImportPackageNames.putAll(incrementalDeltaContainer.changedImportPackageNames);
        }
        if (incrementalDeltaContainer.parserPaths != null) {
            this.parserPaths.addAll(incrementalDeltaContainer.parserPaths);
        }
        if (incrementalDeltaContainer.changedDataTypeElements != null) {
            this.changedDataTypeElements.addAll(incrementalDeltaContainer.changedDataTypeElements);
        }
        if (incrementalDeltaContainer.diffArgumentsExternalFunctions != null) {
            this.diffArgumentsExternalFunctions.addAll(incrementalDeltaContainer.diffArgumentsExternalFunctions);
        }
        if (incrementalDeltaContainer.visitedExternalFunctionsArguments != null) {
            this.visitedExternalFunctionsArguments.addAll(incrementalDeltaContainer.visitedExternalFunctionsArguments);
        }
        if (incrementalDeltaContainer.changedMacros != null) {
            this.changedMacros.addAll(incrementalDeltaContainer.changedMacros);
        }
        if (incrementalDeltaContainer.reparsedFiles != null) {
            this.reparsedFiles.addAll(incrementalDeltaContainer.reparsedFiles);
        }
        if (incrementalDeltaContainer.classesWithChangedParent != null) {
            this.classesWithChangedParent.addAll(incrementalDeltaContainer.classesWithChangedParent);
        }
        if (incrementalDeltaContainer.firstLevelElements != null) {
            this.firstLevelElements.putAll(incrementalDeltaContainer.firstLevelElements);
        }
        if (incrementalDeltaContainer.changedBinds != null) {
            this.changedBinds.addAll(incrementalDeltaContainer.changedBinds);
        }
        if (incrementalDeltaContainer.delta != null) {
            this.delta.putAll(incrementalDeltaContainer.delta);
        }
        if (incrementalDeltaContainer.deltaSpecializedClasses != null) {
            this.deltaSpecializedClasses.addAll(incrementalDeltaContainer.deltaSpecializedClasses);
        }
        if (incrementalDeltaContainer.elementsAfterIncremental != null) {
            this.elementsAfterIncremental.addAll(incrementalDeltaContainer.elementsAfterIncremental);
        }
        if (incrementalDeltaContainer.anonymousNewToOldNameMap != null) {
            this.anonymousNewToOldNameMap.putAll(incrementalDeltaContainer.anonymousNewToOldNameMap);
        }
        if (incrementalDeltaContainer.oldCompleteDataType != null) {
            this.oldCompleteDataType.putAll(incrementalDeltaContainer.oldCompleteDataType);
        }
        if (incrementalDeltaContainer.oldCompleteFieldQualifiers != null) {
            this.oldCompleteFieldQualifiers.putAll(incrementalDeltaContainer.oldCompleteFieldQualifiers);
        }
        if (incrementalDeltaContainer.elementsUnderGeneratesAfterIncremental != null) {
            this.elementsUnderGeneratesAfterIncremental.putAll(incrementalDeltaContainer.elementsUnderGeneratesAfterIncremental);
        }
        if (incrementalDeltaContainer.updateViewsIds != null) {
            this.updateViewsIds.addAll(incrementalDeltaContainer.updateViewsIds);
        }
        this.changedImports = incrementalDeltaContainer.changedImports;
    }

    public void removeElement(RfNamedElement element) {
        this.elementsBeforeIncremental.remove(element);
    }

    public void clear() {
        this.elementsBeforeIncremental.clear();
        this.defElementsBeforeIncremental.clear();
        this.elementsUnderGeneratesBeforeIncremental.clear();
        this.changedTypeNames.clear();
        this.addedImportInfos.clear();
        this.changedImportPackageNames.clear();
        this.parserPaths.clear();
        this.classesWithChangedParent.clear();
        this.anonymousNewToOldNameMap.clear();
        this.oldCompleteDataType.clear();
        this.oldCompleteFieldQualifiers.clear();
        this.firstLevelElements.clear();
        this.changedImports = false;
        this.delta.clear();
        this.deltaSpecializedClasses.clear();
        this.elementsAfterIncremental.clear();
        this.elementsUnderGeneratesAfterIncremental.clear();
        this.updateViewsIds.clear();
        this.changedDataTypeElements.clear();
        this.diffArgumentsExternalFunctions.clear();
        this.visitedExternalFunctionsArguments.clear();
        this.changedMacros.clear();
        this.reparsedFiles.clear();
        this.changedBinds.clear();
        if (TestHelper.isTestMode()) {
            this.updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
        } else {
            this.updateViewsIds.addAll(ViewsUtils.ALL_BUT_DH_VIEWS);
        }
    }

    public Map<ParserPath, Set<IRfNamedElement>> getDelta() {
        return this.delta;
    }

    public Map<ParserPath, Collection<RfNamedElement>> getFirstLevelElements() {
        return this.firstLevelElements;
    }

    public String logDelta(IIncrementalDeltaContainer.LogOption logOption) {
        ParserPath pp;
        StringBuilder sb = new StringBuilder();
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.BEFORE_INCREMENTAL_NAMED_ELEMENTS)) {
            sb.append("elementsBeforeIncremental:\n");
            if (this.elementsBeforeIncremental != null) {
                for (RfNamedElement rfNamedElement : this.elementsBeforeIncremental) {
                    if (rfNamedElement == null) continue;
                    sb.append("    element before incremental name: " + rfNamedElement.getName() + " kind: " + rfNamedElement.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.AFTER_INCREMENTAL_NAMED_ELEMENTS)) {
            sb.append("elementsAfterIncremental:\n");
            if (this.elementsAfterIncremental != null) {
                for (RfNamedElement rfNamedElement : this.elementsAfterIncremental) {
                    if (rfNamedElement == null) continue;
                    sb.append("    element after incremental name: " + rfNamedElement.getName() + " kind: " + rfNamedElement.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.REMOVED_NAMED_ELEMENTS)) {
            Set<RfNamedElement> set = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
            set.addAll(this.elementsBeforeIncremental);
            set.removeAll(this.elementsAfterIncremental);
            sb.append("elementsDiffIncremental (before - after):\n");
            if (set != null) {
                for (RfNamedElement elem : set) {
                    if (elem == null) continue;
                    sb.append("    element diff incremental name: " + elem.getName() + " kind: " + elem.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.ADDED_NAME_ELEMENTS)) {
            Set<RfNamedElement> set = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
            set.addAll(this.elementsAfterIncremental);
            set.removeAll(this.elementsBeforeIncremental);
            sb.append("elementsDiffIncremental (after - before):\n");
            if (set != null) {
                for (RfNamedElement elem : set) {
                    if (elem == null) continue;
                    sb.append("    element diff incremental name: " + elem.getName() + " kind: " + elem.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.CHANGED_TYPE_NAMES)) {
            sb.append("changedTypeNames:\n");
            if (this.changedTypeNames != null) {
                for (String string : this.changedTypeNames) {
                    sb.append("    changed type name " + string + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.ADDED_IMPORT_INFOS)) {
            sb.append("addedImportInfos:\n");
            if (this.addedImportInfos != null) {
                for (ImportInfo importInfo : this.addedImportInfos) {
                    if (importInfo == null) continue;
                    sb.append("    added import info: " + importInfo.getPackageName() + " kind: " + importInfo.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.CHANGED_IMPORT_PACKAGE_NAMES)) {
            sb.append("changedImportPackageNames:\n");
            if (this.changedImportPackageNames != null) {
                for (Map.Entry entry : this.changedImportPackageNames.entrySet()) {
                    String name = (String)entry.getKey();
                    sb.append("    package name " + name + "\n");
                    Collection changedImportPackageNamesList = (Collection)entry.getValue();
                    if (changedImportPackageNamesList == null) continue;
                    for (IRfNamedElement elem : changedImportPackageNamesList) {
                        if (elem == null) continue;
                        sb.append("        changed import element: " + elem.getName() + " kind: " + elem.getClass().toString() + "\n");
                    }
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.PARSER_PATHS)) {
            sb.append("parserPaths:\n");
            if (this.parserPaths != null) {
                for (ParserPathWrapper parserPathWrapper : this.parserPaths) {
                    sb.append("    parser path: " + parserPathWrapper.getParserPath().path + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.CLASSES_WITH_CHANGED_PARENT)) {
            sb.append("classesWithChangedParent:\n");
            if (this.classesWithChangedParent != null) {
                for (RfNamedElement rfNamedElement : this.classesWithChangedParent) {
                    sb.append("    changed parent of name: " + rfNamedElement.getName() + " kind: " + rfNamedElement.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.FIRST_LEVEL_ELEMENTS)) {
            sb.append("firstLevelElements:\n");
            if (this.firstLevelElements != null) {
                for (Map.Entry entry : this.firstLevelElements.entrySet()) {
                    pp = (ParserPath)entry.getKey();
                    sb.append("    parser path " + pp.path + "\n");
                    Collection firstLevelElementsList = (Collection)entry.getValue();
                    if (firstLevelElementsList == null) continue;
                    for (IRfNamedElement elem : firstLevelElementsList) {
                        if (elem == null) continue;
                        sb.append("        first level element: " + elem.getName() + " kind: " + elem.getClass().toString() + "\n");
                    }
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.DELTA)) {
            sb.append("delta:\n");
            if (this.delta != null) {
                for (Map.Entry entry : this.delta.entrySet()) {
                    pp = (ParserPath)entry.getKey();
                    if (pp == null) continue;
                    sb.append("    parser path: " + pp.path + "\n");
                    Set deltaList = (Set)entry.getValue();
                    if (deltaList == null || deltaList.isEmpty()) {
                        sb.append("        delta element: <empty>\n");
                        continue;
                    }
                    for (IRfNamedElement elem : deltaList) {
                        if (elem == null) continue;
                        sb.append("        delta element: " + elem.getName() + " kind: " + elem.getClass().toString() + "\n");
                    }
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.CURRENT_FILES_SCOPE)) {
            sb.append("currentFileScopes:\n");
            if (this.currentFileScopes != null) {
                for (RfNamedElement rfNamedElement : this.currentFileScopes) {
                    if (rfNamedElement == null) continue;
                    sb.append("    currentFileScope: " + rfNamedElement.getName() + " kind: " + rfNamedElement.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.CHANGED_MACROS)) {
            sb.append("changedMacros:\n");
            if (this.changedMacros != null && !this.changedMacros.isEmpty()) {
                for (String string : this.changedMacros) {
                    sb.append("    macro: " + string + "\n");
                }
                sb.append("reparsedFiles:\n");
                for (IDVTFile iDVTFile : this.reparsedFiles) {
                    ParserPath parserPath;
                    if (iDVTFile == null || (parserPath = iDVTFile.getParserPath()) == null) continue;
                    sb.append("    parser path: " + parserPath.path + "\n");
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.logDelta(IIncrementalDeltaContainer.LogOption.ALL);
    }

    protected void removeDirtyElements(ParserPath parserPath, RfProject rfProject) {
        try {
            RfFileDef fileDef;
            HashMap<ParserPath, Collection<RfNamedElement>> createdClassFragments = new HashMap<ParserPath, Collection<RfNamedElement>>();
            if (this.elementsBeforeIncremental != null && !this.elementsBeforeIncremental.isEmpty()) {
                Set visited = Collections.newSetFromMap(new IdentityHashMap());
                for (RfNamedElement rfNamedElement : this.elementsBeforeIncremental) {
                    RfNamedElement enclosingScope = rfNamedElement.getEnclosingScope();
                    if (enclosingScope == null || visited.contains(enclosingScope)) continue;
                    visited.add(enclosingScope);
                    enclosingScope.removeDirtyElements(parserPath, rfProject, createdClassFragments);
                }
            }
            if ((fileDef = this.getFileDef(parserPath, rfProject)) != null) {
                List<RfNamedElement> list = fileDef.getNamedElements();
                if (list != null && !list.isEmpty()) {
                    if (this.currentFileScopes == null) {
                        this.currentFileScopes = new LinkedHashSet<RfNamedElement>();
                    }
                    for (RfNamedElement fileScope : list) {
                        this.currentFileScopes.add(fileScope);
                    }
                }
                OptimizedIdentityHashSet visited = new OptimizedIdentityHashSet();
                this.collectElementsInFileAfterIncremental(parserPath, (DVTLinkedHashMap<RfDefElement, RfDefElement>)fileDef.fChildrenDefs, (Set<RfNamedElement>)visited, true, false, parserPath);
                for (ParserPathWrapper parserPathWrapper : this.parserPaths) {
                    ParserPath includedParserPath;
                    if (!parserPathWrapper.isInInclude() || (includedParserPath = parserPathWrapper.getParserPath()) == null) continue;
                    RfFileDef includedFileDef = rfProject.getFileDefUsingParserPath(includedParserPath);
                    if (includedFileDef == null) {
                        includedFileDef = rfProject.getFileDefIgnoringCanonicalPath(includedParserPath);
                    }
                    if (includedFileDef == null) continue;
                    this.collectElementsInFileAfterIncremental(includedParserPath, (DVTLinkedHashMap<RfDefElement, RfDefElement>)includedFileDef.fChildrenDefs, (Set<RfNamedElement>)visited, true, false, parserPath);
                }
            }
            for (Map.Entry entry : createdClassFragments.entrySet()) {
                ParserPath parserPath2 = (ParserPath)entry.getKey();
                Collection listOfElements = this.firstLevelElements.computeIfAbsent(parserPath2, key -> new ArrayList());
                listOfElements.addAll((Collection)entry.getValue());
            }
            Set<IRfNamedElement> set = this.collectDependencyList(parserPath);
            this.delta.put(parserPath, set);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private RfFileDef getFileDef(ParserPath parserPath, RfProject rfProject) {
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            fileDef = rfProject.getFileDefIgnoringCanonicalPath(parserPath);
        }
        return fileDef;
    }

    public void notifyListeners(RfMixedLangProject mixedLangProjectParent) {
        Set<RfNamedElement> addedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsAfterIncremental.size())));
        addedElements.addAll(this.elementsAfterIncremental);
        for (RfNamedElement namedElement : this.elementsBeforeIncremental) {
            if (namedElement instanceof RfConfiguration) continue;
            addedElements.remove(namedElement);
        }
        Set<RfNamedElement> removedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
        removedElements.addAll(this.elementsBeforeIncremental);
        removedElements.removeAll(this.elementsAfterIncremental);
        this.removeElementsUnderAnonymousContainers(addedElements, removedElements);
        mixedLangProjectParent.notifyIncrementalDeltaListeners(addedElements, removedElements, Collections.emptyList(), this.getParserPaths());
    }

    public Set<IRfNamedElement> collectDependencyList(ParserPath parserPath) {
        Set<IRfNamedElement> result = Collections.newSetFromMap(new IdentityHashMap());
        try {
            this.removeGenerateBlocksContent();
            Set<RfNamedElement> addedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsAfterIncremental.size())));
            addedElements.addAll(this.elementsAfterIncremental);
            for (RfNamedElement namedElement : this.elementsBeforeIncremental) {
                if (namedElement instanceof RfConfiguration) continue;
                addedElements.remove(namedElement);
            }
            Set<RfNamedElement> removedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
            removedElements.addAll(this.elementsBeforeIncremental);
            removedElements.removeAll(this.elementsAfterIncremental);
            this.removeElementsUnderAnonymousContainers(addedElements, removedElements);
            DVTLogger.INSTANCE.logInfo("DEBUG VLOG: Incremental added elements: " + addedElements);
            DVTLogger.INSTANCE.logInfo("DEBUG VLOG: Incremental removed elements: " + removedElements);
            if (this.changedImportPackageNames != null && !this.changedImportPackageNames.isEmpty()) {
                Collection<RfNamedElement> firstElements = null;
                if (this.firstLevelElements != null) {
                    firstElements = this.firstLevelElements.get(parserPath);
                }
                for (List<RfNamedElement> importScopes : this.changedImportPackageNames.values()) {
                    if (importScopes == null) continue;
                    for (RfNamedElement importScope : importScopes) {
                        if (!(importScope instanceof RfPackage) && (firstElements == null || firstElements.contains(importScope))) continue;
                        addedElements.add(importScope);
                    }
                }
            }
            this.collectDependencyList(this.changedDataTypeElements, result, true);
            this.collectViewsUpdateEvents(this.changedDataTypeElements);
            this.collectDependencyList(removedElements, result, true);
            this.collectViewsUpdateEvents(removedElements);
            this.collectDependencyList(addedElements, result, true);
            this.collectViewsUpdateEvents(addedElements);
            this.collectDependencyList(this.diffArgumentsExternalFunctions, result, true);
            this.collectViewsUpdateEvents(this.diffArgumentsExternalFunctions);
            this.collectBindInstances();
            this.collectDependencyList(this.classesWithChangedParent, result, false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void collectBindInstances() {
        for (RfNamedElement rfNamedElement : this.elementsAfterIncremental) {
            if (!(rfNamedElement instanceof RfInstance.RfBindInstance)) continue;
            this.changedBinds.add((RfInstance.RfBindInstance)rfNamedElement);
        }
        for (RfNamedElement rfNamedElement : this.changedDataTypeElements) {
            if (!(rfNamedElement instanceof RfInstance.RfBindInstance)) continue;
            this.changedBinds.add((RfInstance.RfBindInstance)rfNamedElement);
        }
    }

    public void reparseForFilesAffectedByMacroChanges(RfProject rfProject, Set<FileCompileInfo> changedFilesInfos, IProgressMonitor progressMonitor) {
        if (changedFilesInfos == null || changedFilesInfos.isEmpty()) {
            return;
        }
        HashSet<ParserPath> changedFiles = new HashSet<ParserPath>();
        for (FileCompileInfo file : changedFilesInfos) {
            changedFiles.add(DVTFileUtils.getInstance().resource2parser((IResource)file.getFile()));
        }
        this.reparsedFiles = this.getFilesToReparseDueToChangedMacros(rfProject, changedFiles);
        if (this.reparsedFiles.size() > 50) {
            FIncrementalDirtyMacro dirtyResource = new FIncrementalDirtyMacro(FNotificationDirtyReason.MACROS_CHANGED, this.reparsedFiles.size(), this.changedMacros);
            FIncrementalNotificationTracker.INSTANCE.addDirtyResource(rfProject.getProject(), (FNotificationDirtyResource)dirtyResource);
            FWidgetFactory.INSTANCE.paint(true, FWidgetType.DB_OUT_OF_SYNC);
            return;
        }
        for (IDVTFile reparsedFile : this.reparsedFiles) {
            changedFilesInfos.add(new FileCompileInfo(reparsedFile.getFile()));
        }
        RfUtils.getInstance().reparseFiles(this.reparsedFiles, progressMonitor, rfProject.getProject());
    }

    private Set<IDVTFile> getFilesToReparseDueToChangedMacros(RfProject rfProject, Set<ParserPath> changedFiles) {
        LinkedHashSet<IDVTFile> result = new LinkedHashSet<IDVTFile>();
        if (this.changedMacros.isEmpty() || changedFiles == null || changedFiles.isEmpty()) {
            return result;
        }
        IVlogModel vlogModel = VlogModelManager.getInstance().getVlogModel();
        if (vlogModel == null) {
            return result;
        }
        HashSet<ParserPath> reparsedFiles = new HashSet<ParserPath>();
        Set<ParserPath> compiledFiles = rfProject.getCompiledFilesSet();
        for (String macro : this.changedMacros) {
            String[] macroName = new String[]{macro};
            for (ParserPath compiledPath : compiledFiles) {
                IVlogModule modelFile;
                boolean hasHits;
                RfFileDef fileDef;
                if (changedFiles.contains(compiledPath) || reparsedFiles.contains(compiledPath) || !((fileDef = rfProject.getFile(compiledPath)) instanceof RfFileDef) && !((fileDef = rfProject.getMixedLangProjectParent().getFile((IRfSingleLangProject)rfProject, compiledPath)) instanceof RfFileDef) || !(hasHits = RfMixedLangManager.getInstance().hasHits(compiledPath, rfProject.getProject(), macroName, null, false)) || (modelFile = vlogModel.getOrCreateVlogModule(DVTFileUtils.getInstance().findProjectFile(rfProject.getProject(), compiledPath.path))) == null) continue;
                reparsedFiles.add(compiledPath);
                result.add(modelFile);
            }
        }
        return result;
    }

    private boolean hasUpdatedGenerateBlocks() {
        return this.elementsUnderGeneratesBeforeIncremental != null && !this.elementsUnderGeneratesBeforeIncremental.isEmpty() && this.elementsUnderGeneratesAfterIncremental != null && !this.elementsUnderGeneratesAfterIncremental.isEmpty();
    }

    private void removeElementsUnderAnonymousContainers(Set<RfNamedElement> addedElements, Set<RfNamedElement> removedElements) {
        if ((long)removedElements.size() * (long)addedElements.size() > 10000L) {
            return;
        }
        Iterator<RfNamedElement> addedElementsIterator = addedElements.iterator();
        block0: while (addedElementsIterator.hasNext()) {
            RfNamedElement addedElement = addedElementsIterator.next();
            String addedElementCustomName = this.customNameOf(addedElement);
            Iterator<RfNamedElement> removedElementsIterator = removedElements.iterator();
            while (removedElementsIterator.hasNext()) {
                RfNamedElement removedElement = removedElementsIterator.next();
                String removedElementCustomName = this.customNameOf(removedElement);
                if (!addedElementCustomName.equals(removedElementCustomName)) continue;
                addedElementsIterator.remove();
                removedElementsIterator.remove();
                continue block0;
            }
        }
    }

    private final String customNameOf(RfNamedElement element) {
        StringBuilder result = new StringBuilder();
        do {
            boolean isStruct = element instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)element).isStruct();
            boolean isUnion = element instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)element).isUnion();
            boolean isEnum = element instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)element).isEnum();
            result.append('#');
            if (element.isAnonymous() || isStruct || isUnion || isEnum) {
                if (element.isAnonymous()) {
                    result.append("anonymous//");
                } else if (isStruct) {
                    result.append("struct//");
                } else if (isUnion) {
                    result.append("union//");
                } else {
                    result.append("enum//");
                }
                result.append(element.getClass().getName());
                continue;
            }
            result.append(element.getName());
            if (!CLOSEST_TYPE_CONTAINER.contains(element.getClass())) continue;
            return result.toString();
        } while ((element = element.getEnclosingScope()) != null);
        return result.toString();
    }

    private void removeGenerateBlocksContent() {
        if (this.elementsUnderGeneratesBeforeIncremental.size() != this.elementsUnderGeneratesAfterIncremental.size()) {
            return;
        }
        if (!this.elementsUnderGeneratesBeforeIncremental.keySet().equals(this.elementsUnderGeneratesAfterIncremental.keySet())) {
            return;
        }
        this.elementsBeforeIncremental.removeAll(this.elementsUnderGeneratesBeforeIncremental.values());
        this.elementsAfterIncremental.removeAll(this.elementsUnderGeneratesAfterIncremental.values());
    }

    /*
     * Unable to fully structure code
     */
    private void collectRecursiveGenerateMembers(Map<String, RfNamedElement> generateMembers, RfNamedElement element) {
        members = element.getLocalMembersIterator(true);
        if (members != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            member = members.next();
            generateMembers.put(member.getName(), member);
            this.collectRecursiveGenerateMembers(generateMembers, member);
lbl8:
            // 2 sources

            ** while (members.hasNext())
        }
lbl9:
        // 1 sources

    }

    private void collectViewsUpdateEvents(Set<RfNamedElement> elements) {
        if (this.hasUpdatedGenerateBlocks() || TestHelper.isTestMode()) {
            this.updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
        } else {
            this.updateViewsIds.addAll(ViewsUtils.ALL_BUT_DH_VIEWS);
        }
        if (this.updateViewsIds.contains("ro.amiq.dvt.ui.views.LazyDesignHierarchyView")) {
            return;
        }
        for (RfNamedElement element : elements) {
            if (!(element instanceof IRfDesignElement) && !(element instanceof RfInstance) && !(element instanceof RfConfiguration) && (!(element instanceof RfGenerateBlock) || !((RfGenerateBlock)element).hasInstances())) continue;
            this.updateViewsIds.add("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
            break;
        }
    }

    private void collectDependencyList(Collection<? extends RfNamedElement> namedElements, Set<IRfNamedElement> result, boolean checkReferences) {
        try {
            if (namedElements.isEmpty()) {
                return;
            }
            Set visitedElement = Collections.newSetFromMap(new IdentityHashMap());
            for (RfNamedElement rfNamedElement : namedElements) {
                Collection<RfNamedElement> members;
                RfLibrary enclosingLibrary;
                if (rfNamedElement == null || rfNamedElement instanceof RfField && rfNamedElement.getEnclosingScope(RfFunction.class) != null && !((RfField)rfNamedElement).isArgument() && !rfNamedElement.isStorageStatic() || rfNamedElement instanceof RfField && rfNamedElement.isImplicitSignal() || visitedElement.contains(rfNamedElement)) continue;
                visitedElement.add(rfNamedElement);
                RfNamedElement typeContainer = (RfNamedElement)rfNamedElement.getEnclosingScope(CLOSEST_TYPE_CONTAINER);
                if (typeContainer instanceof RfTypeAlias && !(typeContainer instanceof RfForwardTypedef) && typeContainer.getEnclosingScope() != null) {
                    typeContainer = (RfNamedElement)typeContainer.getEnclosingScope().getEnclosingScope(CLOSEST_TYPE_CONTAINER);
                }
                if (typeContainer == null || (enclosingLibrary = typeContainer.getEnclosingLibrary()) == null) continue;
                if (rfNamedElement instanceof RfPackage && (members = rfNamedElement.getMembers(true, false)) != null && !members.isEmpty()) {
                    this.collectDependencyList(members, result, checkReferences);
                }
                String typeName = typeContainer.getName();
                List<RfLibrary> libraries = this.getLibraries(typeContainer);
                for (RfLibrary library : libraries) {
                    Collection<IRfNamedElement> references;
                    if (library == null || (references = library.getReferences(typeName)) == null) continue;
                    for (IRfNamedElement reference : references) {
                        String name;
                        boolean isClassLevelConstant;
                        if (reference == null || result.contains(reference)) continue;
                        String elementName = rfNamedElement.getName();
                        boolean isPackageLevelField = (rfNamedElement.getEnclosingScope() instanceof RfPackage || rfNamedElement.getEnclosingScope() instanceof RfStruct && rfNamedElement.getEnclosingScope().getEnclosingScope() instanceof RfPackage) && rfNamedElement instanceof IRfFieldElement;
                        boolean bl = isClassLevelConstant = ELUtils.isVLOGConstant((IRfNamedElement)rfNamedElement) && typeContainer instanceof RfClass;
                        if (isClassLevelConstant) {
                            this.deltaSpecializedClasses.add((RfClass)typeContainer);
                        }
                        if (isPackageLevelField) {
                            if (!reference.hasReferenceToIdentifierName(elementName)) continue;
                            result.add(reference);
                            continue;
                        }
                        if (reference.hasReferenceToIdentifierName(elementName)) {
                            RfNamedElement enclosingScope;
                            if (reference instanceof RfClass && reference.hasNoDefs(false) && !reference.isPredefined() && (enclosingScope = (RfNamedElement)reference.getEnclosingScope()) != null) {
                                RfNamedElement tmpReference = enclosingScope.getLocalMember(RfClass.class, reference.getName(), true);
                                if (tmpReference == null) {
                                    tmpReference = enclosingScope.getLocalMember(RfFragment.class, reference.getName(), true);
                                }
                                if (tmpReference != null) {
                                    reference = tmpReference;
                                }
                            }
                            result.add(reference);
                            continue;
                        }
                        if (reference instanceof RfConfiguration || this.isPureFunction(rfNamedElement)) {
                            result.add(reference);
                            continue;
                        }
                        if (!(rfNamedElement instanceof RfField) || !this.isPortParameterArgumentElement((RfField)rfNamedElement) || !reference.hasReferenceToIdentifierName(name = rfNamedElement.getEnclosingScope().getName())) continue;
                        result.add(reference);
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private List<RfLibrary> getLibraries(RfNamedElement typeContainer) {
        ArrayList<RfLibrary> result = new ArrayList<RfLibrary>();
        RfLibrary enclosingLibrary = typeContainer.getEnclosingLibrary();
        if (enclosingLibrary == null) {
            return result;
        }
        if (enclosingLibrary.isNonTopFilesLibrary()) {
            RfProject rfProject = typeContainer.getRfProject();
            Collection<RfLibrary> libraries = rfProject.getLibraries();
            if (libraries != null) {
                result.addAll(libraries);
            }
        } else {
            result.add(enclosingLibrary);
        }
        return result;
    }

    private boolean isPortParameterArgumentElement(RfField namedElement) {
        if (namedElement.isTypeParameter() || namedElement.isParameter()) {
            return true;
        }
        if (namedElement.isArgument()) {
            return true;
        }
        return namedElement instanceof RfPort;
    }

    private boolean isPureFunction(RfNamedElement namedElement) {
        return namedElement instanceof RfFunction && namedElement.isPure();
    }

    private void collectElementsInFileAfterIncremental(ParserPath parserPath, DVTLinkedHashMap<RfDefElement, RfDefElement> childrenDefs, Set<RfNamedElement> visited, boolean collectFirstLevel, boolean isInIncludedFile, ParserPath rootParserPath) {
        try {
            if (childrenDefs == null || childrenDefs.isEmpty()) {
                return;
            }
            for (RfDefElement defElement : childrenDefs.values()) {
                List<RfNamedElement> namedElements = defElement.getNamedElements();
                if (namedElements == null || namedElements.isEmpty()) {
                    return;
                }
                for (RfNamedElement namedElement : namedElements) {
                    RfNamedElement enclosingScope;
                    ParserPath enclosingParserPath;
                    RfDefElement declaration;
                    RfNamedElement enclosingScope2;
                    if (namedElement == null || isInIncludedFile && namedElements.size() > 1 && rootParserPath != null && ((enclosingScope2 = namedElement.getEnclosingScope()) == null || (declaration = enclosingScope2.getDeclaration()) != null && !rootParserPath.equals((Object)(enclosingParserPath = declaration.getParserPath())))) continue;
                    if (!(isInIncludedFile || namedElement.isAnonymous() || namedElement instanceof RfFunctionCall)) {
                        this.elementsAfterIncremental.add(namedElement);
                    }
                    if (!isInIncludedFile && namedElement instanceof RfGenerateBlock) {
                        this.elementsUnderGeneratesAfterIncremental.put(namedElement.getName(), namedElement);
                        this.collectRecursiveGenerateMembers(this.elementsUnderGeneratesAfterIncremental, namedElement);
                    }
                    Collection declarations = namedElement.getDeclarations();
                    enclosingParserPath = declarations.iterator();
                    while (enclosingParserPath.hasNext()) {
                        ParserPath parserPath2;
                        declaration = (RfDefElement)enclosingParserPath.next();
                        if (declaration == null || (parserPath2 = declaration.getParserPath()) == null || parserPath2.equals((Object)parserPath)) continue;
                        this.addChangedParserPath(parserPath2, false);
                    }
                    if (!collectFirstLevel) continue;
                    if (this.firstLevelElements == null) {
                        this.firstLevelElements = new LinkedHashMap<ParserPath, Collection<RfNamedElement>>();
                    }
                    if ((enclosingScope = namedElement.getEnclosingScope()) == null || visited.contains(enclosingScope) || (defElement instanceof RfFunctionDef && ((RfFunctionDef)defElement).isOutOfClassDefinition() || defElement instanceof RfConstraintDef && ((RfConstraintDef)defElement).isOutOfClassDefinition()) && enclosingScope != null && visited.contains(enclosingScope.getEnclosingScope())) continue;
                    Collection listOfElements = this.firstLevelElements.computeIfAbsent(parserPath, key -> new ArrayList());
                    listOfElements.add(namedElement);
                    visited.add(namedElement);
                }
                if (defElement.fChildrenDefs == null || defElement.fChildrenDefs.isEmpty() || defElement.fChildrenDefs == childrenDefs) continue;
                this.collectElementsInFileAfterIncremental(parserPath, defElement.fChildrenDefs, visited, false, isInIncludedFile, rootParserPath);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void collectElementsInFileBeforeIncremental(RfDefElement defElement) {
        try {
            if (defElement == null) {
                return;
            }
            List<RfNamedElement> namedElements = defElement.getNamedElements();
            if (namedElements == null || namedElements.isEmpty()) {
                return;
            }
            this.defElementsBeforeIncremental.add(defElement);
            for (RfNamedElement namedElement : namedElements) {
                if (namedElement == null) continue;
                if (!namedElement.isAnonymous() && !(namedElement instanceof RfFunctionCall)) {
                    this.elementsBeforeIncremental.add(namedElement);
                }
                if (!(namedElement instanceof RfGenerateBlock)) continue;
                this.elementsUnderGeneratesBeforeIncremental.put(namedElement.getName(), namedElement);
                this.collectRecursiveGenerateMembers(this.elementsUnderGeneratesBeforeIncremental, namedElement);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void addChangedParserPath(ParserPath parserPath, boolean isInInclude) {
        if (parserPath == null) {
            return;
        }
        this.parserPaths.add(new ParserPathWrapper(parserPath, isInInclude));
    }

    public int getDeltaSize() {
        if (this.delta == null) {
            return 0;
        }
        int count = 0;
        for (Set<IRfNamedElement> values : this.delta.values()) {
            count += values.size();
        }
        return count;
    }

    public void changedClassParent(RfClass classParent) {
        if (this.classesWithChangedParent != null && classParent != null) {
            this.classesWithChangedParent.add(classParent);
        }
    }

    public boolean hasConfigChanges() {
        if (this.firstLevelElements == null || this.firstLevelElements.isEmpty()) {
            return false;
        }
        for (Collection<RfNamedElement> elements : this.firstLevelElements.values()) {
            if (elements == null || elements.isEmpty()) continue;
            for (RfNamedElement element : elements) {
                if (!(element instanceof RfConfiguration)) continue;
                return true;
            }
        }
        return false;
    }

    public void collectDeltaInstances(List<IRfInstanceElement> collected) {
        if (collected == null) {
            return;
        }
        Set uniqueChanged = Collections.newSetFromMap(new IdentityHashMap());
        if (this.delta != null) {
            for (Set set : this.delta.values()) {
                if (set == null || set.isEmpty()) continue;
                for (IRfNamedElement changedElement : set) {
                    if (!(changedElement instanceof IRfInstanceElement)) continue;
                    uniqueChanged.add((IRfInstanceElement)changedElement);
                }
            }
        }
        if (this.changedBinds != null) {
            for (RfInstance rfInstance : this.changedBinds) {
                uniqueChanged.add(rfInstance);
            }
        }
        if (!uniqueChanged.isEmpty()) {
            collected.addAll(uniqueChanged);
        }
    }

    public void collectChangedPackages(List<IRfPackageElement> collected) {
        if (collected == null) {
            return;
        }
        Set uniqueChanged = Collections.newSetFromMap(new IdentityHashMap());
        if (this.addedImportInfos != null && !this.addedImportInfos.isEmpty()) {
            for (ImportInfo importInfo : this.addedImportInfos) {
                if (importInfo.getPackage() == null) continue;
                uniqueChanged.add(importInfo.getPackage());
            }
        }
        boolean analyzeCurrentFileScopes = false;
        if (this.firstLevelElements != null && !this.firstLevelElements.isEmpty()) {
            for (Map.Entry entry : this.firstLevelElements.entrySet()) {
                Collection firstLevelElements = (Collection)entry.getValue();
                if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
                for (RfNamedElement firstLevelElement : firstLevelElements) {
                    if (firstLevelElement instanceof IRfPackageElement) {
                        uniqueChanged.add((IRfPackageElement)firstLevelElement);
                        continue;
                    }
                    if ((!(firstLevelElement instanceof RfStruct) || !((RfStruct)firstLevelElement).isEnum()) && !ELUtils.isVLOGConstant((IRfNamedElement)firstLevelElement)) continue;
                    analyzeCurrentFileScopes = true;
                }
            }
        }
        if (analyzeCurrentFileScopes && this.currentFileScopes != null && !this.currentFileScopes.isEmpty()) {
            for (RfNamedElement rfNamedElement : this.currentFileScopes) {
                if (!(rfNamedElement instanceof IRfPackageElement)) continue;
                uniqueChanged.add((IRfPackageElement)rfNamedElement);
            }
        }
        if (this.delta != null) {
            for (Set set : this.delta.values()) {
                if (set == null || set.isEmpty()) continue;
                for (IRfNamedElement changedElement : set) {
                    if (!(changedElement instanceof IRfPackageElement)) continue;
                    uniqueChanged.add((IRfPackageElement)changedElement);
                }
            }
        }
        if (!uniqueChanged.isEmpty()) {
            collected.addAll(uniqueChanged);
        }
    }

    public void collectChangedNonDesignElements(Set<IRfNamedElement> collected) {
        if (collected == null) {
            return;
        }
        Set uniqueChanged = Collections.newSetFromMap(new IdentityHashMap());
        if (this.firstLevelElements == null || this.firstLevelElements.isEmpty()) {
            return;
        }
        for (Map.Entry<ParserPath, Collection<RfNamedElement>> firstLevelElementsEntrySet : this.firstLevelElements.entrySet()) {
            Collection<RfNamedElement> firstLevelElements = firstLevelElementsEntrySet.getValue();
            if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
            for (RfNamedElement firstLevelElement : firstLevelElements) {
                if (firstLevelElement instanceof IRfDesignElement || firstLevelElement instanceof IRfPackageElement) continue;
                uniqueChanged.add(firstLevelElement);
            }
        }
        if (!uniqueChanged.isEmpty()) {
            collected.addAll(uniqueChanged);
        }
    }

    public void collectDeltaDesigns(List<IRfDesignElement> collected) {
        if (collected == null) {
            return;
        }
        Set uniqueChanged = Collections.newSetFromMap(new IdentityHashMap());
        if (this.firstLevelElements != null) {
            for (Map.Entry entry : this.firstLevelElements.entrySet()) {
                Collection changedElements = (Collection)entry.getValue();
                if (changedElements == null) continue;
                for (RfNamedElement changedElement : changedElements) {
                    IRfNamedElement enclosingDesign;
                    if (changedElement instanceof IRfDesignElement) {
                        uniqueChanged.add((IRfDesignElement)changedElement);
                        continue;
                    }
                    if (!(changedElement instanceof IRfInstanceElement) || !((enclosingDesign = changedElement.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN)) instanceof IRfDesignElement)) continue;
                    uniqueChanged.add((IRfDesignElement)enclosingDesign);
                }
            }
        }
        if (this.delta != null) {
            for (Set set : this.delta.values()) {
                if (set == null || set.isEmpty()) continue;
                for (IRfNamedElement changedElement : set) {
                    if (!(changedElement instanceof IRfDesignElement)) continue;
                    uniqueChanged.add((IRfDesignElement)changedElement);
                }
            }
        }
        if (!uniqueChanged.isEmpty()) {
            collected.addAll(uniqueChanged);
        }
    }

    public boolean hasRemovedDescriptions() {
        Set<RfNamedElement> removedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
        removedElements.addAll(this.elementsBeforeIncremental);
        removedElements.removeAll(this.elementsAfterIncremental);
        for (RfNamedElement added : removedElements) {
            if (!(added instanceof IRfInstanceElement)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStructuralDesignChanges() {
        if (this.hasUpdatedGenerateBlocks()) {
            return true;
        }
        if (this.hasConfigChanges()) {
            return true;
        }
        for (RfNamedElement namedElement : this.changedDataTypeElements) {
            if (!(namedElement instanceof RfInstance)) continue;
            return true;
        }
        Set<RfNamedElement> addedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsAfterIncremental.size())));
        addedElements.addAll(this.elementsAfterIncremental);
        for (RfNamedElement namedElement : this.elementsBeforeIncremental) {
            if (namedElement instanceof IRfInstanceElement && ((IRfInstanceElement)namedElement).isInstanceToBind()) {
                return true;
            }
            if (namedElement instanceof RfConfiguration) continue;
            addedElements.remove(namedElement);
        }
        Set<RfNamedElement> removedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
        removedElements.addAll(this.elementsBeforeIncremental);
        removedElements.removeAll(this.elementsAfterIncremental);
        for (RfNamedElement added : addedElements) {
            if (!(added instanceof IRfInstanceElement) && !(added instanceof IRfDesignElement) && !(added instanceof IRfConfiguration)) continue;
            return true;
        }
        for (RfNamedElement removed : removedElements) {
            if (!(removed instanceof IRfInstanceElement) && !(removed instanceof IRfDesignElement) && !(removed instanceof IRfConfiguration)) continue;
            return true;
        }
        return false;
    }

    public void addChangedMacro(String changedMacro) {
        this.changedMacros.add(changedMacro);
    }

    public void removeChangedMacro(String changedMacro) {
        this.changedMacros.remove(changedMacro);
    }

    @NotNull
    public Set<ParserPath> getParserPaths() {
        HashSet<ParserPath> changedParserPaths = new HashSet<ParserPath>();
        for (ParserPathWrapper parserPathWrapper : this.parserPaths) {
            changedParserPaths.add(parserPathWrapper.getParserPath());
        }
        return changedParserPaths;
    }

    public Set<DeltaFileWrapper> getDeltaFilesParserPath(boolean includeCurrentFileScopes) {
        Set<DeltaFileWrapper> deltaFilesParserPaths = this.getParserPaths().stream().map(path -> new DeltaFileWrapper(path, DeltaFileKind.CHANGED)).collect(Collectors.toSet());
        HashSet<RfNamedElement> namedElements = new HashSet<RfNamedElement>();
        if (this.delta != null && !this.delta.isEmpty()) {
            for (Set set : this.delta.values()) {
                if (set == null || set.isEmpty()) continue;
                namedElements.addAll(set);
            }
        }
        if (includeCurrentFileScopes && this.currentFileScopes != null) {
            namedElements.addAll(this.currentFileScopes);
        }
        for (IRfNamedElement iRfNamedElement : namedElements) {
            ParserPath parserPath;
            IRfDefElement declaration;
            if (iRfNamedElement == null || iRfNamedElement.hasNoDefs(false) || (declaration = iRfNamedElement.getDeclaration()) == null || (parserPath = declaration.getParserPath()) == null) continue;
            deltaFilesParserPaths.add(new DeltaFileWrapper(parserPath, DeltaFileKind.DELTA));
        }
        return deltaFilesParserPaths;
    }

    public void restoreDefElementsOnCancelIncremental(RfProject rfProject, ParserPath parserPath) {
        this.changedTypeNames.clear();
        RfFileDef currentFileDef = this.getFileDef(parserPath, rfProject);
        if (currentFileDef == null) {
            return;
        }
        try {
            currentFileDef.cleanChildren(null, parserPath);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        try {
            for (RfDefElement defElement : this.defElementsBeforeIncremental) {
                RfNamedElement namedElement = defElement.getNamedElement();
                if (namedElement == null) continue;
                currentFileDef.addChildDef(defElement);
                namedElement.addDeclaration(defElement);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        DVTLogger.INSTANCE.logDebug("DEBUG VLOG: Restored defs on incremental canceled/interrupted build!");
    }

    public void clearDefElementsBeforeIncremental() {
        this.defElementsBeforeIncremental.clear();
    }

    public Set<ImportInfo> getAddedImportInfos() {
        return this.addedImportInfos;
    }

    public Set<String> getChangedMacros() {
        return this.changedMacros;
    }

    private static class ParserPathWrapper {
        private ParserPath parserPath;
        private boolean isInInclude;

        public ParserPathWrapper(ParserPath parserPath, boolean isInInclude) {
            this.parserPath = parserPath;
            this.isInInclude = isInInclude;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }

        public boolean isInInclude() {
            return this.isInInclude;
        }

        public int hashCode() {
            return Objects.hash(this.isInInclude, this.parserPath);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParserPathWrapper other = (ParserPathWrapper)obj;
            return this.isInInclude == other.isInInclude && Objects.equals(this.parserPath, other.parserPath);
        }
    }
}

