/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;
import ro.amiq.dvt.utils.DVTStringUtil;

public class LightToken
implements Serializable {
    int lineColumn;
    String text;

    public static LightToken create(int type, String text) {
        if (type == 542) {
            return new IdLightToken(text);
        }
        if (type == 108 || type == 223) {
            return new FunctionLightToken(text);
        }
        if (type == 81 || type == 93) {
            return new EndFunctionLightToken(text);
        }
        if (type == 99) {
            return new ExternLightToken(text);
        }
        if (type == 260) {
            return new WithLightToken(text);
        }
        return new LightToken(text);
    }

    protected LightToken(String text) {
        this.setText(text);
    }

    public int getType() {
        return 0;
    }

    public int getLine() {
        return this.lineColumn >> 12;
    }

    public void setLine(int line) {
        this.lineColumn &= 0xFFF;
        this.lineColumn |= line << 12;
    }

    public int getColumn() {
        return this.lineColumn & 0xFFF;
    }

    public void setColumn(int column) {
        this.lineColumn &= 0x7FFFF000;
        this.lineColumn |= column;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = DVTStringUtil.intern((String)text);
    }

    static class EndFunctionLightToken
    extends LightToken {
        public EndFunctionLightToken(String text) {
            super(text);
        }

        @Override
        public int getType() {
            return 81;
        }
    }

    static class ExternLightToken
    extends LightToken {
        public ExternLightToken(String text) {
            super(text);
        }

        @Override
        public int getType() {
            return 99;
        }
    }

    static class FunctionLightToken
    extends LightToken {
        public FunctionLightToken(String text) {
            super(text);
        }

        @Override
        public int getType() {
            return 108;
        }
    }

    static class IdLightToken
    extends LightToken {
        public IdLightToken(String text) {
            super(text);
        }

        @Override
        public int getType() {
            return 542;
        }
    }

    static class WithLightToken
    extends LightToken {
        public WithLightToken(String text) {
            super(text);
        }

        @Override
        public int getType() {
            return 260;
        }
    }
}

