/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.model.reflection.LightToken;

public class LightTokenList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<LightToken> list = new ArrayList(0);
    private byte[] serialized;

    public void clean() {
        if (this.list != null) {
            this.list.clear();
        }
        this.list = null;
        this.serialized = null;
    }

    public void add(LightToken token) {
        if (this.list == null) {
            this.deserialize();
        }
        this.list.add(token);
    }

    public List<LightToken> getList() {
        if (this.list == null) {
            this.deserialize();
        }
        return this.list;
    }

    public void serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new DeflaterOutputStream(baos)));){
                oos.writeObject(this.list);
                oos.flush();
                oos.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.serialized = baos.toByteArray();
        this.list = null;
    }

    public void deserialize() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.serialized);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new InflaterInputStream(bais)));){
                this.list = (ArrayList)ois.readObject();
                ois.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.serialized = null;
        if (this.list == null) {
            this.list = new ArrayList(0);
        }
    }
}

