/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Iterator;
import java.util.List;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public abstract class RfAbstractBlock
extends RfMembersHolder {
    private static final long serialVersionUID = 2L;
    protected long blockQualifiers;
    protected String expression;
    private transient IHid genvarHid;

    protected RfAbstractBlock(String name, boolean escaped, long qualifiers, String expression) {
        super(name, escaped);
        this.blockQualifiers = qualifiers;
        this.expression = expression;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.genvarHid = null;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.action";
    }

    public boolean hasBlockQualifier(IRfActionBlockElement.BlockQualifier qualifier) {
        if (qualifier == null) {
            return this.blockQualifiers == 0L;
        }
        return (this.blockQualifiers & qualifier.value()) != 0L;
    }

    public boolean hasBlockQualifier(long qualifiers) {
        if (qualifiers == 0L) {
            return this.blockQualifiers == 0L;
        }
        return (this.blockQualifiers & qualifiers) != 0L;
    }

    public void addBlockQualifier(long qualifiers) {
        this.blockQualifiers |= qualifiers;
    }

    public long getBlockQualifiers() {
        return this.blockQualifiers;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isFor() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOR.value()) != 0L;
    }

    public boolean isCase() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.CASE.value() + IRfActionBlockElement.BlockQualifier.CASEX.value() + IRfActionBlockElement.BlockQualifier.CASEZ.value() + IRfActionBlockElement.BlockQualifier.RANDCASE.value()) != 0L;
    }

    public boolean isRandCase() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.RANDCASE.value()) != 0L;
    }

    public boolean isCaseItem() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.CASE_ITEM.value() + IRfActionBlockElement.BlockQualifier.RANDCASE_ITEM.value()) != 0L;
    }

    public boolean isIf() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IF.value()) != 0L;
    }

    public boolean isElse() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ELSE.value()) != 0L;
    }

    public boolean isElsIf() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ELSIF.value()) != 0L;
    }

    public boolean isConditional() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IF.value() + IRfActionBlockElement.BlockQualifier.ELSE.value() + IRfActionBlockElement.BlockQualifier.ELSIF.value()) != 0L;
    }

    public boolean isConditionalWithExpression() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IF.value() + IRfActionBlockElement.BlockQualifier.ELSIF.value()) != 0L;
    }

    public boolean hasBeginEnd() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.BEGIN_END.value()) != 0L;
    }

    public boolean isSimpleBeginEnd() {
        return this.blockQualifiers - IRfActionBlockElement.BlockQualifier.BEGIN_END.value() == 0L;
    }

    public boolean isAnalog() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IS_ANALOG.value()) != 0L;
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        List<RfField> vars = super.getVarsWithPrefix(offset, prefix, matchType);
        Iterator<RfField> iterator = vars.iterator();
        while (iterator.hasNext()) {
            RfField variable = iterator.next();
            RfDefElement declaration = variable.getDeclaration();
            if (declaration != null && declaration.getStartOffset() <= offset) continue;
            iterator.remove();
        }
        vars.addAll(this.getEnclosingScope().getVarsWithPrefix(offset, prefix, matchType));
        return vars;
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        RfDefElement declaration;
        RfField variable = super.getVarWithPrefix(offset, prefix, matchType);
        if (variable != null && (declaration = variable.getDeclaration()) != null && declaration.getStartOffset() <= offset) {
            return variable;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getVarWithPrefix(offset, prefix, matchType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHid getGenvarHid() {
        if (!this.isFor()) {
            return null;
        }
        if (this.genvarHid != null) {
            return this.genvarHid;
        }
        RfAbstractBlock rfAbstractBlock = this;
        synchronized (rfAbstractBlock) {
            IHidObject lhValue;
            if (this.genvarHid != null) {
                return this.genvarHid;
            }
            final ELConstants.LoopGenerateIdentity identity = new ELConstants.LoopGenerateIdentity();
            RfHidHolder hidHolder = this.getHidHolder();
            if (hidHolder != null && !hidHolder.isHidObjectsEmpty()) {
                hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<IRfHidOperatorLayer>(){

                    public boolean visit(IRfHidOperatorLayer hidObject) {
                        if (hidObject.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER)) {
                            identity.genvarInit = hidObject;
                            return false;
                        }
                        return true;
                    }

                    public Class<IRfHidOperatorLayer> getType() {
                        return IRfHidOperatorLayer.class;
                    }
                });
            }
            if (identity.genvarInit instanceof RfHidOperator && (lhValue = ((RfHidOperator)identity.genvarInit).getLHValue()) instanceof IHid) {
                this.genvarHid = (IHid)lhValue;
                return this.genvarHid;
            }
        }
        return null;
    }
}

