/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RTLChecksUtil;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.trace.connections.model.TCLogic;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidExpressionBuilder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class RfActionBlock
extends RfAbstractBlock
implements IRfActionBlockElement {
    private static final long serialVersionUID = 4L;
    private int nofStatements;
    private boolean hasNamedChild;
    private boolean isAllSensitivityList;
    private static final long LOGIC_QUALIFIER = HidUtils.toQualifiersSet((HidOperatorQualifier[])DesignUtils.VLOG_ALWAYS_BLOCK_LOGIC);
    private static final HidOperatorQualifier[] IS_CONDITIONAL_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION};
    private static final HidOperatorQualifier[] IS_CASE_ITEM_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION};

    public RfActionBlock(String name, boolean escaped, long blockQualifiers, RfNamedElement enclosingScope, String expression, int uniquePriority, boolean isAllSensitivityList) {
        super(name, escaped, blockQualifiers, expression);
        this.setEnclosingScope(enclosingScope);
        this.setQualifiers(uniquePriority);
        this.isAllSensitivityList = isAllSensitivityList;
        this.nofStatements = 0;
        this.hasNamedChild = false;
    }

    public void init(long blockQualifiers, String expression, int qualifiers, boolean isAllSensitivityList) {
        this.setQualifiers(qualifiers);
        this.blockQualifiers = blockQualifiers;
        this.expression = expression;
        this.isAllSensitivityList = isAllSensitivityList;
        this.nofStatements = 0;
    }

    public void copyFrom(RfActionBlock oldBlock) {
        this.init(oldBlock.blockQualifiers, oldBlock.expression, oldBlock.getQualifiers(), oldBlock.isAllSensitivityList);
        this.updateHolder((IHidHolder)oldBlock.getHidHolder());
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        RfFileDef defFile = def.getDefFile();
        if (this.isAnonymous() && defFile != null) {
            ParserPath parserPath = defFile.getParserPath();
            LineInfo startInfo = new LineInfo(def.getStartLine(), def.getStartOffset(), -1);
            String actionBlockName = "@" + parserPath + '@' + startInfo;
            if (incrementalDeltaContainer != null && !actionBlockName.equals(this.getName())) {
                incrementalDeltaContainer.anonymousNewToOldNameMap.put(actionBlockName, this.getName());
            }
        }
        super.removeDef(incrementalDeltaContainer, def);
    }

    public void clean(RfDefElement def) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope != null) {
            enclosingScope.removeMember(this);
            Collection enclosingDefs = enclosingScope.getDeclarations();
            if (enclosingDefs != null && !enclosingDefs.isEmpty()) {
                for (RfDefElement enclosingDef : enclosingDefs) {
                    enclosingDef.removeChild(def);
                }
            }
        }
        this.setEnclosingScope(null);
        this.setHidHolder(null);
        this.removeDef(null, def);
        def.removeNamedElement(this);
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    protected void addMember(RfNamedElement element) {
        if (element instanceof RfNamedActionBlock || element instanceof RfAssertExpect && !element.isAnonymous()) {
            this.setHasNamedChild();
        }
        super.addMember(element);
    }

    private void setHasNamedChild() {
        this.hasNamedChild = true;
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfActionBlock && !((RfActionBlock)enclosingScope).hasNamedChild()) {
            ((RfActionBlock)enclosingScope).setHasNamedChild();
        }
    }

    @Override
    public void printScope(StringBuilder result, boolean appendThis) {
        RfNamedElement scope = this.getEnclosingScope();
        if (scope != null) {
            scope.printScope(result, true);
        }
    }

    public boolean hasNamedChild() {
        return this.hasNamedChild;
    }

    public boolean hasVarOrTypeDeclaration() {
        List<RfField> variableDeclarations = this.getLocalMembers(RfField.class);
        if (variableDeclarations != null && !variableDeclarations.isEmpty()) {
            return true;
        }
        List<RfTypeAlias> typeDeclarations = this.getLocalMembers(RfTypeAlias.class);
        return typeDeclarations != null && !typeDeclarations.isEmpty();
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return null;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.action";
    }

    public boolean isNamedBlock() {
        return false;
    }

    public List<RfField> getLocalVarsWithPrefix(int offset, String prefix, int matchType) {
        return super.getVarsWithPrefix(offset, prefix, matchType);
    }

    @Override
    public List<RfInterface> getInterfacesWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getInterfacesWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfModule> getModulesWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getModulesWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfProgram> getProgramsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getProgramsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getThisImplicitVariable(prefix, matchType);
    }

    @Override
    public RfSuperImplicitVariable getSuperImplicitVariable(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getSuperImplicitVariable(prefix, matchType);
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getArgumentsWithPrefix(prefix, matchType);
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getArgumentWithPrefix(prefix, matchType);
    }

    public int getNofStatements() {
        return this.nofStatements;
    }

    public IHidObject getConditionalBlockExpression() {
        if (!(this.isIf() || this.isElsIf() || this.isWhile())) {
            return null;
        }
        List<IHidOperator> hidOperators = this.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION}, true);
        if (hidOperators == null || hidOperators.isEmpty()) {
            return null;
        }
        if (!(hidOperators.get(0) instanceof RfHidOperator)) {
            return null;
        }
        IHidObject operator = ((RfHidOperator)hidOperators.get(0)).getLHValue();
        return operator;
    }

    public boolean hasBeginOrFork() {
        return this.hasBeginEnd() || this.hasForkJoin();
    }

    public boolean hasDefaultCaseItem() {
        if (!this.isCase()) {
            return false;
        }
        List<RfActionBlock> members = this.getLocalMembers(RfActionBlock.class);
        if (members == null || members.isEmpty()) {
            return false;
        }
        for (RfActionBlock member : members) {
            if (!member.isCaseItem() || !member.getExpression().equals("default")) continue;
            return true;
        }
        return false;
    }

    public boolean hasForkJoin() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FORK_JOIN.value() + IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY.value() + IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE.value()) != 0L;
    }

    public boolean isForkJoin() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FORK_JOIN.value()) != 0L;
    }

    public boolean isForkJoinAny() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY.value()) != 0L;
    }

    public boolean isForkJoinNone() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE.value()) != 0L;
    }

    public boolean isSimpleForkJoin() {
        return this.blockQualifiers - IRfActionBlockElement.BlockQualifier.FORK_JOIN.value() == 0L || this.blockQualifiers - IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY.value() == 0L || this.blockQualifiers - IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE.value() == 0L;
    }

    public boolean isProceduralBlock() {
        return this.isInitial() || this.isFinal() || this.isAlways();
    }

    public boolean isFinal() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FINAL.value()) != 0L;
    }

    public boolean isInitial() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.INITIAL.value()) != 0L;
    }

    public boolean isAlways() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ALWAYS.value() + IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value() + IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value() + IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value()) != 0L;
    }

    public boolean isAlwaysComb() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value()) != 0L;
    }

    public boolean isAlwaysFf() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value()) != 0L;
    }

    public boolean isAlwaysLatch() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value()) != 0L;
    }

    public boolean isEnhancedAlways() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value() + IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value() + IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value()) != 0L;
    }

    public boolean isForOrForeach() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOR.value() + IRfActionBlockElement.BlockQualifier.FOREACH.value()) != 0L;
    }

    public boolean isLoop() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOR.value() + IRfActionBlockElement.BlockQualifier.FOREACH.value() + IRfActionBlockElement.BlockQualifier.FOREVER.value() + IRfActionBlockElement.BlockQualifier.WHILE.value() + IRfActionBlockElement.BlockQualifier.REPEAT.value() + IRfActionBlockElement.BlockQualifier.DO.value()) != 0L;
    }

    public boolean isStatementLabel() {
        return this.isIfStatementLabel() || this.isLoopStatementLabel();
    }

    public boolean isIfStatementLabel() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.STATEMENT_LABEL_IF.value()) != 0L;
    }

    public boolean isLoopStatementLabel() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.STATEMENT_LABEL_LOOP.value()) != 0L;
    }

    public boolean isRandsequenceStatement() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.RANDSEQUENCE.value()) != 0L;
    }

    public boolean isCasex() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.CASEX.value()) != 0L;
    }

    public boolean isCasez() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.CASEZ.value()) != 0L;
    }

    public boolean isSimpleCase() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.CASE.value()) != 0L;
    }

    public boolean isWhile() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.WHILE.value()) != 0L;
    }

    public boolean isDoWhile() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.DO.value()) != 0L;
    }

    public boolean isForever() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOREVER.value()) != 0L;
    }

    public boolean isRepeat() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.REPEAT.value()) != 0L;
    }

    public boolean isForEach() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOREACH.value()) != 0L;
    }

    @Override
    public boolean isElsIf() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ELSIF.value()) != 0L;
    }

    public boolean isWith() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.WITH.value()) != 0L;
    }

    public boolean isSequential() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IS_SEQUENTIAL.value()) != 0L;
    }

    public boolean isCombinational() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IS_COMBINATIONAL.value()) != 0L;
    }

    public boolean isAllSensitivityList() {
        return this.isAllSensitivityList;
    }

    public List<IHidObject> computeConditionOperator(IHidEvaluator evaluator, final IHidEvaluationGuardian guardian) {
        if (this.isIf() || this.isElsIf() || this.isCase()) {
            List<IHidOperator> operators = this.getHidOperators(IS_CONDITIONAL_EXPRESSION, true);
            if (operators == null || operators.isEmpty()) {
                return null;
            }
            IHidOperator opi = operators.get(0);
            if (guardian != null) {
                guardian.markEvaluated(opi);
            }
            IHidObject lhValue = opi.getLHValue();
            return Collections.singletonList(lhValue);
        }
        if (this.isCaseItem()) {
            List<IHidOperator> operators = this.getHidOperators(IS_CASE_ITEM_EXPRESSION, true);
            if (operators == null || operators.isEmpty()) {
                return null;
            }
            IHidOperator opi = operators.get(0);
            if (guardian != null) {
                guardian.markEvaluated(opi);
            }
            return Collections.singletonList(opi.getFirstRHValue());
        }
        if (this.isLoop()) {
            final ArrayList<IHidObject> result = new ArrayList<IHidObject>(3);
            result.add(null);
            result.add(null);
            result.add(null);
            RfHidHolder hidHolder = this.getHidHolder();
            if (hidHolder == null) {
                return result;
            }
            hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<HidOperator>(){

                public boolean visit(HidOperator hidObject) {
                    if (!hidObject.isComplete()) {
                        return true;
                    }
                    if (hidObject.hasQualifier(HidQualifierCache.IS_LOOP_EXPRESSION_QUALIFIER)) {
                        if (guardian != null) {
                            guardian.markEvaluated((IHidOperator)hidObject);
                        }
                        IHidObject condition = hidObject.getLHValue();
                        result.set(1, condition);
                    } else if (hidObject.isForInit()) {
                        if (guardian != null) {
                            guardian.markEvaluated((IHidOperator)hidObject);
                        }
                        IHidObject existingForInit = (IHidObject)result.get(0);
                        IHidObject init = hidObject.getLHValue();
                        if (HidUtils.isOperator((IHidObject)init)) {
                            if (existingForInit == null) {
                                result.set(0, init);
                            } else if (existingForInit instanceof HidEvalCenter.SeqBlockStatement) {
                                ((HidEvalCenter.SeqBlockStatement)existingForInit).addRHValue(init, false);
                            } else {
                                HidOperator sequence = HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, -1, -1, -1, true, (ListContainer)existingForInit);
                                sequence.addRHValue(init, false);
                                result.set(0, sequence);
                            }
                        }
                    } else if (hidObject.isForStep()) {
                        if (guardian != null) {
                            guardian.markEvaluated((IHidOperator)hidObject);
                        }
                        IHidObject existingForStep = (IHidObject)result.get(2);
                        IHidObject step = hidObject.getLHValue();
                        if (HidUtils.isOperator((IHidObject)step)) {
                            if (existingForStep == null) {
                                result.set(2, step);
                            } else if (existingForStep instanceof HidEvalCenter.SeqBlockStatement) {
                                ((HidEvalCenter.SeqBlockStatement)existingForStep).addRHValue(step, false);
                            } else {
                                HidOperator sequence = HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, -1, -1, -1, true, (ListContainer)existingForStep);
                                sequence.addRHValue(step, false);
                                result.set(2, sequence);
                            }
                        }
                    }
                    return true;
                }

                public Class<HidOperator> getType() {
                    return HidOperator.class;
                }
            });
            return result;
        }
        return null;
    }

    private IHidObject computeRandcaseSumOperator() {
        if (!this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.RANDCASE)) {
            return null;
        }
        List<RfActionBlock> localMembers = this.getLocalMembers(RfActionBlock.class);
        if (localMembers == null || localMembers.isEmpty()) {
            return null;
        }
        ArrayList<IHidOperator> collected = new ArrayList<IHidOperator>(localMembers.size());
        for (RfActionBlock member : localMembers) {
            List<IHidOperator> operators;
            if (!member.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.RANDCASE_ITEM) || (operators = member.getHidOperators(IS_CASE_ITEM_EXPRESSION, true)) == null || operators.isEmpty()) continue;
            collected.add(operators.get(0));
        }
        if (collected.isEmpty()) {
            return null;
        }
        IHidOperator prevItemExpr = (IHidOperator)collected.get(0);
        if (collected.size() == 1) {
            return prevItemExpr.getFirstRHValue();
        }
        HidOperatorOccurrence occurrence = prevItemExpr.getOccurrence();
        Object result = prevItemExpr.getFirstRHValue();
        int i = 1;
        while (i < collected.size()) {
            IHidOperator nextItemExpr = (IHidOperator)collected.get(i);
            result = STransformer.makeStandInOperator(result, Collections.singleton(nextItemExpr.getFirstRHValue()), 465, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "+", occurrence, 0L);
            ++i;
        }
        return result;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_NAMED_BLOCK: Duplicate named block ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    public void setNofStatements(int nofStatements) {
        this.nofStatements = nofStatements;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ALWAYS);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.expression = null;
        this.blockQualifiers = 0L;
        this.hasNamedChild = false;
        this.isAllSensitivityList = false;
    }

    @Override
    protected void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean ignoreDirty, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        IHid entry;
        super.resolveHids(configInfo, triggerError, ignoreDirty, semanticEnabled, skipMemberClasses);
        LibraryPackageScope libraryPackageScope = this.getLibPkgScope();
        this.checkCheckerInstances(configInfo, libraryPackageScope);
        if (!triggerError || configInfo.disableRTLChecks) {
            this.setCombinationalOrSequentialQualifier();
            return;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfActionBlock) {
            return;
        }
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        if (this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value())) {
            this.addBlockQualifier(IRfActionBlockElement.BlockQualifier.IS_COMBINATIONAL.value());
            this.visitHidObject(null, new AlwaysBlockVisitor(rfProject, libraryPackageScope, false, this));
            return;
        }
        if (this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value())) {
            this.addBlockQualifier(IRfActionBlockElement.BlockQualifier.IS_SEQUENTIAL.value());
            this.visitHidObject(null, new AlwaysBlockVisitor(rfProject, libraryPackageScope, true, this));
            return;
        }
        if (this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value())) {
            this.addBlockQualifier(IRfActionBlockElement.BlockQualifier.IS_SEQUENTIAL.value());
            this.visitHidObject(null, new AlwaysBlockVisitor(rfProject, libraryPackageScope, true, this));
            return;
        }
        if (this.isInitial() || this.isFinal()) {
            this.visitHidObject(null, new BlockingNonBlockingBaseVisitor(rfProject, libraryPackageScope));
            return;
        }
        if (!this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS.value())) {
            return;
        }
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return;
        }
        ParserPath parserPath = declaration.getParserPath();
        if (parserPath == null) {
            return;
        }
        Set<IRfNamedElement> loopIndexVariables = Collections.newSetFromMap(new IdentityHashMap(2));
        boolean[] isSequential = new boolean[]{true};
        boolean[] isSensitiveAll = new boolean[]{true};
        ArrayList<IHid> insensitiveList = new ArrayList<IHid>();
        Collection<IHid> drivers = this.getProcessDrivers(isSensitiveAll, isSequential, true, insensitiveList, loopIndexVariables);
        this.addBlockQualifier(isSequential[0] ? IRfActionBlockElement.BlockQualifier.IS_SEQUENTIAL.value() : IRfActionBlockElement.BlockQualifier.IS_COMBINATIONAL.value());
        this.visitHidObject(null, new AlwaysBlockVisitor(rfProject, libraryPackageScope, isSequential[0], this));
        if (isSequential[0] || isSensitiveAll[0]) {
            return;
        }
        if (this.isAllSensitivityList) {
            Collection<IHid> wildcardDrivers = drivers;
            Iterator<IHid> iterator = wildcardDrivers.iterator();
            block0: while (iterator.hasNext()) {
                IHid entry2 = iterator.next();
                for (IHid insensitiveHid : insensitiveList) {
                    if (!(insensitiveHid instanceof RfHid) || !(entry2 instanceof RfHid) || !entry2.equals(insensitiveHid)) continue;
                    HidAccess insensitiveHidAccess = ((RfHid)insensitiveHid).getFirstAccess();
                    HidAccess driverHidAccess = ((RfHid)entry2).getFirstAccess();
                    if (insensitiveHidAccess == null || insensitiveHidAccess.isRangeSelect()) {
                        iterator.remove();
                        continue block0;
                    }
                    if (insensitiveHidAccess == null || !insensitiveHidAccess.checkEquals((Object)driverHidAccess)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            if (wildcardDrivers.isEmpty()) {
                int line = declaration.getStartLine();
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                rfProject.addSemanticError(2, "SENSITIVITY_NONE: The process is never evaluated (sensitive to nothing)", libraryPackageScope, -1, -1, attributes, line, declaration.getParserPath(), new Object[0]);
            }
            return;
        }
        ArrayList sensitivitySelectsList = new ArrayList();
        LinkedHashMap sensitivityList = new LinkedHashMap();
        DesignUtils.getVLOGSensitivityListDrivers((IRfNamedElement)this, sensitivityList, sensitivitySelectsList, (boolean)true);
        ArrayList superfluousDriversCombined = new ArrayList(sensitivityList.values());
        superfluousDriversCombined.addAll(sensitivitySelectsList);
        Collection<IHid> missingDrivers = drivers;
        Iterator<IHid> iterator = missingDrivers.iterator();
        block2: while (iterator.hasNext()) {
            Hid parentHid;
            entry = iterator.next();
            HidAccess access = ((RfHid)entry).getFirstAccess();
            if (sensitivityList.containsKey(entry.getName())) {
                iterator.remove();
                Iterator superfluousIterator = superfluousDriversCombined.iterator();
                while (superfluousIterator.hasNext()) {
                    IHidObject hidObject = (IHidObject)superfluousIterator.next();
                    if (hidObject.checkEquals((Object)access) || hidObject.checkEquals((Object)entry)) {
                        superfluousIterator.remove();
                        continue;
                    }
                    if (access == null || !(hidObject instanceof HidAccess) || !entry.checkEquals((Object)(parentHid = ((HidAccess)hidObject).getParentHid()))) continue;
                    superfluousIterator.remove();
                }
                continue;
            }
            if (access != null && access.isBitSelect() && !sensitivitySelectsList.isEmpty()) {
                for (HidAccess sensitivity : sensitivitySelectsList) {
                    if (!sensitivity.checkEquals((Object)access)) continue;
                    iterator.remove();
                    Iterator superfluousIterator = superfluousDriversCombined.iterator();
                    while (superfluousIterator.hasNext()) {
                        IHidObject hidObject = (IHidObject)superfluousIterator.next();
                        if (!(hidObject instanceof HidAccess) || !((HidAccess)hidObject).checkEquals((Object)access)) continue;
                        superfluousIterator.remove();
                    }
                    continue block2;
                }
                continue;
            }
            for (HidAccess sensitivity : sensitivitySelectsList) {
                parentHid = sensitivity.getParentHid();
                if (!entry.checkEquals((Object)parentHid)) continue;
                Iterator superfluousIterator = superfluousDriversCombined.iterator();
                while (superfluousIterator.hasNext()) {
                    IHidObject hidObject = (IHidObject)superfluousIterator.next();
                    if (!(hidObject instanceof HidAccess) || !((HidAccess)hidObject).checkEquals((Object)sensitivity)) continue;
                    superfluousIterator.remove();
                }
            }
        }
        iterator = missingDrivers.iterator();
        block8: while (iterator.hasNext()) {
            entry = iterator.next();
            for (IHid insensitiveHid : insensitiveList) {
                if (!(insensitiveHid instanceof RfHid) || !(entry instanceof RfHid) || !entry.equals(insensitiveHid)) continue;
                HidAccess insensitiveHidAccess = ((RfHid)insensitiveHid).getFirstAccess();
                HidAccess driverHidAccess = ((RfHid)entry).getFirstAccess();
                if (insensitiveHidAccess == null || insensitiveHidAccess.isRangeSelect()) {
                    iterator.remove();
                    continue block8;
                }
                if (insensitiveHidAccess == null || !insensitiveHidAccess.checkEquals((Object)driverHidAccess)) continue;
                iterator.remove();
                continue block8;
            }
        }
        if (!missingDrivers.isEmpty()) {
            for (IHid missingDriver : missingDrivers) {
                HidOccurrence occurrence;
                RfHid missingDriverHid;
                boolean isLoopIndexVariable;
                if (!(missingDriver instanceof RfHid) || (isLoopIndexVariable = (missingDriverHid = (RfHid)missingDriver).hasOccurrence(HidQualifierCache.LOOP_INDEX_VAR_QUALIFIER))) continue;
                IRfNamedElement missingDriverElement = missingDriverHid.getElement();
                if (!loopIndexVariables.isEmpty() && loopIndexVariables.contains(missingDriverElement) || (occurrence = missingDriverHid.getOccurrence()) == null) continue;
                RfHid nameHidObject = missingDriverHid.hasAccesses() && (missingDriverHid.getFirstAccess().isBitSelect() || missingDriverHid.getFirstAccess().isRangeSelect()) ? missingDriverHid.getFirstAccess() : missingDriverHid;
                int startOffset = occurrence.getOffset();
                String name = HidUtils.toNiceString((IHidObject)nameHidObject);
                int endOffset = startOffset + name.length();
                int line = occurrence.getLine();
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", name);
                attributes.put("QUICKFIX_KIND", 2);
                rfProject.addSemanticError(2, "SENSITIVITY_MISSING: Missing ''{0}'' from sensitivity list", libraryPackageScope, startOffset, endOffset, attributes, line, declaration.getParserPath(), name);
            }
        }
        if (!superfluousDriversCombined.isEmpty()) {
            for (IHidObject superfuousDriver : superfluousDriversCombined) {
                HidOccurrence occurrence;
                IHid hid;
                Object object = hid = superfuousDriver instanceof HidAccess ? ((HidAccess)superfuousDriver).getParentHid() : (IHid)superfuousDriver;
                if (hid == null || (occurrence = hid.getOccurrence()) == null) continue;
                Object nameHidObject = superfuousDriver instanceof HidAccess && (((HidAccess)superfuousDriver).isBitSelect() || ((HidAccess)superfuousDriver).isRangeSelect()) ? superfuousDriver : hid;
                int startOffset = occurrence.getOffset();
                String name = HidUtils.toNiceString((IHidObject)nameHidObject);
                int endOffset = startOffset + name.length();
                int line = occurrence.getLine();
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", name);
                attributes.put("QUICKFIX_KIND", 3);
                rfProject.addSemanticError(2, "SENSITIVITY_UNUSED: The process is not sensitive to ''{0}''", libraryPackageScope, startOffset, endOffset, attributes, line, declaration.getParserPath(), name);
            }
        }
    }

    private void setCombinationalOrSequentialQualifier() {
        if (this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value())) {
            this.addBlockQualifier(IRfActionBlockElement.BlockQualifier.IS_COMBINATIONAL.value());
            return;
        }
        if (this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value())) {
            this.addBlockQualifier(IRfActionBlockElement.BlockQualifier.IS_SEQUENTIAL.value());
            return;
        }
        if (this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value())) {
            this.addBlockQualifier(IRfActionBlockElement.BlockQualifier.IS_SEQUENTIAL.value());
            return;
        }
        if (!this.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS.value())) {
            return;
        }
        boolean[] isSequential = new boolean[]{true};
        boolean[] isSensitiveAll = new boolean[]{true};
        this.getProcessDrivers(isSensitiveAll, isSequential, false, new ArrayList<IHid>(), Collections.newSetFromMap(new IdentityHashMap(2)));
        this.addBlockQualifier(isSequential[0] ? IRfActionBlockElement.BlockQualifier.IS_SEQUENTIAL.value() : IRfActionBlockElement.BlockQualifier.IS_COMBINATIONAL.value());
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        RfNamedElement enclosingScope;
        if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options) && (enclosingScope = this.getEnclosingScope()) != null && !(enclosingScope instanceof RfProject)) {
            enclosingScope.getQualifiedName(result, typesResolver, scope, options, this);
        }
        if (IRfNamedElement.QualifiedNameOptions.contains((int)8, (int)options) || this.isNamedBlock()) {
            result.append(this.getName()).append(previous == null ? "" : ".");
        }
    }

    public Collection<IHid> getProcessDrivers(final boolean[] isSensitiveAll, boolean[] isSequential, boolean getAllSelects, final Collection<IHid> insensitiveList, final Set<IRfNamedElement> loopIndexVariables) {
        TCLogic logic = getAllSelects ? new TCLogic(() -> new ArrayList()) : new TCLogic();
        Collection commonDrivers = logic.getCommonDrivers();
        final ArrayList seqOperators = new ArrayList();
        final ArrayList combOperators = new ArrayList();
        final BiConsumer<IRfNamedElement, Collection> argConsumer = (functionArgument, rhHids) -> {
            if (!(functionArgument instanceof IRfFieldElement) || rhHids == null || rhHids.isEmpty()) {
                return;
            }
            if (((IRfFieldElement)functionArgument).isOutput()) {
                return;
            }
            for (IHid rhHid : rhHids) {
                if (rhHid.getElement() instanceof IRfInstanceElement) continue;
                commonDrivers.add(rhHid);
            }
        };
        final HashMap writtenLoads = new HashMap();
        final HashMap readLoads = new HashMap();
        IHidVisitor<IHidObject> visitor = new IHidVisitor<IHidObject>(){
            private HidHolder holder;

            public void setHolder(IHidHolder holder) {
                this.holder = (HidHolder)holder;
            }

            public boolean visit(IHidObject hidObject) {
                if (HidUtils.isOperator((IHidObject)hidObject) && ((HidOperator)hidObject).hasOccurrence(LOGIC_QUALIFIER)) {
                    HidOperator operator = (HidOperator)hidObject;
                    if (operator.hasOccurrence(HidOperatorQualifier.IS_EVENT_CONTROL)) {
                        isSensitiveAll[0] = false;
                    }
                    if (operator.isWaitEventControl()) {
                        return true;
                    }
                    if (operator.isAssignment()) {
                        IHidObject lhValue = operator.getLHValue();
                        ListContainer rhValues = operator.getRHValues();
                        HidOperatorOccurrence occurrence = operator.getOccurrence();
                        if (occurrence != null) {
                            IRfNamedElement scope = this.holder.getScope();
                            if (rhValues != null && !rhValues.isEmpty()) {
                                for (IHidObject rhValue : rhValues) {
                                    int offset;
                                    Object hid;
                                    IRfNamedElement hidElement;
                                    if (!(rhValue instanceof IHid) && !(rhValue instanceof RfHidAccess) || (hidElement = (hid = rhValue instanceof IHid ? (IHid)rhValue : ((RfHidAccess)rhValue).getParentHid()).getElement()) == null || hidElement instanceof IRfInstanceElement || readLoads.containsKey(rhValue) && (offset = ((Integer)readLoads.get(rhValue)).intValue()) <= occurrence.getOffset()) continue;
                                    readLoads.put(rhValue, occurrence.getOffset());
                                    if (this.contains(writtenLoads, (IRfScopeElement)scope, rhValue, occurrence.getOffset())) {
                                        insensitiveList.add(hid);
                                        continue;
                                    }
                                    insensitiveList.remove(hid);
                                }
                            }
                            if (operator.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN) && (lhValue instanceof IHid || lhValue instanceof RfHidAccess)) {
                                HashMap<Object, Integer> variables;
                                IRfNamedElement lhElement;
                                IRfNamedElement iRfNamedElement = lhElement = lhValue instanceof IHid ? ((IHid)lhValue).getElement() : ((RfHidAccess)lhValue).getParentHid().getElement();
                                if (lhElement != null && scope instanceof RfActionBlock && ((RfActionBlock)scope).isFor() && loopIndexVariables != null && lhValue instanceof IHid && ((IHid)lhValue).hasOccurrence(HidQualifierCache.LOOP_INDEX_VAR_QUALIFIER)) {
                                    loopIndexVariables.add(lhElement);
                                }
                                if ((variables = (HashMap<Object, Integer>)writtenLoads.get(scope)) == null) {
                                    variables = new HashMap<Object, Integer>();
                                    writtenLoads.put(scope, variables);
                                }
                                if (lhValue instanceof HidAccess && ((HidAccess)lhValue).isRangeSelect()) {
                                    variables.put(((HidAccess)lhValue).getParentHid(), occurrence.getOffset());
                                } else {
                                    variables.put(lhValue, occurrence.getOffset());
                                }
                            }
                        }
                    }
                    LinkedHashSet hids = new LinkedHashSet();
                    DesignUtils.collectVLOGClockEventHids((IHidOperator)operator, hids, (boolean)true);
                    if (!hids.isEmpty()) {
                        seqOperators.add(operator);
                        return false;
                    }
                    combOperators.add(operator);
                } else if (HidUtils.isHid((IHidObject)hidObject)) {
                    Hid hid = (Hid)hidObject;
                    boolean isMethodCall = hid.isMethodCall(false);
                    if (isMethodCall |= hid.getElement() == null && hid instanceof RfHid && ((RfHid)hid).hasAccessArg()) {
                        MethodCallUtils.consumeMethodCallArguments((Hid)hid, (BiConsumer)argConsumer, (boolean)true);
                    }
                }
                return true;
            }

            private boolean contains(Map<IRfScopeElement, Map<IHidObject, Integer>> writtenLoads2, IRfScopeElement scope, IHidObject hidObject, int operatorOffset) {
                while (scope != null) {
                    int offset;
                    Hid parentHid;
                    int offset2;
                    Map<IHidObject, Integer> variables = writtenLoads2.get(scope);
                    if (variables == null) {
                        scope = scope.getEnclosingScope();
                        continue;
                    }
                    if (variables.containsKey(hidObject) && (offset2 = variables.get(hidObject).intValue()) <= operatorOffset) {
                        return true;
                    }
                    if (hidObject instanceof HidAccess && variables.containsKey(parentHid = ((HidAccess)hidObject).getParentHid()) && (offset = variables.get(parentHid).intValue()) <= operatorOffset) {
                        return true;
                    }
                    scope = scope.getEnclosingScope();
                }
                return false;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        };
        this.visitHidObject(null, visitor);
        boolean bl = isSequential[0] = combOperators.isEmpty() && commonDrivers.isEmpty();
        if (isSensitiveAll[0]) {
            return Collections.emptySet();
        }
        if (isSequential[0]) {
            return Collections.emptySet();
        }
        commonDrivers.addAll(DesignUtils.getVLOGClockEventHids(seqOperators, (boolean)false));
        for (IHidOperator operator : combOperators) {
            DesignUtils.collectConcurrentDriversAndLoads((IHidOperator)operator, (TCLogic)logic, (Set)DesignUtils.ASSIGN_HID_FLATTENING);
        }
        List mapProcessDrivers = DesignUtils.mapProcessDriversVLOG((IRfNamedElement)this, (TCLogic)logic, (boolean)false);
        for (IRfNamedElement loopIndexVariable : loopIndexVariables) {
            mapProcessDrivers.removeIf(element -> element.getName().equals(loopIndexVariable.getName()));
        }
        return mapProcessDrivers;
    }

    public IReparseInfo xGetReparseInfo() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getReparseInfo();
        }
        return null;
    }

    public HidOperator xCreateEventControlOperator(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        long qualifiers = HidOperatorQualifier.IS_EVENT_CONTROL.value() | HidOperatorQualifier.IS_OPERATOR_COMPLETE.value();
        RfDefElement declaration = this.getDeclaration();
        RfHidOperator operator = STransformer.makeStandInOperator((IHidObject)STransformer.makeStandInImplicit("*", 462), Collections.emptyList(), 496, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "@", new HidOperatorOccurrence(declaration.getStartOffset(), declaration.getStartVirtualOffset(), declaration.getStartLine(), qualifiers, null), 0L);
        return this.xTransformEdgeControlOperator(operator, true, evaluator, guardian);
    }

    public HidOperator xGetSnsvtEventControlOperator(HidOperator operator, boolean isSensitiveAllCheck, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        if (isSensitiveAllCheck && !XUtils.isSensitiveAllEdgeControl((IHidObject)operator)) {
            throw new UnsupportedOperationException();
        }
        return this.xTransformEdgeControlOperator(operator, false, evaluator, guardian);
    }

    private HidOperator xTransformEdgeControlOperator(HidOperator operator, boolean inlineFunctions, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        LinkedHashSet<IHidObject> drivers = new LinkedHashSet<IHidObject>();
        this.xCollectDrivers(Collections.newSetFromMap(new IdentityHashMap()), drivers, null, inlineFunctions, null, evaluator, guardian);
        RfHidOperator edgeOperator = RfHidOperator.create(operator.getOperatorType(), operator.getOperatorKind(), operator.getOperatorText(), operator.getOccurrence(), ((RfHidOperator)operator).getMacroZone());
        if (drivers == null || drivers.isEmpty()) {
            return edgeOperator;
        }
        if (drivers.size() == 1) {
            edgeOperator.addLHValue((IHidObject)drivers.iterator().next(), false);
            return edgeOperator;
        }
        RfHidOperator variadicOperator = STransformer.makeStandInOperator((IHidObject)STransformer.makeStandInImplicit(",", IHidImplicitConstants.ImplicitType.VARIADIC_LIMIT.id), drivers, 459, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, ",", operator.getOccurrence(), 0L);
        edgeOperator.addLHValue((IHidObject)variadicOperator, false);
        return edgeOperator;
    }

    static class AlwaysBlockVisitor
    extends BlockingNonBlockingBaseVisitor {
        private boolean isSequentiaBlock;
        private RfActionBlock rfActionBlock;

        public AlwaysBlockVisitor(RfProject rfProject, LibraryPackageScope libraryPackageScope, boolean isSequentiaBlock, RfActionBlock rfActionBlock) {
            super(rfProject, libraryPackageScope);
            this.isSequentiaBlock = isSequentiaBlock;
            this.rfActionBlock = rfActionBlock;
        }

        @Override
        public boolean visit(RfHidOperator operator) {
            HidOperatorOccurrence occurrence;
            if (!operator.isComplete()) {
                return true;
            }
            boolean isNonBlocking = operator.hasOccurrence(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN);
            boolean isBlocking = operator.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN);
            if (!isNonBlocking && !isBlocking) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            if (this.checkIllegalNetAssignment(lhValue, occurrence = operator.getOccurrence())) {
                return true;
            }
            if (!this.isSequentiaBlock && isBlocking) {
                return true;
            }
            String name = null;
            boolean isLocalVariable = false;
            if (lhValue instanceof RfHid) {
                RfHid hid = (RfHid)lhValue;
                if (hid.hasQualifier(RfHidExpressionBuilder.LOOP_INDEX_VAR_QUALIFIER)) {
                    return true;
                }
                isLocalVariable = this.isLocalVariable(lhValue);
                name = hid.getName();
            } else {
                name = lhValue instanceof RfHidOperator ? HidUtils.toNiceString((IHidObject)lhValue) : lhValue.toString();
            }
            if (this.isSequentiaBlock && (isBlocking && isLocalVariable || isNonBlocking && !isLocalVariable)) {
                return true;
            }
            int startOffset = occurrence.getOpenBoundaryOutsideMacro();
            int endOffset = occurrence.getCloseBoundaryOutsideMacro();
            if (this.isSequentiaBlock && isBlocking) {
                this.rfProject.addSemanticError(2, "ASSIGNMENT_BLOCKING: Blocking assignment of ''{0}'' in sequential logic (use non-blocking assignment)", this.libraryPackageScope, startOffset, endOffset, null, occurrence.getLine(), this.parserPath, name);
            } else if (!this.isSequentiaBlock && isNonBlocking) {
                this.rfProject.addSemanticError(2, "ASSIGNMENT_NON_BLOCKING: Non-blocking assignment of ''{0}'' in combinational logic (use blocking assignment)", this.libraryPackageScope, startOffset, endOffset, null, occurrence.getLine(), this.parserPath, name);
            } else if (this.isSequentiaBlock && isNonBlocking && isLocalVariable) {
                this.rfProject.addSemanticError(2, "ASSIGNMENT_NON_BLOCKING: Non-blocking assignment of local variable ''{0}'' (use blocking assignment)", this.libraryPackageScope, startOffset, endOffset, null, occurrence.getLine(), this.parserPath, name);
            }
            return true;
        }

        private boolean isLocalVariable(IHidObject lhValue) {
            if (((RfHid)lhValue).getElement() instanceof RfField) {
                RfNamedElement enclosing = (RfNamedElement)((RfHid)lhValue).getElement();
                do {
                    if (enclosing != this.rfActionBlock) continue;
                    return true;
                } while ((enclosing = enclosing.getEnclosingScope()) instanceof RfActionBlock);
            }
            return false;
        }
    }

    static class BlockingNonBlockingBaseVisitor
    implements IHidVisitor<RfHidOperator> {
        protected ParserPath parserPath;
        protected LibraryPackageScope libraryPackageScope;
        protected RfProject rfProject;

        public BlockingNonBlockingBaseVisitor(RfProject rfProject, LibraryPackageScope libraryPackageScope) {
            this.libraryPackageScope = libraryPackageScope;
            this.rfProject = rfProject;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator operator) {
            if (!operator.isComplete()) {
                return true;
            }
            boolean isNonBlocking = operator.hasOccurrence(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN);
            boolean isBlocking = operator.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN);
            if (!isNonBlocking && !isBlocking) {
                return true;
            }
            this.checkIllegalNetAssignment(operator.getLHValue(), operator.getOccurrence());
            return true;
        }

        protected boolean checkIllegalNetAssignment(IHidObject lhValue, HidOperatorOccurrence occurrence) {
            if (lhValue == null) {
                return true;
            }
            switch (lhValue.getHidKind()) {
                case HID: {
                    return this.internalCheckIllegalNetAssignment((IHid)((Hid)lhValue), occurrence);
                }
                case ACCESS: {
                    return this.internalCheckIllegalNetAssignment((IHid)((HidAccess)lhValue).getParentHid(), occurrence);
                }
                case OPERATOR: {
                    boolean isIllegal = false;
                    Set valueHids = HidUtils.flattenToHids((IHidObject)lhValue, (Set)RTLChecksUtil.PROCESS_HID_FLATTENING);
                    for (IHid iHid : valueHids) {
                        isIllegal |= this.internalCheckIllegalNetAssignment(iHid, occurrence);
                    }
                    return isIllegal;
                }
            }
            return false;
        }

        private boolean internalCheckIllegalNetAssignment(IHid hid, HidOperatorOccurrence occurrence) {
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfField) || !((RfField)element).isNet()) {
                return false;
            }
            int startOffset = occurrence.getOpenBoundaryOutsideMacro();
            int endOffset = occurrence.getCloseBoundaryOutsideMacro();
            this.rfProject.addSemanticError(1, "ILLEGAL_NET_ASSIGNMENT: Cannot use net ''{0}'' as left hand side in procedural assignment", this.libraryPackageScope, startOffset, endOffset, null, occurrence.getLine(), this.parserPath, hid.getName());
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

