/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.parser.MacroCallInfo;

public class RfAssertExpect
extends RfMembersHolder
implements IRfAssertExpectElement {
    private static final long serialVersionUID = 2L;
    public static final int IMMEDIATE_ASSERT = 0;
    public static final int EXPECT = 1;
    public static final int CONCURRENT_ASSERT = 2;
    public static final int IMMEDIATE_ASSUME = 3;
    public static final int CONCURRENT_ASSUME = 4;
    public static final int IMMEDIATE_COVER = 5;
    public static final int CONCURRENT_COVER_PROPERTY = 6;
    public static final int CONCURRENT_COVER_SEQUENCE = 7;
    public static final int RESTRICT = 8;
    private short kind = 0;
    private IRfAssertExpectElement.AssertKind assertKind;
    private String disabledIffText;
    private IHidObject expression;
    private MacroCallInfo macroCallInfo;
    private static final HidOperatorQualifier[] CLOCKING_EVENT_QUALIFIER = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CLOCKING_EVENT};

    public RfAssertExpect(String name, boolean escaped, int kind, IRfAssertExpectElement.AssertKind assertKind, MacroCallInfo macroCallInfo) {
        super(name, escaped);
        this.kind = (short)kind;
        this.assertKind = assertKind;
        this.macroCallInfo = macroCallInfo;
        this.setAnonymous(name.length() > 1 && name.charAt(0) == '@');
    }

    public void init(int kind, IRfAssertExpectElement.AssertKind assertKind, MacroCallInfo macroCallInfo) {
        this.kind = (short)kind;
        this.assertKind = assertKind;
        this.macroCallInfo = macroCallInfo;
    }

    public IRfAssertExpectElement.AssertKind getAssertKind() {
        return this.assertKind;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        switch (this.kind) {
            case 0: 
            case 2: {
                return "assert " + this.getName();
            }
            case 3: 
            case 4: {
                return "assume " + this.getName();
            }
            case 5: 
            case 6: 
            case 7: {
                return "cover " + this.getName();
            }
            case 1: {
                return "expect " + this.getName();
            }
            case 8: {
                return "restrict " + this.getName();
            }
        }
        return this.getName();
    }

    @Override
    public void printScope(StringBuilder result, boolean appendThis) {
        RfNamedElement scope = this.getEnclosingScope();
        if (scope != null) {
            scope.printScope(result, true);
        }
        if (appendThis && !this.isAnonymous()) {
            result.append(this.getName()).append('.');
        }
    }

    public int getAssertType() {
        return this.kind;
    }

    public boolean isAssert() {
        return this.kind == 0 || this.kind == 2;
    }

    public boolean isExpect() {
        return this.kind == 1;
    }

    public boolean isDeferred() {
        return this.assertKind == IRfAssertExpectElement.AssertKind.DEFFERED_FINAL || this.assertKind == IRfAssertExpectElement.AssertKind.DEFFERED_POUND_0;
    }

    public boolean isImmediate() {
        return this.assertKind == IRfAssertExpectElement.AssertKind.IMMEDIATE;
    }

    public boolean isConcurrent() {
        return this.assertKind == IRfAssertExpectElement.AssertKind.PROPERTY;
    }

    public boolean isImmediateAssert() {
        return this.kind == 0;
    }

    public boolean isConcurrentAssert() {
        return this.kind == 2;
    }

    public boolean isAssume() {
        return this.kind == 3 || this.kind == 4;
    }

    public boolean isImmediateAssume() {
        return this.kind == 3;
    }

    public boolean isConcurrentAssume() {
        return this.kind == 4;
    }

    public boolean isCover() {
        return this.kind == 5 || this.kind == 6 || this.kind == 7;
    }

    public boolean isImmediateCover() {
        return this.kind == 5;
    }

    public boolean isConcurrentCover() {
        return this.kind == 6 || this.kind == 7;
    }

    public boolean isConcurrentCoverProperty() {
        return this.kind == 6;
    }

    public boolean isConcurrentCoverSequence() {
        return this.kind == 7;
    }

    public boolean isRestrict() {
        return this.kind == 8;
    }

    public boolean isConcurrentAssertionStatement() {
        return this.kind == 2 || this.kind == 4 || this.kind == 6 || this.kind == 7 || this.kind == 8;
    }

    public boolean hasDisabledIff() {
        return this.disabledIffText != null && !this.disabledIffText.isEmpty();
    }

    public String getExpressionText() {
        boolean hasDisableIffExpr;
        IHidObject candidate = this.expression;
        if (!HidUtils.isOperator((IHidObject)candidate) || !((IRfHidOperatorLayer)candidate).isPropertySpec()) {
            return this.internalGetExpressionText(candidate);
        }
        IHidOperator candidateOperator = (IHidOperator)candidate;
        boolean hasClockingEvent = candidateOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR;
        candidate = hasClockingEvent ? candidateOperator.getFirstRHValue() : candidateOperator.getLHValue();
        boolean bl = hasDisableIffExpr = this.hasDisabledIff() && HidUtils.isOperator((IHidObject)candidate) && ((IHidOperator)candidate).isDisableIffExpr();
        if (hasDisableIffExpr) {
            candidate = ((IHidOperator)candidate).getFirstRHValue();
        }
        return this.internalGetExpressionText(candidate);
    }

    private String internalGetExpressionText(IHidObject candidate) {
        return !this.hasDisabledIff() ? HidUtils.toNiceString((IHidObject)candidate) : "disable iff(" + this.disabledIffText + ")" + HidUtils.toNiceString((IHidObject)candidate);
    }

    public void setDisabledIffText(String disabledIffText) {
        this.disabledIffText = disabledIffText == null ? "" : disabledIffText;
    }

    public String getDisabledIffText() {
        return this.disabledIffText;
    }

    public void setExpression(IHidObject expression) {
        this.expression = expression;
    }

    public IHidObject getExpression() {
        return this.expression;
    }

    public List<IHidOperator> getClockingEvents() {
        return this.getHidOperators(CLOCKING_EVENT_QUALIFIER, true);
    }

    public MacroCallInfo getMacroCallInfo() {
        return this.macroCallInfo;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.expression = null;
        this.macroCallInfo = null;
    }

    @Override
    public Image getImage() {
        if (this.isAssert()) {
            if (this.isConcurrentAssertionStatement()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSERT_CONCURRENT);
            }
            if (this.isDeferred()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSERT_IMMEDIATE_DEFERRED);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSERT_IMMEDIATE);
        }
        if (this.isAssume()) {
            if (this.isConcurrentAssertionStatement()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSUME_CONCURRENT);
            }
            if (this.isDeferred()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSUME_IMMEDIATE_DEFERRED);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSUME_IMMEDIATE);
        }
        if (this.isCover()) {
            if (this.isConcurrentAssertionStatement()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVER_CONCURRENT);
            }
            if (this.isDeferred()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVER_IMMEDIATE_DEFERRED);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVER_IMMEDIATE);
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    public IHidObject xGetVlogAssertionCondition() {
        return this.expression;
    }

    public IReparseInfo xGetReparseInfo() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getReparseInfo();
        }
        return null;
    }

    public String getAssertionKindName() {
        if (this.isAssert()) {
            return "assert";
        }
        if (this.isAssume()) {
            return "assume";
        }
        if (this.isCover()) {
            return "cover";
        }
        return "<unknown>";
    }

    public boolean hasBlockQualifier(IRfActionBlockElement.BlockQualifier qualifier) {
        return false;
    }

    public boolean hasBlockQualifier(long qualifiers) {
        return false;
    }
}

