/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfAssociatedTypeWrapper
extends RfAssociatedType {
    private static final long serialVersionUID = 1L;
    private RfNamedElement origin;
    private boolean hasNewDataType;

    public RfAssociatedTypeWrapper(DataType dataType, RfNamedElement enclosingScope) {
        super(dataType.fType, dataType.fEscaped, dataType);
        this.hasNewDataType = false;
        this.setEnclosingScope(enclosingScope);
    }

    public RfAssociatedTypeWrapper(DataType dataType, RfNamedElement origin, RfNamedElement enclosingScope) {
        super(dataType.fType, dataType.fEscaped, dataType);
        this.origin = origin;
        this.hasNewDataType = false;
        this.setEnclosingScope(enclosingScope);
        this.setMacroZone(origin.getMacroZone());
    }

    public RfAssociatedTypeWrapper(RfAssociatedType origin, DataType newDataType) {
        this(newDataType, origin.getEnclosingScope());
        this.origin = origin;
        this.hasNewDataType = true;
        this.setName(origin.getName(), origin.isEscaped());
        this.setMacroZone(origin.getMacroZone());
    }

    public RfAssociatedTypeWrapper(RfAssociatedType origin) {
        this(origin, origin.getDataType());
        this.hasNewDataType = false;
    }

    public RfNamedElement getOrigin() {
        return this.origin;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "";
    }

    @Override
    public RfDefElement getDeclaration() {
        return (this.origin != null ? this.origin : this.getEnclosingScope()).getDeclaration();
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        return (this.origin != null ? this.origin : this.getEnclosingScope()).getDeclarations();
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        IRfNamedElement associatedType = super.getAssociatedType(typesResolver);
        if (this.origin instanceof RfField && ((RfField)this.origin).isTypeParameter() && ((RfField)this.origin).isEffectiveLocalParameter()) {
            ((RfField)this.origin).updateInitialValueParametricDependencyValue(this.getLastLevelDataType().getParametricDependencyValue());
        }
        return associatedType;
    }

    @Override
    protected String implicitTypeName() {
        return this.origin instanceof RfAssociatedType ? ((RfAssociatedType)this.origin).implicitTypeName() : null;
    }

    @Override
    public void internalSetTransientAssociatedType(IRfNamedElement associatedType) {
        if (!this.hasNewDataType && this.origin instanceof RfAssociatedType) {
            ((RfAssociatedType)this.origin).internalSetTransientAssociatedType(associatedType);
        }
    }
}

